--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Deallocation;
with Narval.Buffers;

package body Narval.Actors.Actives.Producers.Basic is

   use Log4ada.Loggers;

   procedure On_Stop (Object : access Basic_Producer_Type) is
   begin
      Producers.On_Stop (Producer_Access (Object));
      Info_Out (Object.Logger'Access,
                "nombre evenements produits :" &
                Object.Number_Of_Event_Produced'Img);
   end On_Stop;
   ----------------------------
   -- Travail_En_Acquisition --
   ----------------------------

   procedure Buffer_Handling
     (Object : access Basic_Producer_Type) is
      type Integer_Array is array (Positive range <>) of Integer;
      Buffer : Buffers.Buffer_Type;
      type Event_Type (Size : Positive) is record
         Words : Integer_Array (1 .. Size);
      end record;
      type Event_Access is access Event_Type;
      for Event_Access'Storage_Pool use Buffer;
      procedure Flush is new Ada.Unchecked_Deallocation (Event_Type,
                                                         Event_Access);
      Event : Event_Access;
      use type Interfaces.Unsigned_64;
   begin
      Buffers.Initialise (Buffer, Object.Outputs (1).Memory);
      Event := new Event_Type (10);
      for I in Event.Words'Range loop
         Event.Words (I) := I;
      end loop;
      Flush (Event);
      Object.Number_Of_Event_Produced :=
        Object.Number_Of_Event_Produced + 1;
   exception
      when E : others =>
         Error_Out (Object.Logger'Access,
                    "travail en acq", E);
   end Buffer_Handling;

end Narval.Actors.Actives.Producers.Basic;

