#ifndef __WB_MYSQL_EDITOR_INSERT_PAGE_H__
#define __WB_MYSQL_EDITOR_INSERT_PAGE_H__

#include "wb_config.h"

#include "grtdb/editor_dbobject.h"
#include "grtdb/dbobject_roles.h"
#include "grtdb/role_tree_model.h"
#include <gtkmm/treemodel.h>
#include "widgets_auto_cleaner.h"

class ListModelWrapper;
namespace Gtk
{
class TreeView;
class ListStore;
class HBox;
class Button;
class Widget;
}

//==============================================================================
//
//==============================================================================
class DbMySQLEditorPrivPage : private WidgetsAutoCleaner
{
  public:
    DbMySQLEditorPrivPage(::bec::DBObjectEditorBE* be);
    ~DbMySQLEditorPrivPage();
    void refresh();

    void switch_be(bec::DBObjectEditorBE* be);
        
    Gtk::HBox& page() const { return *_holder; }
    
  private:
    void assign_privilege_handler();
    void assign_privilege(const Gtk::TreeModel::iterator& iter);
    void remove_privilege_handler();
    void remove_privilege(const Gtk::TreeModel::Path& path);
  
    void role_selected();
  
    ::bec::DBObjectEditorBE   *_be;

    ::bec::ObjectRoleListBE            *_object_roles_list_be;
    ::bec::RoleTreeBE                  *_role_tree_be;
    ::bec::ObjectPrivilegeListBE       *_object_privilege_list_be;

    Glib::RefPtr<ListModelWrapper>      _roles_model;
    Glib::RefPtr<ListModelWrapper>      _all_roles_model;
    Glib::RefPtr<ListModelWrapper>      _assigned_priv_model;
    
    Gtk::HBox                   *_holder;
    Gtk::TreeView               *_roles_tv;
    Gtk::TreeView               *_assigned_priv_tv;
    Gtk::Button                 *_add_button;
    Gtk::Button                 *_remove_button;
    Gtk::TreeView               *_all_roles_tv;
    std::vector<Gtk::TreePath>   _selected;
};

#endif
