/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_CHECKBOX_H_
#define _STUB_CHECKBOX_H_

#include "stub_button.h"

namespace mforms {
namespace stub {

class CheckBoxImpl : public ButtonImpl
{
 protected:
  static bool __stdcall create(::mforms::CheckBox *self)
  {
    return true;
  }

  static void __stdcall set_active(::mforms::CheckBox *self, bool flag)
  {
  }

  static bool __stdcall get_active(::mforms::CheckBox *self)
  {
    return false;
  }

  CheckBoxImpl(::mforms::CheckBox *self)
    : ButtonImpl(self)
  {
  }

  static void __stdcall callback(::mforms::CheckBox* self)
  {
  }

 public:
  static void init()
  {
    ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

    f->_checkbox_impl.create     = &CheckBoxImpl::create;
    f->_checkbox_impl.set_active = &CheckBoxImpl::set_active;
    f->_checkbox_impl.get_active = &CheckBoxImpl::get_active;
  }
};

};
};

#endif
