/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _DRAWING_H_
#define _DRAWING_H_

/**
 * Definitions used for cross-platform drawing.
 */

#ifndef SWIG
#include "common.h"
#endif

namespace MySQL {
namespace Drawing {

  struct HSVColor;

  struct BASELIBRARY_PUBLIC_FUNC Color
  {
    double red, green, blue, alpha;

    Color();
    Color(double ar, double ag, double ab, double aa = 1.0);
    Color(const HSVColor &hsv);

    bool operator !=(const Color &other);
    std::string to_html();

    static Color parse(const std::string &color);

    static inline Color Black() { return Color(0, 0, 0); }
    static inline Color White() { return Color(1, 1, 1); }  
  };


  struct BASELIBRARY_PUBLIC_FUNC HSVColor
  {
    int h; // 0 ~ 360
    double s, v, a; // 0 ~ 1.0

    HSVColor() : h(0), s(0), v(0), a(1) {};
    HSVColor(int ah, double as, double av, double aa=1.0) : h(ah), s(as), v(av), a(aa) {};
    HSVColor(const Color &rgb);
  };

}
}

#endif // _DRAWING_H_
