/* 
 * Copyright (c) 2007, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _DB_SQL_EDITOR_LOG_BE_H_
#define _DB_SQL_EDITOR_LOG_BE_H_


#include "workbench/wb_backend_public_interface.h"
#include "sqlide/var_grid_model_be.h"
#include <boost/shared_ptr.hpp>
#include "mforms/menu.h"


class MYSQLWBBACKEND_PUBLIC_FUNC DbSqlEditorLog : public VarGridModel
{
public:
  enum MessageType {
    ErrorMsg,
    WarningMsg,
    NoteMsg,
    OKMsg,
    EditMsg,
    BusyMsg
  };
  
  typedef boost::shared_ptr<DbSqlEditorLog> Ref;
  static Ref create(bec::GRTManager *grtm) { return Ref(new DbSqlEditorLog(grtm)); }
  virtual ~DbSqlEditorLog() {}
protected:
  DbSqlEditorLog(bec::GRTManager *grtm);

public:
  virtual void reset();

public:
  virtual bec::IconId get_field_icon(const bec::NodeId &node, int column, bec::IconSize size);
  virtual bool get_field(const bec::NodeId &node, int column, std::string &value);
  virtual bool get_field(const bec::NodeId &node, int column, int &value) { return VarGridModel::get_field(node, column, value); }
  virtual bool get_field_description(const bec::NodeId &node, int column, std::string &value);
  
public:
  RowId add_message(int msg_type, const std::string &context, const std::string &msg, const std::string &duration);
  void set_message(RowId row, int msg_type, const std::string &context, const std::string &msg, const std::string &duration);

  mforms::Menu* get_context_menu();

private:
  mforms::Menu  _context_menu;
};


#endif /* _DB_SQL_EDITOR_LOG_BE_H_ */
