//
//  MySQLStartupPref.m
//  MySQLStartup
//
//  Created by Alfredo Kojima on 1/4/05.
//  Copyright (c) 2005 MySQL AB. All rights reserved.
//

#define MYSQL_PREFPANE
#import "MySQLStartupPref.h"
#include "../mahelper.h"
#include "../mahelper_priv.h"
#undef NSLocalizedString
#define NSLocalizedString(a,b) a

@implementation MySQLStartupPref

- (void) mainViewDidLoad
{
  authRef= 0;
  curIsRunning= NO;
  firstTime= YES;

  [self isRunning];
  [self isAutoStarting];
  [NSTimer scheduledTimerWithTimeInterval: 2.0
                                   target:self
                                 selector:@selector(isRunning) 
                                 userInfo:nil 
                                  repeats:YES];

  [NSTimer scheduledTimerWithTimeInterval: 2.0 
                                   target:self
                                 selector:@selector(isAutoStarting) 
                                 userInfo:nil 
                                  repeats:YES];
}

- (void)dealloc
{
  if (authRef)
    AuthorizationFree(authRef,kAuthorizationFlagDefaults);
  [super dealloc];
}


- (BOOL)isAutoStarting
{  
  BOOL autoStart;
  
  if (autoStart= mautoStartState())
    [autoStartCheck setState:NSOnState];
  else
    [autoStartCheck setState:NSOffState];
  
  return autoStart;
}


- (BOOL)isRunning
{
  BOOL state= NO;
  NSTask *task = [[NSTask alloc] init];  
#if 0 // apparently, we can't run suid programs in Tiger anymore...
  NSData *inData = nil;
  NSArray *array = nil;
  NSString *string = nil;
  int i, count;
  
  [task setLaunchPath:@"/bin/ps"];
  [task setArguments:[NSArray arrayWithObjects:@"ax",@"-ocommand",nil]];
#else
  [task setLaunchPath:[NSString stringWithUTF8String:MYSQLADMIN_COMMAND]];
  [task setArguments:[NSArray arrayWithObject:@"ping"]];
#endif
  [task setStandardOutput:[NSPipe pipe]];
  [task setStandardError:[task standardOutput]];
  [task launch];
  [task waitUntilExit];
#if 0
  inData = [[[task standardOutput] fileHandleForReading] readDataToEndOfFile];
  string = [[[NSString alloc] initWithData:inData encoding:NSASCIIStringEncoding] autorelease];
  array = [string componentsSeparatedByString:@"\n"];
  [task release];
  count= [array count];
  for (i= 0; i < count; i++)
  {
    NSString *line= [array objectAtIndex:i];
    NSRange range;
    
    range= [line rangeOfString:@"mysqld"];
    if (range.location != NSNotFound)
    {
      state= YES;
      break;
    }
  }
#else
  state= [task terminationStatus] == 0 ? YES : NO;
#endif
  if (state != curIsRunning || firstTime)
  {
    NSBundle *bundle= [NSBundle bundleForClass:[self class]];
    firstTime= NO;
    curIsRunning= state;
    if (state)
    {
      [button setTitle:NSLocalizedString(@"Stop MySQL Server", nil)];
      [descrText setStringValue:@"The MySQL Database Server is started and ready for client connections.\n"
        "To shut the Server down, use the \"Stop MySQL Server\" button."];
      [warningText setHidden:NO];
      [[stateText cell] setTextColor: [NSColor greenColor]];
      [stateText setStringValue:@"running"];
      [stateImage setImage:
        [[[NSImage alloc] initWithContentsOfFile:[bundle pathForResource:@"instance_started"
                                                                 ofType:@"png"]] autorelease]];
    } else {
      [button setTitle:NSLocalizedString(@"Start MySQL Server", nil)];
      [descrText setStringValue:@"The MySQL Database Server is currently stopped.\n"
        "To start it, use the \"Start MySQL Server\" button."];
      [warningText setHidden:YES];
      [[stateText cell] setTextColor: [NSColor redColor]];
      [stateText setStringValue:@"stopped"];
      [stateImage setImage:
        [[[NSImage alloc] initWithContentsOfFile:[bundle pathForResource:@"instance_stopped"
                                                                  ofType:@"png"]] autorelease]];
    }
    [stateImage setNeedsDisplay];
  }
  
  return state;
}



- (int)performCommand:(MAHelperCommand)command
{
  //AuthorizationRef authRef= NULL;
  NSString *helperPath;
  AuthorizationItem right = { "com.mysql.administrator.helper", 0, NULL, 0 };
  AuthorizationRights rightSet = { 1, &right };
  OSStatus status;

  helperPath= [[NSBundle bundleForClass:[self class]] pathForResource:@"mahelper"
                                                               ofType:@""];

  if (!authRef)
  {
    if (AuthorizationCreate(NULL, kAuthorizationEmptyEnvironment, kAuthorizationFlagDefaults, 
                            &authRef)!=errAuthorizationSuccess)
    {
      NSLog(@"Could not create authorization reference object.");
      return MAHelperCommandInternalError;
    }
    
    status = AuthorizationCopyRights(authRef, &rightSet, kAuthorizationEmptyEnvironment, 
                                     kAuthorizationFlagDefaults | kAuthorizationFlagPreAuthorize
                                     | kAuthorizationFlagInteractionAllowed | kAuthorizationFlagExtendRights,
                                     NULL);
  } else
    status= errAuthorizationSuccess;
  if (status == errAuthorizationSuccess)
  {
    int hstatus;
    
    hstatus = mhelperPerformCommand(authRef, [helperPath UTF8String], command);
  
    return hstatus;
  }
  else
  {
    AuthorizationFree(authRef, kAuthorizationFlagDestroyRights);
    authRef= 0;
    if (status != errAuthorizationCanceled)
    {
      // pre-auth failed
      NSLog(@"Pre-auth failed");
      return MAHelperCommandAuthFailed;
    }
    else
      return MAHelperCommandCancelled;
  }
}


static NSString *errorMessage(int rc)
{
  switch (rc)
  {
    case MAHelperCommandInternalError:
      return @"Internal error.";
    case MAHelperCommandSuccess:
      return @"Success";
    case MAHelperCommandExecFailed:
      return @"Could not execute command.";
    case MAHelperCommandChildError:
      return @"Error in command.";
    case MAHelperCommandAuthFailed:
      return @"Authentication error.";
    case MAHelperCommandOperationFailed:
      return @"Operation failed.";
    case MAHelperCommandCancelled:
      return @"Cancelled.";
    case MAHelperCommandHelperNotFound:
      return @"Helper binary not found. Please reinstall the preference pane.";
    default:
      return [NSString stringWithFormat:@"%i", rc];//@"";
  }
}


- (BOOL)shutdownServer
{
  MAHelperCommand command;
  
  command.authorizedCommandId= MAHelperShutdownMySQL;
  
  return [self performCommand:command]==MAHelperCommandSuccess;
}

- (IBAction)toggleServer:(id)sender
{
  MAHelperCommand command;
  BOOL start= ![self isRunning];
  int rc;

  command.authorizedCommandId= start ? MAHelperStartMySQL : MAHelperStopMySQL;
  
  if ((rc= [self performCommand:command])!=MAHelperCommandSuccess)
  {
    if (rc != MAHelperCommandCancelled)
    {
      if (start)
        NSRunAlertPanel(NSLocalizedString(@"Error",nil), 
                        [NSString stringWithFormat:NSLocalizedString(@"Could not startup MySQL Server.\nReason: %@",nil), errorMessage(rc)], 
                        nil, nil, nil);
      else
	  {
		if (![self shutdownServer])
		{
		  NSRunAlertPanel(NSLocalizedString(@"Error",nil), 
						  [NSString stringWithFormat:NSLocalizedString(@"Could not stop MySQL Server.\nReason: %@",nil), errorMessage(rc)], 
						  nil, nil, nil);
		}
	  }
    }
  }
}


- (IBAction)changeAutoStart:(id)sender
{
  MAHelperCommand command;
  BOOL flag= ![self isAutoStarting];
  int rc;
    
  command.authorizedCommandId= MAHelperToggleAutoStart;
  command.enable= flag;
  if ((rc = [self performCommand:command]) != MAHelperCommandSuccess)
  {
    if (rc != MAHelperCommandCancelled)
      NSRunAlertPanel(NSLocalizedString(@"Error",nil),
                      [NSString stringWithFormat:NSLocalizedString(@"Could not change automatic startup configuration.\nReason: %@",nil), errorMessage(rc)], 
                      nil, nil, nil);
  }
  [self isAutoStarting];
}


@end
