/* Copyright (c) 2004-2007 MySQL AB, 2009 Sun Microsystems, Inc.
   Use is subject to license terms.
   
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; version 2
   of the License.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
   MA 02110-1301, USA
*/

/* 
   UCA (Unicode Collation Algorithm) support. 
   Written by Alexander Barkov <bar@mysql.com>
   
   Currently supports only subset of the full UCA:
   - Only Primary level key comparison
   - Basic Latin letters contraction is implemented
   - Variable weighting is done for Non-ignorable option
   
   Features that are not implemented yet:
   - No Normalization From D is done
     + No decomposition is done
     + No Thai/Lao orderding is done
   - No combining marks processing is done
*/


#include <my_global.h>
#include "m_string.h"
#include "m_ctype.h"

#ifdef HAVE_UCA_COLLATIONS

#define MY_UCA_NPAGES 256
#define MY_UCA_NCHARS 256
#define MY_UCA_CMASK  255
#define MY_UCA_PSHIFT 8

uint16 page000data[]= { /* 0000 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0201,0x0000,0x0000,0x0000,
0x0202,0x0000,0x0000,0x0000, 0x0203,0x0000,0x0000,0x0000,
0x0204,0x0000,0x0000,0x0000, 0x0205,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000, 0x0251,0x0000,0x0000,0x0000,
0x027E,0x0000,0x0000,0x0000, 0x02D2,0x0000,0x0000,0x0000,
0x0E0F,0x0000,0x0000,0x0000, 0x02D3,0x0000,0x0000,0x0000,
0x02CF,0x0000,0x0000,0x0000, 0x0277,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000, 0x0289,0x0000,0x0000,0x0000,
0x02C8,0x0000,0x0000,0x0000, 0x0428,0x0000,0x0000,0x0000,
0x022F,0x0000,0x0000,0x0000, 0x0221,0x0000,0x0000,0x0000,
0x025D,0x0000,0x0000,0x0000, 0x02CC,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000, 0x0E2A,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000, 0x0E2C,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000, 0x0E2E,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000, 0x0E30,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000, 0x0E32,0x0000,0x0000,0x0000,
0x023D,0x0000,0x0000,0x0000, 0x023A,0x0000,0x0000,0x0000,
0x042C,0x0000,0x0000,0x0000, 0x042D,0x0000,0x0000,0x0000,
0x042E,0x0000,0x0000,0x0000, 0x0255,0x0000,0x0000,0x0000,
0x02C7,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000, 0x0EC1,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000, 0x0F21,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000, 0x0FB4,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x0FEA,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x1051,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000, 0x028A,0x0000,0x0000,0x0000,
0x02CE,0x0000,0x0000,0x0000, 0x028B,0x0000,0x0000,0x0000,
0x020F,0x0000,0x0000,0x0000, 0x021B,0x0000,0x0000,0x0000,
0x020C,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000, 0x0EC1,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000, 0x0F21,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000, 0x0FB4,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x0FEA,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x1051,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000, 0x028C,0x0000,0x0000,0x0000,
0x0430,0x0000,0x0000,0x0000, 0x028D,0x0000,0x0000,0x0000,
0x0433,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0206,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000, 0x0252,0x0000,0x0000,0x0000,
0x0E0E,0x0000,0x0000,0x0000, 0x0E10,0x0000,0x0000,0x0000,
0x0E0D,0x0000,0x0000,0x0000, 0x0E11,0x0000,0x0000,0x0000,
0x0431,0x0000,0x0000,0x0000, 0x02C2,0x0000,0x0000,0x0000,
0x0214,0x0000,0x0000,0x0000, 0x02C5,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0286,0x0000,0x0000,0x0000,
0x042F,0x0000,0x0000,0x0000, 0x0220,0x0000,0x0000,0x0000,
0x02C6,0x0000,0x0000,0x0000, 0x0210,0x0000,0x0000,0x0000,
0x034A,0x0000,0x0000,0x0000, 0x0429,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000, 0x0E2C,0x0000,0x0000,0x0000,
0x020D,0x0000,0x0000,0x0000, 0x10F8,0x0000,0x0000,0x0000,
0x02C3,0x0000,0x0000,0x0000, 0x0267,0x0000,0x0000,0x0000,
0x0219,0x0000,0x0000,0x0000, 0x0E2A,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0287,0x0000,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2D,0x0000, 0x0E2A,0x02CD,0x0E2B,0x0000,
0x0E2C,0x02CD,0x0E2D,0x0000, 0x0256,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E38,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0E86,0x0000,0x0000,0x0000, 0x0F64,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x042B,0x0000,0x0000,0x0000,
0x0F8D,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x1094,0x0000,0x0000,0x0000, 0x0FEA,0x0FEA,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E38,0x0000,0x0000,0x0000, 0x0E60,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0E8B,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0E86,0x0000,0x0000,0x0000, 0x0F64,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x0F82,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x042A,0x0000,0x0000,0x0000,
0x0F8D,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000,
0x1094,0x0000,0x0000,0x0000, 0x105E,0x0000,0x0000,0x0000
};

uint16 page001data[]= { /* 0100 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E72,0x0000,0x0000, 0x0E72,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EED,0x0000,0x0000,
0x0EED,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFF,0x0000,0x0000, 0x0EFB,0x0F10,0x0000,
0x0EFB,0x0F10,0x0000, 0x0F10,0x0000,0x0000, 0x0F10,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0FBC,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0267,0x0000, 0x0F2E,0x0267,0x0000, 0x0F36,0x0000,0x0000,
0x0F36,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x10B1,0x0F64,0x0000, 0x0F7E,0x0000,0x0000,
0x0F7E,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0E8B,0x0000, 0x0F82,0x0E8B,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1007,0x0000,0x0000, 0x1007,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0E52,0x0000,0x0000,
0x0E58,0x0000,0x0000, 0x0E5C,0x0000,0x0000, 0x0E5C,0x0000,0x0000,
0x10A8,0x0000,0x0000, 0x10A8,0x0000,0x0000, 0x0F92,0x0000,0x0000,
0x0E65,0x0000,0x0000, 0x0E65,0x0000,0x0000, 0x0E76,0x0000,0x0000,
0x0E7A,0x0000,0x0000, 0x0E7E,0x0000,0x0000, 0x0E7E,0x0000,0x0000,
0x106A,0x1051,0x0000, 0x0E90,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0E98,0x0000,0x0000, 0x0EBD,0x0000,0x0000, 0x0EBD,0x0000,0x0000,
0x0ED1,0x0000,0x0000, 0x0ED9,0x0000,0x0000, 0x0EE9,0x0000,0x0000,
0x0F0C,0x0000,0x0000, 0x0F08,0x0000,0x0000, 0x0F26,0x0000,0x0000,
0x0F26,0x0000,0x0000, 0x0F3B,0x0000,0x0000, 0x0F53,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x0F6E,0x0000,0x0000, 0x0F72,0x0000,0x0000,
0x0F9A,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0EDD,0x0000,0x0000, 0x0EDD,0x0000,0x0000, 0x0FAC,0x0000,0x0000,
0x0FAC,0x0000,0x0000, 0x0FC4,0x0000,0x0000, 0x10A0,0x0000,0x0000,
0x10A0,0x0000,0x0000, 0x0FF2,0x0000,0x0000, 0x0FF6,0x0000,0x0000,
0x100B,0x0000,0x0000, 0x100F,0x0000,0x0000, 0x100F,0x0000,0x0000,
0x1013,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1040,0x0000,0x0000, 0x1049,0x0000,0x0000, 0x1066,0x0000,0x0000,
0x1066,0x0000,0x0000, 0x106F,0x0000,0x0000, 0x106F,0x0000,0x0000,
0x107F,0x0000,0x0000, 0x1084,0x0000,0x0000, 0x1084,0x0000,0x0000,
0x1088,0x0000,0x0000, 0x109C,0x0000,0x0000, 0x10A4,0x0000,0x0000,
0x10A4,0x0000,0x0000, 0x1002,0x0FEA,0x0000, 0x1098,0x0000,0x0000,
0x10C8,0x0000,0x0000, 0x10CC,0x0000,0x0000, 0x10D0,0x0000,0x0000,
0x10D4,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x106A,0x0000,
0x0E6D,0x106A,0x0000, 0x0F2E,0x0F10,0x0000, 0x0F2E,0x0F10,0x0000,
0x0F2E,0x0F10,0x0000, 0x0F64,0x0F10,0x0000, 0x0F64,0x0F10,0x0000,
0x0F64,0x0F10,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x0E90,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E38,0x0000,0x0000, 0x0E38,0x0000,0x0000,
0x0ECD,0x0000,0x0000, 0x0ECD,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x107F,0x0000,0x0000, 0x107F,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x106A,0x0000,
0x0E6D,0x106A,0x0000, 0x0EC1,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE9,0x0000,0x0000, 0x1098,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E38,0x0000,0x0000, 0x0E38,0x0000,0x0000, 0x0F8D,0x0000,0x0000,
0x0F8D,0x0000,0x0000 };

uint16 page002data[]= { /* 0200 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1090,0x0000,0x0000, 0x1090,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0F72,0x0000,0x0000,
0x0E82,0x0000,0x0000, 0x0FA2,0x0000,0x0000, 0x0FA2,0x0000,0x0000,
0x1073,0x0000,0x0000, 0x1073,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x0F4B,0x0000,0x0000, 0x0F7A,0x0000,0x0000,
0x1017,0x0000,0x0000, 0xFBC0,0x8237,0x0000, 0xFBC0,0x8238,0x0000,
0xFBC0,0x8239,0x0000, 0xFBC0,0x823A,0x0000, 0xFBC0,0x823B,0x0000,
0xFBC0,0x823C,0x0000, 0xFBC0,0x823D,0x0000, 0xFBC0,0x823E,0x0000,
0xFBC0,0x823F,0x0000, 0xFBC0,0x8240,0x0000, 0xFBC0,0x8241,0x0000,
0xFBC0,0x8242,0x0000, 0xFBC0,0x8243,0x0000, 0xFBC0,0x8244,0x0000,
0xFBC0,0x8245,0x0000, 0xFBC0,0x8246,0x0000, 0xFBC0,0x8247,0x0000,
0xFBC0,0x8248,0x0000, 0xFBC0,0x8249,0x0000, 0xFBC0,0x824A,0x0000,
0xFBC0,0x824B,0x0000, 0xFBC0,0x824C,0x0000, 0xFBC0,0x824D,0x0000,
0xFBC0,0x824E,0x0000, 0xFBC0,0x824F,0x0000, 0x0E3E,0x0000,0x0000,
0x0E42,0x0000,0x0000, 0x0E46,0x0000,0x0000, 0x0E58,0x0000,0x0000,
0x0F92,0x0000,0x0000, 0x0E69,0x0000,0x0000, 0x0E76,0x0000,0x0000,
0x0E7A,0x0000,0x0000, 0x0E9C,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0EA0,0x0000,0x0000, 0x0E98,0x0000,0x0000, 0x0EA4,0x0000,0x0000,
0x0EA9,0x0000,0x0000, 0x0EAD,0x0000,0x0000, 0x0F19,0x0000,0x0000,
0x0ED1,0x0000,0x0000, 0x0EC5,0x0000,0x0000, 0x0EC9,0x0000,0x0000,
0x0ED9,0x0000,0x0000, 0x0EB5,0x0000,0x0000, 0x102B,0x0000,0x0000,
0x0EF1,0x0000,0x0000, 0x0EF5,0x0000,0x0000, 0x0F08,0x0000,0x0000,
0x0F0C,0x0000,0x0000, 0x0F03,0x0000,0x0000, 0x0F3F,0x0000,0x0000,
0x0F43,0x0000,0x0000, 0x0F47,0x0000,0x0000, 0x0F4F,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x103C,0x0000,0x0000, 0x0F60,0x0000,0x0000,
0x0F6E,0x0000,0x0000, 0x0F76,0x0000,0x0000, 0x0F68,0x0000,0x0000,
0x0F9A,0x0000,0x0000, 0x0F88,0x0000,0x0000, 0x0F9E,0x0000,0x0000,
0x0FB0,0x0000,0x0000, 0x0FC9,0x0000,0x0000, 0x0FCE,0x0000,0x0000,
0x0FD2,0x0000,0x0000, 0x0FD6,0x0000,0x0000, 0x0FDA,0x0000,0x0000,
0x0FDE,0x0000,0x0000, 0x0FE2,0x0000,0x0000, 0x0FC4,0x0000,0x0000,
0x0FE6,0x0000,0x0000, 0x0FEE,0x0000,0x0000, 0x0FF2,0x0000,0x0000,
0x0F1D,0x0000,0x0000, 0x0FFA,0x0000,0x0000, 0x0FFE,0x0000,0x0000,
0x101B,0x0000,0x0000, 0x1013,0x0000,0x0000, 0x1027,0x0000,0x0000,
0x1040,0x0000,0x0000, 0x1049,0x0000,0x0000, 0x104D,0x0000,0x0000,
0x1056,0x0000,0x0000, 0x0F57,0x0000,0x0000, 0x1062,0x0000,0x0000,
0x1077,0x0000,0x0000, 0x107B,0x0000,0x0000, 0x107F,0x0000,0x0000,
0x108C,0x0000,0x0000, 0x10AC,0x0000,0x0000, 0x10B4,0x0000,0x0000,
0x10C4,0x0000,0x0000, 0x10D8,0x0000,0x0000, 0x10DC,0x0000,0x0000,
0x0E4E,0x0000,0x0000, 0x0EB1,0x0000,0x0000, 0x0ED5,0x0000,0x0000,
0x0EE5,0x0000,0x0000, 0x0F15,0x0000,0x0000, 0x0F2A,0x0000,0x0000,
0x0F32,0x0000,0x0000, 0x0FB8,0x0000,0x0000, 0x10BC,0x0000,0x0000,
0x10C0,0x0000,0x0000, 0x0E6D,0x106A,0x0000, 0x0E6D,0x107F,0x0000,
0x0E6D,0x107B,0x0000, 0x1002,0x0FEA,0x0000, 0x1002,0x0FF2,0x0000,
0x1002,0x0E69,0x0000, 0x0EB9,0x0F7E,0x0000, 0x0F2E,0x0FEA,0x0000,
0x0F2E,0x106A,0x0000, 0x10E0,0x0000,0x0000, 0x10E4,0x0000,0x0000,
0x102F,0x0000,0x0000, 0x1033,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EF1,0x0000,0x0000, 0x0F10,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC9,0x0000,0x0000, 0x0FD2,0x0000,0x0000, 0x0FE6,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x0317,0x0000,0x0000,
0x0319,0x0000,0x0000, 0x0EF9,0x0000,0x0000, 0x10B1,0x0000,0x0000,
0x0EFA,0x0000,0x0000, 0x10B3,0x0000,0x0000, 0x10B8,0x0000,0x0000,
0x10B0,0x0000,0x0000, 0x10B9,0x0000,0x0000, 0x031A,0x0000,0x0000,
0x031B,0x0000,0x0000, 0x031C,0x0000,0x0000, 0x031D,0x0000,0x0000,
0x031E,0x0000,0x0000, 0x031F,0x0000,0x0000, 0x0320,0x0000,0x0000,
0x0321,0x0000,0x0000, 0x0322,0x0000,0x0000, 0x0323,0x0000,0x0000,
0x0324,0x0000,0x0000, 0x0325,0x0000,0x0000, 0x0326,0x0000,0x0000,
0x0327,0x0000,0x0000, 0x0E01,0x0000,0x0000, 0x0E02,0x0000,0x0000,
0x0328,0x0000,0x0000, 0x0329,0x0000,0x0000, 0x032A,0x0000,0x0000,
0x032B,0x0000,0x0000, 0x032C,0x0000,0x0000, 0x032D,0x0000,0x0000,
0x0212,0x0000,0x0000, 0x0213,0x0000,0x0000, 0x0215,0x0000,0x0000,
0x021A,0x0000,0x0000, 0x020E,0x0000,0x0000, 0x0216,0x0000,0x0000,
0x032E,0x0000,0x0000, 0x032F,0x0000,0x0000, 0x0ED9,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x10B4,0x0000,0x0000, 0x0330,0x0000,0x0000, 0x0331,0x0000,0x0000,
0x0332,0x0000,0x0000, 0x0333,0x0000,0x0000, 0x0334,0x0000,0x0000,
0x0335,0x0000,0x0000, 0x0336,0x0000,0x0000, 0x0337,0x0000,0x0000,
0x0338,0x0000,0x0000, 0x10B2,0x0000,0x0000, 0x0339,0x0000,0x0000,
0x033A,0x0000,0x0000, 0x033B,0x0000,0x0000, 0x033C,0x0000,0x0000,
0x033D,0x0000,0x0000, 0x033E,0x0000,0x0000, 0x033F,0x0000,0x0000,
0x0340,0x0000,0x0000, 0x0341,0x0000,0x0000, 0x0342,0x0000,0x0000,
0x0343,0x0000,0x0000, 0x0344,0x0000,0x0000, 0x0345,0x0000,0x0000,
0x0346,0x0000,0x0000, 0x0347,0x0000,0x0000, 0x0348,0x0000,0x0000,
0x0349,0x0000,0x0000 };

uint16 page003data[]= { /* 0300 (4 weights per char) */
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0xFBC0,0x8358,0x0000,0x0000, 0xFBC0,0x8359,0x0000,0x0000,
0xFBC0,0x835A,0x0000,0x0000, 0xFBC0,0x835B,0x0000,0x0000,
0xFBC0,0x835C,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x0E33,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000, 0x0EFB,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000, 0x101F,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000, 0x0E6D,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000, 0x0F5B,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000, 0x1002,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000, 0x105A,0x0000,0x0000,0x0000,
0xFBC0,0x8370,0x0000,0x0000, 0xFBC0,0x8371,0x0000,0x0000,
0xFBC0,0x8372,0x0000,0x0000, 0xFBC0,0x8373,0x0000,0x0000,
0x0317,0x0000,0x0000,0x0000, 0x0318,0x0000,0x0000,0x0000,
0xFBC0,0x8376,0x0000,0x0000, 0xFBC0,0x8377,0x0000,0x0000,
0xFBC0,0x8378,0x0000,0x0000, 0xFBC0,0x8379,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0xFBC0,0x837B,0x0000,0x0000,
0xFBC0,0x837C,0x0000,0x0000, 0xFBC0,0x837D,0x0000,0x0000,
0x023A,0x0000,0x0000,0x0000, 0xFBC0,0x837F,0x0000,0x0000,
0xFBC0,0x8380,0x0000,0x0000, 0xFBC0,0x8381,0x0000,0x0000,
0xFBC0,0x8382,0x0000,0x0000, 0xFBC0,0x8383,0x0000,0x0000,
0x020D,0x0000,0x0000,0x0000, 0x0214,0x0000,0x0000,0x0000,
0x10E8,0x0000,0x0000,0x0000, 0x0267,0x0000,0x0000,0x0000,
0x10ED,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0xFBC0,0x838B,0x0000,0x0000,
0x10FB,0x0000,0x0000,0x0000, 0xFBC0,0x838D,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x10E8,0x0000,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10EA,0x0000,0x0000,0x0000,
0x10EC,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F0,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x10F6,0x0000,0x0000,0x0000,
0x10F8,0x0000,0x0000,0x0000, 0x10F9,0x0000,0x0000,0x0000,
0x10FA,0x0000,0x0000,0x0000, 0x10FB,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0xFBC0,0x83A2,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x1103,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1105,0x0000,0x0000,0x0000, 0x1106,0x0000,0x0000,0x0000,
0x1107,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x10E8,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F1,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x10E8,0x0000,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10EA,0x0000,0x0000,0x0000,
0x10EC,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x10F0,0x0000,0x0000,0x0000, 0x10F1,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10F3,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x10F6,0x0000,0x0000,0x0000,
0x10F8,0x0000,0x0000,0x0000, 0x10F9,0x0000,0x0000,0x0000,
0x10FA,0x0000,0x0000,0x0000, 0x10FB,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0x1102,0x0000,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x1103,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1105,0x0000,0x0000,0x0000, 0x1106,0x0000,0x0000,0x0000,
0x1107,0x0000,0x0000,0x0000, 0x1109,0x0000,0x0000,0x0000,
0x10F3,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x10FB,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1109,0x0000,0x0000,0x0000, 0xFBC0,0x83CF,0x0000,0x0000,
0x10E9,0x0000,0x0000,0x0000, 0x10F2,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1104,0x0000,0x0000,0x0000,
0x1104,0x0000,0x0000,0x0000, 0x1105,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000, 0x10F5,0x10E8,0x10F3,0x0000,
0x10FF,0x0000,0x0000,0x0000, 0x10FF,0x0000,0x0000,0x0000,
0x10EF,0x0000,0x0000,0x0000, 0x10EF,0x0000,0x0000,0x0000,
0x10EE,0x0000,0x0000,0x0000, 0x10EE,0x0000,0x0000,0x0000,
0x10FE,0x0000,0x0000,0x0000, 0x10FE,0x0000,0x0000,0x0000,
0x110A,0x0000,0x0000,0x0000, 0x110A,0x0000,0x0000,0x0000,
0x110D,0x0000,0x0000,0x0000, 0x110D,0x0000,0x0000,0x0000,
0x110E,0x0000,0x0000,0x0000, 0x110E,0x0000,0x0000,0x0000,
0x110F,0x0000,0x0000,0x0000, 0x110F,0x0000,0x0000,0x0000,
0x1110,0x0000,0x0000,0x0000, 0x1110,0x0000,0x0000,0x0000,
0x1111,0x0000,0x0000,0x0000, 0x1111,0x0000,0x0000,0x0000,
0x1112,0x0000,0x0000,0x0000, 0x1112,0x0000,0x0000,0x0000,
0x1113,0x0000,0x0000,0x0000, 0x1113,0x0000,0x0000,0x0000,
0x10F5,0x0000,0x0000,0x0000, 0x1100,0x0000,0x0000,0x0000,
0x1102,0x0000,0x0000,0x0000, 0x10F4,0x0000,0x0000,0x0000,
0x10F2,0x0000,0x0000,0x0000, 0x10ED,0x0000,0x0000,0x0000,
0x0423,0x0000,0x0000,0x0000, 0x110B,0x0000,0x0000,0x0000,
0x110B,0x0000,0x0000,0x0000, 0x1102,0x0000,0x0000,0x0000,
0x110C,0x0000,0x0000,0x0000, 0x110C,0x0000,0x0000,0x0000,
0xFBC0,0x83FC,0x0000,0x0000, 0xFBC0,0x83FD,0x0000,0x0000,
0xFBC0,0x83FE,0x0000,0x0000, 0xFBC0,0x83FF,0x0000,0x0000
};

uint16 page004data[]= { /* 0400 (3 weights per char) */
0x1152,0x0000,0x0000, 0x1152,0x0000,0x0000, 0x1145,0x0000,0x0000,
0x114A,0x0000,0x0000, 0x115A,0x0000,0x0000, 0x1173,0x0000,0x0000,
0x1188,0x0000,0x0000, 0x118C,0x0000,0x0000, 0x1194,0x0000,0x0000,
0x11B9,0x0000,0x0000, 0x11DA,0x0000,0x0000, 0x1215,0x0000,0x0000,
0x1219,0x0000,0x0000, 0x117C,0x0000,0x0000, 0x1221,0x0000,0x0000,
0x127D,0x0000,0x0000, 0x1114,0x0000,0x0000, 0x112C,0x0000,0x0000,
0x1130,0x0000,0x0000, 0x1134,0x0000,0x0000, 0x1140,0x0000,0x0000,
0x1152,0x0000,0x0000, 0x115E,0x0000,0x0000, 0x116A,0x0000,0x0000,
0x117C,0x0000,0x0000, 0x1190,0x0000,0x0000, 0x1198,0x0000,0x0000,
0x11B0,0x0000,0x0000, 0x11BE,0x0000,0x0000, 0x11C6,0x0000,0x0000,
0x11DF,0x0000,0x0000, 0x11EF,0x0000,0x0000, 0x11FB,0x0000,0x0000,
0x1203,0x0000,0x0000, 0x120C,0x0000,0x0000, 0x121D,0x0000,0x0000,
0x1239,0x0000,0x0000, 0x123D,0x0000,0x0000, 0x1259,0x0000,0x0000,
0x1261,0x0000,0x0000, 0x1281,0x0000,0x0000, 0x1285,0x0000,0x0000,
0x1289,0x0000,0x0000, 0x128D,0x0000,0x0000, 0x1295,0x0000,0x0000,
0x12A1,0x0000,0x0000, 0x12A9,0x0000,0x0000, 0x12AD,0x0000,0x0000,
0x1114,0x0000,0x0000, 0x112C,0x0000,0x0000, 0x1130,0x0000,0x0000,
0x1134,0x0000,0x0000, 0x1140,0x0000,0x0000, 0x1152,0x0000,0x0000,
0x115E,0x0000,0x0000, 0x116A,0x0000,0x0000, 0x117C,0x0000,0x0000,
0x1190,0x0000,0x0000, 0x1198,0x0000,0x0000, 0x11B0,0x0000,0x0000,
0x11BE,0x0000,0x0000, 0x11C6,0x0000,0x0000, 0x11DF,0x0000,0x0000,
0x11EF,0x0000,0x0000, 0x11FB,0x0000,0x0000, 0x1203,0x0000,0x0000,
0x120C,0x0000,0x0000, 0x121D,0x0000,0x0000, 0x1239,0x0000,0x0000,
0x123D,0x0000,0x0000, 0x1259,0x0000,0x0000, 0x1261,0x0000,0x0000,
0x1281,0x0000,0x0000, 0x1285,0x0000,0x0000, 0x1289,0x0000,0x0000,
0x128D,0x0000,0x0000, 0x1295,0x0000,0x0000, 0x12A1,0x0000,0x0000,
0x12A9,0x0000,0x0000, 0x12AD,0x0000,0x0000, 0x1152,0x0000,0x0000,
0x1152,0x0000,0x0000, 0x1145,0x0000,0x0000, 0x114A,0x0000,0x0000,
0x115A,0x0000,0x0000, 0x1173,0x0000,0x0000, 0x1188,0x0000,0x0000,
0x118C,0x0000,0x0000, 0x1194,0x0000,0x0000, 0x11B9,0x0000,0x0000,
0x11DA,0x0000,0x0000, 0x1215,0x0000,0x0000, 0x1219,0x0000,0x0000,
0x117C,0x0000,0x0000, 0x1221,0x0000,0x0000, 0x127D,0x0000,0x0000,
0x1249,0x0000,0x0000, 0x1249,0x0000,0x0000, 0x129D,0x0000,0x0000,
0x129D,0x0000,0x0000, 0x12B1,0x0000,0x0000, 0x12B1,0x0000,0x0000,
0x12B5,0x0000,0x0000, 0x12B5,0x0000,0x0000, 0x12BD,0x0000,0x0000,
0x12BD,0x0000,0x0000, 0x12B9,0x0000,0x0000, 0x12B9,0x0000,0x0000,
0x12C1,0x0000,0x0000, 0x12C1,0x0000,0x0000, 0x12C5,0x0000,0x0000,
0x12C5,0x0000,0x0000, 0x12C9,0x0000,0x0000, 0x12C9,0x0000,0x0000,
0x12CD,0x0000,0x0000, 0x12CD,0x0000,0x0000, 0x12D1,0x0000,0x0000,
0x12D1,0x0000,0x0000, 0x12D5,0x0000,0x0000, 0x12D5,0x0000,0x0000,
0x1235,0x0000,0x0000, 0x1235,0x0000,0x0000, 0x1255,0x0000,0x0000,
0x1255,0x0000,0x0000, 0x1251,0x0000,0x0000, 0x1251,0x0000,0x0000,
0x124D,0x0000,0x0000, 0x124D,0x0000,0x0000, 0x11F7,0x0000,0x0000,
0x11F7,0x0000,0x0000, 0x034B,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8487,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x1180,0x0000,0x0000, 0x1180,0x0000,0x0000, 0x1299,0x0000,0x0000,
0x1299,0x0000,0x0000, 0x11FF,0x0000,0x0000, 0x11FF,0x0000,0x0000,
0x1134,0x0000,0x0000, 0x1134,0x0000,0x0000, 0x1138,0x0000,0x0000,
0x1138,0x0000,0x0000, 0x113C,0x0000,0x0000, 0x113C,0x0000,0x0000,
0x1166,0x0000,0x0000, 0x1166,0x0000,0x0000, 0x114E,0x0000,0x0000,
0x114E,0x0000,0x0000, 0x119C,0x0000,0x0000, 0x119C,0x0000,0x0000,
0x11AC,0x0000,0x0000, 0x11AC,0x0000,0x0000, 0x11A8,0x0000,0x0000,
0x11A8,0x0000,0x0000, 0x11A4,0x0000,0x0000, 0x11A4,0x0000,0x0000,
0x11CE,0x0000,0x0000, 0x11CE,0x0000,0x0000, 0x11D6,0x0000,0x0000,
0x11D6,0x0000,0x0000, 0x11F3,0x0000,0x0000, 0x11F3,0x0000,0x0000,
0x12D9,0x0000,0x0000, 0x12D9,0x0000,0x0000, 0x1208,0x0000,0x0000,
0x1208,0x0000,0x0000, 0x1211,0x0000,0x0000, 0x1211,0x0000,0x0000,
0x122D,0x0000,0x0000, 0x122D,0x0000,0x0000, 0x1231,0x0000,0x0000,
0x1231,0x0000,0x0000, 0x1241,0x0000,0x0000, 0x1241,0x0000,0x0000,
0x125D,0x0000,0x0000, 0x125D,0x0000,0x0000, 0x1269,0x0000,0x0000,
0x1269,0x0000,0x0000, 0x1271,0x0000,0x0000, 0x1271,0x0000,0x0000,
0x1245,0x0000,0x0000, 0x1245,0x0000,0x0000, 0x1275,0x0000,0x0000,
0x1275,0x0000,0x0000, 0x1279,0x0000,0x0000, 0x1279,0x0000,0x0000,
0x12DD,0x0000,0x0000, 0x115E,0x0000,0x0000, 0x115E,0x0000,0x0000,
0x11A0,0x0000,0x0000, 0x11A0,0x0000,0x0000, 0x11B5,0x0000,0x0000,
0x11B5,0x0000,0x0000, 0x11D2,0x0000,0x0000, 0x11D2,0x0000,0x0000,
0x11CA,0x0000,0x0000, 0x11CA,0x0000,0x0000, 0x126D,0x0000,0x0000,
0x126D,0x0000,0x0000, 0x11C2,0x0000,0x0000, 0x11C2,0x0000,0x0000,
0xFBC0,0x84CF,0x0000, 0x1118,0x0000,0x0000, 0x1118,0x0000,0x0000,
0x111C,0x0000,0x0000, 0x111C,0x0000,0x0000, 0x1128,0x0000,0x0000,
0x1128,0x0000,0x0000, 0x1156,0x0000,0x0000, 0x1156,0x0000,0x0000,
0x1120,0x0000,0x0000, 0x1120,0x0000,0x0000, 0x1124,0x0000,0x0000,
0x1124,0x0000,0x0000, 0x1162,0x0000,0x0000, 0x1162,0x0000,0x0000,
0x116F,0x0000,0x0000, 0x116F,0x0000,0x0000, 0x1177,0x0000,0x0000,
0x1177,0x0000,0x0000, 0x117C,0x0000,0x0000, 0x117C,0x0000,0x0000,
0x1184,0x0000,0x0000, 0x1184,0x0000,0x0000, 0x11E3,0x0000,0x0000,
0x11E3,0x0000,0x0000, 0x11E7,0x0000,0x0000, 0x11E7,0x0000,0x0000,
0x11EB,0x0000,0x0000, 0x11EB,0x0000,0x0000, 0x12A5,0x0000,0x0000,
0x12A5,0x0000,0x0000, 0x121D,0x0000,0x0000, 0x121D,0x0000,0x0000,
0x1225,0x0000,0x0000, 0x1225,0x0000,0x0000, 0x1229,0x0000,0x0000,
0x1229,0x0000,0x0000, 0x1265,0x0000,0x0000, 0x1265,0x0000,0x0000,
0xFBC0,0x84F6,0x0000, 0xFBC0,0x84F7,0x0000, 0x1291,0x0000,0x0000,
0x1291,0x0000,0x0000, 0xFBC0,0x84FA,0x0000, 0xFBC0,0x84FB,0x0000,
0xFBC0,0x84FC,0x0000, 0xFBC0,0x84FD,0x0000, 0xFBC0,0x84FE,0x0000,
0xFBC0,0x84FF,0x0000 };

uint16 page005data[]= { /* 0500 (3 weights per char) */
0x1144,0x0000,0x0000, 0x1144,0x0000,0x0000, 0x1149,0x0000,0x0000,
0x1149,0x0000,0x0000, 0x116E,0x0000,0x0000, 0x116E,0x0000,0x0000,
0x117B,0x0000,0x0000, 0x117B,0x0000,0x0000, 0x11BD,0x0000,0x0000,
0x11BD,0x0000,0x0000, 0x11DE,0x0000,0x0000, 0x11DE,0x0000,0x0000,
0x1207,0x0000,0x0000, 0x1207,0x0000,0x0000, 0x1210,0x0000,0x0000,
0x1210,0x0000,0x0000, 0xFBC0,0x8510,0x0000, 0xFBC0,0x8511,0x0000,
0xFBC0,0x8512,0x0000, 0xFBC0,0x8513,0x0000, 0xFBC0,0x8514,0x0000,
0xFBC0,0x8515,0x0000, 0xFBC0,0x8516,0x0000, 0xFBC0,0x8517,0x0000,
0xFBC0,0x8518,0x0000, 0xFBC0,0x8519,0x0000, 0xFBC0,0x851A,0x0000,
0xFBC0,0x851B,0x0000, 0xFBC0,0x851C,0x0000, 0xFBC0,0x851D,0x0000,
0xFBC0,0x851E,0x0000, 0xFBC0,0x851F,0x0000, 0xFBC0,0x8520,0x0000,
0xFBC0,0x8521,0x0000, 0xFBC0,0x8522,0x0000, 0xFBC0,0x8523,0x0000,
0xFBC0,0x8524,0x0000, 0xFBC0,0x8525,0x0000, 0xFBC0,0x8526,0x0000,
0xFBC0,0x8527,0x0000, 0xFBC0,0x8528,0x0000, 0xFBC0,0x8529,0x0000,
0xFBC0,0x852A,0x0000, 0xFBC0,0x852B,0x0000, 0xFBC0,0x852C,0x0000,
0xFBC0,0x852D,0x0000, 0xFBC0,0x852E,0x0000, 0xFBC0,0x852F,0x0000,
0xFBC0,0x8530,0x0000, 0x130A,0x0000,0x0000, 0x130B,0x0000,0x0000,
0x130C,0x0000,0x0000, 0x130D,0x0000,0x0000, 0x130E,0x0000,0x0000,
0x130F,0x0000,0x0000, 0x1310,0x0000,0x0000, 0x1311,0x0000,0x0000,
0x1312,0x0000,0x0000, 0x1313,0x0000,0x0000, 0x1314,0x0000,0x0000,
0x1315,0x0000,0x0000, 0x1316,0x0000,0x0000, 0x1317,0x0000,0x0000,
0x1318,0x0000,0x0000, 0x1319,0x0000,0x0000, 0x131A,0x0000,0x0000,
0x131B,0x0000,0x0000, 0x131C,0x0000,0x0000, 0x131D,0x0000,0x0000,
0x131E,0x0000,0x0000, 0x131F,0x0000,0x0000, 0x1320,0x0000,0x0000,
0x1321,0x0000,0x0000, 0x1322,0x0000,0x0000, 0x1323,0x0000,0x0000,
0x1324,0x0000,0x0000, 0x1325,0x0000,0x0000, 0x1326,0x0000,0x0000,
0x1327,0x0000,0x0000, 0x1328,0x0000,0x0000, 0x1329,0x0000,0x0000,
0x132A,0x0000,0x0000, 0x132B,0x0000,0x0000, 0x132C,0x0000,0x0000,
0x132D,0x0000,0x0000, 0x132E,0x0000,0x0000, 0x132F,0x0000,0x0000,
0xFBC0,0x8557,0x0000, 0xFBC0,0x8558,0x0000, 0x1330,0x0000,0x0000,
0x02EC,0x0000,0x0000, 0x02ED,0x0000,0x0000, 0x0253,0x0000,0x0000,
0x0230,0x0000,0x0000, 0x0257,0x0000,0x0000, 0x02EE,0x0000,0x0000,
0xFBC0,0x8560,0x0000, 0x130A,0x0000,0x0000, 0x130B,0x0000,0x0000,
0x130C,0x0000,0x0000, 0x130D,0x0000,0x0000, 0x130E,0x0000,0x0000,
0x130F,0x0000,0x0000, 0x1310,0x0000,0x0000, 0x1311,0x0000,0x0000,
0x1312,0x0000,0x0000, 0x1313,0x0000,0x0000, 0x1314,0x0000,0x0000,
0x1315,0x0000,0x0000, 0x1316,0x0000,0x0000, 0x1317,0x0000,0x0000,
0x1318,0x0000,0x0000, 0x1319,0x0000,0x0000, 0x131A,0x0000,0x0000,
0x131B,0x0000,0x0000, 0x131C,0x0000,0x0000, 0x131D,0x0000,0x0000,
0x131E,0x0000,0x0000, 0x131F,0x0000,0x0000, 0x1320,0x0000,0x0000,
0x1321,0x0000,0x0000, 0x1322,0x0000,0x0000, 0x1323,0x0000,0x0000,
0x1324,0x0000,0x0000, 0x1325,0x0000,0x0000, 0x1326,0x0000,0x0000,
0x1327,0x0000,0x0000, 0x1328,0x0000,0x0000, 0x1329,0x0000,0x0000,
0x132A,0x0000,0x0000, 0x132B,0x0000,0x0000, 0x132C,0x0000,0x0000,
0x132D,0x0000,0x0000, 0x132E,0x0000,0x0000, 0x132F,0x0000,0x0000,
0x130E,0x132B,0x0000, 0xFBC0,0x8588,0x0000, 0x023E,0x0000,0x0000,
0x0222,0x0000,0x0000, 0xFBC0,0x858B,0x0000, 0xFBC0,0x858C,0x0000,
0xFBC0,0x858D,0x0000, 0xFBC0,0x858E,0x0000, 0xFBC0,0x858F,0x0000,
0xFBC0,0x8590,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x85A2,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x85BA,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x02EF,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x02F0,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x02F1,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x85C5,0x0000,
0xFBC0,0x85C6,0x0000, 0xFBC0,0x85C7,0x0000, 0xFBC0,0x85C8,0x0000,
0xFBC0,0x85C9,0x0000, 0xFBC0,0x85CA,0x0000, 0xFBC0,0x85CB,0x0000,
0xFBC0,0x85CC,0x0000, 0xFBC0,0x85CD,0x0000, 0xFBC0,0x85CE,0x0000,
0xFBC0,0x85CF,0x0000, 0x1331,0x0000,0x0000, 0x1332,0x0000,0x0000,
0x1333,0x0000,0x0000, 0x1334,0x0000,0x0000, 0x1335,0x0000,0x0000,
0x1336,0x0000,0x0000, 0x1337,0x0000,0x0000, 0x1338,0x0000,0x0000,
0x1339,0x0000,0x0000, 0x133A,0x0000,0x0000, 0x133B,0x0000,0x0000,
0x133B,0x0000,0x0000, 0x133C,0x0000,0x0000, 0x133D,0x0000,0x0000,
0x133D,0x0000,0x0000, 0x133E,0x0000,0x0000, 0x133E,0x0000,0x0000,
0x133F,0x0000,0x0000, 0x1340,0x0000,0x0000, 0x1341,0x0000,0x0000,
0x1341,0x0000,0x0000, 0x1342,0x0000,0x0000, 0x1342,0x0000,0x0000,
0x1343,0x0000,0x0000, 0x1344,0x0000,0x0000, 0x1345,0x0000,0x0000,
0x1346,0x0000,0x0000, 0xFBC0,0x85EB,0x0000, 0xFBC0,0x85EC,0x0000,
0xFBC0,0x85ED,0x0000, 0xFBC0,0x85EE,0x0000, 0xFBC0,0x85EF,0x0000,
0x1336,0x1336,0x0000, 0x1336,0x133A,0x0000, 0x133A,0x133A,0x0000,
0x02F2,0x0000,0x0000, 0x02F3,0x0000,0x0000, 0xFBC0,0x85F5,0x0000,
0xFBC0,0x85F6,0x0000, 0xFBC0,0x85F7,0x0000, 0xFBC0,0x85F8,0x0000,
0xFBC0,0x85F9,0x0000, 0xFBC0,0x85FA,0x0000, 0xFBC0,0x85FB,0x0000,
0xFBC0,0x85FC,0x0000, 0xFBC0,0x85FD,0x0000, 0xFBC0,0x85FE,0x0000,
0xFBC0,0x85FF,0x0000 };

uint16 page006data[]= { /* 0600 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8604,0x0000, 0xFBC0,0x8605,0x0000,
0xFBC0,0x8606,0x0000, 0xFBC0,0x8607,0x0000, 0xFBC0,0x8608,0x0000,
0xFBC0,0x8609,0x0000, 0xFBC0,0x860A,0x0000, 0xFBC0,0x860B,0x0000,
0x0231,0x0000,0x0000, 0x0232,0x0000,0x0000, 0x034C,0x0000,0x0000,
0x034D,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8616,0x0000, 0xFBC0,0x8617,0x0000,
0xFBC0,0x8618,0x0000, 0xFBC0,0x8619,0x0000, 0xFBC0,0x861A,0x0000,
0x023B,0x0000,0x0000, 0xFBC0,0x861C,0x0000, 0xFBC0,0x861D,0x0000,
0xFBC0,0x861E,0x0000, 0x0258,0x0000,0x0000, 0xFBC0,0x8620,0x0000,
0x1347,0x0000,0x0000, 0x1348,0x0000,0x0000, 0x1349,0x0000,0x0000,
0x134C,0x0000,0x0000, 0x134D,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x1350,0x0000,0x0000, 0x1352,0x0000,0x0000, 0x1356,0x0000,0x0000,
0x1357,0x0000,0x0000, 0x1358,0x0000,0x0000, 0x135E,0x0000,0x0000,
0x1364,0x0000,0x0000, 0x1365,0x0000,0x0000, 0x1369,0x0000,0x0000,
0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000, 0x1376,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x1390,0x0000,0x0000, 0xFBC0,0x863B,0x0000,
0xFBC0,0x863C,0x0000, 0xFBC0,0x863D,0x0000, 0xFBC0,0x863E,0x0000,
0xFBC0,0x863F,0x0000, 0x020B,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13BD,0x0000,0x0000, 0x13C7,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0xFBC0,0x8659,0x0000,
0xFBC0,0x865A,0x0000, 0xFBC0,0x865B,0x0000, 0xFBC0,0x865C,0x0000,
0xFBC0,0x865D,0x0000, 0xFBC0,0x865E,0x0000, 0xFBC0,0x865F,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x02D4,0x0000,0x0000, 0x0233,0x0000,0x0000,
0x0234,0x0000,0x0000, 0x02CB,0x0000,0x0000, 0x1351,0x0000,0x0000,
0x139A,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x134B,0x0000,0x0000,
0x134A,0x0000,0x0000, 0x134E,0x0000,0x0000, 0x1347,0x0000,0x0000,
0x1350,0x1347,0x0000, 0x13BD,0x1347,0x0000, 0x13C1,0x1347,0x0000,
0x13C8,0x1347,0x0000, 0x1359,0x0000,0x0000, 0x135A,0x0000,0x0000,
0x1353,0x0000,0x0000, 0x135B,0x0000,0x0000, 0x135C,0x0000,0x0000,
0x1354,0x0000,0x0000, 0x135D,0x0000,0x0000, 0x1355,0x0000,0x0000,
0x1366,0x0000,0x0000, 0x1367,0x0000,0x0000, 0x135F,0x0000,0x0000,
0x1360,0x0000,0x0000, 0x1368,0x0000,0x0000, 0x1361,0x0000,0x0000,
0x1363,0x0000,0x0000, 0x136B,0x0000,0x0000, 0x136C,0x0000,0x0000,
0x136D,0x0000,0x0000, 0x136E,0x0000,0x0000, 0x136F,0x0000,0x0000,
0x1370,0x0000,0x0000, 0x1371,0x0000,0x0000, 0x1372,0x0000,0x0000,
0x1373,0x0000,0x0000, 0x1377,0x0000,0x0000, 0x1378,0x0000,0x0000,
0x1379,0x0000,0x0000, 0x137A,0x0000,0x0000, 0x137B,0x0000,0x0000,
0x137C,0x0000,0x0000, 0x137D,0x0000,0x0000, 0x137E,0x0000,0x0000,
0x137F,0x0000,0x0000, 0x1383,0x0000,0x0000, 0x1384,0x0000,0x0000,
0x1385,0x0000,0x0000, 0x1389,0x0000,0x0000, 0x138A,0x0000,0x0000,
0x138E,0x0000,0x0000, 0x1391,0x0000,0x0000, 0x1394,0x0000,0x0000,
0x1395,0x0000,0x0000, 0x1396,0x0000,0x0000, 0x1397,0x0000,0x0000,
0x1398,0x0000,0x0000, 0x1399,0x0000,0x0000, 0x139C,0x0000,0x0000,
0x139D,0x0000,0x0000, 0x139F,0x0000,0x0000, 0x13A0,0x0000,0x0000,
0x13A1,0x0000,0x0000, 0x13A2,0x0000,0x0000, 0x13A3,0x0000,0x0000,
0x13A4,0x0000,0x0000, 0x13A5,0x0000,0x0000, 0x13A6,0x0000,0x0000,
0x13A7,0x0000,0x0000, 0x13A8,0x0000,0x0000, 0x13A9,0x0000,0x0000,
0x13AA,0x0000,0x0000, 0x13AC,0x0000,0x0000, 0x13AD,0x0000,0x0000,
0x13AE,0x0000,0x0000, 0x13AF,0x0000,0x0000, 0x13B6,0x0000,0x0000,
0x13B2,0x0000,0x0000, 0x13B3,0x0000,0x0000, 0x13B4,0x0000,0x0000,
0x13B5,0x0000,0x0000, 0x13B8,0x0000,0x0000, 0x1362,0x0000,0x0000,
0x13BC,0x0000,0x0000, 0x13B9,0x0000,0x0000, 0x13B9,0x0000,0x0000,
0x13BA,0x0000,0x0000, 0x13BE,0x0000,0x0000, 0x13BF,0x0000,0x0000,
0x13C0,0x0000,0x0000, 0x13C1,0x0000,0x0000, 0x13C2,0x0000,0x0000,
0x13C3,0x0000,0x0000, 0x13C4,0x0000,0x0000, 0x13C5,0x0000,0x0000,
0x13C9,0x0000,0x0000, 0x13CA,0x0000,0x0000, 0x13CB,0x0000,0x0000,
0x13C6,0x0000,0x0000, 0x13CC,0x0000,0x0000, 0x13CD,0x0000,0x0000,
0x13CE,0x0000,0x0000, 0x13CE,0x0000,0x0000, 0x025F,0x0000,0x0000,
0x13BC,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x13BD,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x034E,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1374,0x0000,0x0000, 0x1380,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x1386,0x0000,0x0000, 0x138B,0x0000,0x0000,
0x1392,0x0000,0x0000, 0x1347,0x0000,0x0000, 0x13B0,0x0000,0x0000,
0x13BB,0x0000,0x0000 };

uint16 page007data[]= { /* 0700 (3 weights per char) */
0x0270,0x0000,0x0000, 0x0260,0x0000,0x0000, 0x0261,0x0000,0x0000,
0x023F,0x0000,0x0000, 0x0240,0x0000,0x0000, 0x0241,0x0000,0x0000,
0x0242,0x0000,0x0000, 0x0243,0x0000,0x0000, 0x0244,0x0000,0x0000,
0x0259,0x0000,0x0000, 0x02F4,0x0000,0x0000, 0x02F5,0x0000,0x0000,
0x02F6,0x0000,0x0000, 0x02F7,0x0000,0x0000, 0xFBC0,0x870E,0x0000,
0x0000,0x0000,0x0000, 0x13CF,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x13D0,0x0000,0x0000, 0x13D1,0x0000,0x0000, 0x13D1,0x0000,0x0000,
0x13D3,0x0000,0x0000, 0x13D2,0x0000,0x0000, 0x13D4,0x0000,0x0000,
0x13D5,0x0000,0x0000, 0x13D6,0x0000,0x0000, 0x13D8,0x0000,0x0000,
0x13D9,0x0000,0x0000, 0x13D9,0x0000,0x0000, 0x13DA,0x0000,0x0000,
0x13DB,0x0000,0x0000, 0x13DC,0x0000,0x0000, 0x13DE,0x0000,0x0000,
0x13DF,0x0000,0x0000, 0x13E0,0x0000,0x0000, 0x13E1,0x0000,0x0000,
0x13E1,0x0000,0x0000, 0x13E2,0x0000,0x0000, 0x13E3,0x0000,0x0000,
0x13E3,0x0000,0x0000, 0x13E5,0x0000,0x0000, 0x13E6,0x0000,0x0000,
0x13E7,0x0000,0x0000, 0x13E8,0x0000,0x0000, 0x13E9,0x0000,0x0000,
0x13D0,0x0000,0x0000, 0x13D1,0x0000,0x0000, 0x13D3,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x874B,0x0000, 0xFBC0,0x874C,0x0000, 0x13D7,0x0000,0x0000,
0x13DD,0x0000,0x0000, 0x13E4,0x0000,0x0000, 0xFBC0,0x8750,0x0000,
0xFBC0,0x8751,0x0000, 0xFBC0,0x8752,0x0000, 0xFBC0,0x8753,0x0000,
0xFBC0,0x8754,0x0000, 0xFBC0,0x8755,0x0000, 0xFBC0,0x8756,0x0000,
0xFBC0,0x8757,0x0000, 0xFBC0,0x8758,0x0000, 0xFBC0,0x8759,0x0000,
0xFBC0,0x875A,0x0000, 0xFBC0,0x875B,0x0000, 0xFBC0,0x875C,0x0000,
0xFBC0,0x875D,0x0000, 0xFBC0,0x875E,0x0000, 0xFBC0,0x875F,0x0000,
0xFBC0,0x8760,0x0000, 0xFBC0,0x8761,0x0000, 0xFBC0,0x8762,0x0000,
0xFBC0,0x8763,0x0000, 0xFBC0,0x8764,0x0000, 0xFBC0,0x8765,0x0000,
0xFBC0,0x8766,0x0000, 0xFBC0,0x8767,0x0000, 0xFBC0,0x8768,0x0000,
0xFBC0,0x8769,0x0000, 0xFBC0,0x876A,0x0000, 0xFBC0,0x876B,0x0000,
0xFBC0,0x876C,0x0000, 0xFBC0,0x876D,0x0000, 0xFBC0,0x876E,0x0000,
0xFBC0,0x876F,0x0000, 0xFBC0,0x8770,0x0000, 0xFBC0,0x8771,0x0000,
0xFBC0,0x8772,0x0000, 0xFBC0,0x8773,0x0000, 0xFBC0,0x8774,0x0000,
0xFBC0,0x8775,0x0000, 0xFBC0,0x8776,0x0000, 0xFBC0,0x8777,0x0000,
0xFBC0,0x8778,0x0000, 0xFBC0,0x8779,0x0000, 0xFBC0,0x877A,0x0000,
0xFBC0,0x877B,0x0000, 0xFBC0,0x877C,0x0000, 0xFBC0,0x877D,0x0000,
0xFBC0,0x877E,0x0000, 0xFBC0,0x877F,0x0000, 0x13EA,0x0000,0x0000,
0x13ED,0x0000,0x0000, 0x13EE,0x0000,0x0000, 0x13EF,0x0000,0x0000,
0x13F1,0x0000,0x0000, 0x13F2,0x0000,0x0000, 0x13F3,0x0000,0x0000,
0x13F4,0x0000,0x0000, 0x13F7,0x0000,0x0000, 0x13F9,0x0000,0x0000,
0x13FA,0x0000,0x0000, 0x13FB,0x0000,0x0000, 0x13FD,0x0000,0x0000,
0x1401,0x0000,0x0000, 0x1402,0x0000,0x0000, 0x1404,0x0000,0x0000,
0x1405,0x0000,0x0000, 0x1409,0x0000,0x0000, 0x140A,0x0000,0x0000,
0x140B,0x0000,0x0000, 0x140C,0x0000,0x0000, 0x140D,0x0000,0x0000,
0x140E,0x0000,0x0000, 0x140F,0x0000,0x0000, 0x13FE,0x0000,0x0000,
0x13EB,0x0000,0x0000, 0x13EC,0x0000,0x0000, 0x13FC,0x0000,0x0000,
0x13F0,0x0000,0x0000, 0x1406,0x0000,0x0000, 0x1407,0x0000,0x0000,
0x1408,0x0000,0x0000, 0x13FF,0x0000,0x0000, 0x1400,0x0000,0x0000,
0x13F5,0x0000,0x0000, 0x13F6,0x0000,0x0000, 0x1403,0x0000,0x0000,
0x13F8,0x0000,0x0000, 0x1411,0x0000,0x0000, 0x1412,0x0000,0x0000,
0x1413,0x0000,0x0000, 0x1414,0x0000,0x0000, 0x1415,0x0000,0x0000,
0x1416,0x0000,0x0000, 0x1417,0x0000,0x0000, 0x1418,0x0000,0x0000,
0x1419,0x0000,0x0000, 0x141A,0x0000,0x0000, 0x141B,0x0000,0x0000,
0x1410,0x0000,0x0000, 0xFBC0,0x87B2,0x0000, 0xFBC0,0x87B3,0x0000,
0xFBC0,0x87B4,0x0000, 0xFBC0,0x87B5,0x0000, 0xFBC0,0x87B6,0x0000,
0xFBC0,0x87B7,0x0000, 0xFBC0,0x87B8,0x0000, 0xFBC0,0x87B9,0x0000,
0xFBC0,0x87BA,0x0000, 0xFBC0,0x87BB,0x0000, 0xFBC0,0x87BC,0x0000,
0xFBC0,0x87BD,0x0000, 0xFBC0,0x87BE,0x0000, 0xFBC0,0x87BF,0x0000,
0xFBC0,0x87C0,0x0000, 0xFBC0,0x87C1,0x0000, 0xFBC0,0x87C2,0x0000,
0xFBC0,0x87C3,0x0000, 0xFBC0,0x87C4,0x0000, 0xFBC0,0x87C5,0x0000,
0xFBC0,0x87C6,0x0000, 0xFBC0,0x87C7,0x0000, 0xFBC0,0x87C8,0x0000,
0xFBC0,0x87C9,0x0000, 0xFBC0,0x87CA,0x0000, 0xFBC0,0x87CB,0x0000,
0xFBC0,0x87CC,0x0000, 0xFBC0,0x87CD,0x0000, 0xFBC0,0x87CE,0x0000,
0xFBC0,0x87CF,0x0000, 0xFBC0,0x87D0,0x0000, 0xFBC0,0x87D1,0x0000,
0xFBC0,0x87D2,0x0000, 0xFBC0,0x87D3,0x0000, 0xFBC0,0x87D4,0x0000,
0xFBC0,0x87D5,0x0000, 0xFBC0,0x87D6,0x0000, 0xFBC0,0x87D7,0x0000,
0xFBC0,0x87D8,0x0000, 0xFBC0,0x87D9,0x0000, 0xFBC0,0x87DA,0x0000,
0xFBC0,0x87DB,0x0000, 0xFBC0,0x87DC,0x0000, 0xFBC0,0x87DD,0x0000,
0xFBC0,0x87DE,0x0000, 0xFBC0,0x87DF,0x0000, 0xFBC0,0x87E0,0x0000,
0xFBC0,0x87E1,0x0000, 0xFBC0,0x87E2,0x0000, 0xFBC0,0x87E3,0x0000,
0xFBC0,0x87E4,0x0000, 0xFBC0,0x87E5,0x0000, 0xFBC0,0x87E6,0x0000,
0xFBC0,0x87E7,0x0000, 0xFBC0,0x87E8,0x0000, 0xFBC0,0x87E9,0x0000,
0xFBC0,0x87EA,0x0000, 0xFBC0,0x87EB,0x0000, 0xFBC0,0x87EC,0x0000,
0xFBC0,0x87ED,0x0000, 0xFBC0,0x87EE,0x0000, 0xFBC0,0x87EF,0x0000,
0xFBC0,0x87F0,0x0000, 0xFBC0,0x87F1,0x0000, 0xFBC0,0x87F2,0x0000,
0xFBC0,0x87F3,0x0000, 0xFBC0,0x87F4,0x0000, 0xFBC0,0x87F5,0x0000,
0xFBC0,0x87F6,0x0000, 0xFBC0,0x87F7,0x0000, 0xFBC0,0x87F8,0x0000,
0xFBC0,0x87F9,0x0000, 0xFBC0,0x87FA,0x0000, 0xFBC0,0x87FB,0x0000,
0xFBC0,0x87FC,0x0000, 0xFBC0,0x87FD,0x0000, 0xFBC0,0x87FE,0x0000,
0xFBC0,0x87FF,0x0000 };

uint16 page009data[]= { /* 0900 (3 weights per char) */
0xFBC0,0x8900,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x155A,0x0000,0x0000, 0x155B,0x0000,0x0000,
0x155C,0x0000,0x0000, 0x155D,0x0000,0x0000, 0x155E,0x0000,0x0000,
0x155F,0x0000,0x0000, 0x1560,0x0000,0x0000, 0x1561,0x0000,0x0000,
0x1563,0x0000,0x0000, 0x1565,0x0000,0x0000, 0x1566,0x0000,0x0000,
0x1567,0x0000,0x0000, 0x1568,0x0000,0x0000, 0x1569,0x0000,0x0000,
0x156A,0x0000,0x0000, 0x156B,0x0000,0x0000, 0x156C,0x0000,0x0000,
0x156D,0x0000,0x0000, 0x156E,0x0000,0x0000, 0x156F,0x0000,0x0000,
0x1570,0x0000,0x0000, 0x1571,0x0000,0x0000, 0x1572,0x0000,0x0000,
0x1573,0x0000,0x0000, 0x1574,0x0000,0x0000, 0x1575,0x0000,0x0000,
0x1576,0x0000,0x0000, 0x1577,0x0000,0x0000, 0x1578,0x0000,0x0000,
0x1579,0x0000,0x0000, 0x157A,0x0000,0x0000, 0x157B,0x0000,0x0000,
0x157C,0x0000,0x0000, 0x157D,0x0000,0x0000, 0x157E,0x0000,0x0000,
0x157F,0x0000,0x0000, 0x1580,0x0000,0x0000, 0x1580,0x0000,0x0000,
0x1581,0x0000,0x0000, 0x1582,0x0000,0x0000, 0x1583,0x0000,0x0000,
0x1584,0x0000,0x0000, 0x1585,0x0000,0x0000, 0x1586,0x0000,0x0000,
0x1587,0x0000,0x0000, 0x1587,0x0000,0x0000, 0x1588,0x0000,0x0000,
0x1589,0x0000,0x0000, 0x1589,0x0000,0x0000, 0x158A,0x0000,0x0000,
0x158B,0x0000,0x0000, 0x158C,0x0000,0x0000, 0x158D,0x0000,0x0000,
0x158E,0x0000,0x0000, 0xFBC0,0x893A,0x0000, 0xFBC0,0x893B,0x0000,
0x0000,0x0000,0x0000, 0x158F,0x0000,0x0000, 0x1590,0x0000,0x0000,
0x1591,0x0000,0x0000, 0x1592,0x0000,0x0000, 0x1593,0x0000,0x0000,
0x1594,0x0000,0x0000, 0x1595,0x0000,0x0000, 0x1596,0x0000,0x0000,
0x1599,0x0000,0x0000, 0x159A,0x0000,0x0000, 0x159B,0x0000,0x0000,
0x159C,0x0000,0x0000, 0x159D,0x0000,0x0000, 0x159E,0x0000,0x0000,
0x159F,0x0000,0x0000, 0x15A0,0x0000,0x0000, 0x15A1,0x0000,0x0000,
0xFBC0,0x894E,0x0000, 0xFBC0,0x894F,0x0000, 0x1559,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8955,0x0000, 0xFBC0,0x8956,0x0000,
0xFBC0,0x8957,0x0000, 0x156D,0x0000,0x0000, 0x156E,0x0000,0x0000,
0x156F,0x0000,0x0000, 0x1574,0x0000,0x0000, 0x1579,0x0000,0x0000,
0x157A,0x0000,0x0000, 0x1582,0x0000,0x0000, 0x1586,0x0000,0x0000,
0x1562,0x0000,0x0000, 0x1564,0x0000,0x0000, 0x1597,0x0000,0x0000,
0x1598,0x0000,0x0000, 0x0268,0x0000,0x0000, 0x0269,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x02FA,0x0000,0x0000, 0xFBC0,0x8971,0x0000,
0xFBC0,0x8972,0x0000, 0xFBC0,0x8973,0x0000, 0xFBC0,0x8974,0x0000,
0xFBC0,0x8975,0x0000, 0xFBC0,0x8976,0x0000, 0xFBC0,0x8977,0x0000,
0xFBC0,0x8978,0x0000, 0xFBC0,0x8979,0x0000, 0xFBC0,0x897A,0x0000,
0xFBC0,0x897B,0x0000, 0xFBC0,0x897C,0x0000, 0xFBC0,0x897D,0x0000,
0xFBC0,0x897E,0x0000, 0xFBC0,0x897F,0x0000, 0xFBC0,0x8980,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8984,0x0000, 0x15A2,0x0000,0x0000, 0x15A3,0x0000,0x0000,
0x15A4,0x0000,0x0000, 0x15A5,0x0000,0x0000, 0x15A6,0x0000,0x0000,
0x15A7,0x0000,0x0000, 0x15A8,0x0000,0x0000, 0x15AA,0x0000,0x0000,
0xFBC0,0x898D,0x0000, 0xFBC0,0x898E,0x0000, 0x15AC,0x0000,0x0000,
0x15AD,0x0000,0x0000, 0xFBC0,0x8991,0x0000, 0xFBC0,0x8992,0x0000,
0x15AE,0x0000,0x0000, 0x15AF,0x0000,0x0000, 0x15B0,0x0000,0x0000,
0x15B1,0x0000,0x0000, 0x15B2,0x0000,0x0000, 0x15B3,0x0000,0x0000,
0x15B4,0x0000,0x0000, 0x15B5,0x0000,0x0000, 0x15B6,0x0000,0x0000,
0x15B7,0x0000,0x0000, 0x15B8,0x0000,0x0000, 0x15B9,0x0000,0x0000,
0x15BA,0x0000,0x0000, 0x15BB,0x0000,0x0000, 0x15BC,0x0000,0x0000,
0x15BD,0x0000,0x0000, 0x15BE,0x0000,0x0000, 0x15BF,0x0000,0x0000,
0x15C0,0x0000,0x0000, 0x15C1,0x0000,0x0000, 0x15C2,0x0000,0x0000,
0x15C3,0x0000,0x0000, 0xFBC0,0x89A9,0x0000, 0x15C4,0x0000,0x0000,
0x15C5,0x0000,0x0000, 0x15C6,0x0000,0x0000, 0x15C7,0x0000,0x0000,
0x15C8,0x0000,0x0000, 0x15C9,0x0000,0x0000, 0x15CA,0x0000,0x0000,
0xFBC0,0x89B1,0x0000, 0x15CC,0x0000,0x0000, 0xFBC0,0x89B3,0x0000,
0xFBC0,0x89B4,0x0000, 0xFBC0,0x89B5,0x0000, 0x15CE,0x0000,0x0000,
0x15CF,0x0000,0x0000, 0x15D0,0x0000,0x0000, 0x15D1,0x0000,0x0000,
0xFBC0,0x89BA,0x0000, 0xFBC0,0x89BB,0x0000, 0x0000,0x0000,0x0000,
0x15D2,0x0000,0x0000, 0x15D3,0x0000,0x0000, 0x15D4,0x0000,0x0000,
0x15D5,0x0000,0x0000, 0x15D6,0x0000,0x0000, 0x15D7,0x0000,0x0000,
0x15D8,0x0000,0x0000, 0x15D9,0x0000,0x0000, 0xFBC0,0x89C5,0x0000,
0xFBC0,0x89C6,0x0000, 0x15DC,0x0000,0x0000, 0x15DD,0x0000,0x0000,
0xFBC0,0x89C9,0x0000, 0xFBC0,0x89CA,0x0000, 0x15DE,0x0000,0x0000,
0x15DF,0x0000,0x0000, 0x15E0,0x0000,0x0000, 0xFBC0,0x89CE,0x0000,
0xFBC0,0x89CF,0x0000, 0xFBC0,0x89D0,0x0000, 0xFBC0,0x89D1,0x0000,
0xFBC0,0x89D2,0x0000, 0xFBC0,0x89D3,0x0000, 0xFBC0,0x89D4,0x0000,
0xFBC0,0x89D5,0x0000, 0xFBC0,0x89D6,0x0000, 0x15E1,0x0000,0x0000,
0xFBC0,0x89D8,0x0000, 0xFBC0,0x89D9,0x0000, 0xFBC0,0x89DA,0x0000,
0xFBC0,0x89DB,0x0000, 0x15BC,0x0000,0x0000, 0x15BD,0x0000,0x0000,
0xFBC0,0x89DE,0x0000, 0x15C9,0x0000,0x0000, 0x15A9,0x0000,0x0000,
0x15AB,0x0000,0x0000, 0x15DA,0x0000,0x0000, 0x15DB,0x0000,0x0000,
0xFBC0,0x89E4,0x0000, 0xFBC0,0x89E5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x15CB,0x0000,0x0000, 0x15CD,0x0000,0x0000, 0x0E12,0x0000,0x0000,
0x0E13,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0DC7,0x0000,0x0000,
0x0DC8,0x0000,0x0000, 0x0350,0x0000,0x0000, 0xFBC0,0x89FB,0x0000,
0xFBC0,0x89FC,0x0000, 0xFBC0,0x89FD,0x0000, 0xFBC0,0x89FE,0x0000,
0xFBC0,0x89FF,0x0000 };

uint16 page00Adata[]= { /* 0A00 (3 weights per char) */
0xFBC0,0x8A00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8A04,0x0000, 0x15E7,0x0000,0x0000,
0x15E8,0x0000,0x0000, 0x15EC,0x0000,0x0000, 0x15ED,0x0000,0x0000,
0x15E4,0x0000,0x0000, 0x15E5,0x0000,0x0000, 0xFBC0,0x8A0B,0x0000,
0xFBC0,0x8A0C,0x0000, 0xFBC0,0x8A0D,0x0000, 0xFBC0,0x8A0E,0x0000,
0x15EE,0x0000,0x0000, 0x15E9,0x0000,0x0000, 0xFBC0,0x8A11,0x0000,
0xFBC0,0x8A12,0x0000, 0x15E6,0x0000,0x0000, 0x15EA,0x0000,0x0000,
0x15F1,0x0000,0x0000, 0x15F2,0x0000,0x0000, 0x15F3,0x0000,0x0000,
0x15F4,0x0000,0x0000, 0x15F5,0x0000,0x0000, 0x15F6,0x0000,0x0000,
0x15F7,0x0000,0x0000, 0x15F8,0x0000,0x0000, 0x15F9,0x0000,0x0000,
0x15FA,0x0000,0x0000, 0x15FB,0x0000,0x0000, 0x15FC,0x0000,0x0000,
0x15FD,0x0000,0x0000, 0x15FE,0x0000,0x0000, 0x15FF,0x0000,0x0000,
0x1600,0x0000,0x0000, 0x1601,0x0000,0x0000, 0x1602,0x0000,0x0000,
0x1603,0x0000,0x0000, 0x1604,0x0000,0x0000, 0xFBC0,0x8A29,0x0000,
0x1605,0x0000,0x0000, 0x1606,0x0000,0x0000, 0x1607,0x0000,0x0000,
0x1608,0x0000,0x0000, 0x1609,0x0000,0x0000, 0x160A,0x0000,0x0000,
0x160B,0x0000,0x0000, 0xFBC0,0x8A31,0x0000, 0x160C,0x0000,0x0000,
0x160C,0x0000,0x0000, 0xFBC0,0x8A34,0x0000, 0x160D,0x0000,0x0000,
0x15EF,0x0000,0x0000, 0xFBC0,0x8A37,0x0000, 0x15EF,0x0000,0x0000,
0x15F0,0x0000,0x0000, 0xFBC0,0x8A3A,0x0000, 0xFBC0,0x8A3B,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8A3D,0x0000, 0x160F,0x0000,0x0000,
0x1610,0x0000,0x0000, 0x1611,0x0000,0x0000, 0x1612,0x0000,0x0000,
0x1613,0x0000,0x0000, 0xFBC0,0x8A43,0x0000, 0xFBC0,0x8A44,0x0000,
0xFBC0,0x8A45,0x0000, 0xFBC0,0x8A46,0x0000, 0x1614,0x0000,0x0000,
0x1615,0x0000,0x0000, 0xFBC0,0x8A49,0x0000, 0xFBC0,0x8A4A,0x0000,
0x1616,0x0000,0x0000, 0x1617,0x0000,0x0000, 0x1618,0x0000,0x0000,
0xFBC0,0x8A4E,0x0000, 0xFBC0,0x8A4F,0x0000, 0xFBC0,0x8A50,0x0000,
0xFBC0,0x8A51,0x0000, 0xFBC0,0x8A52,0x0000, 0xFBC0,0x8A53,0x0000,
0xFBC0,0x8A54,0x0000, 0xFBC0,0x8A55,0x0000, 0xFBC0,0x8A56,0x0000,
0xFBC0,0x8A57,0x0000, 0xFBC0,0x8A58,0x0000, 0x15F2,0x0000,0x0000,
0x15F3,0x0000,0x0000, 0x15F8,0x0000,0x0000, 0x160E,0x0000,0x0000,
0xFBC0,0x8A5D,0x0000, 0x1606,0x0000,0x0000, 0xFBC0,0x8A5F,0x0000,
0xFBC0,0x8A60,0x0000, 0xFBC0,0x8A61,0x0000, 0xFBC0,0x8A62,0x0000,
0xFBC0,0x8A63,0x0000, 0xFBC0,0x8A64,0x0000, 0xFBC0,0x8A65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x15EB,0x0000,0x0000, 0x15E3,0x0000,0x0000, 0x15E2,0x0000,0x0000,
0xFBC0,0x8A75,0x0000, 0xFBC0,0x8A76,0x0000, 0xFBC0,0x8A77,0x0000,
0xFBC0,0x8A78,0x0000, 0xFBC0,0x8A79,0x0000, 0xFBC0,0x8A7A,0x0000,
0xFBC0,0x8A7B,0x0000, 0xFBC0,0x8A7C,0x0000, 0xFBC0,0x8A7D,0x0000,
0xFBC0,0x8A7E,0x0000, 0xFBC0,0x8A7F,0x0000, 0xFBC0,0x8A80,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8A84,0x0000, 0x161A,0x0000,0x0000, 0x161B,0x0000,0x0000,
0x161C,0x0000,0x0000, 0x161D,0x0000,0x0000, 0x161E,0x0000,0x0000,
0x161F,0x0000,0x0000, 0x1620,0x0000,0x0000, 0x1622,0x0000,0x0000,
0x1624,0x0000,0x0000, 0xFBC0,0x8A8E,0x0000, 0x1625,0x0000,0x0000,
0x1626,0x0000,0x0000, 0x1627,0x0000,0x0000, 0xFBC0,0x8A92,0x0000,
0x1628,0x0000,0x0000, 0x1629,0x0000,0x0000, 0x162A,0x0000,0x0000,
0x162B,0x0000,0x0000, 0x162C,0x0000,0x0000, 0x162D,0x0000,0x0000,
0x162E,0x0000,0x0000, 0x162F,0x0000,0x0000, 0x1630,0x0000,0x0000,
0x1631,0x0000,0x0000, 0x1632,0x0000,0x0000, 0x1633,0x0000,0x0000,
0x1634,0x0000,0x0000, 0x1635,0x0000,0x0000, 0x1636,0x0000,0x0000,
0x1637,0x0000,0x0000, 0x1638,0x0000,0x0000, 0x1639,0x0000,0x0000,
0x163A,0x0000,0x0000, 0x163B,0x0000,0x0000, 0x163C,0x0000,0x0000,
0x163D,0x0000,0x0000, 0xFBC0,0x8AA9,0x0000, 0x163E,0x0000,0x0000,
0x163F,0x0000,0x0000, 0x1640,0x0000,0x0000, 0x1641,0x0000,0x0000,
0x1642,0x0000,0x0000, 0x1643,0x0000,0x0000, 0x1644,0x0000,0x0000,
0xFBC0,0x8AB1,0x0000, 0x1645,0x0000,0x0000, 0x1646,0x0000,0x0000,
0xFBC0,0x8AB4,0x0000, 0x1647,0x0000,0x0000, 0x1648,0x0000,0x0000,
0x1649,0x0000,0x0000, 0x164A,0x0000,0x0000, 0x164B,0x0000,0x0000,
0xFBC0,0x8ABA,0x0000, 0xFBC0,0x8ABB,0x0000, 0x0000,0x0000,0x0000,
0x164C,0x0000,0x0000, 0x164D,0x0000,0x0000, 0x164E,0x0000,0x0000,
0x164F,0x0000,0x0000, 0x1650,0x0000,0x0000, 0x1651,0x0000,0x0000,
0x1652,0x0000,0x0000, 0x1653,0x0000,0x0000, 0x1656,0x0000,0x0000,
0xFBC0,0x8AC6,0x0000, 0x1657,0x0000,0x0000, 0x1658,0x0000,0x0000,
0x1659,0x0000,0x0000, 0xFBC0,0x8ACA,0x0000, 0x165A,0x0000,0x0000,
0x165B,0x0000,0x0000, 0x165C,0x0000,0x0000, 0xFBC0,0x8ACE,0x0000,
0xFBC0,0x8ACF,0x0000, 0x1619,0x0000,0x0000, 0xFBC0,0x8AD1,0x0000,
0xFBC0,0x8AD2,0x0000, 0xFBC0,0x8AD3,0x0000, 0xFBC0,0x8AD4,0x0000,
0xFBC0,0x8AD5,0x0000, 0xFBC0,0x8AD6,0x0000, 0xFBC0,0x8AD7,0x0000,
0xFBC0,0x8AD8,0x0000, 0xFBC0,0x8AD9,0x0000, 0xFBC0,0x8ADA,0x0000,
0xFBC0,0x8ADB,0x0000, 0xFBC0,0x8ADC,0x0000, 0xFBC0,0x8ADD,0x0000,
0xFBC0,0x8ADE,0x0000, 0xFBC0,0x8ADF,0x0000, 0x1621,0x0000,0x0000,
0x1623,0x0000,0x0000, 0x1654,0x0000,0x0000, 0x1655,0x0000,0x0000,
0xFBC0,0x8AE4,0x0000, 0xFBC0,0x8AE5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x8AF0,0x0000, 0x0E14,0x0000,0x0000, 0xFBC0,0x8AF2,0x0000,
0xFBC0,0x8AF3,0x0000, 0xFBC0,0x8AF4,0x0000, 0xFBC0,0x8AF5,0x0000,
0xFBC0,0x8AF6,0x0000, 0xFBC0,0x8AF7,0x0000, 0xFBC0,0x8AF8,0x0000,
0xFBC0,0x8AF9,0x0000, 0xFBC0,0x8AFA,0x0000, 0xFBC0,0x8AFB,0x0000,
0xFBC0,0x8AFC,0x0000, 0xFBC0,0x8AFD,0x0000, 0xFBC0,0x8AFE,0x0000,
0xFBC0,0x8AFF,0x0000 };

uint16 page00Bdata[]= { /* 0B00 (3 weights per char) */
0xFBC0,0x8B00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8B04,0x0000, 0x165D,0x0000,0x0000,
0x165E,0x0000,0x0000, 0x165F,0x0000,0x0000, 0x1660,0x0000,0x0000,
0x1661,0x0000,0x0000, 0x1662,0x0000,0x0000, 0x1663,0x0000,0x0000,
0x1665,0x0000,0x0000, 0xFBC0,0x8B0D,0x0000, 0xFBC0,0x8B0E,0x0000,
0x1667,0x0000,0x0000, 0x1668,0x0000,0x0000, 0xFBC0,0x8B11,0x0000,
0xFBC0,0x8B12,0x0000, 0x1669,0x0000,0x0000, 0x166A,0x0000,0x0000,
0x166B,0x0000,0x0000, 0x166C,0x0000,0x0000, 0x166D,0x0000,0x0000,
0x166E,0x0000,0x0000, 0x166F,0x0000,0x0000, 0x1670,0x0000,0x0000,
0x1671,0x0000,0x0000, 0x1672,0x0000,0x0000, 0x1673,0x0000,0x0000,
0x1674,0x0000,0x0000, 0x1675,0x0000,0x0000, 0x1676,0x0000,0x0000,
0x1677,0x0000,0x0000, 0x1678,0x0000,0x0000, 0x1679,0x0000,0x0000,
0x167A,0x0000,0x0000, 0x167B,0x0000,0x0000, 0x167C,0x0000,0x0000,
0x167D,0x0000,0x0000, 0x167E,0x0000,0x0000, 0xFBC0,0x8B29,0x0000,
0x167F,0x0000,0x0000, 0x1680,0x0000,0x0000, 0x1681,0x0000,0x0000,
0x1682,0x0000,0x0000, 0x1683,0x0000,0x0000, 0x1684,0x0000,0x0000,
0x1686,0x0000,0x0000, 0xFBC0,0x8B31,0x0000, 0x1687,0x0000,0x0000,
0x1688,0x0000,0x0000, 0xFBC0,0x8B34,0x0000, 0x1689,0x0000,0x0000,
0x168B,0x0000,0x0000, 0x168C,0x0000,0x0000, 0x168D,0x0000,0x0000,
0x168E,0x0000,0x0000, 0xFBC0,0x8B3A,0x0000, 0xFBC0,0x8B3B,0x0000,
0x0000,0x0000,0x0000, 0x168F,0x0000,0x0000, 0x1690,0x0000,0x0000,
0x1691,0x0000,0x0000, 0x1692,0x0000,0x0000, 0x1693,0x0000,0x0000,
0x1694,0x0000,0x0000, 0x1695,0x0000,0x0000, 0xFBC0,0x8B44,0x0000,
0xFBC0,0x8B45,0x0000, 0xFBC0,0x8B46,0x0000, 0x1696,0x0000,0x0000,
0x1697,0x0000,0x0000, 0xFBC0,0x8B49,0x0000, 0xFBC0,0x8B4A,0x0000,
0x1698,0x0000,0x0000, 0x1699,0x0000,0x0000, 0x169A,0x0000,0x0000,
0xFBC0,0x8B4E,0x0000, 0xFBC0,0x8B4F,0x0000, 0xFBC0,0x8B50,0x0000,
0xFBC0,0x8B51,0x0000, 0xFBC0,0x8B52,0x0000, 0xFBC0,0x8B53,0x0000,
0xFBC0,0x8B54,0x0000, 0xFBC0,0x8B55,0x0000, 0x169B,0x0000,0x0000,
0x169C,0x0000,0x0000, 0xFBC0,0x8B58,0x0000, 0xFBC0,0x8B59,0x0000,
0xFBC0,0x8B5A,0x0000, 0xFBC0,0x8B5B,0x0000, 0x1677,0x0000,0x0000,
0x1678,0x0000,0x0000, 0xFBC0,0x8B5E,0x0000, 0x1685,0x0000,0x0000,
0x1664,0x0000,0x0000, 0x1666,0x0000,0x0000, 0xFBC0,0x8B62,0x0000,
0xFBC0,0x8B63,0x0000, 0xFBC0,0x8B64,0x0000, 0xFBC0,0x8B65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0351,0x0000,0x0000, 0x168A,0x0000,0x0000,
0xFBC0,0x8B72,0x0000, 0xFBC0,0x8B73,0x0000, 0xFBC0,0x8B74,0x0000,
0xFBC0,0x8B75,0x0000, 0xFBC0,0x8B76,0x0000, 0xFBC0,0x8B77,0x0000,
0xFBC0,0x8B78,0x0000, 0xFBC0,0x8B79,0x0000, 0xFBC0,0x8B7A,0x0000,
0xFBC0,0x8B7B,0x0000, 0xFBC0,0x8B7C,0x0000, 0xFBC0,0x8B7D,0x0000,
0xFBC0,0x8B7E,0x0000, 0xFBC0,0x8B7F,0x0000, 0xFBC0,0x8B80,0x0000,
0xFBC0,0x8B81,0x0000, 0x0000,0x0000,0x0000, 0x169D,0x0000,0x0000,
0xFBC0,0x8B84,0x0000, 0x169E,0x0000,0x0000, 0x169F,0x0000,0x0000,
0x16A0,0x0000,0x0000, 0x16A1,0x0000,0x0000, 0x16A2,0x0000,0x0000,
0x16A3,0x0000,0x0000, 0xFBC0,0x8B8B,0x0000, 0xFBC0,0x8B8C,0x0000,
0xFBC0,0x8B8D,0x0000, 0x16A4,0x0000,0x0000, 0x16A5,0x0000,0x0000,
0x16A6,0x0000,0x0000, 0xFBC0,0x8B91,0x0000, 0x16A7,0x0000,0x0000,
0x16A8,0x0000,0x0000, 0x16A9,0x0000,0x0000, 0x16AA,0x0000,0x0000,
0xFBC0,0x8B96,0x0000, 0xFBC0,0x8B97,0x0000, 0xFBC0,0x8B98,0x0000,
0x16AB,0x0000,0x0000, 0x16AC,0x0000,0x0000, 0xFBC0,0x8B9B,0x0000,
0x16AD,0x0000,0x0000, 0xFBC0,0x8B9D,0x0000, 0x16AE,0x0000,0x0000,
0x16AF,0x0000,0x0000, 0xFBC0,0x8BA0,0x0000, 0xFBC0,0x8BA1,0x0000,
0xFBC0,0x8BA2,0x0000, 0x16B0,0x0000,0x0000, 0x16B1,0x0000,0x0000,
0xFBC0,0x8BA5,0x0000, 0xFBC0,0x8BA6,0x0000, 0xFBC0,0x8BA7,0x0000,
0x16B2,0x0000,0x0000, 0x16B3,0x0000,0x0000, 0x16B4,0x0000,0x0000,
0xFBC0,0x8BAB,0x0000, 0xFBC0,0x8BAC,0x0000, 0xFBC0,0x8BAD,0x0000,
0x16B5,0x0000,0x0000, 0x16B6,0x0000,0x0000, 0x16B7,0x0000,0x0000,
0x16B8,0x0000,0x0000, 0x16B9,0x0000,0x0000, 0x16BA,0x0000,0x0000,
0x16BB,0x0000,0x0000, 0x16BC,0x0000,0x0000, 0xFBC0,0x8BB6,0x0000,
0x16BD,0x0000,0x0000, 0x16BE,0x0000,0x0000, 0x16BF,0x0000,0x0000,
0xFBC0,0x8BBA,0x0000, 0xFBC0,0x8BBB,0x0000, 0xFBC0,0x8BBC,0x0000,
0xFBC0,0x8BBD,0x0000, 0x16C0,0x0000,0x0000, 0x16C1,0x0000,0x0000,
0x16C2,0x0000,0x0000, 0x16C3,0x0000,0x0000, 0x16C4,0x0000,0x0000,
0xFBC0,0x8BC3,0x0000, 0xFBC0,0x8BC4,0x0000, 0xFBC0,0x8BC5,0x0000,
0x16C5,0x0000,0x0000, 0x16C6,0x0000,0x0000, 0x16C7,0x0000,0x0000,
0xFBC0,0x8BC9,0x0000, 0x16C8,0x0000,0x0000, 0x16C9,0x0000,0x0000,
0x16CA,0x0000,0x0000, 0x16CB,0x0000,0x0000, 0xFBC0,0x8BCE,0x0000,
0xFBC0,0x8BCF,0x0000, 0xFBC0,0x8BD0,0x0000, 0xFBC0,0x8BD1,0x0000,
0xFBC0,0x8BD2,0x0000, 0xFBC0,0x8BD3,0x0000, 0xFBC0,0x8BD4,0x0000,
0xFBC0,0x8BD5,0x0000, 0xFBC0,0x8BD6,0x0000, 0x16CC,0x0000,0x0000,
0xFBC0,0x8BD8,0x0000, 0xFBC0,0x8BD9,0x0000, 0xFBC0,0x8BDA,0x0000,
0xFBC0,0x8BDB,0x0000, 0xFBC0,0x8BDC,0x0000, 0xFBC0,0x8BDD,0x0000,
0xFBC0,0x8BDE,0x0000, 0xFBC0,0x8BDF,0x0000, 0xFBC0,0x8BE0,0x0000,
0xFBC0,0x8BE1,0x0000, 0xFBC0,0x8BE2,0x0000, 0xFBC0,0x8BE3,0x0000,
0xFBC0,0x8BE4,0x0000, 0xFBC0,0x8BE5,0x0000, 0xFBC0,0x8BE6,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0DC9,0x0000,0x0000, 0x0DCA,0x0000,0x0000, 0x0DCB,0x0000,0x0000,
0x0352,0x0000,0x0000, 0x0353,0x0000,0x0000, 0x0354,0x0000,0x0000,
0x0355,0x0000,0x0000, 0x0356,0x0000,0x0000, 0x0357,0x0000,0x0000,
0x0E15,0x0000,0x0000, 0x0358,0x0000,0x0000, 0xFBC0,0x8BFB,0x0000,
0xFBC0,0x8BFC,0x0000, 0xFBC0,0x8BFD,0x0000, 0xFBC0,0x8BFE,0x0000,
0xFBC0,0x8BFF,0x0000 };

uint16 page00Cdata[]= { /* 0C00 (3 weights per char) */
0xFBC0,0x8C00,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8C04,0x0000, 0x16CD,0x0000,0x0000,
0x16CE,0x0000,0x0000, 0x16CF,0x0000,0x0000, 0x16D0,0x0000,0x0000,
0x16D1,0x0000,0x0000, 0x16D2,0x0000,0x0000, 0x16D3,0x0000,0x0000,
0x16D5,0x0000,0x0000, 0xFBC0,0x8C0D,0x0000, 0x16D7,0x0000,0x0000,
0x16D8,0x0000,0x0000, 0x16D9,0x0000,0x0000, 0xFBC0,0x8C11,0x0000,
0x16DA,0x0000,0x0000, 0x16DB,0x0000,0x0000, 0x16DC,0x0000,0x0000,
0x16DD,0x0000,0x0000, 0x16DE,0x0000,0x0000, 0x16DF,0x0000,0x0000,
0x16E0,0x0000,0x0000, 0x16E1,0x0000,0x0000, 0x16E2,0x0000,0x0000,
0x16E3,0x0000,0x0000, 0x16E4,0x0000,0x0000, 0x16E5,0x0000,0x0000,
0x16E6,0x0000,0x0000, 0x16E7,0x0000,0x0000, 0x16E8,0x0000,0x0000,
0x16E9,0x0000,0x0000, 0x16EA,0x0000,0x0000, 0x16EB,0x0000,0x0000,
0x16EC,0x0000,0x0000, 0x16ED,0x0000,0x0000, 0x16EE,0x0000,0x0000,
0x16EF,0x0000,0x0000, 0x16F0,0x0000,0x0000, 0xFBC0,0x8C29,0x0000,
0x16F1,0x0000,0x0000, 0x16F2,0x0000,0x0000, 0x16F3,0x0000,0x0000,
0x16F4,0x0000,0x0000, 0x16F5,0x0000,0x0000, 0x16F6,0x0000,0x0000,
0x16F7,0x0000,0x0000, 0x16F8,0x0000,0x0000, 0x16F9,0x0000,0x0000,
0x16FA,0x0000,0x0000, 0xFBC0,0x8C34,0x0000, 0x16FB,0x0000,0x0000,
0x16FC,0x0000,0x0000, 0x16FD,0x0000,0x0000, 0x16FE,0x0000,0x0000,
0x16FF,0x0000,0x0000, 0xFBC0,0x8C3A,0x0000, 0xFBC0,0x8C3B,0x0000,
0xFBC0,0x8C3C,0x0000, 0xFBC0,0x8C3D,0x0000, 0x1700,0x0000,0x0000,
0x1701,0x0000,0x0000, 0x1702,0x0000,0x0000, 0x1703,0x0000,0x0000,
0x1704,0x0000,0x0000, 0x1705,0x0000,0x0000, 0x1706,0x0000,0x0000,
0xFBC0,0x8C45,0x0000, 0x1707,0x0000,0x0000, 0x1708,0x0000,0x0000,
0x1709,0x0000,0x0000, 0xFBC0,0x8C49,0x0000, 0x170A,0x0000,0x0000,
0x170B,0x0000,0x0000, 0x170C,0x0000,0x0000, 0x170D,0x0000,0x0000,
0xFBC0,0x8C4E,0x0000, 0xFBC0,0x8C4F,0x0000, 0xFBC0,0x8C50,0x0000,
0xFBC0,0x8C51,0x0000, 0xFBC0,0x8C52,0x0000, 0xFBC0,0x8C53,0x0000,
0xFBC0,0x8C54,0x0000, 0x170E,0x0000,0x0000, 0x170F,0x0000,0x0000,
0xFBC0,0x8C57,0x0000, 0xFBC0,0x8C58,0x0000, 0xFBC0,0x8C59,0x0000,
0xFBC0,0x8C5A,0x0000, 0xFBC0,0x8C5B,0x0000, 0xFBC0,0x8C5C,0x0000,
0xFBC0,0x8C5D,0x0000, 0xFBC0,0x8C5E,0x0000, 0xFBC0,0x8C5F,0x0000,
0x16D4,0x0000,0x0000, 0x16D6,0x0000,0x0000, 0xFBC0,0x8C62,0x0000,
0xFBC0,0x8C63,0x0000, 0xFBC0,0x8C64,0x0000, 0xFBC0,0x8C65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x8C70,0x0000, 0xFBC0,0x8C71,0x0000,
0xFBC0,0x8C72,0x0000, 0xFBC0,0x8C73,0x0000, 0xFBC0,0x8C74,0x0000,
0xFBC0,0x8C75,0x0000, 0xFBC0,0x8C76,0x0000, 0xFBC0,0x8C77,0x0000,
0xFBC0,0x8C78,0x0000, 0xFBC0,0x8C79,0x0000, 0xFBC0,0x8C7A,0x0000,
0xFBC0,0x8C7B,0x0000, 0xFBC0,0x8C7C,0x0000, 0xFBC0,0x8C7D,0x0000,
0xFBC0,0x8C7E,0x0000, 0xFBC0,0x8C7F,0x0000, 0xFBC0,0x8C80,0x0000,
0xFBC0,0x8C81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8C84,0x0000, 0x1710,0x0000,0x0000, 0x1711,0x0000,0x0000,
0x1712,0x0000,0x0000, 0x1713,0x0000,0x0000, 0x1714,0x0000,0x0000,
0x1715,0x0000,0x0000, 0x1716,0x0000,0x0000, 0x1718,0x0000,0x0000,
0xFBC0,0x8C8D,0x0000, 0x171A,0x0000,0x0000, 0x171B,0x0000,0x0000,
0x171C,0x0000,0x0000, 0xFBC0,0x8C91,0x0000, 0x171D,0x0000,0x0000,
0x171E,0x0000,0x0000, 0x171F,0x0000,0x0000, 0x1720,0x0000,0x0000,
0x1721,0x0000,0x0000, 0x1722,0x0000,0x0000, 0x1723,0x0000,0x0000,
0x1724,0x0000,0x0000, 0x1725,0x0000,0x0000, 0x1726,0x0000,0x0000,
0x1727,0x0000,0x0000, 0x1728,0x0000,0x0000, 0x1729,0x0000,0x0000,
0x172A,0x0000,0x0000, 0x172B,0x0000,0x0000, 0x172C,0x0000,0x0000,
0x172D,0x0000,0x0000, 0x172E,0x0000,0x0000, 0x172F,0x0000,0x0000,
0x1730,0x0000,0x0000, 0x1731,0x0000,0x0000, 0x1732,0x0000,0x0000,
0x1733,0x0000,0x0000, 0xFBC0,0x8CA9,0x0000, 0x1734,0x0000,0x0000,
0x1735,0x0000,0x0000, 0x1736,0x0000,0x0000, 0x1737,0x0000,0x0000,
0x1738,0x0000,0x0000, 0x1739,0x0000,0x0000, 0x173A,0x0000,0x0000,
0x173B,0x0000,0x0000, 0x173C,0x0000,0x0000, 0x1743,0x0000,0x0000,
0xFBC0,0x8CB4,0x0000, 0x173D,0x0000,0x0000, 0x173E,0x0000,0x0000,
0x173F,0x0000,0x0000, 0x1740,0x0000,0x0000, 0x1741,0x0000,0x0000,
0xFBC0,0x8CBA,0x0000, 0xFBC0,0x8CBB,0x0000, 0x0000,0x0000,0x0000,
0x1742,0x0000,0x0000, 0x1745,0x0000,0x0000, 0x1746,0x0000,0x0000,
0x1747,0x0000,0x0000, 0x1748,0x0000,0x0000, 0x1749,0x0000,0x0000,
0x174A,0x0000,0x0000, 0x174B,0x0000,0x0000, 0xFBC0,0x8CC5,0x0000,
0x174C,0x0000,0x0000, 0x174D,0x0000,0x0000, 0x174E,0x0000,0x0000,
0xFBC0,0x8CC9,0x0000, 0x174F,0x0000,0x0000, 0x1750,0x0000,0x0000,
0x1751,0x0000,0x0000, 0x1752,0x0000,0x0000, 0xFBC0,0x8CCE,0x0000,
0xFBC0,0x8CCF,0x0000, 0xFBC0,0x8CD0,0x0000, 0xFBC0,0x8CD1,0x0000,
0xFBC0,0x8CD2,0x0000, 0xFBC0,0x8CD3,0x0000, 0xFBC0,0x8CD4,0x0000,
0x1753,0x0000,0x0000, 0x1754,0x0000,0x0000, 0xFBC0,0x8CD7,0x0000,
0xFBC0,0x8CD8,0x0000, 0xFBC0,0x8CD9,0x0000, 0xFBC0,0x8CDA,0x0000,
0xFBC0,0x8CDB,0x0000, 0xFBC0,0x8CDC,0x0000, 0xFBC0,0x8CDD,0x0000,
0x1744,0x0000,0x0000, 0xFBC0,0x8CDF,0x0000, 0x1717,0x0000,0x0000,
0x1719,0x0000,0x0000, 0xFBC0,0x8CE2,0x0000, 0xFBC0,0x8CE3,0x0000,
0xFBC0,0x8CE4,0x0000, 0xFBC0,0x8CE5,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x8CF0,0x0000, 0xFBC0,0x8CF1,0x0000, 0xFBC0,0x8CF2,0x0000,
0xFBC0,0x8CF3,0x0000, 0xFBC0,0x8CF4,0x0000, 0xFBC0,0x8CF5,0x0000,
0xFBC0,0x8CF6,0x0000, 0xFBC0,0x8CF7,0x0000, 0xFBC0,0x8CF8,0x0000,
0xFBC0,0x8CF9,0x0000, 0xFBC0,0x8CFA,0x0000, 0xFBC0,0x8CFB,0x0000,
0xFBC0,0x8CFC,0x0000, 0xFBC0,0x8CFD,0x0000, 0xFBC0,0x8CFE,0x0000,
0xFBC0,0x8CFF,0x0000 };

uint16 page00Ddata[]= { /* 0D00 (3 weights per char) */
0xFBC0,0x8D00,0x0000, 0xFBC0,0x8D01,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC0,0x8D04,0x0000, 0x1755,0x0000,0x0000,
0x1756,0x0000,0x0000, 0x1757,0x0000,0x0000, 0x1758,0x0000,0x0000,
0x1759,0x0000,0x0000, 0x175A,0x0000,0x0000, 0x175B,0x0000,0x0000,
0x175D,0x0000,0x0000, 0xFBC0,0x8D0D,0x0000, 0x175F,0x0000,0x0000,
0x1760,0x0000,0x0000, 0x1761,0x0000,0x0000, 0xFBC0,0x8D11,0x0000,
0x1762,0x0000,0x0000, 0x1763,0x0000,0x0000, 0x1764,0x0000,0x0000,
0x1765,0x0000,0x0000, 0x1766,0x0000,0x0000, 0x1767,0x0000,0x0000,
0x1768,0x0000,0x0000, 0x1769,0x0000,0x0000, 0x176A,0x0000,0x0000,
0x176B,0x0000,0x0000, 0x176C,0x0000,0x0000, 0x176D,0x0000,0x0000,
0x176E,0x0000,0x0000, 0x176F,0x0000,0x0000, 0x1770,0x0000,0x0000,
0x1771,0x0000,0x0000, 0x1772,0x0000,0x0000, 0x1773,0x0000,0x0000,
0x1774,0x0000,0x0000, 0x1775,0x0000,0x0000, 0x1776,0x0000,0x0000,
0x1777,0x0000,0x0000, 0x1778,0x0000,0x0000, 0xFBC0,0x8D29,0x0000,
0x1779,0x0000,0x0000, 0x177A,0x0000,0x0000, 0x177B,0x0000,0x0000,
0x177C,0x0000,0x0000, 0x177D,0x0000,0x0000, 0x177E,0x0000,0x0000,
0x177F,0x0000,0x0000, 0x1780,0x0000,0x0000, 0x1781,0x0000,0x0000,
0x1782,0x0000,0x0000, 0x1783,0x0000,0x0000, 0x1784,0x0000,0x0000,
0x1785,0x0000,0x0000, 0x1786,0x0000,0x0000, 0x1787,0x0000,0x0000,
0x1788,0x0000,0x0000, 0xFBC0,0x8D3A,0x0000, 0xFBC0,0x8D3B,0x0000,
0xFBC0,0x8D3C,0x0000, 0xFBC0,0x8D3D,0x0000, 0x1789,0x0000,0x0000,
0x178A,0x0000,0x0000, 0x178B,0x0000,0x0000, 0x178C,0x0000,0x0000,
0x178D,0x0000,0x0000, 0x178E,0x0000,0x0000, 0xFBC0,0x8D44,0x0000,
0xFBC0,0x8D45,0x0000, 0x178F,0x0000,0x0000, 0x1790,0x0000,0x0000,
0x1791,0x0000,0x0000, 0xFBC0,0x8D49,0x0000, 0x1792,0x0000,0x0000,
0x1793,0x0000,0x0000, 0x1794,0x0000,0x0000, 0x1795,0x0000,0x0000,
0xFBC0,0x8D4E,0x0000, 0xFBC0,0x8D4F,0x0000, 0xFBC0,0x8D50,0x0000,
0xFBC0,0x8D51,0x0000, 0xFBC0,0x8D52,0x0000, 0xFBC0,0x8D53,0x0000,
0xFBC0,0x8D54,0x0000, 0xFBC0,0x8D55,0x0000, 0xFBC0,0x8D56,0x0000,
0x1796,0x0000,0x0000, 0xFBC0,0x8D58,0x0000, 0xFBC0,0x8D59,0x0000,
0xFBC0,0x8D5A,0x0000, 0xFBC0,0x8D5B,0x0000, 0xFBC0,0x8D5C,0x0000,
0xFBC0,0x8D5D,0x0000, 0xFBC0,0x8D5E,0x0000, 0xFBC0,0x8D5F,0x0000,
0x175C,0x0000,0x0000, 0x175E,0x0000,0x0000, 0xFBC0,0x8D62,0x0000,
0xFBC0,0x8D63,0x0000, 0xFBC0,0x8D64,0x0000, 0xFBC0,0x8D65,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x8D70,0x0000, 0xFBC0,0x8D71,0x0000,
0xFBC0,0x8D72,0x0000, 0xFBC0,0x8D73,0x0000, 0xFBC0,0x8D74,0x0000,
0xFBC0,0x8D75,0x0000, 0xFBC0,0x8D76,0x0000, 0xFBC0,0x8D77,0x0000,
0xFBC0,0x8D78,0x0000, 0xFBC0,0x8D79,0x0000, 0xFBC0,0x8D7A,0x0000,
0xFBC0,0x8D7B,0x0000, 0xFBC0,0x8D7C,0x0000, 0xFBC0,0x8D7D,0x0000,
0xFBC0,0x8D7E,0x0000, 0xFBC0,0x8D7F,0x0000, 0xFBC0,0x8D80,0x0000,
0xFBC0,0x8D81,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x8D84,0x0000, 0x1797,0x0000,0x0000, 0x1798,0x0000,0x0000,
0x1799,0x0000,0x0000, 0x179A,0x0000,0x0000, 0x179B,0x0000,0x0000,
0x179C,0x0000,0x0000, 0x179D,0x0000,0x0000, 0x179E,0x0000,0x0000,
0x179F,0x0000,0x0000, 0x17A0,0x0000,0x0000, 0x17A1,0x0000,0x0000,
0x17A2,0x0000,0x0000, 0x17A3,0x0000,0x0000, 0x17A4,0x0000,0x0000,
0x17A5,0x0000,0x0000, 0x17A6,0x0000,0x0000, 0x17A7,0x0000,0x0000,
0x17A8,0x0000,0x0000, 0xFBC0,0x8D97,0x0000, 0xFBC0,0x8D98,0x0000,
0xFBC0,0x8D99,0x0000, 0x17A9,0x0000,0x0000, 0x17AA,0x0000,0x0000,
0x17AB,0x0000,0x0000, 0x17AC,0x0000,0x0000, 0x17AD,0x0000,0x0000,
0x17AE,0x0000,0x0000, 0x17AF,0x0000,0x0000, 0x17B0,0x0000,0x0000,
0x17B1,0x0000,0x0000, 0x17B2,0x0000,0x0000, 0x17B3,0x0000,0x0000,
0x17B4,0x0000,0x0000, 0x17B5,0x0000,0x0000, 0x17B6,0x0000,0x0000,
0x17B7,0x0000,0x0000, 0x17B8,0x0000,0x0000, 0x17B9,0x0000,0x0000,
0x17BA,0x0000,0x0000, 0x17BB,0x0000,0x0000, 0x17BC,0x0000,0x0000,
0x17BD,0x0000,0x0000, 0x17BE,0x0000,0x0000, 0x17BF,0x0000,0x0000,
0x17C0,0x0000,0x0000, 0xFBC0,0x8DB2,0x0000, 0x17C1,0x0000,0x0000,
0x17C2,0x0000,0x0000, 0x17C3,0x0000,0x0000, 0x17C4,0x0000,0x0000,
0x17C5,0x0000,0x0000, 0x17C6,0x0000,0x0000, 0x17C7,0x0000,0x0000,
0x17C8,0x0000,0x0000, 0x17C9,0x0000,0x0000, 0xFBC0,0x8DBC,0x0000,
0x17CA,0x0000,0x0000, 0xFBC0,0x8DBE,0x0000, 0xFBC0,0x8DBF,0x0000,
0x17CB,0x0000,0x0000, 0x17CC,0x0000,0x0000, 0x17CD,0x0000,0x0000,
0x17CE,0x0000,0x0000, 0x17CF,0x0000,0x0000, 0x17D0,0x0000,0x0000,
0x17D1,0x0000,0x0000, 0xFBC0,0x8DC7,0x0000, 0xFBC0,0x8DC8,0x0000,
0xFBC0,0x8DC9,0x0000, 0x17D2,0x0000,0x0000, 0xFBC0,0x8DCB,0x0000,
0xFBC0,0x8DCC,0x0000, 0xFBC0,0x8DCD,0x0000, 0xFBC0,0x8DCE,0x0000,
0x17D3,0x0000,0x0000, 0x17D4,0x0000,0x0000, 0x17D5,0x0000,0x0000,
0x17D6,0x0000,0x0000, 0x17D7,0x0000,0x0000, 0x17D8,0x0000,0x0000,
0xFBC0,0x8DD5,0x0000, 0x17D9,0x0000,0x0000, 0xFBC0,0x8DD7,0x0000,
0x17DA,0x0000,0x0000, 0x17DB,0x0000,0x0000, 0x17DC,0x0000,0x0000,
0x17DD,0x0000,0x0000, 0x17DE,0x0000,0x0000, 0x17DF,0x0000,0x0000,
0x17E0,0x0000,0x0000, 0x17E1,0x0000,0x0000, 0xFBC0,0x8DE0,0x0000,
0xFBC0,0x8DE1,0x0000, 0xFBC0,0x8DE2,0x0000, 0xFBC0,0x8DE3,0x0000,
0xFBC0,0x8DE4,0x0000, 0xFBC0,0x8DE5,0x0000, 0xFBC0,0x8DE6,0x0000,
0xFBC0,0x8DE7,0x0000, 0xFBC0,0x8DE8,0x0000, 0xFBC0,0x8DE9,0x0000,
0xFBC0,0x8DEA,0x0000, 0xFBC0,0x8DEB,0x0000, 0xFBC0,0x8DEC,0x0000,
0xFBC0,0x8DED,0x0000, 0xFBC0,0x8DEE,0x0000, 0xFBC0,0x8DEF,0x0000,
0xFBC0,0x8DF0,0x0000, 0xFBC0,0x8DF1,0x0000, 0x17E2,0x0000,0x0000,
0x17E3,0x0000,0x0000, 0x02FB,0x0000,0x0000, 0xFBC0,0x8DF5,0x0000,
0xFBC0,0x8DF6,0x0000, 0xFBC0,0x8DF7,0x0000, 0xFBC0,0x8DF8,0x0000,
0xFBC0,0x8DF9,0x0000, 0xFBC0,0x8DFA,0x0000, 0xFBC0,0x8DFB,0x0000,
0xFBC0,0x8DFC,0x0000, 0xFBC0,0x8DFD,0x0000, 0xFBC0,0x8DFE,0x0000,
0xFBC0,0x8DFF,0x0000 };

uint16 page00Edata[]= { /* 0E00 (3 weights per char) */
0xFBC0,0x8E00,0x0000, 0x17E4,0x0000,0x0000, 0x17E5,0x0000,0x0000,
0x17E6,0x0000,0x0000, 0x17E7,0x0000,0x0000, 0x17E8,0x0000,0x0000,
0x17E9,0x0000,0x0000, 0x17EA,0x0000,0x0000, 0x17EB,0x0000,0x0000,
0x17EC,0x0000,0x0000, 0x17ED,0x0000,0x0000, 0x17EE,0x0000,0x0000,
0x17EF,0x0000,0x0000, 0x17F0,0x0000,0x0000, 0x17F1,0x0000,0x0000,
0x17F2,0x0000,0x0000, 0x17F3,0x0000,0x0000, 0x17F4,0x0000,0x0000,
0x17F5,0x0000,0x0000, 0x17F6,0x0000,0x0000, 0x17F7,0x0000,0x0000,
0x17F8,0x0000,0x0000, 0x17F9,0x0000,0x0000, 0x17FA,0x0000,0x0000,
0x17FB,0x0000,0x0000, 0x17FC,0x0000,0x0000, 0x17FD,0x0000,0x0000,
0x17FE,0x0000,0x0000, 0x17FF,0x0000,0x0000, 0x1800,0x0000,0x0000,
0x1801,0x0000,0x0000, 0x1802,0x0000,0x0000, 0x1803,0x0000,0x0000,
0x1804,0x0000,0x0000, 0x1805,0x0000,0x0000, 0x1806,0x0000,0x0000,
0x1807,0x0000,0x0000, 0x1808,0x0000,0x0000, 0x1809,0x0000,0x0000,
0x180A,0x0000,0x0000, 0x180B,0x0000,0x0000, 0x180C,0x0000,0x0000,
0x180D,0x0000,0x0000, 0x180E,0x0000,0x0000, 0x180F,0x0000,0x0000,
0x1810,0x0000,0x0000, 0x1811,0x0000,0x0000, 0x1812,0x0000,0x0000,
0x1813,0x0000,0x0000, 0x1814,0x0000,0x0000, 0x1815,0x0000,0x0000,
0x1816,0x0000,0x0000, 0x1817,0x0000,0x0000, 0x1818,0x0000,0x0000,
0x1819,0x0000,0x0000, 0x181A,0x0000,0x0000, 0x181B,0x0000,0x0000,
0x181C,0x0000,0x0000, 0x181D,0x0000,0x0000, 0xFBC0,0x8E3B,0x0000,
0xFBC0,0x8E3C,0x0000, 0xFBC0,0x8E3D,0x0000, 0xFBC0,0x8E3E,0x0000,
0x0E16,0x0000,0x0000, 0x181E,0x0000,0x0000, 0x181F,0x0000,0x0000,
0x1820,0x0000,0x0000, 0x1821,0x0000,0x0000, 0x1822,0x0000,0x0000,
0x1823,0x0000,0x0000, 0x0E03,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1824,0x0000,0x0000, 0x1825,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0359,0x0000,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x02FC,0x0000,0x0000, 0x02FD,0x0000,0x0000, 0xFBC0,0x8E5C,0x0000,
0xFBC0,0x8E5D,0x0000, 0xFBC0,0x8E5E,0x0000, 0xFBC0,0x8E5F,0x0000,
0xFBC0,0x8E60,0x0000, 0xFBC0,0x8E61,0x0000, 0xFBC0,0x8E62,0x0000,
0xFBC0,0x8E63,0x0000, 0xFBC0,0x8E64,0x0000, 0xFBC0,0x8E65,0x0000,
0xFBC0,0x8E66,0x0000, 0xFBC0,0x8E67,0x0000, 0xFBC0,0x8E68,0x0000,
0xFBC0,0x8E69,0x0000, 0xFBC0,0x8E6A,0x0000, 0xFBC0,0x8E6B,0x0000,
0xFBC0,0x8E6C,0x0000, 0xFBC0,0x8E6D,0x0000, 0xFBC0,0x8E6E,0x0000,
0xFBC0,0x8E6F,0x0000, 0xFBC0,0x8E70,0x0000, 0xFBC0,0x8E71,0x0000,
0xFBC0,0x8E72,0x0000, 0xFBC0,0x8E73,0x0000, 0xFBC0,0x8E74,0x0000,
0xFBC0,0x8E75,0x0000, 0xFBC0,0x8E76,0x0000, 0xFBC0,0x8E77,0x0000,
0xFBC0,0x8E78,0x0000, 0xFBC0,0x8E79,0x0000, 0xFBC0,0x8E7A,0x0000,
0xFBC0,0x8E7B,0x0000, 0xFBC0,0x8E7C,0x0000, 0xFBC0,0x8E7D,0x0000,
0xFBC0,0x8E7E,0x0000, 0xFBC0,0x8E7F,0x0000, 0xFBC0,0x8E80,0x0000,
0x1826,0x0000,0x0000, 0x1827,0x0000,0x0000, 0xFBC0,0x8E83,0x0000,
0x1828,0x0000,0x0000, 0xFBC0,0x8E85,0x0000, 0xFBC0,0x8E86,0x0000,
0x1829,0x0000,0x0000, 0x182A,0x0000,0x0000, 0xFBC0,0x8E89,0x0000,
0x182B,0x0000,0x0000, 0xFBC0,0x8E8B,0x0000, 0xFBC0,0x8E8C,0x0000,
0x182C,0x0000,0x0000, 0xFBC0,0x8E8E,0x0000, 0xFBC0,0x8E8F,0x0000,
0xFBC0,0x8E90,0x0000, 0xFBC0,0x8E91,0x0000, 0xFBC0,0x8E92,0x0000,
0xFBC0,0x8E93,0x0000, 0x182D,0x0000,0x0000, 0x182E,0x0000,0x0000,
0x182F,0x0000,0x0000, 0x1830,0x0000,0x0000, 0xFBC0,0x8E98,0x0000,
0x1831,0x0000,0x0000, 0x1832,0x0000,0x0000, 0x1833,0x0000,0x0000,
0x1834,0x0000,0x0000, 0x1835,0x0000,0x0000, 0x1836,0x0000,0x0000,
0x1837,0x0000,0x0000, 0xFBC0,0x8EA0,0x0000, 0x1838,0x0000,0x0000,
0x1839,0x0000,0x0000, 0x183A,0x0000,0x0000, 0xFBC0,0x8EA4,0x0000,
0x183B,0x0000,0x0000, 0xFBC0,0x8EA6,0x0000, 0x183C,0x0000,0x0000,
0xFBC0,0x8EA8,0x0000, 0xFBC0,0x8EA9,0x0000, 0x183D,0x0000,0x0000,
0x183E,0x0000,0x0000, 0xFBC0,0x8EAC,0x0000, 0x183F,0x0000,0x0000,
0x1840,0x0000,0x0000, 0x1841,0x0000,0x0000, 0x1842,0x0000,0x0000,
0x1843,0x0000,0x0000, 0x1844,0x0000,0x0000, 0x1845,0x0000,0x0000,
0x1846,0x0000,0x0000, 0x1847,0x0000,0x0000, 0x1848,0x0000,0x0000,
0x1849,0x0000,0x0000, 0x184A,0x0000,0x0000, 0x184B,0x0000,0x0000,
0xFBC0,0x8EBA,0x0000, 0x184C,0x0000,0x0000, 0x184D,0x0000,0x0000,
0x184E,0x0000,0x0000, 0xFBC0,0x8EBE,0x0000, 0xFBC0,0x8EBF,0x0000,
0x184F,0x0000,0x0000, 0x1850,0x0000,0x0000, 0x1851,0x0000,0x0000,
0x1852,0x0000,0x0000, 0x1853,0x0000,0x0000, 0xFBC0,0x8EC5,0x0000,
0x0E04,0x0000,0x0000, 0xFBC0,0x8EC7,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x1854,0x0000,0x0000, 0x1855,0x0000,0x0000, 0xFBC0,0x8ECE,0x0000,
0xFBC0,0x8ECF,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0xFBC0,0x8EDA,0x0000,
0xFBC0,0x8EDB,0x0000, 0x183E,0x1831,0x0000, 0x183E,0x1838,0x0000,
0xFBC0,0x8EDE,0x0000, 0xFBC0,0x8EDF,0x0000, 0xFBC0,0x8EE0,0x0000,
0xFBC0,0x8EE1,0x0000, 0xFBC0,0x8EE2,0x0000, 0xFBC0,0x8EE3,0x0000,
0xFBC0,0x8EE4,0x0000, 0xFBC0,0x8EE5,0x0000, 0xFBC0,0x8EE6,0x0000,
0xFBC0,0x8EE7,0x0000, 0xFBC0,0x8EE8,0x0000, 0xFBC0,0x8EE9,0x0000,
0xFBC0,0x8EEA,0x0000, 0xFBC0,0x8EEB,0x0000, 0xFBC0,0x8EEC,0x0000,
0xFBC0,0x8EED,0x0000, 0xFBC0,0x8EEE,0x0000, 0xFBC0,0x8EEF,0x0000,
0xFBC0,0x8EF0,0x0000, 0xFBC0,0x8EF1,0x0000, 0xFBC0,0x8EF2,0x0000,
0xFBC0,0x8EF3,0x0000, 0xFBC0,0x8EF4,0x0000, 0xFBC0,0x8EF5,0x0000,
0xFBC0,0x8EF6,0x0000, 0xFBC0,0x8EF7,0x0000, 0xFBC0,0x8EF8,0x0000,
0xFBC0,0x8EF9,0x0000, 0xFBC0,0x8EFA,0x0000, 0xFBC0,0x8EFB,0x0000,
0xFBC0,0x8EFC,0x0000, 0xFBC0,0x8EFD,0x0000, 0xFBC0,0x8EFE,0x0000,
0xFBC0,0x8EFF,0x0000 };

uint16 page00Fdata[]= { /* 0F00 (3 weights per char) */
0x189A,0x18AD,0x0000, 0x035A,0x0000,0x0000, 0x035B,0x0000,0x0000,
0x035C,0x0000,0x0000, 0x02FE,0x0000,0x0000, 0x02FF,0x0000,0x0000,
0x0300,0x0000,0x0000, 0x0301,0x0000,0x0000, 0x0302,0x0000,0x0000,
0x0303,0x0000,0x0000, 0x0304,0x0000,0x0000, 0x0305,0x0000,0x0000,
0x0305,0x0000,0x0000, 0x0306,0x0000,0x0000, 0x0307,0x0000,0x0000,
0x0308,0x0000,0x0000, 0x0309,0x0000,0x0000, 0x030A,0x0000,0x0000,
0x030B,0x0000,0x0000, 0x035D,0x0000,0x0000, 0x024C,0x0000,0x0000,
0x035E,0x0000,0x0000, 0x035F,0x0000,0x0000, 0x0360,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0361,0x0000,0x0000,
0x0362,0x0000,0x0000, 0x0363,0x0000,0x0000, 0x0364,0x0000,0x0000,
0x0365,0x0000,0x0000, 0x0366,0x0000,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E29,0x0000,0x0000, 0x0367,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0368,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0369,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x028E,0x0000,0x0000, 0x028F,0x0000,0x0000,
0x0290,0x0000,0x0000, 0x0291,0x0000,0x0000, 0x036A,0x0000,0x0000,
0x036B,0x0000,0x0000, 0x1856,0x0000,0x0000, 0x1858,0x0000,0x0000,
0x185A,0x0000,0x0000, 0x185A,0x1899,0x0000, 0x185C,0x0000,0x0000,
0x185E,0x0000,0x0000, 0x1860,0x0000,0x0000, 0x1862,0x0000,0x0000,
0xFBC0,0x8F48,0x0000, 0x1864,0x0000,0x0000, 0x1866,0x0000,0x0000,
0x1868,0x0000,0x0000, 0x186A,0x0000,0x0000, 0x186A,0x1899,0x0000,
0x186C,0x0000,0x0000, 0x186E,0x0000,0x0000, 0x1870,0x0000,0x0000,
0x1872,0x0000,0x0000, 0x1872,0x1899,0x0000, 0x1874,0x0000,0x0000,
0x1876,0x0000,0x0000, 0x1878,0x0000,0x0000, 0x187A,0x0000,0x0000,
0x187A,0x1899,0x0000, 0x187C,0x0000,0x0000, 0x187E,0x0000,0x0000,
0x1880,0x0000,0x0000, 0x1882,0x0000,0x0000, 0x1882,0x1899,0x0000,
0x1884,0x0000,0x0000, 0x1886,0x0000,0x0000, 0x1888,0x0000,0x0000,
0x188A,0x0000,0x0000, 0x188C,0x0000,0x0000, 0x188E,0x0000,0x0000,
0x1890,0x0000,0x0000, 0x1892,0x0000,0x0000, 0x1894,0x0000,0x0000,
0x1896,0x0000,0x0000, 0x1898,0x0000,0x0000, 0x189A,0x0000,0x0000,
0x1856,0x1895,0x0000, 0x188E,0x0000,0x0000, 0xFBC0,0x8F6B,0x0000,
0xFBC0,0x8F6C,0x0000, 0xFBC0,0x8F6D,0x0000, 0xFBC0,0x8F6E,0x0000,
0xFBC0,0x8F6F,0x0000, 0xFBC0,0x8F70,0x0000, 0x18A0,0x0000,0x0000,
0x18A1,0x0000,0x0000, 0x18A2,0x0000,0x0000, 0x18A5,0x0000,0x0000,
0x18A6,0x0000,0x0000, 0x18A7,0x0000,0x0000, 0x18A8,0x0000,0x0000,
0x18A9,0x0000,0x0000, 0x18AA,0x0000,0x0000, 0x18AB,0x0000,0x0000,
0x18AC,0x0000,0x0000, 0x18AD,0x0000,0x0000, 0x18AE,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x18A3,0x0000,0x0000,
0x18A4,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x18AF,0x0000,0x0000, 0x030C,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x189C,0x0000,0x0000, 0x189D,0x0000,0x0000,
0x189E,0x0000,0x0000, 0x189F,0x0000,0x0000, 0xFBC0,0x8F8C,0x0000,
0xFBC0,0x8F8D,0x0000, 0xFBC0,0x8F8E,0x0000, 0xFBC0,0x8F8F,0x0000,
0x1857,0x0000,0x0000, 0x1859,0x0000,0x0000, 0x185B,0x0000,0x0000,
0x185B,0x1899,0x0000, 0x185D,0x0000,0x0000, 0x185F,0x0000,0x0000,
0x1861,0x0000,0x0000, 0x1863,0x0000,0x0000, 0xFBC0,0x8F98,0x0000,
0x1865,0x0000,0x0000, 0x1867,0x0000,0x0000, 0x1869,0x0000,0x0000,
0x186B,0x0000,0x0000, 0x186B,0x1899,0x0000, 0x186D,0x0000,0x0000,
0x186F,0x0000,0x0000, 0x1871,0x0000,0x0000, 0x1873,0x0000,0x0000,
0x1873,0x1899,0x0000, 0x1875,0x0000,0x0000, 0x1877,0x0000,0x0000,
0x1879,0x0000,0x0000, 0x187B,0x0000,0x0000, 0x187B,0x1899,0x0000,
0x187D,0x0000,0x0000, 0x187F,0x0000,0x0000, 0x1881,0x0000,0x0000,
0x1883,0x0000,0x0000, 0x1883,0x1899,0x0000, 0x1885,0x0000,0x0000,
0x1887,0x0000,0x0000, 0x1889,0x0000,0x0000, 0x188B,0x0000,0x0000,
0x188D,0x0000,0x0000, 0x188F,0x0000,0x0000, 0x1891,0x0000,0x0000,
0x1893,0x0000,0x0000, 0x1895,0x0000,0x0000, 0x1897,0x0000,0x0000,
0x1899,0x0000,0x0000, 0x189B,0x0000,0x0000, 0x1857,0x1895,0x0000,
0x1885,0x0000,0x0000, 0x188D,0x0000,0x0000, 0x188F,0x0000,0x0000,
0xFBC0,0x8FBD,0x0000, 0x036C,0x0000,0x0000, 0x036D,0x0000,0x0000,
0x036E,0x0000,0x0000, 0x036F,0x0000,0x0000, 0x0370,0x0000,0x0000,
0x0371,0x0000,0x0000, 0x0372,0x0000,0x0000, 0x0373,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0374,0x0000,0x0000, 0x0375,0x0000,0x0000,
0x0376,0x0000,0x0000, 0x0377,0x0000,0x0000, 0x0378,0x0000,0x0000,
0x0379,0x0000,0x0000, 0xFBC0,0x8FCD,0x0000, 0xFBC0,0x8FCE,0x0000,
0x037A,0x0000,0x0000, 0xFBC0,0x8FD0,0x0000, 0xFBC0,0x8FD1,0x0000,
0xFBC0,0x8FD2,0x0000, 0xFBC0,0x8FD3,0x0000, 0xFBC0,0x8FD4,0x0000,
0xFBC0,0x8FD5,0x0000, 0xFBC0,0x8FD6,0x0000, 0xFBC0,0x8FD7,0x0000,
0xFBC0,0x8FD8,0x0000, 0xFBC0,0x8FD9,0x0000, 0xFBC0,0x8FDA,0x0000,
0xFBC0,0x8FDB,0x0000, 0xFBC0,0x8FDC,0x0000, 0xFBC0,0x8FDD,0x0000,
0xFBC0,0x8FDE,0x0000, 0xFBC0,0x8FDF,0x0000, 0xFBC0,0x8FE0,0x0000,
0xFBC0,0x8FE1,0x0000, 0xFBC0,0x8FE2,0x0000, 0xFBC0,0x8FE3,0x0000,
0xFBC0,0x8FE4,0x0000, 0xFBC0,0x8FE5,0x0000, 0xFBC0,0x8FE6,0x0000,
0xFBC0,0x8FE7,0x0000, 0xFBC0,0x8FE8,0x0000, 0xFBC0,0x8FE9,0x0000,
0xFBC0,0x8FEA,0x0000, 0xFBC0,0x8FEB,0x0000, 0xFBC0,0x8FEC,0x0000,
0xFBC0,0x8FED,0x0000, 0xFBC0,0x8FEE,0x0000, 0xFBC0,0x8FEF,0x0000,
0xFBC0,0x8FF0,0x0000, 0xFBC0,0x8FF1,0x0000, 0xFBC0,0x8FF2,0x0000,
0xFBC0,0x8FF3,0x0000, 0xFBC0,0x8FF4,0x0000, 0xFBC0,0x8FF5,0x0000,
0xFBC0,0x8FF6,0x0000, 0xFBC0,0x8FF7,0x0000, 0xFBC0,0x8FF8,0x0000,
0xFBC0,0x8FF9,0x0000, 0xFBC0,0x8FFA,0x0000, 0xFBC0,0x8FFB,0x0000,
0xFBC0,0x8FFC,0x0000, 0xFBC0,0x8FFD,0x0000, 0xFBC0,0x8FFE,0x0000,
0xFBC0,0x8FFF,0x0000 };

uint16 page010data[]= { /* 1000 (3 weights per char) */
0x1931,0x0000,0x0000, 0x1932,0x0000,0x0000, 0x1933,0x0000,0x0000,
0x1934,0x0000,0x0000, 0x1935,0x0000,0x0000, 0x1936,0x0000,0x0000,
0x1937,0x0000,0x0000, 0x1938,0x0000,0x0000, 0x1939,0x0000,0x0000,
0x193A,0x0000,0x0000, 0x193B,0x0000,0x0000, 0x193C,0x0000,0x0000,
0x193D,0x0000,0x0000, 0x193E,0x0000,0x0000, 0x193F,0x0000,0x0000,
0x1940,0x0000,0x0000, 0x1941,0x0000,0x0000, 0x1942,0x0000,0x0000,
0x1943,0x0000,0x0000, 0x1944,0x0000,0x0000, 0x1945,0x0000,0x0000,
0x1946,0x0000,0x0000, 0x1947,0x0000,0x0000, 0x1948,0x0000,0x0000,
0x1949,0x0000,0x0000, 0x194A,0x0000,0x0000, 0x194B,0x0000,0x0000,
0x194C,0x0000,0x0000, 0x194D,0x0000,0x0000, 0x194E,0x0000,0x0000,
0x1951,0x0000,0x0000, 0x1952,0x0000,0x0000, 0x1953,0x0000,0x0000,
0x1954,0x0000,0x0000, 0xFBC0,0x9022,0x0000, 0x1955,0x0000,0x0000,
0x1956,0x0000,0x0000, 0x1957,0x0000,0x0000, 0x1958,0x0000,0x0000,
0x1959,0x0000,0x0000, 0xFBC0,0x9028,0x0000, 0x195A,0x0000,0x0000,
0x195B,0x0000,0x0000, 0xFBC0,0x902B,0x0000, 0x1960,0x0000,0x0000,
0x1961,0x0000,0x0000, 0x1962,0x0000,0x0000, 0x1963,0x0000,0x0000,
0x1964,0x0000,0x0000, 0x1965,0x0000,0x0000, 0x1966,0x0000,0x0000,
0xFBC0,0x9033,0x0000, 0xFBC0,0x9034,0x0000, 0xFBC0,0x9035,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x196B,0x0000,0x0000, 0xFBC0,0x903A,0x0000, 0xFBC0,0x903B,0x0000,
0xFBC0,0x903C,0x0000, 0xFBC0,0x903D,0x0000, 0xFBC0,0x903E,0x0000,
0xFBC0,0x903F,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x026C,0x0000,0x0000,
0x026D,0x0000,0x0000, 0x030E,0x0000,0x0000, 0x030F,0x0000,0x0000,
0x0310,0x0000,0x0000, 0x0311,0x0000,0x0000, 0x194F,0x0000,0x0000,
0x1950,0x0000,0x0000, 0x195C,0x0000,0x0000, 0x195D,0x0000,0x0000,
0x195E,0x0000,0x0000, 0x195F,0x0000,0x0000, 0x1967,0x0000,0x0000,
0x1968,0x0000,0x0000, 0x1969,0x0000,0x0000, 0x196A,0x0000,0x0000,
0xFBC0,0x905A,0x0000, 0xFBC0,0x905B,0x0000, 0xFBC0,0x905C,0x0000,
0xFBC0,0x905D,0x0000, 0xFBC0,0x905E,0x0000, 0xFBC0,0x905F,0x0000,
0xFBC0,0x9060,0x0000, 0xFBC0,0x9061,0x0000, 0xFBC0,0x9062,0x0000,
0xFBC0,0x9063,0x0000, 0xFBC0,0x9064,0x0000, 0xFBC0,0x9065,0x0000,
0xFBC0,0x9066,0x0000, 0xFBC0,0x9067,0x0000, 0xFBC0,0x9068,0x0000,
0xFBC0,0x9069,0x0000, 0xFBC0,0x906A,0x0000, 0xFBC0,0x906B,0x0000,
0xFBC0,0x906C,0x0000, 0xFBC0,0x906D,0x0000, 0xFBC0,0x906E,0x0000,
0xFBC0,0x906F,0x0000, 0xFBC0,0x9070,0x0000, 0xFBC0,0x9071,0x0000,
0xFBC0,0x9072,0x0000, 0xFBC0,0x9073,0x0000, 0xFBC0,0x9074,0x0000,
0xFBC0,0x9075,0x0000, 0xFBC0,0x9076,0x0000, 0xFBC0,0x9077,0x0000,
0xFBC0,0x9078,0x0000, 0xFBC0,0x9079,0x0000, 0xFBC0,0x907A,0x0000,
0xFBC0,0x907B,0x0000, 0xFBC0,0x907C,0x0000, 0xFBC0,0x907D,0x0000,
0xFBC0,0x907E,0x0000, 0xFBC0,0x907F,0x0000, 0xFBC0,0x9080,0x0000,
0xFBC0,0x9081,0x0000, 0xFBC0,0x9082,0x0000, 0xFBC0,0x9083,0x0000,
0xFBC0,0x9084,0x0000, 0xFBC0,0x9085,0x0000, 0xFBC0,0x9086,0x0000,
0xFBC0,0x9087,0x0000, 0xFBC0,0x9088,0x0000, 0xFBC0,0x9089,0x0000,
0xFBC0,0x908A,0x0000, 0xFBC0,0x908B,0x0000, 0xFBC0,0x908C,0x0000,
0xFBC0,0x908D,0x0000, 0xFBC0,0x908E,0x0000, 0xFBC0,0x908F,0x0000,
0xFBC0,0x9090,0x0000, 0xFBC0,0x9091,0x0000, 0xFBC0,0x9092,0x0000,
0xFBC0,0x9093,0x0000, 0xFBC0,0x9094,0x0000, 0xFBC0,0x9095,0x0000,
0xFBC0,0x9096,0x0000, 0xFBC0,0x9097,0x0000, 0xFBC0,0x9098,0x0000,
0xFBC0,0x9099,0x0000, 0xFBC0,0x909A,0x0000, 0xFBC0,0x909B,0x0000,
0xFBC0,0x909C,0x0000, 0xFBC0,0x909D,0x0000, 0xFBC0,0x909E,0x0000,
0xFBC0,0x909F,0x0000, 0x12E1,0x0000,0x0000, 0x12E2,0x0000,0x0000,
0x12E3,0x0000,0x0000, 0x12E4,0x0000,0x0000, 0x12E5,0x0000,0x0000,
0x12E6,0x0000,0x0000, 0x12E7,0x0000,0x0000, 0x12E9,0x0000,0x0000,
0x12EA,0x0000,0x0000, 0x12EB,0x0000,0x0000, 0x12EC,0x0000,0x0000,
0x12ED,0x0000,0x0000, 0x12EE,0x0000,0x0000, 0x12F0,0x0000,0x0000,
0x12F1,0x0000,0x0000, 0x12F2,0x0000,0x0000, 0x12F3,0x0000,0x0000,
0x12F4,0x0000,0x0000, 0x12F5,0x0000,0x0000, 0x12F7,0x0000,0x0000,
0x12F8,0x0000,0x0000, 0x12F9,0x0000,0x0000, 0x12FA,0x0000,0x0000,
0x12FB,0x0000,0x0000, 0x12FC,0x0000,0x0000, 0x12FD,0x0000,0x0000,
0x12FE,0x0000,0x0000, 0x12FF,0x0000,0x0000, 0x1300,0x0000,0x0000,
0x1301,0x0000,0x0000, 0x1302,0x0000,0x0000, 0x1304,0x0000,0x0000,
0x1305,0x0000,0x0000, 0x12E8,0x0000,0x0000, 0x12EF,0x0000,0x0000,
0x12F6,0x0000,0x0000, 0x1303,0x0000,0x0000, 0x1306,0x0000,0x0000,
0xFBC0,0x90C6,0x0000, 0xFBC0,0x90C7,0x0000, 0xFBC0,0x90C8,0x0000,
0xFBC0,0x90C9,0x0000, 0xFBC0,0x90CA,0x0000, 0xFBC0,0x90CB,0x0000,
0xFBC0,0x90CC,0x0000, 0xFBC0,0x90CD,0x0000, 0xFBC0,0x90CE,0x0000,
0xFBC0,0x90CF,0x0000, 0x12E1,0x0000,0x0000, 0x12E2,0x0000,0x0000,
0x12E3,0x0000,0x0000, 0x12E4,0x0000,0x0000, 0x12E5,0x0000,0x0000,
0x12E6,0x0000,0x0000, 0x12E7,0x0000,0x0000, 0x12E9,0x0000,0x0000,
0x12EA,0x0000,0x0000, 0x12EB,0x0000,0x0000, 0x12EC,0x0000,0x0000,
0x12ED,0x0000,0x0000, 0x12EE,0x0000,0x0000, 0x12F0,0x0000,0x0000,
0x12F1,0x0000,0x0000, 0x12F2,0x0000,0x0000, 0x12F3,0x0000,0x0000,
0x12F4,0x0000,0x0000, 0x12F5,0x0000,0x0000, 0x12F7,0x0000,0x0000,
0x12F8,0x0000,0x0000, 0x12F9,0x0000,0x0000, 0x12FA,0x0000,0x0000,
0x12FB,0x0000,0x0000, 0x12FC,0x0000,0x0000, 0x12FD,0x0000,0x0000,
0x12FE,0x0000,0x0000, 0x12FF,0x0000,0x0000, 0x1300,0x0000,0x0000,
0x1301,0x0000,0x0000, 0x1302,0x0000,0x0000, 0x1304,0x0000,0x0000,
0x1305,0x0000,0x0000, 0x12E8,0x0000,0x0000, 0x12EF,0x0000,0x0000,
0x12F6,0x0000,0x0000, 0x1303,0x0000,0x0000, 0x1306,0x0000,0x0000,
0x1307,0x0000,0x0000, 0x1308,0x0000,0x0000, 0x1309,0x0000,0x0000,
0xFBC0,0x90F9,0x0000, 0xFBC0,0x90FA,0x0000, 0x0271,0x0000,0x0000,
0xFBC0,0x90FC,0x0000, 0xFBC0,0x90FD,0x0000, 0xFBC0,0x90FE,0x0000,
0xFBC0,0x90FF,0x0000 };

uint16 page011data[]= { /* 1100 (3 weights per char) */
0x1D62,0x0000,0x0000, 0x1D63,0x0000,0x0000, 0x1D64,0x0000,0x0000,
0x1D65,0x0000,0x0000, 0x1D66,0x0000,0x0000, 0x1D67,0x0000,0x0000,
0x1D68,0x0000,0x0000, 0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000,
0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000, 0x1D6D,0x0000,0x0000,
0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000, 0x1D70,0x0000,0x0000,
0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000, 0x1D73,0x0000,0x0000,
0x1D74,0x0000,0x0000, 0x1D75,0x0000,0x0000, 0x1D76,0x0000,0x0000,
0x1D77,0x0000,0x0000, 0x1D78,0x0000,0x0000, 0x1D79,0x0000,0x0000,
0x1D7A,0x0000,0x0000, 0x1D7B,0x0000,0x0000, 0x1D7C,0x0000,0x0000,
0x1D7D,0x0000,0x0000, 0x1D7E,0x0000,0x0000, 0x1D7F,0x0000,0x0000,
0x1D80,0x0000,0x0000, 0x1D81,0x0000,0x0000, 0x1D82,0x0000,0x0000,
0x1D83,0x0000,0x0000, 0x1D84,0x0000,0x0000, 0x1D85,0x0000,0x0000,
0x1D86,0x0000,0x0000, 0x1D87,0x0000,0x0000, 0x1D88,0x0000,0x0000,
0x1D89,0x0000,0x0000, 0x1D8A,0x0000,0x0000, 0x1D8B,0x0000,0x0000,
0x1D8C,0x0000,0x0000, 0x1D8D,0x0000,0x0000, 0x1D8E,0x0000,0x0000,
0x1D8F,0x0000,0x0000, 0x1D90,0x0000,0x0000, 0x1D91,0x0000,0x0000,
0x1D92,0x0000,0x0000, 0x1D93,0x0000,0x0000, 0x1D94,0x0000,0x0000,
0x1D95,0x0000,0x0000, 0x1D96,0x0000,0x0000, 0x1D97,0x0000,0x0000,
0x1D98,0x0000,0x0000, 0x1D99,0x0000,0x0000, 0x1D9A,0x0000,0x0000,
0x1D9B,0x0000,0x0000, 0x1D9C,0x0000,0x0000, 0x1D9D,0x0000,0x0000,
0x1D9E,0x0000,0x0000, 0x1D9F,0x0000,0x0000, 0x1DA0,0x0000,0x0000,
0x1DA1,0x0000,0x0000, 0x1DA2,0x0000,0x0000, 0x1DA3,0x0000,0x0000,
0x1DA4,0x0000,0x0000, 0x1DA5,0x0000,0x0000, 0x1DA6,0x0000,0x0000,
0x1DA7,0x0000,0x0000, 0x1DA8,0x0000,0x0000, 0x1DA9,0x0000,0x0000,
0x1DAA,0x0000,0x0000, 0x1DAB,0x0000,0x0000, 0x1DAC,0x0000,0x0000,
0x1DAD,0x0000,0x0000, 0x1DAE,0x0000,0x0000, 0x1DAF,0x0000,0x0000,
0x1DB0,0x0000,0x0000, 0x1DB1,0x0000,0x0000, 0x1DB2,0x0000,0x0000,
0x1DB3,0x0000,0x0000, 0x1DB4,0x0000,0x0000, 0x1DB5,0x0000,0x0000,
0x1DB6,0x0000,0x0000, 0x1DB7,0x0000,0x0000, 0x1DB8,0x0000,0x0000,
0x1DB9,0x0000,0x0000, 0x1DBA,0x0000,0x0000, 0x1DBB,0x0000,0x0000,
0xFBC0,0x915A,0x0000, 0xFBC0,0x915B,0x0000, 0xFBC0,0x915C,0x0000,
0xFBC0,0x915D,0x0000, 0xFBC0,0x915E,0x0000, 0x1DBC,0x0000,0x0000,
0x1DBD,0x0000,0x0000, 0x1DBE,0x0000,0x0000, 0x1DBF,0x0000,0x0000,
0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000, 0x1DC2,0x0000,0x0000,
0x1DC3,0x0000,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000,
0x1DCC,0x0000,0x0000, 0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000,
0x1DCF,0x0000,0x0000, 0x1DD0,0x0000,0x0000, 0x1DD1,0x0000,0x0000,
0x1DD2,0x0000,0x0000, 0x1DD3,0x0000,0x0000, 0x1DD4,0x0000,0x0000,
0x1DD5,0x0000,0x0000, 0x1DD6,0x0000,0x0000, 0x1DD7,0x0000,0x0000,
0x1DD8,0x0000,0x0000, 0x1DD9,0x0000,0x0000, 0x1DDA,0x0000,0x0000,
0x1DDB,0x0000,0x0000, 0x1DDC,0x0000,0x0000, 0x1DDD,0x0000,0x0000,
0x1DDE,0x0000,0x0000, 0x1DDF,0x0000,0x0000, 0x1DE0,0x0000,0x0000,
0x1DE1,0x0000,0x0000, 0x1DE2,0x0000,0x0000, 0x1DE3,0x0000,0x0000,
0x1DE4,0x0000,0x0000, 0x1DE5,0x0000,0x0000, 0x1DE6,0x0000,0x0000,
0x1DE7,0x0000,0x0000, 0x1DE8,0x0000,0x0000, 0x1DE9,0x0000,0x0000,
0x1DEA,0x0000,0x0000, 0x1DEB,0x0000,0x0000, 0x1DEC,0x0000,0x0000,
0x1DED,0x0000,0x0000, 0x1DEE,0x0000,0x0000, 0x1DEF,0x0000,0x0000,
0x1DF0,0x0000,0x0000, 0x1DF1,0x0000,0x0000, 0x1DF2,0x0000,0x0000,
0x1DF3,0x0000,0x0000, 0x1DF4,0x0000,0x0000, 0x1DF5,0x0000,0x0000,
0x1DF6,0x0000,0x0000, 0x1DF7,0x0000,0x0000, 0x1DF8,0x0000,0x0000,
0x1DF9,0x0000,0x0000, 0x1DFA,0x0000,0x0000, 0x1DFB,0x0000,0x0000,
0x1DFC,0x0000,0x0000, 0x1DFD,0x0000,0x0000, 0x1DFE,0x0000,0x0000,
0x1DFF,0x0000,0x0000, 0xFBC0,0x91A3,0x0000, 0xFBC0,0x91A4,0x0000,
0xFBC0,0x91A5,0x0000, 0xFBC0,0x91A6,0x0000, 0xFBC0,0x91A7,0x0000,
0x1E00,0x0000,0x0000, 0x1E01,0x0000,0x0000, 0x1E02,0x0000,0x0000,
0x1E03,0x0000,0x0000, 0x1E04,0x0000,0x0000, 0x1E05,0x0000,0x0000,
0x1E06,0x0000,0x0000, 0x1E07,0x0000,0x0000, 0x1E08,0x0000,0x0000,
0x1E09,0x0000,0x0000, 0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000,
0x1E0C,0x0000,0x0000, 0x1E0D,0x0000,0x0000, 0x1E0E,0x0000,0x0000,
0x1E0F,0x0000,0x0000, 0x1E10,0x0000,0x0000, 0x1E11,0x0000,0x0000,
0x1E12,0x0000,0x0000, 0x1E13,0x0000,0x0000, 0x1E14,0x0000,0x0000,
0x1E15,0x0000,0x0000, 0x1E16,0x0000,0x0000, 0x1E17,0x0000,0x0000,
0x1E18,0x0000,0x0000, 0x1E19,0x0000,0x0000, 0x1E1A,0x0000,0x0000,
0x1E1B,0x0000,0x0000, 0x1E1C,0x0000,0x0000, 0x1E1D,0x0000,0x0000,
0x1E1E,0x0000,0x0000, 0x1E1F,0x0000,0x0000, 0x1E20,0x0000,0x0000,
0x1E21,0x0000,0x0000, 0x1E22,0x0000,0x0000, 0x1E23,0x0000,0x0000,
0x1E24,0x0000,0x0000, 0x1E25,0x0000,0x0000, 0x1E26,0x0000,0x0000,
0x1E27,0x0000,0x0000, 0x1E28,0x0000,0x0000, 0x1E29,0x0000,0x0000,
0x1E2A,0x0000,0x0000, 0x1E2B,0x0000,0x0000, 0x1E2C,0x0000,0x0000,
0x1E2D,0x0000,0x0000, 0x1E2E,0x0000,0x0000, 0x1E2F,0x0000,0x0000,
0x1E30,0x0000,0x0000, 0x1E31,0x0000,0x0000, 0x1E32,0x0000,0x0000,
0x1E33,0x0000,0x0000, 0x1E34,0x0000,0x0000, 0x1E35,0x0000,0x0000,
0x1E36,0x0000,0x0000, 0x1E37,0x0000,0x0000, 0x1E38,0x0000,0x0000,
0x1E39,0x0000,0x0000, 0x1E3A,0x0000,0x0000, 0x1E3B,0x0000,0x0000,
0x1E3C,0x0000,0x0000, 0x1E3D,0x0000,0x0000, 0x1E3E,0x0000,0x0000,
0x1E3F,0x0000,0x0000, 0x1E40,0x0000,0x0000, 0x1E41,0x0000,0x0000,
0x1E42,0x0000,0x0000, 0x1E43,0x0000,0x0000, 0x1E44,0x0000,0x0000,
0x1E45,0x0000,0x0000, 0x1E46,0x0000,0x0000, 0x1E47,0x0000,0x0000,
0x1E48,0x0000,0x0000, 0x1E49,0x0000,0x0000, 0x1E4A,0x0000,0x0000,
0x1E4B,0x0000,0x0000, 0x1E4C,0x0000,0x0000, 0x1E4D,0x0000,0x0000,
0x1E4E,0x0000,0x0000, 0x1E4F,0x0000,0x0000, 0x1E50,0x0000,0x0000,
0x1E51,0x0000,0x0000, 0xFBC0,0x91FA,0x0000, 0xFBC0,0x91FB,0x0000,
0xFBC0,0x91FC,0x0000, 0xFBC0,0x91FD,0x0000, 0xFBC0,0x91FE,0x0000,
0xFBC0,0x91FF,0x0000 };

uint16 page012data[]= { /* 1200 (3 weights per char) */
0x141C,0x0000,0x0000, 0x141D,0x0000,0x0000, 0x141E,0x0000,0x0000,
0x141F,0x0000,0x0000, 0x1420,0x0000,0x0000, 0x1421,0x0000,0x0000,
0x1422,0x0000,0x0000, 0xFBC0,0x9207,0x0000, 0x1423,0x0000,0x0000,
0x1424,0x0000,0x0000, 0x1425,0x0000,0x0000, 0x1426,0x0000,0x0000,
0x1427,0x0000,0x0000, 0x1428,0x0000,0x0000, 0x1429,0x0000,0x0000,
0x142A,0x0000,0x0000, 0x142B,0x0000,0x0000, 0x142C,0x0000,0x0000,
0x142D,0x0000,0x0000, 0x142E,0x0000,0x0000, 0x142F,0x0000,0x0000,
0x1430,0x0000,0x0000, 0x1431,0x0000,0x0000, 0x1432,0x0000,0x0000,
0x1433,0x0000,0x0000, 0x1434,0x0000,0x0000, 0x1435,0x0000,0x0000,
0x1436,0x0000,0x0000, 0x1437,0x0000,0x0000, 0x1438,0x0000,0x0000,
0x1439,0x0000,0x0000, 0x143A,0x0000,0x0000, 0x143B,0x0000,0x0000,
0x143C,0x0000,0x0000, 0x143D,0x0000,0x0000, 0x143E,0x0000,0x0000,
0x143F,0x0000,0x0000, 0x1440,0x0000,0x0000, 0x1441,0x0000,0x0000,
0x1442,0x0000,0x0000, 0x1443,0x0000,0x0000, 0x1444,0x0000,0x0000,
0x1445,0x0000,0x0000, 0x1446,0x0000,0x0000, 0x1447,0x0000,0x0000,
0x1448,0x0000,0x0000, 0x1449,0x0000,0x0000, 0x144A,0x0000,0x0000,
0x144B,0x0000,0x0000, 0x144C,0x0000,0x0000, 0x144D,0x0000,0x0000,
0x144E,0x0000,0x0000, 0x144F,0x0000,0x0000, 0x1450,0x0000,0x0000,
0x1451,0x0000,0x0000, 0x1452,0x0000,0x0000, 0x1453,0x0000,0x0000,
0x1454,0x0000,0x0000, 0x1455,0x0000,0x0000, 0x1456,0x0000,0x0000,
0x1457,0x0000,0x0000, 0x1458,0x0000,0x0000, 0x1459,0x0000,0x0000,
0x145A,0x0000,0x0000, 0x145B,0x0000,0x0000, 0x145C,0x0000,0x0000,
0x145D,0x0000,0x0000, 0x145E,0x0000,0x0000, 0x145F,0x0000,0x0000,
0x1460,0x0000,0x0000, 0x1461,0x0000,0x0000, 0xFBC0,0x9247,0x0000,
0x1462,0x0000,0x0000, 0xFBC0,0x9249,0x0000, 0x1463,0x0000,0x0000,
0x1464,0x0000,0x0000, 0x1465,0x0000,0x0000, 0x1466,0x0000,0x0000,
0xFBC0,0x924E,0x0000, 0xFBC0,0x924F,0x0000, 0x1467,0x0000,0x0000,
0x1468,0x0000,0x0000, 0x1469,0x0000,0x0000, 0x146A,0x0000,0x0000,
0x146B,0x0000,0x0000, 0x146C,0x0000,0x0000, 0x146D,0x0000,0x0000,
0xFBC0,0x9257,0x0000, 0x146E,0x0000,0x0000, 0xFBC0,0x9259,0x0000,
0x146F,0x0000,0x0000, 0x1470,0x0000,0x0000, 0x1471,0x0000,0x0000,
0x1472,0x0000,0x0000, 0xFBC0,0x925E,0x0000, 0xFBC0,0x925F,0x0000,
0x1473,0x0000,0x0000, 0x1474,0x0000,0x0000, 0x1475,0x0000,0x0000,
0x1476,0x0000,0x0000, 0x1477,0x0000,0x0000, 0x1478,0x0000,0x0000,
0x1479,0x0000,0x0000, 0x147A,0x0000,0x0000, 0x147B,0x0000,0x0000,
0x147C,0x0000,0x0000, 0x147D,0x0000,0x0000, 0x147E,0x0000,0x0000,
0x147F,0x0000,0x0000, 0x1480,0x0000,0x0000, 0x1481,0x0000,0x0000,
0x1482,0x0000,0x0000, 0x1483,0x0000,0x0000, 0x1484,0x0000,0x0000,
0x1485,0x0000,0x0000, 0x1486,0x0000,0x0000, 0x1487,0x0000,0x0000,
0x1488,0x0000,0x0000, 0x1489,0x0000,0x0000, 0x148A,0x0000,0x0000,
0x148B,0x0000,0x0000, 0x148C,0x0000,0x0000, 0x148D,0x0000,0x0000,
0x148E,0x0000,0x0000, 0x148F,0x0000,0x0000, 0x1490,0x0000,0x0000,
0x1491,0x0000,0x0000, 0x1492,0x0000,0x0000, 0x1493,0x0000,0x0000,
0x1494,0x0000,0x0000, 0x1495,0x0000,0x0000, 0x1496,0x0000,0x0000,
0x1497,0x0000,0x0000, 0x1498,0x0000,0x0000, 0x1499,0x0000,0x0000,
0xFBC0,0x9287,0x0000, 0x149A,0x0000,0x0000, 0xFBC0,0x9289,0x0000,
0x149B,0x0000,0x0000, 0x149C,0x0000,0x0000, 0x149D,0x0000,0x0000,
0x149E,0x0000,0x0000, 0xFBC0,0x928E,0x0000, 0xFBC0,0x928F,0x0000,
0x149F,0x0000,0x0000, 0x14A0,0x0000,0x0000, 0x14A1,0x0000,0x0000,
0x14A2,0x0000,0x0000, 0x14A3,0x0000,0x0000, 0x14A4,0x0000,0x0000,
0x14A5,0x0000,0x0000, 0x14A6,0x0000,0x0000, 0x14A7,0x0000,0x0000,
0x14A8,0x0000,0x0000, 0x14A9,0x0000,0x0000, 0x14AA,0x0000,0x0000,
0x14AB,0x0000,0x0000, 0x14AC,0x0000,0x0000, 0x14AD,0x0000,0x0000,
0x14AE,0x0000,0x0000, 0x14AF,0x0000,0x0000, 0x14B0,0x0000,0x0000,
0x14B1,0x0000,0x0000, 0x14B2,0x0000,0x0000, 0x14B3,0x0000,0x0000,
0x14B4,0x0000,0x0000, 0x14B5,0x0000,0x0000, 0x14B6,0x0000,0x0000,
0x14B7,0x0000,0x0000, 0x14B8,0x0000,0x0000, 0x14B9,0x0000,0x0000,
0x14BA,0x0000,0x0000, 0x14BB,0x0000,0x0000, 0x14BC,0x0000,0x0000,
0x14BD,0x0000,0x0000, 0xFBC0,0x92AF,0x0000, 0x14BE,0x0000,0x0000,
0xFBC0,0x92B1,0x0000, 0x14BF,0x0000,0x0000, 0x14C0,0x0000,0x0000,
0x14C1,0x0000,0x0000, 0x14C2,0x0000,0x0000, 0xFBC0,0x92B6,0x0000,
0xFBC0,0x92B7,0x0000, 0x14C3,0x0000,0x0000, 0x14C4,0x0000,0x0000,
0x14C5,0x0000,0x0000, 0x14C6,0x0000,0x0000, 0x14C7,0x0000,0x0000,
0x14C8,0x0000,0x0000, 0x14C9,0x0000,0x0000, 0xFBC0,0x92BF,0x0000,
0x14CA,0x0000,0x0000, 0xFBC0,0x92C1,0x0000, 0x14CB,0x0000,0x0000,
0x14CC,0x0000,0x0000, 0x14CD,0x0000,0x0000, 0x14CE,0x0000,0x0000,
0xFBC0,0x92C6,0x0000, 0xFBC0,0x92C7,0x0000, 0x14CF,0x0000,0x0000,
0x14D0,0x0000,0x0000, 0x14D1,0x0000,0x0000, 0x14D2,0x0000,0x0000,
0x14D3,0x0000,0x0000, 0x14D4,0x0000,0x0000, 0x14D5,0x0000,0x0000,
0xFBC0,0x92CF,0x0000, 0x14D6,0x0000,0x0000, 0x14D7,0x0000,0x0000,
0x14D8,0x0000,0x0000, 0x14D9,0x0000,0x0000, 0x14DA,0x0000,0x0000,
0x14DB,0x0000,0x0000, 0x14DC,0x0000,0x0000, 0xFBC0,0x92D7,0x0000,
0x14DD,0x0000,0x0000, 0x14DE,0x0000,0x0000, 0x14DF,0x0000,0x0000,
0x14E0,0x0000,0x0000, 0x14E1,0x0000,0x0000, 0x14E2,0x0000,0x0000,
0x14E3,0x0000,0x0000, 0x14E4,0x0000,0x0000, 0x14E5,0x0000,0x0000,
0x14E6,0x0000,0x0000, 0x14E7,0x0000,0x0000, 0x14E8,0x0000,0x0000,
0x14E9,0x0000,0x0000, 0x14EA,0x0000,0x0000, 0x14EB,0x0000,0x0000,
0x14EC,0x0000,0x0000, 0x14ED,0x0000,0x0000, 0x14EE,0x0000,0x0000,
0x14EF,0x0000,0x0000, 0x14F0,0x0000,0x0000, 0x14F1,0x0000,0x0000,
0x14F2,0x0000,0x0000, 0x14F3,0x0000,0x0000, 0xFBC0,0x92EF,0x0000,
0x14F4,0x0000,0x0000, 0x14F5,0x0000,0x0000, 0x14F6,0x0000,0x0000,
0x14F7,0x0000,0x0000, 0x14F8,0x0000,0x0000, 0x14F9,0x0000,0x0000,
0x14FA,0x0000,0x0000, 0x14FB,0x0000,0x0000, 0x14FC,0x0000,0x0000,
0x14FD,0x0000,0x0000, 0x14FE,0x0000,0x0000, 0x14FF,0x0000,0x0000,
0x1500,0x0000,0x0000, 0x1501,0x0000,0x0000, 0x1502,0x0000,0x0000,
0x1503,0x0000,0x0000 };

uint16 page013data[]= { /* 1300 (3 weights per char) */
0x1504,0x0000,0x0000, 0x1505,0x0000,0x0000, 0x1506,0x0000,0x0000,
0x1507,0x0000,0x0000, 0x1508,0x0000,0x0000, 0x1509,0x0000,0x0000,
0x150A,0x0000,0x0000, 0x150B,0x0000,0x0000, 0x150C,0x0000,0x0000,
0x150D,0x0000,0x0000, 0x150E,0x0000,0x0000, 0x150F,0x0000,0x0000,
0x1510,0x0000,0x0000, 0x1511,0x0000,0x0000, 0x1512,0x0000,0x0000,
0xFBC0,0x930F,0x0000, 0x1513,0x0000,0x0000, 0xFBC0,0x9311,0x0000,
0x1514,0x0000,0x0000, 0x1515,0x0000,0x0000, 0x1516,0x0000,0x0000,
0x1517,0x0000,0x0000, 0xFBC0,0x9316,0x0000, 0xFBC0,0x9317,0x0000,
0x1518,0x0000,0x0000, 0x1519,0x0000,0x0000, 0x151A,0x0000,0x0000,
0x151B,0x0000,0x0000, 0x151C,0x0000,0x0000, 0x151D,0x0000,0x0000,
0x151E,0x0000,0x0000, 0xFBC0,0x931F,0x0000, 0x151F,0x0000,0x0000,
0x1520,0x0000,0x0000, 0x1521,0x0000,0x0000, 0x1522,0x0000,0x0000,
0x1523,0x0000,0x0000, 0x1524,0x0000,0x0000, 0x1525,0x0000,0x0000,
0x1526,0x0000,0x0000, 0x1527,0x0000,0x0000, 0x1528,0x0000,0x0000,
0x1529,0x0000,0x0000, 0x152A,0x0000,0x0000, 0x152B,0x0000,0x0000,
0x152C,0x0000,0x0000, 0x152D,0x0000,0x0000, 0x152E,0x0000,0x0000,
0x152F,0x0000,0x0000, 0x1530,0x0000,0x0000, 0x1531,0x0000,0x0000,
0x1532,0x0000,0x0000, 0x1533,0x0000,0x0000, 0x1534,0x0000,0x0000,
0x1535,0x0000,0x0000, 0x1536,0x0000,0x0000, 0x1537,0x0000,0x0000,
0x1538,0x0000,0x0000, 0x1539,0x0000,0x0000, 0x153A,0x0000,0x0000,
0x153B,0x0000,0x0000, 0x153C,0x0000,0x0000, 0x153D,0x0000,0x0000,
0x153E,0x0000,0x0000, 0x153F,0x0000,0x0000, 0x1540,0x0000,0x0000,
0x1541,0x0000,0x0000, 0x1542,0x0000,0x0000, 0x1543,0x0000,0x0000,
0x1544,0x0000,0x0000, 0x1545,0x0000,0x0000, 0xFBC0,0x9347,0x0000,
0x1546,0x0000,0x0000, 0x1547,0x0000,0x0000, 0x1548,0x0000,0x0000,
0x1549,0x0000,0x0000, 0x154A,0x0000,0x0000, 0x154B,0x0000,0x0000,
0x154C,0x0000,0x0000, 0x154D,0x0000,0x0000, 0x154E,0x0000,0x0000,
0x154F,0x0000,0x0000, 0x1550,0x0000,0x0000, 0x1551,0x0000,0x0000,
0x1552,0x0000,0x0000, 0x1553,0x0000,0x0000, 0x1554,0x0000,0x0000,
0x1555,0x0000,0x0000, 0x1556,0x0000,0x0000, 0x1557,0x0000,0x0000,
0x1558,0x0000,0x0000, 0xFBC0,0x935B,0x0000, 0xFBC0,0x935C,0x0000,
0xFBC0,0x935D,0x0000, 0xFBC0,0x935E,0x0000, 0xFBC0,0x935F,0x0000,
0xFBC0,0x9360,0x0000, 0x0245,0x0000,0x0000, 0x0262,0x0000,0x0000,
0x0246,0x0000,0x0000, 0x0247,0x0000,0x0000, 0x0248,0x0000,0x0000,
0x0249,0x0000,0x0000, 0x025A,0x0000,0x0000, 0x0272,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0DCC,0x0000,0x0000, 0x0DCD,0x0000,0x0000, 0x0DCE,0x0000,0x0000,
0x0DCF,0x0000,0x0000, 0x0DD0,0x0000,0x0000, 0x0DD1,0x0000,0x0000,
0x0DD2,0x0000,0x0000, 0x0DD3,0x0000,0x0000, 0x0DD4,0x0000,0x0000,
0x0DD5,0x0000,0x0000, 0x0DD6,0x0000,0x0000, 0xFBC0,0x937D,0x0000,
0xFBC0,0x937E,0x0000, 0xFBC0,0x937F,0x0000, 0xFBC0,0x9380,0x0000,
0xFBC0,0x9381,0x0000, 0xFBC0,0x9382,0x0000, 0xFBC0,0x9383,0x0000,
0xFBC0,0x9384,0x0000, 0xFBC0,0x9385,0x0000, 0xFBC0,0x9386,0x0000,
0xFBC0,0x9387,0x0000, 0xFBC0,0x9388,0x0000, 0xFBC0,0x9389,0x0000,
0xFBC0,0x938A,0x0000, 0xFBC0,0x938B,0x0000, 0xFBC0,0x938C,0x0000,
0xFBC0,0x938D,0x0000, 0xFBC0,0x938E,0x0000, 0xFBC0,0x938F,0x0000,
0xFBC0,0x9390,0x0000, 0xFBC0,0x9391,0x0000, 0xFBC0,0x9392,0x0000,
0xFBC0,0x9393,0x0000, 0xFBC0,0x9394,0x0000, 0xFBC0,0x9395,0x0000,
0xFBC0,0x9396,0x0000, 0xFBC0,0x9397,0x0000, 0xFBC0,0x9398,0x0000,
0xFBC0,0x9399,0x0000, 0xFBC0,0x939A,0x0000, 0xFBC0,0x939B,0x0000,
0xFBC0,0x939C,0x0000, 0xFBC0,0x939D,0x0000, 0xFBC0,0x939E,0x0000,
0xFBC0,0x939F,0x0000, 0x1A59,0x0000,0x0000, 0x1A5A,0x0000,0x0000,
0x1A5B,0x0000,0x0000, 0x1A5C,0x0000,0x0000, 0x1A5D,0x0000,0x0000,
0x1A5E,0x0000,0x0000, 0x1A5F,0x0000,0x0000, 0x1A60,0x0000,0x0000,
0x1A61,0x0000,0x0000, 0x1A62,0x0000,0x0000, 0x1A63,0x0000,0x0000,
0x1A64,0x0000,0x0000, 0x1A65,0x0000,0x0000, 0x1A66,0x0000,0x0000,
0x1A67,0x0000,0x0000, 0x1A68,0x0000,0x0000, 0x1A69,0x0000,0x0000,
0x1A6A,0x0000,0x0000, 0x1A6B,0x0000,0x0000, 0x1A6C,0x0000,0x0000,
0x1A6D,0x0000,0x0000, 0x1A6E,0x0000,0x0000, 0x1A6F,0x0000,0x0000,
0x1A70,0x0000,0x0000, 0x1A71,0x0000,0x0000, 0x1A72,0x0000,0x0000,
0x1A73,0x0000,0x0000, 0x1A74,0x0000,0x0000, 0x1A75,0x0000,0x0000,
0x1A76,0x0000,0x0000, 0x1A77,0x0000,0x0000, 0x1A78,0x0000,0x0000,
0x1A79,0x0000,0x0000, 0x1A7A,0x0000,0x0000, 0x1A7B,0x0000,0x0000,
0x1A7C,0x0000,0x0000, 0x1A7D,0x0000,0x0000, 0x1A7E,0x0000,0x0000,
0x1A7F,0x0000,0x0000, 0x1A80,0x0000,0x0000, 0x1A81,0x0000,0x0000,
0x1A82,0x0000,0x0000, 0x1A83,0x0000,0x0000, 0x1A84,0x0000,0x0000,
0x1A85,0x0000,0x0000, 0x1A86,0x0000,0x0000, 0x1A87,0x0000,0x0000,
0x1A88,0x0000,0x0000, 0x1A89,0x0000,0x0000, 0x1A8A,0x0000,0x0000,
0x1A8B,0x0000,0x0000, 0x1A8C,0x0000,0x0000, 0x1A8D,0x0000,0x0000,
0x1A8E,0x0000,0x0000, 0x1A8F,0x0000,0x0000, 0x1A90,0x0000,0x0000,
0x1A91,0x0000,0x0000, 0x1A92,0x0000,0x0000, 0x1A93,0x0000,0x0000,
0x1A94,0x0000,0x0000, 0x1A95,0x0000,0x0000, 0x1A96,0x0000,0x0000,
0x1A97,0x0000,0x0000, 0x1A98,0x0000,0x0000, 0x1A99,0x0000,0x0000,
0x1A9A,0x0000,0x0000, 0x1A9B,0x0000,0x0000, 0x1A9C,0x0000,0x0000,
0x1A9D,0x0000,0x0000, 0x1A9E,0x0000,0x0000, 0x1A9F,0x0000,0x0000,
0x1AA0,0x0000,0x0000, 0x1AA1,0x0000,0x0000, 0x1AA2,0x0000,0x0000,
0x1AA3,0x0000,0x0000, 0x1AA4,0x0000,0x0000, 0x1AA5,0x0000,0x0000,
0x1AA6,0x0000,0x0000, 0x1AA7,0x0000,0x0000, 0x1AA8,0x0000,0x0000,
0x1AA9,0x0000,0x0000, 0x1AAA,0x0000,0x0000, 0x1AAB,0x0000,0x0000,
0x1AAC,0x0000,0x0000, 0x1AAD,0x0000,0x0000, 0xFBC0,0x93F5,0x0000,
0xFBC0,0x93F6,0x0000, 0xFBC0,0x93F7,0x0000, 0xFBC0,0x93F8,0x0000,
0xFBC0,0x93F9,0x0000, 0xFBC0,0x93FA,0x0000, 0xFBC0,0x93FB,0x0000,
0xFBC0,0x93FC,0x0000, 0xFBC0,0x93FD,0x0000, 0xFBC0,0x93FE,0x0000,
0xFBC0,0x93FF,0x0000 };

uint16 page014data[]= { /* 1400 (3 weights per char) */
0xFBC0,0x9400,0x0000, 0x1AAE,0x0000,0x0000, 0x1AAF,0x0000,0x0000,
0x1AB0,0x0000,0x0000, 0x1AB1,0x0000,0x0000, 0x1AB2,0x0000,0x0000,
0x1AB3,0x0000,0x0000, 0x1AB4,0x0000,0x0000, 0x1AB5,0x0000,0x0000,
0x1AB6,0x0000,0x0000, 0x1AB7,0x0000,0x0000, 0x1AB8,0x0000,0x0000,
0x1AB9,0x0000,0x0000, 0x1ABA,0x0000,0x0000, 0x1ABB,0x0000,0x0000,
0x1ABC,0x0000,0x0000, 0x1ABD,0x0000,0x0000, 0x1ABE,0x0000,0x0000,
0x1ABF,0x0000,0x0000, 0x1AC0,0x0000,0x0000, 0x1AC1,0x0000,0x0000,
0x1AC2,0x0000,0x0000, 0x1AC3,0x0000,0x0000, 0x1AC4,0x0000,0x0000,
0x1AC5,0x0000,0x0000, 0x1AC6,0x0000,0x0000, 0x1AC7,0x0000,0x0000,
0x1AC8,0x0000,0x0000, 0x1AC9,0x0000,0x0000, 0x1ACA,0x0000,0x0000,
0x1ACB,0x0000,0x0000, 0x1ACC,0x0000,0x0000, 0x1ACD,0x0000,0x0000,
0x1ACE,0x0000,0x0000, 0x1ACF,0x0000,0x0000, 0x1AD0,0x0000,0x0000,
0x1AD1,0x0000,0x0000, 0x1AD2,0x0000,0x0000, 0x1AD3,0x0000,0x0000,
0x1AD4,0x0000,0x0000, 0x1AD5,0x0000,0x0000, 0x1AD6,0x0000,0x0000,
0x1AD7,0x0000,0x0000, 0x1AD8,0x0000,0x0000, 0x1AD9,0x0000,0x0000,
0x1ADA,0x0000,0x0000, 0x1ADB,0x0000,0x0000, 0x1ADC,0x0000,0x0000,
0x1ADD,0x0000,0x0000, 0x1ADE,0x0000,0x0000, 0x1ADF,0x0000,0x0000,
0x1AE0,0x0000,0x0000, 0x1AE1,0x0000,0x0000, 0x1AE2,0x0000,0x0000,
0x1AE3,0x0000,0x0000, 0x1AE4,0x0000,0x0000, 0x1AE5,0x0000,0x0000,
0x1AE6,0x0000,0x0000, 0x1AE7,0x0000,0x0000, 0x1AE8,0x0000,0x0000,
0x1AE9,0x0000,0x0000, 0x1AEA,0x0000,0x0000, 0x1AEB,0x0000,0x0000,
0x1AEC,0x0000,0x0000, 0x1AED,0x0000,0x0000, 0x1AEE,0x0000,0x0000,
0x1AEF,0x0000,0x0000, 0x1AF0,0x0000,0x0000, 0x1AF1,0x0000,0x0000,
0x1AF2,0x0000,0x0000, 0x1AF3,0x0000,0x0000, 0x1AF4,0x0000,0x0000,
0x1AF5,0x0000,0x0000, 0x1AF6,0x0000,0x0000, 0x1AF7,0x0000,0x0000,
0x1AF8,0x0000,0x0000, 0x1AF9,0x0000,0x0000, 0x1AFA,0x0000,0x0000,
0x1AFB,0x0000,0x0000, 0x1AFC,0x0000,0x0000, 0x1AFD,0x0000,0x0000,
0x1AFE,0x0000,0x0000, 0x1AFF,0x0000,0x0000, 0x1B00,0x0000,0x0000,
0x1B01,0x0000,0x0000, 0x1B02,0x0000,0x0000, 0x1B03,0x0000,0x0000,
0x1B04,0x0000,0x0000, 0x1B05,0x0000,0x0000, 0x1B06,0x0000,0x0000,
0x1B07,0x0000,0x0000, 0x1B08,0x0000,0x0000, 0x1B09,0x0000,0x0000,
0x1B0A,0x0000,0x0000, 0x1B0B,0x0000,0x0000, 0x1B0C,0x0000,0x0000,
0x1B0D,0x0000,0x0000, 0x1B0E,0x0000,0x0000, 0x1B0F,0x0000,0x0000,
0x1B10,0x0000,0x0000, 0x1B11,0x0000,0x0000, 0x1B12,0x0000,0x0000,
0x1B13,0x0000,0x0000, 0x1B14,0x0000,0x0000, 0x1B15,0x0000,0x0000,
0x1B16,0x0000,0x0000, 0x1B17,0x0000,0x0000, 0x1B18,0x0000,0x0000,
0x1B19,0x0000,0x0000, 0x1B1A,0x0000,0x0000, 0x1B1B,0x0000,0x0000,
0x1B1C,0x0000,0x0000, 0x1B1D,0x0000,0x0000, 0x1B1E,0x0000,0x0000,
0x1B1F,0x0000,0x0000, 0x1B20,0x0000,0x0000, 0x1B21,0x0000,0x0000,
0x1B22,0x0000,0x0000, 0x1B23,0x0000,0x0000, 0x1B24,0x0000,0x0000,
0x1B25,0x0000,0x0000, 0x1B26,0x0000,0x0000, 0x1B27,0x0000,0x0000,
0x1B28,0x0000,0x0000, 0x1B29,0x0000,0x0000, 0x1B2A,0x0000,0x0000,
0x1B2B,0x0000,0x0000, 0x1B2C,0x0000,0x0000, 0x1B2D,0x0000,0x0000,
0x1B2E,0x0000,0x0000, 0x1B2F,0x0000,0x0000, 0x1B30,0x0000,0x0000,
0x1B31,0x0000,0x0000, 0x1B32,0x0000,0x0000, 0x1B33,0x0000,0x0000,
0x1B34,0x0000,0x0000, 0x1B35,0x0000,0x0000, 0x1B36,0x0000,0x0000,
0x1B37,0x0000,0x0000, 0x1B38,0x0000,0x0000, 0x1B39,0x0000,0x0000,
0x1B3A,0x0000,0x0000, 0x1B3B,0x0000,0x0000, 0x1B3C,0x0000,0x0000,
0x1B3D,0x0000,0x0000, 0x1B3E,0x0000,0x0000, 0x1B3F,0x0000,0x0000,
0x1B40,0x0000,0x0000, 0x1B41,0x0000,0x0000, 0x1B42,0x0000,0x0000,
0x1B43,0x0000,0x0000, 0x1B44,0x0000,0x0000, 0x1B45,0x0000,0x0000,
0x1B46,0x0000,0x0000, 0x1B47,0x0000,0x0000, 0x1B48,0x0000,0x0000,
0x1B49,0x0000,0x0000, 0x1B4A,0x0000,0x0000, 0x1B4B,0x0000,0x0000,
0x1B4C,0x0000,0x0000, 0x1B4D,0x0000,0x0000, 0x1B4E,0x0000,0x0000,
0x1B4F,0x0000,0x0000, 0x1B50,0x0000,0x0000, 0x1B51,0x0000,0x0000,
0x1B52,0x0000,0x0000, 0x1B53,0x0000,0x0000, 0x1B54,0x0000,0x0000,
0x1B55,0x0000,0x0000, 0x1B56,0x0000,0x0000, 0x1B57,0x0000,0x0000,
0x1B58,0x0000,0x0000, 0x1B59,0x0000,0x0000, 0x1B5A,0x0000,0x0000,
0x1B5B,0x0000,0x0000, 0x1B5C,0x0000,0x0000, 0x1B5D,0x0000,0x0000,
0x1B5E,0x0000,0x0000, 0x1B5F,0x0000,0x0000, 0x1B60,0x0000,0x0000,
0x1B61,0x0000,0x0000, 0x1B62,0x0000,0x0000, 0x1B63,0x0000,0x0000,
0x1B64,0x0000,0x0000, 0x1B65,0x0000,0x0000, 0x1B66,0x0000,0x0000,
0x1B67,0x0000,0x0000, 0x1B68,0x0000,0x0000, 0x1B69,0x0000,0x0000,
0x1B6A,0x0000,0x0000, 0x1B6B,0x0000,0x0000, 0x1B6C,0x0000,0x0000,
0x1B6D,0x0000,0x0000, 0x1B6E,0x0000,0x0000, 0x1B6F,0x0000,0x0000,
0x1B70,0x0000,0x0000, 0x1B71,0x0000,0x0000, 0x1B72,0x0000,0x0000,
0x1B73,0x0000,0x0000, 0x1B74,0x0000,0x0000, 0x1B75,0x0000,0x0000,
0x1B76,0x0000,0x0000, 0x1B77,0x0000,0x0000, 0x1B78,0x0000,0x0000,
0x1B79,0x0000,0x0000, 0x1B7A,0x0000,0x0000, 0x1B7B,0x0000,0x0000,
0x1B7C,0x0000,0x0000, 0x1B7D,0x0000,0x0000, 0x1B7E,0x0000,0x0000,
0x1B7F,0x0000,0x0000, 0x1B80,0x0000,0x0000, 0x1B81,0x0000,0x0000,
0x1B82,0x0000,0x0000, 0x1B83,0x0000,0x0000, 0x1B84,0x0000,0x0000,
0x1B85,0x0000,0x0000, 0x1B86,0x0000,0x0000, 0x1B87,0x0000,0x0000,
0x1B88,0x0000,0x0000, 0x1B89,0x0000,0x0000, 0x1B8A,0x0000,0x0000,
0x1B8B,0x0000,0x0000, 0x1B8C,0x0000,0x0000, 0x1B8D,0x0000,0x0000,
0x1B8E,0x0000,0x0000, 0x1B8F,0x0000,0x0000, 0x1B90,0x0000,0x0000,
0x1B91,0x0000,0x0000, 0x1B92,0x0000,0x0000, 0x1B93,0x0000,0x0000,
0x1B94,0x0000,0x0000, 0x1B95,0x0000,0x0000, 0x1B96,0x0000,0x0000,
0x1B97,0x0000,0x0000, 0x1B98,0x0000,0x0000, 0x1B99,0x0000,0x0000,
0x1B9A,0x0000,0x0000, 0x1B9B,0x0000,0x0000, 0x1B9C,0x0000,0x0000,
0x1B9D,0x0000,0x0000, 0x1B9E,0x0000,0x0000, 0x1B9F,0x0000,0x0000,
0x1BA0,0x0000,0x0000, 0x1BA1,0x0000,0x0000, 0x1BA2,0x0000,0x0000,
0x1BA3,0x0000,0x0000, 0x1BA4,0x0000,0x0000, 0x1BA5,0x0000,0x0000,
0x1BA6,0x0000,0x0000, 0x1BA7,0x0000,0x0000, 0x1BA8,0x0000,0x0000,
0x1BA9,0x0000,0x0000, 0x1BAA,0x0000,0x0000, 0x1BAB,0x0000,0x0000,
0x1BAC,0x0000,0x0000 };

uint16 page015data[]= { /* 1500 (2 weights per char) */
0x1BAD,0x0000, 0x1BAE,0x0000, 0x1BAF,0x0000, 0x1BB0,0x0000,
0x1BB1,0x0000, 0x1BB2,0x0000, 0x1BB3,0x0000, 0x1BB4,0x0000,
0x1BB5,0x0000, 0x1BB6,0x0000, 0x1BB7,0x0000, 0x1BB8,0x0000,
0x1BB9,0x0000, 0x1BBA,0x0000, 0x1BBB,0x0000, 0x1BBC,0x0000,
0x1BBD,0x0000, 0x1BBE,0x0000, 0x1BBF,0x0000, 0x1BC0,0x0000,
0x1BC1,0x0000, 0x1BC2,0x0000, 0x1BC3,0x0000, 0x1BC4,0x0000,
0x1BC5,0x0000, 0x1BC6,0x0000, 0x1BC7,0x0000, 0x1BC8,0x0000,
0x1BC9,0x0000, 0x1BCA,0x0000, 0x1BCB,0x0000, 0x1BCC,0x0000,
0x1BCD,0x0000, 0x1BCE,0x0000, 0x1BCF,0x0000, 0x1BD0,0x0000,
0x1BD1,0x0000, 0x1BD2,0x0000, 0x1BD3,0x0000, 0x1BD4,0x0000,
0x1BD5,0x0000, 0x1BD6,0x0000, 0x1BD7,0x0000, 0x1BD8,0x0000,
0x1BD9,0x0000, 0x1BDA,0x0000, 0x1BDB,0x0000, 0x1BDC,0x0000,
0x1BDD,0x0000, 0x1BDE,0x0000, 0x1BDF,0x0000, 0x1BE0,0x0000,
0x1BE1,0x0000, 0x1BE2,0x0000, 0x1BE3,0x0000, 0x1BE4,0x0000,
0x1BE5,0x0000, 0x1BE6,0x0000, 0x1BE7,0x0000, 0x1BE8,0x0000,
0x1BE9,0x0000, 0x1BEA,0x0000, 0x1BEB,0x0000, 0x1BEC,0x0000,
0x1BED,0x0000, 0x1BEE,0x0000, 0x1BEF,0x0000, 0x1BF0,0x0000,
0x1BF1,0x0000, 0x1BF2,0x0000, 0x1BF3,0x0000, 0x1BF4,0x0000,
0x1BF5,0x0000, 0x1BF6,0x0000, 0x1BF7,0x0000, 0x1BF8,0x0000,
0x1BF9,0x0000, 0x1BFA,0x0000, 0x1BFB,0x0000, 0x1BFC,0x0000,
0x1BFD,0x0000, 0x1BFE,0x0000, 0x1BFF,0x0000, 0x1C00,0x0000,
0x1C01,0x0000, 0x1C02,0x0000, 0x1C03,0x0000, 0x1C04,0x0000,
0x1C05,0x0000, 0x1C06,0x0000, 0x1C07,0x0000, 0x1C08,0x0000,
0x1C09,0x0000, 0x1C0A,0x0000, 0x1C0B,0x0000, 0x1C0C,0x0000,
0x1C0D,0x0000, 0x1C0E,0x0000, 0x1C0F,0x0000, 0x1C10,0x0000,
0x1C11,0x0000, 0x1C12,0x0000, 0x1C13,0x0000, 0x1C14,0x0000,
0x1C15,0x0000, 0x1C16,0x0000, 0x1C17,0x0000, 0x1C18,0x0000,
0x1C19,0x0000, 0x1C1A,0x0000, 0x1C1B,0x0000, 0x1C1C,0x0000,
0x1C1D,0x0000, 0x1C1E,0x0000, 0x1C1F,0x0000, 0x1C20,0x0000,
0x1C21,0x0000, 0x1C22,0x0000, 0x1C23,0x0000, 0x1C24,0x0000,
0x1C25,0x0000, 0x1C26,0x0000, 0x1C27,0x0000, 0x1C28,0x0000,
0x1C5B,0x0000, 0x1C29,0x0000, 0x1C2B,0x0000, 0x1C2C,0x0000,
0x1C2D,0x0000, 0x1C2E,0x0000, 0x1C2F,0x0000, 0x1C30,0x0000,
0x1C31,0x0000, 0x1C32,0x0000, 0x1C33,0x0000, 0x1C34,0x0000,
0x1C35,0x0000, 0x1C36,0x0000, 0x1C37,0x0000, 0x1C38,0x0000,
0x1C39,0x0000, 0x1C3A,0x0000, 0x1C3C,0x0000, 0x1C3D,0x0000,
0x1C3E,0x0000, 0x1C3F,0x0000, 0x1C40,0x0000, 0x1C41,0x0000,
0x1C42,0x0000, 0x1C43,0x0000, 0x1C4A,0x0000, 0x1C4B,0x0000,
0x1C4C,0x0000, 0x1C4D,0x0000, 0x1C4E,0x0000, 0x1C4F,0x0000,
0x1C50,0x0000, 0x1C51,0x0000, 0x1C52,0x0000, 0x1C53,0x0000,
0x1C54,0x0000, 0x1C55,0x0000, 0x1C56,0x0000, 0x1C57,0x0000,
0x1C58,0x0000, 0x1C59,0x0000, 0x1C5A,0x0000, 0x1C5C,0x0000,
0x1C5D,0x0000, 0x1C5E,0x0000, 0x1C5F,0x0000, 0x1C60,0x0000,
0x1C61,0x0000, 0x1C62,0x0000, 0x1C63,0x0000, 0x1C64,0x0000,
0x1C65,0x0000, 0x1C66,0x0000, 0x1C67,0x0000, 0x1C68,0x0000,
0x1C69,0x0000, 0x1C6A,0x0000, 0x1C6B,0x0000, 0x1C6C,0x0000,
0x1C6D,0x0000, 0x1C6E,0x0000, 0x1C6F,0x0000, 0x1C70,0x0000,
0x1C71,0x0000, 0x1C72,0x0000, 0x1C73,0x0000, 0x1C74,0x0000,
0x1C75,0x0000, 0x1C76,0x0000, 0x1C77,0x0000, 0x1C78,0x0000,
0x1C79,0x0000, 0x1C7A,0x0000, 0x1C7B,0x0000, 0x1C7C,0x0000,
0x1C7D,0x0000, 0x1C7E,0x0000, 0x1C7F,0x0000, 0x1C80,0x0000,
0x1C81,0x0000, 0x1C82,0x0000, 0x1C83,0x0000, 0x1C84,0x0000,
0x1C85,0x0000, 0x1C86,0x0000, 0x1C87,0x0000, 0x1C88,0x0000,
0x1C89,0x0000, 0x1C8A,0x0000, 0x1C8B,0x0000, 0x1C8C,0x0000,
0x1C8D,0x0000, 0x1C8E,0x0000, 0x1C8F,0x0000, 0x1C90,0x0000,
0x1C91,0x0000, 0x1C92,0x0000, 0x1C93,0x0000, 0x1C94,0x0000,
0x1C95,0x0000, 0x1C96,0x0000, 0x1C97,0x0000, 0x1C98,0x0000,
0x1C99,0x0000, 0x1C9A,0x0000, 0x1C9B,0x0000, 0x1C9C,0x0000,
0x1C9D,0x0000, 0x1C9E,0x0000, 0x1C9F,0x0000, 0x1CA0,0x0000,
0x1CA1,0x0000, 0x1CA2,0x0000, 0x1CA3,0x0000, 0x1CA4,0x0000,
0x1CA5,0x0000, 0x1CA6,0x0000, 0x1CA7,0x0000, 0x1CA8,0x0000,
0x1CA9,0x0000, 0x1CAA,0x0000, 0x1CAB,0x0000, 0x1CAC,0x0000,
0x1CAD,0x0000, 0x1CAE,0x0000, 0x1CAF,0x0000, 0x1CB0,0x0000,
0x1CB1,0x0000, 0x1CB2,0x0000, 0x1CB3,0x0000, 0x1CB4,0x0000
};

uint16 page016data[]= { /* 1600 (3 weights per char) */
0x1CB5,0x0000,0x0000, 0x1CB6,0x0000,0x0000, 0x1CB7,0x0000,0x0000,
0x1CB8,0x0000,0x0000, 0x1CB9,0x0000,0x0000, 0x1CBA,0x0000,0x0000,
0x1CBB,0x0000,0x0000, 0x1CBC,0x0000,0x0000, 0x1CBD,0x0000,0x0000,
0x1CBE,0x0000,0x0000, 0x1CBF,0x0000,0x0000, 0x1CC0,0x0000,0x0000,
0x1CC1,0x0000,0x0000, 0x1CC2,0x0000,0x0000, 0x1CC3,0x0000,0x0000,
0x1CC4,0x0000,0x0000, 0x1CC5,0x0000,0x0000, 0x1CC6,0x0000,0x0000,
0x1CC7,0x0000,0x0000, 0x1CC8,0x0000,0x0000, 0x1CC9,0x0000,0x0000,
0x1CCA,0x0000,0x0000, 0x1CCB,0x0000,0x0000, 0x1CCC,0x0000,0x0000,
0x1CCD,0x0000,0x0000, 0x1CCE,0x0000,0x0000, 0x1CCF,0x0000,0x0000,
0x1CD0,0x0000,0x0000, 0x1CD1,0x0000,0x0000, 0x1CD2,0x0000,0x0000,
0x1CD3,0x0000,0x0000, 0x1CD4,0x0000,0x0000, 0x1CD5,0x0000,0x0000,
0x1CD6,0x0000,0x0000, 0x1CD7,0x0000,0x0000, 0x1CD8,0x0000,0x0000,
0x1CD9,0x0000,0x0000, 0x1CDA,0x0000,0x0000, 0x1CDB,0x0000,0x0000,
0x1CDC,0x0000,0x0000, 0x1CDD,0x0000,0x0000, 0x1CDE,0x0000,0x0000,
0x1CDF,0x0000,0x0000, 0x1CE0,0x0000,0x0000, 0x1CE1,0x0000,0x0000,
0x1CE2,0x0000,0x0000, 0x1CE3,0x0000,0x0000, 0x1CE4,0x0000,0x0000,
0x1CE5,0x0000,0x0000, 0x1CE6,0x0000,0x0000, 0x1CE7,0x0000,0x0000,
0x1CE8,0x0000,0x0000, 0x1CE9,0x0000,0x0000, 0x1CEA,0x0000,0x0000,
0x1CEB,0x0000,0x0000, 0x1CEC,0x0000,0x0000, 0x1CED,0x0000,0x0000,
0x1CEE,0x0000,0x0000, 0x1CEF,0x0000,0x0000, 0x1CF0,0x0000,0x0000,
0x1CF1,0x0000,0x0000, 0x1CF2,0x0000,0x0000, 0x1CF3,0x0000,0x0000,
0x1CF4,0x0000,0x0000, 0x1CF5,0x0000,0x0000, 0x1CF6,0x0000,0x0000,
0x1CF7,0x0000,0x0000, 0x1CF8,0x0000,0x0000, 0x1CF9,0x0000,0x0000,
0x1CFA,0x0000,0x0000, 0x1CFB,0x0000,0x0000, 0x1CFC,0x0000,0x0000,
0x1CFD,0x0000,0x0000, 0x1CFE,0x0000,0x0000, 0x1CFF,0x0000,0x0000,
0x1D00,0x0000,0x0000, 0x1D01,0x0000,0x0000, 0x1D02,0x0000,0x0000,
0x1D03,0x0000,0x0000, 0x1D04,0x0000,0x0000, 0x1D05,0x0000,0x0000,
0x1D06,0x0000,0x0000, 0x1D07,0x0000,0x0000, 0x1D08,0x0000,0x0000,
0x1D09,0x0000,0x0000, 0x1D0A,0x0000,0x0000, 0x1D0B,0x0000,0x0000,
0x1D0C,0x0000,0x0000, 0x1D0D,0x0000,0x0000, 0x1D0E,0x0000,0x0000,
0x1D0F,0x0000,0x0000, 0x1D10,0x0000,0x0000, 0x1D11,0x0000,0x0000,
0x1D12,0x0000,0x0000, 0x1D13,0x0000,0x0000, 0x1D14,0x0000,0x0000,
0x1D15,0x0000,0x0000, 0x1D16,0x0000,0x0000, 0x1D17,0x0000,0x0000,
0x1D18,0x0000,0x0000, 0x1D19,0x0000,0x0000, 0x1D1A,0x0000,0x0000,
0x1D1B,0x0000,0x0000, 0x1D1C,0x0000,0x0000, 0x1D1D,0x0000,0x0000,
0x1D1E,0x0000,0x0000, 0x1D1F,0x0000,0x0000, 0x1D20,0x0000,0x0000,
0x1D21,0x0000,0x0000, 0x0316,0x0000,0x0000, 0x0265,0x0000,0x0000,
0x1C2A,0x0000,0x0000, 0x1C3B,0x0000,0x0000, 0x1C44,0x0000,0x0000,
0x1C45,0x0000,0x0000, 0x1C46,0x0000,0x0000, 0x1C47,0x0000,0x0000,
0x1C48,0x0000,0x0000, 0x1C49,0x0000,0x0000, 0xFBC0,0x9677,0x0000,
0xFBC0,0x9678,0x0000, 0xFBC0,0x9679,0x0000, 0xFBC0,0x967A,0x0000,
0xFBC0,0x967B,0x0000, 0xFBC0,0x967C,0x0000, 0xFBC0,0x967D,0x0000,
0xFBC0,0x967E,0x0000, 0xFBC0,0x967F,0x0000, 0x020A,0x0000,0x0000,
0x1D22,0x0000,0x0000, 0x1D23,0x0000,0x0000, 0x1D24,0x0000,0x0000,
0x1D25,0x0000,0x0000, 0x1D26,0x0000,0x0000, 0x1D27,0x0000,0x0000,
0x1D28,0x0000,0x0000, 0x1D29,0x0000,0x0000, 0x1D2A,0x0000,0x0000,
0x1D2B,0x0000,0x0000, 0x1D2C,0x0000,0x0000, 0x1D2D,0x0000,0x0000,
0x1D2E,0x0000,0x0000, 0x1D2F,0x0000,0x0000, 0x1D30,0x0000,0x0000,
0x1D31,0x0000,0x0000, 0x1D32,0x0000,0x0000, 0x1D33,0x0000,0x0000,
0x1D34,0x0000,0x0000, 0x1D35,0x0000,0x0000, 0x1D36,0x0000,0x0000,
0x1D37,0x0000,0x0000, 0x1D38,0x0000,0x0000, 0x1D39,0x0000,0x0000,
0x1D3A,0x0000,0x0000, 0x1D3B,0x0000,0x0000, 0x0292,0x0000,0x0000,
0x0293,0x0000,0x0000, 0xFBC0,0x969D,0x0000, 0xFBC0,0x969E,0x0000,
0xFBC0,0x969F,0x0000, 0x1D3C,0x0000,0x0000, 0x1D3C,0x0000,0x0000,
0x1D3D,0x0000,0x0000, 0x1D59,0x0000,0x0000, 0x1D3D,0x0000,0x0000,
0x1D3D,0x0000,0x0000, 0x1D3E,0x0000,0x0000, 0x1D3E,0x0000,0x0000,
0x1D3F,0x0000,0x0000, 0x1D3F,0x0000,0x0000, 0x1D57,0x0000,0x0000,
0x1D58,0x0000,0x0000, 0x1D3F,0x0000,0x0000, 0x1D3F,0x0000,0x0000,
0x1D3F,0x0000,0x0000, 0x1D40,0x0000,0x0000, 0x1D41,0x0000,0x0000,
0x1D42,0x0000,0x0000, 0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000,
0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000, 0x1D43,0x0000,0x0000,
0x1D44,0x0000,0x0000, 0x1D5C,0x0000,0x0000, 0x1D45,0x0000,0x0000,
0x1D46,0x0000,0x0000, 0x1D46,0x0000,0x0000, 0x1D46,0x0000,0x0000,
0x1D46,0x0000,0x0000, 0x1D47,0x0000,0x0000, 0x1D47,0x0000,0x0000,
0x1D47,0x0000,0x0000, 0x1D48,0x0000,0x0000, 0x1D48,0x0000,0x0000,
0x1D49,0x0000,0x0000, 0x1D49,0x0000,0x0000, 0x1D4A,0x0000,0x0000,
0x1D4A,0x0000,0x0000, 0x1D4B,0x0000,0x0000, 0x1D4C,0x0000,0x0000,
0x1D4D,0x0000,0x0000, 0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000,
0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000, 0x1D4E,0x0000,0x0000,
0x1D4F,0x0000,0x0000, 0x1D4F,0x0000,0x0000, 0x1D4F,0x0000,0x0000,
0x1D50,0x0000,0x0000, 0x1D50,0x0000,0x0000, 0x1D50,0x0000,0x0000,
0x1D4C,0x0000,0x0000, 0x1D51,0x0000,0x0000, 0x1D52,0x0000,0x0000,
0x1D52,0x0000,0x0000, 0x1D52,0x0000,0x0000, 0x1D53,0x0000,0x0000,
0x1D53,0x0000,0x0000, 0x1D54,0x0000,0x0000, 0x1D54,0x0000,0x0000,
0x1D55,0x0000,0x0000, 0x1D56,0x0000,0x0000, 0x1D5A,0x0000,0x0000,
0x1D5E,0x0000,0x0000, 0x1D5F,0x0000,0x0000, 0x1D5B,0x0000,0x0000,
0x1D5D,0x0000,0x0000, 0x1D60,0x0000,0x0000, 0x1D61,0x0000,0x0000,
0x1D61,0x0000,0x0000, 0x1D61,0x0000,0x0000, 0x1D45,0x0000,0x0000,
0x1D4E,0x0000,0x0000, 0x024E,0x0000,0x0000, 0x024F,0x0000,0x0000,
0x0250,0x0000,0x0000, 0x1D4A,0x1D53,0x0000, 0x1D52,0x1D52,0x0000,
0x1D3E,0x1D3E,0x0000, 0xFBC0,0x96F1,0x0000, 0xFBC0,0x96F2,0x0000,
0xFBC0,0x96F3,0x0000, 0xFBC0,0x96F4,0x0000, 0xFBC0,0x96F5,0x0000,
0xFBC0,0x96F6,0x0000, 0xFBC0,0x96F7,0x0000, 0xFBC0,0x96F8,0x0000,
0xFBC0,0x96F9,0x0000, 0xFBC0,0x96FA,0x0000, 0xFBC0,0x96FB,0x0000,
0xFBC0,0x96FC,0x0000, 0xFBC0,0x96FD,0x0000, 0xFBC0,0x96FE,0x0000,
0xFBC0,0x96FF,0x0000 };

uint16 page017data[]= { /* 1700 (3 weights per char) */
0x18E2,0x0000,0x0000, 0x18E3,0x0000,0x0000, 0x18E4,0x0000,0x0000,
0x18E5,0x0000,0x0000, 0x18E6,0x0000,0x0000, 0x18E7,0x0000,0x0000,
0x18E8,0x0000,0x0000, 0x18E9,0x0000,0x0000, 0x18EA,0x0000,0x0000,
0x18EB,0x0000,0x0000, 0x18EC,0x0000,0x0000, 0x18ED,0x0000,0x0000,
0x18EE,0x0000,0x0000, 0xFBC0,0x970D,0x0000, 0x18EF,0x0000,0x0000,
0x18F0,0x0000,0x0000, 0x18F1,0x0000,0x0000, 0x18F2,0x0000,0x0000,
0x18F3,0x0000,0x0000, 0x18F4,0x0000,0x0000, 0x18F5,0x0000,0x0000,
0xFBC0,0x9715,0x0000, 0xFBC0,0x9716,0x0000, 0xFBC0,0x9717,0x0000,
0xFBC0,0x9718,0x0000, 0xFBC0,0x9719,0x0000, 0xFBC0,0x971A,0x0000,
0xFBC0,0x971B,0x0000, 0xFBC0,0x971C,0x0000, 0xFBC0,0x971D,0x0000,
0xFBC0,0x971E,0x0000, 0xFBC0,0x971F,0x0000, 0x18F6,0x0000,0x0000,
0x18F7,0x0000,0x0000, 0x18F8,0x0000,0x0000, 0x18F9,0x0000,0x0000,
0x18FA,0x0000,0x0000, 0x18FB,0x0000,0x0000, 0x18FC,0x0000,0x0000,
0x18FD,0x0000,0x0000, 0x18FE,0x0000,0x0000, 0x18FF,0x0000,0x0000,
0x1900,0x0000,0x0000, 0x1901,0x0000,0x0000, 0x1902,0x0000,0x0000,
0x1903,0x0000,0x0000, 0x1904,0x0000,0x0000, 0x1905,0x0000,0x0000,
0x1906,0x0000,0x0000, 0x1907,0x0000,0x0000, 0x1908,0x0000,0x0000,
0x1909,0x0000,0x0000, 0x190A,0x0000,0x0000, 0x026A,0x0000,0x0000,
0x026B,0x0000,0x0000, 0xFBC0,0x9737,0x0000, 0xFBC0,0x9738,0x0000,
0xFBC0,0x9739,0x0000, 0xFBC0,0x973A,0x0000, 0xFBC0,0x973B,0x0000,
0xFBC0,0x973C,0x0000, 0xFBC0,0x973D,0x0000, 0xFBC0,0x973E,0x0000,
0xFBC0,0x973F,0x0000, 0x190B,0x0000,0x0000, 0x190C,0x0000,0x0000,
0x190D,0x0000,0x0000, 0x190E,0x0000,0x0000, 0x190F,0x0000,0x0000,
0x1910,0x0000,0x0000, 0x1911,0x0000,0x0000, 0x1912,0x0000,0x0000,
0x1913,0x0000,0x0000, 0x1914,0x0000,0x0000, 0x1915,0x0000,0x0000,
0x1916,0x0000,0x0000, 0x1917,0x0000,0x0000, 0x1918,0x0000,0x0000,
0x1919,0x0000,0x0000, 0x191A,0x0000,0x0000, 0x191B,0x0000,0x0000,
0x191C,0x0000,0x0000, 0x191D,0x0000,0x0000, 0x191E,0x0000,0x0000,
0xFBC0,0x9754,0x0000, 0xFBC0,0x9755,0x0000, 0xFBC0,0x9756,0x0000,
0xFBC0,0x9757,0x0000, 0xFBC0,0x9758,0x0000, 0xFBC0,0x9759,0x0000,
0xFBC0,0x975A,0x0000, 0xFBC0,0x975B,0x0000, 0xFBC0,0x975C,0x0000,
0xFBC0,0x975D,0x0000, 0xFBC0,0x975E,0x0000, 0xFBC0,0x975F,0x0000,
0x191F,0x0000,0x0000, 0x1920,0x0000,0x0000, 0x1921,0x0000,0x0000,
0x1922,0x0000,0x0000, 0x1923,0x0000,0x0000, 0x1924,0x0000,0x0000,
0x1925,0x0000,0x0000, 0x1926,0x0000,0x0000, 0x1927,0x0000,0x0000,
0x1928,0x0000,0x0000, 0x1929,0x0000,0x0000, 0x192A,0x0000,0x0000,
0x192B,0x0000,0x0000, 0xFBC0,0x976D,0x0000, 0x192C,0x0000,0x0000,
0x192D,0x0000,0x0000, 0x192E,0x0000,0x0000, 0xFBC0,0x9771,0x0000,
0x192F,0x0000,0x0000, 0x1930,0x0000,0x0000, 0xFBC0,0x9774,0x0000,
0xFBC0,0x9775,0x0000, 0xFBC0,0x9776,0x0000, 0xFBC0,0x9777,0x0000,
0xFBC0,0x9778,0x0000, 0xFBC0,0x9779,0x0000, 0xFBC0,0x977A,0x0000,
0xFBC0,0x977B,0x0000, 0xFBC0,0x977C,0x0000, 0xFBC0,0x977D,0x0000,
0xFBC0,0x977E,0x0000, 0xFBC0,0x977F,0x0000, 0x196C,0x0000,0x0000,
0x196D,0x0000,0x0000, 0x196E,0x0000,0x0000, 0x196F,0x0000,0x0000,
0x1970,0x0000,0x0000, 0x1971,0x0000,0x0000, 0x1972,0x0000,0x0000,
0x1973,0x0000,0x0000, 0x1974,0x0000,0x0000, 0x1975,0x0000,0x0000,
0x1976,0x0000,0x0000, 0x1977,0x0000,0x0000, 0x1978,0x0000,0x0000,
0x1979,0x0000,0x0000, 0x197A,0x0000,0x0000, 0x197B,0x0000,0x0000,
0x197C,0x0000,0x0000, 0x197D,0x0000,0x0000, 0x197E,0x0000,0x0000,
0x197F,0x0000,0x0000, 0x1980,0x0000,0x0000, 0x1981,0x0000,0x0000,
0x1982,0x0000,0x0000, 0x1983,0x0000,0x0000, 0x1984,0x0000,0x0000,
0x1985,0x0000,0x0000, 0x1986,0x0000,0x0000, 0x1987,0x0000,0x0000,
0x1988,0x0000,0x0000, 0x1989,0x0000,0x0000, 0x198A,0x0000,0x0000,
0x198B,0x0000,0x0000, 0x198C,0x0000,0x0000, 0x198D,0x0000,0x0000,
0x198E,0x0000,0x0000, 0x1990,0x0000,0x0000, 0x1991,0x0000,0x0000,
0x1992,0x0000,0x0000, 0x1993,0x0000,0x0000, 0x1994,0x0000,0x0000,
0x1995,0x0000,0x0000, 0x1996,0x0000,0x0000, 0x1997,0x0000,0x0000,
0x1998,0x0000,0x0000, 0x1999,0x0000,0x0000, 0x199A,0x0000,0x0000,
0x199B,0x0000,0x0000, 0x199C,0x0000,0x0000, 0x199D,0x0000,0x0000,
0x199E,0x0000,0x0000, 0x199F,0x0000,0x0000, 0x19A0,0x0000,0x0000,
0x19A1,0x0000,0x0000, 0x19A2,0x0000,0x0000, 0x19A3,0x0000,0x0000,
0x19A4,0x0000,0x0000, 0x19A5,0x0000,0x0000, 0x19A6,0x0000,0x0000,
0x19A7,0x0000,0x0000, 0x19A8,0x0000,0x0000, 0x19A9,0x0000,0x0000,
0x19AA,0x0000,0x0000, 0x19AB,0x0000,0x0000, 0x19AC,0x0000,0x0000,
0x19AD,0x0000,0x0000, 0x19AE,0x0000,0x0000, 0x19AF,0x0000,0x0000,
0x19B0,0x0000,0x0000, 0x19B1,0x0000,0x0000, 0x19B2,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x19B3,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x026E,0x0000,0x0000,
0x026F,0x0000,0x0000, 0x024D,0x0000,0x0000, 0x0312,0x0000,0x0000,
0x0313,0x0000,0x0000, 0x0314,0x0000,0x0000, 0x0315,0x0000,0x0000,
0x0E17,0x0000,0x0000, 0x198F,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x97DE,0x0000, 0xFBC0,0x97DF,0x0000, 0x0E29,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0xFBC0,0x97EA,0x0000, 0xFBC0,0x97EB,0x0000, 0xFBC0,0x97EC,0x0000,
0xFBC0,0x97ED,0x0000, 0xFBC0,0x97EE,0x0000, 0xFBC0,0x97EF,0x0000,
0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0xFBC0,0x97FA,0x0000, 0xFBC0,0x97FB,0x0000,
0xFBC0,0x97FC,0x0000, 0xFBC0,0x97FD,0x0000, 0xFBC0,0x97FE,0x0000,
0xFBC0,0x97FF,0x0000 };

uint16 page018data[]= { /* 1800 (3 weights per char) */
0x02F8,0x0000,0x0000, 0x025E,0x0000,0x0000, 0x0235,0x0000,0x0000,
0x0263,0x0000,0x0000, 0x024A,0x0000,0x0000, 0x024B,0x0000,0x0000,
0x0223,0x0000,0x0000, 0x0224,0x0000,0x0000, 0x0236,0x0000,0x0000,
0x0264,0x0000,0x0000, 0x02F9,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x980F,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0xFBC0,0x981A,0x0000,
0xFBC0,0x981B,0x0000, 0xFBC0,0x981C,0x0000, 0xFBC0,0x981D,0x0000,
0xFBC0,0x981E,0x0000, 0xFBC0,0x981F,0x0000, 0x19DF,0x0000,0x0000,
0x19E1,0x0000,0x0000, 0x19E4,0x0000,0x0000, 0x19EA,0x0000,0x0000,
0x19EC,0x0000,0x0000, 0x19EF,0x0000,0x0000, 0x19F1,0x0000,0x0000,
0x19F4,0x0000,0x0000, 0x19F5,0x0000,0x0000, 0x19F6,0x0000,0x0000,
0x19FB,0x0000,0x0000, 0x19FD,0x0000,0x0000, 0x1A00,0x0000,0x0000,
0x1A02,0x0000,0x0000, 0x1A07,0x0000,0x0000, 0x1A09,0x0000,0x0000,
0x1A0A,0x0000,0x0000, 0x1A0B,0x0000,0x0000, 0x1A12,0x0000,0x0000,
0x1A15,0x0000,0x0000, 0x1A18,0x0000,0x0000, 0x1A1D,0x0000,0x0000,
0x1A21,0x0000,0x0000, 0x1A24,0x0000,0x0000, 0x1A26,0x0000,0x0000,
0x1A28,0x0000,0x0000, 0x1A2B,0x0000,0x0000, 0x1A30,0x0000,0x0000,
0x1A31,0x0000,0x0000, 0x1A34,0x0000,0x0000, 0x1A38,0x0000,0x0000,
0x1A3B,0x0000,0x0000, 0x1A3C,0x0000,0x0000, 0x1A3D,0x0000,0x0000,
0x1A3E,0x0000,0x0000, 0x19DE,0x0000,0x0000, 0x19E2,0x0000,0x0000,
0x19E5,0x0000,0x0000, 0x19EB,0x0000,0x0000, 0x19ED,0x0000,0x0000,
0x19F0,0x0000,0x0000, 0x19F2,0x0000,0x0000, 0x19F7,0x0000,0x0000,
0x19FC,0x0000,0x0000, 0x19FE,0x0000,0x0000, 0x1A01,0x0000,0x0000,
0x1A03,0x0000,0x0000, 0x1A08,0x0000,0x0000, 0x1A13,0x0000,0x0000,
0x1A16,0x0000,0x0000, 0x1A19,0x0000,0x0000, 0x1A1E,0x0000,0x0000,
0x1A32,0x0000,0x0000, 0x1A22,0x0000,0x0000, 0x1A27,0x0000,0x0000,
0x1A2C,0x0000,0x0000, 0x1A36,0x0000,0x0000, 0x1A39,0x0000,0x0000,
0x1A3F,0x0000,0x0000, 0x1A40,0x0000,0x0000, 0x1A1B,0x0000,0x0000,
0x19E3,0x0000,0x0000, 0x19E6,0x0000,0x0000, 0x19E9,0x0000,0x0000,
0x19F3,0x0000,0x0000, 0x19EE,0x0000,0x0000, 0x19F8,0x0000,0x0000,
0x1A2D,0x0000,0x0000, 0x1A04,0x0000,0x0000, 0x1A06,0x0000,0x0000,
0x19FF,0x0000,0x0000, 0x1A0C,0x0000,0x0000, 0x1A14,0x0000,0x0000,
0x1A17,0x0000,0x0000, 0x1A1F,0x0000,0x0000, 0x1A29,0x0000,0x0000,
0x1A37,0x0000,0x0000, 0x1A3A,0x0000,0x0000, 0x1A33,0x0000,0x0000,
0x1A35,0x0000,0x0000, 0x1A41,0x0000,0x0000, 0x1A1A,0x0000,0x0000,
0x1A23,0x0000,0x0000, 0x19E7,0x0000,0x0000, 0x1A2E,0x0000,0x0000,
0x1A25,0x0000,0x0000, 0x1A2A,0x0000,0x0000, 0x1A20,0x0000,0x0000,
0xFBC0,0x9878,0x0000, 0xFBC0,0x9879,0x0000, 0xFBC0,0x987A,0x0000,
0xFBC0,0x987B,0x0000, 0xFBC0,0x987C,0x0000, 0xFBC0,0x987D,0x0000,
0xFBC0,0x987E,0x0000, 0xFBC0,0x987F,0x0000, 0x19D7,0x0000,0x0000,
0x19D8,0x0000,0x0000, 0x19D9,0x0000,0x0000, 0x19DA,0x0000,0x0000,
0x19DB,0x0000,0x0000, 0x19DC,0x0000,0x0000, 0x19DD,0x0000,0x0000,
0x19E0,0x0000,0x0000, 0x19E8,0x0000,0x0000, 0x1A2F,0x0000,0x0000,
0x19F9,0x0000,0x0000, 0x1A1C,0x0000,0x0000, 0x1A42,0x0000,0x0000,
0x1A44,0x0000,0x0000, 0x1A45,0x0000,0x0000, 0x1A47,0x0000,0x0000,
0x1A48,0x0000,0x0000, 0x1A4B,0x0000,0x0000, 0x1A4D,0x0000,0x0000,
0x1A4E,0x0000,0x0000, 0x1A50,0x0000,0x0000, 0x1A52,0x0000,0x0000,
0x1A54,0x0000,0x0000, 0x1A55,0x0000,0x0000, 0x1A49,0x0000,0x0000,
0x1A53,0x0000,0x0000, 0x1A05,0x0000,0x0000, 0x19FA,0x0000,0x0000,
0x1A0D,0x0000,0x0000, 0x1A0E,0x0000,0x0000, 0x1A43,0x0000,0x0000,
0x1A46,0x0000,0x0000, 0x1A4A,0x0000,0x0000, 0x1A4C,0x0000,0x0000,
0x1A0F,0x0000,0x0000, 0x1A51,0x0000,0x0000, 0x1A10,0x0000,0x0000,
0x1A11,0x0000,0x0000, 0x1A56,0x0000,0x0000, 0x1A57,0x0000,0x0000,
0x1A4F,0x0000,0x0000, 0x1A58,0x0000,0x0000, 0xFBC0,0x98AA,0x0000,
0xFBC0,0x98AB,0x0000, 0xFBC0,0x98AC,0x0000, 0xFBC0,0x98AD,0x0000,
0xFBC0,0x98AE,0x0000, 0xFBC0,0x98AF,0x0000, 0xFBC0,0x98B0,0x0000,
0xFBC0,0x98B1,0x0000, 0xFBC0,0x98B2,0x0000, 0xFBC0,0x98B3,0x0000,
0xFBC0,0x98B4,0x0000, 0xFBC0,0x98B5,0x0000, 0xFBC0,0x98B6,0x0000,
0xFBC0,0x98B7,0x0000, 0xFBC0,0x98B8,0x0000, 0xFBC0,0x98B9,0x0000,
0xFBC0,0x98BA,0x0000, 0xFBC0,0x98BB,0x0000, 0xFBC0,0x98BC,0x0000,
0xFBC0,0x98BD,0x0000, 0xFBC0,0x98BE,0x0000, 0xFBC0,0x98BF,0x0000,
0xFBC0,0x98C0,0x0000, 0xFBC0,0x98C1,0x0000, 0xFBC0,0x98C2,0x0000,
0xFBC0,0x98C3,0x0000, 0xFBC0,0x98C4,0x0000, 0xFBC0,0x98C5,0x0000,
0xFBC0,0x98C6,0x0000, 0xFBC0,0x98C7,0x0000, 0xFBC0,0x98C8,0x0000,
0xFBC0,0x98C9,0x0000, 0xFBC0,0x98CA,0x0000, 0xFBC0,0x98CB,0x0000,
0xFBC0,0x98CC,0x0000, 0xFBC0,0x98CD,0x0000, 0xFBC0,0x98CE,0x0000,
0xFBC0,0x98CF,0x0000, 0xFBC0,0x98D0,0x0000, 0xFBC0,0x98D1,0x0000,
0xFBC0,0x98D2,0x0000, 0xFBC0,0x98D3,0x0000, 0xFBC0,0x98D4,0x0000,
0xFBC0,0x98D5,0x0000, 0xFBC0,0x98D6,0x0000, 0xFBC0,0x98D7,0x0000,
0xFBC0,0x98D8,0x0000, 0xFBC0,0x98D9,0x0000, 0xFBC0,0x98DA,0x0000,
0xFBC0,0x98DB,0x0000, 0xFBC0,0x98DC,0x0000, 0xFBC0,0x98DD,0x0000,
0xFBC0,0x98DE,0x0000, 0xFBC0,0x98DF,0x0000, 0xFBC0,0x98E0,0x0000,
0xFBC0,0x98E1,0x0000, 0xFBC0,0x98E2,0x0000, 0xFBC0,0x98E3,0x0000,
0xFBC0,0x98E4,0x0000, 0xFBC0,0x98E5,0x0000, 0xFBC0,0x98E6,0x0000,
0xFBC0,0x98E7,0x0000, 0xFBC0,0x98E8,0x0000, 0xFBC0,0x98E9,0x0000,
0xFBC0,0x98EA,0x0000, 0xFBC0,0x98EB,0x0000, 0xFBC0,0x98EC,0x0000,
0xFBC0,0x98ED,0x0000, 0xFBC0,0x98EE,0x0000, 0xFBC0,0x98EF,0x0000,
0xFBC0,0x98F0,0x0000, 0xFBC0,0x98F1,0x0000, 0xFBC0,0x98F2,0x0000,
0xFBC0,0x98F3,0x0000, 0xFBC0,0x98F4,0x0000, 0xFBC0,0x98F5,0x0000,
0xFBC0,0x98F6,0x0000, 0xFBC0,0x98F7,0x0000, 0xFBC0,0x98F8,0x0000,
0xFBC0,0x98F9,0x0000, 0xFBC0,0x98FA,0x0000, 0xFBC0,0x98FB,0x0000,
0xFBC0,0x98FC,0x0000, 0xFBC0,0x98FD,0x0000, 0xFBC0,0x98FE,0x0000,
0xFBC0,0x98FF,0x0000 };

uint16 page019data[]= { /* 1900 (3 weights per char) */
0x18B0,0x0000,0x0000, 0x18B1,0x0000,0x0000, 0x18B2,0x0000,0x0000,
0x18B3,0x0000,0x0000, 0x18B4,0x0000,0x0000, 0x18B5,0x0000,0x0000,
0x18B6,0x0000,0x0000, 0x18B7,0x0000,0x0000, 0x18B8,0x0000,0x0000,
0x18B9,0x0000,0x0000, 0x18BA,0x0000,0x0000, 0x18BB,0x0000,0x0000,
0x18BC,0x0000,0x0000, 0x18BD,0x0000,0x0000, 0x18BE,0x0000,0x0000,
0x18BF,0x0000,0x0000, 0x18C0,0x0000,0x0000, 0x18C1,0x0000,0x0000,
0x18C2,0x0000,0x0000, 0x18C3,0x0000,0x0000, 0x18C4,0x0000,0x0000,
0x18C5,0x0000,0x0000, 0x18C6,0x0000,0x0000, 0x18C7,0x0000,0x0000,
0x18C8,0x0000,0x0000, 0x18C9,0x0000,0x0000, 0x18CA,0x0000,0x0000,
0x18CB,0x0000,0x0000, 0x18CC,0x0000,0x0000, 0xFBC0,0x991D,0x0000,
0xFBC0,0x991E,0x0000, 0xFBC0,0x991F,0x0000, 0x18CD,0x0000,0x0000,
0x18CE,0x0000,0x0000, 0x18CF,0x0000,0x0000, 0x18D0,0x0000,0x0000,
0x18D1,0x0000,0x0000, 0x18D2,0x0000,0x0000, 0x18D3,0x0000,0x0000,
0x18D4,0x0000,0x0000, 0x18D5,0x0000,0x0000, 0x18D6,0x0000,0x0000,
0x18D7,0x0000,0x0000, 0x18D8,0x0000,0x0000, 0xFBC0,0x992C,0x0000,
0xFBC0,0x992D,0x0000, 0xFBC0,0x992E,0x0000, 0xFBC0,0x992F,0x0000,
0x18D9,0x0000,0x0000, 0x18DA,0x0000,0x0000, 0x18DB,0x0000,0x0000,
0x18DC,0x0000,0x0000, 0x18DD,0x0000,0x0000, 0x18DE,0x0000,0x0000,
0x18DF,0x0000,0x0000, 0x18E0,0x0000,0x0000, 0x18E1,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC0,0x993C,0x0000, 0xFBC0,0x993D,0x0000, 0xFBC0,0x993E,0x0000,
0xFBC0,0x993F,0x0000, 0x030D,0x0000,0x0000, 0xFBC0,0x9941,0x0000,
0xFBC0,0x9942,0x0000, 0xFBC0,0x9943,0x0000, 0x0254,0x0000,0x0000,
0x025B,0x0000,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x19B4,0x0000,0x0000,
0x19B5,0x0000,0x0000, 0x19B6,0x0000,0x0000, 0x19B7,0x0000,0x0000,
0x19B8,0x0000,0x0000, 0x19B9,0x0000,0x0000, 0x19BA,0x0000,0x0000,
0x19BB,0x0000,0x0000, 0x19BC,0x0000,0x0000, 0x19BD,0x0000,0x0000,
0x19BE,0x0000,0x0000, 0x19BF,0x0000,0x0000, 0x19C0,0x0000,0x0000,
0x19C1,0x0000,0x0000, 0x19C2,0x0000,0x0000, 0x19C3,0x0000,0x0000,
0x19C4,0x0000,0x0000, 0x19C5,0x0000,0x0000, 0x19C6,0x0000,0x0000,
0x19C7,0x0000,0x0000, 0x19C8,0x0000,0x0000, 0x19C9,0x0000,0x0000,
0x19CA,0x0000,0x0000, 0x19CB,0x0000,0x0000, 0x19CC,0x0000,0x0000,
0x19CD,0x0000,0x0000, 0x19CE,0x0000,0x0000, 0x19CF,0x0000,0x0000,
0x19D0,0x0000,0x0000, 0x19D1,0x0000,0x0000, 0xFBC0,0x996E,0x0000,
0xFBC0,0x996F,0x0000, 0x19D2,0x0000,0x0000, 0x19D3,0x0000,0x0000,
0x19D4,0x0000,0x0000, 0x19D5,0x0000,0x0000, 0x19D6,0x0000,0x0000,
0xFBC0,0x9975,0x0000, 0xFBC0,0x9976,0x0000, 0xFBC0,0x9977,0x0000,
0xFBC0,0x9978,0x0000, 0xFBC0,0x9979,0x0000, 0xFBC0,0x997A,0x0000,
0xFBC0,0x997B,0x0000, 0xFBC0,0x997C,0x0000, 0xFBC0,0x997D,0x0000,
0xFBC0,0x997E,0x0000, 0xFBC0,0x997F,0x0000, 0xFBC0,0x9980,0x0000,
0xFBC0,0x9981,0x0000, 0xFBC0,0x9982,0x0000, 0xFBC0,0x9983,0x0000,
0xFBC0,0x9984,0x0000, 0xFBC0,0x9985,0x0000, 0xFBC0,0x9986,0x0000,
0xFBC0,0x9987,0x0000, 0xFBC0,0x9988,0x0000, 0xFBC0,0x9989,0x0000,
0xFBC0,0x998A,0x0000, 0xFBC0,0x998B,0x0000, 0xFBC0,0x998C,0x0000,
0xFBC0,0x998D,0x0000, 0xFBC0,0x998E,0x0000, 0xFBC0,0x998F,0x0000,
0xFBC0,0x9990,0x0000, 0xFBC0,0x9991,0x0000, 0xFBC0,0x9992,0x0000,
0xFBC0,0x9993,0x0000, 0xFBC0,0x9994,0x0000, 0xFBC0,0x9995,0x0000,
0xFBC0,0x9996,0x0000, 0xFBC0,0x9997,0x0000, 0xFBC0,0x9998,0x0000,
0xFBC0,0x9999,0x0000, 0xFBC0,0x999A,0x0000, 0xFBC0,0x999B,0x0000,
0xFBC0,0x999C,0x0000, 0xFBC0,0x999D,0x0000, 0xFBC0,0x999E,0x0000,
0xFBC0,0x999F,0x0000, 0xFBC0,0x99A0,0x0000, 0xFBC0,0x99A1,0x0000,
0xFBC0,0x99A2,0x0000, 0xFBC0,0x99A3,0x0000, 0xFBC0,0x99A4,0x0000,
0xFBC0,0x99A5,0x0000, 0xFBC0,0x99A6,0x0000, 0xFBC0,0x99A7,0x0000,
0xFBC0,0x99A8,0x0000, 0xFBC0,0x99A9,0x0000, 0xFBC0,0x99AA,0x0000,
0xFBC0,0x99AB,0x0000, 0xFBC0,0x99AC,0x0000, 0xFBC0,0x99AD,0x0000,
0xFBC0,0x99AE,0x0000, 0xFBC0,0x99AF,0x0000, 0xFBC0,0x99B0,0x0000,
0xFBC0,0x99B1,0x0000, 0xFBC0,0x99B2,0x0000, 0xFBC0,0x99B3,0x0000,
0xFBC0,0x99B4,0x0000, 0xFBC0,0x99B5,0x0000, 0xFBC0,0x99B6,0x0000,
0xFBC0,0x99B7,0x0000, 0xFBC0,0x99B8,0x0000, 0xFBC0,0x99B9,0x0000,
0xFBC0,0x99BA,0x0000, 0xFBC0,0x99BB,0x0000, 0xFBC0,0x99BC,0x0000,
0xFBC0,0x99BD,0x0000, 0xFBC0,0x99BE,0x0000, 0xFBC0,0x99BF,0x0000,
0xFBC0,0x99C0,0x0000, 0xFBC0,0x99C1,0x0000, 0xFBC0,0x99C2,0x0000,
0xFBC0,0x99C3,0x0000, 0xFBC0,0x99C4,0x0000, 0xFBC0,0x99C5,0x0000,
0xFBC0,0x99C6,0x0000, 0xFBC0,0x99C7,0x0000, 0xFBC0,0x99C8,0x0000,
0xFBC0,0x99C9,0x0000, 0xFBC0,0x99CA,0x0000, 0xFBC0,0x99CB,0x0000,
0xFBC0,0x99CC,0x0000, 0xFBC0,0x99CD,0x0000, 0xFBC0,0x99CE,0x0000,
0xFBC0,0x99CF,0x0000, 0xFBC0,0x99D0,0x0000, 0xFBC0,0x99D1,0x0000,
0xFBC0,0x99D2,0x0000, 0xFBC0,0x99D3,0x0000, 0xFBC0,0x99D4,0x0000,
0xFBC0,0x99D5,0x0000, 0xFBC0,0x99D6,0x0000, 0xFBC0,0x99D7,0x0000,
0xFBC0,0x99D8,0x0000, 0xFBC0,0x99D9,0x0000, 0xFBC0,0x99DA,0x0000,
0xFBC0,0x99DB,0x0000, 0xFBC0,0x99DC,0x0000, 0xFBC0,0x99DD,0x0000,
0xFBC0,0x99DE,0x0000, 0xFBC0,0x99DF,0x0000, 0x037B,0x0000,0x0000,
0x037C,0x0000,0x0000, 0x037D,0x0000,0x0000, 0x037E,0x0000,0x0000,
0x037F,0x0000,0x0000, 0x0380,0x0000,0x0000, 0x0381,0x0000,0x0000,
0x0382,0x0000,0x0000, 0x0383,0x0000,0x0000, 0x0384,0x0000,0x0000,
0x0385,0x0000,0x0000, 0x0386,0x0000,0x0000, 0x0387,0x0000,0x0000,
0x0388,0x0000,0x0000, 0x0389,0x0000,0x0000, 0x038A,0x0000,0x0000,
0x038B,0x0000,0x0000, 0x038C,0x0000,0x0000, 0x038D,0x0000,0x0000,
0x038E,0x0000,0x0000, 0x038F,0x0000,0x0000, 0x0390,0x0000,0x0000,
0x0391,0x0000,0x0000, 0x0392,0x0000,0x0000, 0x0393,0x0000,0x0000,
0x0394,0x0000,0x0000, 0x0395,0x0000,0x0000, 0x0396,0x0000,0x0000,
0x0397,0x0000,0x0000, 0x0398,0x0000,0x0000, 0x0399,0x0000,0x0000,
0x039A,0x0000,0x0000 };

uint16 page01Ddata[]= { /* 1D00 (3 weights per char) */
0x0E37,0x0000,0x0000, 0x0E3C,0x0000,0x0000, 0x0E3D,0x0000,0x0000,
0x0E57,0x0000,0x0000, 0x0E64,0x0000,0x0000, 0x0E71,0x0000,0x0000,
0x0E8A,0x0000,0x0000, 0x0E8F,0x0000,0x0000, 0x0EA8,0x0000,0x0000,
0x0F07,0x0000,0x0000, 0x0F14,0x0000,0x0000, 0x0F25,0x0000,0x0000,
0x0F3A,0x0000,0x0000, 0x0F5F,0x0000,0x0000, 0x0F6D,0x0000,0x0000,
0x0F86,0x0000,0x0000, 0x0F96,0x0000,0x0000, 0x0F87,0x0000,0x0000,
0x0F97,0x0000,0x0000, 0x0F91,0x0000,0x0000, 0x0F8C,0x0000,0x0000,
0x0FA6,0x0000,0x0000, 0x0F98,0x0000,0x0000, 0x0F99,0x0000,0x0000,
0x0FAB,0x0000,0x0000, 0x0FC8,0x0000,0x0000, 0x0FCD,0x0000,0x0000,
0x1006,0x0000,0x0000, 0x1023,0x0000,0x0000, 0x1024,0x0000,0x0000,
0x1025,0x0000,0x0000, 0x103B,0x0000,0x0000, 0x1048,0x0000,0x0000,
0x1055,0x0000,0x0000, 0x106E,0x0000,0x0000, 0x1083,0x0000,0x0000,
0x10BA,0x0000,0x0000, 0x10BB,0x0000,0x0000, 0x10EB,0x0000,0x0000,
0x10F7,0x0000,0x0000, 0x10FD,0x0000,0x0000, 0x1101,0x0000,0x0000,
0x1108,0x0000,0x0000, 0x11B4,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E38,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E56,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E90,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F6C,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0FA2,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E3E,0x0000,0x0000,
0x0E42,0x0000,0x0000, 0x0E3D,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E94,0x0000,0x0000,
0x0E98,0x0000,0x0000, 0x0EA8,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0F07,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F7E,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F92,0x0000,0x0000,
0x0F98,0x0000,0x0000, 0x0F99,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1024,0x0000,0x0000,
0x1037,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x10BB,0x0000,0x0000,
0x10E9,0x0000,0x0000, 0x10EA,0x0000,0x0000, 0x10EC,0x0000,0x0000,
0x1105,0x0000,0x0000, 0x1106,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x10E9,0x0000,0x0000, 0x10EA,0x0000,0x0000, 0x1100,0x0000,0x0000,
0x1105,0x0000,0x0000, 0x1106,0x0000,0x0000, 0x1026,0x0000,0x0000,
0xFBC0,0x9D6C,0x0000, 0xFBC0,0x9D6D,0x0000, 0xFBC0,0x9D6E,0x0000,
0xFBC0,0x9D6F,0x0000, 0xFBC0,0x9D70,0x0000, 0xFBC0,0x9D71,0x0000,
0xFBC0,0x9D72,0x0000, 0xFBC0,0x9D73,0x0000, 0xFBC0,0x9D74,0x0000,
0xFBC0,0x9D75,0x0000, 0xFBC0,0x9D76,0x0000, 0xFBC0,0x9D77,0x0000,
0xFBC0,0x9D78,0x0000, 0xFBC0,0x9D79,0x0000, 0xFBC0,0x9D7A,0x0000,
0xFBC0,0x9D7B,0x0000, 0xFBC0,0x9D7C,0x0000, 0xFBC0,0x9D7D,0x0000,
0xFBC0,0x9D7E,0x0000, 0xFBC0,0x9D7F,0x0000, 0xFBC0,0x9D80,0x0000,
0xFBC0,0x9D81,0x0000, 0xFBC0,0x9D82,0x0000, 0xFBC0,0x9D83,0x0000,
0xFBC0,0x9D84,0x0000, 0xFBC0,0x9D85,0x0000, 0xFBC0,0x9D86,0x0000,
0xFBC0,0x9D87,0x0000, 0xFBC0,0x9D88,0x0000, 0xFBC0,0x9D89,0x0000,
0xFBC0,0x9D8A,0x0000, 0xFBC0,0x9D8B,0x0000, 0xFBC0,0x9D8C,0x0000,
0xFBC0,0x9D8D,0x0000, 0xFBC0,0x9D8E,0x0000, 0xFBC0,0x9D8F,0x0000,
0xFBC0,0x9D90,0x0000, 0xFBC0,0x9D91,0x0000, 0xFBC0,0x9D92,0x0000,
0xFBC0,0x9D93,0x0000, 0xFBC0,0x9D94,0x0000, 0xFBC0,0x9D95,0x0000,
0xFBC0,0x9D96,0x0000, 0xFBC0,0x9D97,0x0000, 0xFBC0,0x9D98,0x0000,
0xFBC0,0x9D99,0x0000, 0xFBC0,0x9D9A,0x0000, 0xFBC0,0x9D9B,0x0000,
0xFBC0,0x9D9C,0x0000, 0xFBC0,0x9D9D,0x0000, 0xFBC0,0x9D9E,0x0000,
0xFBC0,0x9D9F,0x0000, 0xFBC0,0x9DA0,0x0000, 0xFBC0,0x9DA1,0x0000,
0xFBC0,0x9DA2,0x0000, 0xFBC0,0x9DA3,0x0000, 0xFBC0,0x9DA4,0x0000,
0xFBC0,0x9DA5,0x0000, 0xFBC0,0x9DA6,0x0000, 0xFBC0,0x9DA7,0x0000,
0xFBC0,0x9DA8,0x0000, 0xFBC0,0x9DA9,0x0000, 0xFBC0,0x9DAA,0x0000,
0xFBC0,0x9DAB,0x0000, 0xFBC0,0x9DAC,0x0000, 0xFBC0,0x9DAD,0x0000,
0xFBC0,0x9DAE,0x0000, 0xFBC0,0x9DAF,0x0000, 0xFBC0,0x9DB0,0x0000,
0xFBC0,0x9DB1,0x0000, 0xFBC0,0x9DB2,0x0000, 0xFBC0,0x9DB3,0x0000,
0xFBC0,0x9DB4,0x0000, 0xFBC0,0x9DB5,0x0000, 0xFBC0,0x9DB6,0x0000,
0xFBC0,0x9DB7,0x0000, 0xFBC0,0x9DB8,0x0000, 0xFBC0,0x9DB9,0x0000,
0xFBC0,0x9DBA,0x0000, 0xFBC0,0x9DBB,0x0000, 0xFBC0,0x9DBC,0x0000,
0xFBC0,0x9DBD,0x0000, 0xFBC0,0x9DBE,0x0000, 0xFBC0,0x9DBF,0x0000,
0xFBC0,0x9DC0,0x0000, 0xFBC0,0x9DC1,0x0000, 0xFBC0,0x9DC2,0x0000,
0xFBC0,0x9DC3,0x0000, 0xFBC0,0x9DC4,0x0000, 0xFBC0,0x9DC5,0x0000,
0xFBC0,0x9DC6,0x0000, 0xFBC0,0x9DC7,0x0000, 0xFBC0,0x9DC8,0x0000,
0xFBC0,0x9DC9,0x0000, 0xFBC0,0x9DCA,0x0000, 0xFBC0,0x9DCB,0x0000,
0xFBC0,0x9DCC,0x0000, 0xFBC0,0x9DCD,0x0000, 0xFBC0,0x9DCE,0x0000,
0xFBC0,0x9DCF,0x0000, 0xFBC0,0x9DD0,0x0000, 0xFBC0,0x9DD1,0x0000,
0xFBC0,0x9DD2,0x0000, 0xFBC0,0x9DD3,0x0000, 0xFBC0,0x9DD4,0x0000,
0xFBC0,0x9DD5,0x0000, 0xFBC0,0x9DD6,0x0000, 0xFBC0,0x9DD7,0x0000,
0xFBC0,0x9DD8,0x0000, 0xFBC0,0x9DD9,0x0000, 0xFBC0,0x9DDA,0x0000,
0xFBC0,0x9DDB,0x0000, 0xFBC0,0x9DDC,0x0000, 0xFBC0,0x9DDD,0x0000,
0xFBC0,0x9DDE,0x0000, 0xFBC0,0x9DDF,0x0000, 0xFBC0,0x9DE0,0x0000,
0xFBC0,0x9DE1,0x0000, 0xFBC0,0x9DE2,0x0000, 0xFBC0,0x9DE3,0x0000,
0xFBC0,0x9DE4,0x0000, 0xFBC0,0x9DE5,0x0000, 0xFBC0,0x9DE6,0x0000,
0xFBC0,0x9DE7,0x0000, 0xFBC0,0x9DE8,0x0000, 0xFBC0,0x9DE9,0x0000,
0xFBC0,0x9DEA,0x0000, 0xFBC0,0x9DEB,0x0000, 0xFBC0,0x9DEC,0x0000,
0xFBC0,0x9DED,0x0000, 0xFBC0,0x9DEE,0x0000, 0xFBC0,0x9DEF,0x0000,
0xFBC0,0x9DF0,0x0000, 0xFBC0,0x9DF1,0x0000, 0xFBC0,0x9DF2,0x0000,
0xFBC0,0x9DF3,0x0000, 0xFBC0,0x9DF4,0x0000, 0xFBC0,0x9DF5,0x0000,
0xFBC0,0x9DF6,0x0000, 0xFBC0,0x9DF7,0x0000, 0xFBC0,0x9DF8,0x0000,
0xFBC0,0x9DF9,0x0000, 0xFBC0,0x9DFA,0x0000, 0xFBC0,0x9DFB,0x0000,
0xFBC0,0x9DFC,0x0000, 0xFBC0,0x9DFD,0x0000, 0xFBC0,0x9DFE,0x0000,
0xFBC0,0x9DFF,0x0000 };

uint16 page01Edata[]= { /* 1E00 (3 weights per char) */
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0EB9,0x0000,0x0000, 0x0EB9,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F21,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F2E,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F64,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FA7,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1002,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x1044,0x0000,0x0000, 0x1044,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x105A,0x0000,0x0000, 0x105A,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x105A,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x106A,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x1051,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x0E33,0x10B3,0x0000, 0x0FEA,0x0000,0x0000,
0xFBC0,0x9E9C,0x0000, 0xFBC0,0x9E9D,0x0000, 0xFBC0,0x9E9E,0x0000,
0xFBC0,0x9E9F,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x101F,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x105E,0x0000,0x0000, 0xFBC0,0x9EFA,0x0000, 0xFBC0,0x9EFB,0x0000,
0xFBC0,0x9EFC,0x0000, 0xFBC0,0x9EFD,0x0000, 0xFBC0,0x9EFE,0x0000,
0xFBC0,0x9EFF,0x0000 };

uint16 page01Fdata[]= { /* 1F00 (3 weights per char) */
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0xFBC0,0x9F16,0x0000, 0xFBC0,0x9F17,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0xFBC0,0x9F1E,0x0000, 0xFBC0,0x9F1F,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0xFBC0,0x9F46,0x0000, 0xFBC0,0x9F47,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0xFBC0,0x9F4E,0x0000, 0xFBC0,0x9F4F,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0xFBC0,0x9F58,0x0000, 0x1104,0x0000,0x0000,
0xFBC0,0x9F5A,0x0000, 0x1104,0x0000,0x0000, 0xFBC0,0x9F5C,0x0000,
0x1104,0x0000,0x0000, 0xFBC0,0x9F5E,0x0000, 0x1104,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10ED,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x10FB,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0xFBC0,0x9F7E,0x0000, 0xFBC0,0x9F7F,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0xFBC0,0x9FB5,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000, 0x10E8,0x0000,0x0000,
0x0217,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x0217,0x0000,0x0000,
0x021D,0x0000,0x0000, 0x0214,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0xFBC0,0x9FC5,0x0000,
0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10ED,0x0000,0x0000,
0x10ED,0x0000,0x0000, 0x10F1,0x0000,0x0000, 0x10F1,0x0000,0x0000,
0x10F1,0x0000,0x0000, 0x0217,0x0000,0x0000, 0x0217,0x0000,0x0000,
0x0217,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0xFBC0,0x9FD4,0x0000,
0xFBC0,0x9FD5,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000, 0x10F3,0x0000,0x0000,
0x10F3,0x0000,0x0000, 0xFBC0,0x9FDC,0x0000, 0x0218,0x0000,0x0000,
0x0218,0x0000,0x0000, 0x0218,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1100,0x0000,0x0000, 0x1100,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000,
0x1104,0x0000,0x0000, 0x1104,0x0000,0x0000, 0x1100,0x0000,0x0000,
0x0214,0x0000,0x0000, 0x0214,0x0000,0x0000, 0x020C,0x0000,0x0000,
0xFBC0,0x9FF0,0x0000, 0xFBC0,0x9FF1,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0xFBC0,0x9FF5,0x0000,
0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x10FB,0x0000,0x0000,
0x10FB,0x0000,0x0000, 0x1109,0x0000,0x0000, 0x1109,0x0000,0x0000,
0x1109,0x0000,0x0000, 0x020D,0x0000,0x0000, 0x0218,0x0000,0x0000,
0xFBC0,0x9FFF,0x0000 };

uint16 page020data[]= { /* 2000 (5 weights per char) */
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0225,0x0000,0x0000,0x0000,0x0000,
0x0225,0x0000,0x0000,0x0000,0x0000,
0x0226,0x0000,0x0000,0x0000,0x0000,
0x0227,0x0000,0x0000,0x0000,0x0000,
0x0228,0x0000,0x0000,0x0000,0x0000,
0x0229,0x0000,0x0000,0x0000,0x0000,
0x0432,0x0000,0x0000,0x0000,0x0000,
0x021C,0x0000,0x0000,0x0000,0x0000,
0x0278,0x0000,0x0000,0x0000,0x0000,
0x0279,0x0000,0x0000,0x0000,0x0000,
0x027A,0x0000,0x0000,0x0000,0x0000,
0x027B,0x0000,0x0000,0x0000,0x0000,
0x027F,0x0000,0x0000,0x0000,0x0000,
0x0280,0x0000,0x0000,0x0000,0x0000,
0x0281,0x0000,0x0000,0x0000,0x0000,
0x0282,0x0000,0x0000,0x0000,0x0000,
0x02D8,0x0000,0x0000,0x0000,0x0000,
0x02D9,0x0000,0x0000,0x0000,0x0000,
0x02DA,0x0000,0x0000,0x0000,0x0000,
0x02DB,0x0000,0x0000,0x0000,0x0000,
0x025D,0x0000,0x0000,0x0000,0x0000,
0x025D,0x025D,0x0000,0x0000,0x0000,
0x025D,0x025D,0x025D,0x0000,0x0000,
0x02DC,0x0000,0x0000,0x0000,0x0000,
0x0207,0x0000,0x0000,0x0000,0x0000,
0x0208,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x02D5,0x0000,0x0000,0x0000,0x0000,
0x02D6,0x0000,0x0000,0x0000,0x0000,
0x02E0,0x0000,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x02E0,0x0000,0x0000,
0x02E1,0x0000,0x0000,0x0000,0x0000,
0x02E1,0x02E1,0x0000,0x0000,0x0000,
0x02E1,0x02E1,0x02E1,0x0000,0x0000,
0x02E4,0x0000,0x0000,0x0000,0x0000,
0x027C,0x0000,0x0000,0x0000,0x0000,
0x027D,0x0000,0x0000,0x0000,0x0000,
0x02E5,0x0000,0x0000,0x0000,0x0000,
0x0251,0x0251,0x0000,0x0000,0x0000,
0x025C,0x0000,0x0000,0x0000,0x0000,
0x0211,0x0000,0x0000,0x0000,0x0000,
0x02E6,0x0000,0x0000,0x0000,0x0000,
0x02E8,0x0000,0x0000,0x0000,0x0000,
0x02EA,0x0000,0x0000,0x0000,0x0000,
0x02EB,0x0000,0x0000,0x0000,0x0000,
0x02DD,0x0000,0x0000,0x0000,0x0000,
0x02CD,0x0000,0x0000,0x0000,0x0000,
0x0294,0x0000,0x0000,0x0000,0x0000,
0x0295,0x0000,0x0000,0x0000,0x0000,
0x0255,0x0255,0x0000,0x0000,0x0000,
0x0255,0x0251,0x0000,0x0000,0x0000,
0x0251,0x0255,0x0000,0x0000,0x0000,
0x02D1,0x0000,0x0000,0x0000,0x0000,
0x02C4,0x0000,0x0000,0x0000,0x0000,
0x02DE,0x0000,0x0000,0x0000,0x0000,
0x02DF,0x0000,0x0000,0x0000,0x0000,
0x02C9,0x0000,0x0000,0x0000,0x0000,
0x023C,0x0000,0x0000,0x0000,0x0000,
0x02E9,0x0000,0x0000,0x0000,0x0000,
0x02CA,0x0000,0x0000,0x0000,0x0000,
0x02D7,0x0000,0x0000,0x0000,0x0000,
0x022A,0x0000,0x0000,0x0000,0x0000,
0x02E7,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA055,0x0000,0x0000,0x0000,
0xFBC0,0xA056,0x0000,0x0000,0x0000,
0x02E0,0x02E0,0x02E0,0x02E0,0x0000,
0xFBC0,0xA058,0x0000,0x0000,0x0000,
0xFBC0,0xA059,0x0000,0x0000,0x0000,
0xFBC0,0xA05A,0x0000,0x0000,0x0000,
0xFBC0,0xA05B,0x0000,0x0000,0x0000,
0xFBC0,0xA05C,0x0000,0x0000,0x0000,
0xFBC0,0xA05D,0x0000,0x0000,0x0000,
0xFBC0,0xA05E,0x0000,0x0000,0x0000,
0x0209,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA064,0x0000,0x0000,0x0000,
0xFBC0,0xA065,0x0000,0x0000,0x0000,
0xFBC0,0xA066,0x0000,0x0000,0x0000,
0xFBC0,0xA067,0x0000,0x0000,0x0000,
0xFBC0,0xA068,0x0000,0x0000,0x0000,
0xFBC0,0xA069,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA072,0x0000,0x0000,0x0000,
0xFBC0,0xA073,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0428,0x0000,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000,0x0000,
0x0289,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0428,0x0000,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000,0x0000,
0x0288,0x0000,0x0000,0x0000,0x0000,
0x0289,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA08F,0x0000,0x0000,0x0000,
0xFBC0,0xA090,0x0000,0x0000,0x0000,
0xFBC0,0xA091,0x0000,0x0000,0x0000,
0xFBC0,0xA092,0x0000,0x0000,0x0000,
0xFBC0,0xA093,0x0000,0x0000,0x0000,
0xFBC0,0xA094,0x0000,0x0000,0x0000,
0xFBC0,0xA095,0x0000,0x0000,0x0000,
0xFBC0,0xA096,0x0000,0x0000,0x0000,
0xFBC0,0xA097,0x0000,0x0000,0x0000,
0xFBC0,0xA098,0x0000,0x0000,0x0000,
0xFBC0,0xA099,0x0000,0x0000,0x0000,
0xFBC0,0xA09A,0x0000,0x0000,0x0000,
0xFBC0,0xA09B,0x0000,0x0000,0x0000,
0xFBC0,0xA09C,0x0000,0x0000,0x0000,
0xFBC0,0xA09D,0x0000,0x0000,0x0000,
0xFBC0,0xA09E,0x0000,0x0000,0x0000,
0xFBC0,0xA09F,0x0000,0x0000,0x0000,
0x0E18,0x0000,0x0000,0x0000,0x0000,
0x0E19,0x0000,0x0000,0x0000,0x0000,
0x0E1A,0x0000,0x0000,0x0000,0x0000,
0x0E1B,0x0000,0x0000,0x0000,0x0000,
0x0E1C,0x0000,0x0000,0x0000,0x0000,
0x0E1D,0x0000,0x0000,0x0000,0x0000,
0x0E1E,0x0000,0x0000,0x0000,0x0000,
0x0E1F,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0FEA,0x0000,0x0000,0x0000,
0x0E20,0x0000,0x0000,0x0000,0x0000,
0x0E21,0x0000,0x0000,0x0000,0x0000,
0x0E22,0x0000,0x0000,0x0000,0x0000,
0x0E23,0x0000,0x0000,0x0000,0x0000,
0x0E24,0x0000,0x0000,0x0000,0x0000,
0x0E25,0x0000,0x0000,0x0000,0x0000,
0x0E26,0x0000,0x0000,0x0000,0x0000,
0x0E27,0x0000,0x0000,0x0000,0x0000,
0x0E28,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA0B2,0x0000,0x0000,0x0000,
0xFBC0,0xA0B3,0x0000,0x0000,0x0000,
0xFBC0,0xA0B4,0x0000,0x0000,0x0000,
0xFBC0,0xA0B5,0x0000,0x0000,0x0000,
0xFBC0,0xA0B6,0x0000,0x0000,0x0000,
0xFBC0,0xA0B7,0x0000,0x0000,0x0000,
0xFBC0,0xA0B8,0x0000,0x0000,0x0000,
0xFBC0,0xA0B9,0x0000,0x0000,0x0000,
0xFBC0,0xA0BA,0x0000,0x0000,0x0000,
0xFBC0,0xA0BB,0x0000,0x0000,0x0000,
0xFBC0,0xA0BC,0x0000,0x0000,0x0000,
0xFBC0,0xA0BD,0x0000,0x0000,0x0000,
0xFBC0,0xA0BE,0x0000,0x0000,0x0000,
0xFBC0,0xA0BF,0x0000,0x0000,0x0000,
0xFBC0,0xA0C0,0x0000,0x0000,0x0000,
0xFBC0,0xA0C1,0x0000,0x0000,0x0000,
0xFBC0,0xA0C2,0x0000,0x0000,0x0000,
0xFBC0,0xA0C3,0x0000,0x0000,0x0000,
0xFBC0,0xA0C4,0x0000,0x0000,0x0000,
0xFBC0,0xA0C5,0x0000,0x0000,0x0000,
0xFBC0,0xA0C6,0x0000,0x0000,0x0000,
0xFBC0,0xA0C7,0x0000,0x0000,0x0000,
0xFBC0,0xA0C8,0x0000,0x0000,0x0000,
0xFBC0,0xA0C9,0x0000,0x0000,0x0000,
0xFBC0,0xA0CA,0x0000,0x0000,0x0000,
0xFBC0,0xA0CB,0x0000,0x0000,0x0000,
0xFBC0,0xA0CC,0x0000,0x0000,0x0000,
0xFBC0,0xA0CD,0x0000,0x0000,0x0000,
0xFBC0,0xA0CE,0x0000,0x0000,0x0000,
0xFBC0,0xA0CF,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA0EB,0x0000,0x0000,0x0000,
0xFBC0,0xA0EC,0x0000,0x0000,0x0000,
0xFBC0,0xA0ED,0x0000,0x0000,0x0000,
0xFBC0,0xA0EE,0x0000,0x0000,0x0000,
0xFBC0,0xA0EF,0x0000,0x0000,0x0000,
0xFBC0,0xA0F0,0x0000,0x0000,0x0000,
0xFBC0,0xA0F1,0x0000,0x0000,0x0000,
0xFBC0,0xA0F2,0x0000,0x0000,0x0000,
0xFBC0,0xA0F3,0x0000,0x0000,0x0000,
0xFBC0,0xA0F4,0x0000,0x0000,0x0000,
0xFBC0,0xA0F5,0x0000,0x0000,0x0000,
0xFBC0,0xA0F6,0x0000,0x0000,0x0000,
0xFBC0,0xA0F7,0x0000,0x0000,0x0000,
0xFBC0,0xA0F8,0x0000,0x0000,0x0000,
0xFBC0,0xA0F9,0x0000,0x0000,0x0000,
0xFBC0,0xA0FA,0x0000,0x0000,0x0000,
0xFBC0,0xA0FB,0x0000,0x0000,0x0000,
0xFBC0,0xA0FC,0x0000,0x0000,0x0000,
0xFBC0,0xA0FD,0x0000,0x0000,0x0000,
0xFBC0,0xA0FE,0x0000,0x0000,0x0000,
0xFBC0,0xA0FF,0x0000,0x0000,0x0000
};

uint16 page021data[]= { /* 2100 (5 weights per char) */
0x0E33,0x02CC,0x0E60,0x0000,0x0000,
0x0E33,0x02CC,0x0FEA,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x034A,0x0E60,0x0000,0x0000,0x0000,
0x039B,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x02CC,0x0F82,0x0000,0x0000,
0x0E60,0x02CC,0x101F,0x0000,0x0000,
0x0E98,0x0000,0x0000,0x0000,0x0000,
0x039C,0x0000,0x0000,0x0000,0x0000,
0x034A,0x0EB9,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EED,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x039D,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0F82,0x0000,0x0000,0x0000,
0x039E,0x0000,0x0000,0x0000,0x0000,
0x039F,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x03A0,0x0000,0x0000,0x0000,0x0000,
0x03A1,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0F5B,0x0000,0x0000,0x0000,
0x1002,0x0E8B,0x0F2E,0x0000,0x0000,
0x1002,0x0F5B,0x0000,0x0000,0x0000,
0x03A2,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x03A3,0x0000,0x0000,0x0000,0x0000,
0x1109,0x0000,0x0000,0x0000,0x0000,
0x03A4,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x03A5,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x03A6,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x03A7,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000,0x0000,
0x1332,0x0000,0x0000,0x0000,0x0000,
0x1333,0x0000,0x0000,0x0000,0x0000,
0x1334,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x03A8,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0E33,0x105A,0x0000,0x0000,
0xFBC0,0xA13C,0x0000,0x0000,0x0000,
0x10EA,0x0000,0x0000,0x0000,0x0000,
0x10EA,0x0000,0x0000,0x0000,0x0000,
0x10FC,0x0000,0x0000,0x0000,0x0000,
0x0427,0x0000,0x0000,0x0000,0x0000,
0x03A9,0x0000,0x0000,0x0000,0x0000,
0x03AA,0x0000,0x0000,0x0000,0x0000,
0x03AB,0x0000,0x0000,0x0000,0x0000,
0x03AC,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x03AD,0x0000,0x0000,0x0000,0x0000,
0x02D0,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA14C,0x0000,0x0000,0x0000,
0xFBC0,0xA14D,0x0000,0x0000,0x0000,
0xFBC0,0xA14E,0x0000,0x0000,0x0000,
0xFBC0,0xA14F,0x0000,0x0000,0x0000,
0xFBC0,0xA150,0x0000,0x0000,0x0000,
0xFBC0,0xA151,0x0000,0x0000,0x0000,
0xFBC0,0xA152,0x0000,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2C,0x0000,0x0000,
0x0E2B,0x02CD,0x0E2C,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2B,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2C,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2D,0x02CD,0x0E2E,0x0000,0x0000,
0x0E2A,0x02CD,0x0E2F,0x0000,0x0000,
0x0E2E,0x02CD,0x0E2F,0x0000,0x0000,
0x0E2A,0x02CD,0x0E31,0x0000,0x0000,
0x0E2C,0x02CD,0x0E31,0x0000,0x0000,
0x0E2E,0x02CD,0x0E31,0x0000,0x0000,
0x0E30,0x02CD,0x0E31,0x0000,0x0000,
0x0E2A,0x02CD,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0EFB,0x0000,0x0000,
0x0EFB,0x1044,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0EFB,0x0000,
0x0EFB,0x105A,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0EFB,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0000,0x0000,0x0000,
0x0EFB,0x0EFB,0x0EFB,0x0000,0x0000,
0x0EFB,0x1044,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0000,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0000,0x0000,
0x1044,0x0EFB,0x0EFB,0x0EFB,0x0000,
0x0EFB,0x105A,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0000,0x0000,0x0000,
0x105A,0x0EFB,0x0EFB,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0DD7,0x0000,0x0000,0x0000,0x0000,
0x0DD8,0x0000,0x0000,0x0000,0x0000,
0x0DD9,0x0000,0x0000,0x0000,0x0000,
0x0DDA,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA184,0x0000,0x0000,0x0000,
0xFBC0,0xA185,0x0000,0x0000,0x0000,
0xFBC0,0xA186,0x0000,0x0000,0x0000,
0xFBC0,0xA187,0x0000,0x0000,0x0000,
0xFBC0,0xA188,0x0000,0x0000,0x0000,
0xFBC0,0xA189,0x0000,0x0000,0x0000,
0xFBC0,0xA18A,0x0000,0x0000,0x0000,
0xFBC0,0xA18B,0x0000,0x0000,0x0000,
0xFBC0,0xA18C,0x0000,0x0000,0x0000,
0xFBC0,0xA18D,0x0000,0x0000,0x0000,
0xFBC0,0xA18E,0x0000,0x0000,0x0000,
0xFBC0,0xA18F,0x0000,0x0000,0x0000,
0x03AE,0x0000,0x0000,0x0000,0x0000,
0x03B0,0x0000,0x0000,0x0000,0x0000,
0x03AF,0x0000,0x0000,0x0000,0x0000,
0x03B1,0x0000,0x0000,0x0000,0x0000,
0x03B2,0x0000,0x0000,0x0000,0x0000,
0x03B3,0x0000,0x0000,0x0000,0x0000,
0x03B4,0x0000,0x0000,0x0000,0x0000,
0x03B5,0x0000,0x0000,0x0000,0x0000,
0x03B6,0x0000,0x0000,0x0000,0x0000,
0x03B7,0x0000,0x0000,0x0000,0x0000,
0x03AE,0x0000,0x0000,0x0000,0x0000,
0x03AF,0x0000,0x0000,0x0000,0x0000,
0x03B8,0x0000,0x0000,0x0000,0x0000,
0x03B9,0x0000,0x0000,0x0000,0x0000,
0x03BA,0x0000,0x0000,0x0000,0x0000,
0x03BB,0x0000,0x0000,0x0000,0x0000,
0x03BC,0x0000,0x0000,0x0000,0x0000,
0x03BD,0x0000,0x0000,0x0000,0x0000,
0x03BE,0x0000,0x0000,0x0000,0x0000,
0x03BF,0x0000,0x0000,0x0000,0x0000,
0x03C0,0x0000,0x0000,0x0000,0x0000,
0x03C1,0x0000,0x0000,0x0000,0x0000,
0x03C2,0x0000,0x0000,0x0000,0x0000,
0x03C3,0x0000,0x0000,0x0000,0x0000,
0x03C4,0x0000,0x0000,0x0000,0x0000,
0x03C5,0x0000,0x0000,0x0000,0x0000,
0x03C6,0x0000,0x0000,0x0000,0x0000,
0x03C7,0x0000,0x0000,0x0000,0x0000,
0x03C8,0x0000,0x0000,0x0000,0x0000,
0x03C9,0x0000,0x0000,0x0000,0x0000,
0x03B2,0x0000,0x0000,0x0000,0x0000,
0x03CA,0x0000,0x0000,0x0000,0x0000,
0x03CB,0x0000,0x0000,0x0000,0x0000,
0x03CC,0x0000,0x0000,0x0000,0x0000,
0x03CD,0x0000,0x0000,0x0000,0x0000,
0x03CE,0x0000,0x0000,0x0000,0x0000,
0x03CF,0x0000,0x0000,0x0000,0x0000,
0x03D0,0x0000,0x0000,0x0000,0x0000,
0x03D1,0x0000,0x0000,0x0000,0x0000,
0x03D2,0x0000,0x0000,0x0000,0x0000,
0x03D3,0x0000,0x0000,0x0000,0x0000,
0x03D4,0x0000,0x0000,0x0000,0x0000,
0x03D5,0x0000,0x0000,0x0000,0x0000,
0x03D6,0x0000,0x0000,0x0000,0x0000,
0x03D7,0x0000,0x0000,0x0000,0x0000,
0x03D8,0x0000,0x0000,0x0000,0x0000,
0x03D9,0x0000,0x0000,0x0000,0x0000,
0x03DA,0x0000,0x0000,0x0000,0x0000,
0x03DB,0x0000,0x0000,0x0000,0x0000,
0x03DC,0x0000,0x0000,0x0000,0x0000,
0x03DD,0x0000,0x0000,0x0000,0x0000,
0x03DE,0x0000,0x0000,0x0000,0x0000,
0x03DF,0x0000,0x0000,0x0000,0x0000,
0x03E0,0x0000,0x0000,0x0000,0x0000,
0x03E1,0x0000,0x0000,0x0000,0x0000,
0x03E2,0x0000,0x0000,0x0000,0x0000,
0x03E3,0x0000,0x0000,0x0000,0x0000,
0x03E4,0x0000,0x0000,0x0000,0x0000,
0x03E5,0x0000,0x0000,0x0000,0x0000,
0x03E6,0x0000,0x0000,0x0000,0x0000,
0x03E7,0x0000,0x0000,0x0000,0x0000,
0x03E8,0x0000,0x0000,0x0000,0x0000,
0x03EC,0x0000,0x0000,0x0000,0x0000,
0x03EA,0x0000,0x0000,0x0000,0x0000,
0x03E8,0x0000,0x0000,0x0000,0x0000,
0x03E9,0x0000,0x0000,0x0000,0x0000,
0x03EA,0x0000,0x0000,0x0000,0x0000,
0x03EB,0x0000,0x0000,0x0000,0x0000,
0x03EC,0x0000,0x0000,0x0000,0x0000,
0x03ED,0x0000,0x0000,0x0000,0x0000,
0x03EE,0x0000,0x0000,0x0000,0x0000,
0x03EF,0x0000,0x0000,0x0000,0x0000,
0x03F0,0x0000,0x0000,0x0000,0x0000,
0x03F1,0x0000,0x0000,0x0000,0x0000,
0x03F2,0x0000,0x0000,0x0000,0x0000,
0x03F3,0x0000,0x0000,0x0000,0x0000,
0x03F4,0x0000,0x0000,0x0000,0x0000,
0x03F5,0x0000,0x0000,0x0000,0x0000,
0x03F6,0x0000,0x0000,0x0000,0x0000,
0x03F7,0x0000,0x0000,0x0000,0x0000,
0x03F8,0x0000,0x0000,0x0000,0x0000,
0x03F9,0x0000,0x0000,0x0000,0x0000,
0x03FA,0x0000,0x0000,0x0000,0x0000,
0x03FB,0x0000,0x0000,0x0000,0x0000,
0x03FC,0x0000,0x0000,0x0000,0x0000,
0x03FD,0x0000,0x0000,0x0000,0x0000,
0x03FE,0x0000,0x0000,0x0000,0x0000,
0x03FF,0x0000,0x0000,0x0000,0x0000,
0x0400,0x0000,0x0000,0x0000,0x0000,
0x0401,0x0000,0x0000,0x0000,0x0000,
0x0402,0x0000,0x0000,0x0000,0x0000,
0x0403,0x0000,0x0000,0x0000,0x0000,
0x0404,0x0000,0x0000,0x0000,0x0000,
0x0405,0x0000,0x0000,0x0000,0x0000,
0x0406,0x0000,0x0000,0x0000,0x0000,
0x0407,0x0000,0x0000,0x0000,0x0000,
0x0408,0x0000,0x0000,0x0000,0x0000,
0x0409,0x0000,0x0000,0x0000,0x0000,
0x040A,0x0000,0x0000,0x0000,0x0000,
0x040B,0x0000,0x0000,0x0000,0x0000,
0x040C,0x0000,0x0000,0x0000,0x0000,
0x040D,0x0000,0x0000,0x0000,0x0000,
0x040E,0x0000,0x0000,0x0000,0x0000,
0x040F,0x0000,0x0000,0x0000,0x0000,
0x0410,0x0000,0x0000,0x0000,0x0000,
0x0411,0x0000,0x0000,0x0000,0x0000,
0x0412,0x0000,0x0000,0x0000,0x0000,
0x0413,0x0000,0x0000,0x0000,0x0000,
0x0414,0x0000,0x0000,0x0000,0x0000,
0x0415,0x0000,0x0000,0x0000,0x0000,
0x0416,0x0000,0x0000,0x0000,0x0000,
0x0417,0x0000,0x0000,0x0000,0x0000
};

uint16 page022data[]= { /* 2200 (4 weights per char) */
0x0418,0x0000,0x0000,0x0000, 0x0419,0x0000,0x0000,0x0000,
0x041A,0x0000,0x0000,0x0000, 0x041B,0x0000,0x0000,0x0000,
0x041B,0x0000,0x0000,0x0000, 0x041C,0x0000,0x0000,0x0000,
0x041D,0x0000,0x0000,0x0000, 0x041E,0x0000,0x0000,0x0000,
0x041F,0x0000,0x0000,0x0000, 0x041F,0x0000,0x0000,0x0000,
0x0420,0x0000,0x0000,0x0000, 0x0421,0x0000,0x0000,0x0000,
0x0421,0x0000,0x0000,0x0000, 0x0422,0x0000,0x0000,0x0000,
0x0424,0x0000,0x0000,0x0000, 0x0425,0x0000,0x0000,0x0000,
0x0426,0x0000,0x0000,0x0000, 0x0427,0x0000,0x0000,0x0000,
0x0434,0x0000,0x0000,0x0000, 0x0435,0x0000,0x0000,0x0000,
0x0436,0x0000,0x0000,0x0000, 0x0437,0x0000,0x0000,0x0000,
0x0438,0x0000,0x0000,0x0000, 0x0439,0x0000,0x0000,0x0000,
0x043A,0x0000,0x0000,0x0000, 0x043B,0x0000,0x0000,0x0000,
0x043C,0x0000,0x0000,0x0000, 0x043D,0x0000,0x0000,0x0000,
0x043E,0x0000,0x0000,0x0000, 0x043F,0x0000,0x0000,0x0000,
0x0440,0x0000,0x0000,0x0000, 0x0441,0x0000,0x0000,0x0000,
0x0442,0x0000,0x0000,0x0000, 0x0443,0x0000,0x0000,0x0000,
0x0444,0x0000,0x0000,0x0000, 0x0445,0x0000,0x0000,0x0000,
0x0445,0x0000,0x0000,0x0000, 0x0446,0x0000,0x0000,0x0000,
0x0446,0x0000,0x0000,0x0000, 0x0447,0x0000,0x0000,0x0000,
0x0448,0x0000,0x0000,0x0000, 0x0449,0x0000,0x0000,0x0000,
0x044A,0x0000,0x0000,0x0000, 0x044B,0x0000,0x0000,0x0000,
0x044B,0x044B,0x0000,0x0000, 0x044B,0x044B,0x044B,0x0000,
0x044C,0x0000,0x0000,0x0000, 0x044C,0x044C,0x0000,0x0000,
0x044C,0x044C,0x044C,0x0000, 0x044D,0x0000,0x0000,0x0000,
0x044E,0x0000,0x0000,0x0000, 0x044F,0x0000,0x0000,0x0000,
0x0450,0x0000,0x0000,0x0000, 0x0451,0x0000,0x0000,0x0000,
0x0452,0x0000,0x0000,0x0000, 0x0453,0x0000,0x0000,0x0000,
0x0454,0x0000,0x0000,0x0000, 0x0455,0x0000,0x0000,0x0000,
0x0456,0x0000,0x0000,0x0000, 0x0457,0x0000,0x0000,0x0000,
0x0458,0x0000,0x0000,0x0000, 0x0459,0x0000,0x0000,0x0000,
0x045A,0x0000,0x0000,0x0000, 0x045B,0x0000,0x0000,0x0000,
0x045C,0x0000,0x0000,0x0000, 0x0458,0x0000,0x0000,0x0000,
0x045D,0x0000,0x0000,0x0000, 0x045E,0x0000,0x0000,0x0000,
0x045E,0x0000,0x0000,0x0000, 0x045F,0x0000,0x0000,0x0000,
0x0460,0x0000,0x0000,0x0000, 0x045F,0x0000,0x0000,0x0000,
0x0461,0x0000,0x0000,0x0000, 0x0461,0x0000,0x0000,0x0000,
0x0462,0x0000,0x0000,0x0000, 0x0463,0x0000,0x0000,0x0000,
0x0464,0x0000,0x0000,0x0000, 0x0465,0x0000,0x0000,0x0000,
0x0466,0x0000,0x0000,0x0000, 0x0467,0x0000,0x0000,0x0000,
0x0468,0x0000,0x0000,0x0000, 0x0469,0x0000,0x0000,0x0000,
0x046A,0x0000,0x0000,0x0000, 0x046B,0x0000,0x0000,0x0000,
0x046C,0x0000,0x0000,0x0000, 0x046D,0x0000,0x0000,0x0000,
0x046E,0x0000,0x0000,0x0000, 0x046F,0x0000,0x0000,0x0000,
0x0470,0x0000,0x0000,0x0000, 0x0471,0x0000,0x0000,0x0000,
0x0472,0x0000,0x0000,0x0000, 0x0473,0x0000,0x0000,0x0000,
0x0474,0x0000,0x0000,0x0000, 0x0475,0x0000,0x0000,0x0000,
0x0476,0x0000,0x0000,0x0000, 0x0477,0x0000,0x0000,0x0000,
0x042D,0x0000,0x0000,0x0000, 0x0478,0x0000,0x0000,0x0000,
0x0478,0x0000,0x0000,0x0000, 0x0479,0x0000,0x0000,0x0000,
0x047A,0x0000,0x0000,0x0000, 0x047B,0x0000,0x0000,0x0000,
0x047C,0x0000,0x0000,0x0000, 0x047D,0x0000,0x0000,0x0000,
0x047E,0x0000,0x0000,0x0000, 0x047F,0x0000,0x0000,0x0000,
0x0480,0x0000,0x0000,0x0000, 0x0481,0x0000,0x0000,0x0000,
0x0482,0x0000,0x0000,0x0000, 0x0465,0x0000,0x0000,0x0000,
0x042C,0x0000,0x0000,0x0000, 0x042E,0x0000,0x0000,0x0000,
0x047A,0x0000,0x0000,0x0000, 0x047B,0x0000,0x0000,0x0000,
0x0483,0x0000,0x0000,0x0000, 0x0484,0x0000,0x0000,0x0000,
0x0483,0x0000,0x0000,0x0000, 0x0484,0x0000,0x0000,0x0000,
0x0485,0x0000,0x0000,0x0000, 0x0486,0x0000,0x0000,0x0000,
0x0485,0x0000,0x0000,0x0000, 0x0486,0x0000,0x0000,0x0000,
0x0487,0x0000,0x0000,0x0000, 0x0488,0x0000,0x0000,0x0000,
0x0489,0x0000,0x0000,0x0000, 0x048A,0x0000,0x0000,0x0000,
0x048B,0x0000,0x0000,0x0000, 0x048C,0x0000,0x0000,0x0000,
0x0487,0x0000,0x0000,0x0000, 0x0488,0x0000,0x0000,0x0000,
0x048D,0x0000,0x0000,0x0000, 0x048E,0x0000,0x0000,0x0000,
0x048D,0x0000,0x0000,0x0000, 0x048E,0x0000,0x0000,0x0000,
0x048F,0x0000,0x0000,0x0000, 0x0490,0x0000,0x0000,0x0000,
0x048F,0x0000,0x0000,0x0000, 0x0490,0x0000,0x0000,0x0000,
0x0491,0x0000,0x0000,0x0000, 0x0492,0x0000,0x0000,0x0000,
0x0493,0x0000,0x0000,0x0000, 0x0494,0x0000,0x0000,0x0000,
0x0495,0x0000,0x0000,0x0000, 0x0496,0x0000,0x0000,0x0000,
0x0497,0x0000,0x0000,0x0000, 0x0498,0x0000,0x0000,0x0000,
0x0499,0x0000,0x0000,0x0000, 0x049A,0x0000,0x0000,0x0000,
0x049B,0x0000,0x0000,0x0000, 0x049C,0x0000,0x0000,0x0000,
0x049D,0x0000,0x0000,0x0000, 0x049E,0x0000,0x0000,0x0000,
0x049F,0x0000,0x0000,0x0000, 0x04A0,0x0000,0x0000,0x0000,
0x04A1,0x0000,0x0000,0x0000, 0x04A2,0x0000,0x0000,0x0000,
0x04A3,0x0000,0x0000,0x0000, 0x04A4,0x0000,0x0000,0x0000,
0x04A5,0x0000,0x0000,0x0000, 0x04A6,0x0000,0x0000,0x0000,
0x04A7,0x0000,0x0000,0x0000, 0x04A8,0x0000,0x0000,0x0000,
0x04A9,0x0000,0x0000,0x0000, 0x04AA,0x0000,0x0000,0x0000,
0x04AB,0x0000,0x0000,0x0000, 0x04AC,0x0000,0x0000,0x0000,
0x04AD,0x0000,0x0000,0x0000, 0x04AE,0x0000,0x0000,0x0000,
0x04AF,0x0000,0x0000,0x0000, 0x04B0,0x0000,0x0000,0x0000,
0x04B1,0x0000,0x0000,0x0000, 0x04B2,0x0000,0x0000,0x0000,
0x04A9,0x0000,0x0000,0x0000, 0x04AF,0x0000,0x0000,0x0000,
0x04B0,0x0000,0x0000,0x0000, 0x04B2,0x0000,0x0000,0x0000,
0x04B3,0x0000,0x0000,0x0000, 0x04B4,0x0000,0x0000,0x0000,
0x04B5,0x0000,0x0000,0x0000, 0x04B6,0x0000,0x0000,0x0000,
0x04B7,0x0000,0x0000,0x0000, 0x04B8,0x0000,0x0000,0x0000,
0x04B9,0x0000,0x0000,0x0000, 0x04BA,0x0000,0x0000,0x0000,
0x04BB,0x0000,0x0000,0x0000, 0x04BC,0x0000,0x0000,0x0000,
0x04BD,0x0000,0x0000,0x0000, 0x04BE,0x0000,0x0000,0x0000,
0x04BF,0x0000,0x0000,0x0000, 0x04C0,0x0000,0x0000,0x0000,
0x04C1,0x0000,0x0000,0x0000, 0x04C2,0x0000,0x0000,0x0000,
0x04C3,0x0000,0x0000,0x0000, 0x04C4,0x0000,0x0000,0x0000,
0x04C5,0x0000,0x0000,0x0000, 0x04C6,0x0000,0x0000,0x0000,
0x04C7,0x0000,0x0000,0x0000, 0x04C8,0x0000,0x0000,0x0000,
0x04C9,0x0000,0x0000,0x0000, 0x04CA,0x0000,0x0000,0x0000,
0x04CB,0x0000,0x0000,0x0000, 0x04CC,0x0000,0x0000,0x0000,
0x04CD,0x0000,0x0000,0x0000, 0x04CE,0x0000,0x0000,0x0000,
0x04CF,0x0000,0x0000,0x0000, 0x04D0,0x0000,0x0000,0x0000,
0x04D1,0x0000,0x0000,0x0000, 0x04D2,0x0000,0x0000,0x0000,
0x04D3,0x0000,0x0000,0x0000, 0x04D4,0x0000,0x0000,0x0000,
0x04D5,0x0000,0x0000,0x0000, 0x04D6,0x0000,0x0000,0x0000,
0x04D7,0x0000,0x0000,0x0000, 0x04D8,0x0000,0x0000,0x0000,
0x04D9,0x0000,0x0000,0x0000, 0x04DA,0x0000,0x0000,0x0000,
0x04DB,0x0000,0x0000,0x0000, 0x04DC,0x0000,0x0000,0x0000,
0x04DD,0x0000,0x0000,0x0000, 0x04DE,0x0000,0x0000,0x0000,
0x04DF,0x0000,0x0000,0x0000, 0x04E0,0x0000,0x0000,0x0000,
0x04E1,0x0000,0x0000,0x0000, 0x04E2,0x0000,0x0000,0x0000,
0x0489,0x0000,0x0000,0x0000, 0x048A,0x0000,0x0000,0x0000,
0x0498,0x0000,0x0000,0x0000, 0x0499,0x0000,0x0000,0x0000,
0x04E3,0x0000,0x0000,0x0000, 0x04E4,0x0000,0x0000,0x0000,
0x04E5,0x0000,0x0000,0x0000, 0x04E6,0x0000,0x0000,0x0000,
0x04E7,0x0000,0x0000,0x0000, 0x04E8,0x0000,0x0000,0x0000,
0x04B5,0x0000,0x0000,0x0000, 0x04B6,0x0000,0x0000,0x0000,
0x04B7,0x0000,0x0000,0x0000, 0x04B8,0x0000,0x0000,0x0000,
0x04E9,0x0000,0x0000,0x0000, 0x04EA,0x0000,0x0000,0x0000,
0x04EB,0x0000,0x0000,0x0000, 0x04EC,0x0000,0x0000,0x0000,
0x04ED,0x0000,0x0000,0x0000, 0x04EE,0x0000,0x0000,0x0000,
0x04EF,0x0000,0x0000,0x0000, 0x04F0,0x0000,0x0000,0x0000,
0x04F1,0x0000,0x0000,0x0000, 0x04F2,0x0000,0x0000,0x0000,
0x04F3,0x0000,0x0000,0x0000, 0x04F4,0x0000,0x0000,0x0000,
0x04F5,0x0000,0x0000,0x0000, 0x04F6,0x0000,0x0000,0x0000,
0x04F7,0x0000,0x0000,0x0000, 0x04F8,0x0000,0x0000,0x0000,
0x04F9,0x0000,0x0000,0x0000, 0x04FA,0x0000,0x0000,0x0000
};

uint16 page023data[]= { /* 2300 (3 weights per char) */
0x04FB,0x0000,0x0000, 0x04FC,0x0000,0x0000, 0x04FD,0x0000,0x0000,
0x04FE,0x0000,0x0000, 0x04FF,0x0000,0x0000, 0x0500,0x0000,0x0000,
0x0501,0x0000,0x0000, 0x0502,0x0000,0x0000, 0x0503,0x0000,0x0000,
0x0504,0x0000,0x0000, 0x0505,0x0000,0x0000, 0x0506,0x0000,0x0000,
0x0507,0x0000,0x0000, 0x0508,0x0000,0x0000, 0x0509,0x0000,0x0000,
0x050A,0x0000,0x0000, 0x050B,0x0000,0x0000, 0x050C,0x0000,0x0000,
0x050D,0x0000,0x0000, 0x050E,0x0000,0x0000, 0x050F,0x0000,0x0000,
0x0510,0x0000,0x0000, 0x0511,0x0000,0x0000, 0x0512,0x0000,0x0000,
0x0513,0x0000,0x0000, 0x0514,0x0000,0x0000, 0x0515,0x0000,0x0000,
0x0516,0x0000,0x0000, 0x0517,0x0000,0x0000, 0x0518,0x0000,0x0000,
0x0519,0x0000,0x0000, 0x051A,0x0000,0x0000, 0x051B,0x0000,0x0000,
0x051C,0x0000,0x0000, 0x051D,0x0000,0x0000, 0x051E,0x0000,0x0000,
0x051F,0x0000,0x0000, 0x0520,0x0000,0x0000, 0x0521,0x0000,0x0000,
0x0522,0x0000,0x0000, 0x0523,0x0000,0x0000, 0x02AE,0x0000,0x0000,
0x02AF,0x0000,0x0000, 0x0524,0x0000,0x0000, 0x0525,0x0000,0x0000,
0x0526,0x0000,0x0000, 0x0527,0x0000,0x0000, 0x0528,0x0000,0x0000,
0x0529,0x0000,0x0000, 0x052A,0x0000,0x0000, 0x052B,0x0000,0x0000,
0x052C,0x0000,0x0000, 0x052D,0x0000,0x0000, 0x052E,0x0000,0x0000,
0x052F,0x0000,0x0000, 0x0530,0x0000,0x0000, 0x0531,0x0000,0x0000,
0x0532,0x0000,0x0000, 0x0533,0x0000,0x0000, 0x0534,0x0000,0x0000,
0x0535,0x0000,0x0000, 0x0536,0x0000,0x0000, 0x0537,0x0000,0x0000,
0x0538,0x0000,0x0000, 0x0539,0x0000,0x0000, 0x053A,0x0000,0x0000,
0x053B,0x0000,0x0000, 0x053C,0x0000,0x0000, 0x053D,0x0000,0x0000,
0x053E,0x0000,0x0000, 0x053F,0x0000,0x0000, 0x0540,0x0000,0x0000,
0x0541,0x0000,0x0000, 0x0542,0x0000,0x0000, 0x0543,0x0000,0x0000,
0x0544,0x0000,0x0000, 0x0545,0x0000,0x0000, 0x0546,0x0000,0x0000,
0x0547,0x0000,0x0000, 0x0548,0x0000,0x0000, 0x0549,0x0000,0x0000,
0x054A,0x0000,0x0000, 0x054B,0x0000,0x0000, 0x054C,0x0000,0x0000,
0x054D,0x0000,0x0000, 0x054E,0x0000,0x0000, 0x054F,0x0000,0x0000,
0x0550,0x0000,0x0000, 0x0551,0x0000,0x0000, 0x0552,0x0000,0x0000,
0x0553,0x0000,0x0000, 0x0554,0x0000,0x0000, 0x0555,0x0000,0x0000,
0x0556,0x0000,0x0000, 0x0557,0x0000,0x0000, 0x0558,0x0000,0x0000,
0x0559,0x0000,0x0000, 0x055A,0x0000,0x0000, 0x055B,0x0000,0x0000,
0x055C,0x0000,0x0000, 0x055D,0x0000,0x0000, 0x055E,0x0000,0x0000,
0x055F,0x0000,0x0000, 0x0560,0x0000,0x0000, 0x0561,0x0000,0x0000,
0x0562,0x0000,0x0000, 0x0563,0x0000,0x0000, 0x0564,0x0000,0x0000,
0x0565,0x0000,0x0000, 0x0566,0x0000,0x0000, 0x0567,0x0000,0x0000,
0x0568,0x0000,0x0000, 0x0569,0x0000,0x0000, 0x056A,0x0000,0x0000,
0x056B,0x0000,0x0000, 0x056C,0x0000,0x0000, 0x056D,0x0000,0x0000,
0x056E,0x0000,0x0000, 0x056F,0x0000,0x0000, 0x0570,0x0000,0x0000,
0x0571,0x0000,0x0000, 0x0572,0x0000,0x0000, 0x0573,0x0000,0x0000,
0x0574,0x0000,0x0000, 0x0575,0x0000,0x0000, 0x0576,0x0000,0x0000,
0x0577,0x0000,0x0000, 0x0578,0x0000,0x0000, 0x0579,0x0000,0x0000,
0x057A,0x0000,0x0000, 0x057B,0x0000,0x0000, 0x057C,0x0000,0x0000,
0x057D,0x0000,0x0000, 0x057E,0x0000,0x0000, 0x057F,0x0000,0x0000,
0x0580,0x0000,0x0000, 0x0581,0x0000,0x0000, 0x0582,0x0000,0x0000,
0x0583,0x0000,0x0000, 0x0584,0x0000,0x0000, 0x0585,0x0000,0x0000,
0x0586,0x0000,0x0000, 0x0587,0x0000,0x0000, 0x0588,0x0000,0x0000,
0x0589,0x0000,0x0000, 0x058A,0x0000,0x0000, 0x058B,0x0000,0x0000,
0x058C,0x0000,0x0000, 0x058D,0x0000,0x0000, 0x058E,0x0000,0x0000,
0x058F,0x0000,0x0000, 0x0590,0x0000,0x0000, 0x0591,0x0000,0x0000,
0x0592,0x0000,0x0000, 0x0593,0x0000,0x0000, 0x0594,0x0000,0x0000,
0x0595,0x0000,0x0000, 0x0596,0x0000,0x0000, 0x0597,0x0000,0x0000,
0x0598,0x0000,0x0000, 0x0599,0x0000,0x0000, 0x059A,0x0000,0x0000,
0x059B,0x0000,0x0000, 0x059C,0x0000,0x0000, 0x059D,0x0000,0x0000,
0x059E,0x0000,0x0000, 0x059F,0x0000,0x0000, 0x05A0,0x0000,0x0000,
0x05A1,0x0000,0x0000, 0x05A2,0x0000,0x0000, 0x05A3,0x0000,0x0000,
0x05A4,0x0000,0x0000, 0x05A5,0x0000,0x0000, 0x05A6,0x0000,0x0000,
0x05A7,0x0000,0x0000, 0x05A8,0x0000,0x0000, 0x05A9,0x0000,0x0000,
0x05AA,0x0000,0x0000, 0x05AB,0x0000,0x0000, 0x05AC,0x0000,0x0000,
0x05AD,0x0000,0x0000, 0x05AE,0x0000,0x0000, 0x05AF,0x0000,0x0000,
0x05B0,0x0000,0x0000, 0x05B1,0x0000,0x0000, 0x05B2,0x0000,0x0000,
0x05B3,0x0000,0x0000, 0x05B4,0x0000,0x0000, 0x05B5,0x0000,0x0000,
0x05B6,0x0000,0x0000, 0x05B7,0x0000,0x0000, 0x05B8,0x0000,0x0000,
0x05B9,0x0000,0x0000, 0x05BA,0x0000,0x0000, 0x05BB,0x0000,0x0000,
0x05BC,0x0000,0x0000, 0x05BD,0x0000,0x0000, 0x05BE,0x0000,0x0000,
0x05BF,0x0000,0x0000, 0x05C0,0x0000,0x0000, 0x05C1,0x0000,0x0000,
0x05C2,0x0000,0x0000, 0x05C3,0x0000,0x0000, 0x05C4,0x0000,0x0000,
0x05C5,0x0000,0x0000, 0x05C6,0x0000,0x0000, 0x05C7,0x0000,0x0000,
0x05C8,0x0000,0x0000, 0x05C9,0x0000,0x0000, 0xFBC0,0xA3D1,0x0000,
0xFBC0,0xA3D2,0x0000, 0xFBC0,0xA3D3,0x0000, 0xFBC0,0xA3D4,0x0000,
0xFBC0,0xA3D5,0x0000, 0xFBC0,0xA3D6,0x0000, 0xFBC0,0xA3D7,0x0000,
0xFBC0,0xA3D8,0x0000, 0xFBC0,0xA3D9,0x0000, 0xFBC0,0xA3DA,0x0000,
0xFBC0,0xA3DB,0x0000, 0xFBC0,0xA3DC,0x0000, 0xFBC0,0xA3DD,0x0000,
0xFBC0,0xA3DE,0x0000, 0xFBC0,0xA3DF,0x0000, 0xFBC0,0xA3E0,0x0000,
0xFBC0,0xA3E1,0x0000, 0xFBC0,0xA3E2,0x0000, 0xFBC0,0xA3E3,0x0000,
0xFBC0,0xA3E4,0x0000, 0xFBC0,0xA3E5,0x0000, 0xFBC0,0xA3E6,0x0000,
0xFBC0,0xA3E7,0x0000, 0xFBC0,0xA3E8,0x0000, 0xFBC0,0xA3E9,0x0000,
0xFBC0,0xA3EA,0x0000, 0xFBC0,0xA3EB,0x0000, 0xFBC0,0xA3EC,0x0000,
0xFBC0,0xA3ED,0x0000, 0xFBC0,0xA3EE,0x0000, 0xFBC0,0xA3EF,0x0000,
0xFBC0,0xA3F0,0x0000, 0xFBC0,0xA3F1,0x0000, 0xFBC0,0xA3F2,0x0000,
0xFBC0,0xA3F3,0x0000, 0xFBC0,0xA3F4,0x0000, 0xFBC0,0xA3F5,0x0000,
0xFBC0,0xA3F6,0x0000, 0xFBC0,0xA3F7,0x0000, 0xFBC0,0xA3F8,0x0000,
0xFBC0,0xA3F9,0x0000, 0xFBC0,0xA3FA,0x0000, 0xFBC0,0xA3FB,0x0000,
0xFBC0,0xA3FC,0x0000, 0xFBC0,0xA3FD,0x0000, 0xFBC0,0xA3FE,0x0000,
0xFBC0,0xA3FF,0x0000 };

uint16 page024data[]= { /* 2400 (5 weights per char) */
0x05CA,0x0000,0x0000,0x0000,0x0000,
0x05CB,0x0000,0x0000,0x0000,0x0000,
0x05CC,0x0000,0x0000,0x0000,0x0000,
0x05CD,0x0000,0x0000,0x0000,0x0000,
0x05CE,0x0000,0x0000,0x0000,0x0000,
0x05CF,0x0000,0x0000,0x0000,0x0000,
0x05D0,0x0000,0x0000,0x0000,0x0000,
0x05D1,0x0000,0x0000,0x0000,0x0000,
0x05D2,0x0000,0x0000,0x0000,0x0000,
0x05D3,0x0000,0x0000,0x0000,0x0000,
0x05D4,0x0000,0x0000,0x0000,0x0000,
0x05D5,0x0000,0x0000,0x0000,0x0000,
0x05D6,0x0000,0x0000,0x0000,0x0000,
0x05D7,0x0000,0x0000,0x0000,0x0000,
0x05D8,0x0000,0x0000,0x0000,0x0000,
0x05D9,0x0000,0x0000,0x0000,0x0000,
0x05DA,0x0000,0x0000,0x0000,0x0000,
0x05DB,0x0000,0x0000,0x0000,0x0000,
0x05DC,0x0000,0x0000,0x0000,0x0000,
0x05DD,0x0000,0x0000,0x0000,0x0000,
0x05DE,0x0000,0x0000,0x0000,0x0000,
0x05DF,0x0000,0x0000,0x0000,0x0000,
0x05E0,0x0000,0x0000,0x0000,0x0000,
0x05E1,0x0000,0x0000,0x0000,0x0000,
0x05E2,0x0000,0x0000,0x0000,0x0000,
0x05E3,0x0000,0x0000,0x0000,0x0000,
0x05E4,0x0000,0x0000,0x0000,0x0000,
0x05E5,0x0000,0x0000,0x0000,0x0000,
0x05E6,0x0000,0x0000,0x0000,0x0000,
0x05E7,0x0000,0x0000,0x0000,0x0000,
0x05E8,0x0000,0x0000,0x0000,0x0000,
0x05E9,0x0000,0x0000,0x0000,0x0000,
0x05EA,0x0000,0x0000,0x0000,0x0000,
0x05EB,0x0000,0x0000,0x0000,0x0000,
0x05EC,0x0000,0x0000,0x0000,0x0000,
0x05ED,0x0000,0x0000,0x0000,0x0000,
0x05EE,0x0000,0x0000,0x0000,0x0000,
0x05EF,0x0000,0x0000,0x0000,0x0000,
0x05F0,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA427,0x0000,0x0000,0x0000,
0xFBC0,0xA428,0x0000,0x0000,0x0000,
0xFBC0,0xA429,0x0000,0x0000,0x0000,
0xFBC0,0xA42A,0x0000,0x0000,0x0000,
0xFBC0,0xA42B,0x0000,0x0000,0x0000,
0xFBC0,0xA42C,0x0000,0x0000,0x0000,
0xFBC0,0xA42D,0x0000,0x0000,0x0000,
0xFBC0,0xA42E,0x0000,0x0000,0x0000,
0xFBC0,0xA42F,0x0000,0x0000,0x0000,
0xFBC0,0xA430,0x0000,0x0000,0x0000,
0xFBC0,0xA431,0x0000,0x0000,0x0000,
0xFBC0,0xA432,0x0000,0x0000,0x0000,
0xFBC0,0xA433,0x0000,0x0000,0x0000,
0xFBC0,0xA434,0x0000,0x0000,0x0000,
0xFBC0,0xA435,0x0000,0x0000,0x0000,
0xFBC0,0xA436,0x0000,0x0000,0x0000,
0xFBC0,0xA437,0x0000,0x0000,0x0000,
0xFBC0,0xA438,0x0000,0x0000,0x0000,
0xFBC0,0xA439,0x0000,0x0000,0x0000,
0xFBC0,0xA43A,0x0000,0x0000,0x0000,
0xFBC0,0xA43B,0x0000,0x0000,0x0000,
0xFBC0,0xA43C,0x0000,0x0000,0x0000,
0xFBC0,0xA43D,0x0000,0x0000,0x0000,
0xFBC0,0xA43E,0x0000,0x0000,0x0000,
0xFBC0,0xA43F,0x0000,0x0000,0x0000,
0x05F1,0x0000,0x0000,0x0000,0x0000,
0x05F2,0x0000,0x0000,0x0000,0x0000,
0x05F3,0x0000,0x0000,0x0000,0x0000,
0x05F4,0x0000,0x0000,0x0000,0x0000,
0x05F5,0x0000,0x0000,0x0000,0x0000,
0x05F6,0x0000,0x0000,0x0000,0x0000,
0x05F7,0x0000,0x0000,0x0000,0x0000,
0x05F8,0x0000,0x0000,0x0000,0x0000,
0x05F9,0x0000,0x0000,0x0000,0x0000,
0x05FA,0x0000,0x0000,0x0000,0x0000,
0x05FB,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xA44B,0x0000,0x0000,0x0000,
0xFBC0,0xA44C,0x0000,0x0000,0x0000,
0xFBC0,0xA44D,0x0000,0x0000,0x0000,
0xFBC0,0xA44E,0x0000,0x0000,0x0000,
0xFBC0,0xA44F,0x0000,0x0000,0x0000,
0xFBC0,0xA450,0x0000,0x0000,0x0000,
0xFBC0,0xA451,0x0000,0x0000,0x0000,
0xFBC0,0xA452,0x0000,0x0000,0x0000,
0xFBC0,0xA453,0x0000,0x0000,0x0000,
0xFBC0,0xA454,0x0000,0x0000,0x0000,
0xFBC0,0xA455,0x0000,0x0000,0x0000,
0xFBC0,0xA456,0x0000,0x0000,0x0000,
0xFBC0,0xA457,0x0000,0x0000,0x0000,
0xFBC0,0xA458,0x0000,0x0000,0x0000,
0xFBC0,0xA459,0x0000,0x0000,0x0000,
0xFBC0,0xA45A,0x0000,0x0000,0x0000,
0xFBC0,0xA45B,0x0000,0x0000,0x0000,
0xFBC0,0xA45C,0x0000,0x0000,0x0000,
0xFBC0,0xA45D,0x0000,0x0000,0x0000,
0xFBC0,0xA45E,0x0000,0x0000,0x0000,
0xFBC0,0xA45F,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0x0000,0x0000,0x0000,
0x0288,0x0E2A,0x0289,0x0000,0x0000,
0x0288,0x0E2B,0x0289,0x0000,0x0000,
0x0288,0x0E2C,0x0289,0x0000,0x0000,
0x0288,0x0E2D,0x0289,0x0000,0x0000,
0x0288,0x0E2E,0x0289,0x0000,0x0000,
0x0288,0x0E2F,0x0289,0x0000,0x0000,
0x0288,0x0E30,0x0289,0x0000,0x0000,
0x0288,0x0E31,0x0289,0x0000,0x0000,
0x0288,0x0E32,0x0289,0x0000,0x0000,
0x0288,0x0E2A,0x0E29,0x0289,0x0000,
0x0288,0x0E2A,0x0E2A,0x0289,0x0000,
0x0288,0x0E2A,0x0E2B,0x0289,0x0000,
0x0288,0x0E2A,0x0E2C,0x0289,0x0000,
0x0288,0x0E2A,0x0E2D,0x0289,0x0000,
0x0288,0x0E2A,0x0E2E,0x0289,0x0000,
0x0288,0x0E2A,0x0E2F,0x0289,0x0000,
0x0288,0x0E2A,0x0E30,0x0289,0x0000,
0x0288,0x0E2A,0x0E31,0x0289,0x0000,
0x0288,0x0E2A,0x0E32,0x0289,0x0000,
0x0288,0x0E2B,0x0E29,0x0289,0x0000,
0x0E2A,0x025D,0x0000,0x0000,0x0000,
0x0E2B,0x025D,0x0000,0x0000,0x0000,
0x0E2C,0x025D,0x0000,0x0000,0x0000,
0x0E2D,0x025D,0x0000,0x0000,0x0000,
0x0E2E,0x025D,0x0000,0x0000,0x0000,
0x0E2F,0x025D,0x0000,0x0000,0x0000,
0x0E30,0x025D,0x0000,0x0000,0x0000,
0x0E31,0x025D,0x0000,0x0000,0x0000,
0x0E32,0x025D,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x025D,0x0000,0x0000,
0x0E2A,0x0E2A,0x025D,0x0000,0x0000,
0x0E2A,0x0E2B,0x025D,0x0000,0x0000,
0x0E2A,0x0E2C,0x025D,0x0000,0x0000,
0x0E2A,0x0E2D,0x025D,0x0000,0x0000,
0x0E2A,0x0E2E,0x025D,0x0000,0x0000,
0x0E2A,0x0E2F,0x025D,0x0000,0x0000,
0x0E2A,0x0E30,0x025D,0x0000,0x0000,
0x0E2A,0x0E31,0x025D,0x0000,0x0000,
0x0E2A,0x0E32,0x025D,0x0000,0x0000,
0x0E2B,0x0E29,0x025D,0x0000,0x0000,
0x0288,0x0E33,0x0289,0x0000,0x0000,
0x0288,0x0E4A,0x0289,0x0000,0x0000,
0x0288,0x0E60,0x0289,0x0000,0x0000,
0x0288,0x0E6D,0x0289,0x0000,0x0000,
0x0288,0x0E8B,0x0289,0x0000,0x0000,
0x0288,0x0EB9,0x0289,0x0000,0x0000,
0x0288,0x0EC1,0x0289,0x0000,0x0000,
0x0288,0x0EE1,0x0289,0x0000,0x0000,
0x0288,0x0EFB,0x0289,0x0000,0x0000,
0x0288,0x0F10,0x0289,0x0000,0x0000,
0x0288,0x0F21,0x0289,0x0000,0x0000,
0x0288,0x0F2E,0x0289,0x0000,0x0000,
0x0288,0x0F5B,0x0289,0x0000,0x0000,
0x0288,0x0F64,0x0289,0x0000,0x0000,
0x0288,0x0F82,0x0289,0x0000,0x0000,
0x0288,0x0FA7,0x0289,0x0000,0x0000,
0x0288,0x0FB4,0x0289,0x0000,0x0000,
0x0288,0x0FC0,0x0289,0x0000,0x0000,
0x0288,0x0FEA,0x0289,0x0000,0x0000,
0x0288,0x1002,0x0289,0x0000,0x0000,
0x0288,0x101F,0x0289,0x0000,0x0000,
0x0288,0x1044,0x0289,0x0000,0x0000,
0x0288,0x1051,0x0289,0x0000,0x0000,
0x0288,0x105A,0x0289,0x0000,0x0000,
0x0288,0x105E,0x0289,0x0000,0x0000,
0x0288,0x106A,0x0289,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105E,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0000,0x0000,0x0000,0x0000,
0x0F10,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0000,0x0000,0x0000,0x0000,
0x0FB4,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0000,0x0000,0x0000,0x0000,
0x101F,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0000,0x0000,0x0000,0x0000,
0x105A,0x0000,0x0000,0x0000,0x0000,
0x105E,0x0000,0x0000,0x0000,0x0000,
0x106A,0x0000,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0x0000,0x0000,0x0000,
0x0E2A,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0x0000,0x0000,0x0000,0x0000,
0x0E30,0x0000,0x0000,0x0000,0x0000,
0x0E31,0x0000,0x0000,0x0000,0x0000,
0x0E32,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0x0000,0x0000,0x0000,
0x0E29,0x0000,0x0000,0x0000,0x0000
};

uint16 page025data[]= { /* 2500 (2 weights per char) */
0x05FC,0x0000, 0x05FD,0x0000, 0x05FE,0x0000, 0x05FF,0x0000,
0x0600,0x0000, 0x0601,0x0000, 0x0602,0x0000, 0x0603,0x0000,
0x0604,0x0000, 0x0605,0x0000, 0x0606,0x0000, 0x0607,0x0000,
0x0608,0x0000, 0x0609,0x0000, 0x060A,0x0000, 0x060B,0x0000,
0x060C,0x0000, 0x060D,0x0000, 0x060E,0x0000, 0x060F,0x0000,
0x0610,0x0000, 0x0611,0x0000, 0x0612,0x0000, 0x0613,0x0000,
0x0614,0x0000, 0x0615,0x0000, 0x0616,0x0000, 0x0617,0x0000,
0x0618,0x0000, 0x0619,0x0000, 0x061A,0x0000, 0x061B,0x0000,
0x061C,0x0000, 0x061D,0x0000, 0x061E,0x0000, 0x061F,0x0000,
0x0620,0x0000, 0x0621,0x0000, 0x0622,0x0000, 0x0623,0x0000,
0x0624,0x0000, 0x0625,0x0000, 0x0626,0x0000, 0x0627,0x0000,
0x0628,0x0000, 0x0629,0x0000, 0x062A,0x0000, 0x062B,0x0000,
0x062C,0x0000, 0x062D,0x0000, 0x062E,0x0000, 0x062F,0x0000,
0x0630,0x0000, 0x0631,0x0000, 0x0632,0x0000, 0x0633,0x0000,
0x0634,0x0000, 0x0635,0x0000, 0x0636,0x0000, 0x0637,0x0000,
0x0638,0x0000, 0x0639,0x0000, 0x063A,0x0000, 0x063B,0x0000,
0x063C,0x0000, 0x063D,0x0000, 0x063E,0x0000, 0x063F,0x0000,
0x0640,0x0000, 0x0641,0x0000, 0x0642,0x0000, 0x0643,0x0000,
0x0644,0x0000, 0x0645,0x0000, 0x0646,0x0000, 0x0647,0x0000,
0x0648,0x0000, 0x0649,0x0000, 0x064A,0x0000, 0x064B,0x0000,
0x064C,0x0000, 0x064D,0x0000, 0x064E,0x0000, 0x064F,0x0000,
0x0650,0x0000, 0x0651,0x0000, 0x0652,0x0000, 0x0653,0x0000,
0x0654,0x0000, 0x0655,0x0000, 0x0656,0x0000, 0x0657,0x0000,
0x0658,0x0000, 0x0659,0x0000, 0x065A,0x0000, 0x065B,0x0000,
0x065C,0x0000, 0x065D,0x0000, 0x065E,0x0000, 0x065F,0x0000,
0x0660,0x0000, 0x0661,0x0000, 0x0662,0x0000, 0x0663,0x0000,
0x0664,0x0000, 0x0665,0x0000, 0x0666,0x0000, 0x0667,0x0000,
0x0668,0x0000, 0x0669,0x0000, 0x066A,0x0000, 0x066B,0x0000,
0x066C,0x0000, 0x066D,0x0000, 0x066E,0x0000, 0x066F,0x0000,
0x0670,0x0000, 0x0671,0x0000, 0x0672,0x0000, 0x0673,0x0000,
0x0674,0x0000, 0x0675,0x0000, 0x0676,0x0000, 0x0677,0x0000,
0x0678,0x0000, 0x0679,0x0000, 0x067A,0x0000, 0x067B,0x0000,
0x067C,0x0000, 0x067D,0x0000, 0x067E,0x0000, 0x067F,0x0000,
0x0680,0x0000, 0x0681,0x0000, 0x0682,0x0000, 0x0683,0x0000,
0x0684,0x0000, 0x0685,0x0000, 0x0686,0x0000, 0x0687,0x0000,
0x0688,0x0000, 0x0689,0x0000, 0x068A,0x0000, 0x068B,0x0000,
0x068C,0x0000, 0x068D,0x0000, 0x068E,0x0000, 0x068F,0x0000,
0x0690,0x0000, 0x0691,0x0000, 0x0692,0x0000, 0x0693,0x0000,
0x0694,0x0000, 0x0695,0x0000, 0x0696,0x0000, 0x0697,0x0000,
0x0698,0x0000, 0x0699,0x0000, 0x069A,0x0000, 0x069B,0x0000,
0x069C,0x0000, 0x069D,0x0000, 0x069E,0x0000, 0x069F,0x0000,
0x06A0,0x0000, 0x06A1,0x0000, 0x06A2,0x0000, 0x06A3,0x0000,
0x06A4,0x0000, 0x06A5,0x0000, 0x06A6,0x0000, 0x06A7,0x0000,
0x06A8,0x0000, 0x06A9,0x0000, 0x06AA,0x0000, 0x06AB,0x0000,
0x06AC,0x0000, 0x06AD,0x0000, 0x06AE,0x0000, 0x06AF,0x0000,
0x06B0,0x0000, 0x06B1,0x0000, 0x06B2,0x0000, 0x06B3,0x0000,
0x06B4,0x0000, 0x06B5,0x0000, 0x06B6,0x0000, 0x06B7,0x0000,
0x06B8,0x0000, 0x06B9,0x0000, 0x06BA,0x0000, 0x06BB,0x0000,
0x06BC,0x0000, 0x06BD,0x0000, 0x06BE,0x0000, 0x06BF,0x0000,
0x06C0,0x0000, 0x06C1,0x0000, 0x06C2,0x0000, 0x06C3,0x0000,
0x06C4,0x0000, 0x06C5,0x0000, 0x06C6,0x0000, 0x06C7,0x0000,
0x06C8,0x0000, 0x06C9,0x0000, 0x06CA,0x0000, 0x06CB,0x0000,
0x06CC,0x0000, 0x06CD,0x0000, 0x06CE,0x0000, 0x06CF,0x0000,
0x06D0,0x0000, 0x06D1,0x0000, 0x06D2,0x0000, 0x06D3,0x0000,
0x06D4,0x0000, 0x06D5,0x0000, 0x06D6,0x0000, 0x06D7,0x0000,
0x06D8,0x0000, 0x06D9,0x0000, 0x06DA,0x0000, 0x06DB,0x0000,
0x06DC,0x0000, 0x06DD,0x0000, 0x06DE,0x0000, 0x06DF,0x0000,
0x06E0,0x0000, 0x06E1,0x0000, 0x06E2,0x0000, 0x06E3,0x0000,
0x06E4,0x0000, 0x06E5,0x0000, 0x06E6,0x0000, 0x06E7,0x0000,
0x06E8,0x0000, 0x06E9,0x0000, 0x06EA,0x0000, 0x06EB,0x0000,
0x06EC,0x0000, 0x06ED,0x0000, 0x06EE,0x0000, 0x06EF,0x0000,
0x06F0,0x0000, 0x06F1,0x0000, 0x06F2,0x0000, 0x06F3,0x0000,
0x06F4,0x0000, 0x06F5,0x0000, 0x06F6,0x0000, 0x06F7,0x0000,
0x06F8,0x0000, 0x06F9,0x0000, 0x06FA,0x0000, 0x06FB,0x0000
};

uint16 page026data[]= { /* 2600 (3 weights per char) */
0x06FC,0x0000,0x0000, 0x06FD,0x0000,0x0000, 0x06FE,0x0000,0x0000,
0x06FF,0x0000,0x0000, 0x0700,0x0000,0x0000, 0x0701,0x0000,0x0000,
0x0702,0x0000,0x0000, 0x0703,0x0000,0x0000, 0x0704,0x0000,0x0000,
0x0705,0x0000,0x0000, 0x0706,0x0000,0x0000, 0x0707,0x0000,0x0000,
0x0708,0x0000,0x0000, 0x0709,0x0000,0x0000, 0x070A,0x0000,0x0000,
0x070B,0x0000,0x0000, 0x070C,0x0000,0x0000, 0x070D,0x0000,0x0000,
0x070E,0x0000,0x0000, 0x070F,0x0000,0x0000, 0x0710,0x0000,0x0000,
0x0711,0x0000,0x0000, 0x0712,0x0000,0x0000, 0x0713,0x0000,0x0000,
0xFBC0,0xA618,0x0000, 0x0714,0x0000,0x0000, 0x0715,0x0000,0x0000,
0x0716,0x0000,0x0000, 0x0717,0x0000,0x0000, 0x0718,0x0000,0x0000,
0x0719,0x0000,0x0000, 0x071A,0x0000,0x0000, 0x071B,0x0000,0x0000,
0x071C,0x0000,0x0000, 0x071D,0x0000,0x0000, 0x071E,0x0000,0x0000,
0x071F,0x0000,0x0000, 0x0720,0x0000,0x0000, 0x0721,0x0000,0x0000,
0x0722,0x0000,0x0000, 0x0723,0x0000,0x0000, 0x0724,0x0000,0x0000,
0x0725,0x0000,0x0000, 0x0726,0x0000,0x0000, 0x0727,0x0000,0x0000,
0x0728,0x0000,0x0000, 0x0729,0x0000,0x0000, 0x072A,0x0000,0x0000,
0x0B2F,0x0000,0x0000, 0x0B30,0x0000,0x0000, 0x0B31,0x0000,0x0000,
0x0B32,0x0000,0x0000, 0x0B33,0x0000,0x0000, 0x0B34,0x0000,0x0000,
0x0B35,0x0000,0x0000, 0x0B36,0x0000,0x0000, 0x072B,0x0000,0x0000,
0x072C,0x0000,0x0000, 0x072D,0x0000,0x0000, 0x072E,0x0000,0x0000,
0x072F,0x0000,0x0000, 0x0730,0x0000,0x0000, 0x0731,0x0000,0x0000,
0x0732,0x0000,0x0000, 0x0733,0x0000,0x0000, 0x0734,0x0000,0x0000,
0x0735,0x0000,0x0000, 0x0736,0x0000,0x0000, 0x0737,0x0000,0x0000,
0x0738,0x0000,0x0000, 0x0739,0x0000,0x0000, 0x073A,0x0000,0x0000,
0x073B,0x0000,0x0000, 0x073C,0x0000,0x0000, 0x073D,0x0000,0x0000,
0x073E,0x0000,0x0000, 0x073F,0x0000,0x0000, 0x0740,0x0000,0x0000,
0x0741,0x0000,0x0000, 0x0742,0x0000,0x0000, 0x0743,0x0000,0x0000,
0x0744,0x0000,0x0000, 0x0745,0x0000,0x0000, 0x0746,0x0000,0x0000,
0x0747,0x0000,0x0000, 0x0748,0x0000,0x0000, 0x0749,0x0000,0x0000,
0x074A,0x0000,0x0000, 0x074B,0x0000,0x0000, 0x074C,0x0000,0x0000,
0x074D,0x0000,0x0000, 0x074E,0x0000,0x0000, 0x074F,0x0000,0x0000,
0x0750,0x0000,0x0000, 0x0751,0x0000,0x0000, 0x0752,0x0000,0x0000,
0x0753,0x0000,0x0000, 0x0754,0x0000,0x0000, 0x0755,0x0000,0x0000,
0x0756,0x0000,0x0000, 0x0757,0x0000,0x0000, 0x0758,0x0000,0x0000,
0x0759,0x0000,0x0000, 0x075A,0x0000,0x0000, 0x075B,0x0000,0x0000,
0x075C,0x0000,0x0000, 0x075D,0x0000,0x0000, 0x075E,0x0000,0x0000,
0x075F,0x0000,0x0000, 0x0D2B,0x0000,0x0000, 0x0D2C,0x0000,0x0000,
0x0D2D,0x0000,0x0000, 0x0760,0x0000,0x0000, 0x0761,0x0000,0x0000,
0x0762,0x0000,0x0000, 0x0763,0x0000,0x0000, 0x0764,0x0000,0x0000,
0x0765,0x0000,0x0000, 0x0766,0x0000,0x0000, 0x0767,0x0000,0x0000,
0x0768,0x0000,0x0000, 0x0769,0x0000,0x0000, 0x076A,0x0000,0x0000,
0x076B,0x0000,0x0000, 0x076C,0x0000,0x0000, 0x076D,0x0000,0x0000,
0xFBC0,0xA67E,0x0000, 0xFBC0,0xA67F,0x0000, 0x076E,0x0000,0x0000,
0x076F,0x0000,0x0000, 0x0770,0x0000,0x0000, 0x0771,0x0000,0x0000,
0x0772,0x0000,0x0000, 0x0773,0x0000,0x0000, 0x0774,0x0000,0x0000,
0x0775,0x0000,0x0000, 0x0776,0x0000,0x0000, 0x0777,0x0000,0x0000,
0x0B29,0x0000,0x0000, 0x0B2A,0x0000,0x0000, 0x0B2B,0x0000,0x0000,
0x0B2C,0x0000,0x0000, 0x0B2D,0x0000,0x0000, 0x0B2E,0x0000,0x0000,
0x0778,0x0000,0x0000, 0x0779,0x0000,0x0000, 0xFBC0,0xA692,0x0000,
0xFBC0,0xA693,0x0000, 0xFBC0,0xA694,0x0000, 0xFBC0,0xA695,0x0000,
0xFBC0,0xA696,0x0000, 0xFBC0,0xA697,0x0000, 0xFBC0,0xA698,0x0000,
0xFBC0,0xA699,0x0000, 0xFBC0,0xA69A,0x0000, 0xFBC0,0xA69B,0x0000,
0xFBC0,0xA69C,0x0000, 0xFBC0,0xA69D,0x0000, 0xFBC0,0xA69E,0x0000,
0xFBC0,0xA69F,0x0000, 0x077A,0x0000,0x0000, 0x077B,0x0000,0x0000,
0xFBC0,0xA6A2,0x0000, 0xFBC0,0xA6A3,0x0000, 0xFBC0,0xA6A4,0x0000,
0xFBC0,0xA6A5,0x0000, 0xFBC0,0xA6A6,0x0000, 0xFBC0,0xA6A7,0x0000,
0xFBC0,0xA6A8,0x0000, 0xFBC0,0xA6A9,0x0000, 0xFBC0,0xA6AA,0x0000,
0xFBC0,0xA6AB,0x0000, 0xFBC0,0xA6AC,0x0000, 0xFBC0,0xA6AD,0x0000,
0xFBC0,0xA6AE,0x0000, 0xFBC0,0xA6AF,0x0000, 0xFBC0,0xA6B0,0x0000,
0xFBC0,0xA6B1,0x0000, 0xFBC0,0xA6B2,0x0000, 0xFBC0,0xA6B3,0x0000,
0xFBC0,0xA6B4,0x0000, 0xFBC0,0xA6B5,0x0000, 0xFBC0,0xA6B6,0x0000,
0xFBC0,0xA6B7,0x0000, 0xFBC0,0xA6B8,0x0000, 0xFBC0,0xA6B9,0x0000,
0xFBC0,0xA6BA,0x0000, 0xFBC0,0xA6BB,0x0000, 0xFBC0,0xA6BC,0x0000,
0xFBC0,0xA6BD,0x0000, 0xFBC0,0xA6BE,0x0000, 0xFBC0,0xA6BF,0x0000,
0xFBC0,0xA6C0,0x0000, 0xFBC0,0xA6C1,0x0000, 0xFBC0,0xA6C2,0x0000,
0xFBC0,0xA6C3,0x0000, 0xFBC0,0xA6C4,0x0000, 0xFBC0,0xA6C5,0x0000,
0xFBC0,0xA6C6,0x0000, 0xFBC0,0xA6C7,0x0000, 0xFBC0,0xA6C8,0x0000,
0xFBC0,0xA6C9,0x0000, 0xFBC0,0xA6CA,0x0000, 0xFBC0,0xA6CB,0x0000,
0xFBC0,0xA6CC,0x0000, 0xFBC0,0xA6CD,0x0000, 0xFBC0,0xA6CE,0x0000,
0xFBC0,0xA6CF,0x0000, 0xFBC0,0xA6D0,0x0000, 0xFBC0,0xA6D1,0x0000,
0xFBC0,0xA6D2,0x0000, 0xFBC0,0xA6D3,0x0000, 0xFBC0,0xA6D4,0x0000,
0xFBC0,0xA6D5,0x0000, 0xFBC0,0xA6D6,0x0000, 0xFBC0,0xA6D7,0x0000,
0xFBC0,0xA6D8,0x0000, 0xFBC0,0xA6D9,0x0000, 0xFBC0,0xA6DA,0x0000,
0xFBC0,0xA6DB,0x0000, 0xFBC0,0xA6DC,0x0000, 0xFBC0,0xA6DD,0x0000,
0xFBC0,0xA6DE,0x0000, 0xFBC0,0xA6DF,0x0000, 0xFBC0,0xA6E0,0x0000,
0xFBC0,0xA6E1,0x0000, 0xFBC0,0xA6E2,0x0000, 0xFBC0,0xA6E3,0x0000,
0xFBC0,0xA6E4,0x0000, 0xFBC0,0xA6E5,0x0000, 0xFBC0,0xA6E6,0x0000,
0xFBC0,0xA6E7,0x0000, 0xFBC0,0xA6E8,0x0000, 0xFBC0,0xA6E9,0x0000,
0xFBC0,0xA6EA,0x0000, 0xFBC0,0xA6EB,0x0000, 0xFBC0,0xA6EC,0x0000,
0xFBC0,0xA6ED,0x0000, 0xFBC0,0xA6EE,0x0000, 0xFBC0,0xA6EF,0x0000,
0xFBC0,0xA6F0,0x0000, 0xFBC0,0xA6F1,0x0000, 0xFBC0,0xA6F2,0x0000,
0xFBC0,0xA6F3,0x0000, 0xFBC0,0xA6F4,0x0000, 0xFBC0,0xA6F5,0x0000,
0xFBC0,0xA6F6,0x0000, 0xFBC0,0xA6F7,0x0000, 0xFBC0,0xA6F8,0x0000,
0xFBC0,0xA6F9,0x0000, 0xFBC0,0xA6FA,0x0000, 0xFBC0,0xA6FB,0x0000,
0xFBC0,0xA6FC,0x0000, 0xFBC0,0xA6FD,0x0000, 0xFBC0,0xA6FE,0x0000,
0xFBC0,0xA6FF,0x0000 };

uint16 page027data[]= { /* 2700 (3 weights per char) */
0xFBC0,0xA700,0x0000, 0x077C,0x0000,0x0000, 0x077D,0x0000,0x0000,
0x077E,0x0000,0x0000, 0x077F,0x0000,0x0000, 0xFBC0,0xA705,0x0000,
0x0780,0x0000,0x0000, 0x0781,0x0000,0x0000, 0x0782,0x0000,0x0000,
0x0783,0x0000,0x0000, 0xFBC0,0xA70A,0x0000, 0xFBC0,0xA70B,0x0000,
0x0784,0x0000,0x0000, 0x0785,0x0000,0x0000, 0x0786,0x0000,0x0000,
0x0787,0x0000,0x0000, 0x0788,0x0000,0x0000, 0x0789,0x0000,0x0000,
0x078A,0x0000,0x0000, 0x078B,0x0000,0x0000, 0x078C,0x0000,0x0000,
0x078D,0x0000,0x0000, 0x078E,0x0000,0x0000, 0x078F,0x0000,0x0000,
0x0790,0x0000,0x0000, 0x0791,0x0000,0x0000, 0x0792,0x0000,0x0000,
0x0793,0x0000,0x0000, 0x0794,0x0000,0x0000, 0x0795,0x0000,0x0000,
0x0796,0x0000,0x0000, 0x0797,0x0000,0x0000, 0x0798,0x0000,0x0000,
0x0799,0x0000,0x0000, 0x079A,0x0000,0x0000, 0x079B,0x0000,0x0000,
0x079C,0x0000,0x0000, 0x079D,0x0000,0x0000, 0x079E,0x0000,0x0000,
0x079F,0x0000,0x0000, 0xFBC0,0xA728,0x0000, 0x07A0,0x0000,0x0000,
0x07A1,0x0000,0x0000, 0x07A2,0x0000,0x0000, 0x07A3,0x0000,0x0000,
0x07A4,0x0000,0x0000, 0x07A5,0x0000,0x0000, 0x07A6,0x0000,0x0000,
0x07A7,0x0000,0x0000, 0x07A8,0x0000,0x0000, 0x07A9,0x0000,0x0000,
0x07AA,0x0000,0x0000, 0x07AB,0x0000,0x0000, 0x07AC,0x0000,0x0000,
0x07AD,0x0000,0x0000, 0x07AE,0x0000,0x0000, 0x07AF,0x0000,0x0000,
0x07B0,0x0000,0x0000, 0x07B1,0x0000,0x0000, 0x07B2,0x0000,0x0000,
0x07B3,0x0000,0x0000, 0x07B4,0x0000,0x0000, 0x07B5,0x0000,0x0000,
0x07B6,0x0000,0x0000, 0x07B7,0x0000,0x0000, 0x07B8,0x0000,0x0000,
0x07B9,0x0000,0x0000, 0x07BA,0x0000,0x0000, 0x07BB,0x0000,0x0000,
0x07BC,0x0000,0x0000, 0x07BD,0x0000,0x0000, 0x07BE,0x0000,0x0000,
0x07BF,0x0000,0x0000, 0x07C0,0x0000,0x0000, 0x07C1,0x0000,0x0000,
0x07C2,0x0000,0x0000, 0xFBC0,0xA74C,0x0000, 0x07C3,0x0000,0x0000,
0xFBC0,0xA74E,0x0000, 0x07C4,0x0000,0x0000, 0x07C5,0x0000,0x0000,
0x07C6,0x0000,0x0000, 0x07C7,0x0000,0x0000, 0xFBC0,0xA753,0x0000,
0xFBC0,0xA754,0x0000, 0xFBC0,0xA755,0x0000, 0x07C8,0x0000,0x0000,
0xFBC0,0xA757,0x0000, 0x07C9,0x0000,0x0000, 0x07CA,0x0000,0x0000,
0x07CB,0x0000,0x0000, 0x07CC,0x0000,0x0000, 0x07CD,0x0000,0x0000,
0x07CE,0x0000,0x0000, 0x07CF,0x0000,0x0000, 0xFBC0,0xA75F,0x0000,
0xFBC0,0xA760,0x0000, 0x07D0,0x0000,0x0000, 0x07D1,0x0000,0x0000,
0x07D2,0x0000,0x0000, 0x07D3,0x0000,0x0000, 0x07D4,0x0000,0x0000,
0x07D5,0x0000,0x0000, 0x07D6,0x0000,0x0000, 0x07D7,0x0000,0x0000,
0x07D8,0x0000,0x0000, 0x07D9,0x0000,0x0000, 0x07DA,0x0000,0x0000,
0x07DB,0x0000,0x0000, 0x07DC,0x0000,0x0000, 0x07DD,0x0000,0x0000,
0x07DE,0x0000,0x0000, 0x07DF,0x0000,0x0000, 0x07E0,0x0000,0x0000,
0x07E1,0x0000,0x0000, 0x07E2,0x0000,0x0000, 0x07E3,0x0000,0x0000,
0x07E4,0x0000,0x0000, 0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000,
0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000,
0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000,
0x0E32,0x0000,0x0000, 0x0E2A,0x0E29,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x0E2A,0x0E29,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0E2A,0x0E29,0x0000, 0x07E5,0x0000,0x0000, 0xFBC0,0xA795,0x0000,
0xFBC0,0xA796,0x0000, 0xFBC0,0xA797,0x0000, 0x07E6,0x0000,0x0000,
0x07E7,0x0000,0x0000, 0x07E8,0x0000,0x0000, 0x07E9,0x0000,0x0000,
0x07EA,0x0000,0x0000, 0x07EB,0x0000,0x0000, 0x07EC,0x0000,0x0000,
0x07ED,0x0000,0x0000, 0x07EE,0x0000,0x0000, 0x07EF,0x0000,0x0000,
0x07F0,0x0000,0x0000, 0x07F1,0x0000,0x0000, 0x07F2,0x0000,0x0000,
0x07F3,0x0000,0x0000, 0x07F4,0x0000,0x0000, 0x07F5,0x0000,0x0000,
0x07F6,0x0000,0x0000, 0x07F7,0x0000,0x0000, 0x07F8,0x0000,0x0000,
0x07F9,0x0000,0x0000, 0x07FA,0x0000,0x0000, 0x07FB,0x0000,0x0000,
0x07FC,0x0000,0x0000, 0x07FD,0x0000,0x0000, 0xFBC0,0xA7B0,0x0000,
0x07FE,0x0000,0x0000, 0x07FF,0x0000,0x0000, 0x0800,0x0000,0x0000,
0x0801,0x0000,0x0000, 0x0802,0x0000,0x0000, 0x0803,0x0000,0x0000,
0x0804,0x0000,0x0000, 0x0805,0x0000,0x0000, 0x0806,0x0000,0x0000,
0x0807,0x0000,0x0000, 0x0808,0x0000,0x0000, 0x0809,0x0000,0x0000,
0x080A,0x0000,0x0000, 0x080B,0x0000,0x0000, 0xFBC0,0xA7BF,0x0000,
0xFBC0,0xA7C0,0x0000, 0xFBC0,0xA7C1,0x0000, 0xFBC0,0xA7C2,0x0000,
0xFBC0,0xA7C3,0x0000, 0xFBC0,0xA7C4,0x0000, 0xFBC0,0xA7C5,0x0000,
0xFBC0,0xA7C6,0x0000, 0xFBC0,0xA7C7,0x0000, 0xFBC0,0xA7C8,0x0000,
0xFBC0,0xA7C9,0x0000, 0xFBC0,0xA7CA,0x0000, 0xFBC0,0xA7CB,0x0000,
0xFBC0,0xA7CC,0x0000, 0xFBC0,0xA7CD,0x0000, 0xFBC0,0xA7CE,0x0000,
0xFBC0,0xA7CF,0x0000, 0x080C,0x0000,0x0000, 0x080D,0x0000,0x0000,
0x080E,0x0000,0x0000, 0x080F,0x0000,0x0000, 0x0810,0x0000,0x0000,
0x0811,0x0000,0x0000, 0x0812,0x0000,0x0000, 0x0813,0x0000,0x0000,
0x0814,0x0000,0x0000, 0x0815,0x0000,0x0000, 0x0816,0x0000,0x0000,
0x0817,0x0000,0x0000, 0x0818,0x0000,0x0000, 0x0819,0x0000,0x0000,
0x081A,0x0000,0x0000, 0x081B,0x0000,0x0000, 0x081C,0x0000,0x0000,
0x081D,0x0000,0x0000, 0x081E,0x0000,0x0000, 0x081F,0x0000,0x0000,
0x0820,0x0000,0x0000, 0x0821,0x0000,0x0000, 0x0822,0x0000,0x0000,
0x0823,0x0000,0x0000, 0x0824,0x0000,0x0000, 0x0825,0x0000,0x0000,
0x0826,0x0000,0x0000, 0x0827,0x0000,0x0000, 0xFBC0,0xA7EC,0x0000,
0xFBC0,0xA7ED,0x0000, 0xFBC0,0xA7EE,0x0000, 0xFBC0,0xA7EF,0x0000,
0x0828,0x0000,0x0000, 0x0829,0x0000,0x0000, 0x082A,0x0000,0x0000,
0x082B,0x0000,0x0000, 0x082C,0x0000,0x0000, 0x082D,0x0000,0x0000,
0x082E,0x0000,0x0000, 0x082F,0x0000,0x0000, 0x0830,0x0000,0x0000,
0x0831,0x0000,0x0000, 0x0832,0x0000,0x0000, 0x0833,0x0000,0x0000,
0x0834,0x0000,0x0000, 0x0835,0x0000,0x0000, 0x0836,0x0000,0x0000,
0x0837,0x0000,0x0000 };

uint16 page028data[]= { /* 2800 (2 weights per char) */
0x0A29,0x0000, 0x0A2A,0x0000, 0x0A2B,0x0000, 0x0A2C,0x0000,
0x0A2D,0x0000, 0x0A2E,0x0000, 0x0A2F,0x0000, 0x0A30,0x0000,
0x0A31,0x0000, 0x0A32,0x0000, 0x0A33,0x0000, 0x0A34,0x0000,
0x0A35,0x0000, 0x0A36,0x0000, 0x0A37,0x0000, 0x0A38,0x0000,
0x0A39,0x0000, 0x0A3A,0x0000, 0x0A3B,0x0000, 0x0A3C,0x0000,
0x0A3D,0x0000, 0x0A3E,0x0000, 0x0A3F,0x0000, 0x0A40,0x0000,
0x0A41,0x0000, 0x0A42,0x0000, 0x0A43,0x0000, 0x0A44,0x0000,
0x0A45,0x0000, 0x0A46,0x0000, 0x0A47,0x0000, 0x0A48,0x0000,
0x0A49,0x0000, 0x0A4A,0x0000, 0x0A4B,0x0000, 0x0A4C,0x0000,
0x0A4D,0x0000, 0x0A4E,0x0000, 0x0A4F,0x0000, 0x0A50,0x0000,
0x0A51,0x0000, 0x0A52,0x0000, 0x0A53,0x0000, 0x0A54,0x0000,
0x0A55,0x0000, 0x0A56,0x0000, 0x0A57,0x0000, 0x0A58,0x0000,
0x0A59,0x0000, 0x0A5A,0x0000, 0x0A5B,0x0000, 0x0A5C,0x0000,
0x0A5D,0x0000, 0x0A5E,0x0000, 0x0A5F,0x0000, 0x0A60,0x0000,
0x0A61,0x0000, 0x0A62,0x0000, 0x0A63,0x0000, 0x0A64,0x0000,
0x0A65,0x0000, 0x0A66,0x0000, 0x0A67,0x0000, 0x0A68,0x0000,
0x0A69,0x0000, 0x0A6A,0x0000, 0x0A6B,0x0000, 0x0A6C,0x0000,
0x0A6D,0x0000, 0x0A6E,0x0000, 0x0A6F,0x0000, 0x0A70,0x0000,
0x0A71,0x0000, 0x0A72,0x0000, 0x0A73,0x0000, 0x0A74,0x0000,
0x0A75,0x0000, 0x0A76,0x0000, 0x0A77,0x0000, 0x0A78,0x0000,
0x0A79,0x0000, 0x0A7A,0x0000, 0x0A7B,0x0000, 0x0A7C,0x0000,
0x0A7D,0x0000, 0x0A7E,0x0000, 0x0A7F,0x0000, 0x0A80,0x0000,
0x0A81,0x0000, 0x0A82,0x0000, 0x0A83,0x0000, 0x0A84,0x0000,
0x0A85,0x0000, 0x0A86,0x0000, 0x0A87,0x0000, 0x0A88,0x0000,
0x0A89,0x0000, 0x0A8A,0x0000, 0x0A8B,0x0000, 0x0A8C,0x0000,
0x0A8D,0x0000, 0x0A8E,0x0000, 0x0A8F,0x0000, 0x0A90,0x0000,
0x0A91,0x0000, 0x0A92,0x0000, 0x0A93,0x0000, 0x0A94,0x0000,
0x0A95,0x0000, 0x0A96,0x0000, 0x0A97,0x0000, 0x0A98,0x0000,
0x0A99,0x0000, 0x0A9A,0x0000, 0x0A9B,0x0000, 0x0A9C,0x0000,
0x0A9D,0x0000, 0x0A9E,0x0000, 0x0A9F,0x0000, 0x0AA0,0x0000,
0x0AA1,0x0000, 0x0AA2,0x0000, 0x0AA3,0x0000, 0x0AA4,0x0000,
0x0AA5,0x0000, 0x0AA6,0x0000, 0x0AA7,0x0000, 0x0AA8,0x0000,
0x0AA9,0x0000, 0x0AAA,0x0000, 0x0AAB,0x0000, 0x0AAC,0x0000,
0x0AAD,0x0000, 0x0AAE,0x0000, 0x0AAF,0x0000, 0x0AB0,0x0000,
0x0AB1,0x0000, 0x0AB2,0x0000, 0x0AB3,0x0000, 0x0AB4,0x0000,
0x0AB5,0x0000, 0x0AB6,0x0000, 0x0AB7,0x0000, 0x0AB8,0x0000,
0x0AB9,0x0000, 0x0ABA,0x0000, 0x0ABB,0x0000, 0x0ABC,0x0000,
0x0ABD,0x0000, 0x0ABE,0x0000, 0x0ABF,0x0000, 0x0AC0,0x0000,
0x0AC1,0x0000, 0x0AC2,0x0000, 0x0AC3,0x0000, 0x0AC4,0x0000,
0x0AC5,0x0000, 0x0AC6,0x0000, 0x0AC7,0x0000, 0x0AC8,0x0000,
0x0AC9,0x0000, 0x0ACA,0x0000, 0x0ACB,0x0000, 0x0ACC,0x0000,
0x0ACD,0x0000, 0x0ACE,0x0000, 0x0ACF,0x0000, 0x0AD0,0x0000,
0x0AD1,0x0000, 0x0AD2,0x0000, 0x0AD3,0x0000, 0x0AD4,0x0000,
0x0AD5,0x0000, 0x0AD6,0x0000, 0x0AD7,0x0000, 0x0AD8,0x0000,
0x0AD9,0x0000, 0x0ADA,0x0000, 0x0ADB,0x0000, 0x0ADC,0x0000,
0x0ADD,0x0000, 0x0ADE,0x0000, 0x0ADF,0x0000, 0x0AE0,0x0000,
0x0AE1,0x0000, 0x0AE2,0x0000, 0x0AE3,0x0000, 0x0AE4,0x0000,
0x0AE5,0x0000, 0x0AE6,0x0000, 0x0AE7,0x0000, 0x0AE8,0x0000,
0x0AE9,0x0000, 0x0AEA,0x0000, 0x0AEB,0x0000, 0x0AEC,0x0000,
0x0AED,0x0000, 0x0AEE,0x0000, 0x0AEF,0x0000, 0x0AF0,0x0000,
0x0AF1,0x0000, 0x0AF2,0x0000, 0x0AF3,0x0000, 0x0AF4,0x0000,
0x0AF5,0x0000, 0x0AF6,0x0000, 0x0AF7,0x0000, 0x0AF8,0x0000,
0x0AF9,0x0000, 0x0AFA,0x0000, 0x0AFB,0x0000, 0x0AFC,0x0000,
0x0AFD,0x0000, 0x0AFE,0x0000, 0x0AFF,0x0000, 0x0B00,0x0000,
0x0B01,0x0000, 0x0B02,0x0000, 0x0B03,0x0000, 0x0B04,0x0000,
0x0B05,0x0000, 0x0B06,0x0000, 0x0B07,0x0000, 0x0B08,0x0000,
0x0B09,0x0000, 0x0B0A,0x0000, 0x0B0B,0x0000, 0x0B0C,0x0000,
0x0B0D,0x0000, 0x0B0E,0x0000, 0x0B0F,0x0000, 0x0B10,0x0000,
0x0B11,0x0000, 0x0B12,0x0000, 0x0B13,0x0000, 0x0B14,0x0000,
0x0B15,0x0000, 0x0B16,0x0000, 0x0B17,0x0000, 0x0B18,0x0000,
0x0B19,0x0000, 0x0B1A,0x0000, 0x0B1B,0x0000, 0x0B1C,0x0000,
0x0B1D,0x0000, 0x0B1E,0x0000, 0x0B1F,0x0000, 0x0B20,0x0000,
0x0B21,0x0000, 0x0B22,0x0000, 0x0B23,0x0000, 0x0B24,0x0000,
0x0B25,0x0000, 0x0B26,0x0000, 0x0B27,0x0000, 0x0B28,0x0000
};

uint16 page029data[]= { /* 2900 (2 weights per char) */
0x0838,0x0000, 0x0839,0x0000, 0x083A,0x0000, 0x083B,0x0000,
0x083C,0x0000, 0x083D,0x0000, 0x083E,0x0000, 0x083F,0x0000,
0x0840,0x0000, 0x0841,0x0000, 0x0842,0x0000, 0x0843,0x0000,
0x0844,0x0000, 0x0845,0x0000, 0x0846,0x0000, 0x0847,0x0000,
0x0848,0x0000, 0x0849,0x0000, 0x084A,0x0000, 0x084B,0x0000,
0x084C,0x0000, 0x084D,0x0000, 0x084E,0x0000, 0x084F,0x0000,
0x0850,0x0000, 0x0851,0x0000, 0x0852,0x0000, 0x0853,0x0000,
0x0854,0x0000, 0x0855,0x0000, 0x0856,0x0000, 0x0857,0x0000,
0x0858,0x0000, 0x0859,0x0000, 0x085A,0x0000, 0x085B,0x0000,
0x085C,0x0000, 0x085D,0x0000, 0x085E,0x0000, 0x085F,0x0000,
0x0860,0x0000, 0x0861,0x0000, 0x0862,0x0000, 0x0863,0x0000,
0x0864,0x0000, 0x0865,0x0000, 0x0866,0x0000, 0x0867,0x0000,
0x0868,0x0000, 0x0869,0x0000, 0x086A,0x0000, 0x086B,0x0000,
0x086C,0x0000, 0x086D,0x0000, 0x086E,0x0000, 0x086F,0x0000,
0x0870,0x0000, 0x0871,0x0000, 0x0872,0x0000, 0x0873,0x0000,
0x0874,0x0000, 0x0875,0x0000, 0x0876,0x0000, 0x0877,0x0000,
0x0878,0x0000, 0x0879,0x0000, 0x087A,0x0000, 0x087B,0x0000,
0x087C,0x0000, 0x087D,0x0000, 0x087E,0x0000, 0x087F,0x0000,
0x0880,0x0000, 0x0881,0x0000, 0x0882,0x0000, 0x0883,0x0000,
0x0884,0x0000, 0x0885,0x0000, 0x0886,0x0000, 0x0887,0x0000,
0x0888,0x0000, 0x0889,0x0000, 0x088A,0x0000, 0x088B,0x0000,
0x088C,0x0000, 0x088D,0x0000, 0x088E,0x0000, 0x088F,0x0000,
0x0890,0x0000, 0x0891,0x0000, 0x0892,0x0000, 0x0893,0x0000,
0x0894,0x0000, 0x0895,0x0000, 0x0896,0x0000, 0x0897,0x0000,
0x0898,0x0000, 0x0899,0x0000, 0x089A,0x0000, 0x089B,0x0000,
0x089C,0x0000, 0x089D,0x0000, 0x089E,0x0000, 0x089F,0x0000,
0x08A0,0x0000, 0x08A1,0x0000, 0x08A2,0x0000, 0x08A3,0x0000,
0x08A4,0x0000, 0x08A5,0x0000, 0x08A6,0x0000, 0x08A7,0x0000,
0x08A8,0x0000, 0x08A9,0x0000, 0x08AA,0x0000, 0x08AB,0x0000,
0x08AC,0x0000, 0x08AD,0x0000, 0x08AE,0x0000, 0x08AF,0x0000,
0x08B0,0x0000, 0x08B1,0x0000, 0x08B2,0x0000, 0x08B3,0x0000,
0x08B4,0x0000, 0x08B5,0x0000, 0x08B6,0x0000, 0x08B7,0x0000,
0x08B8,0x0000, 0x08B9,0x0000, 0x08BA,0x0000, 0x0298,0x0000,
0x0299,0x0000, 0x029A,0x0000, 0x029B,0x0000, 0x029C,0x0000,
0x029D,0x0000, 0x029E,0x0000, 0x029F,0x0000, 0x02A0,0x0000,
0x02A1,0x0000, 0x02A2,0x0000, 0x02A3,0x0000, 0x02A4,0x0000,
0x02A5,0x0000, 0x02A6,0x0000, 0x02A7,0x0000, 0x02A8,0x0000,
0x02A9,0x0000, 0x02AA,0x0000, 0x02AB,0x0000, 0x02AC,0x0000,
0x02AD,0x0000, 0x08BB,0x0000, 0x08BC,0x0000, 0x08BD,0x0000,
0x08BE,0x0000, 0x08BF,0x0000, 0x08C0,0x0000, 0x08C1,0x0000,
0x08C2,0x0000, 0x08C3,0x0000, 0x08C4,0x0000, 0x08C5,0x0000,
0x08C6,0x0000, 0x08C7,0x0000, 0x08C8,0x0000, 0x08C9,0x0000,
0x08CA,0x0000, 0x08CB,0x0000, 0x08CC,0x0000, 0x08CD,0x0000,
0x08CE,0x0000, 0x08CF,0x0000, 0x08D0,0x0000, 0x08D1,0x0000,
0x08D2,0x0000, 0x08D3,0x0000, 0x08D4,0x0000, 0x08D5,0x0000,
0x08D6,0x0000, 0x08D7,0x0000, 0x08D8,0x0000, 0x08D9,0x0000,
0x08DA,0x0000, 0x08DB,0x0000, 0x08DC,0x0000, 0x08DD,0x0000,
0x08DE,0x0000, 0x08DF,0x0000, 0x08E0,0x0000, 0x08E1,0x0000,
0x08E2,0x0000, 0x08E3,0x0000, 0x08E4,0x0000, 0x08E5,0x0000,
0x08E6,0x0000, 0x08E7,0x0000, 0x08E8,0x0000, 0x08E9,0x0000,
0x08EA,0x0000, 0x08EB,0x0000, 0x08EC,0x0000, 0x08ED,0x0000,
0x08EE,0x0000, 0x08EF,0x0000, 0x08F0,0x0000, 0x08F1,0x0000,
0x08F2,0x0000, 0x08F3,0x0000, 0x08F4,0x0000, 0x08F5,0x0000,
0x08F6,0x0000, 0x08F7,0x0000, 0x08F8,0x0000, 0x08F9,0x0000,
0x08FA,0x0000, 0x08FB,0x0000, 0x08FC,0x0000, 0x08FD,0x0000,
0x08FE,0x0000, 0x08FF,0x0000, 0x0900,0x0000, 0x0901,0x0000,
0x0902,0x0000, 0x0903,0x0000, 0x0904,0x0000, 0x0905,0x0000,
0x0906,0x0000, 0x0907,0x0000, 0x0908,0x0000, 0x0909,0x0000,
0x090A,0x0000, 0x090B,0x0000, 0x090C,0x0000, 0x090D,0x0000,
0x090E,0x0000, 0x090F,0x0000, 0x0910,0x0000, 0x0911,0x0000,
0x0912,0x0000, 0x0913,0x0000, 0x0914,0x0000, 0x0915,0x0000,
0x0916,0x0000, 0x0917,0x0000, 0x0918,0x0000, 0x0919,0x0000,
0x091A,0x0000, 0x091B,0x0000, 0x091C,0x0000, 0x091D,0x0000,
0x0296,0x0000, 0x0297,0x0000, 0x091E,0x0000, 0x091F,0x0000
};

uint16 page02Adata[]= { /* 2A00 (5 weights per char) */
0x0920,0x0000,0x0000,0x0000,0x0000,
0x0921,0x0000,0x0000,0x0000,0x0000,
0x0922,0x0000,0x0000,0x0000,0x0000,
0x0923,0x0000,0x0000,0x0000,0x0000,
0x0924,0x0000,0x0000,0x0000,0x0000,
0x0925,0x0000,0x0000,0x0000,0x0000,
0x0926,0x0000,0x0000,0x0000,0x0000,
0x0927,0x0000,0x0000,0x0000,0x0000,
0x0928,0x0000,0x0000,0x0000,0x0000,
0x0929,0x0000,0x0000,0x0000,0x0000,
0x092A,0x0000,0x0000,0x0000,0x0000,
0x092B,0x0000,0x0000,0x0000,0x0000,
0x044B,0x044B,0x044B,0x044B,0x0000,
0x092C,0x0000,0x0000,0x0000,0x0000,
0x092D,0x0000,0x0000,0x0000,0x0000,
0x092E,0x0000,0x0000,0x0000,0x0000,
0x092F,0x0000,0x0000,0x0000,0x0000,
0x0930,0x0000,0x0000,0x0000,0x0000,
0x0931,0x0000,0x0000,0x0000,0x0000,
0x0932,0x0000,0x0000,0x0000,0x0000,
0x0933,0x0000,0x0000,0x0000,0x0000,
0x0934,0x0000,0x0000,0x0000,0x0000,
0x0935,0x0000,0x0000,0x0000,0x0000,
0x0936,0x0000,0x0000,0x0000,0x0000,
0x0937,0x0000,0x0000,0x0000,0x0000,
0x0938,0x0000,0x0000,0x0000,0x0000,
0x0939,0x0000,0x0000,0x0000,0x0000,
0x093A,0x0000,0x0000,0x0000,0x0000,
0x093B,0x0000,0x0000,0x0000,0x0000,
0x093C,0x0000,0x0000,0x0000,0x0000,
0x093D,0x0000,0x0000,0x0000,0x0000,
0x093E,0x0000,0x0000,0x0000,0x0000,
0x093F,0x0000,0x0000,0x0000,0x0000,
0x0940,0x0000,0x0000,0x0000,0x0000,
0x0941,0x0000,0x0000,0x0000,0x0000,
0x0942,0x0000,0x0000,0x0000,0x0000,
0x0943,0x0000,0x0000,0x0000,0x0000,
0x0944,0x0000,0x0000,0x0000,0x0000,
0x0945,0x0000,0x0000,0x0000,0x0000,
0x0946,0x0000,0x0000,0x0000,0x0000,
0x0947,0x0000,0x0000,0x0000,0x0000,
0x0948,0x0000,0x0000,0x0000,0x0000,
0x0949,0x0000,0x0000,0x0000,0x0000,
0x094A,0x0000,0x0000,0x0000,0x0000,
0x094B,0x0000,0x0000,0x0000,0x0000,
0x094C,0x0000,0x0000,0x0000,0x0000,
0x094D,0x0000,0x0000,0x0000,0x0000,
0x094E,0x0000,0x0000,0x0000,0x0000,
0x094F,0x0000,0x0000,0x0000,0x0000,
0x0950,0x0000,0x0000,0x0000,0x0000,
0x0951,0x0000,0x0000,0x0000,0x0000,
0x0952,0x0000,0x0000,0x0000,0x0000,
0x0953,0x0000,0x0000,0x0000,0x0000,
0x0954,0x0000,0x0000,0x0000,0x0000,
0x0955,0x0000,0x0000,0x0000,0x0000,
0x0956,0x0000,0x0000,0x0000,0x0000,
0x0957,0x0000,0x0000,0x0000,0x0000,
0x0958,0x0000,0x0000,0x0000,0x0000,
0x0959,0x0000,0x0000,0x0000,0x0000,
0x095A,0x0000,0x0000,0x0000,0x0000,
0x095B,0x0000,0x0000,0x0000,0x0000,
0x095C,0x0000,0x0000,0x0000,0x0000,
0x095D,0x0000,0x0000,0x0000,0x0000,
0x095E,0x0000,0x0000,0x0000,0x0000,
0x095F,0x0000,0x0000,0x0000,0x0000,
0x0960,0x0000,0x0000,0x0000,0x0000,
0x0961,0x0000,0x0000,0x0000,0x0000,
0x0962,0x0000,0x0000,0x0000,0x0000,
0x0963,0x0000,0x0000,0x0000,0x0000,
0x0964,0x0000,0x0000,0x0000,0x0000,
0x0965,0x0000,0x0000,0x0000,0x0000,
0x0966,0x0000,0x0000,0x0000,0x0000,
0x0967,0x0000,0x0000,0x0000,0x0000,
0x0968,0x0000,0x0000,0x0000,0x0000,
0x0969,0x0000,0x0000,0x0000,0x0000,
0x096A,0x0000,0x0000,0x0000,0x0000,
0x096B,0x0000,0x0000,0x0000,0x0000,
0x096C,0x0000,0x0000,0x0000,0x0000,
0x096D,0x0000,0x0000,0x0000,0x0000,
0x096E,0x0000,0x0000,0x0000,0x0000,
0x096F,0x0000,0x0000,0x0000,0x0000,
0x0970,0x0000,0x0000,0x0000,0x0000,
0x0971,0x0000,0x0000,0x0000,0x0000,
0x0972,0x0000,0x0000,0x0000,0x0000,
0x0973,0x0000,0x0000,0x0000,0x0000,
0x0974,0x0000,0x0000,0x0000,0x0000,
0x0975,0x0000,0x0000,0x0000,0x0000,
0x0976,0x0000,0x0000,0x0000,0x0000,
0x0977,0x0000,0x0000,0x0000,0x0000,
0x0978,0x0000,0x0000,0x0000,0x0000,
0x0979,0x0000,0x0000,0x0000,0x0000,
0x097A,0x0000,0x0000,0x0000,0x0000,
0x097B,0x0000,0x0000,0x0000,0x0000,
0x097C,0x0000,0x0000,0x0000,0x0000,
0x097D,0x0000,0x0000,0x0000,0x0000,
0x097E,0x0000,0x0000,0x0000,0x0000,
0x097F,0x0000,0x0000,0x0000,0x0000,
0x0980,0x0000,0x0000,0x0000,0x0000,
0x0981,0x0000,0x0000,0x0000,0x0000,
0x0982,0x0000,0x0000,0x0000,0x0000,
0x0983,0x0000,0x0000,0x0000,0x0000,
0x0984,0x0000,0x0000,0x0000,0x0000,
0x0985,0x0000,0x0000,0x0000,0x0000,
0x0986,0x0000,0x0000,0x0000,0x0000,
0x0987,0x0000,0x0000,0x0000,0x0000,
0x0988,0x0000,0x0000,0x0000,0x0000,
0x0989,0x0000,0x0000,0x0000,0x0000,
0x098A,0x0000,0x0000,0x0000,0x0000,
0x098B,0x0000,0x0000,0x0000,0x0000,
0x098C,0x0000,0x0000,0x0000,0x0000,
0x098D,0x0000,0x0000,0x0000,0x0000,
0x098E,0x0000,0x0000,0x0000,0x0000,
0x098F,0x0000,0x0000,0x0000,0x0000,
0x0990,0x0000,0x0000,0x0000,0x0000,
0x0991,0x0000,0x0000,0x0000,0x0000,
0x0992,0x0000,0x0000,0x0000,0x0000,
0x023D,0x023D,0x042D,0x0000,0x0000,
0x042D,0x042D,0x0000,0x0000,0x0000,
0x042D,0x042D,0x042D,0x0000,0x0000,
0x0993,0x0000,0x0000,0x0000,0x0000,
0x0994,0x0000,0x0000,0x0000,0x0000,
0x0995,0x0000,0x0000,0x0000,0x0000,
0x0996,0x0000,0x0000,0x0000,0x0000,
0x0997,0x0000,0x0000,0x0000,0x0000,
0x0998,0x0000,0x0000,0x0000,0x0000,
0x0999,0x0000,0x0000,0x0000,0x0000,
0x099A,0x0000,0x0000,0x0000,0x0000,
0x099B,0x0000,0x0000,0x0000,0x0000,
0x099C,0x0000,0x0000,0x0000,0x0000,
0x099D,0x0000,0x0000,0x0000,0x0000,
0x099E,0x0000,0x0000,0x0000,0x0000,
0x099F,0x0000,0x0000,0x0000,0x0000,
0x09A0,0x0000,0x0000,0x0000,0x0000,
0x09A1,0x0000,0x0000,0x0000,0x0000,
0x09A2,0x0000,0x0000,0x0000,0x0000,
0x09A3,0x0000,0x0000,0x0000,0x0000,
0x09A4,0x0000,0x0000,0x0000,0x0000,
0x09A5,0x0000,0x0000,0x0000,0x0000,
0x09A6,0x0000,0x0000,0x0000,0x0000,
0x09A7,0x0000,0x0000,0x0000,0x0000,
0x09A8,0x0000,0x0000,0x0000,0x0000,
0x09A9,0x0000,0x0000,0x0000,0x0000,
0x09AA,0x0000,0x0000,0x0000,0x0000,
0x09AB,0x0000,0x0000,0x0000,0x0000,
0x09AC,0x0000,0x0000,0x0000,0x0000,
0x09AD,0x0000,0x0000,0x0000,0x0000,
0x09AE,0x0000,0x0000,0x0000,0x0000,
0x09AF,0x0000,0x0000,0x0000,0x0000,
0x09B0,0x0000,0x0000,0x0000,0x0000,
0x09B1,0x0000,0x0000,0x0000,0x0000,
0x09B2,0x0000,0x0000,0x0000,0x0000,
0x09B3,0x0000,0x0000,0x0000,0x0000,
0x09B4,0x0000,0x0000,0x0000,0x0000,
0x09B5,0x0000,0x0000,0x0000,0x0000,
0x09B6,0x0000,0x0000,0x0000,0x0000,
0x09B7,0x0000,0x0000,0x0000,0x0000,
0x09B8,0x0000,0x0000,0x0000,0x0000,
0x09B9,0x0000,0x0000,0x0000,0x0000,
0x09BA,0x0000,0x0000,0x0000,0x0000,
0x09BB,0x0000,0x0000,0x0000,0x0000,
0x09BC,0x0000,0x0000,0x0000,0x0000,
0x09BD,0x0000,0x0000,0x0000,0x0000,
0x09BE,0x0000,0x0000,0x0000,0x0000,
0x09BF,0x0000,0x0000,0x0000,0x0000,
0x09C0,0x0000,0x0000,0x0000,0x0000,
0x09C1,0x0000,0x0000,0x0000,0x0000,
0x09C2,0x0000,0x0000,0x0000,0x0000,
0x09C3,0x0000,0x0000,0x0000,0x0000,
0x09C4,0x0000,0x0000,0x0000,0x0000,
0x09C5,0x0000,0x0000,0x0000,0x0000,
0x09C6,0x0000,0x0000,0x0000,0x0000,
0x09C7,0x0000,0x0000,0x0000,0x0000,
0x09C8,0x0000,0x0000,0x0000,0x0000,
0x09C9,0x0000,0x0000,0x0000,0x0000,
0x09CA,0x0000,0x0000,0x0000,0x0000,
0x09CB,0x0000,0x0000,0x0000,0x0000,
0x09CC,0x0000,0x0000,0x0000,0x0000,
0x09CD,0x0000,0x0000,0x0000,0x0000,
0x09CE,0x0000,0x0000,0x0000,0x0000,
0x09CF,0x0000,0x0000,0x0000,0x0000,
0x09D0,0x0000,0x0000,0x0000,0x0000,
0x09D1,0x0000,0x0000,0x0000,0x0000,
0x09D2,0x0000,0x0000,0x0000,0x0000,
0x09D3,0x0000,0x0000,0x0000,0x0000,
0x09D4,0x0000,0x0000,0x0000,0x0000,
0x09D5,0x0000,0x0000,0x0000,0x0000,
0x09D6,0x0000,0x0000,0x0000,0x0000,
0x09D7,0x0000,0x0000,0x0000,0x0000,
0x09D8,0x0000,0x0000,0x0000,0x0000,
0x09D9,0x0000,0x0000,0x0000,0x0000,
0x09DA,0x0000,0x0000,0x0000,0x0000,
0x09DB,0x0000,0x0000,0x0000,0x0000,
0x09DC,0x0000,0x0000,0x0000,0x0000,
0x09DD,0x0000,0x0000,0x0000,0x0000,
0x09DE,0x0000,0x0000,0x0000,0x0000,
0x09DF,0x0000,0x0000,0x0000,0x0000,
0x09E0,0x0000,0x0000,0x0000,0x0000,
0x09E1,0x0000,0x0000,0x0000,0x0000,
0x09E2,0x0000,0x0000,0x0000,0x0000,
0x09E3,0x0000,0x0000,0x0000,0x0000,
0x09E4,0x0000,0x0000,0x0000,0x0000,
0x09E5,0x0000,0x0000,0x0000,0x0000,
0x09E6,0x0000,0x0000,0x0000,0x0000,
0x09E7,0x0000,0x0000,0x0000,0x0000,
0x09E8,0x0000,0x0000,0x0000,0x0000,
0x09E9,0x0000,0x0000,0x0000,0x0000,
0x09EA,0x0000,0x0000,0x0000,0x0000,
0x09EB,0x0000,0x0000,0x0000,0x0000,
0x09EC,0x0000,0x0000,0x0000,0x0000,
0x09ED,0x0000,0x0000,0x0000,0x0000,
0x09EE,0x0000,0x0000,0x0000,0x0000,
0x09EF,0x0000,0x0000,0x0000,0x0000,
0x09F0,0x0000,0x0000,0x0000,0x0000,
0x09F1,0x0000,0x0000,0x0000,0x0000,
0x09F2,0x0000,0x0000,0x0000,0x0000,
0x09F3,0x0000,0x0000,0x0000,0x0000,
0x09F4,0x0000,0x0000,0x0000,0x0000,
0x09F5,0x0000,0x0000,0x0000,0x0000,
0x09F6,0x0000,0x0000,0x0000,0x0000,
0x09F7,0x0000,0x0000,0x0000,0x0000,
0x09F8,0x0000,0x0000,0x0000,0x0000,
0x09F8,0x0000,0x0000,0x0000,0x0000,
0x09F9,0x0000,0x0000,0x0000,0x0000,
0x09FA,0x0000,0x0000,0x0000,0x0000,
0x09FB,0x0000,0x0000,0x0000,0x0000,
0x09FC,0x0000,0x0000,0x0000,0x0000,
0x09FD,0x0000,0x0000,0x0000,0x0000,
0x09FE,0x0000,0x0000,0x0000,0x0000,
0x09FF,0x0000,0x0000,0x0000,0x0000,
0x0A00,0x0000,0x0000,0x0000,0x0000,
0x0A01,0x0000,0x0000,0x0000,0x0000,
0x0A02,0x0000,0x0000,0x0000,0x0000,
0x0A03,0x0000,0x0000,0x0000,0x0000,
0x0A04,0x0000,0x0000,0x0000,0x0000,
0x0A05,0x0000,0x0000,0x0000,0x0000,
0x0A06,0x0000,0x0000,0x0000,0x0000,
0x0A07,0x0000,0x0000,0x0000,0x0000,
0x0A08,0x0000,0x0000,0x0000,0x0000,
0x0A09,0x0000,0x0000,0x0000,0x0000,
0x0A0A,0x0000,0x0000,0x0000,0x0000,
0x0A0B,0x0000,0x0000,0x0000,0x0000,
0x0A0C,0x0000,0x0000,0x0000,0x0000,
0x0A0D,0x0000,0x0000,0x0000,0x0000,
0x0A0E,0x0000,0x0000,0x0000,0x0000,
0x0A0F,0x0000,0x0000,0x0000,0x0000,
0x0A10,0x0000,0x0000,0x0000,0x0000,
0x0A11,0x0000,0x0000,0x0000,0x0000,
0x0A12,0x0000,0x0000,0x0000,0x0000,
0x0A13,0x0000,0x0000,0x0000,0x0000,
0x0A14,0x0000,0x0000,0x0000,0x0000,
0x0A15,0x0000,0x0000,0x0000,0x0000,
0x0A16,0x0000,0x0000,0x0000,0x0000,
0x0A17,0x0000,0x0000,0x0000,0x0000,
0x0A18,0x0000,0x0000,0x0000,0x0000,
0x0A19,0x0000,0x0000,0x0000,0x0000,
0x0A1A,0x0000,0x0000,0x0000,0x0000
};

uint16 page02Bdata[]= { /* 2B00 (3 weights per char) */
0x0A1B,0x0000,0x0000, 0x0A1C,0x0000,0x0000, 0x0A1D,0x0000,0x0000,
0x0A1E,0x0000,0x0000, 0x0A1F,0x0000,0x0000, 0x0A20,0x0000,0x0000,
0x0A21,0x0000,0x0000, 0x0A22,0x0000,0x0000, 0x0A23,0x0000,0x0000,
0x0A24,0x0000,0x0000, 0x0A25,0x0000,0x0000, 0x0A26,0x0000,0x0000,
0x0A27,0x0000,0x0000, 0x0A28,0x0000,0x0000, 0xFBC0,0xAB0E,0x0000,
0xFBC0,0xAB0F,0x0000, 0xFBC0,0xAB10,0x0000, 0xFBC0,0xAB11,0x0000,
0xFBC0,0xAB12,0x0000, 0xFBC0,0xAB13,0x0000, 0xFBC0,0xAB14,0x0000,
0xFBC0,0xAB15,0x0000, 0xFBC0,0xAB16,0x0000, 0xFBC0,0xAB17,0x0000,
0xFBC0,0xAB18,0x0000, 0xFBC0,0xAB19,0x0000, 0xFBC0,0xAB1A,0x0000,
0xFBC0,0xAB1B,0x0000, 0xFBC0,0xAB1C,0x0000, 0xFBC0,0xAB1D,0x0000,
0xFBC0,0xAB1E,0x0000, 0xFBC0,0xAB1F,0x0000, 0xFBC0,0xAB20,0x0000,
0xFBC0,0xAB21,0x0000, 0xFBC0,0xAB22,0x0000, 0xFBC0,0xAB23,0x0000,
0xFBC0,0xAB24,0x0000, 0xFBC0,0xAB25,0x0000, 0xFBC0,0xAB26,0x0000,
0xFBC0,0xAB27,0x0000, 0xFBC0,0xAB28,0x0000, 0xFBC0,0xAB29,0x0000,
0xFBC0,0xAB2A,0x0000, 0xFBC0,0xAB2B,0x0000, 0xFBC0,0xAB2C,0x0000,
0xFBC0,0xAB2D,0x0000, 0xFBC0,0xAB2E,0x0000, 0xFBC0,0xAB2F,0x0000,
0xFBC0,0xAB30,0x0000, 0xFBC0,0xAB31,0x0000, 0xFBC0,0xAB32,0x0000,
0xFBC0,0xAB33,0x0000, 0xFBC0,0xAB34,0x0000, 0xFBC0,0xAB35,0x0000,
0xFBC0,0xAB36,0x0000, 0xFBC0,0xAB37,0x0000, 0xFBC0,0xAB38,0x0000,
0xFBC0,0xAB39,0x0000, 0xFBC0,0xAB3A,0x0000, 0xFBC0,0xAB3B,0x0000,
0xFBC0,0xAB3C,0x0000, 0xFBC0,0xAB3D,0x0000, 0xFBC0,0xAB3E,0x0000,
0xFBC0,0xAB3F,0x0000, 0xFBC0,0xAB40,0x0000, 0xFBC0,0xAB41,0x0000,
0xFBC0,0xAB42,0x0000, 0xFBC0,0xAB43,0x0000, 0xFBC0,0xAB44,0x0000,
0xFBC0,0xAB45,0x0000, 0xFBC0,0xAB46,0x0000, 0xFBC0,0xAB47,0x0000,
0xFBC0,0xAB48,0x0000, 0xFBC0,0xAB49,0x0000, 0xFBC0,0xAB4A,0x0000,
0xFBC0,0xAB4B,0x0000, 0xFBC0,0xAB4C,0x0000, 0xFBC0,0xAB4D,0x0000,
0xFBC0,0xAB4E,0x0000, 0xFBC0,0xAB4F,0x0000, 0xFBC0,0xAB50,0x0000,
0xFBC0,0xAB51,0x0000, 0xFBC0,0xAB52,0x0000, 0xFBC0,0xAB53,0x0000,
0xFBC0,0xAB54,0x0000, 0xFBC0,0xAB55,0x0000, 0xFBC0,0xAB56,0x0000,
0xFBC0,0xAB57,0x0000, 0xFBC0,0xAB58,0x0000, 0xFBC0,0xAB59,0x0000,
0xFBC0,0xAB5A,0x0000, 0xFBC0,0xAB5B,0x0000, 0xFBC0,0xAB5C,0x0000,
0xFBC0,0xAB5D,0x0000, 0xFBC0,0xAB5E,0x0000, 0xFBC0,0xAB5F,0x0000,
0xFBC0,0xAB60,0x0000, 0xFBC0,0xAB61,0x0000, 0xFBC0,0xAB62,0x0000,
0xFBC0,0xAB63,0x0000, 0xFBC0,0xAB64,0x0000, 0xFBC0,0xAB65,0x0000,
0xFBC0,0xAB66,0x0000, 0xFBC0,0xAB67,0x0000, 0xFBC0,0xAB68,0x0000,
0xFBC0,0xAB69,0x0000, 0xFBC0,0xAB6A,0x0000, 0xFBC0,0xAB6B,0x0000,
0xFBC0,0xAB6C,0x0000, 0xFBC0,0xAB6D,0x0000, 0xFBC0,0xAB6E,0x0000,
0xFBC0,0xAB6F,0x0000, 0xFBC0,0xAB70,0x0000, 0xFBC0,0xAB71,0x0000,
0xFBC0,0xAB72,0x0000, 0xFBC0,0xAB73,0x0000, 0xFBC0,0xAB74,0x0000,
0xFBC0,0xAB75,0x0000, 0xFBC0,0xAB76,0x0000, 0xFBC0,0xAB77,0x0000,
0xFBC0,0xAB78,0x0000, 0xFBC0,0xAB79,0x0000, 0xFBC0,0xAB7A,0x0000,
0xFBC0,0xAB7B,0x0000, 0xFBC0,0xAB7C,0x0000, 0xFBC0,0xAB7D,0x0000,
0xFBC0,0xAB7E,0x0000, 0xFBC0,0xAB7F,0x0000, 0xFBC0,0xAB80,0x0000,
0xFBC0,0xAB81,0x0000, 0xFBC0,0xAB82,0x0000, 0xFBC0,0xAB83,0x0000,
0xFBC0,0xAB84,0x0000, 0xFBC0,0xAB85,0x0000, 0xFBC0,0xAB86,0x0000,
0xFBC0,0xAB87,0x0000, 0xFBC0,0xAB88,0x0000, 0xFBC0,0xAB89,0x0000,
0xFBC0,0xAB8A,0x0000, 0xFBC0,0xAB8B,0x0000, 0xFBC0,0xAB8C,0x0000,
0xFBC0,0xAB8D,0x0000, 0xFBC0,0xAB8E,0x0000, 0xFBC0,0xAB8F,0x0000,
0xFBC0,0xAB90,0x0000, 0xFBC0,0xAB91,0x0000, 0xFBC0,0xAB92,0x0000,
0xFBC0,0xAB93,0x0000, 0xFBC0,0xAB94,0x0000, 0xFBC0,0xAB95,0x0000,
0xFBC0,0xAB96,0x0000, 0xFBC0,0xAB97,0x0000, 0xFBC0,0xAB98,0x0000,
0xFBC0,0xAB99,0x0000, 0xFBC0,0xAB9A,0x0000, 0xFBC0,0xAB9B,0x0000,
0xFBC0,0xAB9C,0x0000, 0xFBC0,0xAB9D,0x0000, 0xFBC0,0xAB9E,0x0000,
0xFBC0,0xAB9F,0x0000, 0xFBC0,0xABA0,0x0000, 0xFBC0,0xABA1,0x0000,
0xFBC0,0xABA2,0x0000, 0xFBC0,0xABA3,0x0000, 0xFBC0,0xABA4,0x0000,
0xFBC0,0xABA5,0x0000, 0xFBC0,0xABA6,0x0000, 0xFBC0,0xABA7,0x0000,
0xFBC0,0xABA8,0x0000, 0xFBC0,0xABA9,0x0000, 0xFBC0,0xABAA,0x0000,
0xFBC0,0xABAB,0x0000, 0xFBC0,0xABAC,0x0000, 0xFBC0,0xABAD,0x0000,
0xFBC0,0xABAE,0x0000, 0xFBC0,0xABAF,0x0000, 0xFBC0,0xABB0,0x0000,
0xFBC0,0xABB1,0x0000, 0xFBC0,0xABB2,0x0000, 0xFBC0,0xABB3,0x0000,
0xFBC0,0xABB4,0x0000, 0xFBC0,0xABB5,0x0000, 0xFBC0,0xABB6,0x0000,
0xFBC0,0xABB7,0x0000, 0xFBC0,0xABB8,0x0000, 0xFBC0,0xABB9,0x0000,
0xFBC0,0xABBA,0x0000, 0xFBC0,0xABBB,0x0000, 0xFBC0,0xABBC,0x0000,
0xFBC0,0xABBD,0x0000, 0xFBC0,0xABBE,0x0000, 0xFBC0,0xABBF,0x0000,
0xFBC0,0xABC0,0x0000, 0xFBC0,0xABC1,0x0000, 0xFBC0,0xABC2,0x0000,
0xFBC0,0xABC3,0x0000, 0xFBC0,0xABC4,0x0000, 0xFBC0,0xABC5,0x0000,
0xFBC0,0xABC6,0x0000, 0xFBC0,0xABC7,0x0000, 0xFBC0,0xABC8,0x0000,
0xFBC0,0xABC9,0x0000, 0xFBC0,0xABCA,0x0000, 0xFBC0,0xABCB,0x0000,
0xFBC0,0xABCC,0x0000, 0xFBC0,0xABCD,0x0000, 0xFBC0,0xABCE,0x0000,
0xFBC0,0xABCF,0x0000, 0xFBC0,0xABD0,0x0000, 0xFBC0,0xABD1,0x0000,
0xFBC0,0xABD2,0x0000, 0xFBC0,0xABD3,0x0000, 0xFBC0,0xABD4,0x0000,
0xFBC0,0xABD5,0x0000, 0xFBC0,0xABD6,0x0000, 0xFBC0,0xABD7,0x0000,
0xFBC0,0xABD8,0x0000, 0xFBC0,0xABD9,0x0000, 0xFBC0,0xABDA,0x0000,
0xFBC0,0xABDB,0x0000, 0xFBC0,0xABDC,0x0000, 0xFBC0,0xABDD,0x0000,
0xFBC0,0xABDE,0x0000, 0xFBC0,0xABDF,0x0000, 0xFBC0,0xABE0,0x0000,
0xFBC0,0xABE1,0x0000, 0xFBC0,0xABE2,0x0000, 0xFBC0,0xABE3,0x0000,
0xFBC0,0xABE4,0x0000, 0xFBC0,0xABE5,0x0000, 0xFBC0,0xABE6,0x0000,
0xFBC0,0xABE7,0x0000, 0xFBC0,0xABE8,0x0000, 0xFBC0,0xABE9,0x0000,
0xFBC0,0xABEA,0x0000, 0xFBC0,0xABEB,0x0000, 0xFBC0,0xABEC,0x0000,
0xFBC0,0xABED,0x0000, 0xFBC0,0xABEE,0x0000, 0xFBC0,0xABEF,0x0000,
0xFBC0,0xABF0,0x0000, 0xFBC0,0xABF1,0x0000, 0xFBC0,0xABF2,0x0000,
0xFBC0,0xABF3,0x0000, 0xFBC0,0xABF4,0x0000, 0xFBC0,0xABF5,0x0000,
0xFBC0,0xABF6,0x0000, 0xFBC0,0xABF7,0x0000, 0xFBC0,0xABF8,0x0000,
0xFBC0,0xABF9,0x0000, 0xFBC0,0xABFA,0x0000, 0xFBC0,0xABFB,0x0000,
0xFBC0,0xABFC,0x0000, 0xFBC0,0xABFD,0x0000, 0xFBC0,0xABFE,0x0000,
0xFBC0,0xABFF,0x0000 };

uint16 page02Edata[]= { /* 2E00 (3 weights per char) */
0xFBC0,0xAE00,0x0000, 0xFBC0,0xAE01,0x0000, 0xFBC0,0xAE02,0x0000,
0xFBC0,0xAE03,0x0000, 0xFBC0,0xAE04,0x0000, 0xFBC0,0xAE05,0x0000,
0xFBC0,0xAE06,0x0000, 0xFBC0,0xAE07,0x0000, 0xFBC0,0xAE08,0x0000,
0xFBC0,0xAE09,0x0000, 0xFBC0,0xAE0A,0x0000, 0xFBC0,0xAE0B,0x0000,
0xFBC0,0xAE0C,0x0000, 0xFBC0,0xAE0D,0x0000, 0xFBC0,0xAE0E,0x0000,
0xFBC0,0xAE0F,0x0000, 0xFBC0,0xAE10,0x0000, 0xFBC0,0xAE11,0x0000,
0xFBC0,0xAE12,0x0000, 0xFBC0,0xAE13,0x0000, 0xFBC0,0xAE14,0x0000,
0xFBC0,0xAE15,0x0000, 0xFBC0,0xAE16,0x0000, 0xFBC0,0xAE17,0x0000,
0xFBC0,0xAE18,0x0000, 0xFBC0,0xAE19,0x0000, 0xFBC0,0xAE1A,0x0000,
0xFBC0,0xAE1B,0x0000, 0xFBC0,0xAE1C,0x0000, 0xFBC0,0xAE1D,0x0000,
0xFBC0,0xAE1E,0x0000, 0xFBC0,0xAE1F,0x0000, 0xFBC0,0xAE20,0x0000,
0xFBC0,0xAE21,0x0000, 0xFBC0,0xAE22,0x0000, 0xFBC0,0xAE23,0x0000,
0xFBC0,0xAE24,0x0000, 0xFBC0,0xAE25,0x0000, 0xFBC0,0xAE26,0x0000,
0xFBC0,0xAE27,0x0000, 0xFBC0,0xAE28,0x0000, 0xFBC0,0xAE29,0x0000,
0xFBC0,0xAE2A,0x0000, 0xFBC0,0xAE2B,0x0000, 0xFBC0,0xAE2C,0x0000,
0xFBC0,0xAE2D,0x0000, 0xFBC0,0xAE2E,0x0000, 0xFBC0,0xAE2F,0x0000,
0xFBC0,0xAE30,0x0000, 0xFBC0,0xAE31,0x0000, 0xFBC0,0xAE32,0x0000,
0xFBC0,0xAE33,0x0000, 0xFBC0,0xAE34,0x0000, 0xFBC0,0xAE35,0x0000,
0xFBC0,0xAE36,0x0000, 0xFBC0,0xAE37,0x0000, 0xFBC0,0xAE38,0x0000,
0xFBC0,0xAE39,0x0000, 0xFBC0,0xAE3A,0x0000, 0xFBC0,0xAE3B,0x0000,
0xFBC0,0xAE3C,0x0000, 0xFBC0,0xAE3D,0x0000, 0xFBC0,0xAE3E,0x0000,
0xFBC0,0xAE3F,0x0000, 0xFBC0,0xAE40,0x0000, 0xFBC0,0xAE41,0x0000,
0xFBC0,0xAE42,0x0000, 0xFBC0,0xAE43,0x0000, 0xFBC0,0xAE44,0x0000,
0xFBC0,0xAE45,0x0000, 0xFBC0,0xAE46,0x0000, 0xFBC0,0xAE47,0x0000,
0xFBC0,0xAE48,0x0000, 0xFBC0,0xAE49,0x0000, 0xFBC0,0xAE4A,0x0000,
0xFBC0,0xAE4B,0x0000, 0xFBC0,0xAE4C,0x0000, 0xFBC0,0xAE4D,0x0000,
0xFBC0,0xAE4E,0x0000, 0xFBC0,0xAE4F,0x0000, 0xFBC0,0xAE50,0x0000,
0xFBC0,0xAE51,0x0000, 0xFBC0,0xAE52,0x0000, 0xFBC0,0xAE53,0x0000,
0xFBC0,0xAE54,0x0000, 0xFBC0,0xAE55,0x0000, 0xFBC0,0xAE56,0x0000,
0xFBC0,0xAE57,0x0000, 0xFBC0,0xAE58,0x0000, 0xFBC0,0xAE59,0x0000,
0xFBC0,0xAE5A,0x0000, 0xFBC0,0xAE5B,0x0000, 0xFBC0,0xAE5C,0x0000,
0xFBC0,0xAE5D,0x0000, 0xFBC0,0xAE5E,0x0000, 0xFBC0,0xAE5F,0x0000,
0xFBC0,0xAE60,0x0000, 0xFBC0,0xAE61,0x0000, 0xFBC0,0xAE62,0x0000,
0xFBC0,0xAE63,0x0000, 0xFBC0,0xAE64,0x0000, 0xFBC0,0xAE65,0x0000,
0xFBC0,0xAE66,0x0000, 0xFBC0,0xAE67,0x0000, 0xFBC0,0xAE68,0x0000,
0xFBC0,0xAE69,0x0000, 0xFBC0,0xAE6A,0x0000, 0xFBC0,0xAE6B,0x0000,
0xFBC0,0xAE6C,0x0000, 0xFBC0,0xAE6D,0x0000, 0xFBC0,0xAE6E,0x0000,
0xFBC0,0xAE6F,0x0000, 0xFBC0,0xAE70,0x0000, 0xFBC0,0xAE71,0x0000,
0xFBC0,0xAE72,0x0000, 0xFBC0,0xAE73,0x0000, 0xFBC0,0xAE74,0x0000,
0xFBC0,0xAE75,0x0000, 0xFBC0,0xAE76,0x0000, 0xFBC0,0xAE77,0x0000,
0xFBC0,0xAE78,0x0000, 0xFBC0,0xAE79,0x0000, 0xFBC0,0xAE7A,0x0000,
0xFBC0,0xAE7B,0x0000, 0xFBC0,0xAE7C,0x0000, 0xFBC0,0xAE7D,0x0000,
0xFBC0,0xAE7E,0x0000, 0xFBC0,0xAE7F,0x0000, 0xFB40,0xCE36,0x0000,
0xFB40,0xD382,0x0000, 0xFB40,0xCE5B,0x0000, 0xFB40,0xCE5A,0x0000,
0xFB40,0xCE59,0x0000, 0xFB40,0xCEBB,0x0000, 0xFB40,0xD182,0x0000,
0xFB40,0xD1E0,0x0000, 0xFB40,0xD200,0x0000, 0xFB40,0xD202,0x0000,
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xDC0F,0x0000,
0xFB40,0xDC0F,0x0000, 0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000,
0xFB40,0xDC22,0x0000, 0xFB40,0xDC23,0x0000, 0xFB40,0xDDF3,0x0000,
0xFB40,0xDE7A,0x0000, 0xFB40,0xDF51,0x0000, 0xFB40,0xDF50,0x0000,
0xFB40,0xDFC4,0x0000, 0xFB40,0xDFC3,0x0000, 0xFB40,0xE24C,0x0000,
0xFB40,0xE535,0x0000, 0xFBC0,0xAE9A,0x0000, 0xFB40,0xE5E1,0x0000,
0xFB40,0xE5E5,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xEB7A,0x0000,
0xFB40,0xEBCD,0x0000, 0xFB40,0xEC11,0x0000, 0xFB40,0xEC35,0x0000,
0xFB40,0xEC3A,0x0000, 0xFB40,0xF06C,0x0000, 0xFB40,0xF22B,0x0000,
0xFB40,0xF22B,0x0000, 0xFB40,0xCE2C,0x0000, 0xFB40,0xF25B,0x0000,
0xFB40,0xF2AD,0x0000, 0xFB40,0xF38B,0x0000, 0xFB40,0xF58B,0x0000,
0xFB40,0xF6EE,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF93B,0x0000,
0xFB40,0xFAF9,0x0000, 0xFB40,0xFCF9,0x0000, 0xFB40,0xFE9F,0x0000,
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF53,0x0000,
0xFB40,0xFF53,0x0000, 0xFB40,0xFF52,0x0000, 0xFB40,0xFF8A,0x0000,
0xFB40,0xFF8A,0x0000, 0xFB40,0xFF8B,0x0000, 0xFB41,0x8002,0x0000,
0xFB41,0x8080,0x0000, 0xFB41,0x807F,0x0000, 0xFB41,0x8089,0x0000,
0xFB41,0x81FC,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000,
0xFB41,0x8279,0x0000, 0xFB41,0x864E,0x0000, 0xFB41,0x8864,0x0000,
0xFB41,0x8980,0x0000, 0xFB41,0x897F,0x0000, 0xFB41,0x89C1,0x0000,
0xFB41,0x89D2,0x0000, 0xFB41,0x89D2,0x0000, 0xFB41,0x8BA0,0x0000,
0xFB41,0x8D1D,0x0000, 0xFB41,0x8DB3,0x0000, 0xFB41,0x8F66,0x0000,
0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000, 0xFB41,0x8FB6,0x0000,
0xFB41,0x9091,0x0000, 0xFB41,0x9485,0x0000, 0xFB41,0x9577,0x0000,
0xFB41,0x9578,0x0000, 0xFB41,0x957F,0x0000, 0xFB41,0x95E8,0x0000,
0xFB41,0x961C,0x0000, 0xFB41,0x961D,0x0000, 0xFB41,0x96E8,0x0000,
0xFB41,0x9752,0x0000, 0xFB41,0x97E6,0x0000, 0xFB41,0x9875,0x0000,
0xFB41,0x98CE,0x0000, 0xFB41,0x98DE,0x0000, 0xFB41,0x98DF,0x0000,
0xFB41,0x98E0,0x0000, 0xFB41,0x98E0,0x0000, 0xFB41,0x9963,0x0000,
0xFB41,0x9996,0x0000, 0xFB41,0x9A6C,0x0000, 0xFB41,0x9AA8,0x0000,
0xFB41,0x9B3C,0x0000, 0xFB41,0x9C7C,0x0000, 0xFB41,0x9E1F,0x0000,
0xFB41,0x9E75,0x0000, 0xFB41,0x9EA6,0x0000, 0xFB41,0x9EC4,0x0000,
0xFB41,0x9EFE,0x0000, 0xFB41,0x9F4A,0x0000, 0xFB41,0x9F50,0x0000,
0xFB41,0x9F52,0x0000, 0xFB41,0x9F7F,0x0000, 0xFB41,0x9F8D,0x0000,
0xFB41,0x9F99,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB41,0x9F9F,0x0000, 0xFBC0,0xAEF4,0x0000, 0xFBC0,0xAEF5,0x0000,
0xFBC0,0xAEF6,0x0000, 0xFBC0,0xAEF7,0x0000, 0xFBC0,0xAEF8,0x0000,
0xFBC0,0xAEF9,0x0000, 0xFBC0,0xAEFA,0x0000, 0xFBC0,0xAEFB,0x0000,
0xFBC0,0xAEFC,0x0000, 0xFBC0,0xAEFD,0x0000, 0xFBC0,0xAEFE,0x0000,
0xFBC0,0xAEFF,0x0000 };

uint16 page02Fdata[]= { /* 2F00 (3 weights per char) */
0xFB40,0xCE00,0x0000, 0xFB40,0xCE28,0x0000, 0xFB40,0xCE36,0x0000,
0xFB40,0xCE3F,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE85,0x0000,
0xFB40,0xCE8C,0x0000, 0xFB40,0xCEA0,0x0000, 0xFB40,0xCEBA,0x0000,
0xFB40,0xD13F,0x0000, 0xFB40,0xD165,0x0000, 0xFB40,0xD16B,0x0000,
0xFB40,0xD182,0x0000, 0xFB40,0xD196,0x0000, 0xFB40,0xD1AB,0x0000,
0xFB40,0xD1E0,0x0000, 0xFB40,0xD1F5,0x0000, 0xFB40,0xD200,0x0000,
0xFB40,0xD29B,0x0000, 0xFB40,0xD2F9,0x0000, 0xFB40,0xD315,0x0000,
0xFB40,0xD31A,0x0000, 0xFB40,0xD338,0x0000, 0xFB40,0xD341,0x0000,
0xFB40,0xD35C,0x0000, 0xFB40,0xD369,0x0000, 0xFB40,0xD382,0x0000,
0xFB40,0xD3B6,0x0000, 0xFB40,0xD3C8,0x0000, 0xFB40,0xD3E3,0x0000,
0xFB40,0xD6D7,0x0000, 0xFB40,0xD71F,0x0000, 0xFB40,0xD8EB,0x0000,
0xFB40,0xD902,0x0000, 0xFB40,0xD90A,0x0000, 0xFB40,0xD915,0x0000,
0xFB40,0xD927,0x0000, 0xFB40,0xD973,0x0000, 0xFB40,0xDB50,0x0000,
0xFB40,0xDB80,0x0000, 0xFB40,0xDBF8,0x0000, 0xFB40,0xDC0F,0x0000,
0xFB40,0xDC22,0x0000, 0xFB40,0xDC38,0x0000, 0xFB40,0xDC6E,0x0000,
0xFB40,0xDC71,0x0000, 0xFB40,0xDDDB,0x0000, 0xFB40,0xDDE5,0x0000,
0xFB40,0xDDF1,0x0000, 0xFB40,0xDDFE,0x0000, 0xFB40,0xDE72,0x0000,
0xFB40,0xDE7A,0x0000, 0xFB40,0xDE7F,0x0000, 0xFB40,0xDEF4,0x0000,
0xFB40,0xDEFE,0x0000, 0xFB40,0xDF0B,0x0000, 0xFB40,0xDF13,0x0000,
0xFB40,0xDF50,0x0000, 0xFB40,0xDF61,0x0000, 0xFB40,0xDF73,0x0000,
0xFB40,0xDFC3,0x0000, 0xFB40,0xE208,0x0000, 0xFB40,0xE236,0x0000,
0xFB40,0xE24B,0x0000, 0xFB40,0xE52F,0x0000, 0xFB40,0xE534,0x0000,
0xFB40,0xE587,0x0000, 0xFB40,0xE597,0x0000, 0xFB40,0xE5A4,0x0000,
0xFB40,0xE5B9,0x0000, 0xFB40,0xE5E0,0x0000, 0xFB40,0xE5E5,0x0000,
0xFB40,0xE6F0,0x0000, 0xFB40,0xE708,0x0000, 0xFB40,0xE728,0x0000,
0xFB40,0xEB20,0x0000, 0xFB40,0xEB62,0x0000, 0xFB40,0xEB79,0x0000,
0xFB40,0xEBB3,0x0000, 0xFB40,0xEBCB,0x0000, 0xFB40,0xEBD4,0x0000,
0xFB40,0xEBDB,0x0000, 0xFB40,0xEC0F,0x0000, 0xFB40,0xEC14,0x0000,
0xFB40,0xEC34,0x0000, 0xFB40,0xF06B,0x0000, 0xFB40,0xF22A,0x0000,
0xFB40,0xF236,0x0000, 0xFB40,0xF23B,0x0000, 0xFB40,0xF23F,0x0000,
0xFB40,0xF247,0x0000, 0xFB40,0xF259,0x0000, 0xFB40,0xF25B,0x0000,
0xFB40,0xF2AC,0x0000, 0xFB40,0xF384,0x0000, 0xFB40,0xF389,0x0000,
0xFB40,0xF4DC,0x0000, 0xFB40,0xF4E6,0x0000, 0xFB40,0xF518,0x0000,
0xFB40,0xF51F,0x0000, 0xFB40,0xF528,0x0000, 0xFB40,0xF530,0x0000,
0xFB40,0xF58B,0x0000, 0xFB40,0xF592,0x0000, 0xFB40,0xF676,0x0000,
0xFB40,0xF67D,0x0000, 0xFB40,0xF6AE,0x0000, 0xFB40,0xF6BF,0x0000,
0xFB40,0xF6EE,0x0000, 0xFB40,0xF7DB,0x0000, 0xFB40,0xF7E2,0x0000,
0xFB40,0xF7F3,0x0000, 0xFB40,0xF93A,0x0000, 0xFB40,0xF9B8,0x0000,
0xFB40,0xF9BE,0x0000, 0xFB40,0xFA74,0x0000, 0xFB40,0xFACB,0x0000,
0xFB40,0xFAF9,0x0000, 0xFB40,0xFC73,0x0000, 0xFB40,0xFCF8,0x0000,
0xFB40,0xFF36,0x0000, 0xFB40,0xFF51,0x0000, 0xFB40,0xFF8A,0x0000,
0xFB40,0xFFBD,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x800C,0x0000,
0xFB41,0x8012,0x0000, 0xFB41,0x8033,0x0000, 0xFB41,0x807F,0x0000,
0xFB41,0x8089,0x0000, 0xFB41,0x81E3,0x0000, 0xFB41,0x81EA,0x0000,
0xFB41,0x81F3,0x0000, 0xFB41,0x81FC,0x0000, 0xFB41,0x820C,0x0000,
0xFB41,0x821B,0x0000, 0xFB41,0x821F,0x0000, 0xFB41,0x826E,0x0000,
0xFB41,0x8272,0x0000, 0xFB41,0x8278,0x0000, 0xFB41,0x864D,0x0000,
0xFB41,0x866B,0x0000, 0xFB41,0x8840,0x0000, 0xFB41,0x884C,0x0000,
0xFB41,0x8863,0x0000, 0xFB41,0x897E,0x0000, 0xFB41,0x898B,0x0000,
0xFB41,0x89D2,0x0000, 0xFB41,0x8A00,0x0000, 0xFB41,0x8C37,0x0000,
0xFB41,0x8C46,0x0000, 0xFB41,0x8C55,0x0000, 0xFB41,0x8C78,0x0000,
0xFB41,0x8C9D,0x0000, 0xFB41,0x8D64,0x0000, 0xFB41,0x8D70,0x0000,
0xFB41,0x8DB3,0x0000, 0xFB41,0x8EAB,0x0000, 0xFB41,0x8ECA,0x0000,
0xFB41,0x8F9B,0x0000, 0xFB41,0x8FB0,0x0000, 0xFB41,0x8FB5,0x0000,
0xFB41,0x9091,0x0000, 0xFB41,0x9149,0x0000, 0xFB41,0x91C6,0x0000,
0xFB41,0x91CC,0x0000, 0xFB41,0x91D1,0x0000, 0xFB41,0x9577,0x0000,
0xFB41,0x9580,0x0000, 0xFB41,0x961C,0x0000, 0xFB41,0x96B6,0x0000,
0xFB41,0x96B9,0x0000, 0xFB41,0x96E8,0x0000, 0xFB41,0x9751,0x0000,
0xFB41,0x975E,0x0000, 0xFB41,0x9762,0x0000, 0xFB41,0x9769,0x0000,
0xFB41,0x97CB,0x0000, 0xFB41,0x97ED,0x0000, 0xFB41,0x97F3,0x0000,
0xFB41,0x9801,0x0000, 0xFB41,0x98A8,0x0000, 0xFB41,0x98DB,0x0000,
0xFB41,0x98DF,0x0000, 0xFB41,0x9996,0x0000, 0xFB41,0x9999,0x0000,
0xFB41,0x99AC,0x0000, 0xFB41,0x9AA8,0x0000, 0xFB41,0x9AD8,0x0000,
0xFB41,0x9ADF,0x0000, 0xFB41,0x9B25,0x0000, 0xFB41,0x9B2F,0x0000,
0xFB41,0x9B32,0x0000, 0xFB41,0x9B3C,0x0000, 0xFB41,0x9B5A,0x0000,
0xFB41,0x9CE5,0x0000, 0xFB41,0x9E75,0x0000, 0xFB41,0x9E7F,0x0000,
0xFB41,0x9EA5,0x0000, 0xFB41,0x9EBB,0x0000, 0xFB41,0x9EC3,0x0000,
0xFB41,0x9ECD,0x0000, 0xFB41,0x9ED1,0x0000, 0xFB41,0x9EF9,0x0000,
0xFB41,0x9EFD,0x0000, 0xFB41,0x9F0E,0x0000, 0xFB41,0x9F13,0x0000,
0xFB41,0x9F20,0x0000, 0xFB41,0x9F3B,0x0000, 0xFB41,0x9F4A,0x0000,
0xFB41,0x9F52,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB41,0x9FA0,0x0000, 0xFBC0,0xAFD6,0x0000, 0xFBC0,0xAFD7,0x0000,
0xFBC0,0xAFD8,0x0000, 0xFBC0,0xAFD9,0x0000, 0xFBC0,0xAFDA,0x0000,
0xFBC0,0xAFDB,0x0000, 0xFBC0,0xAFDC,0x0000, 0xFBC0,0xAFDD,0x0000,
0xFBC0,0xAFDE,0x0000, 0xFBC0,0xAFDF,0x0000, 0xFBC0,0xAFE0,0x0000,
0xFBC0,0xAFE1,0x0000, 0xFBC0,0xAFE2,0x0000, 0xFBC0,0xAFE3,0x0000,
0xFBC0,0xAFE4,0x0000, 0xFBC0,0xAFE5,0x0000, 0xFBC0,0xAFE6,0x0000,
0xFBC0,0xAFE7,0x0000, 0xFBC0,0xAFE8,0x0000, 0xFBC0,0xAFE9,0x0000,
0xFBC0,0xAFEA,0x0000, 0xFBC0,0xAFEB,0x0000, 0xFBC0,0xAFEC,0x0000,
0xFBC0,0xAFED,0x0000, 0xFBC0,0xAFEE,0x0000, 0xFBC0,0xAFEF,0x0000,
0x0DAF,0x0000,0x0000, 0x0DB0,0x0000,0x0000, 0x0DB1,0x0000,0x0000,
0x0DB2,0x0000,0x0000, 0x0DB3,0x0000,0x0000, 0x0DB4,0x0000,0x0000,
0x0DB5,0x0000,0x0000, 0x0DB6,0x0000,0x0000, 0x0DB7,0x0000,0x0000,
0x0DB8,0x0000,0x0000, 0x0DB9,0x0000,0x0000, 0x0DBA,0x0000,0x0000,
0xFBC0,0xAFFC,0x0000, 0xFBC0,0xAFFD,0x0000, 0xFBC0,0xAFFE,0x0000,
0xFBC0,0xAFFF,0x0000 };

uint16 page030data[]= { /* 3000 (3 weights per char) */
0x0209,0x0000,0x0000, 0x0237,0x0000,0x0000, 0x0266,0x0000,0x0000,
0x02E2,0x0000,0x0000, 0x0DBB,0x0000,0x0000, 0x0E05,0x0000,0x0000,
0x1E5D,0x1E73,0x0000, 0x0E29,0x0000,0x0000, 0x02AE,0x0000,0x0000,
0x02AF,0x0000,0x0000, 0x02B0,0x0000,0x0000, 0x02B1,0x0000,0x0000,
0x02B2,0x0000,0x0000, 0x02B3,0x0000,0x0000, 0x02B4,0x0000,0x0000,
0x02B5,0x0000,0x0000, 0x02B6,0x0000,0x0000, 0x02B7,0x0000,0x0000,
0x0DBC,0x0000,0x0000, 0x0DBD,0x0000,0x0000, 0x02B8,0x0000,0x0000,
0x02B9,0x0000,0x0000, 0x02BA,0x0000,0x0000, 0x02BB,0x0000,0x0000,
0x02BC,0x0000,0x0000, 0x02BD,0x0000,0x0000, 0x02BE,0x0000,0x0000,
0x02BF,0x0000,0x0000, 0x022B,0x0000,0x0000, 0x0283,0x0000,0x0000,
0x0284,0x0000,0x0000, 0x0285,0x0000,0x0000, 0x0DBE,0x0000,0x0000,
0x0E2A,0x0000,0x0000, 0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000,
0x0E2D,0x0000,0x0000, 0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000,
0x0E30,0x0000,0x0000, 0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x022C,0x0000,0x0000, 0x0E07,0x0000,0x0000, 0x0E07,0x0000,0x0000,
0x0E08,0x0000,0x0000, 0x0E08,0x0000,0x0000, 0x0E09,0x0000,0x0000,
0x0DBC,0x0000,0x0000, 0x0DBF,0x0000,0x0000, 0xFB40,0xD341,0x0000,
0xFB40,0xD344,0x0000, 0xFB40,0xD345,0x0000, 0x0E06,0x0000,0x0000,
0x1E70,0x1E5E,0x0000, 0x02E3,0x0000,0x0000, 0x0DC0,0x0000,0x0000,
0x0DC1,0x0000,0x0000, 0xFBC0,0xB040,0x0000, 0x1E52,0x0000,0x0000,
0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E57,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E58,0x0000,0x0000, 0x1E59,0x0000,0x0000, 0x1E59,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5B,0x0000,0x0000, 0x1E5C,0x0000,0x0000, 0x1E5C,0x0000,0x0000,
0x1E5D,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5E,0x0000,0x0000, 0x1E5F,0x0000,0x0000, 0x1E5F,0x0000,0x0000,
0x1E60,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E61,0x0000,0x0000, 0x1E62,0x0000,0x0000, 0x1E62,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000,
0x1E64,0x0000,0x0000, 0x1E64,0x0000,0x0000, 0x1E65,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000,
0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000,
0x1E70,0x0000,0x0000, 0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000,
0x1E73,0x0000,0x0000, 0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7D,0x0000,0x0000,
0x1E7E,0x0000,0x0000, 0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000,
0x1E81,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E57,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0xFBC0,0xB097,0x0000, 0xFBC0,0xB098,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x021E,0x0000,0x0000,
0x021F,0x0000,0x0000, 0x0E0A,0x0000,0x0000, 0x0E0A,0x0000,0x0000,
0x1E77,0x1E79,0x0000, 0x022D,0x0000,0x0000, 0x1E52,0x0000,0x0000,
0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E57,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E58,0x0000,0x0000, 0x1E59,0x0000,0x0000, 0x1E59,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5B,0x0000,0x0000, 0x1E5C,0x0000,0x0000, 0x1E5C,0x0000,0x0000,
0x1E5D,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5E,0x0000,0x0000, 0x1E5F,0x0000,0x0000, 0x1E5F,0x0000,0x0000,
0x1E60,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E61,0x0000,0x0000, 0x1E62,0x0000,0x0000, 0x1E62,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E63,0x0000,0x0000,
0x1E64,0x0000,0x0000, 0x1E64,0x0000,0x0000, 0x1E65,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6C,0x0000,0x0000,
0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E6F,0x0000,0x0000,
0x1E70,0x0000,0x0000, 0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000,
0x1E73,0x0000,0x0000, 0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7D,0x0000,0x0000,
0x1E7E,0x0000,0x0000, 0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000,
0x1E81,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E57,0x0000,0x0000,
0x1E5A,0x0000,0x0000, 0x1E7D,0x0000,0x0000, 0x1E7E,0x0000,0x0000,
0x1E7F,0x0000,0x0000, 0x1E80,0x0000,0x0000, 0x022E,0x0000,0x0000,
0x0E0B,0x0000,0x0000, 0x0E0C,0x0000,0x0000, 0x0E0C,0x0000,0x0000,
0x1E5B,0x1E65,0x0000 };

uint16 page031data[]= { /* 3100 (3 weights per char) */
0xFBC0,0xB100,0x0000, 0xFBC0,0xB101,0x0000, 0xFBC0,0xB102,0x0000,
0xFBC0,0xB103,0x0000, 0xFBC0,0xB104,0x0000, 0x1E82,0x0000,0x0000,
0x1E83,0x0000,0x0000, 0x1E84,0x0000,0x0000, 0x1E85,0x0000,0x0000,
0x1E87,0x0000,0x0000, 0x1E88,0x0000,0x0000, 0x1E89,0x0000,0x0000,
0x1E8A,0x0000,0x0000, 0x1E8B,0x0000,0x0000, 0x1E8C,0x0000,0x0000,
0x1E8F,0x0000,0x0000, 0x1E90,0x0000,0x0000, 0x1E91,0x0000,0x0000,
0x1E92,0x0000,0x0000, 0x1E94,0x0000,0x0000, 0x1E95,0x0000,0x0000,
0x1E96,0x0000,0x0000, 0x1E97,0x0000,0x0000, 0x1E98,0x0000,0x0000,
0x1E99,0x0000,0x0000, 0x1E9A,0x0000,0x0000, 0x1E9B,0x0000,0x0000,
0x1E9C,0x0000,0x0000, 0x1E9E,0x0000,0x0000, 0x1E9F,0x0000,0x0000,
0x1EA1,0x0000,0x0000, 0x1EA2,0x0000,0x0000, 0x1EA3,0x0000,0x0000,
0x1EA4,0x0000,0x0000, 0x1EA5,0x0000,0x0000, 0x1EA6,0x0000,0x0000,
0x1EA7,0x0000,0x0000, 0x1EA9,0x0000,0x0000, 0x1EAD,0x0000,0x0000,
0x1EAE,0x0000,0x0000, 0x1EAF,0x0000,0x0000, 0x1EB0,0x0000,0x0000,
0x1E86,0x0000,0x0000, 0x1E8D,0x0000,0x0000, 0x1E93,0x0000,0x0000,
0xFBC0,0xB12D,0x0000, 0xFBC0,0xB12E,0x0000, 0xFBC0,0xB12F,0x0000,
0xFBC0,0xB130,0x0000, 0x1D62,0x0000,0x0000, 0x1D63,0x0000,0x0000,
0x1E02,0x0000,0x0000, 0x1D64,0x0000,0x0000, 0x1E04,0x0000,0x0000,
0x1E05,0x0000,0x0000, 0x1D65,0x0000,0x0000, 0x1D66,0x0000,0x0000,
0x1D67,0x0000,0x0000, 0x1E08,0x0000,0x0000, 0x1E09,0x0000,0x0000,
0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000, 0x1E0C,0x0000,0x0000,
0x1E0D,0x0000,0x0000, 0x1D7C,0x0000,0x0000, 0x1D68,0x0000,0x0000,
0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000, 0x1D83,0x0000,0x0000,
0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000, 0x1D6D,0x0000,0x0000,
0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000, 0x1D70,0x0000,0x0000,
0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000, 0x1D73,0x0000,0x0000,
0x1D74,0x0000,0x0000, 0x1DBE,0x0000,0x0000, 0x1DBF,0x0000,0x0000,
0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000, 0x1DC2,0x0000,0x0000,
0x1DC3,0x0000,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000,
0x1DCC,0x0000,0x0000, 0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000,
0x1DCF,0x0000,0x0000, 0x1DD0,0x0000,0x0000, 0x1DD1,0x0000,0x0000,
0x1DD2,0x0000,0x0000, 0x1DBD,0x0000,0x0000, 0x1D76,0x0000,0x0000,
0x1D77,0x0000,0x0000, 0x1E1F,0x0000,0x0000, 0x1E20,0x0000,0x0000,
0x1E24,0x0000,0x0000, 0x1E26,0x0000,0x0000, 0x1E2B,0x0000,0x0000,
0x1E2F,0x0000,0x0000, 0x1E31,0x0000,0x0000, 0x1D7E,0x0000,0x0000,
0x1E35,0x0000,0x0000, 0x1E37,0x0000,0x0000, 0x1D7F,0x0000,0x0000,
0x1D80,0x0000,0x0000, 0x1D82,0x0000,0x0000, 0x1D84,0x0000,0x0000,
0x1D85,0x0000,0x0000, 0x1D89,0x0000,0x0000, 0x1D8B,0x0000,0x0000,
0x1D8D,0x0000,0x0000, 0x1D8E,0x0000,0x0000, 0x1D8F,0x0000,0x0000,
0x1D90,0x0000,0x0000, 0x1D91,0x0000,0x0000, 0x1D94,0x0000,0x0000,
0x1D98,0x0000,0x0000, 0x1DA2,0x0000,0x0000, 0x1DA9,0x0000,0x0000,
0x1DAE,0x0000,0x0000, 0x1E49,0x0000,0x0000, 0x1E4A,0x0000,0x0000,
0x1DB9,0x0000,0x0000, 0x1DBA,0x0000,0x0000, 0x1DBB,0x0000,0x0000,
0x1DE1,0x0000,0x0000, 0x1DE2,0x0000,0x0000, 0x1DE5,0x0000,0x0000,
0x1DEE,0x0000,0x0000, 0x1DEF,0x0000,0x0000, 0x1DF1,0x0000,0x0000,
0x1DFB,0x0000,0x0000, 0x1DFE,0x0000,0x0000, 0xFBC0,0xB18F,0x0000,
0x0DC2,0x0000,0x0000, 0x0DC3,0x0000,0x0000, 0xFB40,0xCE00,0x0000,
0xFB40,0xCE8C,0x0000, 0xFB40,0xCE09,0x0000, 0xFB40,0xD6DB,0x0000,
0xFB40,0xCE0A,0x0000, 0xFB40,0xCE2D,0x0000, 0xFB40,0xCE0B,0x0000,
0xFB40,0xF532,0x0000, 0xFB40,0xCE59,0x0000, 0xFB40,0xCE19,0x0000,
0xFB40,0xCE01,0x0000, 0xFB40,0xD929,0x0000, 0xFB40,0xD730,0x0000,
0xFB40,0xCEBA,0x0000, 0x1E82,0x0000,0x0000, 0x1E98,0x0000,0x0000,
0x1E90,0x0000,0x0000, 0x1E8B,0x0000,0x0000, 0x1EA0,0x0000,0x0000,
0x1EA0,0x0000,0x0000, 0x1E9D,0x0000,0x0000, 0x1E9C,0x0000,0x0000,
0x1EAF,0x0000,0x0000, 0x1E9B,0x0000,0x0000, 0x1EAE,0x0000,0x0000,
0x1EAF,0x0000,0x0000, 0x1EAC,0x0000,0x0000, 0x1E8E,0x0000,0x0000,
0x1EA1,0x0000,0x0000, 0x1EA3,0x0000,0x0000, 0x1EAA,0x0000,0x0000,
0x1EAB,0x0000,0x0000, 0x1EA8,0x0000,0x0000, 0x1EAE,0x0000,0x0000,
0x1E83,0x0000,0x0000, 0x1E88,0x0000,0x0000, 0x1E8C,0x0000,0x0000,
0x1E8F,0x0000,0x0000, 0xFBC0,0xB1B8,0x0000, 0xFBC0,0xB1B9,0x0000,
0xFBC0,0xB1BA,0x0000, 0xFBC0,0xB1BB,0x0000, 0xFBC0,0xB1BC,0x0000,
0xFBC0,0xB1BD,0x0000, 0xFBC0,0xB1BE,0x0000, 0xFBC0,0xB1BF,0x0000,
0xFBC0,0xB1C0,0x0000, 0xFBC0,0xB1C1,0x0000, 0xFBC0,0xB1C2,0x0000,
0xFBC0,0xB1C3,0x0000, 0xFBC0,0xB1C4,0x0000, 0xFBC0,0xB1C5,0x0000,
0xFBC0,0xB1C6,0x0000, 0xFBC0,0xB1C7,0x0000, 0xFBC0,0xB1C8,0x0000,
0xFBC0,0xB1C9,0x0000, 0xFBC0,0xB1CA,0x0000, 0xFBC0,0xB1CB,0x0000,
0xFBC0,0xB1CC,0x0000, 0xFBC0,0xB1CD,0x0000, 0xFBC0,0xB1CE,0x0000,
0xFBC0,0xB1CF,0x0000, 0xFBC0,0xB1D0,0x0000, 0xFBC0,0xB1D1,0x0000,
0xFBC0,0xB1D2,0x0000, 0xFBC0,0xB1D3,0x0000, 0xFBC0,0xB1D4,0x0000,
0xFBC0,0xB1D5,0x0000, 0xFBC0,0xB1D6,0x0000, 0xFBC0,0xB1D7,0x0000,
0xFBC0,0xB1D8,0x0000, 0xFBC0,0xB1D9,0x0000, 0xFBC0,0xB1DA,0x0000,
0xFBC0,0xB1DB,0x0000, 0xFBC0,0xB1DC,0x0000, 0xFBC0,0xB1DD,0x0000,
0xFBC0,0xB1DE,0x0000, 0xFBC0,0xB1DF,0x0000, 0xFBC0,0xB1E0,0x0000,
0xFBC0,0xB1E1,0x0000, 0xFBC0,0xB1E2,0x0000, 0xFBC0,0xB1E3,0x0000,
0xFBC0,0xB1E4,0x0000, 0xFBC0,0xB1E5,0x0000, 0xFBC0,0xB1E6,0x0000,
0xFBC0,0xB1E7,0x0000, 0xFBC0,0xB1E8,0x0000, 0xFBC0,0xB1E9,0x0000,
0xFBC0,0xB1EA,0x0000, 0xFBC0,0xB1EB,0x0000, 0xFBC0,0xB1EC,0x0000,
0xFBC0,0xB1ED,0x0000, 0xFBC0,0xB1EE,0x0000, 0xFBC0,0xB1EF,0x0000,
0x1E59,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E68,0x0000,0x0000, 0x1E6B,0x0000,0x0000,
0x1E6C,0x0000,0x0000, 0x1E6D,0x0000,0x0000, 0x1E6E,0x0000,0x0000,
0x1E6F,0x0000,0x0000, 0x1E72,0x0000,0x0000, 0x1E78,0x0000,0x0000,
0x1E79,0x0000,0x0000, 0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000,
0x1E7C,0x0000,0x0000 };

uint16 page032data[]= { /* 3200 (8 weights per char) */
0x0288,0x1D62,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D64,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D65,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D67,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D68,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D69,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6B,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D70,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D71,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D72,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D73,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D74,0x0289,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D62,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D64,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D65,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D67,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D68,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D69,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6B,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D70,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D71,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D72,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D73,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D74,0x1DBE,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6E,0x1DCB,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0x1D6D,0x1DC6,0x1D6E,0x1DC2,0x1E03,0x0289,0x0000,
0x0288,0x1D6D,0x1DC6,0x1D74,0x1DCB,0x0289,0x0000,0x0000,
0xFBC0,0xB21F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE00,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE8C,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE09,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD6DB,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE94,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD16D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE03,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD16B,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCE5D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD341,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE708,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF06B,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xEC34,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE728,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x91D1,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD71F,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE5E5,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE82A,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xE709,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF93E,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD40D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF279,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x8CA1,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF95D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD2B4,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCEE3,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD47C,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xDB66,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF6E3,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCF01,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x8CC7,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xD354,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xF96D,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB40,0xCF11,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x81EA,0x0289,0x0000,0x0000,0x0000,0x0000,
0x0288,0xFB41,0x81F3,0x0289,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB244,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB245,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB246,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB247,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB248,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB249,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB24F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1002,0x0E8B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D68,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D69,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D71,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D73,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D74,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D62,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D64,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D65,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D67,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D68,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D69,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6B,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6D,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D6E,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D71,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D72,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D73,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D74,0x1DBE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1D70,0x1DBE,0x1E0F,0x1D62,0x1DC6,0x0000,0x0000,0x0000,
0x1D6E,0x1DCB,0x1D6D,0x1DD1,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB27E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0DC4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE8C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE09,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD6DB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE94,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD16D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE03,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD16B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD341,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF06B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xEC34,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE728,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x91D1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD71F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE82A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE709,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF93E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD40D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF279,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x8CA1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF95D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD2B4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF9D8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF537,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD973,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x9069,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD12A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD370,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xECE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x9805,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCF11,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD199,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE0A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCE0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD3F3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD33B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDB97,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDB66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xF6E3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xCF01,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB41,0x8CC7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD354,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD91C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E2F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E30,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E31,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0x0E32,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0x0E29,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xE708,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x0FC0,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E8B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x1002,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E54,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E67,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E68,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E69,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E74,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E76,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E77,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E78,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E80,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC0,0xB2FF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page033data[]= { /* 3300 (9 weights per char) */
0x1E52,0x1E6B,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x1E7A,0x1E6D,0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x1E81,0x1E6E,0x1E52,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E52,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x1E67,0x1E81,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E53,0x1E81,0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E54,0x1E56,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x1E5E,0x1E59,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E55,0x0E0B,0x1E57,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x1E81,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E56,0x0E0B,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E53,0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E78,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E7C,0x1E79,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E7C,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E57,0x1E81,0x1E70,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E67,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E76,0x1E79,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7A,0x1E61,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E59,0x1E78,0x1E72,0x0000,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E73,0x0E0B,0x1E65,0x1E7A,0x0000,0x0000,0x0000,
0x1E58,0x1E7C,0x1E7D,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E78,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E78,0x1E72,0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E7A,0x1E5F,0x1E53,0x1E7C,0x0000,0x0000,0x0000,0x0000,
0x1E59,0x1E7C,0x0E0B,0x1E69,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5A,0x0E0B,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x1E7A,0x1E66,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5B,0x0E0B,0x1E6F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x1E53,0x1E59,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5C,0x1E81,0x1E62,0x0E0B,0x1E72,0x0000,0x0000,0x0000,0x0000,
0x1E5D,0x1E79,0x1E81,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x1E81,0x1E62,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E5F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E61,0x0E0B,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E64,0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E66,0x1E6A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6A,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x1E53,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E5F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6B,0x0E0B,0x1E7B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E52,0x1E5E,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E59,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6C,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E52,0x1E78,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E53,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E63,0x1E5D,0x1E55,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6D,0x1E78,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E59,0x1E61,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E67,0x1E6C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E7A,0x1E63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x1E81,0x1E5E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0E0B,0x1E5D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6E,0x0E0B,0x1E61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E53,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E7A,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x1E81,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E6F,0x0E0B,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E53,0x1E59,0x1E7C,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E53,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E63,0x1E6B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E7A,0x1E59,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E70,0x1E81,0x1E5D,0x1E77,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E59,0x1E7C,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E79,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E71,0x1E79,0x1E6B,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x1E57,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x1E57,0x1E65,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E73,0x0E0B,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0E0B,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E75,0x0E0B,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E76,0x1E52,0x1E81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x1E63,0x1E65,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E79,0x1E78,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x1E6C,0x0E0B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7A,0x0E0B,0x1E6D,0x1E7A,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x1E72,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1E7B,0x1E81,0x1E65,0x1E5A,0x1E81,0x0000,0x0000,0x0000,0x0000,
0x1E7D,0x1E63,0x1E65,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0xFB40,0xF0B9,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x101F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0E33,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F82,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x101F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xDE73,0xFB40,0xE210,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE62D,0xFB40,0xD48C,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xD927,0xFB40,0xEB63,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE60E,0xFB40,0xECBB,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFB40,0xE82A,0xFB40,0xDF0F,0xFB40,0xCF1A,0xFB40,0xF93E,0x0000,
0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0E60,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0EB9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1002,0x0EE1,0x106A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EB9,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0E2C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0437,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0437,0x0FEA,0x0E2B,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0FA7,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0437,0x0FEA,0x0000,0x0000,0x0000,0x0000,
0x0FC0,0x0E33,0x0E6D,0x0437,0x0FEA,0x0E2B,0x0000,0x0000,0x0000,
0x0FA7,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0FEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F64,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x10F8,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1051,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1109,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x1109,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x025D,0x0F5B,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E4A,0x0FB4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0E6D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0437,0x0F21,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E60,0x0F82,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E6D,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x105E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0E33,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EE1,0x0FA7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EFB,0x0F64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F21,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F21,0x1002,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F64,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x0F82,0x0EC1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F2E,0x105A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0EFB,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0F5B,0x0F82,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0EE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x025D,0x0F5B,0x025D,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0FA7,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FA7,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x0FC0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0FEA,0x1044,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1051,0x0E4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1044,0x0437,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E33,0x0437,0x0F5B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2A,0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2B,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2C,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2D,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2E,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E2F,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E30,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E31,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2B,0x0E32,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E29,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0E2C,0x0E2A,0xFB40,0xE5E5,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0EC1,0x0E33,0x0F2E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page04Ddata[]= { /* 4D00 (3 weights per char) */
0xFB80,0xCD00,0x0000, 0xFB80,0xCD01,0x0000, 0xFB80,0xCD02,0x0000,
0xFB80,0xCD03,0x0000, 0xFB80,0xCD04,0x0000, 0xFB80,0xCD05,0x0000,
0xFB80,0xCD06,0x0000, 0xFB80,0xCD07,0x0000, 0xFB80,0xCD08,0x0000,
0xFB80,0xCD09,0x0000, 0xFB80,0xCD0A,0x0000, 0xFB80,0xCD0B,0x0000,
0xFB80,0xCD0C,0x0000, 0xFB80,0xCD0D,0x0000, 0xFB80,0xCD0E,0x0000,
0xFB80,0xCD0F,0x0000, 0xFB80,0xCD10,0x0000, 0xFB80,0xCD11,0x0000,
0xFB80,0xCD12,0x0000, 0xFB80,0xCD13,0x0000, 0xFB80,0xCD14,0x0000,
0xFB80,0xCD15,0x0000, 0xFB80,0xCD16,0x0000, 0xFB80,0xCD17,0x0000,
0xFB80,0xCD18,0x0000, 0xFB80,0xCD19,0x0000, 0xFB80,0xCD1A,0x0000,
0xFB80,0xCD1B,0x0000, 0xFB80,0xCD1C,0x0000, 0xFB80,0xCD1D,0x0000,
0xFB80,0xCD1E,0x0000, 0xFB80,0xCD1F,0x0000, 0xFB80,0xCD20,0x0000,
0xFB80,0xCD21,0x0000, 0xFB80,0xCD22,0x0000, 0xFB80,0xCD23,0x0000,
0xFB80,0xCD24,0x0000, 0xFB80,0xCD25,0x0000, 0xFB80,0xCD26,0x0000,
0xFB80,0xCD27,0x0000, 0xFB80,0xCD28,0x0000, 0xFB80,0xCD29,0x0000,
0xFB80,0xCD2A,0x0000, 0xFB80,0xCD2B,0x0000, 0xFB80,0xCD2C,0x0000,
0xFB80,0xCD2D,0x0000, 0xFB80,0xCD2E,0x0000, 0xFB80,0xCD2F,0x0000,
0xFB80,0xCD30,0x0000, 0xFB80,0xCD31,0x0000, 0xFB80,0xCD32,0x0000,
0xFB80,0xCD33,0x0000, 0xFB80,0xCD34,0x0000, 0xFB80,0xCD35,0x0000,
0xFB80,0xCD36,0x0000, 0xFB80,0xCD37,0x0000, 0xFB80,0xCD38,0x0000,
0xFB80,0xCD39,0x0000, 0xFB80,0xCD3A,0x0000, 0xFB80,0xCD3B,0x0000,
0xFB80,0xCD3C,0x0000, 0xFB80,0xCD3D,0x0000, 0xFB80,0xCD3E,0x0000,
0xFB80,0xCD3F,0x0000, 0xFB80,0xCD40,0x0000, 0xFB80,0xCD41,0x0000,
0xFB80,0xCD42,0x0000, 0xFB80,0xCD43,0x0000, 0xFB80,0xCD44,0x0000,
0xFB80,0xCD45,0x0000, 0xFB80,0xCD46,0x0000, 0xFB80,0xCD47,0x0000,
0xFB80,0xCD48,0x0000, 0xFB80,0xCD49,0x0000, 0xFB80,0xCD4A,0x0000,
0xFB80,0xCD4B,0x0000, 0xFB80,0xCD4C,0x0000, 0xFB80,0xCD4D,0x0000,
0xFB80,0xCD4E,0x0000, 0xFB80,0xCD4F,0x0000, 0xFB80,0xCD50,0x0000,
0xFB80,0xCD51,0x0000, 0xFB80,0xCD52,0x0000, 0xFB80,0xCD53,0x0000,
0xFB80,0xCD54,0x0000, 0xFB80,0xCD55,0x0000, 0xFB80,0xCD56,0x0000,
0xFB80,0xCD57,0x0000, 0xFB80,0xCD58,0x0000, 0xFB80,0xCD59,0x0000,
0xFB80,0xCD5A,0x0000, 0xFB80,0xCD5B,0x0000, 0xFB80,0xCD5C,0x0000,
0xFB80,0xCD5D,0x0000, 0xFB80,0xCD5E,0x0000, 0xFB80,0xCD5F,0x0000,
0xFB80,0xCD60,0x0000, 0xFB80,0xCD61,0x0000, 0xFB80,0xCD62,0x0000,
0xFB80,0xCD63,0x0000, 0xFB80,0xCD64,0x0000, 0xFB80,0xCD65,0x0000,
0xFB80,0xCD66,0x0000, 0xFB80,0xCD67,0x0000, 0xFB80,0xCD68,0x0000,
0xFB80,0xCD69,0x0000, 0xFB80,0xCD6A,0x0000, 0xFB80,0xCD6B,0x0000,
0xFB80,0xCD6C,0x0000, 0xFB80,0xCD6D,0x0000, 0xFB80,0xCD6E,0x0000,
0xFB80,0xCD6F,0x0000, 0xFB80,0xCD70,0x0000, 0xFB80,0xCD71,0x0000,
0xFB80,0xCD72,0x0000, 0xFB80,0xCD73,0x0000, 0xFB80,0xCD74,0x0000,
0xFB80,0xCD75,0x0000, 0xFB80,0xCD76,0x0000, 0xFB80,0xCD77,0x0000,
0xFB80,0xCD78,0x0000, 0xFB80,0xCD79,0x0000, 0xFB80,0xCD7A,0x0000,
0xFB80,0xCD7B,0x0000, 0xFB80,0xCD7C,0x0000, 0xFB80,0xCD7D,0x0000,
0xFB80,0xCD7E,0x0000, 0xFB80,0xCD7F,0x0000, 0xFB80,0xCD80,0x0000,
0xFB80,0xCD81,0x0000, 0xFB80,0xCD82,0x0000, 0xFB80,0xCD83,0x0000,
0xFB80,0xCD84,0x0000, 0xFB80,0xCD85,0x0000, 0xFB80,0xCD86,0x0000,
0xFB80,0xCD87,0x0000, 0xFB80,0xCD88,0x0000, 0xFB80,0xCD89,0x0000,
0xFB80,0xCD8A,0x0000, 0xFB80,0xCD8B,0x0000, 0xFB80,0xCD8C,0x0000,
0xFB80,0xCD8D,0x0000, 0xFB80,0xCD8E,0x0000, 0xFB80,0xCD8F,0x0000,
0xFB80,0xCD90,0x0000, 0xFB80,0xCD91,0x0000, 0xFB80,0xCD92,0x0000,
0xFB80,0xCD93,0x0000, 0xFB80,0xCD94,0x0000, 0xFB80,0xCD95,0x0000,
0xFB80,0xCD96,0x0000, 0xFB80,0xCD97,0x0000, 0xFB80,0xCD98,0x0000,
0xFB80,0xCD99,0x0000, 0xFB80,0xCD9A,0x0000, 0xFB80,0xCD9B,0x0000,
0xFB80,0xCD9C,0x0000, 0xFB80,0xCD9D,0x0000, 0xFB80,0xCD9E,0x0000,
0xFB80,0xCD9F,0x0000, 0xFB80,0xCDA0,0x0000, 0xFB80,0xCDA1,0x0000,
0xFB80,0xCDA2,0x0000, 0xFB80,0xCDA3,0x0000, 0xFB80,0xCDA4,0x0000,
0xFB80,0xCDA5,0x0000, 0xFB80,0xCDA6,0x0000, 0xFB80,0xCDA7,0x0000,
0xFB80,0xCDA8,0x0000, 0xFB80,0xCDA9,0x0000, 0xFB80,0xCDAA,0x0000,
0xFB80,0xCDAB,0x0000, 0xFB80,0xCDAC,0x0000, 0xFB80,0xCDAD,0x0000,
0xFB80,0xCDAE,0x0000, 0xFB80,0xCDAF,0x0000, 0xFB80,0xCDB0,0x0000,
0xFB80,0xCDB1,0x0000, 0xFB80,0xCDB2,0x0000, 0xFB80,0xCDB3,0x0000,
0xFB80,0xCDB4,0x0000, 0xFB80,0xCDB5,0x0000, 0xFBC0,0xCDB6,0x0000,
0xFBC0,0xCDB7,0x0000, 0xFBC0,0xCDB8,0x0000, 0xFBC0,0xCDB9,0x0000,
0xFBC0,0xCDBA,0x0000, 0xFBC0,0xCDBB,0x0000, 0xFBC0,0xCDBC,0x0000,
0xFBC0,0xCDBD,0x0000, 0xFBC0,0xCDBE,0x0000, 0xFBC0,0xCDBF,0x0000,
0x0B37,0x0000,0x0000, 0x0B38,0x0000,0x0000, 0x0B39,0x0000,0x0000,
0x0B3A,0x0000,0x0000, 0x0B3B,0x0000,0x0000, 0x0B3C,0x0000,0x0000,
0x0B3D,0x0000,0x0000, 0x0B3E,0x0000,0x0000, 0x0B3F,0x0000,0x0000,
0x0B40,0x0000,0x0000, 0x0B41,0x0000,0x0000, 0x0B42,0x0000,0x0000,
0x0B43,0x0000,0x0000, 0x0B44,0x0000,0x0000, 0x0B45,0x0000,0x0000,
0x0B46,0x0000,0x0000, 0x0B47,0x0000,0x0000, 0x0B48,0x0000,0x0000,
0x0B49,0x0000,0x0000, 0x0B4A,0x0000,0x0000, 0x0B4B,0x0000,0x0000,
0x0B4C,0x0000,0x0000, 0x0B4D,0x0000,0x0000, 0x0B4E,0x0000,0x0000,
0x0B4F,0x0000,0x0000, 0x0B50,0x0000,0x0000, 0x0B51,0x0000,0x0000,
0x0B52,0x0000,0x0000, 0x0B53,0x0000,0x0000, 0x0B54,0x0000,0x0000,
0x0B55,0x0000,0x0000, 0x0B56,0x0000,0x0000, 0x0B57,0x0000,0x0000,
0x0B58,0x0000,0x0000, 0x0B59,0x0000,0x0000, 0x0B5A,0x0000,0x0000,
0x0B5B,0x0000,0x0000, 0x0B5C,0x0000,0x0000, 0x0B5D,0x0000,0x0000,
0x0B5E,0x0000,0x0000, 0x0B5F,0x0000,0x0000, 0x0B60,0x0000,0x0000,
0x0B61,0x0000,0x0000, 0x0B62,0x0000,0x0000, 0x0B63,0x0000,0x0000,
0x0B64,0x0000,0x0000, 0x0B65,0x0000,0x0000, 0x0B66,0x0000,0x0000,
0x0B67,0x0000,0x0000, 0x0B68,0x0000,0x0000, 0x0B69,0x0000,0x0000,
0x0B6A,0x0000,0x0000, 0x0B6B,0x0000,0x0000, 0x0B6C,0x0000,0x0000,
0x0B6D,0x0000,0x0000, 0x0B6E,0x0000,0x0000, 0x0B6F,0x0000,0x0000,
0x0B70,0x0000,0x0000, 0x0B71,0x0000,0x0000, 0x0B72,0x0000,0x0000,
0x0B73,0x0000,0x0000, 0x0B74,0x0000,0x0000, 0x0B75,0x0000,0x0000,
0x0B76,0x0000,0x0000 };

uint16 page0A0data[]= { /* A000 (2 weights per char) */
0x1EB1,0x0000, 0x1EB2,0x0000, 0x1EB3,0x0000, 0x1EB4,0x0000,
0x1EB5,0x0000, 0x1EB6,0x0000, 0x1EB7,0x0000, 0x1EB8,0x0000,
0x1EB9,0x0000, 0x1EBA,0x0000, 0x1EBB,0x0000, 0x1EBC,0x0000,
0x1EBD,0x0000, 0x1EBE,0x0000, 0x1EBF,0x0000, 0x1EC0,0x0000,
0x1EC1,0x0000, 0x1EC2,0x0000, 0x1EC3,0x0000, 0x1EC4,0x0000,
0x1EC5,0x0000, 0x1EC6,0x0000, 0x1EC7,0x0000, 0x1EC8,0x0000,
0x1EC9,0x0000, 0x1ECA,0x0000, 0x1ECB,0x0000, 0x1ECC,0x0000,
0x1ECD,0x0000, 0x1ECE,0x0000, 0x1ECF,0x0000, 0x1ED0,0x0000,
0x1ED1,0x0000, 0x1ED2,0x0000, 0x1ED3,0x0000, 0x1ED4,0x0000,
0x1ED5,0x0000, 0x1ED6,0x0000, 0x1ED7,0x0000, 0x1ED8,0x0000,
0x1ED9,0x0000, 0x1EDA,0x0000, 0x1EDB,0x0000, 0x1EDC,0x0000,
0x1EDD,0x0000, 0x1EDE,0x0000, 0x1EDF,0x0000, 0x1EE0,0x0000,
0x1EE1,0x0000, 0x1EE2,0x0000, 0x1EE3,0x0000, 0x1EE4,0x0000,
0x1EE5,0x0000, 0x1EE6,0x0000, 0x1EE7,0x0000, 0x1EE8,0x0000,
0x1EE9,0x0000, 0x1EEA,0x0000, 0x1EEB,0x0000, 0x1EEC,0x0000,
0x1EED,0x0000, 0x1EEE,0x0000, 0x1EEF,0x0000, 0x1EF0,0x0000,
0x1EF1,0x0000, 0x1EF2,0x0000, 0x1EF3,0x0000, 0x1EF4,0x0000,
0x1EF5,0x0000, 0x1EF6,0x0000, 0x1EF7,0x0000, 0x1EF8,0x0000,
0x1EF9,0x0000, 0x1EFA,0x0000, 0x1EFB,0x0000, 0x1EFC,0x0000,
0x1EFD,0x0000, 0x1EFE,0x0000, 0x1EFF,0x0000, 0x1F00,0x0000,
0x1F01,0x0000, 0x1F02,0x0000, 0x1F03,0x0000, 0x1F04,0x0000,
0x1F05,0x0000, 0x1F06,0x0000, 0x1F07,0x0000, 0x1F08,0x0000,
0x1F09,0x0000, 0x1F0A,0x0000, 0x1F0B,0x0000, 0x1F0C,0x0000,
0x1F0D,0x0000, 0x1F0E,0x0000, 0x1F0F,0x0000, 0x1F10,0x0000,
0x1F11,0x0000, 0x1F12,0x0000, 0x1F13,0x0000, 0x1F14,0x0000,
0x1F15,0x0000, 0x1F16,0x0000, 0x1F17,0x0000, 0x1F18,0x0000,
0x1F19,0x0000, 0x1F1A,0x0000, 0x1F1B,0x0000, 0x1F1C,0x0000,
0x1F1D,0x0000, 0x1F1E,0x0000, 0x1F1F,0x0000, 0x1F20,0x0000,
0x1F21,0x0000, 0x1F22,0x0000, 0x1F23,0x0000, 0x1F24,0x0000,
0x1F25,0x0000, 0x1F26,0x0000, 0x1F27,0x0000, 0x1F28,0x0000,
0x1F29,0x0000, 0x1F2A,0x0000, 0x1F2B,0x0000, 0x1F2C,0x0000,
0x1F2D,0x0000, 0x1F2E,0x0000, 0x1F2F,0x0000, 0x1F30,0x0000,
0x1F31,0x0000, 0x1F32,0x0000, 0x1F33,0x0000, 0x1F34,0x0000,
0x1F35,0x0000, 0x1F36,0x0000, 0x1F37,0x0000, 0x1F38,0x0000,
0x1F39,0x0000, 0x1F3A,0x0000, 0x1F3B,0x0000, 0x1F3C,0x0000,
0x1F3D,0x0000, 0x1F3E,0x0000, 0x1F3F,0x0000, 0x1F40,0x0000,
0x1F41,0x0000, 0x1F42,0x0000, 0x1F43,0x0000, 0x1F44,0x0000,
0x1F45,0x0000, 0x1F46,0x0000, 0x1F47,0x0000, 0x1F48,0x0000,
0x1F49,0x0000, 0x1F4A,0x0000, 0x1F4B,0x0000, 0x1F4C,0x0000,
0x1F4D,0x0000, 0x1F4E,0x0000, 0x1F4F,0x0000, 0x1F50,0x0000,
0x1F51,0x0000, 0x1F52,0x0000, 0x1F53,0x0000, 0x1F54,0x0000,
0x1F55,0x0000, 0x1F56,0x0000, 0x1F57,0x0000, 0x1F58,0x0000,
0x1F59,0x0000, 0x1F5A,0x0000, 0x1F5B,0x0000, 0x1F5C,0x0000,
0x1F5D,0x0000, 0x1F5E,0x0000, 0x1F5F,0x0000, 0x1F60,0x0000,
0x1F61,0x0000, 0x1F62,0x0000, 0x1F63,0x0000, 0x1F64,0x0000,
0x1F65,0x0000, 0x1F66,0x0000, 0x1F67,0x0000, 0x1F68,0x0000,
0x1F69,0x0000, 0x1F6A,0x0000, 0x1F6B,0x0000, 0x1F6C,0x0000,
0x1F6D,0x0000, 0x1F6E,0x0000, 0x1F6F,0x0000, 0x1F70,0x0000,
0x1F71,0x0000, 0x1F72,0x0000, 0x1F73,0x0000, 0x1F74,0x0000,
0x1F75,0x0000, 0x1F76,0x0000, 0x1F77,0x0000, 0x1F78,0x0000,
0x1F79,0x0000, 0x1F7A,0x0000, 0x1F7B,0x0000, 0x1F7C,0x0000,
0x1F7D,0x0000, 0x1F7E,0x0000, 0x1F7F,0x0000, 0x1F80,0x0000,
0x1F81,0x0000, 0x1F82,0x0000, 0x1F83,0x0000, 0x1F84,0x0000,
0x1F85,0x0000, 0x1F86,0x0000, 0x1F87,0x0000, 0x1F88,0x0000,
0x1F89,0x0000, 0x1F8A,0x0000, 0x1F8B,0x0000, 0x1F8C,0x0000,
0x1F8D,0x0000, 0x1F8E,0x0000, 0x1F8F,0x0000, 0x1F90,0x0000,
0x1F91,0x0000, 0x1F92,0x0000, 0x1F93,0x0000, 0x1F94,0x0000,
0x1F95,0x0000, 0x1F96,0x0000, 0x1F97,0x0000, 0x1F98,0x0000,
0x1F99,0x0000, 0x1F9A,0x0000, 0x1F9B,0x0000, 0x1F9C,0x0000,
0x1F9D,0x0000, 0x1F9E,0x0000, 0x1F9F,0x0000, 0x1FA0,0x0000,
0x1FA1,0x0000, 0x1FA2,0x0000, 0x1FA3,0x0000, 0x1FA4,0x0000,
0x1FA5,0x0000, 0x1FA6,0x0000, 0x1FA7,0x0000, 0x1FA8,0x0000,
0x1FA9,0x0000, 0x1FAA,0x0000, 0x1FAB,0x0000, 0x1FAC,0x0000,
0x1FAD,0x0000, 0x1FAE,0x0000, 0x1FAF,0x0000, 0x1FB0,0x0000
};

uint16 page0A1data[]= { /* A100 (2 weights per char) */
0x1FB1,0x0000, 0x1FB2,0x0000, 0x1FB3,0x0000, 0x1FB4,0x0000,
0x1FB5,0x0000, 0x1FB6,0x0000, 0x1FB7,0x0000, 0x1FB8,0x0000,
0x1FB9,0x0000, 0x1FBA,0x0000, 0x1FBB,0x0000, 0x1FBC,0x0000,
0x1FBD,0x0000, 0x1FBE,0x0000, 0x1FBF,0x0000, 0x1FC0,0x0000,
0x1FC1,0x0000, 0x1FC2,0x0000, 0x1FC3,0x0000, 0x1FC4,0x0000,
0x1FC5,0x0000, 0x1FC6,0x0000, 0x1FC7,0x0000, 0x1FC8,0x0000,
0x1FC9,0x0000, 0x1FCA,0x0000, 0x1FCB,0x0000, 0x1FCC,0x0000,
0x1FCD,0x0000, 0x1FCE,0x0000, 0x1FCF,0x0000, 0x1FD0,0x0000,
0x1FD1,0x0000, 0x1FD2,0x0000, 0x1FD3,0x0000, 0x1FD4,0x0000,
0x1FD5,0x0000, 0x1FD6,0x0000, 0x1FD7,0x0000, 0x1FD8,0x0000,
0x1FD9,0x0000, 0x1FDA,0x0000, 0x1FDB,0x0000, 0x1FDC,0x0000,
0x1FDD,0x0000, 0x1FDE,0x0000, 0x1FDF,0x0000, 0x1FE0,0x0000,
0x1FE1,0x0000, 0x1FE2,0x0000, 0x1FE3,0x0000, 0x1FE4,0x0000,
0x1FE5,0x0000, 0x1FE6,0x0000, 0x1FE7,0x0000, 0x1FE8,0x0000,
0x1FE9,0x0000, 0x1FEA,0x0000, 0x1FEB,0x0000, 0x1FEC,0x0000,
0x1FED,0x0000, 0x1FEE,0x0000, 0x1FEF,0x0000, 0x1FF0,0x0000,
0x1FF1,0x0000, 0x1FF2,0x0000, 0x1FF3,0x0000, 0x1FF4,0x0000,
0x1FF5,0x0000, 0x1FF6,0x0000, 0x1FF7,0x0000, 0x1FF8,0x0000,
0x1FF9,0x0000, 0x1FFA,0x0000, 0x1FFB,0x0000, 0x1FFC,0x0000,
0x1FFD,0x0000, 0x1FFE,0x0000, 0x1FFF,0x0000, 0x2000,0x0000,
0x2001,0x0000, 0x2002,0x0000, 0x2003,0x0000, 0x2004,0x0000,
0x2005,0x0000, 0x2006,0x0000, 0x2007,0x0000, 0x2008,0x0000,
0x2009,0x0000, 0x200A,0x0000, 0x200B,0x0000, 0x200C,0x0000,
0x200D,0x0000, 0x200E,0x0000, 0x200F,0x0000, 0x2010,0x0000,
0x2011,0x0000, 0x2012,0x0000, 0x2013,0x0000, 0x2014,0x0000,
0x2015,0x0000, 0x2016,0x0000, 0x2017,0x0000, 0x2018,0x0000,
0x2019,0x0000, 0x201A,0x0000, 0x201B,0x0000, 0x201C,0x0000,
0x201D,0x0000, 0x201E,0x0000, 0x201F,0x0000, 0x2020,0x0000,
0x2021,0x0000, 0x2022,0x0000, 0x2023,0x0000, 0x2024,0x0000,
0x2025,0x0000, 0x2026,0x0000, 0x2027,0x0000, 0x2028,0x0000,
0x2029,0x0000, 0x202A,0x0000, 0x202B,0x0000, 0x202C,0x0000,
0x202D,0x0000, 0x202E,0x0000, 0x202F,0x0000, 0x2030,0x0000,
0x2031,0x0000, 0x2032,0x0000, 0x2033,0x0000, 0x2034,0x0000,
0x2035,0x0000, 0x2036,0x0000, 0x2037,0x0000, 0x2038,0x0000,
0x2039,0x0000, 0x203A,0x0000, 0x203B,0x0000, 0x203C,0x0000,
0x203D,0x0000, 0x203E,0x0000, 0x203F,0x0000, 0x2040,0x0000,
0x2041,0x0000, 0x2042,0x0000, 0x2043,0x0000, 0x2044,0x0000,
0x2045,0x0000, 0x2046,0x0000, 0x2047,0x0000, 0x2048,0x0000,
0x2049,0x0000, 0x204A,0x0000, 0x204B,0x0000, 0x204C,0x0000,
0x204D,0x0000, 0x204E,0x0000, 0x204F,0x0000, 0x2050,0x0000,
0x2051,0x0000, 0x2052,0x0000, 0x2053,0x0000, 0x2054,0x0000,
0x2055,0x0000, 0x2056,0x0000, 0x2057,0x0000, 0x2058,0x0000,
0x2059,0x0000, 0x205A,0x0000, 0x205B,0x0000, 0x205C,0x0000,
0x205D,0x0000, 0x205E,0x0000, 0x205F,0x0000, 0x2060,0x0000,
0x2061,0x0000, 0x2062,0x0000, 0x2063,0x0000, 0x2064,0x0000,
0x2065,0x0000, 0x2066,0x0000, 0x2067,0x0000, 0x2068,0x0000,
0x2069,0x0000, 0x206A,0x0000, 0x206B,0x0000, 0x206C,0x0000,
0x206D,0x0000, 0x206E,0x0000, 0x206F,0x0000, 0x2070,0x0000,
0x2071,0x0000, 0x2072,0x0000, 0x2073,0x0000, 0x2074,0x0000,
0x2075,0x0000, 0x2076,0x0000, 0x2077,0x0000, 0x2078,0x0000,
0x2079,0x0000, 0x207A,0x0000, 0x207B,0x0000, 0x207C,0x0000,
0x207D,0x0000, 0x207E,0x0000, 0x207F,0x0000, 0x2080,0x0000,
0x2081,0x0000, 0x2082,0x0000, 0x2083,0x0000, 0x2084,0x0000,
0x2085,0x0000, 0x2086,0x0000, 0x2087,0x0000, 0x2088,0x0000,
0x2089,0x0000, 0x208A,0x0000, 0x208B,0x0000, 0x208C,0x0000,
0x208D,0x0000, 0x208E,0x0000, 0x208F,0x0000, 0x2090,0x0000,
0x2091,0x0000, 0x2092,0x0000, 0x2093,0x0000, 0x2094,0x0000,
0x2095,0x0000, 0x2096,0x0000, 0x2097,0x0000, 0x2098,0x0000,
0x2099,0x0000, 0x209A,0x0000, 0x209B,0x0000, 0x209C,0x0000,
0x209D,0x0000, 0x209E,0x0000, 0x209F,0x0000, 0x20A0,0x0000,
0x20A1,0x0000, 0x20A2,0x0000, 0x20A3,0x0000, 0x20A4,0x0000,
0x20A5,0x0000, 0x20A6,0x0000, 0x20A7,0x0000, 0x20A8,0x0000,
0x20A9,0x0000, 0x20AA,0x0000, 0x20AB,0x0000, 0x20AC,0x0000,
0x20AD,0x0000, 0x20AE,0x0000, 0x20AF,0x0000, 0x20B0,0x0000
};

uint16 page0A2data[]= { /* A200 (2 weights per char) */
0x20B1,0x0000, 0x20B2,0x0000, 0x20B3,0x0000, 0x20B4,0x0000,
0x20B5,0x0000, 0x20B6,0x0000, 0x20B7,0x0000, 0x20B8,0x0000,
0x20B9,0x0000, 0x20BA,0x0000, 0x20BB,0x0000, 0x20BC,0x0000,
0x20BD,0x0000, 0x20BE,0x0000, 0x20BF,0x0000, 0x20C0,0x0000,
0x20C1,0x0000, 0x20C2,0x0000, 0x20C3,0x0000, 0x20C4,0x0000,
0x20C5,0x0000, 0x20C6,0x0000, 0x20C7,0x0000, 0x20C8,0x0000,
0x20C9,0x0000, 0x20CA,0x0000, 0x20CB,0x0000, 0x20CC,0x0000,
0x20CD,0x0000, 0x20CE,0x0000, 0x20CF,0x0000, 0x20D0,0x0000,
0x20D1,0x0000, 0x20D2,0x0000, 0x20D3,0x0000, 0x20D4,0x0000,
0x20D5,0x0000, 0x20D6,0x0000, 0x20D7,0x0000, 0x20D8,0x0000,
0x20D9,0x0000, 0x20DA,0x0000, 0x20DB,0x0000, 0x20DC,0x0000,
0x20DD,0x0000, 0x20DE,0x0000, 0x20DF,0x0000, 0x20E0,0x0000,
0x20E1,0x0000, 0x20E2,0x0000, 0x20E3,0x0000, 0x20E4,0x0000,
0x20E5,0x0000, 0x20E6,0x0000, 0x20E7,0x0000, 0x20E8,0x0000,
0x20E9,0x0000, 0x20EA,0x0000, 0x20EB,0x0000, 0x20EC,0x0000,
0x20ED,0x0000, 0x20EE,0x0000, 0x20EF,0x0000, 0x20F0,0x0000,
0x20F1,0x0000, 0x20F2,0x0000, 0x20F3,0x0000, 0x20F4,0x0000,
0x20F5,0x0000, 0x20F6,0x0000, 0x20F7,0x0000, 0x20F8,0x0000,
0x20F9,0x0000, 0x20FA,0x0000, 0x20FB,0x0000, 0x20FC,0x0000,
0x20FD,0x0000, 0x20FE,0x0000, 0x20FF,0x0000, 0x2100,0x0000,
0x2101,0x0000, 0x2102,0x0000, 0x2103,0x0000, 0x2104,0x0000,
0x2105,0x0000, 0x2106,0x0000, 0x2107,0x0000, 0x2108,0x0000,
0x2109,0x0000, 0x210A,0x0000, 0x210B,0x0000, 0x210C,0x0000,
0x210D,0x0000, 0x210E,0x0000, 0x210F,0x0000, 0x2110,0x0000,
0x2111,0x0000, 0x2112,0x0000, 0x2113,0x0000, 0x2114,0x0000,
0x2115,0x0000, 0x2116,0x0000, 0x2117,0x0000, 0x2118,0x0000,
0x2119,0x0000, 0x211A,0x0000, 0x211B,0x0000, 0x211C,0x0000,
0x211D,0x0000, 0x211E,0x0000, 0x211F,0x0000, 0x2120,0x0000,
0x2121,0x0000, 0x2122,0x0000, 0x2123,0x0000, 0x2124,0x0000,
0x2125,0x0000, 0x2126,0x0000, 0x2127,0x0000, 0x2128,0x0000,
0x2129,0x0000, 0x212A,0x0000, 0x212B,0x0000, 0x212C,0x0000,
0x212D,0x0000, 0x212E,0x0000, 0x212F,0x0000, 0x2130,0x0000,
0x2131,0x0000, 0x2132,0x0000, 0x2133,0x0000, 0x2134,0x0000,
0x2135,0x0000, 0x2136,0x0000, 0x2137,0x0000, 0x2138,0x0000,
0x2139,0x0000, 0x213A,0x0000, 0x213B,0x0000, 0x213C,0x0000,
0x213D,0x0000, 0x213E,0x0000, 0x213F,0x0000, 0x2140,0x0000,
0x2141,0x0000, 0x2142,0x0000, 0x2143,0x0000, 0x2144,0x0000,
0x2145,0x0000, 0x2146,0x0000, 0x2147,0x0000, 0x2148,0x0000,
0x2149,0x0000, 0x214A,0x0000, 0x214B,0x0000, 0x214C,0x0000,
0x214D,0x0000, 0x214E,0x0000, 0x214F,0x0000, 0x2150,0x0000,
0x2151,0x0000, 0x2152,0x0000, 0x2153,0x0000, 0x2154,0x0000,
0x2155,0x0000, 0x2156,0x0000, 0x2157,0x0000, 0x2158,0x0000,
0x2159,0x0000, 0x215A,0x0000, 0x215B,0x0000, 0x215C,0x0000,
0x215D,0x0000, 0x215E,0x0000, 0x215F,0x0000, 0x2160,0x0000,
0x2161,0x0000, 0x2162,0x0000, 0x2163,0x0000, 0x2164,0x0000,
0x2165,0x0000, 0x2166,0x0000, 0x2167,0x0000, 0x2168,0x0000,
0x2169,0x0000, 0x216A,0x0000, 0x216B,0x0000, 0x216C,0x0000,
0x216D,0x0000, 0x216E,0x0000, 0x216F,0x0000, 0x2170,0x0000,
0x2171,0x0000, 0x2172,0x0000, 0x2173,0x0000, 0x2174,0x0000,
0x2175,0x0000, 0x2176,0x0000, 0x2177,0x0000, 0x2178,0x0000,
0x2179,0x0000, 0x217A,0x0000, 0x217B,0x0000, 0x217C,0x0000,
0x217D,0x0000, 0x217E,0x0000, 0x217F,0x0000, 0x2180,0x0000,
0x2181,0x0000, 0x2182,0x0000, 0x2183,0x0000, 0x2184,0x0000,
0x2185,0x0000, 0x2186,0x0000, 0x2187,0x0000, 0x2188,0x0000,
0x2189,0x0000, 0x218A,0x0000, 0x218B,0x0000, 0x218C,0x0000,
0x218D,0x0000, 0x218E,0x0000, 0x218F,0x0000, 0x2190,0x0000,
0x2191,0x0000, 0x2192,0x0000, 0x2193,0x0000, 0x2194,0x0000,
0x2195,0x0000, 0x2196,0x0000, 0x2197,0x0000, 0x2198,0x0000,
0x2199,0x0000, 0x219A,0x0000, 0x219B,0x0000, 0x219C,0x0000,
0x219D,0x0000, 0x219E,0x0000, 0x219F,0x0000, 0x21A0,0x0000,
0x21A1,0x0000, 0x21A2,0x0000, 0x21A3,0x0000, 0x21A4,0x0000,
0x21A5,0x0000, 0x21A6,0x0000, 0x21A7,0x0000, 0x21A8,0x0000,
0x21A9,0x0000, 0x21AA,0x0000, 0x21AB,0x0000, 0x21AC,0x0000,
0x21AD,0x0000, 0x21AE,0x0000, 0x21AF,0x0000, 0x21B0,0x0000
};

uint16 page0A3data[]= { /* A300 (2 weights per char) */
0x21B1,0x0000, 0x21B2,0x0000, 0x21B3,0x0000, 0x21B4,0x0000,
0x21B5,0x0000, 0x21B6,0x0000, 0x21B7,0x0000, 0x21B8,0x0000,
0x21B9,0x0000, 0x21BA,0x0000, 0x21BB,0x0000, 0x21BC,0x0000,
0x21BD,0x0000, 0x21BE,0x0000, 0x21BF,0x0000, 0x21C0,0x0000,
0x21C1,0x0000, 0x21C2,0x0000, 0x21C3,0x0000, 0x21C4,0x0000,
0x21C5,0x0000, 0x21C6,0x0000, 0x21C7,0x0000, 0x21C8,0x0000,
0x21C9,0x0000, 0x21CA,0x0000, 0x21CB,0x0000, 0x21CC,0x0000,
0x21CD,0x0000, 0x21CE,0x0000, 0x21CF,0x0000, 0x21D0,0x0000,
0x21D1,0x0000, 0x21D2,0x0000, 0x21D3,0x0000, 0x21D4,0x0000,
0x21D5,0x0000, 0x21D6,0x0000, 0x21D7,0x0000, 0x21D8,0x0000,
0x21D9,0x0000, 0x21DA,0x0000, 0x21DB,0x0000, 0x21DC,0x0000,
0x21DD,0x0000, 0x21DE,0x0000, 0x21DF,0x0000, 0x21E0,0x0000,
0x21E1,0x0000, 0x21E2,0x0000, 0x21E3,0x0000, 0x21E4,0x0000,
0x21E5,0x0000, 0x21E6,0x0000, 0x21E7,0x0000, 0x21E8,0x0000,
0x21E9,0x0000, 0x21EA,0x0000, 0x21EB,0x0000, 0x21EC,0x0000,
0x21ED,0x0000, 0x21EE,0x0000, 0x21EF,0x0000, 0x21F0,0x0000,
0x21F1,0x0000, 0x21F2,0x0000, 0x21F3,0x0000, 0x21F4,0x0000,
0x21F5,0x0000, 0x21F6,0x0000, 0x21F7,0x0000, 0x21F8,0x0000,
0x21F9,0x0000, 0x21FA,0x0000, 0x21FB,0x0000, 0x21FC,0x0000,
0x21FD,0x0000, 0x21FE,0x0000, 0x21FF,0x0000, 0x2200,0x0000,
0x2201,0x0000, 0x2202,0x0000, 0x2203,0x0000, 0x2204,0x0000,
0x2205,0x0000, 0x2206,0x0000, 0x2207,0x0000, 0x2208,0x0000,
0x2209,0x0000, 0x220A,0x0000, 0x220B,0x0000, 0x220C,0x0000,
0x220D,0x0000, 0x220E,0x0000, 0x220F,0x0000, 0x2210,0x0000,
0x2211,0x0000, 0x2212,0x0000, 0x2213,0x0000, 0x2214,0x0000,
0x2215,0x0000, 0x2216,0x0000, 0x2217,0x0000, 0x2218,0x0000,
0x2219,0x0000, 0x221A,0x0000, 0x221B,0x0000, 0x221C,0x0000,
0x221D,0x0000, 0x221E,0x0000, 0x221F,0x0000, 0x2220,0x0000,
0x2221,0x0000, 0x2222,0x0000, 0x2223,0x0000, 0x2224,0x0000,
0x2225,0x0000, 0x2226,0x0000, 0x2227,0x0000, 0x2228,0x0000,
0x2229,0x0000, 0x222A,0x0000, 0x222B,0x0000, 0x222C,0x0000,
0x222D,0x0000, 0x222E,0x0000, 0x222F,0x0000, 0x2230,0x0000,
0x2231,0x0000, 0x2232,0x0000, 0x2233,0x0000, 0x2234,0x0000,
0x2235,0x0000, 0x2236,0x0000, 0x2237,0x0000, 0x2238,0x0000,
0x2239,0x0000, 0x223A,0x0000, 0x223B,0x0000, 0x223C,0x0000,
0x223D,0x0000, 0x223E,0x0000, 0x223F,0x0000, 0x2240,0x0000,
0x2241,0x0000, 0x2242,0x0000, 0x2243,0x0000, 0x2244,0x0000,
0x2245,0x0000, 0x2246,0x0000, 0x2247,0x0000, 0x2248,0x0000,
0x2249,0x0000, 0x224A,0x0000, 0x224B,0x0000, 0x224C,0x0000,
0x224D,0x0000, 0x224E,0x0000, 0x224F,0x0000, 0x2250,0x0000,
0x2251,0x0000, 0x2252,0x0000, 0x2253,0x0000, 0x2254,0x0000,
0x2255,0x0000, 0x2256,0x0000, 0x2257,0x0000, 0x2258,0x0000,
0x2259,0x0000, 0x225A,0x0000, 0x225B,0x0000, 0x225C,0x0000,
0x225D,0x0000, 0x225E,0x0000, 0x225F,0x0000, 0x2260,0x0000,
0x2261,0x0000, 0x2262,0x0000, 0x2263,0x0000, 0x2264,0x0000,
0x2265,0x0000, 0x2266,0x0000, 0x2267,0x0000, 0x2268,0x0000,
0x2269,0x0000, 0x226A,0x0000, 0x226B,0x0000, 0x226C,0x0000,
0x226D,0x0000, 0x226E,0x0000, 0x226F,0x0000, 0x2270,0x0000,
0x2271,0x0000, 0x2272,0x0000, 0x2273,0x0000, 0x2274,0x0000,
0x2275,0x0000, 0x2276,0x0000, 0x2277,0x0000, 0x2278,0x0000,
0x2279,0x0000, 0x227A,0x0000, 0x227B,0x0000, 0x227C,0x0000,
0x227D,0x0000, 0x227E,0x0000, 0x227F,0x0000, 0x2280,0x0000,
0x2281,0x0000, 0x2282,0x0000, 0x2283,0x0000, 0x2284,0x0000,
0x2285,0x0000, 0x2286,0x0000, 0x2287,0x0000, 0x2288,0x0000,
0x2289,0x0000, 0x228A,0x0000, 0x228B,0x0000, 0x228C,0x0000,
0x228D,0x0000, 0x228E,0x0000, 0x228F,0x0000, 0x2290,0x0000,
0x2291,0x0000, 0x2292,0x0000, 0x2293,0x0000, 0x2294,0x0000,
0x2295,0x0000, 0x2296,0x0000, 0x2297,0x0000, 0x2298,0x0000,
0x2299,0x0000, 0x229A,0x0000, 0x229B,0x0000, 0x229C,0x0000,
0x229D,0x0000, 0x229E,0x0000, 0x229F,0x0000, 0x22A0,0x0000,
0x22A1,0x0000, 0x22A2,0x0000, 0x22A3,0x0000, 0x22A4,0x0000,
0x22A5,0x0000, 0x22A6,0x0000, 0x22A7,0x0000, 0x22A8,0x0000,
0x22A9,0x0000, 0x22AA,0x0000, 0x22AB,0x0000, 0x22AC,0x0000,
0x22AD,0x0000, 0x22AE,0x0000, 0x22AF,0x0000, 0x22B0,0x0000
};

uint16 page0A4data[]= { /* A400 (3 weights per char) */
0x22B1,0x0000,0x0000, 0x22B2,0x0000,0x0000, 0x22B3,0x0000,0x0000,
0x22B4,0x0000,0x0000, 0x22B5,0x0000,0x0000, 0x22B6,0x0000,0x0000,
0x22B7,0x0000,0x0000, 0x22B8,0x0000,0x0000, 0x22B9,0x0000,0x0000,
0x22BA,0x0000,0x0000, 0x22BB,0x0000,0x0000, 0x22BC,0x0000,0x0000,
0x22BD,0x0000,0x0000, 0x22BE,0x0000,0x0000, 0x22BF,0x0000,0x0000,
0x22C0,0x0000,0x0000, 0x22C1,0x0000,0x0000, 0x22C2,0x0000,0x0000,
0x22C3,0x0000,0x0000, 0x22C4,0x0000,0x0000, 0x22C5,0x0000,0x0000,
0x22C6,0x0000,0x0000, 0x22C7,0x0000,0x0000, 0x22C8,0x0000,0x0000,
0x22C9,0x0000,0x0000, 0x22CA,0x0000,0x0000, 0x22CB,0x0000,0x0000,
0x22CC,0x0000,0x0000, 0x22CD,0x0000,0x0000, 0x22CE,0x0000,0x0000,
0x22CF,0x0000,0x0000, 0x22D0,0x0000,0x0000, 0x22D1,0x0000,0x0000,
0x22D2,0x0000,0x0000, 0x22D3,0x0000,0x0000, 0x22D4,0x0000,0x0000,
0x22D5,0x0000,0x0000, 0x22D6,0x0000,0x0000, 0x22D7,0x0000,0x0000,
0x22D8,0x0000,0x0000, 0x22D9,0x0000,0x0000, 0x22DA,0x0000,0x0000,
0x22DB,0x0000,0x0000, 0x22DC,0x0000,0x0000, 0x22DD,0x0000,0x0000,
0x22DE,0x0000,0x0000, 0x22DF,0x0000,0x0000, 0x22E0,0x0000,0x0000,
0x22E1,0x0000,0x0000, 0x22E2,0x0000,0x0000, 0x22E3,0x0000,0x0000,
0x22E4,0x0000,0x0000, 0x22E5,0x0000,0x0000, 0x22E6,0x0000,0x0000,
0x22E7,0x0000,0x0000, 0x22E8,0x0000,0x0000, 0x22E9,0x0000,0x0000,
0x22EA,0x0000,0x0000, 0x22EB,0x0000,0x0000, 0x22EC,0x0000,0x0000,
0x22ED,0x0000,0x0000, 0x22EE,0x0000,0x0000, 0x22EF,0x0000,0x0000,
0x22F0,0x0000,0x0000, 0x22F1,0x0000,0x0000, 0x22F2,0x0000,0x0000,
0x22F3,0x0000,0x0000, 0x22F4,0x0000,0x0000, 0x22F5,0x0000,0x0000,
0x22F6,0x0000,0x0000, 0x22F7,0x0000,0x0000, 0x22F8,0x0000,0x0000,
0x22F9,0x0000,0x0000, 0x22FA,0x0000,0x0000, 0x22FB,0x0000,0x0000,
0x22FC,0x0000,0x0000, 0x22FD,0x0000,0x0000, 0x22FE,0x0000,0x0000,
0x22FF,0x0000,0x0000, 0x2300,0x0000,0x0000, 0x2301,0x0000,0x0000,
0x2302,0x0000,0x0000, 0x2303,0x0000,0x0000, 0x2304,0x0000,0x0000,
0x2305,0x0000,0x0000, 0x2306,0x0000,0x0000, 0x2307,0x0000,0x0000,
0x2308,0x0000,0x0000, 0x2309,0x0000,0x0000, 0x230A,0x0000,0x0000,
0x230B,0x0000,0x0000, 0x230C,0x0000,0x0000, 0x230D,0x0000,0x0000,
0x230E,0x0000,0x0000, 0x230F,0x0000,0x0000, 0x2310,0x0000,0x0000,
0x2311,0x0000,0x0000, 0x2312,0x0000,0x0000, 0x2313,0x0000,0x0000,
0x2314,0x0000,0x0000, 0x2315,0x0000,0x0000, 0x2316,0x0000,0x0000,
0x2317,0x0000,0x0000, 0x2318,0x0000,0x0000, 0x2319,0x0000,0x0000,
0x231A,0x0000,0x0000, 0x231B,0x0000,0x0000, 0x231C,0x0000,0x0000,
0x231D,0x0000,0x0000, 0x231E,0x0000,0x0000, 0x231F,0x0000,0x0000,
0x2320,0x0000,0x0000, 0x2321,0x0000,0x0000, 0x2322,0x0000,0x0000,
0x2323,0x0000,0x0000, 0x2324,0x0000,0x0000, 0x2325,0x0000,0x0000,
0x2326,0x0000,0x0000, 0x2327,0x0000,0x0000, 0x2328,0x0000,0x0000,
0x2329,0x0000,0x0000, 0x232A,0x0000,0x0000, 0x232B,0x0000,0x0000,
0x232C,0x0000,0x0000, 0x232D,0x0000,0x0000, 0x232E,0x0000,0x0000,
0x232F,0x0000,0x0000, 0x2330,0x0000,0x0000, 0x2331,0x0000,0x0000,
0x2332,0x0000,0x0000, 0x2333,0x0000,0x0000, 0x2334,0x0000,0x0000,
0x2335,0x0000,0x0000, 0x2336,0x0000,0x0000, 0x2337,0x0000,0x0000,
0x2338,0x0000,0x0000, 0x2339,0x0000,0x0000, 0x233A,0x0000,0x0000,
0x233B,0x0000,0x0000, 0x233C,0x0000,0x0000, 0x233D,0x0000,0x0000,
0xFBC1,0xA48D,0x0000, 0xFBC1,0xA48E,0x0000, 0xFBC1,0xA48F,0x0000,
0x0BCE,0x0000,0x0000, 0x0BCF,0x0000,0x0000, 0x0BD0,0x0000,0x0000,
0x0BD1,0x0000,0x0000, 0x0BD2,0x0000,0x0000, 0x0BD3,0x0000,0x0000,
0x0BD4,0x0000,0x0000, 0x0BD5,0x0000,0x0000, 0x0BD6,0x0000,0x0000,
0x0BD7,0x0000,0x0000, 0x0BD8,0x0000,0x0000, 0x0BD9,0x0000,0x0000,
0x0BDA,0x0000,0x0000, 0x0BDB,0x0000,0x0000, 0x0BDC,0x0000,0x0000,
0x0BDD,0x0000,0x0000, 0x0BDE,0x0000,0x0000, 0x0BDF,0x0000,0x0000,
0x0BE0,0x0000,0x0000, 0x0BE1,0x0000,0x0000, 0x0BE2,0x0000,0x0000,
0x0BE3,0x0000,0x0000, 0x0BE4,0x0000,0x0000, 0x0BE5,0x0000,0x0000,
0x0BE6,0x0000,0x0000, 0x0BE7,0x0000,0x0000, 0x0BE8,0x0000,0x0000,
0x0BE9,0x0000,0x0000, 0x0BEA,0x0000,0x0000, 0x0BEB,0x0000,0x0000,
0x0BEC,0x0000,0x0000, 0x0BED,0x0000,0x0000, 0x0BEE,0x0000,0x0000,
0x0BEF,0x0000,0x0000, 0x0BF0,0x0000,0x0000, 0x0BF1,0x0000,0x0000,
0x0BF2,0x0000,0x0000, 0x0BF3,0x0000,0x0000, 0x0BF4,0x0000,0x0000,
0x0BF5,0x0000,0x0000, 0x0BF6,0x0000,0x0000, 0x0BF7,0x0000,0x0000,
0x0BF8,0x0000,0x0000, 0x0BF9,0x0000,0x0000, 0x0BFA,0x0000,0x0000,
0x0BFB,0x0000,0x0000, 0x0BFC,0x0000,0x0000, 0x0BFD,0x0000,0x0000,
0x0BFE,0x0000,0x0000, 0x0BFF,0x0000,0x0000, 0x0C00,0x0000,0x0000,
0x0C01,0x0000,0x0000, 0x0C02,0x0000,0x0000, 0x0C03,0x0000,0x0000,
0x0C04,0x0000,0x0000, 0xFBC1,0xA4C7,0x0000, 0xFBC1,0xA4C8,0x0000,
0xFBC1,0xA4C9,0x0000, 0xFBC1,0xA4CA,0x0000, 0xFBC1,0xA4CB,0x0000,
0xFBC1,0xA4CC,0x0000, 0xFBC1,0xA4CD,0x0000, 0xFBC1,0xA4CE,0x0000,
0xFBC1,0xA4CF,0x0000, 0xFBC1,0xA4D0,0x0000, 0xFBC1,0xA4D1,0x0000,
0xFBC1,0xA4D2,0x0000, 0xFBC1,0xA4D3,0x0000, 0xFBC1,0xA4D4,0x0000,
0xFBC1,0xA4D5,0x0000, 0xFBC1,0xA4D6,0x0000, 0xFBC1,0xA4D7,0x0000,
0xFBC1,0xA4D8,0x0000, 0xFBC1,0xA4D9,0x0000, 0xFBC1,0xA4DA,0x0000,
0xFBC1,0xA4DB,0x0000, 0xFBC1,0xA4DC,0x0000, 0xFBC1,0xA4DD,0x0000,
0xFBC1,0xA4DE,0x0000, 0xFBC1,0xA4DF,0x0000, 0xFBC1,0xA4E0,0x0000,
0xFBC1,0xA4E1,0x0000, 0xFBC1,0xA4E2,0x0000, 0xFBC1,0xA4E3,0x0000,
0xFBC1,0xA4E4,0x0000, 0xFBC1,0xA4E5,0x0000, 0xFBC1,0xA4E6,0x0000,
0xFBC1,0xA4E7,0x0000, 0xFBC1,0xA4E8,0x0000, 0xFBC1,0xA4E9,0x0000,
0xFBC1,0xA4EA,0x0000, 0xFBC1,0xA4EB,0x0000, 0xFBC1,0xA4EC,0x0000,
0xFBC1,0xA4ED,0x0000, 0xFBC1,0xA4EE,0x0000, 0xFBC1,0xA4EF,0x0000,
0xFBC1,0xA4F0,0x0000, 0xFBC1,0xA4F1,0x0000, 0xFBC1,0xA4F2,0x0000,
0xFBC1,0xA4F3,0x0000, 0xFBC1,0xA4F4,0x0000, 0xFBC1,0xA4F5,0x0000,
0xFBC1,0xA4F6,0x0000, 0xFBC1,0xA4F7,0x0000, 0xFBC1,0xA4F8,0x0000,
0xFBC1,0xA4F9,0x0000, 0xFBC1,0xA4FA,0x0000, 0xFBC1,0xA4FB,0x0000,
0xFBC1,0xA4FC,0x0000, 0xFBC1,0xA4FD,0x0000, 0xFBC1,0xA4FE,0x0000,
0xFBC1,0xA4FF,0x0000 };

uint16 page0F9data[]= { /* F900 (3 weights per char) */
0xFB41,0x8C48,0x0000, 0xFB40,0xE6F4,0x0000, 0xFB41,0x8ECA,0x0000,
0xFB41,0x8CC8,0x0000, 0xFB40,0xEED1,0x0000, 0xFB40,0xCE32,0x0000,
0xFB40,0xD3E5,0x0000, 0xFB41,0x9F9C,0x0000, 0xFB41,0x9F9C,0x0000,
0xFB40,0xD951,0x0000, 0xFB41,0x91D1,0x0000, 0xFB40,0xD587,0x0000,
0xFB40,0xD948,0x0000, 0xFB40,0xE1F6,0x0000, 0xFB40,0xF669,0x0000,
0xFB40,0xFF85,0x0000, 0xFB41,0x863F,0x0000, 0xFB41,0x87BA,0x0000,
0xFB41,0x88F8,0x0000, 0xFB41,0x908F,0x0000, 0xFB40,0xEA02,0x0000,
0xFB40,0xED1B,0x0000, 0xFB40,0xF0D9,0x0000, 0xFB40,0xF3DE,0x0000,
0xFB41,0x843D,0x0000, 0xFB41,0x916A,0x0000, 0xFB41,0x99F1,0x0000,
0xFB40,0xCE82,0x0000, 0xFB40,0xD375,0x0000, 0xFB40,0xEB04,0x0000,
0xFB40,0xF21B,0x0000, 0xFB41,0x862D,0x0000, 0xFB41,0x9E1E,0x0000,
0xFB40,0xDD50,0x0000, 0xFB40,0xEFEB,0x0000, 0xFB41,0x85CD,0x0000,
0xFB41,0x8964,0x0000, 0xFB40,0xE2C9,0x0000, 0xFB41,0x81D8,0x0000,
0xFB41,0x881F,0x0000, 0xFB40,0xDECA,0x0000, 0xFB40,0xE717,0x0000,
0xFB40,0xED6A,0x0000, 0xFB40,0xF2FC,0x0000, 0xFB41,0x90CE,0x0000,
0xFB40,0xCF86,0x0000, 0xFB40,0xD1B7,0x0000, 0xFB40,0xD2DE,0x0000,
0xFB40,0xE4C4,0x0000, 0xFB40,0xEAD3,0x0000, 0xFB40,0xF210,0x0000,
0xFB40,0xF6E7,0x0000, 0xFB41,0x8001,0x0000, 0xFB41,0x8606,0x0000,
0xFB41,0x865C,0x0000, 0xFB41,0x8DEF,0x0000, 0xFB41,0x9732,0x0000,
0xFB41,0x9B6F,0x0000, 0xFB41,0x9DFA,0x0000, 0xFB40,0xF88C,0x0000,
0xFB40,0xF97F,0x0000, 0xFB40,0xFDA0,0x0000, 0xFB41,0x83C9,0x0000,
0xFB41,0x9304,0x0000, 0xFB41,0x9E7F,0x0000, 0xFB41,0x8AD6,0x0000,
0xFB40,0xD8DF,0x0000, 0xFB40,0xDF04,0x0000, 0xFB40,0xFC60,0x0000,
0xFB41,0x807E,0x0000, 0xFB40,0xF262,0x0000, 0xFB40,0xF8CA,0x0000,
0xFB41,0x8CC2,0x0000, 0xFB41,0x96F7,0x0000, 0xFB40,0xD8D8,0x0000,
0xFB40,0xDC62,0x0000, 0xFB40,0xEA13,0x0000, 0xFB40,0xEDDA,0x0000,
0xFB40,0xEF0F,0x0000, 0xFB40,0xFD2F,0x0000, 0xFB40,0xFE37,0x0000,
0xFB41,0x964B,0x0000, 0xFB40,0xD2D2,0x0000, 0xFB41,0x808B,0x0000,
0xFB40,0xD1DC,0x0000, 0xFB40,0xD1CC,0x0000, 0xFB40,0xFA1C,0x0000,
0xFB40,0xFDBE,0x0000, 0xFB41,0x83F1,0x0000, 0xFB41,0x9675,0x0000,
0xFB41,0x8B80,0x0000, 0xFB40,0xE2CF,0x0000, 0xFB40,0xEA02,0x0000,
0xFB41,0x8AFE,0x0000, 0xFB40,0xCE39,0x0000, 0xFB40,0xDBE7,0x0000,
0xFB40,0xE012,0x0000, 0xFB40,0xF387,0x0000, 0xFB40,0xF570,0x0000,
0xFB40,0xD317,0x0000, 0xFB40,0xF8FB,0x0000, 0xFB40,0xCFBF,0x0000,
0xFB40,0xDFA9,0x0000, 0xFB40,0xCE0D,0x0000, 0xFB40,0xECCC,0x0000,
0xFB40,0xE578,0x0000, 0xFB40,0xFD22,0x0000, 0xFB40,0xD3C3,0x0000,
0xFB40,0xD85E,0x0000, 0xFB40,0xF701,0x0000, 0xFB41,0x8449,0x0000,
0xFB41,0x8AAA,0x0000, 0xFB40,0xEBBA,0x0000, 0xFB41,0x8FB0,0x0000,
0xFB40,0xEC88,0x0000, 0xFB40,0xE2FE,0x0000, 0xFB41,0x82E5,0x0000,
0xFB40,0xE3A0,0x0000, 0xFB40,0xF565,0x0000, 0xFB40,0xCEAE,0x0000,
0xFB40,0xD169,0x0000, 0xFB40,0xD1C9,0x0000, 0xFB40,0xE881,0x0000,
0xFB40,0xFCE7,0x0000, 0xFB41,0x826F,0x0000, 0xFB41,0x8AD2,0x0000,
0xFB41,0x91CF,0x0000, 0xFB40,0xD2F5,0x0000, 0xFB40,0xD442,0x0000,
0xFB40,0xD973,0x0000, 0xFB40,0xDEEC,0x0000, 0xFB40,0xE5C5,0x0000,
0xFB40,0xEFFE,0x0000, 0xFB40,0xF92A,0x0000, 0xFB41,0x95AD,0x0000,
0xFB41,0x9A6A,0x0000, 0xFB41,0x9E97,0x0000, 0xFB41,0x9ECE,0x0000,
0xFB40,0xD29B,0x0000, 0xFB40,0xE6C6,0x0000, 0xFB40,0xEB77,0x0000,
0xFB41,0x8F62,0x0000, 0xFB40,0xDE74,0x0000, 0xFB40,0xE190,0x0000,
0xFB40,0xE200,0x0000, 0xFB40,0xE49A,0x0000, 0xFB40,0xEF23,0x0000,
0xFB40,0xF149,0x0000, 0xFB40,0xF489,0x0000, 0xFB40,0xF9CA,0x0000,
0xFB40,0xFDF4,0x0000, 0xFB41,0x806F,0x0000, 0xFB41,0x8F26,0x0000,
0xFB41,0x84EE,0x0000, 0xFB41,0x9023,0x0000, 0xFB41,0x934A,0x0000,
0xFB40,0xD217,0x0000, 0xFB40,0xD2A3,0x0000, 0xFB40,0xD4BD,0x0000,
0xFB40,0xF0C8,0x0000, 0xFB41,0x88C2,0x0000, 0xFB41,0x8AAA,0x0000,
0xFB40,0xDEC9,0x0000, 0xFB40,0xDFF5,0x0000, 0xFB40,0xE37B,0x0000,
0xFB40,0xEBAE,0x0000, 0xFB40,0xFC3E,0x0000, 0xFB40,0xF375,0x0000,
0xFB40,0xCEE4,0x0000, 0xFB40,0xD6F9,0x0000, 0xFB40,0xDBE7,0x0000,
0xFB40,0xDDBA,0x0000, 0xFB40,0xE01C,0x0000, 0xFB40,0xF3B2,0x0000,
0xFB40,0xF469,0x0000, 0xFB40,0xFF9A,0x0000, 0xFB41,0x8046,0x0000,
0xFB41,0x9234,0x0000, 0xFB41,0x96F6,0x0000, 0xFB41,0x9748,0x0000,
0xFB41,0x9818,0x0000, 0xFB40,0xCF8B,0x0000, 0xFB40,0xF9AE,0x0000,
0xFB41,0x91B4,0x0000, 0xFB41,0x96B8,0x0000, 0xFB40,0xE0E1,0x0000,
0xFB40,0xCE86,0x0000, 0xFB40,0xD0DA,0x0000, 0xFB40,0xDBEE,0x0000,
0xFB40,0xDC3F,0x0000, 0xFB40,0xE599,0x0000, 0xFB40,0xEA02,0x0000,
0xFB40,0xF1CE,0x0000, 0xFB40,0xF642,0x0000, 0xFB41,0x84FC,0x0000,
0xFB41,0x907C,0x0000, 0xFB41,0x9F8D,0x0000, 0xFB40,0xE688,0x0000,
0xFB41,0x962E,0x0000, 0xFB40,0xD289,0x0000, 0xFB40,0xE77B,0x0000,
0xFB40,0xE7F3,0x0000, 0xFB40,0xED41,0x0000, 0xFB40,0xEE9C,0x0000,
0xFB40,0xF409,0x0000, 0xFB40,0xF559,0x0000, 0xFB40,0xF86B,0x0000,
0xFB40,0xFD10,0x0000, 0xFB41,0x985E,0x0000, 0xFB40,0xD16D,0x0000,
0xFB40,0xE22E,0x0000, 0xFB41,0x9678,0x0000, 0xFB40,0xD02B,0x0000,
0xFB40,0xDD19,0x0000, 0xFB40,0xEDEA,0x0000, 0xFB41,0x8F2A,0x0000,
0xFB40,0xDF8B,0x0000, 0xFB40,0xE144,0x0000, 0xFB40,0xE817,0x0000,
0xFB40,0xF387,0x0000, 0xFB41,0x9686,0x0000, 0xFB40,0xD229,0x0000,
0xFB40,0xD40F,0x0000, 0xFB40,0xDC65,0x0000, 0xFB40,0xE613,0x0000,
0xFB40,0xE74E,0x0000, 0xFB40,0xE8A8,0x0000, 0xFB40,0xECE5,0x0000,
0xFB40,0xF406,0x0000, 0xFB40,0xF5E2,0x0000, 0xFB40,0xFF79,0x0000,
0xFB41,0x88CF,0x0000, 0xFB41,0x88E1,0x0000, 0xFB41,0x91CC,0x0000,
0xFB41,0x96E2,0x0000, 0xFB40,0xD33F,0x0000, 0xFB40,0xEEBA,0x0000,
0xFB40,0xD41D,0x0000, 0xFB40,0xF1D0,0x0000, 0xFB40,0xF498,0x0000,
0xFB41,0x85FA,0x0000, 0xFB41,0x96A3,0x0000, 0xFB41,0x9C57,0x0000,
0xFB41,0x9E9F,0x0000, 0xFB40,0xE797,0x0000, 0xFB40,0xEDCB,0x0000,
0xFB41,0x81E8,0x0000, 0xFB40,0xFACB,0x0000, 0xFB40,0xFB20,0x0000,
0xFB40,0xFC92,0x0000, 0xFB40,0xF2C0,0x0000, 0xFB40,0xF099,0x0000,
0xFB41,0x8B58,0x0000, 0xFB40,0xCEC0,0x0000, 0xFB41,0x8336,0x0000,
0xFB40,0xD23A,0x0000 };

uint16 page0FAdata[]= { /* FA00 (3 weights per char) */
0xFB40,0xD207,0x0000, 0xFB40,0xDEA6,0x0000, 0xFB40,0xE2D3,0x0000,
0xFB40,0xFCD6,0x0000, 0xFB40,0xDB85,0x0000, 0xFB40,0xED1E,0x0000,
0xFB40,0xE6B4,0x0000, 0xFB41,0x8F3B,0x0000, 0xFB41,0x884C,0x0000,
0xFB41,0x964D,0x0000, 0xFB41,0x898B,0x0000, 0xFB40,0xDED3,0x0000,
0xFB40,0xD140,0x0000, 0xFB40,0xD5C0,0x0000, 0xFB41,0xFA0E,0x0000,
0xFB41,0xFA0F,0x0000, 0xFB40,0xD85A,0x0000, 0xFB41,0xFA11,0x0000,
0xFB40,0xE674,0x0000, 0xFB41,0xFA13,0x0000, 0xFB41,0xFA14,0x0000,
0xFB40,0xD1DE,0x0000, 0xFB40,0xF32A,0x0000, 0xFB40,0xF6CA,0x0000,
0xFB40,0xF93C,0x0000, 0xFB40,0xF95E,0x0000, 0xFB40,0xF965,0x0000,
0xFB40,0xF98F,0x0000, 0xFB41,0x9756,0x0000, 0xFB40,0xFCBE,0x0000,
0xFB40,0xFFBD,0x0000, 0xFB41,0xFA1F,0x0000, 0xFB41,0x8612,0x0000,
0xFB41,0xFA21,0x0000, 0xFB41,0x8AF8,0x0000, 0xFB41,0xFA23,0x0000,
0xFB41,0xFA24,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x90FD,0x0000,
0xFB41,0xFA27,0x0000, 0xFB41,0xFA28,0x0000, 0xFB41,0xFA29,0x0000,
0xFB41,0x98EF,0x0000, 0xFB41,0x98FC,0x0000, 0xFB41,0x9928,0x0000,
0xFB41,0x9DB4,0x0000, 0xFBC1,0xFA2E,0x0000, 0xFBC1,0xFA2F,0x0000,
0xFB40,0xCFAE,0x0000, 0xFB40,0xD0E7,0x0000, 0xFB40,0xD14D,0x0000,
0xFB40,0xD2C9,0x0000, 0xFB40,0xD2E4,0x0000, 0xFB40,0xD351,0x0000,
0xFB40,0xD59D,0x0000, 0xFB40,0xD606,0x0000, 0xFB40,0xD668,0x0000,
0xFB40,0xD840,0x0000, 0xFB40,0xD8A8,0x0000, 0xFB40,0xDC64,0x0000,
0xFB40,0xDC6E,0x0000, 0xFB40,0xE094,0x0000, 0xFB40,0xE168,0x0000,
0xFB40,0xE18E,0x0000, 0xFB40,0xE1F2,0x0000, 0xFB40,0xE54F,0x0000,
0xFB40,0xE5E2,0x0000, 0xFB40,0xE691,0x0000, 0xFB40,0xE885,0x0000,
0xFB40,0xED77,0x0000, 0xFB40,0xEE1A,0x0000, 0xFB40,0xEF22,0x0000,
0xFB40,0xF16E,0x0000, 0xFB40,0xF22B,0x0000, 0xFB40,0xF422,0x0000,
0xFB40,0xF891,0x0000, 0xFB40,0xF93E,0x0000, 0xFB40,0xF949,0x0000,
0xFB40,0xF948,0x0000, 0xFB40,0xF950,0x0000, 0xFB40,0xF956,0x0000,
0xFB40,0xF95D,0x0000, 0xFB40,0xF98D,0x0000, 0xFB40,0xF98E,0x0000,
0xFB40,0xFA40,0x0000, 0xFB40,0xFA81,0x0000, 0xFB40,0xFBC0,0x0000,
0xFB40,0xFDF4,0x0000, 0xFB40,0xFE09,0x0000, 0xFB40,0xFE41,0x0000,
0xFB40,0xFF72,0x0000, 0xFB41,0x8005,0x0000, 0xFB41,0x81ED,0x0000,
0xFB41,0x8279,0x0000, 0xFB41,0x8279,0x0000, 0xFB41,0x8457,0x0000,
0xFB41,0x8910,0x0000, 0xFB41,0x8996,0x0000, 0xFB41,0x8B01,0x0000,
0xFB41,0x8B39,0x0000, 0xFB41,0x8CD3,0x0000, 0xFB41,0x8D08,0x0000,
0xFB41,0x8FB6,0x0000, 0xFB41,0x9038,0x0000, 0xFB41,0x96E3,0x0000,
0xFB41,0x97FF,0x0000, 0xFB41,0x983B,0x0000, 0xFBC1,0xFA6B,0x0000,
0xFBC1,0xFA6C,0x0000, 0xFBC1,0xFA6D,0x0000, 0xFBC1,0xFA6E,0x0000,
0xFBC1,0xFA6F,0x0000, 0xFBC1,0xFA70,0x0000, 0xFBC1,0xFA71,0x0000,
0xFBC1,0xFA72,0x0000, 0xFBC1,0xFA73,0x0000, 0xFBC1,0xFA74,0x0000,
0xFBC1,0xFA75,0x0000, 0xFBC1,0xFA76,0x0000, 0xFBC1,0xFA77,0x0000,
0xFBC1,0xFA78,0x0000, 0xFBC1,0xFA79,0x0000, 0xFBC1,0xFA7A,0x0000,
0xFBC1,0xFA7B,0x0000, 0xFBC1,0xFA7C,0x0000, 0xFBC1,0xFA7D,0x0000,
0xFBC1,0xFA7E,0x0000, 0xFBC1,0xFA7F,0x0000, 0xFBC1,0xFA80,0x0000,
0xFBC1,0xFA81,0x0000, 0xFBC1,0xFA82,0x0000, 0xFBC1,0xFA83,0x0000,
0xFBC1,0xFA84,0x0000, 0xFBC1,0xFA85,0x0000, 0xFBC1,0xFA86,0x0000,
0xFBC1,0xFA87,0x0000, 0xFBC1,0xFA88,0x0000, 0xFBC1,0xFA89,0x0000,
0xFBC1,0xFA8A,0x0000, 0xFBC1,0xFA8B,0x0000, 0xFBC1,0xFA8C,0x0000,
0xFBC1,0xFA8D,0x0000, 0xFBC1,0xFA8E,0x0000, 0xFBC1,0xFA8F,0x0000,
0xFBC1,0xFA90,0x0000, 0xFBC1,0xFA91,0x0000, 0xFBC1,0xFA92,0x0000,
0xFBC1,0xFA93,0x0000, 0xFBC1,0xFA94,0x0000, 0xFBC1,0xFA95,0x0000,
0xFBC1,0xFA96,0x0000, 0xFBC1,0xFA97,0x0000, 0xFBC1,0xFA98,0x0000,
0xFBC1,0xFA99,0x0000, 0xFBC1,0xFA9A,0x0000, 0xFBC1,0xFA9B,0x0000,
0xFBC1,0xFA9C,0x0000, 0xFBC1,0xFA9D,0x0000, 0xFBC1,0xFA9E,0x0000,
0xFBC1,0xFA9F,0x0000, 0xFBC1,0xFAA0,0x0000, 0xFBC1,0xFAA1,0x0000,
0xFBC1,0xFAA2,0x0000, 0xFBC1,0xFAA3,0x0000, 0xFBC1,0xFAA4,0x0000,
0xFBC1,0xFAA5,0x0000, 0xFBC1,0xFAA6,0x0000, 0xFBC1,0xFAA7,0x0000,
0xFBC1,0xFAA8,0x0000, 0xFBC1,0xFAA9,0x0000, 0xFBC1,0xFAAA,0x0000,
0xFBC1,0xFAAB,0x0000, 0xFBC1,0xFAAC,0x0000, 0xFBC1,0xFAAD,0x0000,
0xFBC1,0xFAAE,0x0000, 0xFBC1,0xFAAF,0x0000, 0xFBC1,0xFAB0,0x0000,
0xFBC1,0xFAB1,0x0000, 0xFBC1,0xFAB2,0x0000, 0xFBC1,0xFAB3,0x0000,
0xFBC1,0xFAB4,0x0000, 0xFBC1,0xFAB5,0x0000, 0xFBC1,0xFAB6,0x0000,
0xFBC1,0xFAB7,0x0000, 0xFBC1,0xFAB8,0x0000, 0xFBC1,0xFAB9,0x0000,
0xFBC1,0xFABA,0x0000, 0xFBC1,0xFABB,0x0000, 0xFBC1,0xFABC,0x0000,
0xFBC1,0xFABD,0x0000, 0xFBC1,0xFABE,0x0000, 0xFBC1,0xFABF,0x0000,
0xFBC1,0xFAC0,0x0000, 0xFBC1,0xFAC1,0x0000, 0xFBC1,0xFAC2,0x0000,
0xFBC1,0xFAC3,0x0000, 0xFBC1,0xFAC4,0x0000, 0xFBC1,0xFAC5,0x0000,
0xFBC1,0xFAC6,0x0000, 0xFBC1,0xFAC7,0x0000, 0xFBC1,0xFAC8,0x0000,
0xFBC1,0xFAC9,0x0000, 0xFBC1,0xFACA,0x0000, 0xFBC1,0xFACB,0x0000,
0xFBC1,0xFACC,0x0000, 0xFBC1,0xFACD,0x0000, 0xFBC1,0xFACE,0x0000,
0xFBC1,0xFACF,0x0000, 0xFBC1,0xFAD0,0x0000, 0xFBC1,0xFAD1,0x0000,
0xFBC1,0xFAD2,0x0000, 0xFBC1,0xFAD3,0x0000, 0xFBC1,0xFAD4,0x0000,
0xFBC1,0xFAD5,0x0000, 0xFBC1,0xFAD6,0x0000, 0xFBC1,0xFAD7,0x0000,
0xFBC1,0xFAD8,0x0000, 0xFBC1,0xFAD9,0x0000, 0xFBC1,0xFADA,0x0000,
0xFBC1,0xFADB,0x0000, 0xFBC1,0xFADC,0x0000, 0xFBC1,0xFADD,0x0000,
0xFBC1,0xFADE,0x0000, 0xFBC1,0xFADF,0x0000, 0xFBC1,0xFAE0,0x0000,
0xFBC1,0xFAE1,0x0000, 0xFBC1,0xFAE2,0x0000, 0xFBC1,0xFAE3,0x0000,
0xFBC1,0xFAE4,0x0000, 0xFBC1,0xFAE5,0x0000, 0xFBC1,0xFAE6,0x0000,
0xFBC1,0xFAE7,0x0000, 0xFBC1,0xFAE8,0x0000, 0xFBC1,0xFAE9,0x0000,
0xFBC1,0xFAEA,0x0000, 0xFBC1,0xFAEB,0x0000, 0xFBC1,0xFAEC,0x0000,
0xFBC1,0xFAED,0x0000, 0xFBC1,0xFAEE,0x0000, 0xFBC1,0xFAEF,0x0000,
0xFBC1,0xFAF0,0x0000, 0xFBC1,0xFAF1,0x0000, 0xFBC1,0xFAF2,0x0000,
0xFBC1,0xFAF3,0x0000, 0xFBC1,0xFAF4,0x0000, 0xFBC1,0xFAF5,0x0000,
0xFBC1,0xFAF6,0x0000, 0xFBC1,0xFAF7,0x0000, 0xFBC1,0xFAF8,0x0000,
0xFBC1,0xFAF9,0x0000, 0xFBC1,0xFAFA,0x0000, 0xFBC1,0xFAFB,0x0000,
0xFBC1,0xFAFC,0x0000, 0xFBC1,0xFAFD,0x0000, 0xFBC1,0xFAFE,0x0000,
0xFBC1,0xFAFF,0x0000 };

uint16 page0FBdata[]= { /* FB00 (4 weights per char) */
0x0EB9,0x0EB9,0x0000,0x0000, 0x0EB9,0x0EFB,0x0000,0x0000,
0x0EB9,0x0F2E,0x0000,0x0000, 0x0EB9,0x0EB9,0x0EFB,0x0000,
0x0EB9,0x0EB9,0x0F2E,0x0000, 0x0FEA,0x1002,0x0000,0x0000,
0x0FEA,0x1002,0x0000,0x0000, 0xFBC1,0xFB07,0x0000,0x0000,
0xFBC1,0xFB08,0x0000,0x0000, 0xFBC1,0xFB09,0x0000,0x0000,
0xFBC1,0xFB0A,0x0000,0x0000, 0xFBC1,0xFB0B,0x0000,0x0000,
0xFBC1,0xFB0C,0x0000,0x0000, 0xFBC1,0xFB0D,0x0000,0x0000,
0xFBC1,0xFB0E,0x0000,0x0000, 0xFBC1,0xFB0F,0x0000,0x0000,
0xFBC1,0xFB10,0x0000,0x0000, 0xFBC1,0xFB11,0x0000,0x0000,
0xFBC1,0xFB12,0x0000,0x0000, 0x131D,0x131F,0x0000,0x0000,
0x131D,0x130E,0x0000,0x0000, 0x131D,0x1314,0x0000,0x0000,
0x1327,0x131F,0x0000,0x0000, 0x131D,0x1316,0x0000,0x0000,
0xFBC1,0xFB18,0x0000,0x0000, 0xFBC1,0xFB19,0x0000,0x0000,
0xFBC1,0xFB1A,0x0000,0x0000, 0xFBC1,0xFB1B,0x0000,0x0000,
0xFBC1,0xFB1C,0x0000,0x0000, 0x133A,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000, 0x133A,0x133A,0x0000,0x0000,
0x1340,0x0000,0x0000,0x0000, 0x1331,0x0000,0x0000,0x0000,
0x1334,0x0000,0x0000,0x0000, 0x1335,0x0000,0x0000,0x0000,
0x133B,0x0000,0x0000,0x0000, 0x133C,0x0000,0x0000,0x0000,
0x133D,0x0000,0x0000,0x0000, 0x1344,0x0000,0x0000,0x0000,
0x1346,0x0000,0x0000,0x0000, 0x0428,0x0000,0x0000,0x0000,
0x1345,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1345,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000, 0x1331,0x0000,0x0000,0x0000,
0x1331,0x0000,0x0000,0x0000, 0x1332,0x0000,0x0000,0x0000,
0x1333,0x0000,0x0000,0x0000, 0x1334,0x0000,0x0000,0x0000,
0x1335,0x0000,0x0000,0x0000, 0x1336,0x0000,0x0000,0x0000,
0x1337,0x0000,0x0000,0x0000, 0xFBC1,0xFB37,0x0000,0x0000,
0x1339,0x0000,0x0000,0x0000, 0x133A,0x0000,0x0000,0x0000,
0x133B,0x0000,0x0000,0x0000, 0x133B,0x0000,0x0000,0x0000,
0x133C,0x0000,0x0000,0x0000, 0xFBC1,0xFB3D,0x0000,0x0000,
0x133D,0x0000,0x0000,0x0000, 0xFBC1,0xFB3F,0x0000,0x0000,
0x133E,0x0000,0x0000,0x0000, 0x133F,0x0000,0x0000,0x0000,
0xFBC1,0xFB42,0x0000,0x0000, 0x1341,0x0000,0x0000,0x0000,
0x1341,0x0000,0x0000,0x0000, 0xFBC1,0xFB45,0x0000,0x0000,
0x1342,0x0000,0x0000,0x0000, 0x1343,0x0000,0x0000,0x0000,
0x1344,0x0000,0x0000,0x0000, 0x1345,0x0000,0x0000,0x0000,
0x1346,0x0000,0x0000,0x0000, 0x1336,0x0000,0x0000,0x0000,
0x1332,0x0000,0x0000,0x0000, 0x133B,0x0000,0x0000,0x0000,
0x1341,0x0000,0x0000,0x0000, 0x1331,0x133C,0x0000,0x0000,
0x134B,0x0000,0x0000,0x0000, 0x134B,0x0000,0x0000,0x0000,
0x1353,0x0000,0x0000,0x0000, 0x1353,0x0000,0x0000,0x0000,
0x1353,0x0000,0x0000,0x0000, 0x1353,0x0000,0x0000,0x0000,
0x1354,0x0000,0x0000,0x0000, 0x1354,0x0000,0x0000,0x0000,
0x1354,0x0000,0x0000,0x0000, 0x1354,0x0000,0x0000,0x0000,
0x1355,0x0000,0x0000,0x0000, 0x1355,0x0000,0x0000,0x0000,
0x1355,0x0000,0x0000,0x0000, 0x1355,0x0000,0x0000,0x0000,
0x135A,0x0000,0x0000,0x0000, 0x135A,0x0000,0x0000,0x0000,
0x135A,0x0000,0x0000,0x0000, 0x135A,0x0000,0x0000,0x0000,
0x135D,0x0000,0x0000,0x0000, 0x135D,0x0000,0x0000,0x0000,
0x135D,0x0000,0x0000,0x0000, 0x135D,0x0000,0x0000,0x0000,
0x1359,0x0000,0x0000,0x0000, 0x1359,0x0000,0x0000,0x0000,
0x1359,0x0000,0x0000,0x0000, 0x1359,0x0000,0x0000,0x0000,
0x1397,0x0000,0x0000,0x0000, 0x1397,0x0000,0x0000,0x0000,
0x1397,0x0000,0x0000,0x0000, 0x1397,0x0000,0x0000,0x0000,
0x1399,0x0000,0x0000,0x0000, 0x1399,0x0000,0x0000,0x0000,
0x1399,0x0000,0x0000,0x0000, 0x1399,0x0000,0x0000,0x0000,
0x1360,0x0000,0x0000,0x0000, 0x1360,0x0000,0x0000,0x0000,
0x1360,0x0000,0x0000,0x0000, 0x1360,0x0000,0x0000,0x0000,
0x135F,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000,
0x135F,0x0000,0x0000,0x0000, 0x135F,0x0000,0x0000,0x0000,
0x1361,0x0000,0x0000,0x0000, 0x1361,0x0000,0x0000,0x0000,
0x1361,0x0000,0x0000,0x0000, 0x1361,0x0000,0x0000,0x0000,
0x1363,0x0000,0x0000,0x0000, 0x1363,0x0000,0x0000,0x0000,
0x1363,0x0000,0x0000,0x0000, 0x1363,0x0000,0x0000,0x0000,
0x1370,0x0000,0x0000,0x0000, 0x1370,0x0000,0x0000,0x0000,
0x136F,0x0000,0x0000,0x0000, 0x136F,0x0000,0x0000,0x0000,
0x1371,0x0000,0x0000,0x0000, 0x1371,0x0000,0x0000,0x0000,
0x136B,0x0000,0x0000,0x0000, 0x136B,0x0000,0x0000,0x0000,
0x137E,0x0000,0x0000,0x0000, 0x137E,0x0000,0x0000,0x0000,
0x1377,0x0000,0x0000,0x0000, 0x1377,0x0000,0x0000,0x0000,
0x139F,0x0000,0x0000,0x0000, 0x139F,0x0000,0x0000,0x0000,
0x139F,0x0000,0x0000,0x0000, 0x139F,0x0000,0x0000,0x0000,
0x13A5,0x0000,0x0000,0x0000, 0x13A5,0x0000,0x0000,0x0000,
0x13A5,0x0000,0x0000,0x0000, 0x13A5,0x0000,0x0000,0x0000,
0x13A9,0x0000,0x0000,0x0000, 0x13A9,0x0000,0x0000,0x0000,
0x13A9,0x0000,0x0000,0x0000, 0x13A9,0x0000,0x0000,0x0000,
0x13A7,0x0000,0x0000,0x0000, 0x13A7,0x0000,0x0000,0x0000,
0x13A7,0x0000,0x0000,0x0000, 0x13A7,0x0000,0x0000,0x0000,
0x13B2,0x0000,0x0000,0x0000, 0x13B2,0x0000,0x0000,0x0000,
0x13B3,0x0000,0x0000,0x0000, 0x13B3,0x0000,0x0000,0x0000,
0x13B3,0x0000,0x0000,0x0000, 0x13B3,0x0000,0x0000,0x0000,
0x13BC,0x0000,0x0000,0x0000, 0x13BC,0x0000,0x0000,0x0000,
0x13B9,0x0000,0x0000,0x0000, 0x13B9,0x0000,0x0000,0x0000,
0x13B9,0x0000,0x0000,0x0000, 0x13B9,0x0000,0x0000,0x0000,
0x13B8,0x0000,0x0000,0x0000, 0x13B8,0x0000,0x0000,0x0000,
0x13B8,0x0000,0x0000,0x0000, 0x13B8,0x0000,0x0000,0x0000,
0x13CE,0x0000,0x0000,0x0000, 0x13CE,0x0000,0x0000,0x0000,
0x13CE,0x0000,0x0000,0x0000, 0x13CE,0x0000,0x0000,0x0000,
0xFBC1,0xFBB2,0x0000,0x0000, 0xFBC1,0xFBB3,0x0000,0x0000,
0xFBC1,0xFBB4,0x0000,0x0000, 0xFBC1,0xFBB5,0x0000,0x0000,
0xFBC1,0xFBB6,0x0000,0x0000, 0xFBC1,0xFBB7,0x0000,0x0000,
0xFBC1,0xFBB8,0x0000,0x0000, 0xFBC1,0xFBB9,0x0000,0x0000,
0xFBC1,0xFBBA,0x0000,0x0000, 0xFBC1,0xFBBB,0x0000,0x0000,
0xFBC1,0xFBBC,0x0000,0x0000, 0xFBC1,0xFBBD,0x0000,0x0000,
0xFBC1,0xFBBE,0x0000,0x0000, 0xFBC1,0xFBBF,0x0000,0x0000,
0xFBC1,0xFBC0,0x0000,0x0000, 0xFBC1,0xFBC1,0x0000,0x0000,
0xFBC1,0xFBC2,0x0000,0x0000, 0xFBC1,0xFBC3,0x0000,0x0000,
0xFBC1,0xFBC4,0x0000,0x0000, 0xFBC1,0xFBC5,0x0000,0x0000,
0xFBC1,0xFBC6,0x0000,0x0000, 0xFBC1,0xFBC7,0x0000,0x0000,
0xFBC1,0xFBC8,0x0000,0x0000, 0xFBC1,0xFBC9,0x0000,0x0000,
0xFBC1,0xFBCA,0x0000,0x0000, 0xFBC1,0xFBCB,0x0000,0x0000,
0xFBC1,0xFBCC,0x0000,0x0000, 0xFBC1,0xFBCD,0x0000,0x0000,
0xFBC1,0xFBCE,0x0000,0x0000, 0xFBC1,0xFBCF,0x0000,0x0000,
0xFBC1,0xFBD0,0x0000,0x0000, 0xFBC1,0xFBD1,0x0000,0x0000,
0xFBC1,0xFBD2,0x0000,0x0000, 0x13A3,0x0000,0x0000,0x0000,
0x13A3,0x0000,0x0000,0x0000, 0x13A3,0x0000,0x0000,0x0000,
0x13A3,0x0000,0x0000,0x0000, 0x13C1,0x0000,0x0000,0x0000,
0x13C1,0x0000,0x0000,0x0000, 0x13C0,0x0000,0x0000,0x0000,
0x13C0,0x0000,0x0000,0x0000, 0x13C2,0x0000,0x0000,0x0000,
0x13C2,0x0000,0x0000,0x0000, 0x13C1,0x1347,0x0000,0x0000,
0x13C5,0x0000,0x0000,0x0000, 0x13C5,0x0000,0x0000,0x0000,
0x13BF,0x0000,0x0000,0x0000, 0x13BF,0x0000,0x0000,0x0000,
0x13C3,0x0000,0x0000,0x0000, 0x13C3,0x0000,0x0000,0x0000,
0x13CC,0x0000,0x0000,0x0000, 0x13CC,0x0000,0x0000,0x0000,
0x13CC,0x0000,0x0000,0x0000, 0x13CC,0x0000,0x0000,0x0000,
0x13C7,0x0000,0x0000,0x0000, 0x13C7,0x0000,0x0000,0x0000,
0x134F,0x1350,0x0000,0x0000, 0x134F,0x1350,0x0000,0x0000,
0x134F,0x13BC,0x0000,0x0000, 0x134F,0x13BC,0x0000,0x0000,
0x134F,0x13BD,0x0000,0x0000, 0x134F,0x13BD,0x0000,0x0000,
0x134F,0x13C1,0x0000,0x0000, 0x134F,0x13C1,0x0000,0x0000,
0x134F,0x13C0,0x0000,0x0000, 0x134F,0x13C0,0x0000,0x0000,
0x134F,0x13C2,0x0000,0x0000, 0x134F,0x13C2,0x0000,0x0000,
0x134F,0x13CC,0x0000,0x0000, 0x134F,0x13CC,0x0000,0x0000,
0x134F,0x13CC,0x0000,0x0000, 0x134F,0x13C7,0x0000,0x0000,
0x134F,0x13C7,0x0000,0x0000, 0x134F,0x13C7,0x0000,0x0000,
0x13C9,0x0000,0x0000,0x0000, 0x13C9,0x0000,0x0000,0x0000,
0x13C9,0x0000,0x0000,0x0000, 0x13C9,0x0000,0x0000,0x0000
};

uint16 page0FCdata[]= { /* FC00 (3 weights per char) */
0x134F,0x135E,0x0000, 0x134F,0x1364,0x0000, 0x134F,0x13B0,0x0000,
0x134F,0x13C7,0x0000, 0x134F,0x13C8,0x0000, 0x1352,0x135E,0x0000,
0x1352,0x1364,0x0000, 0x1352,0x1365,0x0000, 0x1352,0x13B0,0x0000,
0x1352,0x13C7,0x0000, 0x1352,0x13C8,0x0000, 0x1357,0x135E,0x0000,
0x1357,0x1364,0x0000, 0x1357,0x1365,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13C7,0x0000, 0x1357,0x13C8,0x0000, 0x1358,0x135E,0x0000,
0x1358,0x13B0,0x0000, 0x1358,0x13C7,0x0000, 0x1358,0x13C8,0x0000,
0x135E,0x1364,0x0000, 0x135E,0x13B0,0x0000, 0x1364,0x135E,0x0000,
0x1364,0x13B0,0x0000, 0x1365,0x135E,0x0000, 0x1365,0x1364,0x0000,
0x1365,0x13B0,0x0000, 0x1381,0x135E,0x0000, 0x1381,0x1364,0x0000,
0x1381,0x1365,0x0000, 0x1381,0x13B0,0x0000, 0x1387,0x1364,0x0000,
0x1387,0x13B0,0x0000, 0x1388,0x135E,0x0000, 0x1388,0x1364,0x0000,
0x1388,0x1365,0x0000, 0x1388,0x13B0,0x0000, 0x138C,0x1364,0x0000,
0x138C,0x13B0,0x0000, 0x138D,0x13B0,0x0000, 0x138F,0x135E,0x0000,
0x138F,0x13B0,0x0000, 0x1390,0x135E,0x0000, 0x1390,0x13B0,0x0000,
0x1393,0x135E,0x0000, 0x1393,0x1364,0x0000, 0x1393,0x1365,0x0000,
0x1393,0x13B0,0x0000, 0x1393,0x13C7,0x0000, 0x1393,0x13C8,0x0000,
0x139B,0x1364,0x0000, 0x139B,0x13B0,0x0000, 0x139B,0x13C7,0x0000,
0x139B,0x13C8,0x0000, 0x139E,0x1350,0x0000, 0x139E,0x135E,0x0000,
0x139E,0x1364,0x0000, 0x139E,0x1365,0x0000, 0x139E,0x13AB,0x0000,
0x139E,0x13B0,0x0000, 0x139E,0x13C7,0x0000, 0x139E,0x13C8,0x0000,
0x13AB,0x135E,0x0000, 0x13AB,0x1364,0x0000, 0x13AB,0x1365,0x0000,
0x13AB,0x13B0,0x0000, 0x13AB,0x13C7,0x0000, 0x13AB,0x13C8,0x0000,
0x13B0,0x135E,0x0000, 0x13B0,0x1364,0x0000, 0x13B0,0x1365,0x0000,
0x13B0,0x13B0,0x0000, 0x13B0,0x13C7,0x0000, 0x13B0,0x13C8,0x0000,
0x13B1,0x135E,0x0000, 0x13B1,0x1364,0x0000, 0x13B1,0x1365,0x0000,
0x13B1,0x13B0,0x0000, 0x13B1,0x13C7,0x0000, 0x13B1,0x13C8,0x0000,
0x13B7,0x135E,0x0000, 0x13B7,0x13B0,0x0000, 0x13B7,0x13C7,0x0000,
0x13B7,0x13C8,0x0000, 0x13C8,0x135E,0x0000, 0x13C8,0x1364,0x0000,
0x13C8,0x1365,0x0000, 0x13C8,0x13B0,0x0000, 0x13C8,0x13C7,0x0000,
0x13C8,0x13C8,0x0000, 0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000,
0x13C7,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x134F,0x1375,0x0000, 0x134F,0x1376,0x0000,
0x134F,0x13B0,0x0000, 0x134F,0x13B1,0x0000, 0x134F,0x13C7,0x0000,
0x134F,0x13C8,0x0000, 0x1352,0x1375,0x0000, 0x1352,0x1376,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B1,0x0000, 0x1352,0x13C7,0x0000,
0x1352,0x13C8,0x0000, 0x1357,0x1375,0x0000, 0x1357,0x1376,0x0000,
0x1357,0x13B0,0x0000, 0x1357,0x13B1,0x0000, 0x1357,0x13C7,0x0000,
0x1357,0x13C8,0x0000, 0x1358,0x1375,0x0000, 0x1358,0x1376,0x0000,
0x1358,0x13B0,0x0000, 0x1358,0x13B1,0x0000, 0x1358,0x13C7,0x0000,
0x1358,0x13C8,0x0000, 0x1393,0x13C7,0x0000, 0x1393,0x13C8,0x0000,
0x139B,0x13C7,0x0000, 0x139B,0x13C8,0x0000, 0x139E,0x1350,0x0000,
0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000, 0x139E,0x13C7,0x0000,
0x139E,0x13C8,0x0000, 0x13AB,0x13B0,0x0000, 0x13AB,0x13C7,0x0000,
0x13AB,0x13C8,0x0000, 0x13B0,0x1350,0x0000, 0x13B0,0x13B0,0x0000,
0x13B1,0x1375,0x0000, 0x13B1,0x1376,0x0000, 0x13B1,0x13B0,0x0000,
0x13B1,0x13B1,0x0000, 0x13B1,0x13C7,0x0000, 0x13B1,0x13C8,0x0000,
0x13C7,0x0000,0x0000, 0x13C8,0x1375,0x0000, 0x13C8,0x1376,0x0000,
0x13C8,0x13B0,0x0000, 0x13C8,0x13B1,0x0000, 0x13C8,0x13C7,0x0000,
0x13C8,0x13C8,0x0000, 0x134F,0x135E,0x0000, 0x134F,0x1364,0x0000,
0x134F,0x1365,0x0000, 0x134F,0x13B0,0x0000, 0x134F,0x13B7,0x0000,
0x1352,0x135E,0x0000, 0x1352,0x1364,0x0000, 0x1352,0x1365,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B7,0x0000, 0x1357,0x135E,0x0000,
0x1357,0x1364,0x0000, 0x1357,0x1365,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13B7,0x0000, 0x1358,0x13B0,0x0000, 0x135E,0x1364,0x0000,
0x135E,0x13B0,0x0000, 0x1364,0x135E,0x0000, 0x1364,0x13B0,0x0000,
0x1365,0x135E,0x0000, 0x1365,0x13B0,0x0000, 0x1381,0x135E,0x0000,
0x1381,0x1364,0x0000, 0x1381,0x1365,0x0000, 0x1381,0x13B0,0x0000,
0x1387,0x1364,0x0000, 0x1387,0x1365,0x0000, 0x1387,0x13B0,0x0000,
0x1388,0x135E,0x0000, 0x1388,0x1364,0x0000, 0x1388,0x1365,0x0000,
0x1388,0x13B0,0x0000, 0x138C,0x1364,0x0000, 0x138D,0x13B0,0x0000,
0x138F,0x135E,0x0000, 0x138F,0x13B0,0x0000, 0x1390,0x135E,0x0000,
0x1390,0x13B0,0x0000, 0x1393,0x135E,0x0000, 0x1393,0x1364,0x0000,
0x1393,0x1365,0x0000, 0x1393,0x13B0,0x0000, 0x139B,0x1364,0x0000,
0x139B,0x13B0,0x0000, 0x139E,0x135E,0x0000, 0x139E,0x1364,0x0000,
0x139E,0x1365,0x0000, 0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000,
0x13AB,0x135E,0x0000, 0x13AB,0x1364,0x0000, 0x13AB,0x1365,0x0000,
0x13AB,0x13B0,0x0000, 0x13AB,0x13B7,0x0000, 0x13B0,0x135E,0x0000,
0x13B0,0x1364,0x0000, 0x13B0,0x1365,0x0000, 0x13B0,0x13B0,0x0000,
0x13B1,0x135E,0x0000, 0x13B1,0x1364,0x0000, 0x13B1,0x1365,0x0000,
0x13B1,0x13B0,0x0000, 0x13B1,0x13B7,0x0000, 0x13B7,0x135E,0x0000,
0x13B7,0x13B0,0x0000, 0x13B7,0x0000,0x0000, 0x13C8,0x135E,0x0000,
0x13C8,0x1364,0x0000, 0x13C8,0x1365,0x0000, 0x13C8,0x13B0,0x0000,
0x13C8,0x13B7,0x0000, 0x134F,0x13B0,0x0000, 0x134F,0x13B7,0x0000,
0x1352,0x13B0,0x0000, 0x1352,0x13B7,0x0000, 0x1357,0x13B0,0x0000,
0x1357,0x13B7,0x0000, 0x1358,0x13B0,0x0000, 0x1358,0x13B7,0x0000,
0x1381,0x13B0,0x0000, 0x1381,0x13B7,0x0000, 0x1382,0x13B0,0x0000,
0x1382,0x13B7,0x0000, 0x139E,0x13AB,0x0000, 0x139E,0x13B0,0x0000,
0x13AB,0x13B0,0x0000, 0x13B1,0x13B0,0x0000, 0x13B1,0x13B7,0x0000,
0x13C8,0x13B0,0x0000, 0x13C8,0x13B7,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x138C,0x13C7,0x0000,
0x138C,0x13C8,0x0000, 0x138F,0x13C7,0x0000, 0x138F,0x13C8,0x0000,
0x1390,0x13C7,0x0000, 0x1390,0x13C8,0x0000, 0x1381,0x13C7,0x0000,
0x1381,0x13C8,0x0000, 0x1382,0x13C7,0x0000, 0x1382,0x13C8,0x0000,
0x1364,0x13C7,0x0000 };

uint16 page0FDdata[]= { /* FD00 (9 weights per char) */
0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138D,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x02C0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x02C1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD40,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD41,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD42,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD43,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD44,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD45,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD46,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD47,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD48,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD49,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4A,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4B,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4C,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD4F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138C,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD90,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFD91,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x1365,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B7,0x13B0,0x135E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B7,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1352,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x135E,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1357,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x1364,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13B0,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1382,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1388,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13C8,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13B0,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x1364,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13AB,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x1364,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1364,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1393,0x13B0,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1352,0x1364,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139E,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x135E,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13B0,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1381,0x1365,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B1,0x135E,0x13C8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDC8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDC9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDCF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDD9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDD,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDDF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE1,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE4,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE5,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDE9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEB,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEC,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDED,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDEF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x13CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x139B,0x13AB,0x13CE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x13AB,0x13AB,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1350,0x139E,0x1352,0x1375,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13B0,0x1364,0x13B0,0x1369,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x138F,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1375,0x1381,0x13BD,0x13AB,0x0000,0x0000,0x0000,0x0000,0x0000,
0x138F,0x13AB,0x13C8,0x13B7,0x0000,0x0000,0x0000,0x0000,0x0000,
0x13BD,0x1381,0x13AB,0x13B0,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1387,0x13AB,0x13C7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFA,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x135E,0x13AB,0x0209,0x135E,0x13AB,0x1350,0x13AB,0x13B7,0x0000,
0x1375,0x13C9,0x1350,0x13AB,0x0000,0x0000,0x0000,0x0000,0x0000,
0x034F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFE,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0xFBC1,0xFDFF,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

uint16 page0FEdata[]= { /* FE00 (3 weights per char) */
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0xFBC1,0xFE10,0x0000, 0xFBC1,0xFE11,0x0000,
0xFBC1,0xFE12,0x0000, 0xFBC1,0xFE13,0x0000, 0xFBC1,0xFE14,0x0000,
0xFBC1,0xFE15,0x0000, 0xFBC1,0xFE16,0x0000, 0xFBC1,0xFE17,0x0000,
0xFBC1,0xFE18,0x0000, 0xFBC1,0xFE19,0x0000, 0xFBC1,0xFE1A,0x0000,
0xFBC1,0xFE1B,0x0000, 0xFBC1,0xFE1C,0x0000, 0xFBC1,0xFE1D,0x0000,
0xFBC1,0xFE1E,0x0000, 0xFBC1,0xFE1F,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC1,0xFE24,0x0000, 0xFBC1,0xFE25,0x0000, 0xFBC1,0xFE26,0x0000,
0xFBC1,0xFE27,0x0000, 0xFBC1,0xFE28,0x0000, 0xFBC1,0xFE29,0x0000,
0xFBC1,0xFE2A,0x0000, 0xFBC1,0xFE2B,0x0000, 0xFBC1,0xFE2C,0x0000,
0xFBC1,0xFE2D,0x0000, 0xFBC1,0xFE2E,0x0000, 0xFBC1,0xFE2F,0x0000,
0x025D,0x025D,0x0000, 0x0228,0x0000,0x0000, 0x0227,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x021B,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x028D,0x0000,0x0000,
0x02B8,0x0000,0x0000, 0x02B9,0x0000,0x0000, 0x02B6,0x0000,0x0000,
0x02B7,0x0000,0x0000, 0x02B0,0x0000,0x0000, 0x02B1,0x0000,0x0000,
0x02AE,0x0000,0x0000, 0x02AF,0x0000,0x0000, 0x02B2,0x0000,0x0000,
0x02B3,0x0000,0x0000, 0x02B4,0x0000,0x0000, 0x02B5,0x0000,0x0000,
0x0238,0x0000,0x0000, 0x0239,0x0000,0x0000, 0x028A,0x0000,0x0000,
0x028B,0x0000,0x0000, 0x0211,0x0000,0x0000, 0x0211,0x0000,0x0000,
0x0211,0x0000,0x0000, 0x0211,0x0000,0x0000, 0x021B,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x021B,0x0000,0x0000, 0x022F,0x0000,0x0000,
0x0237,0x0000,0x0000, 0x025D,0x0000,0x0000, 0xFBC1,0xFE53,0x0000,
0x023A,0x0000,0x0000, 0x023D,0x0000,0x0000, 0x0255,0x0000,0x0000,
0x0251,0x0000,0x0000, 0x0228,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x028D,0x0000,0x0000,
0x02B8,0x0000,0x0000, 0x02B9,0x0000,0x0000, 0x02D2,0x0000,0x0000,
0x02CF,0x0000,0x0000, 0x02C8,0x0000,0x0000, 0x0428,0x0000,0x0000,
0x0221,0x0000,0x0000, 0x042C,0x0000,0x0000, 0x042E,0x0000,0x0000,
0x042D,0x0000,0x0000, 0xFBC1,0xFE67,0x0000, 0x02CE,0x0000,0x0000,
0x0E0F,0x0000,0x0000, 0x02D3,0x0000,0x0000, 0x02C7,0x0000,0x0000,
0xFBC1,0xFE6C,0x0000, 0xFBC1,0xFE6D,0x0000, 0xFBC1,0xFE6E,0x0000,
0xFBC1,0xFE6F,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0xFBC1,0xFE75,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x1347,0x0000,0x0000,
0x1348,0x0000,0x0000, 0x1348,0x0000,0x0000, 0x1349,0x0000,0x0000,
0x1349,0x0000,0x0000, 0x134C,0x0000,0x0000, 0x134C,0x0000,0x0000,
0x134D,0x0000,0x0000, 0x134D,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x134F,0x0000,0x0000, 0x134F,0x0000,0x0000, 0x134F,0x0000,0x0000,
0x1350,0x0000,0x0000, 0x1350,0x0000,0x0000, 0x1352,0x0000,0x0000,
0x1352,0x0000,0x0000, 0x1352,0x0000,0x0000, 0x1352,0x0000,0x0000,
0x1356,0x0000,0x0000, 0x1356,0x0000,0x0000, 0x1357,0x0000,0x0000,
0x1357,0x0000,0x0000, 0x1357,0x0000,0x0000, 0x1357,0x0000,0x0000,
0x1358,0x0000,0x0000, 0x1358,0x0000,0x0000, 0x1358,0x0000,0x0000,
0x1358,0x0000,0x0000, 0x135E,0x0000,0x0000, 0x135E,0x0000,0x0000,
0x135E,0x0000,0x0000, 0x135E,0x0000,0x0000, 0x1364,0x0000,0x0000,
0x1364,0x0000,0x0000, 0x1364,0x0000,0x0000, 0x1364,0x0000,0x0000,
0x1365,0x0000,0x0000, 0x1365,0x0000,0x0000, 0x1365,0x0000,0x0000,
0x1365,0x0000,0x0000, 0x1369,0x0000,0x0000, 0x1369,0x0000,0x0000,
0x136A,0x0000,0x0000, 0x136A,0x0000,0x0000, 0x1375,0x0000,0x0000,
0x1375,0x0000,0x0000, 0x1376,0x0000,0x0000, 0x1376,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1381,0x0000,0x0000, 0x1381,0x0000,0x0000,
0x1381,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1382,0x0000,0x0000,
0x1382,0x0000,0x0000, 0x1382,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1387,0x0000,0x0000, 0x1387,0x0000,0x0000, 0x1387,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x1388,0x0000,0x0000, 0x1388,0x0000,0x0000,
0x1388,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138C,0x0000,0x0000,
0x138C,0x0000,0x0000, 0x138C,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138D,0x0000,0x0000, 0x138D,0x0000,0x0000, 0x138D,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x138F,0x0000,0x0000, 0x138F,0x0000,0x0000,
0x138F,0x0000,0x0000, 0x1390,0x0000,0x0000, 0x1390,0x0000,0x0000,
0x1390,0x0000,0x0000, 0x1390,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x1393,0x0000,0x0000, 0x1393,0x0000,0x0000, 0x1393,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139B,0x0000,0x0000, 0x139B,0x0000,0x0000,
0x139B,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x139E,0x0000,0x0000,
0x139E,0x0000,0x0000, 0x139E,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13AB,0x0000,0x0000, 0x13AB,0x0000,0x0000, 0x13AB,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B0,0x0000,0x0000, 0x13B0,0x0000,0x0000,
0x13B0,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B1,0x0000,0x0000,
0x13B1,0x0000,0x0000, 0x13B1,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13B7,0x0000,0x0000, 0x13B7,0x0000,0x0000, 0x13B7,0x0000,0x0000,
0x13BD,0x0000,0x0000, 0x13BD,0x0000,0x0000, 0x13C7,0x0000,0x0000,
0x13C7,0x0000,0x0000, 0x13C8,0x0000,0x0000, 0x13C8,0x0000,0x0000,
0x13C8,0x0000,0x0000, 0x13C8,0x0000,0x0000, 0x13AB,0x1348,0x0000,
0x13AB,0x1348,0x0000, 0x13AB,0x1349,0x0000, 0x13AB,0x1349,0x0000,
0x13AB,0x134D,0x0000, 0x13AB,0x134D,0x0000, 0x13AB,0x1350,0x0000,
0x13AB,0x1350,0x0000, 0xFBC1,0xFEFD,0x0000, 0xFBC1,0xFEFE,0x0000,
0x0000,0x0000,0x0000 };

uint16 page0FFdata[]= { /* FF00 (3 weights per char) */
0xFBC1,0xFF00,0x0000, 0x0251,0x0000,0x0000, 0x027E,0x0000,0x0000,
0x02D2,0x0000,0x0000, 0x0E0F,0x0000,0x0000, 0x02D3,0x0000,0x0000,
0x02CF,0x0000,0x0000, 0x0277,0x0000,0x0000, 0x0288,0x0000,0x0000,
0x0289,0x0000,0x0000, 0x02C8,0x0000,0x0000, 0x0428,0x0000,0x0000,
0x022F,0x0000,0x0000, 0x0221,0x0000,0x0000, 0x025D,0x0000,0x0000,
0x02CC,0x0000,0x0000, 0x0E29,0x0000,0x0000, 0x0E2A,0x0000,0x0000,
0x0E2B,0x0000,0x0000, 0x0E2C,0x0000,0x0000, 0x0E2D,0x0000,0x0000,
0x0E2E,0x0000,0x0000, 0x0E2F,0x0000,0x0000, 0x0E30,0x0000,0x0000,
0x0E31,0x0000,0x0000, 0x0E32,0x0000,0x0000, 0x023D,0x0000,0x0000,
0x023A,0x0000,0x0000, 0x042C,0x0000,0x0000, 0x042D,0x0000,0x0000,
0x042E,0x0000,0x0000, 0x0255,0x0000,0x0000, 0x02C7,0x0000,0x0000,
0x0E33,0x0000,0x0000, 0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000,
0x0E6D,0x0000,0x0000, 0x0E8B,0x0000,0x0000, 0x0EB9,0x0000,0x0000,
0x0EC1,0x0000,0x0000, 0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000,
0x0F10,0x0000,0x0000, 0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000,
0x0F5B,0x0000,0x0000, 0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000,
0x0FA7,0x0000,0x0000, 0x0FB4,0x0000,0x0000, 0x0FC0,0x0000,0x0000,
0x0FEA,0x0000,0x0000, 0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000,
0x1044,0x0000,0x0000, 0x1051,0x0000,0x0000, 0x105A,0x0000,0x0000,
0x105E,0x0000,0x0000, 0x106A,0x0000,0x0000, 0x028A,0x0000,0x0000,
0x02CE,0x0000,0x0000, 0x028B,0x0000,0x0000, 0x020F,0x0000,0x0000,
0x021B,0x0000,0x0000, 0x020C,0x0000,0x0000, 0x0E33,0x0000,0x0000,
0x0E4A,0x0000,0x0000, 0x0E60,0x0000,0x0000, 0x0E6D,0x0000,0x0000,
0x0E8B,0x0000,0x0000, 0x0EB9,0x0000,0x0000, 0x0EC1,0x0000,0x0000,
0x0EE1,0x0000,0x0000, 0x0EFB,0x0000,0x0000, 0x0F10,0x0000,0x0000,
0x0F21,0x0000,0x0000, 0x0F2E,0x0000,0x0000, 0x0F5B,0x0000,0x0000,
0x0F64,0x0000,0x0000, 0x0F82,0x0000,0x0000, 0x0FA7,0x0000,0x0000,
0x0FB4,0x0000,0x0000, 0x0FC0,0x0000,0x0000, 0x0FEA,0x0000,0x0000,
0x1002,0x0000,0x0000, 0x101F,0x0000,0x0000, 0x1044,0x0000,0x0000,
0x1051,0x0000,0x0000, 0x105A,0x0000,0x0000, 0x105E,0x0000,0x0000,
0x106A,0x0000,0x0000, 0x028C,0x0000,0x0000, 0x0430,0x0000,0x0000,
0x028D,0x0000,0x0000, 0x0433,0x0000,0x0000, 0x029A,0x0000,0x0000,
0x029B,0x0000,0x0000, 0x0266,0x0000,0x0000, 0x02B2,0x0000,0x0000,
0x02B3,0x0000,0x0000, 0x0237,0x0000,0x0000, 0x022E,0x0000,0x0000,
0x1E80,0x0000,0x0000, 0x1E52,0x0000,0x0000, 0x1E53,0x0000,0x0000,
0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000, 0x1E56,0x0000,0x0000,
0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000, 0x1E77,0x0000,0x0000,
0x1E63,0x0000,0x0000, 0x0E0B,0x0000,0x0000, 0x1E52,0x0000,0x0000,
0x1E53,0x0000,0x0000, 0x1E54,0x0000,0x0000, 0x1E55,0x0000,0x0000,
0x1E56,0x0000,0x0000, 0x1E57,0x0000,0x0000, 0x1E58,0x0000,0x0000,
0x1E59,0x0000,0x0000, 0x1E5A,0x0000,0x0000, 0x1E5B,0x0000,0x0000,
0x1E5C,0x0000,0x0000, 0x1E5D,0x0000,0x0000, 0x1E5E,0x0000,0x0000,
0x1E5F,0x0000,0x0000, 0x1E60,0x0000,0x0000, 0x1E61,0x0000,0x0000,
0x1E62,0x0000,0x0000, 0x1E63,0x0000,0x0000, 0x1E64,0x0000,0x0000,
0x1E65,0x0000,0x0000, 0x1E66,0x0000,0x0000, 0x1E67,0x0000,0x0000,
0x1E68,0x0000,0x0000, 0x1E69,0x0000,0x0000, 0x1E6A,0x0000,0x0000,
0x1E6B,0x0000,0x0000, 0x1E6C,0x0000,0x0000, 0x1E6D,0x0000,0x0000,
0x1E6E,0x0000,0x0000, 0x1E6F,0x0000,0x0000, 0x1E70,0x0000,0x0000,
0x1E71,0x0000,0x0000, 0x1E72,0x0000,0x0000, 0x1E73,0x0000,0x0000,
0x1E74,0x0000,0x0000, 0x1E75,0x0000,0x0000, 0x1E76,0x0000,0x0000,
0x1E77,0x0000,0x0000, 0x1E78,0x0000,0x0000, 0x1E79,0x0000,0x0000,
0x1E7A,0x0000,0x0000, 0x1E7B,0x0000,0x0000, 0x1E7C,0x0000,0x0000,
0x1E7D,0x0000,0x0000, 0x1E81,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000, 0x1DBD,0x0000,0x0000, 0x1D62,0x0000,0x0000,
0x1D63,0x0000,0x0000, 0x1E02,0x0000,0x0000, 0x1D64,0x0000,0x0000,
0x1E04,0x0000,0x0000, 0x1E05,0x0000,0x0000, 0x1D65,0x0000,0x0000,
0x1D66,0x0000,0x0000, 0x1D67,0x0000,0x0000, 0x1E08,0x0000,0x0000,
0x1E09,0x0000,0x0000, 0x1E0A,0x0000,0x0000, 0x1E0B,0x0000,0x0000,
0x1E0C,0x0000,0x0000, 0x1E0D,0x0000,0x0000, 0x1D7C,0x0000,0x0000,
0x1D68,0x0000,0x0000, 0x1D69,0x0000,0x0000, 0x1D6A,0x0000,0x0000,
0x1D83,0x0000,0x0000, 0x1D6B,0x0000,0x0000, 0x1D6C,0x0000,0x0000,
0x1D6D,0x0000,0x0000, 0x1D6E,0x0000,0x0000, 0x1D6F,0x0000,0x0000,
0x1D70,0x0000,0x0000, 0x1D71,0x0000,0x0000, 0x1D72,0x0000,0x0000,
0x1D73,0x0000,0x0000, 0x1D74,0x0000,0x0000, 0xFBC1,0xFFBF,0x0000,
0xFBC1,0xFFC0,0x0000, 0xFBC1,0xFFC1,0x0000, 0x1DBE,0x0000,0x0000,
0x1DBF,0x0000,0x0000, 0x1DC0,0x0000,0x0000, 0x1DC1,0x0000,0x0000,
0x1DC2,0x0000,0x0000, 0x1DC3,0x0000,0x0000, 0xFBC1,0xFFC8,0x0000,
0xFBC1,0xFFC9,0x0000, 0x1DC4,0x0000,0x0000, 0x1DC5,0x0000,0x0000,
0x1DC6,0x0000,0x0000, 0x1DC7,0x0000,0x0000, 0x1DC8,0x0000,0x0000,
0x1DC9,0x0000,0x0000, 0xFBC1,0xFFD0,0x0000, 0xFBC1,0xFFD1,0x0000,
0x1DCA,0x0000,0x0000, 0x1DCB,0x0000,0x0000, 0x1DCC,0x0000,0x0000,
0x1DCD,0x0000,0x0000, 0x1DCE,0x0000,0x0000, 0x1DCF,0x0000,0x0000,
0xFBC1,0xFFD8,0x0000, 0xFBC1,0xFFD9,0x0000, 0x1DD0,0x0000,0x0000,
0x1DD1,0x0000,0x0000, 0x1DD2,0x0000,0x0000, 0xFBC1,0xFFDD,0x0000,
0xFBC1,0xFFDE,0x0000, 0xFBC1,0xFFDF,0x0000, 0x0E0E,0x0000,0x0000,
0x0E10,0x0000,0x0000, 0x042F,0x0000,0x0000, 0x0210,0x0000,0x0000,
0x0431,0x0000,0x0000, 0x0E11,0x0000,0x0000, 0x0E20,0x0000,0x0000,
0xFBC1,0xFFE7,0x0000, 0x05FE,0x0000,0x0000, 0x03AE,0x0000,0x0000,
0x03B0,0x0000,0x0000, 0x03AF,0x0000,0x0000, 0x03B1,0x0000,0x0000,
0x069C,0x0000,0x0000, 0x06C7,0x0000,0x0000, 0xFBC1,0xFFEF,0x0000,
0xFBC1,0xFFF0,0x0000, 0xFBC1,0xFFF1,0x0000, 0xFBC1,0xFFF2,0x0000,
0xFBC1,0xFFF3,0x0000, 0xFBC1,0xFFF4,0x0000, 0xFBC1,0xFFF5,0x0000,
0xFBC1,0xFFF6,0x0000, 0xFBC1,0xFFF7,0x0000, 0xFBC1,0xFFF8,0x0000,
0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000, 0x0000,0x0000,0x0000,
0x0DC5,0x0000,0x0000, 0x0DC6,0x0000,0x0000, 0xFBC1,0xFFFE,0x0000,
0xFBC1,0xFFFF,0x0000 };

uchar uca_length[256]={
4,3,3,4,3,3,3,3,0,3,3,3,3,3,3,3,
3,3,3,3,3,2,3,3,3,3,0,0,0,3,3,3,
5,5,4,3,5,2,3,3,2,2,5,3,0,0,3,3,
3,3,8,9,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,2,2,3,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,3,3,4,3,9,3,3
};
uint16 *uca_weight[256]={
page000data,page001data,page002data,page003data,
page004data,page005data,page006data,page007data,
NULL       ,page009data,page00Adata,page00Bdata,
page00Cdata,page00Ddata,page00Edata,page00Fdata,
page010data,page011data,page012data,page013data,
page014data,page015data,page016data,page017data,
page018data,page019data,NULL       ,NULL       ,
NULL       ,page01Ddata,page01Edata,page01Fdata,
page020data,page021data,page022data,page023data,
page024data,page025data,page026data,page027data,
page028data,page029data,page02Adata,page02Bdata,
NULL       ,NULL       ,page02Edata,page02Fdata,
page030data,page031data,page032data,page033data,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,page04Ddata,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
page0A0data,page0A1data,page0A2data,page0A3data,
page0A4data,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,NULL       ,NULL       ,NULL       ,
NULL       ,page0F9data,page0FAdata,page0FBdata,
page0FCdata,page0FDdata,page0FEdata,page0FFdata
};

/*
  Some sources treat LETTER A WITH DIARESIS (00E4,00C4)
  secondary greater than LETTER AE (00E6,00C6).
  http://www.evertype.com/alphabets/icelandic.pdf
  http://developer.mimer.com/collations/charts/icelandic.htm

  Other sources do not provide any special rules
  for LETTER A WITH DIARESIS:
  http://www.omniglot.com/writing/icelandic.htm
  http://en.wikipedia.org/wiki/Icelandic_alphabet
  http://oss.software.ibm.com/icu/charts/collation/is.html

  Let's go the first way.
*/

static const char icelandic[]=
    "& A < \\u00E1 <<< \\u00C1 "
    "& D < \\u00F0 <<< \\u00D0 "
    "& E < \\u00E9 <<< \\u00C9 "
    "& I < \\u00ED <<< \\u00CD "
    "& O < \\u00F3 <<< \\u00D3 "
    "& U < \\u00FA <<< \\u00DA "
    "& Y < \\u00FD <<< \\u00DD "
    "& Z < \\u00FE <<< \\u00DE "
        "< \\u00E6 <<< \\u00C6 << \\u00E4 <<< \\u00C4 "
        "< \\u00F6 <<< \\u00D6 << \\u00F8 <<< \\u00D8 "
        "< \\u00E5 <<< \\u00C5 ";

/*
  Some sources treat I and Y primary different.
  Other sources treat I and Y the same on primary level.
  We'll go the first way.
*/

static const char latvian[]=
    "& C < \\u010D <<< \\u010C "
    "& G < \\u0123 <<< \\u0122 "
    "& I < \\u0079 <<< \\u0059 "
    "& K < \\u0137 <<< \\u0136 "
    "& L < \\u013C <<< \\u013B "
    "& N < \\u0146 <<< \\u0145 "
    "& R < \\u0157 <<< \\u0156 "
    "& S < \\u0161 <<< \\u0160 "
    "& Z < \\u017E <<< \\u017D ";


static const char romanian[]=
    "& A < \\u0103 <<< \\u0102 < \\u00E2 <<< \\u00C2 "
    "& I < \\u00EE <<< \\u00CE "
    "& S < \\u0219 <<< \\u0218 << \\u015F <<< \\u015E "
    "& T < \\u021B <<< \\u021A << \\u0163 <<< \\u0162 ";

static const char slovenian[]=
    "& C < \\u010D <<< \\u010C "
    "& S < \\u0161 <<< \\u0160 "
    "& Z < \\u017E <<< \\u017D ";
    

static const char polish[]=
    "& A < \\u0105 <<< \\u0104 "
    "& C < \\u0107 <<< \\u0106 "
    "& E < \\u0119 <<< \\u0118 "
    "& L < \\u0142 <<< \\u0141 "
    "& N < \\u0144 <<< \\u0143 "
    "& O < \\u00F3 <<< \\u00D3 "
    "& S < \\u015B <<< \\u015A "
    "& Z < \\u017A <<< \\u0179 < \\u017C <<< \\u017B";

static const char estonian[]=
    "& S < \\u0161 <<< \\u0160 "
       " < \\u007A <<< \\u005A "
       " < \\u017E <<< \\u017D "
    "& W < \\u00F5 <<< \\u00D5 "
        "< \\u00E4 <<< \\u00C4 "
        "< \\u00F6 <<< \\u00D6 "
        "< \\u00FC <<< \\u00DC ";

static const char spanish[]= "& N < \\u00F1 <<< \\u00D1 ";

/*
  Some sources treat V and W as similar on primary level.
  We'll treat V and W as different on primary level.
*/
    
static const char swedish[]=
    "& Y <<\\u00FC <<< \\u00DC "
    "& Z < \\u00E5 <<< \\u00C5 "
        "< \\u00E4 <<< \\u00C4 << \\u00E6 <<< \\u00C6 "
        "< \\u00F6 <<< \\u00D6 << \\u00F8 <<< \\u00D8 ";

static const char turkish[]=
    "& C < \\u00E7 <<< \\u00C7 "
    "& G < \\u011F <<< \\u011E "
    "& H < \\u0131 <<< \\u0049 "
    "& O < \\u00F6 <<< \\u00D6 "
    "& S < \\u015F <<< \\u015E "
    "& U < \\u00FC <<< \\u00DC ";
    

static const char czech[]=
    "& C < \\u010D <<< \\u010C "
    "& H <      ch <<<      Ch <<< CH"
    "& R < \\u0159 <<< \\u0158"
    "& S < \\u0161 <<< \\u0160"
    "& Z < \\u017E <<< \\u017D";

static const char danish[]=  /* Also good for Norwegian */
    "& Y << \\u00FC <<< \\u00DC << \\u0171 <<< \\u0170"
    "& Z  < \\u00E6 <<< \\u00C6 << \\u00E4 <<< \\u00C4"
        " < \\u00F8 <<< \\u00D8 << \\u00F6 <<< \\u00D6 << \\u0151 <<< \\u0150"
        " < \\u00E5 <<< \\u00C5 << aa <<<  Aa <<< AA";

static const char lithuanian[]=
    "& C << ch <<< Ch <<< CH< \\u010D <<< \\u010C"
    "& E << \\u0119 <<< \\u0118 << \\u0117 <<< \\u0116"
    "& I << y <<< Y"
    "& S  < \\u0161 <<< \\u0160"
    "& Z  < \\u017E <<< \\u017D";

static const char slovak[]=
    "& A < \\u00E4 <<< \\u00C4"
    "& C < \\u010D <<< \\u010C"
    "& H < ch <<< Ch <<< CH"
    "& O < \\u00F4 <<< \\u00D4"
    "& S < \\u0161 <<< \\u0160"
    "& Z < \\u017E <<< \\u017D";

static const char spanish2[]=	/* Also good for Asturian and Galician */
    "&C <  ch <<< Ch <<< CH"
    "&L <  ll <<< Ll <<< LL"
    "&N < \\u00F1 <<< \\u00D1";

static const char roman[]= /* i.e. Classical Latin */
    "& I << j <<< J "
    "& V << u <<< U ";

/*
  Persian collation support was provided by 
  Jody McIntyre <mysql@modernduck.com>
  
  To: internals@lists.mysql.com
  Subject: Persian UTF8 collation support
  Date: 17.08.2004
  
  Contraction is not implemented.  Some implementations do perform
  contraction but others do not, and it is able to sort all my test
  strings correctly.
  
  Jody.
*/
static const char persian[]=
    "& \\u066D < \\u064E < \\uFE76 < \\uFE77 < \\u0650 < \\uFE7A < \\uFE7B"
             " < \\u064F < \\uFE78 < \\uFE79 < \\u064B < \\uFE70 < \\uFE71"
             " < \\u064D < \\uFE74 < \\u064C < \\uFE72"
    "& \\uFE7F < \\u0653 < \\u0654 < \\u0655 < \\u0670"
    "& \\u0669 < \\u0622 < \\u0627 < \\u0671 < \\u0621 < \\u0623 < \\u0625"
             " < \\u0624 < \\u0626"
    "& \\u0642 < \\u06A9 < \\u0643"
    "& \\u0648 < \\u0647 < \\u0629 < \\u06C0 < \\u06CC < \\u0649 < \\u064A"
    "& \\uFE80 < \\uFE81 < \\uFE82 < \\uFE8D < \\uFE8E < \\uFB50 < \\uFB51"
             " < \\uFE80 < \\uFE83 < \\uFE84 < \\uFE87 < \\uFE88 < \\uFE85"
             " < \\uFE86 < \\u0689 < \\u068A"
    "& \\uFEAE < \\uFDFC"
    "& \\uFED8 < \\uFB8E < \\uFB8F < \\uFB90 < \\uFB91 < \\uFED9 < \\uFEDA"
             " < \\uFEDB < \\uFEDC"
    "& \\uFEEE < \\uFEE9 < \\uFEEA < \\uFEEB < \\uFEEC < \\uFE93 < \\uFE94"
             " < \\uFBA4 < \\uFBA5 < \\uFBFC < \\uFBFD < \\uFBFE < \\uFBFF"
             " < \\uFEEF < \\uFEF0 < \\uFEF1 < \\uFEF2 < \\uFEF3 < \\uFEF4"
             " < \\uFEF5 < \\uFEF6 < \\uFEF7 < \\uFEF8 < \\uFEF9 < \\uFEFA"
             " < \\uFEFB < \\uFEFC";

/*
  Esperanto tailoring.
  Contributed by Bertilo Wennergren <bertilow at gmail dot com>
  September 1, 2005
*/
static const char esperanto[]=
    "& C < \\u0109 <<< \\u0108"
    "& G < \\u011D <<< \\u011C"
    "& H < \\u0125 <<< \\u0124"
    "& J < \\u0135 <<< \\u0134"
    "& S < \\u015d <<< \\u015c"
    "& U < \\u016d <<< \\u016c";

/*
  A simplified version of Hungarian, without consonant contractions.
*/
static const char hungarian[]=
    "&O < \\u00F6 <<< \\u00D6 << \\u0151 <<< \\u0150"
    "&U < \\u00FC <<< \\u00DC << \\u0171 <<< \\u0170";


/*
  Unicode Collation Algorithm:
  Collation element (weight) scanner, 
  for consequent scan of collations
  weights from a string.
*/
typedef struct my_uca_scanner_st
{
  const uint16 *wbeg;	/* Beginning of the current weight string */
  const uchar  *sbeg;	/* Beginning of the input string          */
  const uchar  *send;	/* End of the input string                */
  uchar *uca_length;
  uint16 **uca_weight;
  uint16 *contractions;
  uint16 implicit[2];
  int page;
  int code;
  CHARSET_INFO *cs;
} my_uca_scanner;

/*
  Charset dependent scanner part, to optimize
  some character sets.
*/
typedef struct my_uca_scanner_handler_st 
{
  void (*init)(my_uca_scanner *scanner, CHARSET_INFO *cs, 
               const uchar *str, size_t length);
  int (*next)(my_uca_scanner *scanner);
} my_uca_scanner_handler;

static uint16 nochar[]= {0,0};


#ifdef HAVE_CHARSET_ucs2
/*
  Initialize collation weight scanner

  SYNOPSIS:
    my_uca_scanner_init()
    scanner	Pointer to an initialized scanner structure
    cs		Character set + collation information
    str		Beginning of the string
    length	Length of the string.
    
  NOTES:
    Optimized for UCS2

  RETURN
    N/A
*/

static void my_uca_scanner_init_ucs2(my_uca_scanner *scanner,
                                     CHARSET_INFO *cs __attribute__((unused)),
                                     const uchar *str, size_t length)
{
  scanner->wbeg= nochar; 
  if (length)
  {
    scanner->sbeg= str;
    scanner->send= str + length - 2;
    scanner->uca_length= cs->sort_order;
    scanner->uca_weight= cs->sort_order_big;
    scanner->contractions= cs->contractions;
    return;
  }

  /*
    Sometimes this function is called with
    str=NULL and length=0, which should be
    considered as an empty string.
    
    The above initialization is unsafe for such cases,
    because scanner->send is initialized to (NULL-2), which is 0xFFFFFFFE.
    Then we fall into an endless loop in my_uca_scanner_next_ucs2().
      
    Do special initialization for the case when length=0.
    Initialize scanner->sbeg to an address greater than scanner->send.
    Next call of my_uca_scanner_next_ucs2() will correctly return with -1.
  */
  scanner->sbeg= (uchar*) &nochar[1];
  scanner->send= (uchar*) &nochar[0];
}


/*
  Read next collation element (weight), i.e. converts
  a stream of characters into a stream of their weights.
  
  SYNOPSIS:
    my_uca_scanner_next()
    scanner	Address of a previously initialized scanner strucuture
    
  NOTES:
    Optimized for UCS2
    
    Checks if the current character's weight string has been fully scanned,
    if no, then returns the next weight for this character,
    else scans the next character and returns its first weight.

    Each character can have number weights from 0 to 8.
    
    Some characters do not have weights at all, 0 weights. 
    It means they are ignored during comparison.
    
    Examples:
    1. 0x0001 START OF HEADING, has no weights, ignored, does
       not produce any weights.
    2. 0x0061 LATIN SMALL LETTER A, has one weight.
       0x0E33 will be returned
    3. 0x00DF LATIN SMALL LETTER SHARP S, aka SZ ligature,
       has two weights. It will return 0x0FEA twice for two
       consequent calls.
    4. 0x247D PATENTHESIZED NUMBER TEN, has four weights,
       this function will return these numbers in four 
       consequent calls: 0x0288, 0x0E2A, 0x0E29, 0x0289
    5. A string consisting of the above characters:
       0x0001 0x0061 0x00DF 0x247D
       will return the following weights, one weight per call:
       0x0E33 0x0FEA 0x0FEA 0x0288, 0x0E2A, 0x0E29, 0x0289
    
  RETURN
    Next weight, a number between 0x0000 and 0xFFFF
    Or -1 on error (END-OF-STRING or ILLEGAL MULTIBYTE SEQUENCE)
*/

static int my_uca_scanner_next_ucs2(my_uca_scanner *scanner)
{
  
  /* 
    Check if the weights for the previous character have been
    already fully scanned. If yes, then get the next character and 
    initialize wbeg and wlength to its weight string.
  */
  
  if (scanner->wbeg[0])
    return *scanner->wbeg++;
  
  do 
  {
    uint16 **ucaw= scanner->uca_weight;
    uchar *ucal= scanner->uca_length;
    
    if (scanner->sbeg > scanner->send)
      return -1;
    
    scanner->page= (uchar)scanner->sbeg[0];
    scanner->code= (uchar)scanner->sbeg[1];
    scanner->sbeg+= 2;
    
    if (scanner->contractions && (scanner->sbeg <= scanner->send))
    {
      int cweight;
      
      if (!scanner->page && !scanner->sbeg[0] &&
          (scanner->sbeg[1] > 0x40) && (scanner->sbeg[1] < 0x80) &&
          (scanner->code > 0x40) && (scanner->code < 0x80) &&
          (cweight= scanner->contractions[(scanner->code-0x40)*0x40+scanner->sbeg[1]-0x40]))
        {
          scanner->implicit[0]= 0;
          scanner->wbeg= scanner->implicit;
          scanner->sbeg+=2;
          return cweight;
        }
    }
    
    if (!ucaw[scanner->page])
      goto implicit;
    scanner->wbeg= ucaw[scanner->page] + scanner->code * ucal[scanner->page];
  } while (!scanner->wbeg[0]);
  
  return *scanner->wbeg++;
  
implicit:
  
  scanner->code= (scanner->page << 8) + scanner->code;
  scanner->implicit[0]= (scanner->code & 0x7FFF) | 0x8000;
  scanner->implicit[1]= 0;
  scanner->wbeg= scanner->implicit;
  
  scanner->page= scanner->page >> 7;
  
  if (scanner->code >= 0x3400 && scanner->code <= 0x4DB5)
    scanner->page+= 0xFB80;
  else if (scanner->code >= 0x4E00 && scanner->code <= 0x9FA5)
    scanner->page+= 0xFB40;
  else
    scanner->page+= 0xFBC0;
  
  return scanner->page;
}

static my_uca_scanner_handler my_ucs2_uca_scanner_handler=
{
  my_uca_scanner_init_ucs2,
  my_uca_scanner_next_ucs2
};

#endif


/*
  The same two functions for any character set
*/
static void my_uca_scanner_init_any(my_uca_scanner *scanner,
				    CHARSET_INFO *cs __attribute__((unused)),
				    const uchar *str, size_t length)
{
  /* Note, no needs to initialize scanner->wbeg */
  scanner->sbeg= str;
  scanner->send= str + length;
  scanner->wbeg= nochar; 
  scanner->uca_length= cs->sort_order;
  scanner->uca_weight= cs->sort_order_big;
  scanner->contractions= cs->contractions;
  scanner->cs= cs;
}

static int my_uca_scanner_next_any(my_uca_scanner *scanner)
{
  
  /* 
    Check if the weights for the previous character have been
    already fully scanned. If yes, then get the next character and 
    initialize wbeg and wlength to its weight string.
  */
  
  if (scanner->wbeg[0])
    return *scanner->wbeg++;
  
  do 
  {
    uint16 **ucaw= scanner->uca_weight;
    uchar *ucal= scanner->uca_length;
    my_wc_t wc;
    int mb_len;
    
    if (((mb_len= scanner->cs->cset->mb_wc(scanner->cs, &wc, 
                                          scanner->sbeg,
                                          scanner->send)) <= 0))
      return -1;
    
    scanner->page= wc >> 8;
    scanner->code= wc & 0xFF;
    scanner->sbeg+= mb_len;
    
    if (scanner->contractions && !scanner->page &&
        (scanner->code > 0x40) && (scanner->code < 0x80))
    {
      uint page1, code1, cweight;
      
      if (((mb_len= scanner->cs->cset->mb_wc(scanner->cs, &wc,
                                            scanner->sbeg, 
                                            scanner->send)) >=0) &&
           (!(page1= (wc >> 8))) &&
           ((code1= (wc & 0xFF)) > 0x40) &&
           (code1 < 0x80) && 
           (cweight= scanner->contractions[(scanner->code-0x40)*0x40 + code1-0x40]))
      {
        scanner->implicit[0]= 0;
        scanner->wbeg= scanner->implicit;
        scanner->sbeg+= mb_len;
        return cweight;
      }
    }
    
    if (!ucaw[scanner->page])
      goto implicit;
    scanner->wbeg= ucaw[scanner->page] + scanner->code * ucal[scanner->page];
  } while (!scanner->wbeg[0]);
  
  return *scanner->wbeg++;
  
implicit:
  
  scanner->code= (scanner->page << 8) + scanner->code;
  scanner->implicit[0]= (scanner->code & 0x7FFF) | 0x8000;
  scanner->implicit[1]= 0;
  scanner->wbeg= scanner->implicit;
  
  scanner->page= scanner->page >> 7;
  
  if (scanner->code >= 0x3400 && scanner->code <= 0x4DB5)
    scanner->page+= 0xFB80;
  else if (scanner->code >= 0x4E00 && scanner->code <= 0x9FA5)
    scanner->page+= 0xFB40;
  else
    scanner->page+= 0xFBC0;
  
  return scanner->page;
}


static my_uca_scanner_handler my_any_uca_scanner_handler=
{
  my_uca_scanner_init_any,
  my_uca_scanner_next_any
};

/*
  Compares two strings according to the collation

  SYNOPSIS:
    my_strnncoll_uca()
    cs		Character set information
    s		First string
    slen	First string length
    t		Second string
    tlen	Seconf string length
  
  NOTES:
    Initializes two weight scanners and gets weights
    corresponding to two strings in a loop. If weights are not
    the same at some step then returns their difference.
    
    In the while() comparison these situations are possible:
    1. (s_res>0) and (t_res>0) and (s_res == t_res)
       Weights are the same so far, continue comparison
    2. (s_res>0) and (t_res>0) and (s_res!=t_res)
       A difference has been found, return.
    3. (s_res>0) and (t_res<0)
       We have reached the end of the second string, or found
       an illegal multibyte sequence in the second string.
       Return a positive number, i.e. the first string is bigger.
    4. (s_res<0) and (t_res>0)   
       We have reached the end of the first string, or found
       an illegal multibyte sequence in the first string.
       Return a negative number, i.e. the second string is bigger.
    5. (s_res<0) and (t_res<0)
       Both scanners returned -1. It means we have riched
       the end-of-string of illegal-sequence in both strings
       at the same time. Return 0, strings are equal.
    
  RETURN
    Difference between two strings, according to the collation:
    0               - means strings are equal
    negative number - means the first string is smaller
    positive number - means the first string is bigger
*/

static int my_strnncoll_uca(CHARSET_INFO *cs, 
                            my_uca_scanner_handler *scanner_handler,
			    const uchar *s, size_t slen,
                            const uchar *t, size_t tlen,
                            my_bool t_is_prefix)
{
  my_uca_scanner sscanner;
  my_uca_scanner tscanner;
  int s_res;
  int t_res;
  
  scanner_handler->init(&sscanner, cs, s, slen);
  scanner_handler->init(&tscanner, cs, t, tlen);
  
  do
  {
    s_res= scanner_handler->next(&sscanner);
    t_res= scanner_handler->next(&tscanner);
  } while ( s_res == t_res && s_res >0);
  
  return  (t_is_prefix && t_res < 0) ? 0 : (s_res - t_res);
}

/*
  Compares two strings according to the collation,
  ignoring trailing spaces.

  SYNOPSIS:
    my_strnncollsp_uca()
    cs		Character set information
    s		First string
    slen	First string length
    t		Second string
    tlen	Seconf string length
    diff_if_only_endspace_difference
		        Set to 1 if the strings should be regarded as different
                        if they only difference in end space
  
  NOTES:
    Works exactly the same with my_strnncoll_uca(),
    but ignores trailing spaces.

    In the while() comparison these situations are possible:
    1. (s_res>0) and (t_res>0) and (s_res == t_res)
       Weights are the same so far, continue comparison
    2. (s_res>0) and (t_res>0) and (s_res!=t_res)
       A difference has been found, return.
    3. (s_res>0) and (t_res<0)
       We have reached the end of the second string, or found
       an illegal multibyte sequence in the second string.
       Compare the first string to an infinite array of
       space characters until difference is found, or until
       the end of the first string.
    4. (s_res<0) and (t_res>0)   
       We have reached the end of the first string, or found
       an illegal multibyte sequence in the first string.
       Compare the second string to an infinite array of
       space characters until difference is found or until
       the end of the second steing.
    5. (s_res<0) and (t_res<0)
       Both scanners returned -1. It means we have riched
       the end-of-string of illegal-sequence in both strings
       at the same time. Return 0, strings are equal.
  
  RETURN
    Difference between two strings, according to the collation:
    0               - means strings are equal
    negative number - means the first string is smaller
    positive number - means the first string is bigger
*/

static int my_strnncollsp_uca(CHARSET_INFO *cs, 
                              my_uca_scanner_handler *scanner_handler,
                              const uchar *s, size_t slen,
                              const uchar *t, size_t tlen,
                              my_bool diff_if_only_endspace_difference)
{
  my_uca_scanner sscanner, tscanner;
  int s_res, t_res;
  
#ifndef VARCHAR_WITH_DIFF_ENDSPACE_ARE_DIFFERENT_FOR_UNIQUE
  diff_if_only_endspace_difference= 0;
#endif

  scanner_handler->init(&sscanner, cs, s, slen);
  scanner_handler->init(&tscanner, cs, t, tlen);
  
  do
  {
    s_res= scanner_handler->next(&sscanner);
    t_res= scanner_handler->next(&tscanner);
  } while ( s_res == t_res && s_res >0);

  if (s_res > 0 && t_res < 0)
  { 
    /* Calculate weight for SPACE character */
    t_res= cs->sort_order_big[0][0x20 * cs->sort_order[0]];
      
    /* compare the first string to spaces */
    do
    {
      if (s_res != t_res)
        return (s_res - t_res);
      s_res= scanner_handler->next(&sscanner);
    } while (s_res > 0);
    return diff_if_only_endspace_difference ? 1 : 0;
  }
    
  if (s_res < 0 && t_res > 0)
  {
    /* Calculate weight for SPACE character */
    s_res= cs->sort_order_big[0][0x20 * cs->sort_order[0]];
      
    /* compare the second string to spaces */
    do
    {
      if (s_res != t_res)
        return (s_res - t_res);
      t_res= scanner_handler->next(&tscanner);
    } while (t_res > 0);
    return diff_if_only_endspace_difference ? -1 : 0;
  }
  
  return ( s_res - t_res );
}

/*
  Calculates hash value for the given string,
  according to the collation, and ignoring trailing spaces.
  
  SYNOPSIS:
    my_hash_sort_uca()
    cs		Character set information
    s		String
    slen	String's length
    n1		First hash parameter
    n2		Second hash parameter
  
  NOTES:
    Scans consequently weights and updates
    hash parameters n1 and n2. In a case insensitive collation,
    upper and lower case of the same letter will return the same
    weight sequence, and thus will produce the same hash values
    in n1 and n2.
  
  RETURN
    N/A
*/

static void my_hash_sort_uca(CHARSET_INFO *cs,
                             my_uca_scanner_handler *scanner_handler,
			     const uchar *s, size_t slen,
			     ulong *n1, ulong *n2)
{
  int   s_res;
  my_uca_scanner scanner;
  
  slen= cs->cset->lengthsp(cs, (char*) s, slen);
  scanner_handler->init(&scanner, cs, s, slen);
  
  while ((s_res= scanner_handler->next(&scanner)) >0)
  {
    n1[0]^= (((n1[0] & 63)+n2[0])*(s_res >> 8))+ (n1[0] << 8);
    n2[0]+=3;
    n1[0]^= (((n1[0] & 63)+n2[0])*(s_res & 0xFF))+ (n1[0] << 8);
    n2[0]+=3;
  }
}


/*
  For the given string creates its "binary image", suitable
  to be used in binary comparison, i.e. in memcmp(). 
  
  SYNOPSIS:
    my_strnxfrm_uca()
    cs		Character set information
    dst		Where to write the image
    dstlen	Space available for the image, in bytes
    src		The source string
    srclen	Length of the source string, in bytes
  
  NOTES:
    In a loop, scans weights from the source string and writes
    them into the binary image. In a case insensitive collation,
    upper and lower cases of the same letter will produce the
    same image subsequences. When we have reached the end-of-string
    or found an illegal multibyte sequence, the loop stops.

    It is impossible to restore the original string using its
    binary image. 
    
    Binary images are used for bulk comparison purposes,
    e.g. in ORDER BY, when it is more efficient to create
    a binary image and use it instead of weight scanner
    for the original strings for every comparison.
  
  RETURN
    Number of bytes that have been written into the binary image.
*/

static size_t my_strnxfrm_uca(CHARSET_INFO *cs, 
                              my_uca_scanner_handler *scanner_handler,
                              uchar *dst, size_t dstlen,
                              const uchar *src, size_t srclen)
{
  uchar *de= dst + (dstlen & (size_t) ~1); /* add even length for easier code */
  int   s_res;
  my_uca_scanner scanner;
  scanner_handler->init(&scanner, cs, src, srclen);
  
  while (dst < de && (s_res= scanner_handler->next(&scanner)) >0)
  {
    dst[0]= s_res >> 8;
    dst[1]= s_res & 0xFF;
    dst+= 2;
  }
  s_res= cs->sort_order_big[0][0x20 * cs->sort_order[0]];
  while (dst < de)
  {
    dst[0]= s_res >> 8;
    dst[1]= s_res & 0xFF;
    dst+= 2;
  }
  if (dstlen & 1) /* if odd number then fill the last char */
    *dst= '\0';
  
  return dstlen;
}



/*
  This function compares if two characters are the same.
  The sign +1 or -1 does not matter. The only
  important thing is that the result is 0 or not 0.
  This fact allows us to use memcmp() safely, on both
  little-endian and big-endian machines.
*/

static int my_uca_charcmp(CHARSET_INFO *cs, my_wc_t wc1, my_wc_t wc2)
{
  size_t page1= wc1 >> MY_UCA_PSHIFT;
  size_t page2= wc2 >> MY_UCA_PSHIFT;
  uchar *ucal= cs->sort_order;
  uint16 **ucaw= cs->sort_order_big;
  size_t length1= ucal[page1];
  size_t length2= ucal[page2];
  uint16 *weight1= ucaw[page1] + (wc1 & MY_UCA_CMASK) * ucal[page1];
  uint16 *weight2= ucaw[page2] + (wc2 & MY_UCA_CMASK) * ucal[page2];
  
  if (!weight1 || !weight2)
    return wc1 != wc2;
  
  if (length1 > length2)
    return memcmp((const void*)weight1, (const void*)weight2, length2*2) ?
           1: weight1[length2];
  
  if (length1 < length2)
    return memcmp((const void*)weight1, (const void*)weight2, length1*2) ?
           1 : weight2[length1];
  
  return memcmp((const void*)weight1, (const void*)weight2, length1*2);
}

/*
** Compare string against string with wildcard
**	0 if matched
**	-1 if not matched with wildcard
**	 1 if matched with wildcard
*/

static
int my_wildcmp_uca(CHARSET_INFO *cs,
		   const char *str,const char *str_end,
		   const char *wildstr,const char *wildend,
		   int escape, int w_one, int w_many)
{
  int result= -1;			/* Not found, using wildcards */
  my_wc_t s_wc, w_wc;
  int scan;
  int (*mb_wc)(struct charset_info_st *, my_wc_t *,
               const uchar *, const uchar *);
  mb_wc= cs->cset->mb_wc;
  
  while (wildstr != wildend)
  {
    while (1)
    {
      my_bool escaped= 0;
      if ((scan= mb_wc(cs, &w_wc, (const uchar*)wildstr,
		       (const uchar*)wildend)) <= 0)
	return 1;

      if (w_wc == (my_wc_t)w_many)
      {
        result= 1;				/* Found an anchor char */
        break;
      }

      wildstr+= scan;
      if (w_wc ==  (my_wc_t)escape)
      {
        if ((scan= mb_wc(cs, &w_wc, (const uchar*)wildstr,
			(const uchar*)wildend)) <= 0)
          return 1;
        wildstr+= scan;
        escaped= 1;
      }
      
      if ((scan= mb_wc(cs, &s_wc, (const uchar*)str,
      		       (const uchar*)str_end)) <= 0)
        return 1;
      str+= scan;
      
      if (!escaped && w_wc == (my_wc_t)w_one)
      {
        result= 1;				/* Found an anchor char */
      }
      else
      {
        if (my_uca_charcmp(cs,s_wc,w_wc))
          return 1;
      }
      if (wildstr == wildend)
	return (str != str_end);		/* Match if both are at end */
    }
    
    
    if (w_wc == (my_wc_t)w_many)
    {						/* Found w_many */
    
      /* Remove any '%' and '_' from the wild search string */
      for ( ; wildstr != wildend ; )
      {
        if ((scan= mb_wc(cs, &w_wc, (const uchar*)wildstr,
			 (const uchar*)wildend)) <= 0)
          return 1;
        
	if (w_wc == (my_wc_t)w_many)
	{
	  wildstr+= scan;
	  continue;
	} 
	
	if (w_wc == (my_wc_t)w_one)
	{
	  wildstr+= scan;
	  if ((scan= mb_wc(cs, &s_wc, (const uchar*)str,
			   (const uchar*)str_end)) <= 0)
            return 1;
          str+= scan;
	  continue;
	}
	break;					/* Not a wild character */
      }
      
      if (wildstr == wildend)
	return 0;				/* Ok if w_many is last */
      
      if (str == str_end)
	return -1;
      
      if ((scan= mb_wc(cs, &w_wc, (const uchar*)wildstr,
		       (const uchar*)wildend)) <= 0)
        return 1;
      
      if (w_wc ==  (my_wc_t)escape)
      {
        wildstr+= scan;
        if ((scan= mb_wc(cs, &w_wc, (const uchar*)wildstr,
			 (const uchar*)wildend)) <= 0)
          return 1;
      }
      
      while (1)
      {
        /* Skip until the first character from wildstr is found */
        while (str != str_end)
        {
          if ((scan= mb_wc(cs, &s_wc, (const uchar*)str,
			   (const uchar*)str_end)) <= 0)
            return 1;
          
          if (!my_uca_charcmp(cs,s_wc,w_wc))
            break;
          str+= scan;
        }
        if (str == str_end)
          return -1;
        
        result= my_wildcmp_uca(cs, str, str_end, wildstr, wildend,
        		       escape, w_one, w_many);
        
        if (result <= 0)
          return result;
        
        str+= scan;
      } 
    }
  }
  return (str != str_end ? 1 : 0);
}


/*
  Collation language is implemented according to
  subset of ICU Collation Customization (tailorings):
  http://oss.software.ibm.com/icu/userguide/Collate_Customization.html
  
  Collation language elements:
  Delimiters:
    space   - skipped
  
  <char> :=  A-Z | a-z | \uXXXX
  
  Shift command:
    <shift>  := &       - reset at this letter. 
  
  Diff command:
    <d1> :=  <     - Identifies a primary difference.
    <d2> :=  <<    - Identifies a secondary difference.
    <d3> := <<<    - Idenfifies a tertiary difference.
  
  
  Collation rules:
    <ruleset> :=  <rule>  { <ruleset> }
    
    <rule> :=   <d1>    <string>
              | <d2>    <string>
              | <d3>    <string>
              | <shift> <char>
    
    <string> := <char> [ <string> ]

  An example, Polish collation:
  
    &A < \u0105 <<< \u0104
    &C < \u0107 <<< \u0106
    &E < \u0119 <<< \u0118
    &L < \u0142 <<< \u0141
    &N < \u0144 <<< \u0143
    &O < \u00F3 <<< \u00D3
    &S < \u015B <<< \u015A
    &Z < \u017A <<< \u017B    
*/


typedef enum my_coll_lexem_num_en
{
  MY_COLL_LEXEM_EOF	= 0,
  MY_COLL_LEXEM_DIFF	= 1, 
  MY_COLL_LEXEM_SHIFT	= 4,
  MY_COLL_LEXEM_CHAR	= 5,
  MY_COLL_LEXEM_ERROR	= 6
} my_coll_lexem_num;


typedef struct my_coll_lexem_st
{
  const char *beg;
  const char *end;
  const char *prev;
  int   diff;
  int   code;
} MY_COLL_LEXEM;


/*
  Initialize collation rule lexical anilizer
  
  SYNOPSIS
    my_coll_lexem_init
    lexem                Lex analizer to init
    str                  Const string to parse
    str_end               End of the string
  USAGE
  
  RETURN VALUES
    N/A
*/

static void my_coll_lexem_init(MY_COLL_LEXEM *lexem,
                               const char *str, const char *str_end)
{
  lexem->beg= str;
  lexem->prev= str;
  lexem->end= str_end;
  lexem->diff= 0;
  lexem->code= 0;
}


/*
  Print collation customization expression parse error, with context.
  
  SYNOPSIS
    my_coll_lexem_print_error
    lexem                Lex analizer to take context from
    errstr               sting to write error to
    errsize              errstr size
    txt                  error message
  USAGE
  
  RETURN VALUES
    N/A
*/

static void my_coll_lexem_print_error(MY_COLL_LEXEM *lexem,
                                      char *errstr, size_t errsize,
                                      const char *txt)
{
  char tail[30];
  size_t len= lexem->end - lexem->prev;
  strmake (tail, lexem->prev, (size_t) min(len, sizeof(tail)-1));
  errstr[errsize-1]= '\0';
  my_snprintf(errstr,errsize-1,"%s at '%s'", txt, tail);
}


/*
  Convert a hex digit into its numeric value
  
  SYNOPSIS
    ch2x
    ch                   hex digit to convert
  USAGE
  
  RETURN VALUES
    an integer value in the range 0..15
    -1 on error
*/

static int ch2x(int ch)
{
  if (ch >= '0' && ch <= '9')
    return ch - '0';
  
  if (ch >= 'a' && ch <= 'f')
    return 10 + ch - 'a';
  
  if (ch >= 'A' && ch <= 'F')
    return 10 + ch - 'A';
  
  return -1;
}


/*
  Collation language lexical parser:
  Scans the next lexem.
  
  SYNOPSIS
    my_coll_lexem_next
    lexem                Lex analizer, previously initialized by 
                         my_coll_lexem_init.
  USAGE
    Call this function in a loop
    
  RETURN VALUES
    Lexem number: eof, diff, shift, char or error.
*/

static my_coll_lexem_num my_coll_lexem_next(MY_COLL_LEXEM *lexem)
{
  const char *beg;
  my_coll_lexem_num rc;
  
  for (beg= lexem->beg ; beg < lexem->end ; beg++)
  {
    if (*beg == ' ' || *beg == '\t' || *beg == '\r' || *beg == '\n')
      continue;
    
    if (*beg == '&')
    {
      beg++;
      rc= MY_COLL_LEXEM_SHIFT;
      goto ex;
    }
    
    if (beg[0] == '<')
    {
      for (beg++, lexem->diff= 1;
           (beg < lexem->end) && 
           (*beg == '<') && (lexem->diff<3);
           beg++, lexem->diff++);
      rc= MY_COLL_LEXEM_DIFF;
      goto ex;
    }
    
    if ((*beg >= 'a' && *beg <= 'z') || (*beg >= 'A' && *beg <= 'Z'))
    {
      lexem->code= *beg++;
      rc= MY_COLL_LEXEM_CHAR;
      goto ex;
    }
    
    if ((*beg == '\\') && (beg+2 < lexem->end) && (beg[1] == 'u'))
    {
      int ch;
      
      beg+= 2;
      lexem->code= 0;
      while ((beg < lexem->end) && ((ch= ch2x(beg[0])) >= 0))
      { 
        lexem->code= (lexem->code << 4) + ch;
        beg++;
      }
      rc= MY_COLL_LEXEM_CHAR;
      goto ex;
    }
    
    rc= MY_COLL_LEXEM_ERROR;
    goto ex;
  }
  rc= MY_COLL_LEXEM_EOF;
  
ex:
  lexem->prev= lexem->beg;
  lexem->beg= beg;
  return rc;  
}


/*
  Collation rule item
*/

typedef struct my_coll_rule_item_st
{
  uint base;     /* Base character                             */
  uint curr[2];  /* Current character                          */
  int diff[3];   /* Primary, Secondary and Tertiary difference */
} MY_COLL_RULE;


/*
  Collation language syntax parser.
  Uses lexical parser.
  
  SYNOPSIS
    my_coll_rule_parse
    rule                 Collation rule list to load to.
    str                  A string containin collation language expression.
    str_end              End of the string.
  USAGE
    
  RETURN VALUES
    A positive number means the number of rules loaded.
   -1 means ERROR, e.g. too many items, syntax error, etc.
*/

static int my_coll_rule_parse(MY_COLL_RULE *rule, size_t mitems,
                              const char *str, const char *str_end,
                              char *errstr, size_t errsize)
{
  MY_COLL_LEXEM lexem;
  my_coll_lexem_num lexnum;
  my_coll_lexem_num prevlexnum= MY_COLL_LEXEM_ERROR;
  MY_COLL_RULE item; 
  int state= 0;
  size_t nitems= 0;
  
  /* Init all variables */
  errstr[0]= '\0';
  bzero(&item, sizeof(item));
  my_coll_lexem_init(&lexem, str, str_end);
  
  while ((lexnum= my_coll_lexem_next(&lexem)))
  {
    if (lexnum == MY_COLL_LEXEM_ERROR)
    {
      my_coll_lexem_print_error(&lexem,errstr,errsize-1,"Unknown character");
      return -1;
    }
    
    switch (state) {
    case 0:
      if (lexnum != MY_COLL_LEXEM_SHIFT)
      {
        my_coll_lexem_print_error(&lexem,errstr,errsize-1,"& expected");
        return -1;
      }
      prevlexnum= lexnum;
      state= 2;
      continue;
      
    case 1:
      if (lexnum != MY_COLL_LEXEM_SHIFT && lexnum != MY_COLL_LEXEM_DIFF)
      {
        my_coll_lexem_print_error(&lexem,errstr,errsize-1,"& or < expected");
        return -1;
      }
      prevlexnum= lexnum;
      state= 2;
      continue;
      
    case 2:
      if (lexnum != MY_COLL_LEXEM_CHAR)
      {
        my_coll_lexem_print_error(&lexem,errstr,errsize-1,"character expected");
        return -1;
      }
      
      if (prevlexnum == MY_COLL_LEXEM_SHIFT)
      {
        item.base= lexem.code;
        item.diff[0]= 0;
        item.diff[1]= 0;
        item.diff[2]= 0;
      }
      else if (prevlexnum == MY_COLL_LEXEM_DIFF)
      {
        MY_COLL_LEXEM savlex;
        savlex= lexem;
        item.curr[0]= lexem.code;
        if ((lexnum= my_coll_lexem_next(&lexem)) == MY_COLL_LEXEM_CHAR)
        {
          item.curr[1]= lexem.code;
        }
        else
        {
          item.curr[1]= 0;
          lexem=savlex;   /* Restore previous parser state */
        }
        if (lexem.diff == 3)
        {
          item.diff[2]++;
        }
        else if (lexem.diff == 2)
        {
          item.diff[1]++;
          item.diff[2]= 0;
        }
        else if (lexem.diff == 1)
        {
          item.diff[0]++;
          item.diff[1]= 0;
          item.diff[2]= 0;
        }
        if (nitems >= mitems)
        {
          my_coll_lexem_print_error(&lexem,errstr,errsize-1,"Too many rules");
          return -1;
        }
        rule[nitems++]= item;
      }
      else
      {
        my_coll_lexem_print_error(&lexem,errstr,errsize-1,"Should never happen");
        return -1;
      }
      state= 1;
      continue;
    }
  }
  return (int) nitems;
}

#define MY_MAX_COLL_RULE 128

/*
  This function copies an UCS2 collation from
  the default Unicode Collation Algorithm (UCA)
  weights applying tailorings, i.e. a set of
  alternative weights for some characters. 
  
  The default UCA weights are stored in uca_weight/uca_length.
  They consist of 256 pages, 256 character each.
  
  If a page is not overwritten by tailoring rules,
  it is copies as is from UCA as is.
  
  If a page contains some overwritten characters, it is
  allocated. Untouched characters are copied from the
  default weights.
*/

static my_bool create_tailoring(CHARSET_INFO *cs, void *(*alloc)(size_t))
{
  MY_COLL_RULE rule[MY_MAX_COLL_RULE];
  char errstr[128];
  uchar   *newlengths;
  uint16 **newweights;
  const uchar *deflengths= uca_length;
  uint16     **defweights= uca_weight;
  int rc, i;
  int ncontractions= 0;
  
  if (!cs->tailoring)
    return 1;
  
  /* Parse ICU Collation Customization expression */
  if ((rc= my_coll_rule_parse(rule, MY_MAX_COLL_RULE,
                              cs->tailoring,
                              cs->tailoring + strlen(cs->tailoring),
                              errstr, sizeof(errstr))) < 0)
  {
    /* 
      TODO: add error message reporting.
      printf("Error: %d '%s'\n", rc, errstr);
    */
    return 1;
  }
  
  if (!cs->caseinfo)
    cs->caseinfo= my_unicase_default;
  
  if (!(newweights= (uint16**) (*alloc)(256*sizeof(uint16*))))
    return 1;
  bzero(newweights, 256*sizeof(uint16*));
  
  if (!(newlengths= (uchar*) (*alloc)(256)))
    return 1;
  
  memcpy(newlengths, deflengths, 256);
  
  /*
    Calculate maximum lenghts for the pages
    which will be overwritten.
  */
  for (i=0; i < rc; i++)
  {
    if (!rule[i].curr[1]) /* If not a contraction */
    {
      uint pageb= (rule[i].base >> 8) & 0xFF;
      uint pagec= (rule[i].curr[0] >> 8) & 0xFF;
    
      if (newlengths[pagec] < deflengths[pageb])
        newlengths[pagec]= deflengths[pageb];
    }
    else
      ncontractions++;
  }
  
  for (i=0; i < rc;  i++)
  {
    uint pageb= (rule[i].base >> 8) & 0xFF;
    uint pagec= (rule[i].curr[0] >> 8) & 0xFF;
    uint chb, chc;
    
    if (rule[i].curr[1]) /* Skip contraction */
      continue;
    
    if (!newweights[pagec])
    {
      /* Alloc new page and copy the default UCA weights */
      uint size= 256*newlengths[pagec]*sizeof(uint16);
      
      if (!(newweights[pagec]= (uint16*) (*alloc)(size)))
        return 1;
      bzero((void*) newweights[pagec], size);
      
      for (chc=0 ; chc < 256; chc++)
      {
        memcpy(newweights[pagec] + chc*newlengths[pagec],
               defweights[pagec] + chc*deflengths[pagec],
               deflengths[pagec]*sizeof(uint16));
      }
    }
    
    /* 
      Aply the alternative rule:
      shift to the base character and primary difference.
    */
    chc= rule[i].curr[0] & 0xFF;
    chb= rule[i].base & 0xFF;
    memcpy(newweights[pagec] + chc*newlengths[pagec],
           defweights[pageb] + chb*deflengths[pageb],
           deflengths[pageb]*sizeof(uint16));
    /* Apply primary difference */
    newweights[pagec][chc*newlengths[pagec]]+= rule[i].diff[0];
  }
  
  /* Copy non-overwritten pages from the default UCA weights */
  for (i= 0; i < 256 ; i++)
  {
    if (!newweights[i])
      newweights[i]= defweights[i];
  }
  
  cs->sort_order= newlengths;
  cs->sort_order_big= newweights;
  cs->contractions= NULL;
  
  /* Now process contractions */
  if (ncontractions)
  {
    /*
      8K for weights for basic latin letter pairs,
      plus 256 bytes for "is contraction part" flags.
    */
    uint size= 0x40*0x40*sizeof(uint16) + 256;
    char *contraction_flags;
    if (!(cs->contractions= (uint16*) (*alloc)(size)))
        return 1;
    bzero((void*)cs->contractions, size);
    contraction_flags= ((char*) cs->contractions) + 0x40*0x40;
    for (i=0; i < rc; i++)
    {
      if (rule[i].curr[1])
      {
        uint pageb= (rule[i].base >> 8) & 0xFF;
        uint chb= rule[i].base & 0xFF;
        uint16 *offsb= defweights[pageb] + chb*deflengths[pageb];
        uint offsc;
        
        if (offsb[1] || 
            rule[i].curr[0] < 0x40 || rule[i].curr[0] > 0x7f ||
            rule[i].curr[1] < 0x40 || rule[i].curr[1] > 0x7f)
        {
          /* 
           TODO: add error reporting;
           We support only basic latin letters contractions at this point.
           Also, We don't support contractions with weight longer than one.
           Otherwise, we'd need much more memory.
          */
          return 1;
        }
        offsc= (rule[i].curr[0]-0x40)*0x40+(rule[i].curr[1]-0x40);
        
        /* Copy base weight applying primary difference */
        cs->contractions[offsc]= offsb[0] + rule[i].diff[0];
        /* Mark both letters as "is contraction part */
        contraction_flags[rule[i].curr[0]]= 1;
        contraction_flags[rule[i].curr[1]]= 1;
      }
    }
  }
  return 0;
}


/*
  Universal CHARSET_INFO compatible wrappers
  for the above internal functions.
  Should work for any character set.
*/

static my_bool my_coll_init_uca(CHARSET_INFO *cs, void *(*alloc)(size_t))
{
  cs->pad_char= ' ';
  cs->ctype= my_charset_utf8_unicode_ci.ctype;
  return create_tailoring(cs, alloc);
}

static int my_strnncoll_any_uca(CHARSET_INFO *cs,
                                const uchar *s, size_t slen,
                                const uchar *t, size_t tlen,
                                my_bool t_is_prefix)
{
  return my_strnncoll_uca(cs, &my_any_uca_scanner_handler,
                          s, slen, t, tlen, t_is_prefix);
}

static int my_strnncollsp_any_uca(CHARSET_INFO *cs,
                                  const uchar *s, size_t slen,
                                  const uchar *t, size_t tlen,
                                  my_bool diff_if_only_endspace_difference)
{
  return my_strnncollsp_uca(cs, &my_any_uca_scanner_handler,
                            s, slen, t, tlen,
                            diff_if_only_endspace_difference);
}   

static void my_hash_sort_any_uca(CHARSET_INFO *cs,
                                 const uchar *s, size_t slen,
                                 ulong *n1, ulong *n2)
{
  my_hash_sort_uca(cs, &my_any_uca_scanner_handler, s, slen, n1, n2); 
}

static size_t my_strnxfrm_any_uca(CHARSET_INFO *cs, 
                                  uchar *dst, size_t dstlen,
                                  const uchar *src, size_t srclen)
{
  return my_strnxfrm_uca(cs, &my_any_uca_scanner_handler,
                         dst, dstlen, src, srclen);
}


#ifdef HAVE_CHARSET_ucs2
/*
  UCS2 optimized CHARSET_INFO compatible wrappers.
*/
static int my_strnncoll_ucs2_uca(CHARSET_INFO *cs,
                                 const uchar *s, size_t slen,
                                 const uchar *t, size_t tlen,
                                 my_bool t_is_prefix)
{
  return my_strnncoll_uca(cs, &my_ucs2_uca_scanner_handler,
                          s, slen, t, tlen, t_is_prefix);
}

static int my_strnncollsp_ucs2_uca(CHARSET_INFO *cs,
                                   const uchar *s, size_t slen,
                                   const uchar *t, size_t tlen,
                                   my_bool diff_if_only_endspace_difference)
{
  return my_strnncollsp_uca(cs, &my_ucs2_uca_scanner_handler,
                            s, slen, t, tlen,
                            diff_if_only_endspace_difference);
}   

static void my_hash_sort_ucs2_uca(CHARSET_INFO *cs,
                                  const uchar *s, size_t slen,
                                  ulong *n1, ulong *n2)
{
  my_hash_sort_uca(cs, &my_ucs2_uca_scanner_handler, s, slen, n1, n2); 
}

static size_t my_strnxfrm_ucs2_uca(CHARSET_INFO *cs, 
                                   uchar *dst, size_t dstlen,
                                   const uchar *src, size_t srclen)
{
  return my_strnxfrm_uca(cs, &my_ucs2_uca_scanner_handler,
                         dst, dstlen, src, srclen);
}

MY_COLLATION_HANDLER my_collation_ucs2_uca_handler =
{
  my_coll_init_uca,	/* init */
  my_strnncoll_ucs2_uca,
  my_strnncollsp_ucs2_uca,
  my_strnxfrm_ucs2_uca,
  my_strnxfrmlen_simple,
  my_like_range_ucs2,
  my_wildcmp_uca,
  NULL,
  my_instr_mb,
  my_hash_sort_ucs2_uca,
  my_propagate_complex
};

CHARSET_INFO my_charset_ucs2_unicode_ci=
{
    128,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_unicode_ci",	/* name         */
    "",			/* comment      */
    "",			/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    uca_length,		/* sort_order   */
    NULL,		/* contractions */
    uca_weight,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_icelandic_uca_ci=
{
    129,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_icelandic_ci",/* name         */
    "",			/* comment      */
    icelandic,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_latvian_uca_ci=
{
    130,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_latvian_ci",	/* name         */
    "",			/* comment      */
    latvian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_romanian_uca_ci=
{
    131,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_romanian_ci",	/* name         */
    "",			/* comment      */
    romanian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_slovenian_uca_ci=
{
    132,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_slovenian_ci",/* name         */
    "",			/* comment      */
    slovenian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_polish_uca_ci=
{
    133,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_polish_ci",	/* name         */
    "",			/* comment      */
    polish,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_estonian_uca_ci=
{
    134,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_estonian_ci",	/* name         */
    "",			/* comment      */
    estonian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_spanish_uca_ci=
{
    135,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_spanish_ci",	/* name         */
    "",			/* comment      */
    spanish,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_swedish_uca_ci=
{
    136,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_swedish_ci",	/* name         */
    "",			/* comment      */
    swedish,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_turkish_uca_ci=
{
    137,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_turkish_ci",	/* name         */
    "",			/* comment      */
    turkish,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_turkish, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_czech_uca_ci=
{
    138,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_czech_ci",	/* name         */
    "",			/* comment      */
    czech,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


CHARSET_INFO my_charset_ucs2_danish_uca_ci=
{
    139,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_danish_ci",	/* name         */
    "",			/* comment      */
    danish,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_lithuanian_uca_ci=
{
    140,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_lithuanian_ci",/* name         */
    "",			/* comment      */
    lithuanian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_slovak_uca_ci=
{
    141,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_slovak_ci",	/* name         */
    "",			/* comment      */
    slovak,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};

CHARSET_INFO my_charset_ucs2_spanish2_uca_ci=
{
    142,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_spanish2_ci",	/* name         */
    "",			/* comment      */
    spanish2,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


CHARSET_INFO my_charset_ucs2_roman_uca_ci=
{
    143,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_roman_ci",	/* name         */
    "",			/* comment      */
    roman,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


CHARSET_INFO my_charset_ucs2_persian_uca_ci=
{
    144,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_persian_ci",	/* name         */
    "",			/* comment      */
    persian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


CHARSET_INFO my_charset_ucs2_esperanto_uca_ci=
{
    145,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_esperanto_ci",/* name         */
    "",			/* comment      */
    esperanto,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


CHARSET_INFO my_charset_ucs2_hungarian_uca_ci=
{
    146,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "ucs2",		/* cs name    */
    "ucs2_hungarian_ci",/* name         */
    "",			/* comment      */
    hungarian,		/* tailoring    */
    NULL,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    2,			/* mbminlen     */
    2,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_ucs2_handler,
    &my_collation_ucs2_uca_handler
};


#endif


#ifdef HAVE_CHARSET_utf8
MY_COLLATION_HANDLER my_collation_any_uca_handler =
{
    my_coll_init_uca,	/* init */
    my_strnncoll_any_uca,
    my_strnncollsp_any_uca,
    my_strnxfrm_any_uca,
    my_strnxfrmlen_simple,
    my_like_range_mb,
    my_wildcmp_uca,
    NULL,
    my_instr_mb,
    my_hash_sort_any_uca,
    my_propagate_complex
};

/* 
  We consider bytes with code more than 127 as a letter.
  This garantees that word boundaries work fine with regular
  expressions. Note, there is no need to mark byte 255  as a
  letter, it is illegal byte in UTF8.
*/
static uchar ctype_utf8[] = {
    0,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 40, 40, 40, 40, 40, 32, 32,
   32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
   72, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
  132,132,132,132,132,132,132,132,132,132, 16, 16, 16, 16, 16, 16,
   16,129,129,129,129,129,129,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1, 16, 16, 16, 16, 16,
   16,130,130,130,130,130,130,  2,  2,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2, 16, 16, 16, 16, 32,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,
    3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  3,  0
};

extern MY_CHARSET_HANDLER my_charset_utf8_handler;

CHARSET_INFO my_charset_utf8_unicode_ci=
{
    192,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_unicode_ci",	/* name         */
    "",			/* comment      */
    "",			/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    uca_length,		/* sort_order   */
    NULL,		/* contractions */
    uca_weight,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};


CHARSET_INFO my_charset_utf8_icelandic_uca_ci=
{
    193,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_icelandic_ci",/* name         */
    "",			/* comment      */
    icelandic,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_latvian_uca_ci=
{
    194,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_latvian_ci",	/* name         */
    "",			/* comment      */
    latvian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_romanian_uca_ci=
{
    195,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_romanian_ci",	/* name         */
    "",			/* comment      */
    romanian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_slovenian_uca_ci=
{
    196,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_slovenian_ci",/* name         */
    "",			/* comment      */
    slovenian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_polish_uca_ci=
{
    197,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_polish_ci",	/* name         */
    "",			/* comment      */
    polish,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_estonian_uca_ci=
{
    198,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_estonian_ci",	/* name         */
    "",			/* comment      */
    estonian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_spanish_uca_ci=
{
    199,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_spanish_ci",	/* name         */
    "",			/* comment      */
    spanish,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_swedish_uca_ci=
{
    200,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_swedish_ci",	/* name         */
    "",			/* comment      */
    swedish,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_turkish_uca_ci=
{
    201,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_turkish_ci",	/* name         */
    "",			/* comment      */
    turkish,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_turkish, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    2,                  /* caseup_multiply  */
    2,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_czech_uca_ci=
{
    202,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_czech_ci",	/* name         */
    "",			/* comment      */
    czech,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};


CHARSET_INFO my_charset_utf8_danish_uca_ci=
{
    203,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_danish_ci",	/* name         */
    "",			/* comment      */
    danish,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_lithuanian_uca_ci=
{
    204,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_lithuanian_ci",/* name         */
    "",			/* comment      */
    lithuanian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_slovak_uca_ci=
{
    205,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_slovak_ci",	/* name         */
    "",			/* comment      */
    slovak,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_spanish2_uca_ci=
{
    206,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_spanish2_ci",	/* name         */
    "",			/* comment      */
    spanish2,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_roman_uca_ci=
{
    207,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_roman_ci",	/* name         */
    "",			/* comment      */
    roman,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_persian_uca_ci=
{
    208,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_persian_ci",	/* name         */
    "",			/* comment      */
    persian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_esperanto_uca_ci=
{
    209,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_esperanto_ci",/* name         */
    "",			/* comment      */
    esperanto,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

CHARSET_INFO my_charset_utf8_hungarian_uca_ci=
{
    210,0,0,		/* number       */
    MY_CS_COMPILED|MY_CS_STRNXFRM|MY_CS_UNICODE,
    "utf8",		/* cs name    */
    "utf8_hungarian_ci",/* name         */
    "",			/* comment      */
    hungarian,		/* tailoring    */
    ctype_utf8,		/* ctype        */
    NULL,		/* to_lower     */
    NULL,		/* to_upper     */
    NULL,		/* sort_order   */
    NULL,		/* contractions */
    NULL,		/* sort_order_big*/
    NULL,		/* tab_to_uni   */
    NULL,		/* tab_from_uni */
    my_unicase_default, /* caseinfo     */
    NULL,		/* state_map    */
    NULL,		/* ident_map    */
    8,			/* strxfrm_multiply */
    1,                  /* caseup_multiply  */
    1,                  /* casedn_multiply  */
    1,			/* mbminlen     */
    3,			/* mbmaxlen     */
    9,			/* min_sort_char */
    0xFFFF,		/* max_sort_char */
    ' ',                /* pad char      */
    0,                  /* escape_with_backslash_is_dangerous */
    &my_charset_utf8_handler,
    &my_collation_any_uca_handler
};

#endif /* HAVE_CHARSET_utf8 */

#endif /* HAVE_UCA_COLLATIONS */
