#!/bin/bash
#/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
# *   Mupen64plus - m64p_update.sh                                          *
# *   Mupen64Plus homepage: http://code.google.com/p/mupen64plus/           *
# *   Copyright (C) 2009 Richard Goedeken                                   *
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License as published by  *
# *   the Free Software Foundation; either version 2 of the License, or     *
# *   (at your option) any later version.                                   *
# *                                                                         *
# *   This program is distributed in the hope that it will be useful,       *
# *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
# *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
# *   GNU General Public License for more details.                          *
# *                                                                         *
# *   You should have received a copy of the GNU General Public License     *
# *   along with this program; if not, write to the                         *
# *   Free Software Foundation, Inc.,                                       *
# *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
# * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

# terminate the script if any commands return a non-zero error code
set -e

cd source

echo "************************************ Updating Core library"
hg pull --cwd mupen64plus-core
hg update --cwd mupen64plus-core $@

echo "************************************ Updating console front-end"
hg pull --cwd mupen64plus-ui-console
hg update --cwd mupen64plus-ui-console $@

echo "************************************ Updating SDL audio plugin"
hg pull --cwd mupen64plus-audio-sdl
hg update --cwd mupen64plus-audio-sdl $@

echo "************************************ Updating SDL input plugin"
hg pull --cwd mupen64plus-input-sdl
hg update --cwd mupen64plus-input-sdl $@

echo "************************************ Updating RSP HLE plugin"
hg pull --cwd mupen64plus-rsp-hle
hg update --cwd mupen64plus-rsp-hle $@

echo "************************************ Updating Rice Video plugin"
hg pull --cwd mupen64plus-video-rice
hg update --cwd mupen64plus-video-rice $@


