/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.InfoType;
import base.drawable.InfoValue;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.io.DataIO;
import base.io.MixedDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class InfoBox
extends TimeBoundingBox
implements DataIO {
    private static final int INIT_BYTESIZE = 6;
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;
    private boolean hasBufBeenDecoded;
    private byte[] infobuffer;
    private InfoValue[] infovals;
    private StringBuffer err_msg;
    private String[] infokeys = null;

    public InfoBox() {
        this.initCategoryToNull();
        this.err_msg = null;
    }

    public InfoBox(int n) {
        this.initCategoryToNull();
        this.type_idx = n;
        this.err_msg = null;
    }

    public InfoBox(Category category) {
        this.setCategory(category);
        this.err_msg = null;
    }

    public InfoBox(InfoBox infoBox) {
        super(infoBox);
        this.setCategory(infoBox.type);
        this.err_msg = null;
    }

    public InfoBox(Category category, InfoBox infoBox) {
        super(infoBox);
        this.setCategory(category);
        this.err_msg = null;
    }

    private void initCategoryToNull() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
        this.infobuffer = null;
        this.infovals = null;
        this.hasBufBeenDecoded = false;
    }

    private void setCategory(Category category) {
        if (category != null) {
            this.type = category;
            this.type_idx = this.type.getIndex();
            this.infobuffer = null;
            this.infovals = null;
            this.hasBufBeenDecoded = false;
        } else {
            this.initCategoryToNull();
        }
    }

    public boolean resolveCategory(Map map) {
        if (this.type == null) {
            if (this.type_idx != Integer.MIN_VALUE) {
                this.type = (Category)map.get(new Integer(this.type_idx));
                if (this.type != null) {
                    this.type.setUsed(true);
                } else {
                    this.type = new Category(this.type_idx, "UnknownType-" + this.type_idx, Topology.STATE, ColorAlpha.getNextDefaultColor(), 1);
                    map.put(new Integer(this.type.getIndex()), this.type);
                    this.type.setUsed(true);
                }
                return true;
            }
        } else {
            if (!this.type.isUsed()) {
                map.put(new Integer(this.type.getIndex()), this.type);
                this.type.setUsed(true);
                if (this.type.getName() == null) {
                    this.type.setName("UnknownType-" + this.type.getIndex());
                    this.type.setColor(ColorAlpha.getNextDefaultColor());
                }
            }
            return true;
        }
        return false;
    }

    public void releaseCategory() {
        if (this.type != null) {
            this.type.setUsed(false);
            this.type = null;
        }
    }

    public Category getCategory() {
        return this.type;
    }

    public int getCategoryIndex() {
        return this.type_idx;
    }

    private void addErrMsg(String string) {
        if (this.err_msg == null) {
            this.err_msg = new StringBuffer(string);
        } else {
            this.err_msg.append(" " + string);
        }
    }

    public void setInfoBuffer(byte[] byArray) {
        this.infobuffer = byArray;
    }

    private void setInfoValueTypes() {
        if (this.type != null) {
            InfoType[] infoTypeArray = this.type.getInfoTypes();
            if (infoTypeArray != null && infoTypeArray.length > 0) {
                int n = infoTypeArray.length;
                this.infovals = new InfoValue[n];
                for (int i = 0; i < n; ++i) {
                    this.infovals[i] = new InfoValue(infoTypeArray[i]);
                }
            } else {
                this.infovals = null;
            }
        }
    }

    private void setInfoValues() {
        this.setInfoValueTypes();
        if (this.infobuffer == null) {
            if (this.infovals != null && this.infovals.length > 0) {
                this.addErrMsg("Missing user byte[] but Non-empty format chars!");
            }
            return;
        }
        if (this.infovals != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.infobuffer);
            MixedDataInputStream mixedDataInputStream = new MixedDataInputStream(byteArrayInputStream);
            try {
                for (int i = 0; i < this.infovals.length; ++i) {
                    this.infovals[i].readValue(mixedDataInputStream);
                }
                mixedDataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            this.addErrMsg("Can't decode user byte[] with Missing format chars!");
        }
    }

    private void decodeInfoBuffer() {
        if (!this.hasBufBeenDecoded) {
            this.hasBufBeenDecoded = true;
            this.setInfoValues();
        }
    }

    public int getInfoLength() {
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int n = this.infokeys != null ? this.infokeys.length : 0;
                int n2 = this.infovals != null ? this.infovals.length : 0;
                int n3 = Math.max(n, n2);
                return n3;
            }
        }
        return 0;
    }

    public String getInfoKey(int n) {
        this.decodeInfoBuffer();
        if (this.infokeys != null && n < this.infokeys.length) {
            return this.infokeys[n];
        }
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && n < this.infokeys.length) {
                return this.infokeys[n];
            }
        }
        return null;
    }

    public InfoValue getInfoValue(int n) {
        this.decodeInfoBuffer();
        if (this.infovals != null && n < this.infovals.length) {
            return this.infovals[n];
        }
        return null;
    }

    public int getByteSize() {
        int n = 6;
        if (this.infobuffer != null) {
            n += this.infobuffer.length;
        }
        return n;
    }

    @Override
    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.type_idx);
        if (this.infobuffer != null && this.infobuffer.length > 0) {
            dataOutput.writeShort(this.infobuffer.length);
            dataOutput.write(this.infobuffer);
        } else {
            dataOutput.writeShort(0);
        }
    }

    public InfoBox(DataInput dataInput) throws IOException {
        this.readObject(dataInput);
    }

    @Override
    public void readObject(DataInput dataInput) throws IOException {
        this.type_idx = dataInput.readInt();
        short s = dataInput.readShort();
        if (s > 0) {
            this.infobuffer = new byte[s];
            dataInput.readFully(this.infobuffer);
        } else {
            this.infobuffer = null;
        }
    }

    public String toInfoBoxString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int n = this.infokeys != null ? this.infokeys.length : 0;
                int n2 = this.infovals != null ? this.infovals.length : 0;
                int n3 = Math.max(n, n2);
                for (int i = 0; i < n3; ++i) {
                    if (i < n) {
                        stringBuffer.append(this.infokeys[i]);
                    }
                    if (i >= n2) continue;
                    stringBuffer.append(this.infovals[i]);
                }
            }
        } else if (this.infovals != null) {
            for (int i = 0; i < this.infovals.length; ++i) {
                stringBuffer.append(this.infovals[i] + " ");
            }
        }
        if (this.err_msg != null) {
            stringBuffer.append("\n" + this.err_msg);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("infobox[ " + super.toString() + " ");
        if (this.type != null) {
            stringBuffer.append("Category=" + this.type + ": ");
        } else {
            stringBuffer.append("Category=" + this.type_idx + ": ");
        }
        this.decodeInfoBuffer();
        if (this.type != null) {
            this.infokeys = this.type.getInfoKeys();
            if (this.infokeys != null && this.infokeys.length > 0 || this.infovals != null && this.infovals.length > 0) {
                int n = this.infokeys != null ? this.infokeys.length : 0;
                int n2 = this.infovals != null ? this.infovals.length : 0;
                int n3 = Math.max(n, n2);
                for (int i = 0; i < n3; ++i) {
                    if (i < n) {
                        stringBuffer.append(this.infokeys[i]);
                    }
                    if (i >= n2) continue;
                    stringBuffer.append(this.infovals[i]);
                }
            }
        } else if (this.infovals != null) {
            for (int i = 0; i < this.infovals.length; ++i) {
                stringBuffer.append(this.infovals[i] + " ");
            }
        }
        if (this.err_msg != null) {
            stringBuffer.append(" **** " + this.err_msg + " **** ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

