/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import viewer.legends.LegendTable;
import viewer.legends.LegendTableModel;
import viewer.legends.Triangular3DIcon;

public class GenericHeaderRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 2400L;
    private JTable table_view;
    private int renderer_column;
    private LegendTableModel table_model;
    private JTableHeader table_header;
    private Color released_bg_color;
    private Color pressed_bg_color;
    private Icon released_tab_icon;
    private Icon pressed_tab_icon;

    public GenericHeaderRenderer(LegendTable legendTable, int n) {
        this.table_view = legendTable;
        this.renderer_column = n;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        super.setText(this.table_model.getColumnName(n));
        super.setToolTipText(this.table_model.getColumnToolTip(n));
        super.setHorizontalAlignment(0);
        super.setForeground(this.table_model.getColumnNameForeground(n));
        this.released_bg_color = this.table_model.getColumnNameBackground(n);
        this.pressed_bg_color = this.released_bg_color.darker();
        super.setBackground(this.released_bg_color);
        this.table_header = null;
        this.released_tab_icon = null;
        this.pressed_tab_icon = null;
    }

    public void initPressablePullDownTab() {
        boolean bl = this.table_model.isRaisedColumnNameIcon(this.renderer_column);
        this.released_tab_icon = new Triangular3DIcon(1, true, bl);
        this.pressed_tab_icon = new Triangular3DIcon(1, false, bl);
        this.table_header = this.table_view.getTableHeader();
        super.setHorizontalTextPosition(2);
        super.setIcon(this.released_tab_icon);
        this.table_header.addMouseListener(new RendererMouseHandler());
    }

    public void setPressed(boolean bl) {
        if (bl) {
            super.setIcon(this.pressed_tab_icon);
            super.setBackground(this.pressed_bg_color);
        } else {
            super.setIcon(this.released_tab_icon);
            super.setBackground(this.released_bg_color);
        }
        super.revalidate();
        super.repaint();
        this.table_header.repaint();
    }

    private class RendererMouseHandler
    extends MouseAdapter {
        private GenericHeaderRenderer renderer;

        public RendererMouseHandler() {
            this.renderer = GenericHeaderRenderer.this;
        }

        private boolean isMouseEventAtMyColumn(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = GenericHeaderRenderer.this.table_header.columnAtPoint(point);
            int n2 = GenericHeaderRenderer.this.table_view.convertColumnIndexToModel(n);
            return n2 == GenericHeaderRenderer.this.renderer_column;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.isMouseEventAtMyColumn(mouseEvent)) {
                this.renderer.setPressed(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isMouseEventAtMyColumn(mouseEvent)) {
                this.renderer.setPressed(false);
            }
        }
    }
}

