/*
 * Decompiled with CFR 0.152.
 */
package base.statistics;

import base.drawable.Category;
import base.drawable.CategoryWeight;
import base.statistics.CategorySummaryF;
import java.util.Comparator;

public class CategoryWeightF
extends CategorySummaryF {
    public static final int BYTESIZE = 20;
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final int INVALID_INDEX = Integer.MIN_VALUE;
    private int type_idx;
    private Category type;

    public CategoryWeightF() {
        this.type = null;
        this.type_idx = Integer.MIN_VALUE;
    }

    public CategoryWeightF(Category category, float f, float f2, double d) {
        super(f, f2, d);
        this.type = category;
        this.type_idx = this.type.getIndex();
    }

    public CategoryWeightF(CategoryWeightF categoryWeightF) {
        super(categoryWeightF);
        this.type = categoryWeightF.type;
        this.type_idx = categoryWeightF.type_idx;
    }

    public CategoryWeightF(CategoryWeight categoryWeight) {
        super(categoryWeight);
        this.type = categoryWeight.getCategory();
        this.type_idx = this.type.getIndex();
    }

    public Category getCategory() {
        return this.type;
    }

    @Override
    public String toInfoBoxString(int n) {
        StringBuffer stringBuffer = new StringBuffer("legend=");
        if (this.type != null) {
            stringBuffer.append(this.type.getName());
        } else {
            stringBuffer.append("null:" + this.type_idx);
        }
        stringBuffer.append(", ");
        stringBuffer.append(super.toInfoBoxString(n));
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(type=" + this.type_idx);
        if (this.type != null) {
            stringBuffer.append(":" + this.type.getName());
        } else {
            stringBuffer.append(", ");
        }
        stringBuffer.append(super.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static class IndexOrder
    implements Comparator {
        private IndexOrder() {
        }

        public int compare(Object object, Object object2) {
            CategoryWeightF categoryWeightF = (CategoryWeightF)object;
            CategoryWeightF categoryWeightF2 = (CategoryWeightF)object2;
            return categoryWeightF.type_idx - categoryWeightF2.type_idx;
        }
    }
}

