/*
 * Decompiled with CFR 0.152.
 */
package viewer.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import viewer.common.Dialogs;
import viewer.common.RuntimeExecCommand;

public class Launcher {
    private static String setupfile_path = null;
    private static String FileSeparator = "/";
    private static String PathSeparator = ":";
    private static String JavaHome = null;
    private static String ClassPath = null;
    private static String UserHome = null;
    private static final String VERSION_INFO = "1.0.0.1";
    private static String JVM = "java";
    private static String JVM_OPTIONS = "-Xms64m -Xmx256m";
    private static String VIEWER_JAR = "jumpshot.jar";
    private static boolean VERBOSE = true;
    private static final String CONFIGURATION_HEADER = "# Jumpshot-4 Launcher setup file.\n#VERSION_INFO: version-ID of the jumpshot-launcher.\n#JVM: Java Virtual Machine name, can be absolute path.\n#JVM_OPTIONS: JVM launch parameters.\n#VIEWER_JAR: executable jar file to be launched.\n#VERBOSE: be informative about this setup file change, true(yes) or false(no).\n";

    private static void initializeSystemProperties() {
        Properties properties = System.getProperties();
        FileSeparator = properties.getProperty("file.separator");
        PathSeparator = properties.getProperty("path.separator");
        JavaHome = properties.getProperty("java.home");
        ClassPath = properties.getProperty("java.class.path");
        UserHome = properties.getProperty("user.home");
    }

    private static void initializeLauncherConstants() {
        JVM = FileSeparator.equals("/") ? "java" : "javaw.exe";
        setupfile_path = UserHome + FileSeparator + ".jumpshot_launcher.conf";
    }

    private static String readLauncherConstants() {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(setupfile_path);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return "This is your first time using the launcher.\nA launcher setup file, " + setupfile_path + ",\n" + "will be created in your home directory.";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        StringBuffer stringBuffer = null;
        String string = properties.getProperty("VERSION_INFO");
        if (!VERSION_INFO.equals(string)) {
            stringBuffer = new StringBuffer();
            if (string != null) {
                stringBuffer.append("Your setup file verion is " + string + ".\n");
            } else {
                stringBuffer.append("Your setup file verion is older.\n");
            }
            stringBuffer.append("This launcher version is 1.0.0.1.\n");
        }
        if ((string = properties.getProperty("JVM")) != null && !JVM.equals(string)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append("The default JVM, " + JVM + ",\n" + "is overriden by value, " + string + ",\n" + "specified in your setup file.\n");
            JVM = string;
        }
        if ((string = properties.getProperty("JVM_OPTIONS")) != null && !JVM_OPTIONS.equals(string)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append("The default JVM_OPTIONS, " + JVM_OPTIONS + ",\n" + "is overriden by value, " + string + ",\n" + "specified in your setup file.\n");
            JVM_OPTIONS = string;
        }
        if ((string = properties.getProperty("VIEWER_JAR")) != null && !VIEWER_JAR.equals(string)) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append("\n");
            }
            stringBuffer.append("The default VIEWER_JAR, " + VIEWER_JAR + ",\n" + "is overriden by value, " + string + ",\n" + "specified in your setup file.\n");
            VIEWER_JAR = string;
        }
        if ((string = properties.getProperty("VERBOSE")) != null) {
            boolean bl = VERBOSE = string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes");
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    private static void writeLauncherConstants() {
        Properties properties = new Properties();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(setupfile_path);
            properties.setProperty("VERSION_INFO", VERSION_INFO);
            properties.setProperty("JVM", JVM);
            properties.setProperty("JVM_OPTIONS", JVM_OPTIONS);
            properties.setProperty("VIEWER_JAR", VIEWER_JAR);
            properties.setProperty("VERBOSE", String.valueOf(VERBOSE));
            properties.store(fileOutputStream, CONFIGURATION_HEADER);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
    }

    private static String getDefaultPathToJVM() {
        String string = null;
        File file = new File(JVM);
        string = file.isAbsolute() ? JVM : JavaHome + FileSeparator + "bin" + FileSeparator + JVM;
        return string;
    }

    private static String getDefaultPathToJarDir() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(ClassPath, PathSeparator);
        while (stringTokenizer.hasMoreTokens() && string == null) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.lastIndexOf(FileSeparator);
            if (n < 0) continue;
            string = string2.substring(0, n);
        }
        return string;
    }

    private static String getDefaultJarPath(String string) {
        if (string != null && string.length() > 0) {
            return string + FileSeparator + VIEWER_JAR;
        }
        return VIEWER_JAR;
    }

    private String exec(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = null;
        int n = 0;
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(stringArray);
            InputStreamThread inputStreamThread = new InputStreamThread(process.getErrorStream(), "Error", stringBuffer);
            InputStreamThread inputStreamThread2 = new InputStreamThread(process.getInputStream(), "Output", stringBuffer2);
            inputStreamThread.start();
            inputStreamThread2.start();
            n = process.waitFor();
            inputStreamThread.stopRunning();
            inputStreamThread = null;
            inputStreamThread2.stopRunning();
            inputStreamThread2 = null;
            if (n != 0) {
                return stringBuffer.toString();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static final void main(String[] stringArray) {
        String string;
        File file;
        String string2;
        String string3;
        File file2;
        Launcher.initializeSystemProperties();
        Launcher.initializeLauncherConstants();
        String string4 = Launcher.readLauncherConstants();
        if (string4 != null) {
            if (VERBOSE) {
                Dialogs.info(null, string4, null);
            }
            Launcher.writeLauncherConstants();
        }
        if (!(file2 = new File(string3 = Launcher.getDefaultJarPath(string2 = Launcher.getDefaultPathToJarDir()))).exists()) {
            Dialogs.error(null, string3 + " does not exist!\n" + "Make sure that " + VIEWER_JAR + " is in " + "the same directory as this launcher.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!file2.canRead()) {
            Dialogs.error(null, string3 + " is NOT readable!\n" + "Reset the read privilege of the file, " + VIEWER_JAR + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!(file = new File(string = Launcher.getDefaultPathToJVM())).exists()) {
            Dialogs.error(null, string + " does not exist!\n" + "Make sure that " + string + " exists.\n" + "Then restart this program again.");
            System.exit(1);
        }
        if (!file.canRead()) {
            Dialogs.error(null, string + " is NOT readable!\n" + "Reset the read privilege of the file, " + string + ".\n" + "Then restart this program again.");
            System.exit(1);
        }
        String string5 = JVM_OPTIONS;
        RuntimeExecCommand runtimeExecCommand = new RuntimeExecCommand();
        runtimeExecCommand.addWholeString(string);
        runtimeExecCommand.addTokenizedString(string5);
        runtimeExecCommand.addWholeString("-jar");
        runtimeExecCommand.addWholeString(string3);
        Launcher launcher = new Launcher();
        String string6 = launcher.exec(runtimeExecCommand.toStringArray());
        if (string6 != null) {
            Dialogs.error(null, "The following process exits with error:\n" + runtimeExecCommand.toString() + "\n" + string6);
            System.exit(1);
        }
        System.exit(0);
    }

    private class InputStreamThread
    extends Thread {
        private InputStream ins;
        private String prefix;
        private StringBuffer outbuffer;
        private boolean isRunning;

        public InputStreamThread(InputStream inputStream, String string, StringBuffer stringBuffer) {
            this.ins = inputStream;
            this.prefix = string;
            this.outbuffer = stringBuffer;
            this.isRunning = true;
        }

        public void stopRunning() {
            this.isRunning = false;
        }

        @Override
        public void run() {
            try {
                String string = null;
                InputStreamReader inputStreamReader = new InputStreamReader(this.ins);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while (this.isRunning && (string = bufferedReader.readLine()) != null) {
                    System.out.println(this.prefix + " > " + string);
                    if (this.outbuffer == null) continue;
                    this.outbuffer.append(string + "\n");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

