var mgDefaultSettings = {
  defaultFunctions : {
    functions : {
      browser       : new Array(),
      viewsource    : new Array(),
      messenger     : new Array(),
      mailcompose   : new Array(),
      unknownWindow : new Array()
    },

    init : function() {
      /* "b" == functions for browser
      b["mgB_ResetZoom"] = ["B", "M", "VS"] -> this function
      will work in (B)rowser, (M)essenger and (V)iew(S)ource
      ====================================================== */
      var b = this.functions.browser;
      b["mgB_AddBookmark"] = ["B", "cat5"]
      b["mgB_Back"] = ["B", "VS", "cat1"]
      b["mgB_CloseDoc"] = ["B", "cat3"]
      b["mgB_CloseTab"] = ["B", "cat2"]
      b["mgB_DoubleImageSize"] = ["B", "M", "cat4"]
      b["mgB_DoubleStackWin"] = ["B", "cat3"]
      b["mgB_DuplicateTab"] = ["B", "cat2"]
      b["mgB_Forward"] = ["B", "VS", "cat1"]
      b["mgB_HalveImageSize"] = ["B", "M", "cat4"]
      b["mgB_HideImage"] = ["B", "M", "cat4"]
      b["mgB_Home"] = ["B", "cat1"]
      b["mgB_LinksInTabs"] = ["B", "cat5"]
      b["mgB_LinksInWindows"] = ["B", "cat5"]
      b["mgB_NextTab"] = ["B", "cat2"]
      b["mgB_OpenNewDocument"] = ["B", "cat3"]
      b["mgB_OpenTab"] = ["B", "cat2"]
      b["mgB_PreviousTab"] = ["B", "cat2"]
      b["mgB_Reload"] = ["B", "cat1"]
      b["mgB_ReloadSkipCache"] = ["B", "cat1"]
      b["mgB_ResetZoom"] = ["B", "M", "VS", "cat4"]
      b["mgB_Stop"] = ["B", "cat1"]
      b["mgB_UndoCloseTab"] = ["B", "cat2"]
      b["mgB_UpDir"] = ["B", "cat1"]
      b["mgB_ViewPageInfo"] = ["B", "cat3"]
      b["mgB_ViewPageSource"] = ["B", "cat3"]
      b["mgB_ZoomIn"] = ["B", "M", "VS", "cat4"]
      b["mgB_ZoomIn_DoubleImage"] = ["B", "M", "cat4"]
      b["mgB_ZoomOut"] = ["B", "M", "VS", "cat4"]
      b["mgB_ZoomOut_HalveImage"] = ["B", "M", "cat4"]

      b["mgW_CloseWin"] = ["B", "M", "MC", "U", "VS", "cat3"]
      b["mgW_Copy"] = ["B", "M", "MC", "VS", "cat0"]
      b["mgW_Cut"] = ["B", "M", "MC", "VS", "cat0"]
      b["mgW_MinWin"] = ["B", "M", "MC", "U", "VS", "cat3"]
      b["mgW_Paste"] = ["B", "M", "MC", "VS", "cat0"]
      b["mgW_Restart"] = ["B", "M", "MC", "U", "VS", "cat3"]
      b["mgW_RestMaxWin"] = ["B", "M", "MC", "U", "VS", "cat3"]
      b["mgW_ScrollDown"] = ["B", "M", "MC", "VS", "cat4"]
      b["mgW_ScrollUp"] = ["B", "M", "MC", "VS", "cat4"]
      b["mgW_ScrollRight"] = ["B", "M", "MC", "VS", "cat4"]
      b["mgW_ScrollLeft"] = ["B", "M", "MC", "VS", "cat4"]

      //messenger
      var m = this.functions.messenger;
      m["mgM_DeleteMessage"] = ["M", "cat6"]
      m["mgM_ForwardMessage"] = ["M", "cat6"]
      m["mgM_Home"] = ["M", "cat1"]
      m["mgM_NewMessage"] = ["M", "cat6"]
      m["mgM_NextMessage"] = ["M", "cat6"]
      m["mgM_NextUnreadMessage"] = ["M", "cat6"]
      m["mgM_OpenLinks"] = ["M", "cat5"]
      m["mgM_PrevMessage"] = ["M", "cat6"]
      m["mgM_PrevUnreadMessage"] = ["M", "cat6"]
      m["mgM_Reload"] = ["M", "cat1"]
      m["mgM_ReplyMessage"] = ["M", "cat6"]
      m["mgM_ViewSource"] = ["M", "cat3"]

      //mailcompose
      var mc = this.functions.mailcompose;

      //unknown windows
      var u = this.functions.unknownWindow;
    },

    getFunctions : function() {
      return this.functions
    }
  },

  defaultMappings : {
    mappings : {
      browser       : new Array(),
      viewsource    : new Array(),
      messenger     : new Array(),
      mailcompose   : new Array(),
      unknownWindow : new Array()
    },

    /* ==================================================
    x[mapping] = {func:*, type:*, name:*, count:*, cat:*}
    type: Type of gesture
     0: built-in
        func: Built-in-function
     1: custom
        func: Encoded JavaScript
     2: keyboard
        func: Mix of ctrl|alt|shift|meta + key/charCode
        fired to document.documentElement
    9n: bookmark
        func: Unique bookmark id
        90 current Window
        91 new Window
        92 new Tab
        93 new selected Tab
        94 Sidebar

    name: Encoded name of gesture

    cat: Category of gesture
    0: Miscellaneous (not 1-6)
    1: Navigation (e.g. mgB_Back)
    2: Tabbed Browsing
    3: Window Management
    4: Zooming and Scrolling
    5: Links and Bookmarks
    6: Message Management (only TB + SM)
    ===================================================== */

    init : function() {
      //for ALL known windows
      var ALL = new Array();
      ALL["31"]  = {func: "mgW_Cut", cat: 0}
      ALL["13"]  = {func: "mgW_Copy", cat: 0}
      ALL["39"]  = {func: "mgW_Paste", cat: 0}
      ALL["DRD"] = {func: "mgW_CloseWin", cat: 3}
      ALL["LDL"] = {func: "mgW_MinWin", cat: 3}
      ALL["RUR"] = {func: "mgW_RestMaxWin", cat: 3}
      ALL["UD"]  = {func: "mgW_ScrollUp", cat: 4}
      ALL["DU"]  = {func: "mgW_ScrollDown", cat: 4}
      ALL["RL"]  = {func: "mgW_ScrollRight", cat: 4}
      ALL["LR"]  = {func: "mgW_ScrollLeft", cat: 4}

      //browser
      var b = this.mappings.browser;
      b["L"]   = {func: "mgB_Back", cat: 1}
      b["R"]   = {func: "mgB_Forward", cat: 1}
      b["LDR"] = {func: "mgB_Stop", cat: 1}
      b["LUR"] = {func: "mgB_Reload", cat: 1}
      b["LUL"] = {func: "mgB_UpDir", cat: 1}
      b["UDR"] = {func: "mgB_Home", cat: 1}
      b[":02"] = {func: "mgB_Forward", cat: 1}
      b[":20"] = {func: "mgB_Back", cat: 1}

      b["U"]   = {func: "mgB_OpenTab", cat: 2}
      b["UR"]  = {func: "mgB_NextTab", cat: 2}
      b["UL"]  = {func: "mgB_PreviousTab", cat: 2}
      b["DR"]  = {func: "mgB_CloseTab", cat: 2}
      b["LU"]  = {func: "mgB_UndoCloseTab", cat: 2}
      b["RU"]  = {func: "mgB_DuplicateTab", cat: 2}
      b[":12"] = {func: "mgB_NextTab", cat: 2}
      b[":10"] = {func: "mgB_PreviousTab", cat: 2}
      b[":2+"] = {func: "mgB_NextTab", cat: 2}
      b[":2-"] = {func: "mgB_PreviousTab", cat: 2}

      b["D"]    = {func: "mgB_OpenNewDocument", cat: 3}
      b["URDL"] = {func: "mgB_ViewPageInfo", cat: 3}
      b["LDRD"] = {func: "mgB_ViewPageSource", cat: 3}
      b["RUDR"] = {func: "mgB_DoubleStackWin", cat: 3}

      b["9"] = {func: "mgB_HideImage", cat: 4}
      b["1"] = {func: "mgB_ResetZoom", cat: 4}
      b["3"] = {func: "mgB_ZoomIn_DoubleImage", cat: 4}
      b["7"] = {func: "mgB_ZoomOut_HalveImage", cat: 4}

      b["URD"]  = {func: "mgB_AddBookmark", cat: 5}
      b["*RU"]  = {func: "mgB_LinksInWindows", cat: 5}
      b["*RUL"] = {func: "mgB_LinksInTabs", cat: 5}

      //viewsource
      var vs = this.mappings.viewsource;
      vs["3"] = {func: "mgB_ZoomIn", cat:4}
      vs["7"] = {func: "mgB_ZoomOut", cat: 4}
      vs["1"] = {func: "mgB_ResetZoom", cat: 4}

      //messenger
      var m = this.mappings.messenger;
      m["L"]    = {func: "mgM_PrevMessage", cat: 6}
      m["R"]    = {func: "mgM_NextMessage", cat: 6}
      m["D"]    = {func: "mgM_NewMessage", cat: 6}
      m["DRU"]  = {func: "mgM_DeleteMessage", cat: 6}
      m["DUR"]  = {func: "mgM_ReplyMessage", cat: 6}
      m["DURL"] = {func: "mgM_ForwardMessage", cat: 6}
      m[":20"]  = {func: "mgM_PrevMessage", cat: 6}
      m[":02"]  = {func: "mgM_NextMessage", cat: 6}
      m["LUR"]  = {func: "mgM_Reload", cat: 1}
      m["UDR"]  = {func: "mgM_Home", cat: 1}
      m["LDRD"] = {func: "mgM_ViewSource", cat: 3}
      m["1"]    = {func: "mgB_ResetZoom", cat: 4}
      m["9"]    = {func: "mgB_HideImage", cat: 4}
      m["3"]    = {func: "mgB_ZoomIn_DoubleImage", cat: 4}
      m["7"]    = {func: "mgB_ZoomOut_HalveImage", cat: 4}
      m["*RUL"] = {func: "mgM_OpenLinks", cat: 5}

      //mailcompose
      var mc = this.mappings.mailcompose;

      //unknown windows
      var u = this.mappings.unknownWindow;
      u["DRD"] = {func: "mgW_CloseWin", cat: 3}
      u["LDL"] = {func: "mgW_MinWin", cat: 3}
      u["RUR"] = {func: "mgW_RestMaxWin", cat: 3}

      for (wtype in this.mappings) {
        if (wtype != "unknownWindow") {
          for (mapping in ALL)
            this.mappings[wtype][mapping] = ALL[mapping];
        }
      }
    },

    getMappings : function() {
      var bundle = Components.classes["@mozilla.org/intl/stringbundle;1"].getService()
                   .QueryInterface(Components.interfaces.nsIStringBundleService)
                   .createBundle("chrome://mozgest/locale/mozgest.properties");

      for (component in this.mappings) {
        for (mapping in this.mappings[component]) {
          var func = this.mappings[component][mapping].func;
          var name = encodeURIComponent(bundle.GetStringFromName(func));
          this.mappings[component][mapping].type = "0";
          this.mappings[component][mapping].name = name;
        }
      }

      return this.mappings
    }
  },

  defaultPrefs : {
    prefs : new Array(),

    init : function() {
      var p = this.prefs

      //int [default, min, max]
      p["grid"] = [15, 4, 500]
      p["delay"] = [1000, 200, 10000]
      p["lmbGestureLimit"] = [500, 100, 10000]
      p["staticRockersDelay"] = [1000, 200, 10000]
      p["staticWheelRockersDelay"] = [1000, 200, 10000]
      p["diagonalTolerance"] = [60, 0, 75]
      p["mousebutton"] = [2, 0, 2]
      p["trails.width"] = [7, 1, 100]
      p["trails.interval"] = [1, 1, 100]
      p["status.align"] = [0, 0, 3]
      p["status.timeout"] = [1000, 0, 5000]
      p["misc.selectedTab"] = [4, 0, 4]
      p["misc.funcPref.mgWScroll.scrollBy"] = [200, 1, 1000000]
      p["misc.funcPref.mgB_LinksInWindows.maxLinks"] = [25, 1, 50]

      //bool
      p["enableDump"] = [false]
      p["enableStrokes"] = [true]
      p["enableRockers"] = [true]
      p["staticRockers"] = [false]
      p["enableWheelRockers"] = [false]
      p["staticWheelRockers"] = [false]
      p["lefthanded"] = [false]
      p["modifier.ctrl"] = [false]
      p["modifier.alt"] = [false]
      p["modifier.shift"] = [false]
      p["modifier.meta"] = [false]
      p["modifier.ctrlDisables"] = [false]
      p["modifier.altDisables"] = [false]
      p["modifier.shiftDisables"] = [false]
      p["modifier.metaDisables"] = [false]
      p["pluginSupport"] = [false]
      p["trails.enabled"] = [true]
      p["status.isEnabled"] = [true]
      p["misc.sideBar.canvas"] = [true]
      p["misc.mappingsWin.canvas"] = [true]
      p["misc.sideBar.sortByUsage"] = [true]
      p["misc.mappingsWin.sortByUsage"] = [false]
      p["window.browser"] = [true]
      p["window.viewsource"] = [true]
      p["window.messenger"] = [true]
      p["window.mailcompose"] = [true]
      p["window.unknownWindow"] = [false]

      //char
      p["trails.color"] = ["#FF9900"]
      p["misc.importFrom"] = ["www.mousegestures.org"]
      p["sites.excluded"] = [""]
    },

    getPref : function(pref) {
      if (pref in this.prefs)
        return this.prefs[pref];
      else
        return ["notFound"];
    }
  }

}