// Copyright 2010-2011, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef MOZC_GUI_CONFIG_DIALOG_AUTH_DIALOG_H_
#define MOZC_GUI_CONFIG_DIALOG_AUTH_DIALOG_H_

#include <QtCore/QTimer>
#include <QtGui/QtGui>
#include <QtGui/QDialog>
#include <string>
#include "gui/config_dialog/auth_code_detector.h"
#include "gui/config_dialog/ui_auth_dialog.h"

namespace mozc {
namespace gui {
class AuthDialog : public QDialog,
                   private Ui::AuthDialog {
  Q_OBJECT;

 public:
  AuthDialog(QWidget *parent);
  virtual ~AuthDialog();

  string GetAuthCode() const;

  public slots:
  void browserButtonClicked();
  void handleTextChange(const QString &new_text);

  static bool Show(QWidget *parent, string *auth_code);

 private:
  string auth_code_;
  scoped_ptr<QTimer> detector_timer_;
  scoped_ptr<AuthCodeDetector> auth_code_detector_;
};
}  // namespace mozc::gui
}  // namespace mozc
#endif  // MOZC_GUI_CONFIG_DIALOG_AUTH_DIALOG_H_
