// 
// SubviewAttachmentHandler.cs
//  
// Author:
//       Mike Krüger <mkrueger@novell.com>
// 
// Copyright (c) 2010 Novell, Inc (http://www.novell.com)
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
using System;
using System.Linq;
using MonoDevelop.Components.Commands;
using Mono.Addins;
using MonoDevelop.VersionControl;
using MonoDevelop.Ide.Gui;

namespace MonoDevelop.VersionControl.Views
{
	class SubviewAttachmentHandler : CommandHandler
	{
		protected override void Run ()
		{
			Ide.IdeApp.Workbench.DocumentOpened += HandleDocumentOpened;
		}

		void HandleDocumentOpened (object sender, Ide.Gui.DocumentEventArgs e)
		{
			if (!e.Document.IsFile || e.Document.Project == null)
				return;
			
			var repo = VersionControlService.GetRepository (e.Document.Project);
			if (repo == null || !repo.GetVersionInfo (e.Document.FileName).IsVersioned)
				return;
			
			var item = new VersionControlItem (repo, e.Document.Project, e.Document.FileName, false, null);
			TryAttachView <IDiffView> (e.Document, item, DiffCommand.DiffViewHandlers);
			TryAttachView <IBlameView> (e.Document, item, BlameCommand.BlameViewHandlers);
			TryAttachView <ILogView> (e.Document, item, LogCommand.LogViewHandlers);
			TryAttachView <IMergeView> (e.Document, item, MergeCommand.MergeViewHandlers);
		}
		
		void TryAttachView <T>(Document document, VersionControlItem item, string type)
			where T : IAttachableViewContent
		{
			var handler = AddinManager.GetExtensionObjects<IVersionControlViewHandler<T>> (type).FirstOrDefault (h => h.CanHandle (item));
			if (handler != null) {
				document.Window.AttachViewContent (handler.CreateView (item, document.PrimaryView));
			}
		}
	}
}

