#include "AllObjects.h"
#include "ObjectRepository.h"
#include "GameRecorder.h"


//----------------------------------------------------------------------------
GameRecorder GameRecorder::sm_instance;

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Barrier *b)
{
    Uint16 id = b->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new BarrierPDU(b);
    }
    else
    {
        BarrierPDU *pdu =
            static_cast<BarrierPDU*>(updateIter->second);
        pdu->update(b);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const BlackHole *b)
{
    Uint16 id = b->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new BlackHolePDU(b);
    }
    else
    {
        BlackHolePDU *pdu =
            static_cast<BlackHolePDU*>(updateIter->second);
        pdu->update(b);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Crate *c)
{
    Uint16 id = c->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new CratePDU(c);
    }
    else
    {
        CratePDU *pdu =
            static_cast<CratePDU*>(updateIter->second);
        pdu->update(c);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Grenade *g)
{
    Uint16 id = g->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new GrenadePDU(g);
    }
    else
    {
        GrenadePDU *pdu =
            static_cast<GrenadePDU*>(updateIter->second);
        pdu->update(g);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Grinder *g)
{
    Uint16 id = g->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new GrinderPDU(g);
    }
    else
    {
        GrinderPDU *pdu =
            static_cast<GrinderPDU*>(updateIter->second);
        pdu->update(g);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const MagnetBase *m)
{
    Uint16 id = m->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new MagnetBasePDU(m);
    }
    else
    {
        MagnetBasePDU *pdu =
            static_cast<MagnetBasePDU*>(updateIter->second);
        pdu->update(m);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Missile *m)
{
    Uint16 id = m->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new MissilePDU(m);
    }
    else
    {
        MissilePDU *pdu =
            static_cast<MissilePDU*>(updateIter->second);
        pdu->update(m);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const MortarBase *m)
{
    Uint16 id = m->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new MortarBasePDU(m);
    }
    else
    {
        MortarBasePDU *pdu =
            static_cast<MortarBasePDU*>(updateIter->second);
        pdu->update(m);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const ParticleFountainBase *f)
{
    Uint16 id = f->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new ParticleFountainBasePDU(f);
    }
    else
    {
        ParticleFountainBasePDU *pdu =
            static_cast<ParticleFountainBasePDU*>(updateIter->second);
        pdu->update(f);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Platform *p)
{
    Uint16 id = p->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new PlatformPDU(p);
    }
    else
    {
        PlatformPDU *pdu =
            static_cast<PlatformPDU*>(updateIter->second);
        pdu->update(p);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const ProjectileBase *p)
{
    Uint16 id = p->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new ProjectileBasePDU(p);
    }
    else
    {
        ProjectileBasePDU *pdu =
            static_cast<ProjectileBasePDU*>(updateIter->second);
        pdu->update(p);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const SAMBatteryBase *s)
{
    Uint16 id = s->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new SAMBatteryBasePDU(s);
    }
    else
    {
        SAMBatteryBasePDU *pdu =
            static_cast<SAMBatteryBasePDU*>(updateIter->second);
        pdu->update(s);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Ship *s)
{
    Uint16 id = s->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new ShipPDU(s);
    }
    else
    {
        ShipPDU *pdu =
            static_cast<ShipPDU*>(updateIter->second);
        pdu->update(s);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const SwitchBase *s)
{
    Uint16 id = s->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new SwitchBasePDU(s);
    }
    else
    {
        SwitchBasePDU *pdu =
            static_cast<SwitchBasePDU*>(updateIter->second);
        pdu->update(s);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Tank *t)
{
    Uint16 id = t->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new TankPDU(t);
    }
    else
    {
        TankPDU *pdu =
            static_cast<TankPDU*>(updateIter->second);
        pdu->update(t);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const Thorn *t)
{
    Uint16 id = t->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new ThornPDU(t);
    }
    else
    {
        ThornPDU *pdu =
            static_cast<ThornPDU*>(updateIter->second);
        pdu->update(t);
        pdu->m_visited = true;
    }
}

//----------------------------------------------------------------------------
void GameRecorder::PreparePDUsConstVisitor::do_visit(const TurretBase *t)
{
    Uint16 id = t->getId();
    ObjectPDUs::iterator updateIter = m_recorder->m_updatePDUs.find(id);

    if (updateIter == m_recorder->m_updatePDUs.end())
    {
        m_recorder->m_createPDUs[id] = new TurretBasePDU(t);
    }
    else
    {
        TurretBasePDU *pdu =
            static_cast<TurretBasePDU*>(updateIter->second);
        pdu->update(t);
        pdu->m_visited = true;
    }
}



//----------------------------------------------------------------------------
void GameRecorder::AppendToBufferConstVisitor::appendUint8(const Uint8 value)
{
    m_buffer.push_back(value);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendToBufferConstVisitor::appendUint16(const Uint16 value)
{
    m_buffer.push_back((value & 0xff00) >> 8);
    m_buffer.push_back(value & 0x00ff);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendToBufferConstVisitor::appendUint32(const Uint32 value)
{
    m_buffer.push_back((value & 0xff000000) >> 24);
    m_buffer.push_back((value & 0x00ff0000) >> 16);
    m_buffer.push_back((value & 0x0000ff00) >> 8);
    m_buffer.push_back(value & 0x000000ff);
}



//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_objectPDUBase(const ObjectPDUBase *pdu)
{
    appendUint16(pdu->m_id);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_staticDecorationObjectPDUBase(const StaticDecorationObjectPDUBase *pdu)
{
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}


//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const BarrierPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
    appendUint8(pdu->m_activated);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const BlackHolePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const CratePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_type);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const GrenadePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const GrinderPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const MagnetBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
    appendUint8(pdu->m_wh);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const MissilePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint16(pdu->m_angle);
    appendUint8(pdu->m_thrust);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const MortarBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const ParticleFountainBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const PlatformPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_w);
    appendUint8(pdu->m_leftEdge);
    appendUint8(pdu->m_rightEdge);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const ProjectileBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const SAMBatteryBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const ShipPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint8(pdu->m_type);
    appendUint16(pdu->m_angle);
    appendUint8(pdu->m_thrust);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const SwitchBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const TankPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_objectPDUBase(pdu);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const ThornPDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
    appendUint16(pdu->m_size);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const TurretBasePDU *pdu)
{
    appendUint16(pdu->sm_createPDUId);
    do_staticDecorationObjectPDUBase(pdu);
    appendUint8(pdu->m_orientation);
    appendUint8(pdu->m_type);
}


//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const HeaderPDU *pdu)
{
    appendUint16(pdu->sm_pduId);
    appendUint16(pdu->m_version);
    appendUint16(pdu->m_length);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendCreatePDUToBufferConstVisitor::do_visit(const DeleteObjectPDU *pdu)
{
    appendUint16(pdu->sm_pduId);
    appendUint16(pdu->m_id);
}



//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const BarrierPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint8(pdu->m_activated);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const BlackHolePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const CratePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const GrenadePDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const GrinderPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const MagnetBasePDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const MissilePDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint16(pdu->m_angle);
    appendUint8(pdu->m_thrust);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const MortarBasePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const ParticleFountainBasePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const PlatformPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint8(pdu->m_frame);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const ProjectileBasePDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const SAMBatteryBasePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const ShipPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
    appendUint16(pdu->m_angle);
    appendUint8(pdu->m_thrust);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const SwitchBasePDU *pdu)
{
    // Nothing to update here.
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const TankPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_x);
    appendUint16(pdu->m_y);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const ThornPDU *pdu)
{
    appendUint16(pdu->sm_updatePDUId);
    appendUint16(pdu->m_id);
    appendUint16(pdu->m_size);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const TurretBasePDU *pdu)
{
    // Nothing to update here.
}


//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const HeaderPDU *pdu)
{
    assert(false);
}

//----------------------------------------------------------------------------
void GameRecorder::AppendUpdatePDUToBufferConstVisitor::do_visit(const DeleteObjectPDU *pdu)
{
    assert(false);
}



//----------------------------------------------------------------------------
GameRecorder::GameRecorder()
{
    m_file = new File("/tmp/moagg.data", "w");
}

//----------------------------------------------------------------------------
GameRecorder::~GameRecorder()
{
    ZAP_POINTER(m_file);
}

//----------------------------------------------------------------------------
void GameRecorder::writeFrame()
{
    convertCreatePDUs2UpdatePDUs();
    processObjects();
    convertNotVisitedUpdatePDUs2DeletePDUs();

    std::vector<char> buffer;
    buffer.reserve(256);
    encodePDUs(buffer);

    size_t size = buffer.size();
    assert(size >= 6);
    size -= 6;

    // Fix the payload length of this frame.
    buffer[4] = (size & 0xff00) >> 8;
    buffer[5] = (size & 0x00ff);

    m_file->write(&*buffer.begin(), buffer.size());
}

//----------------------------------------------------------------------------
void GameRecorder::convertCreatePDUs2UpdatePDUs()
{
    for (ObjectPDUs::iterator
             iter = m_createPDUs.begin(),
             end = m_createPDUs.end();
         iter != end; ++iter)
    {
        m_updatePDUs[iter->first] = iter->second;
    }

    m_createPDUs.clear();
}

//----------------------------------------------------------------------------
void GameRecorder::processObjects()
{
    PreparePDUsConstVisitor v(this);
    ObjectRepository::getInstance()->acceptObjects(v);
}

//----------------------------------------------------------------------------
void GameRecorder::convertNotVisitedUpdatePDUs2DeletePDUs()
{
    ObjectPDUs::iterator iter = m_updatePDUs.begin();
    while (iter != m_updatePDUs.end())
    {
        if (!iter->second->m_visited)
        {
            m_deletePDUs[iter->first] = new DeleteObjectPDU(iter->first);
            delete iter->second;
            m_updatePDUs.erase(iter++);
        }
        else
        {
            ++iter;
        }
    }
}

//----------------------------------------------------------------------------
void GameRecorder::encodePDUs(std::vector<char> &buffer)
{
    AppendCreatePDUToBufferConstVisitor vc(buffer);
    AppendUpdatePDUToBufferConstVisitor vu(buffer);

    HeaderPDU header;
    header.accept(vc);

    for (ObjectPDUs::const_iterator
             iter = m_createPDUs.begin(),
             end = m_createPDUs.end();
         iter != end; ++iter)
    {
        iter->second->accept(vc);
    }

    for (ObjectPDUs::iterator
             iter = m_updatePDUs.begin(),
             end = m_updatePDUs.end();
         iter != end; ++iter)
    {
        if (iter->second->m_modified)
        {
            iter->second->accept(vu);
        }

        // Reset the UpdatePDU's flag for the next call of writeFrame().
        iter->second->m_modified = false;
        iter->second->m_visited = false;
    }

    for (PDUs::iterator
             iter = m_deletePDUs.begin(),
             end = m_deletePDUs.end();
         iter != end; ++iter)
    {
        iter->second->accept(vc);
        delete iter->second;  // DeletePDUs are only needed once.
    }
    m_deletePDUs.clear();
}
