      SUBROUTINE M_SDIR(NMODE,IERR)
C
C     Sets up both the file and memory directories consistently
C     with the current directory definition
C     NMODE = 0 means input file //MN_HBIN
C     NMODE = 1 means normal output file //MN_HBOUT
C     NMODE = 2 means temporary output file //MN_TEM
C     NMODE = 3 means memory only
C     NMODE = 4 means merge input file //MRGIN
C     NMODE = 5 means merge output file //MRGOUT
C
#include "mnpar.inc"
#include "mnflg.inc"
#include "mnlun.inc"
#include "quest.inc"
C
      INTEGER NMODE,IERR
C
      INTEGER MAXDIR
      PARAMETER (MAXDIR=20)
      CHARACTER*20 CHDIR(MAXDIR)
      CHARACTER*20 TSDIR
      INTEGER NDIR
C
      CHARACTER*10 TIDIR(0:5),TODIR(0:5)
C
      CHARACTER*80 TXT1,TXT2,TDIRI
      CHARACTER*80 TTMP
C
      DATA TIDIR/'//MN_HBIN','//PAWC',     '//PAWC',  '//PAWC',
     + '//MRGIN', '//PAWC'/
      DATA TODIR/'//PAWC',   '//MN_HBOUT', '//MN_TEM',' ',
     + '//PAWC', '//MRGOUT'/
C
      IERR = 0
C
C     Check if the mode is OK
C
      IF(NMODE.LT.0 .OR. NMODE.GT.5) THEN
          CALL MN_ERR('M_SDIR','M_SDIR called with an illegal flag')
          GOTO 9000
      ENDIF
C
C     Set the top level directly properly
C
      CALL HCDIR(TXT1,'R')
      LENT = LNBLNK(TXT1)
      TDIRI = TXT1
      LDIRI = LENT
      IND = INDEX(TXT1(3:),'/')
      LEND = LNBLNK(TIDIR(NMODE))
      IF(IND.LE.0) THEN
          TXT2 = TIDIR(NMODE)(1:LEND)
      ELSE
          N1 = IND + 2
          TXT2 = TIDIR(NMODE)(1:LEND) // TXT1(N1:LENT)
      ENDIF
      CALL HCDIR(TXT2,' ')
      IF(DIR_HB.NE.' ') THEN
          CALL HCDIR(DIR_HB,' ')
          IF(IQUEST(1).NE.0) THEN
              IERR = 1
              len2 = lnblnk(txt2)
              LENH = LNBLNK(DIR_HB)
              TXTERR = 'HBOOK directory' // TXT2(1:LEN2) //
     +         DIR_HB(1:LENH) // ' does not exist'
              CALL MN_ERR('M_SDIR',TXTERR)
          ENDIF
          DIR_HB = ' '
          IF(IERR.NE.0) GOTO 9000
      ENDIF
      CALL HCDIR(TXT1,'R')
C
      LENT = MAX0(1,LNBLNK(TXT1))
CICB      WRITE(TXTMES,'('' The current HBOOK directory is: '',A)')
CICB     + TXT1(1:LENT)
CICB      LENMES = MAX0(1,LNBLNK(TXTMES))
CICB      WRITE(LUNTTO,'(A)') TXTMES(1:LENMES)
C
      IF(NMODE.EQ.3) GOTO 3000
C
C     Look for the subdirectory. If it does not exist create it
C     Must first skip past the top level directory name
C
      IND = INDEX(TXT1(3:),'/')
      IF(IND.LE.0) GOTO 3000
      N1 = IND + 3
C
C     Start at the top level and then work down all the sub-directories
C     checking that they exist in memory and on the file.
C
      LENO = LNBLNK(TODIR(NMODE))
      CALL HCDIR(TODIR(NMODE)(1:LENO),' ')
      CALL HCDIR(TXT2,'R')
      LEN2 = LNBLNK(TXT2)
C      WRITE(6,'('' M_SDIR: Top level directory set to: '',A)')
C     + TXT2(1:LEN2)
C
1000  CONTINUE
C
C     Find the current subdirectory name
C
      IND = INDEX(TXT1(N1:),'/')
      IF(IND.LE.0) THEN
          N2 = LNBLNK(TXT1) + 1
      ELSE
          N2 = N1 + IND - 1
      ENDIF
      TSDIR = TXT1(N1:N2-1)
      CALL CLTOU(TSDIR)
      LENS = LNBLNK(TSDIR)
C
C     See if it exists in memory if this is mode 0 or in the
C     output file if it is any other mode
C
CICB      call hldir(' ',' ')
      CALL HRDIR(MAXDIR,CHDIR,NDIR)
      DO I=1,NDIR
          CALL CLTOU(CHDIR(I))
          IF(CHDIR(I).EQ.TSDIR(1:LENS)) THEN
              CALL HCDIR(TSDIR(1:LENS),' ')
              GOTO 2800
          ENDIF
      ENDDO
c      CALL HCDIR(TSDIR(1:LENS),' ')
c      IF(IQUEST(1).NE.0) THEN
          TXTMES = ' M_SDIR: Creating HBOOK directory: ' //
     +     TXT2(1:LEN2) // '/' // TSDIR(1:LENS)
          LENMES = MAX0(1,LNBLNK(TXTMES))
          WRITE(LUNTTO,'(A)') TXTMES(1:LENMES)
          CALL HMDIR(TSDIR(1:LENS),'S')
c      ENDIF
C
 2800 CONTINUE
      TXT2(LEN2+1:) = '/' // TSDIR(1:LENS)
      LEN2 = LEN2 + LENS + 1
      CALL HCDIR(TTMP,'R')
      LEN4 = LNBLNK(TTMP)
C      WRITE(6,'('' M_SDIR: Set to subdirectory: '',A)') TTMP(1:LEN4)
C
      N1 = N2 + 1
      IF(N1.LT.LENT) GOTO 1000
C
C     Directories now exist. Set both memory and the file to the
C     same directory name
C
3000  CONTINUE
      IND = INDEX(TXT1(3:),'/')
      N1  = IND + 2
      LENI = LNBLNK(TIDIR(NMODE))
      LENO = LNBLNK(TODIR(NMODE))
      IF(IND.EQ.0) THEN
          IF(NMODE.EQ.0) THEN
              CALL HCDIR(TODIR(NMODE)(1:LENO),' ')
          ENDIF
          CALL HCDIR(TIDIR(NMODE)(1:LENI),' ')
          IF(NMODE.EQ.1 .OR. NMODE.EQ.2) THEN
              CALL HCDIR(TODIR(NMODE)(1:LENO),' ')
          ENDIF
      ELSE
          IF(NMODE.EQ.0) THEN
              TXT2 = TODIR(NMODE)(1:LENO) // TXT1(N1:LENT)
              LEN2 = LNBLNK(TXT2)
              CALL HCDIR(TXT2(1:LEN2),' ')
          ENDIF
          TXT2 = TIDIR(NMODE)(1:LENI) // TXT1(N1:LENT)
          LEN2 = LNBLNK(TXT2)
          CALL HCDIR(TXT2(1:LEN2),' ')
          IF(NMODE.EQ.1 .OR. NMODE.EQ.2) THEN
              TXT2 = TODIR(NMODE)(1:LENO) // TXT1(N1:LENT)
              LEN2 = LNBLNK(TXT2)
              CALL HCDIR(TXT2(1:LEN2),' ')
          ENDIF
      ENDIF
C
      CALL HCDIR(DIR_HC,'R')
C
      LENT = MAX0(1,LNBLNK(DIR_HC))
      IF(TDIRI(1:LDIRI).NE.DIR_HC(1:LENT)) THEN
          WRITE(TXTMES,'('' HBOOK directory set to: '',A)')
     +     DIR_HC(1:LENT)
          LENMES = MAX0(1,LNBLNK(TXTMES))
          WRITE(LUNTTO,'(A)') TXTMES(1:LENMES)
      ENDIF
C
9000  CONTINUE
      END
