      subroutine mn_rootr(ida1,ida2,idb1,idb2,nnid,ierr)
*-----------------------------------------------------------------------
*     Routine for reading in all or a range of root histograms
*
*     $Id: mn_rootr.fpp,v 1.4 2005/06/06 09:29:16 brock Exp $
*-----------------------------------------------------------------------
      implicit none
*
      integer ida1,ida2,idb1,idb2,nnid,ierr
*
#include "mnlun.inc"
#if ( defined(ROOT) )
#include "mnpar.inc"
#include "mnflg.inc"
#include "mnroot.inc"
*
      character chid(mhstmx)*40,tid*50,tidh*10
      integer lenid(mhstmx)
      integer nid,i,idr,ida,idb,leni
      logical qrnge,qzero
*
      integer m_root_exist, lnblnk
#endif
*
*-----------------------------------------------------------------------
*
#if ( !defined(ROOT) )
      txterr = 'Root not in this Mn_Fit version'
      call mn_err('MN_ROOTR',txterr)
      ierr = 1
      goto 9000
#else
*
      ierr = 0
      qzero = ida1.eq.0
      qrnge = ida2.gt.ida1
*
      if(qzero) then
        call vzero(lenid,mhstmx)
        call m_root_id(nid, 40, mhstmx, lenid, chid)
        write(6,'('' Will try to fetch'',I5,'' histograms'')') nid
        do i=1,nid
          write(6,'('' Name: '',A,'', Length'',I3,'', ID'',I8)')
     +     chid(i)(1:max(1,lenid(i))), lenid(i), idroot-1+i
        enddo
*
        idr = idroot - 1
        do i=1,nid
          idr = idr + 1
          tid = ' '
          tidh = ' '
          leni = max(1,lenid(i))
          call csetdi(idr,tidh,1,10)
          call cleft(tidh,1,10)
          tid = chid(i)(:leni) // ';' // tidh
          call mn_rooth(tid,ida,idb,ierr)
          if(ierr.ne.0) then
            write(txterr,'(''Error fetching root histogram''
     +       ,I7,I4)') IDA,IDB
            call m_emsg('MN_ROOTR',txterr)
          endif
        enddo
      elseif(qrnge) then
        do idr=ida1,ida2
          tidh = ' '
          call csetdi(idr,tidh,1,10)
          call cleft(tidh,1,10)
          tid = 'h' // tidh
          leni = lnblnk(tid)
          if(m_root_exist(leni,tid).eq.0) then
            tid = 'h' // tidh // ';' // tidh
            call mn_rooth(tid,ida,idb,ierr)
          endif
        enddo
      endif
#endif
*
9000  continue
      end
