      SUBROUTINE M_NTPMRG(IDELIM)
C
C-----------------------------------------------------------------------
C
C     Merges Ntuples of the same id from different files into a single
C     Ntuple on another file.
C     This should probably be replaced by HMERGE!
C
C     Called by MN_NTP
C
C-----------------------------------------------------------------------
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnlun.inc"
#include "quest.inc"
C
      CHARACTER*80 TFILI,TFILO,TITLE,TXT1,TXT2
      CHARACTER*80 TDIRI,TDIRO,TDIRM,TDIR
      CHARACTER*32 TNAME(MDIMMX)
      REAL RVAL(MDIMMX),ADLO(MDIMMX),ADHI(MDIMMX)
      INTEGER IDH,NVAL,NCHRI,NCHRO,IDELIM,IERR,IOERR,I
     + ,NPNT,NEVTOT,NVARO,NVAR,NPRIME
      LOGICAL QNEW,QHFO,QHFI,HEXIST,QEXIST,accessf
      CHARACTER*1 TOPT
C
      logical  hntnew
      external hntnew
C
C     Close any histogram files that are open
C
      CALL M_HCLS
C
      QHFO = .FALSE.
      CALL WAITYQ('Give Ntuple Identifier: ')
      NVAL = IVLTYQ(.TRUE.,IDELIM)
      CALL MN_NCK(NVAL,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
      IDH = NVAL
C
      CALL WAITYQ('Give output filename: ')
      NCHRO = ISLTYQ(.TRUE.,IDELIM,TFILO)
      IF(IDELIM.GT.0 .OR. NCHRO.LE.0) GOTO 9000
C
      txt1 = tfilo
      call m_pfil(2,txt1,ierr)
#if ( defined(UNIX) )
      qexist = accessf(txt1,0)
#endif
#if ( defined(VMS) )
      INQUIRE(FILE=txt1,EXIST=QEXIST)
#endif

c      IF(QEXIST) THEN
c         TOPT = 'U'
c      ELSE
          TOPT = 'N'
c      ENDIF
      CALL MN_FIL(-47,LUNO,TFILO,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
      NCHRO = LENOCC(TFILO)
      TXTMES = ' M_NTPMRG: Opened HBOOK output file with option ' //
     + TOPT
      CALL MN_MES(LUNTTO,'ME',TXTMES)
*ICB      CALL HRFILE(LUNO,'MRGOUT',TOPT)
      QHFO = .TRUE.
C
C     Loop over the input filenames
C
      QNEW = .TRUE.
      ICYCLE = 99999
      CALL WAITYQ('Give list of input filenames (<CR> when finished): ')
      NEVTOT = 0
2000  CONTINUE
      IERR  = 1
      TFILI = ' '
      NCHRI = ISLTYQ(.TRUE.,IDELIM,TFILI)
      IF(NCHRI.LE.0) THEN
          IF(.NOT.QNEW) IERR = 0
          GOTO 9000
      ENDIF
C
      IF(.NOT.QNEW) THEN
          CALL HCDIR('//PAWC',' ')
*ICB          CALL HCDIR('//MN_HBIN',' ')
          CALL HCDIR('//MRGIN',' ')
*
*         HREND seems to also close MN_HBOUT on Linux machines with 97a
*         Assume this is no longer a problem or 2000+ version of CERNLIB
*
*ICB          CALL HRENDC('MN_HBIN')
          CALL HRENDC('MRGIN')
*ICB          CALL HCDIR('//MN_HBOUT',' ')
          CALL HCDIR('//MRGOUT',' ')
      ENDIF
C
      QHFI = .FALSE.
      NMODE = 47
      CALL MN_FIL(NMODE,LUNI,TFILI,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
      NCHRI = LENOCC(TFILI)
*ICB      CALL HRFILE(LUNI,'MRGIN',' ')
      QHFI = .TRUE.
      IERR = 1
C
C     Make sure the directory structure is as required
C
      IF(QNEW) THEN
          CALL M_SDIR(4,IERR)
          IF(IERR.NE.0) GOTO 9000
          CALL M_SDIR(5,IERR)
          IF(IERR.NE.0) GOTO 9000
          CALL HCDIR(TDIR,'R')
          IND = INDEX(TDIR(3:),'/')
          IF(IND.GT.0) THEN
              TDIRM = '//PAWC' // TDIR(IND+2:)
*ICB              TDIRI = '//MN_HBIN' // TDIR(IND+2:)
*ICB              TDIRO = '//MN_HBOUT' // TDIR(IND+2:)
              TDIRI = '//MRGIN' // TDIR(IND+2:)
              TDIRO = '//MRGOUT' // TDIR(IND+2:)
          ELSE
              TDIRM = '//PAWC'
*ICB              TDIRI = '//MN_HBIN'
*ICB              TDIRO = '//MN_HBOUT'
              TDIRI = '//MRGIN'
              TDIRO = '//MRGOUT'
          ENDIF
      ENDIF
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR(TDIRI,' ')
C
C     Read in and get the characteristics of the Ntuple
C
      IF(HEXIST(IDH)) CALL HDELET(IDH)
      CALL HRIN(IDH,ICYCLE,0)
      IF(.NOT.HEXIST(IDH)) THEN
          LEND = LENOCC(TDIRI)
          WRITE(TXTERR,'(''Ntuple'',I7,'' does not exist in directory ''
     +     ,A)',IOSTAT=IOERR) IDH,TDIRI(1:LEND)
          CALL MN_ERR('M_NTPMRG',TXTERR)
          GOTO 9000
      ENDIF
C
      NVAR = MDIMMX
      CALL HGIVEN(IDH,TITLE,NVAR,TNAME,ADLO,ADHI)
      IF(NVAR.LE.0) THEN
          TXTERR = 'Plot in file ' // TFILI(1:NCHRI) //
     +     'is not an Ntuple'
          CALL MN_ERR('M_NTPMRG',TXTERR)
          GOTO 9000
      ENDIF
      IF(NVAR.GT.MDIMMX) THEN
          WRITE(TXTERR,'(''Plot'',I7,'' has'',I4
     1     ,'' dimensions, but I can only cope with 1 ->'',I4)')
     2     IDH,NVAR,MDIMMX
          CALL MN_ERR('M_NTPMRG',TXTERR)
          GOTO 9000
      ENDIF
C
C     Check for CWN
C
      if(hntnew(idh)) then
          WRITE(TXTERR,'(''Plot'',I7,'' is a CWN.''
     1     ,'' I cannot merge a CWN - sorry'')')
     2     IDH
          CALL MN_ERR('M_NTPMRG',TXTERR)
          GOTO 9000
      endif
C
      CALL HNOENT(IDH,NPNT)
C
C     Make a new Ntuple or check that the new one is the
C     same as the previous one
C
      IF(QNEW) THEN
          CALL HCDIR('//PAWC',' ')
          CALL HCDIR('//PAWC/TMP',' ')
          CALL HCDIR(TXT1,'R')
          IF(TXT1.NE.'//PAWC/TMP') THEN
              TXTMES = ' M_NTPMRG: Creating a temporary directory' //
     +         ' //PAWC/TMP'
              CALL MN_MES(LUNTTO,'ME',TXTMES)
              CALL HMDIR('TMP',' ')
              CALL HCDIR('//PAWC/TMP',' ')
          ENDIF
          IF(HEXIST(IDH)) CALL HDELET(IDH)
CICB          NPRIME = MIN0(1000,MIN0(100*NVAR,10000))
          NPRIME = MIN0(10000,MIN0(10000*NVAR,50000))
          CALL HBOOKN(IDH,TITLE,NVAR,TDIRO,NPRIME,TNAME)
          NVARO = NVAR
      ELSEIF(NVAR.NE.NVARO) THEN
          WRITE(TXTERR
     +     ,'(''Ntuple has a different number of dimensions''
     +     ,/,'' Old/New'',2I4)',IOSTAT=IOERR) NVARO,NVAR
          CALL M_EMSG('M_NTPMRG',TXTERR)
          TXTERR = TFILI(1:NCHRI)
          CALL MN_ERR('M_NTPMRG',TXTERR)
          GOTO 9000
      ENDIF
      QNEW = .FALSE.
C
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR(TDIRI,' ')
      CALL HGNPAR(IDH,'M_NTPMRG')
      DO 3000 I=1,NPNT
          CALL HCDIR('//PAWC',' ')
          CALL HCDIR(TDIRI,' ')
          CALL HGNF(IDH,I,RVAL,JERR)
          IF(JERR.NE.0) THEN
              TXTERR = 'Error reading Ntuple from file ' //
     +         TFILI(1:NCHRI)
              CALL MN_ERR('M_NTPMRG',TXTERR)
              GOTO 9000
          ENDIF
C
          NEVTOT = NEVTOT + 1
          CALL HCDIR('//PAWC/TMP',' ')
          CALL HCDIR(TDIRO,' ')
          CALL HFN(IDH,RVAL)
3000  CONTINUE
C
      GOTO 2000
C
9000  CONTINUE
C
      IF(QHFO) THEN
          IF(.NOT.QNEW) THEN
              NPNT = 0
              IF(HEXIST(IDH)) CALL HNOENT(IDH,NPNT)
              CALL HCDIR('//PAWC/TMP',' ')
              JERR = IQUEST(1)
              CALL HCDIR(TDIRO,' ')
              KERR = IQUEST(1)
              WRITE(TXTMES,'('' Copied'',I6,'' entries'',2I4)'
     +         ,IOSTAT=IOERR) NPNT,JERR,KERR
              CALL MN_MES(LUNTTO,'ME',TXTMES)
              IF(HEXIST(IDH)) THEN
                  CALL HROUT(IDH,ICYCLE,' ')
                  CALL HDELET(IDH)
                  CALL HCDIR('//PAWC',' ')
C                  CALL RZDELT('TMP')
              ENDIF
          ENDIF
*ICB          CALL HRENDC('MN_HBOUT')
          CALL HRENDC('MRGOUT')
      ENDIF
C
      IF(QHFI) THEN
          CALL HCDIR('//PAWC',' ')
          IF(HEXIST(IDH)) CALL HDELET(IDH)
*ICB          CALL HRENDC('MN_HBIN')
          CALL HRENDC('MRGIN')
      ENDIF
C
C     Read the merged Ntuple in as a Mn_Fit Ntuple
C
      IF(QHFO) THEN
          IF(IERR.EQ.0) THEN
              LEND = LENOCC(TDIRM)
              TXT2 = TDIRM(1:LEND)
              CALL QUOTYQ(TXT2)
              IDELIM = 0
              CALL M_CDIR(IDELIM,0,IERR)
C
              LENF = LENOCC(TFILO)
              WRITE(TXT1,'(I8)') IDH
              TXT2 = TFILO(1:LENF) // TXT1
              CALL QUOTYQ(TXT2)
              IDELIM = 0
              NMODE  = 4
              CALL MN_HBF(IDELIM,NMODE)
          ELSE
              CALL M_EMSG('M_NTPMRG'
     +         ,'Merged Ntuple will not be read in')
          ENDIF
      ENDIF
C
      END
