      SUBROUTINE TVARC(XX, YY, RAD1, RAD2, PHI1, PHI2
     + ,NSYM, NsCOL, THICK, NHAT, NPAT, nhcol, npcol)
C
C     Routine for drawing circles and arcs - uses HIGZ IGARC
C     or my own code
C
      implicit none
*
#include "mngrn.inc"
#include "mnpij.inc"
C
      REAL XX,YY,RAD1,RAD2,PHI1,PHI2,THICK
      INTEGER NSYM,NsCOL,NHAT,NPAT,nhcol,npcol
C
      integer npt,mpt
      parameter (mpt=101)
      REAL XPT(mpt),YPT(mpt)
      real phi,rad,aunit,delphi
      integer i
C
#if ( defined(PLTSUB) )
      INTEGER NPFILL
      REAL SISYMX,SISYMY
#endif

C
C     Don't do anything if no or null output device selected
C
      IF(LPDEV.LE.1) RETURN
C
#if ( defined(HIGZ) )
C
C     Setup filling if requested
C
      CALL ISLN(NSYM)
      CALL ISPLCI(NsCOL)
      IF(NHAT.NE.0) THEN
          CALL ISFAIS(3)
          CALL ISFASI(NHAT)
          CALL ISFACI(NhCOL)
      ELSEIF(NPAT.EQ.100) THEN
          CALL ISFAIS(1)
          CALL ISFACI(NpCOL)
      ELSEIF(NPAT.EQ.200) THEN
          CALL ISFAIS(0)
      ELSEIF(NPAT.NE.0) THEN
          CALL ISFAIS(2)
          CALL ISFASI(NPAT)
          CALL ISFACI(NpCOL)
      ELSE
          CALL ISFAIS(0)
      ENDIF
      CALL ISLWSC(THICK)
      CALL IGSET('LTYP',FLOAT(NSYM))
      CALL IGSET('BORD',1.0)
C
C     Use HIGZ routines if required or if the area between the arcs
C     should be filled
C
      if(qigarc .or.
     + (rad1.ne.rad2 .and. rad1.ne.0.0 .and. rad2.ne.0.0)) then
        CALL IGARC(XX,YY,RAD1,RAD2,PHI1,PHI2)
C
C     Use my code to get round HIGZ bug that sometimes uses
C     wrong symbol and colour
C
      else
        rad = max(rad1,rad2)
        delphi = (phi2 - phi1)*drad
        if(delphi.eq.0.0) delphi = twopi
        npt = min(mpt,max(9,nint(100.0*rad)))
        do i=1,npt
          phi = phi1 + float(i-1)/float(npt-1) * delphi
          xpt(i) = xx + rad*cos(phi)
          ypt(i) = yy + rad*sin(phi)
        enddo
C
        if(nhat.ne.0 .or. npat.ne.0) then
          call ifa(npt,xpt,ypt)
        endif
C
        call ipl(npt,xpt,ypt)
      endif
C
#endif
#if ( defined(PLTSUB) )
C
C     Draw the circle by hand as an octogon
C
      SISYMX = RAD1
      SISYMY = RAD1
      NPT = 9
      NPFILL = NPT
      XPT(1) = XX - SISYMX
      YPT(1) = YY + 0.5*SISYMY
      XPT(2) = XX - 0.5*SISYMX
      YPT(2) = YY + SISYMY
      XPT(3) = XX + 0.5*SISYMX
      YPT(3) = YY + SISYMY
      XPT(4) = XX + SISYMX
      YPT(4) = YY + 0.5*SISYMY
      XPT(5) = XX + SISYMX
      YPT(5) = YY - 0.5*SISYMY
      XPT(6) = XX + 0.5*SISYMX
      YPT(6) = YY - SISYMY
      XPT(7) = XX - 0.5*SISYMX
      YPT(7) = YY - SISYMY
      XPT(8) = XX - SISYMX
      YPT(8) = YY - 0.5*SISYMY
      XPT(9) = XX - SISYMX
      YPT(9) = YY + 0.5*SISYMY
      CALL MN_LIN(XPT,YPT,NPT,nsym,SISYMY,NsCOL,THICK)
C
      IF(NHAT.NE.0) THEN
          CALL TVSFIL(NPFILL,XPT,YPT,NNSYM,XX,YY,SISYMX,SISYMY
     1     ,NhCOL)
      ENDIF
C
#endif

      END
