/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux 
 *   and Thomas Pfisterer
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

// 	$Id$	


 
#ifndef _readpool_h_
#define _readpool_h_


#include "stdinc/defines.H"
#include "stdinc/stlincludes.H"


#include <string>

#include "mira/parameters.H"
#include "mira/read.H"

#undef yyFlexLexer
#define yyFlexLexer FAFlexLexer
#include <FlexLexer.h>


using namespace std;

class ReadPool
{
  // Variables
private:
  //for debuging and sanity checks
#define REP_VALID ((((static_cast<uint32>('R')<<8)+static_cast<uint32>('E')<<8)\
                     +static_cast<uint32>('P')<<8)+static_cast<uint32>('V'))
  uint32 REP_valid;

  vector<MIRAParameters> * REP_miraparams;

  //char * REP_filenames;          // temporary buffer for the loaded fofn.

  vector<Read> REP_thepool;

  vector<string> REP_strainnames;


  // Functions
private:
  void foolCompiler();

  static void mergeXMLTraceInfo_callback(void * callerobjptr, list<string> & elements, list<string> & elements_cdata);
  
  void solexaScoreToQual(const vector<int32> & s, 
			 vector<base_quality_t> & q);

  inline void rpDateStamp() {
    if(REP_miraparams!=NULL) {
      if((*REP_miraparams)[0].getAssemblyParams().as_dateoutput) dateStamp(cout);
    }else{
      dateStamp(cout);
    };
  }

public:
  ReadPool(vector<MIRAParameters> * params);
  ~ReadPool();

  void discard();
  size_t estimateMemoryUsage() const;

  Read & addNewEmptyRead();            // adds an empty read to the pool

  inline uint32 size() const     // returns number of reads in pool
    {return static_cast<uint32>(REP_thepool.size());};
  inline uint32 capacity() const     // returns number of reads in pool
    {return static_cast<uint32>(REP_thepool.capacity());};
  inline void reserve(uint32 rsize) {REP_thepool.reserve(rsize);};
  inline Read & back()           // returns reference to last read in pool
    {return REP_thepool.back();};

  // returns read at the index in pool
  Read & getRead(uint32 index);
  inline Read & operator [] (uint32 index) {return getRead(index);};

  // returns (first) read with name i.p.
  Read & getRead(const string & name);

  // returns id of (first) read with name
  int32  getReadIndex(const string & name) const;

  // to save some old functions the time to convert to a string obj
  int32  getReadIndex(const char * name) const;

  // true if name is already in pool, else false
  bool isInPool(const string & name) const;

  const string & getStrainOfStrainID(uint32 sid) const;
  inline uint32 getNumOfStrainInReadpool() const {
    if(REP_strainnames.empty()){
      ReadPool & nrp=const_cast<ReadPool &>(*this);
      nrp.makeTemplateIDs(false);
      nrp.makeStrainIDs(false);
    }
    return static_cast<uint32>(REP_strainnames.size());
  };
  bool getStrainIDOfStrain(const string & strainname, int32 & sid) const;


  size_t loadEXPs(const string & fofn, 
		  const uint8 loadaction, 
		  uint32 & longestread,
		  const uint8 readtype=Read::SEQTYPE_SANGER,
		  void (*callback)(ReadPool &)=NULL);
  size_t loadPHD(const string & filename, 
		 const uint8 loadaction,
		 uint32 & longestread,
		 void (*callback)(ReadPool &)=NULL);

  size_t loadDataFromFASTA(const string & filename, 
			   const uint8 loadaction,
			   uint32 & longestread,
			   bool  wantsqualfiletoexist,
			   const string & qualfilename="",
			   const bool generatefilenames=true,   
			   const uint8 readtype=Read::SEQTYPE_SANGER,
			   const bool sxa_mustconvert=true,
			   void (*callback)(ReadPool &)=NULL);
  size_t loadDataFromFASTQ(const string & filename, 
			   const uint8 loadaction,
			   uint32 & longestread,
			   const bool generatefilenames=true,   
			   const uint8 readtype=Read::SEQTYPE_SANGER,
			   const bool sxa_mustconvert=true,
			   void (*callback)(ReadPool &)=NULL);


  void loadDataFromGBF(const string & filename);
  void loadDataFromGFF3(const string & filename);
  void loadStrainData(const string & sdfile);    // name for the key value file;
  void deleteReadsByName(const string & nfile, 
			 bool invertselection);

  void loadQualitiesFromSCF(uint32 force, 
			    bool loadfailnoerror, 
			    const string & log1name, 
			    const string & log2name);
  void loadQualitiesFromSCF(uint32 force, bool loadfailnoerror);

  void mergeXMLTraceInfo(const string & xmlfile);

  void dumpAs(ostream & ostr, uint8 astype, bool alsoinvalids) const;
  void dumpAsEXPs(string & dirname) const;
  void dumpPoolInfo(ostream & ostr) const;



  bool makeTemplateIDs(bool verbose=true);
  void makeStrainIDs(bool verbose=true);
  void dumpStrainIDSummary();

};

#endif
