#############################################################################
# mined text editor make actions (make include file for make targets)


#############################################################################
# components to be compiled

#ARCH=$(shell uname).$(shell uname -m)
#BIN=bin/$(ARCH)

# Mined modules
PROGOBJS = \
	mousemen.o \
	mined1.o edit.o pastebuf.o textfile.o \
	textbuf.o justify.o search.o \
	minedaux.o legacy.o \
	output.o prompt.o compose.o \
	charcode.o \
	keymaps.o keydefs.o dispatch.o \
	termprop.o width.o encoding.o \
	handescr.o
OBJS = $(PROGOBJS) $(CHARMAPS)

# make target parameters that may be overriden in makefile
# (could be set to default with the ?= syntax but that doesn't work 
# in all versions of make)

SCREENOBJ=io.o keyboard.o

MOUSELIB=

#KEYMAPSDEP?=keymaps/_keymaps.h


#############################################################################
# commands
#WGET=curl -R -O --connect-timeout 5
WGET=wget -N -t 1 --timeout=5


#############################################################################
# target properties, default target, auxiliary targets

# functional or abbreviated (non-file) targets:
.PHONY:	mkcharmaps mkkeymaps mnemodoc help man bin install localinstall optinstall links clean clear debianclean update all clean_unidata clean_unihan clean_udata vni viqr vtelex

# Default make target:
all:	$(MAKEMAPS) mined


#############################################################################
# Unicode data tables:

UCD.zip:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/UCD.zip

Unihan.zip:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/UNIDATA/Unihan.zip

UnicodeData.txt:	UCD.zip
	unzip UCD UnicodeData.txt

Scripts.txt:	UCD.zip
	unzip UCD Scripts.txt

Blocks.txt:	UCD.zip
	unzip UCD Blocks.txt

SpecialCasing.txt:	UCD.zip
	unzip UCD SpecialCasing.txt

PropList.txt:	UCD.zip
	unzip UCD PropList.txt

EastAsianWidth.txt:	UCD.zip
	unzip UCD EastAsianWidth.txt

PropertyValueAliases.txt:	UCD.zip
	unzip UCD PropertyValueAliases.txt

DerivedBidiClass.txt:	UCD.zip
	unzip -j UCD extracted/DerivedBidiClass.txt

NameAliases.txt:	UCD.zip
	unzip UCD NameAliases.txt

BIG5.TXT:
	echo Trying to retrieve Unicode data file via Internet
	$(WGET) http://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT

check_ccc:
	grep "^ccc; *230;.*; *Above$$" PropertyValueAliases.txt

clean_unidata:	UnicodeData.txt SpecialCasing.txt Scripts.txt PropList.txt PropertyValueAliases.txt check_ccc
	rm -f casetabl.t casespec.t softdot.t combin.t
	rm -f scripts.t scriptdf.t charname.t categors.sed categors.t
	rm -f UniWITH

clean_unihan:	Unihan.zip
	echo "Regenerate Han info data (5 minutes...)? (yes/n) " | tr -d '\n' ; read a; [ "$$a" != yes ] || rm -f handescr.t handescr/descriptions.uni
	echo "Regenerate Radical/Stroke input method (5 minutes...)? (yes/n) " | tr -d '\n' ; read a; [ "$$a" != yes ] || rm -f keymaps?/Radical_Stroke.h

clean_udata:
	rm -f udata_* udata-*

uniset.tar.gz:
	$(WGET) http://www.cl.cam.ac.uk/~mgk25/download/uniset.tar.gz

#WIDTH-A:	uniset.tar.gz
#	tar xvzf uniset.tar.gz WIDTH-A

WIDTH-A:	EastAsianWidth.txt
	./mkwidthA


udata:	udata_combining.t udata_spacingcombining.t udata_ambiguous.t udata_assigned.t
	cat udata_combining.t udata_spacingcombining.t udata_assigned.t > width.t.add

univer = `sed -e '/^\# Blocks-/ s,[^0-9],,g' -e t -e d Blocks.txt`
univer_prev = `sed -e '/^\# Blocks-/ s,[^0-9],,g' -e t -e d unicode-previous/Blocks.txt`

# (Blocks.txt is a dummy dependency of uniset)

udata_combining.t:	UnicodeData.txt Blocks.txt
	echo > udata_combining.t
	echo "static struct interval" >> udata_combining.t
	echo "combining_$(univer) [] =" >> udata_combining.t
	uniset +cat=Me +cat=Mn +cat=Cf -00AD +1160-11FF +200B c >> udata_combining.t

udata_ambiguous.t:	UnicodeData.txt Blocks.txt WIDTH-A
	echo > udata_ambiguous.t
	echo "static struct interval" >> udata_ambiguous.t
	echo "ambiguous_$(univer) [] =" >> udata_ambiguous.t
	uniset +WIDTH-A -cat=Me -cat=Mn -cat=Cf c >> udata_ambiguous.t

udata_spacingcombining.t:	UnicodeData.txt Blocks.txt
	echo > udata_spacingcombining.t
	echo "static struct interval" >> udata_spacingcombining.t
	echo "spacing_combining_$(univer) [] =" >> udata_spacingcombining.t
	uniset +cat=Mc c >> udata_spacingcombining.t

# not strictly needed for current Unicode version; 
# same range of characters as listed in scripts.t
udata_assigned.t:	UnicodeData.txt Blocks.txt
	echo > udata_assigned.t
	echo "static struct interval" >> udata_assigned.t
	echo "assigned_$(univer) [] =" >> udata_assigned.t
	uniset +0000-10FFFF clean c >> udata_assigned.t

udata-update:	udata-add_assigned udata-add_combining WIDTH-A udata-add_ambiguous udata-add_right-to-left

unicode-previous/WIDTH-A:
	(cd unicode-previous; ${PWD}/mkwidthA)

udata-add_assigned:
	(cd unicode-previous; uniset +0000-10FFFF clean table) > udata-old_assigned
	uniset +0000-10FFFF clean table > udata-new_assigned
	uniset +udata-new_assigned -udata-old_assigned ucs table > udata-add_assigned

udata-add_combining:
	(cd unicode-previous; uniset +cat=Me +cat=Mn +cat=Cf -00AD +1160-11FF +200B table) > udata-old_combining
	uniset +cat=Me +cat=Mn +cat=Cf -00AD +1160-11FF +200B table > udata-new_combining
	uniset +udata-new_combining -udata-old_combining ucs table > udata-add_combining

udata-add_ambiguous:	unicode-previous/WIDTH-A
	(cd unicode-previous; uniset +WIDTH-A -cat=Me -cat=Mn -cat=Cf table) > udata-old_ambiguous
	uniset +WIDTH-A -cat=Me -cat=Mn -cat=Cf table > udata-new_ambiguous
	uniset +udata-new_ambiguous -udata-old_ambiguous ucs table > udata-add_ambiguous

udata-add_right-to-left:
	(cd unicode-previous; sed -e 's-^\([^;]*\);\([^;]*\);\([^;]*\);\([^;]*\);R;.*-	\1-' -e t -e 's-^\([^;]*\);\([^;]*\);\([^;]*\);\([^;]*\);AL;.*-	\1-' -e t -e d UnicodeData.txt | uniset +- table) > udata-old_right-to-left
	sed -e 's-^\([^;]*\);\([^;]*\);\([^;]*\);\([^;]*\);R;.*-	\1-' -e t -e 's-^\([^;]*\);\([^;]*\);\([^;]*\);\([^;]*\);AL;.*-	\1-' -e t -e d UnicodeData.txt | uniset +- table > udata-new_right-to-left
	uniset +udata-new_right-to-left -udata-old_right-to-left ucs table > udata-add_right-to-left


u/full-unicode.txt:	UnicodeData.txt Blocks.txt
	(uniset +0000-FFFF utf8-list ; uniset +10000..10FFFF clean utf8-list) > u/full-unicode.txt


# Vietnamese input methods:

UniWITH:	UnicodeData.txt
	sed -e "s,^\([^;]*\);\([^;]* LETTER [^;]* WITH [^;]*\);.*,U+\1	\2 AND," -e t -e d UnicodeData.txt | CC=$(CC) ./insutf8 > UniWITH

vni:	keymaps/VNI.h

categors.sed:	mkcategs # PropertyValueAliases.txt
	./mkcategs -sed

categors.t:	mkcategs # PropertyValueAliases.txt
	./mkcategs -h

keymaps/VNI.h:	UniWITH vni.sev vni.sed vni.seh
	mkdir -p keymaps
	(sed -f vni.sev UniWITH ; cat UniWITH) | LC_ALL=C sed -f vni.sed | sed -f vni.seh > keymaps/VNI.h

viqr:	keymaps/VIQR.h

keymaps/VIQR.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,VIQR," keymaps/VNI.h | tr "6879125340" "^(+d\'\`.?~-" > keymaps/VIQR.h

vtelex:	keymaps/Vtelex.h

keymaps/Vtelex.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,Vtelex," -e "s,\([Aa]\)6,\1a," -e "s,\([Ee]\)6,\1e," -e "s,\([Oo]\)6,\1o," keymaps/VNI.h | tr "879125340" "wwdsfjrxz" > keymaps/Vtelex.h

# Case conversion tables:

casetabl.t:	mkcasetb # UnicodeData.txt
	./mkcasetb

casespec.t:	mkcasesp # SpecialCasing.txt
	./mkcasesp

# Unicode character information tables:
wide.t:	mkwidthW # EastAsianWidth.txt
	./mkwidthW

softdot.t:	mkpropl # PropList.txt
	./mkpropl Soft_Dotted > softdot.t

combin.t:	mkcombin # UnicodeData.txt
	CC=$(CC) ./mkcombin

charprop.t:	mkpropl # PropList.txt
	./mkpropl Quotation_Mark > charprop.t
	./mkpropl Dash >> charprop.t

#scriptdf.t:	mkscript2 scripts.tt
scripts.t:	mkscript mkscript2 categors.sed # Scripts.txt
	CC=$(CC) ./mkscript
	./mkscript2

charname.t:	mkchname # UnicodeData.txt
	CC=$(CC) ./mkchname

decompos.t:	mkdecompose # UnicodeData.txt
	CC=$(CC) ./mkdecompose

# from:		Greek		124 64
# generate:		{"Greek", 124, 64},
colours.t:	colours.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\)[	 ][	 ]*\([0-9][0-9]*\).*/	{"\1", \2, \3},/' -e t -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\).*/	{"\1", \2, -1},/' -e t -e d colours.cfg | sort > colours.t

# Unihan database dependent information:
unihan:	handescr.t radical_stroke
	echo "mkkbmap Cangjie [+]"

# Unihan character description table:
handescr.t:	# handescr/mkdescriptions handescr/descriptions.sed handescr/descriptions.uni # Unihan.zip
	cd handescr && $(MAKE) descriptions.h
	ln handescr/descriptions.h handescr.t || cp handescr/descriptions.h handescr.t

# Radical/Stroke input method table:
radical_stroke:	keymaps/Radical_Stroke.h

keymaps/Radical_Stroke.h:	# Unihan.zip
	cd handescr && $(MAKE) Radical_Stroke.h
	ln handescr/Radical_Stroke.h keymaps/ || cp handescr/Radical_Stroke.h keymaps/

# Radical/Stroke input method table:
cangjie:	keymaps/Cangjie.h

keymaps/Cangjie.h:	# Unihan.zip etc/charmaps/hkscs/hkscs-2004-cj.txt
	./mkkbmap cj +

# Keyboard mapping table configuration:

# source lines: Greek	GreekMonotonic	gr	(Y)
# check input method tag ("gr", ...) for uniqueness
getkeymapstags = sed -e '/^\#/ d' -e '/^--/ d' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/\3/' -e t -e d keymaps.cfg
checkkeymapstags:	keymaps.cfg
	LC_ALL=C $(getkeymapstags) | sort | uniq -d | sed -e "s,^,[41m," -e "s,$$,[0m," | if grep .; then echo ERROR: duplicate tags in keymaps.cfg; false; else true; fi

withoutCJK=-e "/^-.*Japanese/,/^$$/ d" -e "/^-.*Chinese/,/^$$/ d" -e "/^-.*Korean/,/^$$/ d" -e "/^Fullwidth/ d"

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:		{"Greek", select_keymap_entry, "gr", keymapon, "Y"},
# from:		---- Group
# generate:		{"Group", separator, ""},
keymapsm.t:	keymaps.cfg # mkinclud.mak
	$(MAKE) -f mkinclud.mak checkkeymapstags
	LC_ALL=C sed -e '/^#/ d' -e 's/^--* *\(.*\) */	{"\1", separator, ""},/' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\)		*(*\([^)	 ]*\))*.*/	{"\1", select_keymap_entry, "\3", keymapon, "\4"},/' -e t -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\).*\([^ 	][^ 	]\).*/	{"\1", select_keymap_entry, "\3", keymapon},/' -e t -e d keymaps.cfg > keymapsm.t

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:		{keymap_GreekMonotonic, "gr"},
keymapsk.t:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/	{keymap_\2, "\3"},/' -e t -e d keymaps.cfg > keymapsk.t

# DOS variant without CJK input methods:
keymapsd.t:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed $(withoutCJK) -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/	{keymap_\2, "\3"},/' -e t -e d keymaps.cfg > keymapsd.t

# from:		Greek	GreekMonotonic	gr	(Y)
# generate:	#include "GreekMonotonic.h"
keymapsi.h:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/#include "\2.h"/' -e t -e d keymaps.cfg > keymapsi.h

# DOS variant without CJK input methods:
keymapsd.h:	keymaps.cfg # mkinclud.mak
	LC_ALL=C sed $(withoutCJK) -e '/^[-#]/ d' -e 's/^[ 	"]*\([^	]*\)		*\([A-Za-z0-9_][^ 	]*\)		*\([^ 	][^ 	]\).*/#include "\2.h"/' -e t -e d keymaps.cfg > keymapsd.h

# Character mapping configuration:

# check input method tag ("gr", ...) for uniqueness
checkcharmapstags:	charmaps.cfg mkchrcfg
	./mkchrcfg checktags

charmaps.t:	charmaps.cfg mkchrcfg
	$(MAKE) -f mkinclud.mak checkcharmapstags
	./mkchrcfg charmaps.t

charmaps.h:	charmaps.cfg mkchrcfg
	./mkchrcfg charmaps.h

charemen.t:	charmaps.cfg mkchrcfg
	./mkchrcfg charemen.t

charesub.t:	charmaps.cfg mkchrcfg
	./mkchrcfg charesub.t

# Mapping table locale (substring) -> charmap (encoding name)
# from:
#	ar_IN	UTF-8
#	ar	ISO-8859-6	MacArabic
# generate:
#		{"ar", "ISO-8859-6", "MacArabic"},
#		{"ar_IN", "UTF-8"},
locales.t:	locales.cfg # mkinclud.mak
	sed -e '/^$$/ d' -e '/^#/ d' -e 's/\([^ 	][^ 	]*\)[ 	][ 	]*\([^ 	][^ 	]*\)[ 	]*\([^ 	]*\)/	{"\1", "\2", "\3"},/' -e 's/, ""//' locales.cfg | LC_ALL=C sort > locales.t

# Find supplements for locales.cfg:
localealiases:	/usr/share/locale/locale.alias locales.cfg
	sed -e "/^#/ d" -e "/8859-1$$/ d" -e "s,\([^ 	]*\)[ 	][ 	]*\([^ 	]*\),\1	\2," -e "s,	[^.]*\.,	," -e "s,	euc,	EUC-," /usr/share/locale/locale.alias | fgrep -v -x -f locales.cfg

# HTML character mnemonics:
zeichen.htm:
	$(WGET) http://de.selfhtml.org/html/referenz/zeichen.htm

mnemos.com: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent -

mnemos.ara: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Arabic

mnemos.cyr: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Cyrillic

mnemos.grk: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Greek

mnemos.heb: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Hebrew

mnemos.lat: mkaccent accents.cfg # UnicodeData.txt
	./mkaccent Latin

mnemos.www:	mnemos.tex # zeichen.htm
	CC=$(CC) ./mkmnhtml zeichen.htm | fgrep -v -x -f mnemos.tex > mnemos.www
	./mnemos.check


#############################################################################
# generate tables for character encodings and keyboard mappings

# rules for non-GNU make:

# extract list of configured keyboard mappings from keymaps.cfg:
getKEYMAPS=`./mkkmlist`

# generate makefile to deal with variable list of dependencies,
# invoke it to generate cumulative keymaps file:
mkkeymaps:
	test -d keymaps || mkdir keymaps
	echo keymaps/_keymaps.h: keymaps.cfg $(getKEYMAPS) mkkmincl > keymaps/makefile
	echo "	./mkkmincl $(getKEYMAPS) > keymaps/_keymaps.h" >> keymaps/makefile
	$(MAKE) -f keymaps/makefile

# generate makefile to deal with variable list of targets,
# invoke it to generate and compile character mapping tables:
mkcharmaps:
	CC=$(CC) OPT="$(OPT)" ./mkmakchr > charmaps/makefile
	$(MAKE) -f charmaps/makefile


# rules for GNU make:

# KEYMAPS is extracted list of configured keyboard mappings from keymaps.cfg:
keymaps/_keymaps.h:	keymaps.cfg $(KEYMAPS) mkkmincl keymaps1/Radical_Stroke.h
	test -d keymaps || mkdir keymaps
	./mkkmincl $(KEYMAPS) > keymaps/_keymaps.h

# define generic rule to generate and compile character mapping tables:
#charmaps/%.o: charmaps/%.map charcode.h mkchrtab
#	CC=$(CC) OPT="$(OPT)" ./mkchrtab $<

# rather do it in 2 steps to facilitate generation with non-Unix make 
# after manual copying cross-generated .c files:
# generate character mapping tables:
charmaps/%.c: charmaps/%.map charcode.h mkchrtab
	CC=$(CC) OPT="$(OPT)" ./mkchrtab -S $<

# compile character mapping tables:
charmaps/%.o: charmaps/%.c
	$(CC) $(OPT) -I. -c $< -o charmaps/$*.o


#############################################################################
# Character input support tables:
MNEMOS=mnemos.???	# mnemos.sup, .gen, .rfc, .tex, .www
mnemos.h:	$(MNEMOS)
#	cat $(MNEMOS) > mnemos.h
	ls -1 $(MNEMOS) | sed -e 's,^,#include ",' -e 's,$$,",' > mnemos.h

# Documentation page for mnemonics (listing mined additional mnemos)
mnemodoc:	../doc/mnemodoc.html
../doc/mnemodoc.html:	mnemos.sup ../doc/mined.html mkmnemodoc
	CC=$(CC) ./mkmnemodoc > ../doc/mnemodoc.html.new
	/bin/mv ../doc/mnemodoc.html.new ../doc/mnemodoc.html
	./mnemos.check


#############################################################################
# Location of online help file:
DHELP=-DRUNDIR=\"$(rundir)\" -DLRUNDIR=\"$(lrundir)\"

# Version/About text:
#VERSION=`sed -e 's,^[^0-9]*,,' -e 's,[^0-9][^0-9]*,.,g' -e q ../VERSION`
#ABOUT=\"MinEd $(VERSION) - http://mined.sourceforge.net/\"


#############################################################################
# Source compilation:
mined1.o:	version.h mined1.c textfile.h encoding.h locales.t mined.h io.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) $(DHELP) -c mined1.c
textfile.o:	textfile.c textfile.h mined.h turbodir.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c textfile.c
textbuf.o:	textbuf.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c textbuf.c
justify.o:	justify.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c justify.c
edit.o:	edit.c mined.h io.h casespec.t casetabl.t softdot.t combin.t wide.t charname.t termprop.h scripts.t # scriptdf.t
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c edit.c
pastebuf.o:	pastebuf.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c pastebuf.c
minedaux.o:	minedaux.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c minedaux.c
legacy.o:	legacy.c
	$(CC) $(CFLAGS) -c legacy.c
search.o:	search.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c search.c
mousemen.o:	mousemen.c mined.h io.h keymapsm.t charemen.t charesub.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c mousemen.c
output.o:	output.c colours.t mined.h io.h charprop.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c output.c
prompt.o:	prompt.c mined.h io.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c prompt.c
io.o:	io.c io.h mined.h $(MOUSELIB) dosvideo.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c io.c
iocurses.o:	io.c io.h mined.h termprop.h
	$(CC) $(CFLAGS) -DCURSES -DSETLOCALE $(PROTOFLAGS) -c io.c $(ICURSES) -o iocurses.o
keyboard.o:	keyboard.c mined.h termprop.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) $(KEYMAPSFLAGS) -c keyboard.c
keycurs.o:	keyboard.c mined.h termprop.h
	$(CC) $(CFLAGS) -DCURSES $(PROTOFLAGS) $(KEYMAPSFLAGS) -c keyboard.c $(ICURSES) -o keycurs.o
charcode.o:	charcode.c charcode.h charmaps.t charmaps.h termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c charcode.c
handescr.o:	handescr.c handescr.t
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c handescr.c
compose.o:	compose.c mined.h mnemos.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c compose.c
keymaps.o:	keymaps.c keymapsk.t $(KEYMAPSDEP)
	$(CC) $(CFLAGS) $(PROTOFLAGS) -Ikeymaps $(KEYMAPSFLAGS) -c keymaps.c
keydefs.o:	keydefs.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c keydefs.c
dispatch.o:	dispatch.c mined.h io.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c dispatch.c
encoding.o:	encoding.c encoding.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c encoding.c
termprop.o:	termprop.c termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c termprop.c
width.o:	width.c width.t termprop.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c width.c


#############################################################################
# Mined generation:
mined:	$(OBJS) $(SCREENOBJ)
	$(CC) $(OBJS) $(SCREENOBJ) $(LINKOPTS) ${LDFLAGS} $(SLIB) -o mined

minced:	$(OBJS) iocurses.o keycurs.o
	$(CC) $(OBJS) iocurses.o keycurs.o $(LINKOPTS) ${LDFLAGS} -lncursesw $(LDL) -o minced


#############################################################################
# additional files, installation, cleanup

# Online help:
help:	../usrshare/help/mined.hlp

../usrshare/help/mined.hlp:	help/* mkhelp
	./mkhelp > ../usrshare/help/mined.hlp

# Manual page:
man:	../man/mined.1 ../man/uterm.1

../man/%.1:	../doc/%.html
	cd `/bin/pwd`/../man && $(MAKE)


# Install aliases; may be suppressed with make ...install makelinks=
makelinks=$(MAKE) -f mkinclud.mak links EXE=$(EXE)

links:	$(linkdir)/xmined $(linkdir)/minmacs$(EXE) $(linkdir)/mpico$(EXE) $(linkdir)/mstar$(EXE)

$(linkdir)/xmined:
	cd $(linkdir) && ln -s umined xmined

$(linkdir)/%:
	cd $(linkdir) && ln -s mined$(EXE) $*


# Install uterm and umined scripts;
# may be suppressed with make ...install installscript=echo
installscript=$(INSTALLBIN)
#installscript=echo not installing

# Install desktop context menu entry
# may be suppressed with make ...install installdesktop=echo
installdesktop=$(INSTALL)
desktop=../usrshare/setup_install/mined.desktop
icon=../usrshare/setup_install/mined.xpm
rootmenudir=$(DESTDIR)$(root)/usr/share/applications
rooticondir=$(DESTDIR)$(root)/usr/share/pixmaps
localmenudir=$(DESTDIR)$(root)/usr/local/share/applications
localicondir=$(DESTDIR)$(root)/usr/local/share/pixmaps
usermenudir=${HOME}/.local/share/applications
usericondir=${HOME}/.local/share/pixmaps
rootmenu=mkdir $(rootmenudir) && $(installdesktop) $(desktop) $(rootmenudir)
rooticon=mkdir $(rooticondir) && $(installdesktop) $(icon) $(rooticondir)
# enforce local or user desktop integration with mkdir -p
localmenu=mkdir -p $(localmenudir) && $(installdesktop) $(desktop) $(localmenudir)
localicon=mkdir -p $(localicondir) && $(installdesktop) $(icon) $(localicondir)
usermenu=mkdir -p $(usermenudir) && $(installdesktop) $(desktop) $(usermenudir)
usericon=mkdir -p $(usericondir) && $(installdesktop) $(icon) $(usericondir)


# Installation:
# or installation to system-specific dir with make install root=...
install:	mined help man
	# ==== install binary and scripts
	#don't strip -p mined$(EXE) || true
	mkdir -p $(DESTDIR)$(bindir)
	$(INSTALLBIN) mined$(EXE) $(DESTDIR)$(bindir)
	$(installscript) ../usrshare/bin/uterm $(DESTDIR)$(bindir)
	$(installscript) ../usrshare/bin/umined $(DESTDIR)$(bindir)
	$(makelinks) linkdir=$(DESTDIR)$(bindir)
	# ==== install runtime support library
	mkdir -p $(DESTDIR)$(rundir)
	/bin/cp -pr ../usrshare/* $(DESTDIR)$(rundir)
	# ==== install manual page
	mkdir -p $(DESTDIR)$(mandir)/man1
	$(INSTALL) ../man/*.1 $(DESTDIR)$(mandir)/man1
	# zip man if mans are zipped in actual mandir (not DESTDIR)
	if (ls $(mandir)/man1/*.gz && type gzip) > /dev/null 2>&1; then gzip -f $(DESTDIR)$(mandir)/man1/mined.1; fi
	# ==== install desktop context menu item ("Open With")
	( $(rootmenu) && $(rooticon) ) || ( $(usermenu) && $(usericon) ) || echo Could not install desktop menu entry
	# ==== install system-specific stuff (e.g. wined, README.cygwin)
	$(extrainstall)

# Local installation:
# or installation to system-specific local dir with make localinstall root=...
localinstall:	mined help man
	# ==== install binary and scripts
	#don't strip -p mined$(EXE) || true
	mkdir -p $(DESTDIR)$(lbindir)
	$(INSTALLBIN) mined$(EXE) $(DESTDIR)$(lbindir)
	$(installscript) ../usrshare/bin/uterm $(DESTDIR)$(lbindir)
	$(installscript) ../usrshare/bin/umined $(DESTDIR)$(lbindir)
	$(makelinks) linkdir=$(DESTDIR)$(lbindir)
	# ==== install runtime support library
	mkdir -p $(DESTDIR)$(lrundir)
	/bin/cp -pr ../usrshare/* $(DESTDIR)$(lrundir)
	# ==== install manual page
	mkdir -p $(DESTDIR)$(lmandir)/man1
	$(INSTALL) ../man/*.1 $(DESTDIR)$(lmandir)/man1
	# zip man if mans are zipped in actual mandir (not DESTDIR)
	if (ls $(lmandir)/man1/*.gz && type gzip) > /dev/null 2>&1; then gzip -f $(DESTDIR)$(lmandir)/man1/mined.1; fi
	# ==== install desktop context menu item ("Open With")
	( $(localmenu) && $(localicon) ) || ( $(usermenu) && $(usericon) ) || echo Could not install desktop menu entry
	# ==== install system-specific stuff (e.g. wined, README.cygwin)
	$(extrainstall)

# /opt installation:
# or installation to system-specific opt subdir with make optinstall root=...
optinstall:	mined help man
	# ==== install binary and scripts
	#don't strip -p mined$(EXE) || true
	mkdir -p $(DESTDIR)$(root)/opt/mined/bin
	$(INSTALLBIN) mined$(EXE) $(DESTDIR)$(root)/opt/mined/bin
	$(installscript) ../usrshare/bin/uterm $(DESTDIR)$(root)/opt/mined/bin
	$(installscript) ../usrshare/bin/umined $(DESTDIR)$(root)/opt/mined/bin
	$(makelinks) linkdir=$(DESTDIR)$(root)/opt/mined/bin
	# ==== install runtime support library
	mkdir -p $(DESTDIR)$(root)/opt/mined/share
	/bin/cp -pr ../usrshare/* $(DESTDIR)$(root)/opt/mined/share
	# ==== install manual page
	mkdir -p $(DESTDIR)$(root)/opt/mined/man/man1
	$(INSTALL) ../man/*.1 $(DESTDIR)$(root)/opt/mined/man/man1
	# ==== install desktop context menu item ("Open With")
	( $(rootmenu) && $(rooticon) ) || ( $(usermenu) && $(usericon) ) || echo Could not install desktop menu entry
	# ==== install system-specific stuff (e.g. wined, README.cygwin)
	$(extrainstall)


# Cleanup after compilation:
clear:
	rm -f *.o charmaps/*.o colours.t keymaps?.t keymaps/_keymaps.h core
	rm -f charmaps/makefile keymaps/makefile
	rmdir keymaps || true

debianclean:
	rm -f mined semantic.cache ../debian/semantic.cache

clean:	clear debianclean


#############################################################################
# pre-generation of tables
generate:	keymaps1/Radical_Stroke.h

keymaps1/Radical_Stroke.h:	keymaps0/Radical_Stroke.h
	./mkkmincl keymaps0/Radical_Stroke.h > keymaps1/Radical_Stroke.h

#keymaps0/Radical_Stroke.h:	keymaps/Radical_Stroke.h
#	cp keymaps/Radical_Stroke.h keymaps0/Radical_Stroke.h

# Cross-generation of charmaps files for MSDOS compilation
PCCHARMAPS=$(shell echo charmaps/*.map | sed -e "s, charmaps/cjk-[^ ]*.map,,g" )
PCCHARTABS=$(shell echo $(PCCHARMAPS) | sed -e "s,\.map,.c,g" )

# dj complains about the following rule ("multiple target patterns")
# so keep it away from makefile.dj
pc:	$(PCCHARTABS)

#pc:
#	./mkchrtab -S $(PCCHARMAPS)


#############################################################################
# development targets

# DOS (djgpp) versions of tables
dj:	keymapsd.h keymapsd.t

# Tags file:
tags:	*.c *.h
	ctags -w *.c *.h

# Source update archive:
update:
	cd ../man && $(MAKE)
	zip -y mined-src-update *.h *.c makefile.* mk* doc/changes.html doc/mined.html man/*.1 -x handescr.t

# Check function valid_cjk:
validcjk:	validcjk.c termprop.o width.o charmaps/*.o
	$(CC) $(CFLAGS) -o validcjk validcjk.c termprop.o width.o charmaps/*.o

# VMS build scripts:
vms:
	rm -f vms-link.new
	#echo '$$ define LNK$$LIBRARY   SYS$$LIBRARY:VAXCCURSE' >> vms-link.new
	#echo '$$ define LNK$$LIBRARY_1 SYS$$LIBRARY:VAXCRTL' >> vms-link.new
	echo $(SCREENOBJ) $(PROGOBJS) | sed -e "s,\.o,,g" -e "s/ /,/g" -e "s,^,$$ link ," -e "s:$$:,charmaps/library /executable=mined:" >> vms-link.new
	echo $(SCREENOBJ) $(PROGOBJS) | sed -e "s,\.o,,g" -e "s/ /,/g" | tr ',' '\012' | sed -e "/keymaps/ s,^,$$ cc/decc/include_directory=[.keymaps0] ," -e t -e "s,^,$$ cc/decc ," > vms-compile.new
	cmp vms-compile.com vms-compile.new || mv -f vms-compile.new vms-compile.com
	cmp vms-link.com vms-link.new || mv -f vms-link.new vms-link.com
	rm -f vms-compile.new vms-link.new

# Check correctness, consistency, uniqueness...
checkchar:	validcjk
	./validcjk
	./mnemos.check

checksrc:
	# source code checks
	if egrep -e "} *if" *.c; then false; fi
	# check for remains of debug stuff
	if egrep -e "^(printf|#define debug)" *.[hc]; then false; fi
	# check for statements at line beginning
	if sed -e "/^{/,/^}/ b" -e d *.c | grep "^[a-z].*;"; then false; fi
	if sed -e "/-- test/,$$ b" -e d keymaps.cfg | egrep '^[^#]'; then false; else true; fi

check:	checksrc checkchar

# Check makefile function
ldl:
	echo $(ldl_libs)
	echo $(LDL)

y=echo -e '\033[30;43m'
n=echo "[0m"

checkdirs:
	$(y); echo install:; echo $(prefix); echo $(bindir); echo $(mandir); echo $(rundir); $(n)
	$(y); echo localinstall:; echo $(lprefix); echo $(lbindir); echo $(lmandir); echo $(lrundir); $(n)

checkmaps:
	echo all:	$(MAKEMAPS) mined
	echo mined:	$(OBJS) $(SCREENOBJ)


#############################################################################
# end
