#ifndef __SEARCH_BAR_H__
#define __SEARCH_BAR_H__

#include <gtk/gtk.h>
#include "string.hh"

class SearchBar
{
private:
	GtkWidget* hbox_search_bar;
	GtkWidget* entry_search_bar;
	GtkWidget* button_search_bar_forward;
	GtkWidget* button_search_bar_back;
	GList* list;
	GList* current;

	static void button_search_bar_close_clicked(GtkButton* widget, SearchBar* search_bar);
	static void button_search_bar_forward_clicked(GtkButton* widget, SearchBar* search_bar);
	static void button_search_bar_back_clicked(GtkButton* widget, SearchBar* search_bar);
	static void entry_search_bar_changed(GtkEditable* widget, SearchBar* search_bar);
	static void entry_search_bar_activate(GtkEntry* widget, SearchBar* search_bar);

	void clear_search_results();
	void search();
	void search(const String& query);
	void forward();
	void back();

public:
	SearchBar();
	
	void show();
	void hide();
	gboolean is_visible();
};

#endif
