/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __SCHEDULED_RECORDINGS_DIALOG_H__
#define __SCHEDULED_RECORDINGS_DIALOG_H__

#include <gtk/gtk.h>
#include "scheduled_recording.hh"

class ScheduledRecordingsTreeViewRowCollection;

class ScheduledRecordingsTreeViewRow
{
private:
	GtkTreeModel*	model;
	GtkTreeIter		iter;
		
	String get_tree_view_column_text(gchar* s);

public:
	ScheduledRecordingsTreeViewRow();

	void attach(GtkTreeModel* model, GtkTreeIter* iter);
	void update();
	
	GtkTreeModel*	get_model()	{ return model; }
	GtkTreeIter*	get_iter()	{ return &iter; }
	
	ScheduledRecording scheduled_recording;
};

class ScheduledRecordingsTreeViewRowCollection
{
private:
	GtkTreeIter*	parent_iter;
	GtkTreeIter		iter;
	GtkTreeModel*	model;
public:	
	ScheduledRecordingsTreeViewRowCollection(GtkTreeModel* model, GtkTreeIter* parent_iter = NULL);

	GtkTreeIter*	get_iter() { return &iter; }
	GtkTreeModel*	get_model() { return model; }
	
	void add_row(ScheduledRecordingsTreeViewRow& row);
};

class ScheduledRecordingsTreeView
{
private:
	GtkTreeView* tree_view;
	
	void add_scheduled_recording(ScheduledRecording& scheduled_recording);
	
	static void on_tree_view_row_activated(
		GtkTreeView* tree_view,
		GtkTreePath       *path,
		GtkTreeViewColumn *column,
		ScheduledRecordingsTreeView* scheduled_recordings_tree_view);

public:
	ScheduledRecordingsTreeView(GtkTreeView* tree_view_epg);

	void resize_to_fit();
	void clear();
	void load();
	void add_row(ScheduledRecordingsTreeViewRow& row);
	ScheduledRecordingsTreeViewRowCollection get_rows();
	String get_selected_description();
};

class ScheduledRecordingsDialog
{
private:
	GtkWidget* dialog_scheduled_recordings;
	ScheduledRecordingsTreeView* tree_view;
	
	static void on_button_scheduled_recordings_close_clicked(GtkButton* button, ScheduledRecordingsDialog* scheduled_recordings_dialog);
	static void on_button_scheduled_recordings_add_clicked(GtkButton* button, ScheduledRecordingsDialog* scheduled_recordings_dialog);
	static void on_button_scheduled_recordings_delete_clicked(GtkButton* button, ScheduledRecordingsDialog* scheduled_recordings_dialog);

	void hide();
public:
	ScheduledRecordingsDialog();
	void show();
};

#endif
