#ifndef __MPLAYER_ENGINE_H__
#define __MPLAYER_ENGINE_H__

#include "configuration.hh"
#include "engine.hh"
#include "io.hh"

class MPlayerEngine : public Engine
{
private:
	gint			width, height;
	gint			x, y;
	double			pixel_aspect;
	gboolean		mute_state;
	IO::Channel*	fifo_output_stream;
	String			fifo_path;
	GThread*		video_thread;
	int				pid;
	int				standard_input;
	int				standard_output;
	int				standard_error;
	GtkWidget*		widget;
	gint			dual_language_state;
	gint			audio_channel;
	gint			subtitle_channel;
	
	static gpointer video_thread_function(MPlayerEngine* engine);	
	void send_key_event(unsigned int keycode);
	void send_key_event(int type, long event_mask, unsigned int keycode);
	
	void write(const gchar* buffer, gsize length);
	void open();
	void close();
	void stop();
	void play();
	
	void mute(gboolean state);
	
	void set_audio_channel(gint channel);
	void set_subtitle_channel(gint channel);
	
	Window get_window_id();
	
	void on_timer() {}
	void set_dual_language_state(gint state);

	
public:
	MPlayerEngine();
	~MPlayerEngine();
};

#endif
