/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include "exception.hh"
#include "string_utility.hh"
#include <glib.h>
#include <errno.h>
#include <string.h>
#include "log.hh"
#include <gnome.h>

void Exception::set_message(const String& m)
{
	g_log("Me TV", G_LOG_LEVEL_MESSAGE, _("Exception message: '%s'"), m.c_str());
	message = m;
}

Exception::Exception()
{
}

Exception::Exception(const String& m)
{
	set_message(m);
}

Exception::Exception(const char* fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	gchar* text = g_strdup_vprintf(fmt, ap);
	set_message(text);
	g_free(text);
	va_end(ap);
}

String Exception::get_message() const
{
	return message;
}

SystemException::SystemException(const String& message)
{
	String m = message;
	m += ": ";
	m += strerror(errno);
	set_message(m);
}

SystemException::SystemException(const char* fmt, ...)
{
	String system_message;
	
	va_list ap;
	va_start(ap, fmt);
	gchar* text = g_strdup_vprintf(fmt, ap);
	system_message = String::format("%s: %s", text, strerror(errno));
	g_free(text);
	va_end(ap);
	
	set_message(system_message);
}

TimeoutException::TimeoutException(const String& message)
{
	set_message(message);
}
