/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __ENGINE_H__
#define __ENGINE_H__

#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include "string.hh"
#include "io.hh"

#define ENGINE_DUAL_LANGUAGE_STATE_DISABLED	0
#define ENGINE_DUAL_LANGUAGE_STATE_LEFT		1
#define ENGINE_DUAL_LANGUAGE_STATE_RIGHT	2

class Engine
{
public:
	Engine();
	virtual ~Engine();
	
	virtual void write(const gchar* buffer, gsize length) = 0;
	virtual void open() = 0;
	virtual void close() = 0;
	virtual void on_timer() = 0;
	virtual void mute(gboolean state) = 0;
	virtual void set_audio_channel(gint channel) = 0;
	virtual void set_subtitle_channel(gint channel) = 0;
	virtual void set_dual_language_state(gint state) = 0;
};

#endif
