/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file EpsWindAttributes.cc
    \brief Implemtation of EpsWind Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!
   
    Generated: Tue Nov 22 10:53:37 2011
*/    

#include "EpsWindAttributes.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "XmlNode.h"
#include "ParameterSettings.h"


using namespace magics;


EpsWindAttributes::EpsWindAttributes():
	colour_(MagTranslator<string, Colour>().magics("eps_rose_wind_colour")),
	border_colour_(MagTranslator<string, Colour>().magics("eps_rose_wind_border_colour")),
	convention_(ParameterManager::getString("eps_rose_wind_convention"))
{
} 



EpsWindAttributes::~EpsWindAttributes()
{
}

    
void EpsWindAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	prefix[0] = "eps_rose_wind";
	prefix[1] = "eps";

	setAttribute(prefix, "eps_rose_wind_colour", colour_, params);
	setAttribute(prefix, "eps_rose_wind_border_colour", border_colour_, params);
	setAttribute(prefix, "eps_rose_wind_convention", convention_, params);
}

void EpsWindAttributes::copy(const EpsWindAttributes& other)
{
	setColour(other.colour_->clone());
	setBorder_colour(other.border_colour_->clone());
	convention_ = other.convention_;
} 


bool EpsWindAttributes::accept(const string& node)
{	
	if ( magCompare(node, "epswind")  )
		return true;
	return false;
}

void EpsWindAttributes::set(const XmlNode& node)
{
	if ( this->accept(node.name()) == false ) 
		return;

	if ( magCompare(node.name(), "epswind") )
		set(node.attributes());
	else {
	}
	for (XmlNode::ElementIterator elt = node.firstElement(); elt != node.lastElement(); ++elt) {
	}
}

void EpsWindAttributes::print(ostream& out)  const
{
	out << "EpsWindAttributes[";
	out << "colour = " << *colour_;
	out << ", border_colour = " << *border_colour_;
	out << ", convention = " << convention_;
	out << "]" << "\n";
}


void EpsWindAttributes::toxml(ostream& out, const string& tag, int tabs)  const
{
     out <<  "\"epswind\"";
	 out << ", \"eps_rose_wind_colour\":";
	 niceprint(out, *colour_);
	 out << ", \"eps_rose_wind_border_colour\":";
	 niceprint(out, *border_colour_);
	 out << ", \"eps_rose_wind_convention\":";
	 niceprint(out,convention_);
}
static MagicsParameter<string> eps_rose_wind_colour("eps_rose_wind_colour", "grey", "");
static MagicsParameter<string> eps_rose_wind_border_colour("eps_rose_wind_border_colour", "grey", "");
static MagicsParameter<string> eps_rose_wind_convention("eps_rose_wind_convention", "meteorological", "");
