/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file DotPolyShadingMethodAttributes.h
    \brief Definition of DotPolyShadingMethod Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:37 2011
*/
   

#ifndef DotPolyShadingMethodAttributes_H
#define DotPolyShadingMethodAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class DotPolyShadingMethodAttributes 
{
public:
//  --  constructor
    DotPolyShadingMethodAttributes();
    
//  --  destructor
    virtual ~DotPolyShadingMethodAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const DotPolyShadingMethodAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Size of dot in shading pattern 
    \param size Setting contour_shade_dot_size - default=0.02
*/
	void setSize(double size) 
		{ size_ =  size; } 
	double getSize() const 
		{ return size_; } 
        
/*!
    Magics Information:
    \brief  Dots/square centimetre in highest shading band 
    \param max_density Setting contour_shade_max_level_density - default=50.0
*/
	void setMax_density(double max_density) 
		{ max_density_ =  max_density; } 
	double getMax_density() const 
		{ return max_density_; } 
        
/*!
    Magics Information:
    \brief  Dots/square centimetre in lowest shading band 
    \param min_density Setting contour_shade_min_level_density - default=1.0
*/
	void setMin_density(double min_density) 
		{ min_density_ =  min_density; } 
	double getMin_density() const 
		{ return min_density_; } 
        
/*!
    Magics Information:
    \brief  Angle of shading line to the horizontal in degrees in an anticlockwise direction 
    \param angle Setting contour_shade_angle - default=45.0
*/
	void setAngle(double angle) 
		{ angle_ =  angle; } 
	double getAngle() const 
		{ return angle_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double size_;
	double max_density_;
	double min_density_;
	double angle_;

private:
  
	friend ostream& operator<<(ostream& s,const DotPolyShadingMethodAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
