/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file NetcdfMatrixInterpretorAttributes.h
    \brief Definition of NetcdfMatrixInterpretor Attributes class.
    \author MeteoroMagLogical Visualisation Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Tue Nov 22 10:53:39 2011
*/
   

#ifndef NetcdfMatrixInterpretorAttributes_H
#define NetcdfMatrixInterpretorAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class NetcdfMatrixInterpretorAttributes 
{
public:
//  --  constructor
    NetcdfMatrixInterpretorAttributes();
    
//  --  destructor
    virtual ~NetcdfMatrixInterpretorAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NetcdfMatrixInterpretorAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief Variable name representing the y dimension
    \param y Setting netcdf_y_variable - default=y
*/
	void setY(const string& y) 
		{ y_ =  y; } 
	const string& getY() const 
		{ return y_; } 
        
/*!
    Magics Information:
    \brief Variable name representing the x dimension
    \param x Setting netcdf_x_variable - default=x
*/
	void setX(const string& x) 
		{ x_ =  x; } 
	const string& getX() const 
		{ return x_; } 
        
/*!
    Magics Information:
    \brief varibale can used to define geoline definition.
    \param aux Setting netcdf_x_auxiliary_variable - default=
*/
	void setAux(const string& aux) 
		{ aux_ =  aux; } 
	const string& getAux() const 
		{ return aux_; } 
        
/*!
    Magics Information:
    \brief  Primary index latitude/longitude
    \param primary_index Setting netcdf_matrix_primary_index - default=longitude
*/
	void setPrimary_index(const string& primary_index) 
		{ primary_index_ =  primary_index; } 
	const string& getPrimary_index() const 
		{ return primary_index_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string y_;
	string x_;
	string aux_;
	string primary_index_;

private:
  
	friend ostream& operator<<(ostream& s,const NetcdfMatrixInterpretorAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
