/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphSymbol.cc
    \brief Implementation of the Template class GraphSymbol.
    
    Magics Team - ECMWF 2005
    
    Started: Tue 6-Dec-2005
    
    Changes:
    
*/



#include "GraphSymbol.h"
#include "Symbol.h"
#include "Transformation.h"
#include "Data.h"

using namespace magics;

GraphSymbol::GraphSymbol() 
{
}


GraphSymbol::~GraphSymbol() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void GraphSymbol::print(ostream& out)  const
{
	out << "GraphSymbol[";
	out << "]";
}

void GraphSymbol::operator()(vector<UserPoint>& points, BasicGraphicsObjectContainer& out) 
{
	

	Symbol* symbol = new Symbol();
	
    symbol->setMarker(marker_);
    symbol->setHeight(height_);
    symbol->setColour(*colour_);
	const Transformation& transformation = out.transformation();
		
    for ( vector<UserPoint>::const_iterator point = points.begin(); point != points.end(); ++point) {
    	if ( transformation.in(*point) )     
    		symbol->push_back(transformation(*point));
    }
   
    out.push_back(symbol);
}

void GraphSymbol::legend(PaperPoint& point, BasicGraphicsObjectContainer& task)
{
	Symbol* symbol = new Symbol();
   
    symbol->setMarker(marker_);
    symbol->setHeight(height_);
    symbol->setColour(*colour_);
    symbol->push_back(point);
 
    task.push_back(symbol);
}

