/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file GraphMissingPlot.h
    \brief Definition of the Template class GraphMissingPlot.
    
    Magics Team - ECMWF 2006
    
    Started: Mon 22-May-2006
    
    Changes:
    
*/

#ifndef GraphMissingPlot_H
#define GraphMissingPlot_H

#include "magics.h"
#include "Translator.h"
#include "Factory.h"
#include "BasicGraphicsObject.h"
#include "GraphMissingPlotAttributes.h"



namespace magics {
	
class PaperPoint;


class GraphMissingPlot : public GraphMissingPlotAttributes {

public:
	GraphMissingPlot();
	virtual ~GraphMissingPlot();
    
    virtual void set(const XmlNode& node) {     
        GraphMissingPlotAttributes::set(node);
    }
    virtual void set(const map<string, string>& map) {
    	GraphMissingPlotAttributes::set(map);
    }
    virtual GraphMissingPlot* clone() const {
        Log::dev() << "(const map<string, string&)---> to be checked!...\n";
        return new GraphMissingPlot();
    }
    virtual void toxml(ostream&, int = 0) const {}
    virtual bool operator()(const PaperPoint&, const PaperPoint&, const vector<PaperPoint>&, BasicGraphicsObjectContainer&);
    // if return true needs a new curve! 
 
    
    
protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 

private:
    //! Copy constructor - No copy allowed
	GraphMissingPlot(const GraphMissingPlot&);
    //! Overloaded << operator to copy - No copy allowed
	GraphMissingPlot& operator=(const GraphMissingPlot&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const GraphMissingPlot& p)
		{ p.print(s); return s; }

};

class JoinGraphMissingPlot : public GraphMissingPlot {

public:
  JoinGraphMissingPlot() {}
  ~JoinGraphMissingPlot() {}
  virtual GraphMissingPlot* clone() const {
        return new JoinGraphMissingPlot();
    }
	virtual void print(ostream&) const; 
	virtual bool operator()(const PaperPoint&, const PaperPoint&, const vector<PaperPoint>&, BasicGraphicsObjectContainer&);
};

class DropGraphMissingPlot : public GraphMissingPlot {

public:
  DropGraphMissingPlot() {}
  ~DropGraphMissingPlot() {}
  virtual GraphMissingPlot* clone() const {
        return new DropGraphMissingPlot();
    }
 virtual void print(ostream&) const; 
 virtual bool operator()(const PaperPoint&, const PaperPoint&, const vector<PaperPoint>&, BasicGraphicsObjectContainer&);
};



template <>
class Translator<string, GraphMissingPlot> { 
public:
	GraphMissingPlot* operator()(const string& val )
	{
		return SimpleObjectMaker<GraphMissingPlot>::create(val);
	}     

	GraphMissingPlot* magics(const string& param)
	{
		string val;
		ParameterManager::get(param, val);
		return (*this)(val);
	}
};

} // namespace magics
#endif
