/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file Bar.h
    \brief Definition of the Template class Bar.
    
    Magics Team - ECMWF 2004
    
    Started: Wed 5-May-2004
    
    Changes:
    
*/

#ifndef Bar_H
#define Bar_H

#include "magics.h"

#include "BarAttributes.h"
#include "Curve.h"
#include "Polyline.h"

namespace magics {

class XmlNode;


class Bar: public BarAttributes, public Graph {

public:
	Bar();
	virtual ~Bar();
    
    void set(const XmlNode& node) { 
    	BarAttributes::set(node); 
    	Graph::set(node);
    }
    
    void operator()(Data<UserPoint>&, BasicGraphicsObjectContainer&);
    void visit(LegendVisitor&);
    
    
    // Implements the set method ... 
    void set(const map<string, string>& map ) { BarAttributes::set(map); }

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
 
    

private:
    //! Copy constructor - No copy allowed
	Bar(const Bar&);
    //! Overloaded << operator to copy - No copy allowed
	Bar& operator=(const Bar&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const Bar& p)
		{ p.print(s); return s; }

};

} // namespace magics
#endif
