/*! \file NoAxisTip.h
    \brief Implementation of the Template class NoAxisTip.
    
    Magics Team - ECMWF 2010
    
    Started: Tue 16-Nov-2010
    
    Changes:
    
*/



#include "AxisTip.h"
#include "Text.h"
#include "Transformation.h"
using namespace magics;

NoAxisTip::NoAxisTip() 
{
}


NoAxisTip::~NoAxisTip() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void NoAxisTip::print(ostream& out)  const
{
	out << "NoAxisTip[";
	out << "]";
}

AxisTip::AxisTip() 
{
}


AxisTip::~AxisTip() 
{
}

/*!
 Class information are given to the output-stream.
*/		
void AxisTip::print(ostream& out)  const
{
	out << "AxisTip[";
    AxisTipAttributes::print(out);
	out << "]";
}
void  AxisTip::horizontal(const Colour&, TopAxisVisitor& out) const
{
	cout << "SUPER-> AxisTip::horizontal" << *this << endl;
}

void  AxisTip::horizontal(const Colour& colour,BottomAxisVisitor& out) const
{
	Text* text = new Text();
	
	MagFont font; 
	font.size(height_);
	font.colour((colour_->automatic()) ? colour : *colour_);	
	text->addText(text_, font);
	text->setVerticalAlign(MTOP);
	
	double x;
	
	if ( out.maxX() >  out.minX() )
		x = 4*((out.maxX() + out.minX())/5);	
	else 
		x = (out.maxX() + out.minX())/5;
	
	text->push_back(PaperPoint(x, out.offsetTitle())); 
	
	out.push_back(text);
}

void  AxisTip::vertical(const Colour& colour, LeftAxisVisitor& out) const
{
	double angle = out.angleTip();
		double x = out.offsetTip();
		
		Text* text = new Text();
		MagFont font; 
		font.size(height_);
		font.colour((colour_->automatic()) ? colour : *colour_);	
		text->addText(text_, font);
		
		text->setAngle(( orientation_ == "horizontal" ) ? 0 : angle);
		
		double y;
		if  ( out.minY() <  out.maxY() ) 
			y = 9*((out.minY() + out.maxY())/10);
		else 
			y = (out.minY() + out.maxY())/10;
		
		text->push_back(PaperPoint(x, y)); 
	   
		out.push_back(text);
}

void  AxisTip::vertical(const Colour&,RightAxisVisitor& out) const
{
	cout << "SUPER-> AxisTip::vetical" << *this << endl;
}
