/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file ObsDecoderAttributes.h
    \brief Definition of ObsDecoder Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:56 2011
*/
   

#ifndef ObsDecoderAttributes_H
#define ObsDecoderAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"



namespace magics {

class XmlNode;



class ObsDecoderAttributes 
{
public:
//  --  constructor
    ObsDecoderAttributes();
    
//  --  destructor
    virtual ~ObsDecoderAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const ObsDecoderAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  The name of the input file containing the BUFR code field(s) 
    \param file_name Setting obs_input_file_name - default=
*/
	void setFile_name(string file_name) 
		{ file_name_ =  file_name; } 
	string getFile_name() const 
		{ return file_name_; } 
        
/*!
    Magics Information:
    \brief  Pressure level to be plotted (upper air only) 
    \param level Setting obs_level - default=500
*/
	void setLevel(int level) 
		{ level_ =  level; } 
	int getLevel() const 
		{ return level_; } 
        
/*!
    Magics Information:
    \brief  2nd pressure level (for thickness plots only) 
    \param level2 Setting obs_level_2 - default=1000
*/
	void setLevel2(int level2) 
		{ level2_ =  level2; } 
	int getLevel2() const 
		{ return level2_; } 
        
/*!
    Magics Information:
    \brief  Tolerance (hPa) above and below the requested level for which observations may be plotted (applies to OBS_LEVEL only) 
    \param tolerance Setting obs_level_tolerance - default=0
*/
	void setTolerance(int tolerance) 
		{ tolerance_ =  tolerance; } 
	int getTolerance() const 
		{ return tolerance_; } 
        
/*!
    Magics Information:
    \brief  A list of observation types (SATEM, TEMP etc) for which observations are to be plotted 
    \param types Setting obs_type_list - default=stringarray()
*/
	void setTypes(stringarray types) 
		{ types_ =  types; } 
	stringarray getTypes() const 
		{ return types_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	string file_name_;
	int level_;
	int level2_;
	int tolerance_;
	stringarray types_;

private:
  
	friend ostream& operator<<(ostream& s,const ObsDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
