/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file NetcdfOrcaInterpretor.h
    \brief Implementation of the Template class NetcdfOrcaInterpretor.
    
    Magics Team - ECMWF 2004
    
    Started: Tue 17-Feb-2004
    
    Changes:
    
*/

#include "NetcdfOrcaInterpretor.h"
#include "Factory.h"
#include "Netcdf.h"
#include <limits>

using namespace magics;

NetcdfOrcaInterpretor::NetcdfOrcaInterpretor() 
{}


NetcdfOrcaInterpretor::~NetcdfOrcaInterpretor() 
{}

void NetcdfOrcaInterpretor::interpretAsMatrix(Matrix** data)
{
	
	if ( *data ) return;
	

	
	    
		
	  
		Netcdf netcdf(path_);
		
		
		int jm = netcdf.getDimension("y");
		int im = netcdf.getDimension("x");
		
		ProjectedMatrix* matrix = new ProjectedMatrix(jm, im);
		
		*data = matrix;
		matrix->missing(std::numeric_limits<double>::max());
		
		// get the data ...
		try
		{
			
					map<string, string> first, last;
					setDimensions(dimension_, first, last);
			       
					netcdf.get(field_, *matrix, first, last);
					Log::debug() << "data[" << matrix->size() << ":" << scaling_ << ", " << offset_ << "\n";

					matrix->multiply(scaling_);
					matrix->plus(offset_);
					
					netcdf.get(longitude_, matrix->columnsArray(), first, last);
					netcdf.get(latitude_,  matrix->rowsArray(), first, last);
					
					matrix->setMapsAxis();
					
	        
			Log::dev() << *matrix << "\n";
			
		}
	    
		catch (MagicsException& e)
		{
			Log::error() << e << "\n";
		}
}


void NetcdfOrcaInterpretor::interpretAsPoints(PointsList<GeoPoint>& points)
{
	
    Matrix latitudes;
    Matrix longitudes;
	Matrix matrix;
	
	matrix.missing(std::numeric_limits<double>::max());
	// later!
#ifdef later
	// get the data ...
	try
	{
		Log::dev() << " Netcdf File Path --->" << path_ << "\n";
		Netcdf netcdf(path_);
		map<string, string> first, last;
		setDimensions(dimension_, first, last);
       
		netcdf.get(field_, matrix, first, last);
		Log::debug() << "data[" << matrix->size() << ":" << scaling_ << ", " << offset_ << "\n";

		matrix->multiply(scaling_);
		matrix->plus(offset_);
		vector<double> rows, columns;
	
		
		for (int i = 0; i < netcdf.getDimension(x_); i++)
			columns.push_back(i);
	   
	    for (int i = 0; i < netcdf.getDimension(y_); i++)
			rows.push_back(i);

		matrix->setRowsAxis(rows);
		matrix->setColumnsAxis(columns);
		
		
		
	 
		Log::debug() << "data[" << matrix->size() << ", " << scaling_ << ", " << offset_ << "]" << "\n";
        
		netcdf.get(longitude_,longitudes, first, last);
		netcdf.get(latitude_, latitudes, first, last);
		
		longitudes.setRowsAxis(rows);
		longitudes.setColumnsAxis(columns);
		
		latitudes.setColumnsAxis(columns);
        latitudes.setRowsAxis(rows);
        
        Log::debug() << latitudes.size() << ", " << rows.size() << ", " << columns.size() << "]" << "\n";
            
		for (unsigned int y = 0; y < rows.size(); y++) {
		  for (unsigned int x = 0; x < columns.size(); x++) {
		  	points.push_back(GeoPoint(longitudes(y, x), latitudes(y, x), matrix(y, x)));		  	
		  	Log::dev() << "(" << longitudes(y, x) << ", " << latitudes(y, x) << ", " << matrix(y, x) << "]" << "\n";
		  }
	} 
	}
   
	catch (MagicsException& e)
	{
		Log::error() << e << "\n";
	}
#endif
}



/*!
 Class information are given to the output-stream.
*/		
void NetcdfOrcaInterpretor::print(ostream& out)  const
{
	out << "NetcdfOrcaInterpretor[";
	NetcdfInterpretor::print(out);
	NetcdfGeoMatrixInterpretorAttributes::print(out);
	out << "]";
}

static SimpleObjectMaker<NetcdfOrcaInterpretor, NetcdfInterpretor> netcdf_geovalues_interpretor("orca");

