/******************************** LICENSE ********************************

 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at 

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 ******************************** LICENSE ********************************/

/*! \file InputMatrix.h
    \brief Definition of the Template class InputMatrix.
    
    Magics Team - ECMWF 2005
    
    Started: Fri 16-Sep-2005
    
    Changes:
    
*/

#ifndef InputMatrix_H
#define InputMatrix_H

#include "magics.h"

#include "InputMatrixAttributes.h"
#include "Data.h"

namespace magics {

template <class P>
class InputMatrix: public Data<P>, public InputMatrixAttributes {

public:
	InputMatrix();
	virtual ~InputMatrix();
	
	virtual void set(const map<string, string>& map) { InputMatrixAttributes::set(map); }
	virtual void set(const XmlNode& node) { InputMatrixAttributes::set(node); }

	virtual MatrixHandler<P>& matrix();
	virtual MatrixHandler<P>& xComponent();
	virtual MatrixHandler<P>& yComponent();
	
	virtual PointsHandler<P>& points(const Transformation&);
	
	void customisedPoints(const BasicThinningMethod&, const Transformation&, const std::set<string>&, CustomisedPointsList& );
	       
	
	bool defined()
	{
	   return !field_.empty() || 
	           (
	             (!u_component_.empty() && !u_component_.empty() )    ||
	             (!wind_speed_.empty()  && !wind_direction_.empty() ) || 
	             simple_field_
	           );
	}
	void filter(Matrix&);

protected:
     //! Method to print string about this class on to a stream of type ostream (virtual).
	 virtual void print(ostream&) const; 
     Matrix* matrix_;
     Matrix* u_;
     Matrix* v_;
     Matrix* speed_;
     Matrix* direction_;
     
private:
    //! Copy constructor - No copy allowed
	InputMatrix(const InputMatrix<P>&);
    //! Overloaded << operator to copy - No copy allowed
	InputMatrix& operator=(const InputMatrix<P>&);

// -- Friends
    //! Overloaded << operator to call print().
	friend ostream& operator<<(ostream& s,const InputMatrix<P>& p)
		{ p.print(s); return s; }

};
} // namespace magics

#include "InputMatrix.cc"

#endif
