# -*- ruby -*
#
# Expanding a template with attributed text.
#

require 'xtemplate'

THIS = XTemplate::TextNode

data = {
  'links' => [
    {'@href' => 'http://www.foo.com/', THIS => 'foo.com'},
    {'@href' => 'http://www.bar.com/', THIS => 'bar.com'},
    {'@href' => 'http://www.foo.org/', THIS => 'foo.org'},
    {'@href' => 'http://www.bar.org/', THIS => nil},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<links>
  <a id="links">default text</a>
</links>
EOF

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data))
