/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.PipelineReader;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.PropertiesWriter;

public class GenMapAndTopicListModule
extends AbstractPipelineModule {
    private PipelineReader reader = null;
    private Set ditaList = new TreeSet();
    private Set fullTopicList = new TreeSet();
    private Set fullMapList = new TreeSet();
    private Set hrefTopicList = new TreeSet();
    private Set hrefMapList = new TreeSet();
    private Set conrefList = new TreeSet();
    private Set imageList = new TreeSet();
    private List waitList = null;

    public GenMapAndTopicListModule() {
        this.reader = new PipelineReader();
        this.waitList = new ArrayList();
        try {
            this.reader.initXMLReader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AbstractPipelineOutput execute(AbstractPipelineInput input) {
        String inputFile = ((PipelineHashIO)input).getAttribute("inputmap");
        String baseDir = ((PipelineHashIO)input).getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        this.addToWaitList(inputFile);
        int i = 0;
        while (i < this.waitList.size()) {
            String filename = (String)this.waitList.get(i);
            try {
                if (baseDir != null) {
                    this.reader.parse(baseDir + "|" + filename);
                } else {
                    this.reader.parse(filename);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iter = this.reader.getResult().iterator();
            while (iter.hasNext()) {
                String item = (String)iter.next();
                this.addToWaitList(item);
                String lcaseItem = item.toLowerCase();
                if (!lcaseItem.endsWith(".jpg") && !lcaseItem.endsWith(".gif") && !lcaseItem.endsWith(".eps")) continue;
                this.imageList.add(item);
            }
            this.ditaList.add(filename);
            if (this.reader.hasConRef()) {
                this.conrefList.add(filename);
            }
            if (filename.toLowerCase().endsWith(".dita") || filename.toLowerCase().endsWith(".xml")) {
                this.fullTopicList.add(filename);
                if (this.reader.hasHref()) {
                    this.hrefTopicList.add(filename);
                }
            }
            if (filename.toLowerCase().endsWith(".ditamap")) {
                this.fullMapList.add(filename);
                if (this.reader.hasHref()) {
                    this.hrefMapList.add(filename);
                }
            }
            ++i;
        }
        Properties prop = new Properties();
        prop.put("dita.list", StringUtils.assembleString(this.ditaList, ",").replaceAll("\\\\", "/"));
        prop.put("fullditatopc.list", StringUtils.assembleString(this.fullTopicList, ",").replaceAll("\\\\", "/"));
        prop.put("fullditamap.list", StringUtils.assembleString(this.fullMapList, ",").replaceAll("\\\\", "/"));
        prop.put("hrefditatopc.list", StringUtils.assembleString(this.hrefTopicList, ",").replaceAll("\\\\", "/"));
        prop.put("conref.list", StringUtils.assembleString(this.conrefList, ",").replaceAll("\\\\", "/"));
        prop.put("imagelist.list", StringUtils.assembleString(this.imageList, ",").replaceAll("\\\\", "/"));
        PropertiesWriter writer = new PropertiesWriter();
        ContentImpl content = new ContentImpl();
        content.setObject(prop);
        writer.setContent(content);
        try {
            File dir = new File(tempDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            writer.write(tempDir + File.separator + "dita.list");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void addToWaitList(String fileName) {
        if (this.waitList.contains(fileName)) {
            return;
        }
        if (fileName.endsWith(".dita") || fileName.endsWith(".xml") || fileName.endsWith(".ditamap")) {
            this.waitList.add(fileName);
        }
    }
}

