/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.tr;

import com.jclark.xsl.expr.StringExpr;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.tr.Action;
import com.jclark.xsl.tr.ProcessContext;
import com.jclark.xsl.tr.Result;

class ElementAction
implements Action {
    private StringExpr nameExpr;
    private StringExpr namespaceExpr;
    private NamespacePrefixMap nsMap;
    private Action content;

    ElementAction(StringExpr nameExpr, StringExpr namespaceExpr, NamespacePrefixMap nsMap, Action content) {
        this.nameExpr = nameExpr;
        this.namespaceExpr = namespaceExpr;
        this.nsMap = nsMap;
        this.content = content;
    }

    public void invoke(ProcessContext context, Node sourceNode, Result result) throws XSLException {
        Name name;
        String qname = this.nameExpr.eval(sourceNode, context);
        NamespacePrefixMap map = this.nsMap.getNameTable().getEmptyNamespacePrefixMap();
        if (this.namespaceExpr != null) {
            int i = qname.indexOf(58);
            String ns = this.namespaceExpr.eval(sourceNode, context);
            if (ns.length() == 0) {
                name = this.nsMap.getNameTable().createName(qname.substring(i + 1));
            } else {
                map = i > 0 ? map.bind(qname.substring(0, i), ns) : map.bindDefault(ns);
                name = map.expandElementTypeName(qname, null);
            }
        } else {
            name = this.nsMap.expandElementTypeName(qname, sourceNode);
            String ns = name.getNamespace();
            if (ns != null) {
                String prefix = name.getPrefix();
                map = prefix != null ? map.bind(prefix, ns) : map.bindDefault(ns);
            }
        }
        result.startElement(name, map);
        if (this.content != null) {
            this.content.invoke(context, sourceNode, result);
        }
        result.endElement(name);
    }
}

