/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax2;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax2.Indenter;
import com.jclark.xsl.sax2.OutputContentHandler;
import com.jclark.xsl.sax2.RawCharactersHandler;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XMLOutputHandler
implements OutputContentHandler,
CommentHandler,
RawCharactersHandler {
    private OutputStream out = null;
    private boolean keepOpen;
    private boolean inStartTag = false;
    private boolean omitXmlDeclaration = false;
    private String standalone;
    private static final int DEFAULT_BUF_LENGTH = 8192;
    private byte[] buf = new byte[8192];
    private int bufUsed = 0;
    private String lineSeparator = System.getProperty("line.separator");
    private byte minimize = 1;
    private String doctypeSystem;
    private String doctypePublic;
    private boolean outputDoctype = false;
    public static final byte MINIMIZE_NONE = 0;
    public static final byte MINIMIZE_EMPTY_ELEMENTS = 1;
    public static final byte MINIMIZE_EMPTY_ELEMENTS_HTML = 2;

    public XMLOutputHandler() {
    }

    public XMLOutputHandler(OutputStream out) {
        this();
        this.out = out;
    }

    public ContentHandler init(Destination dest, Properties props) throws IOException {
        this.out = dest.getOutputStream("application/xml", null);
        this.keepOpen = dest.keepOpen();
        if ("yes".equals(props.getProperty("omit-xml-declaration"))) {
            this.omitXmlDeclaration = true;
        }
        this.standalone = props.getProperty("standalone");
        this.doctypeSystem = props.getProperty("doctype-system");
        this.doctypePublic = props.getProperty("doctype-public");
        if (this.doctypeSystem != null || this.doctypePublic != null) {
            this.outputDoctype = true;
        }
        if ("yes".equals(props.getProperty("indent"))) {
            return new Indenter(this, this);
        }
        return this;
    }

    public void setMinimize(byte minimize) {
        this.minimize = minimize;
    }

    public void startDocument() throws SAXException {
        if (!this.omitXmlDeclaration) {
            this.writeRaw("<?xml version=\"1.0\" encoding=\"utf-8\"");
            if (this.standalone != null) {
                this.writeRaw(" standalone=\"");
                this.writeRaw(this.standalone);
                this.put((byte)34);
            }
            this.writeRaw("?>");
            this.writeRaw(this.lineSeparator);
        }
    }

    public void characters(char[] cbuf, int off, int len) throws SAXException {
        if (len == 0) {
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        do {
            char c = cbuf[off++];
            switch (c) {
                case '\n': {
                    this.writeRaw(this.lineSeparator);
                    break;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    break;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    break;
                }
                case '>': {
                    this.writeRaw("&gt;");
                    break;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        break;
                    }
                    try {
                        this.writeMB(c);
                        break;
                    }
                    catch (CharConversionException e) {
                        if (len-- == 0) {
                            throw new SAXException(e);
                        }
                        this.writeSurrogatePair(cbuf[off - 1], cbuf[off]);
                        ++off;
                    }
                }
            }
        } while (--len > 0);
    }

    public void rawCharacters(String chars) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw(chars);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        while (length > 0) {
            this.put((byte)ch[start]);
            --length;
            ++start;
        }
    }

    private void writeRaw(String str) throws SAXException {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                this.put((byte)c);
                continue;
            }
            try {
                this.writeMB(str.charAt(i));
                continue;
            }
            catch (CharConversionException e) {
                if (++i == n) {
                    throw new SAXException(e.getMessage());
                }
                this.writeSurrogatePair(c, str.charAt(i));
            }
        }
    }

    private final void writeMB(char c) throws SAXException, CharConversionException {
        switch (c & 0xF800) {
            case 0: {
                this.put((byte)(c >> 6 & 0x1F | 0xC0));
                this.put((byte)(c & 0x3F | 0x80));
                break;
            }
            default: {
                this.put((byte)(c >> 12 & 0xF | 0xE0));
                this.put((byte)(c >> 6 & 0x3F | 0x80));
                this.put((byte)(c & 0x3F | 0x80));
                break;
            }
            case 55296: {
                throw new CharConversionException("invalid surrogate pair");
            }
        }
    }

    private final void writeSurrogatePair(char c1, char c2) throws SAXException {
        if ((c1 & 0xFC00) != 55296 || (c2 & 0xFC00) != 56320) {
            throw new SAXException("invalid surrogate pair");
        }
        int c = (c1 & 0x3FF) << 10 | c2 & 0x3FF;
        this.put((byte)((c += 65536) >> 18 & 7 | 0xF0));
        this.put((byte)(c >> 12 & 0x3F | 0x80));
        this.put((byte)(c >> 6 & 0x3F | 0x80));
        this.put((byte)(c & 0x3F | 0x80));
    }

    public void startElement(String namespace, String localName, String qName, Attributes atts) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        if (this.outputDoctype) {
            byte lit;
            this.outputDoctype = false;
            this.writeRaw("<!DOCTYPE ");
            this.writeRaw(qName);
            if (this.doctypePublic != null) {
                this.writeRaw(" PUBLIC ");
                lit = this.doctypePublic.indexOf(34) >= 0 ? (byte)39 : 34;
                this.put(lit);
                this.writeRaw(this.doctypePublic);
                this.put(lit);
            } else {
                this.writeRaw(" SYSTEM");
            }
            if (this.doctypeSystem != null) {
                lit = this.doctypeSystem.indexOf(34) >= 0 ? (byte)39 : 34;
                this.put((byte)32);
                this.put(lit);
                this.writeRaw(this.doctypeSystem);
                this.put(lit);
            }
            this.put((byte)62);
            this.writeRaw(this.lineSeparator);
        }
        this.put((byte)60);
        this.writeRaw(qName);
        int n = atts.getLength();
        for (int i = 0; i < n; ++i) {
            this.put((byte)32);
            this.writeRaw(atts.getQName(i));
            this.put((byte)61);
            this.put((byte)34);
            this.attributeValue(atts.getValue(i));
            this.put((byte)34);
        }
        this.inStartTag = true;
    }

    protected void attributeValue(String value) throws SAXException {
        int valueLength = value.length();
        block10: for (int j = 0; j < valueLength; ++j) {
            char c = value.charAt(j);
            switch (c) {
                case '\n': {
                    this.writeRaw("&#10;");
                    continue block10;
                }
                case '&': {
                    this.writeRaw("&amp;");
                    continue block10;
                }
                case '<': {
                    this.writeRaw("&lt;");
                    continue block10;
                }
                case '\"': {
                    this.writeRaw("&quot;");
                    continue block10;
                }
                case '\r': {
                    this.writeRaw("&#13;");
                    continue block10;
                }
                case '\t': {
                    this.writeRaw("&#9;");
                    continue block10;
                }
                default: {
                    if (c < '\u0080') {
                        this.put((byte)c);
                        continue block10;
                    }
                    try {
                        this.writeMB(c);
                        continue block10;
                    }
                    catch (CharConversionException e) {
                        if (++j == valueLength) {
                            throw new SAXException(e.getMessage());
                        }
                        this.writeSurrogatePair(value.charAt(j - 1), value.charAt(j));
                    }
                }
            }
        }
    }

    private final void finishStartTag() throws SAXException {
        this.inStartTag = false;
        this.put((byte)62);
    }

    public void endElement(String namespace, String localName, String qName) throws SAXException {
        if (this.inStartTag) {
            this.inStartTag = false;
            if (this.minimize != 0) {
                if (this.minimize == 2) {
                    this.put((byte)32);
                }
                this.put((byte)47);
                this.put((byte)62);
                return;
            }
            this.put((byte)62);
        }
        this.put((byte)60);
        this.put((byte)47);
        this.writeRaw(qName);
        this.put((byte)62);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target == null) {
            this.comment(data);
            return;
        }
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.put((byte)60);
        this.put((byte)63);
        this.writeRaw(target);
        if (data.length() > 0) {
            this.put((byte)32);
            this.writeMarkup(data);
        }
        this.put((byte)63);
        this.put((byte)62);
    }

    public void markup(String chars) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeMarkup(chars);
    }

    public void comment(String body) throws SAXException {
        if (this.inStartTag) {
            this.finishStartTag();
        }
        this.writeRaw("<!--");
        this.writeMarkup(body);
        this.writeRaw("-->");
    }

    private void writeMarkup(String str) throws SAXException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                this.writeRaw(this.lineSeparator);
                continue;
            }
            if (c < '\u0080') {
                this.put((byte)c);
                continue;
            }
            try {
                this.writeMB(c);
                continue;
            }
            catch (CharConversionException e) {
                if (++i == len) {
                    throw new SAXException(e);
                }
                this.writeSurrogatePair(c, str.charAt(i));
            }
        }
    }

    private final void put(byte b) throws SAXException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = b;
    }

    private final void flushBuf() throws SAXException {
        try {
            this.out.write(this.buf, 0, this.bufUsed);
            this.bufUsed = 0;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void skippedEntity(String name) {
    }

    public void setDocumentLocator(Locator loc) {
    }

    public void endDocument() throws SAXException {
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        try {
            if (this.out != null) {
                if (this.keepOpen) {
                    this.out.flush();
                } else {
                    this.out.close();
                }
                this.out = null;
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.out = null;
        this.buf = null;
    }
}

