/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.expr;

import com.jclark.xsl.expr.ConvertibleBooleanExpr;
import com.jclark.xsl.expr.ConvertibleExpr;
import com.jclark.xsl.expr.ConvertibleStringExpr;
import com.jclark.xsl.expr.ExprContext;
import com.jclark.xsl.expr.Function1;
import com.jclark.xsl.expr.ParseException;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.XSLException;

class LangFunction
extends Function1 {
    LangFunction() {
    }

    ConvertibleExpr makeCallExpr(ConvertibleExpr e) throws ParseException {
        final ConvertibleStringExpr se = e.makeStringExpr();
        return new ConvertibleBooleanExpr(){

            public boolean eval(Node node, ExprContext context) throws XSLException {
                return LangFunction.lang(node, se.eval(node, context));
            }
        };
    }

    private static boolean lang(Node node, String lang) {
        Name XML_LANG = node.getNamespacePrefixMap().getNameTable().createName("xml:lang", "http://www.w3.org/XML/1998/namespace");
        while (node != null) {
            String nodeLang = node.getAttributeValue(XML_LANG);
            if (nodeLang != null) {
                return LangFunction.isSubLanguage(lang, nodeLang);
            }
            node = node.getParent();
        }
        return false;
    }

    private static boolean isSubLanguage(String lang1, String lang2) {
        int len2;
        int len1 = lang1.length();
        if (len1 > (len2 = lang2.length())) {
            return false;
        }
        if (len1 < len2 && lang2.charAt(len1) != '-') {
            return false;
        }
        block3: for (int i = 0; i < len1; ++i) {
            char c1 = lang1.charAt(i);
            char c2 = lang2.charAt(i);
            switch (c1 - c2) {
                case -32: 
                case 0: 
                case 32: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

