/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include <stdlib.h>
#include <stdio.h>
#include "finestre.h"

char *TabulazioniRiga (char *riga_in)
{
	static char riga_out[256];
	static char *tab="        ";
	int len_in=strlen(riga_in);
	int lltab=0;
	int p_in=0;
	int p_out=0;

	for (p_in=0;p_in<len_in;p_in++)
	{
		if (riga_in[p_in]=='\t')
		{
			lltab=strlen(tab)-(p_out % strlen(tab)) ;
			strncpy (riga_out+p_out,tab,lltab);
			p_out=p_out+lltab;
		}
		else
		{
			riga_out[p_out]=riga_in[p_in];
			p_out=p_out+1;
		}
	
	}
	riga_out[p_out]='\0';

	return (riga_out);

}

int WX11_viewfile_ok ()
{
	Window focusWin;
	int reverToReturn;

	// Prende la finestra attiva	
	XGetInputFocus(WX11_GetDisplay(), &focusWin, &reverToReturn);

	ChiudeFinestra (focusWin);

	return (1);	// Termina
}

int WX11_ViewFile (char *filename,char *titolo,int LlWin, int HhWin)
{
	int size,r_bytes;
	char *buffile;
	int TipoScroll=0;

	CmdInfo *my,*area,*button;
	CmdInfo *PrevMain;
	int colorfg=WX11_ColorGet(WINFG);
	int colorbg=WX11_ColorGet(WINBG);

	//ListCmdInfo *ViewFile;

	FILE *in, *fopen();

	in = fopen(filename, "r");
	if (!in)
	{
		//sprintf (buff,"Errore apertura %s",filename);
		//printf (buff);
		WX11_Alert ("Cannot open file","Ok",NULL);
		return (1);
	}

	PrevMain=GetPrevTopLevelWindow();
	if (PrevMain)
	{

		WX11_DisableTopLevelWindow(PrevMain);

		my=ApreFinestra (
			titolo,
			PrevMain->x+(((PrevMain->Width)-(LlWin))/2),
			PrevMain->y+(((PrevMain->Height)-(HhWin))/2),
			LlWin,HhWin);

		XSetTransientForHint(
			WX11_GetDisplay(), 
			my->win,
			PrevMain->win
			);
	}
	else
	{
		my=ApreFinestraCentrale (titolo,LlWin,HhWin);
	}
	
	fseek(in, 0, SEEK_END);
	size=ftell(in);
	fseek(in, 0, SEEK_SET);
	
	buffile=malloc(size+1);
	if (!buffile)
	{
		printf ("Cannot malloc buffer\n");
		return (1);
	}
	r_bytes=fread(buffile, 1, size, in); 
	buffile[r_bytes]='\0';
	//printf ("%s",buffile);

	area=WX11_CmdOpen (AREA,my,5,5,LlWin-10,HhWin-60,colorbg, colorfg,2,buffile);
	WX11_Print (area,0,0,buffile);
	free(buffile);
	fclose (in);

	if ((area->scroll_max_y) > (area->Height)+1)
        	TipoScroll+=1;
	if ((area->scroll_max_x) > (area->Width)+1)
        	TipoScroll+=2;
	if (TipoScroll)
        	WX11_ScrollBar (area,TipoScroll);


	button=ApreBottone(my,(LlWin-100)/2,HhWin-35,100,20,"Ok");
        WX11_SetSignalCallBack (button,Button1Release,WX11_viewfile_ok,NULL);
	
	WX11_Events (my);

	if (PrevMain)
		WX11_EnableTopLevelWindow (PrevMain);


	return (0);
}

