constant cvs_version="$Id: sqlextras.pike,v 1.1 bwellive  Exp $"; 

// This isa roxen module.
// Required sqltag to be loaded.
// Written by Bill Welliver <hww3@riverweb.com>
// This module is made available under GPL version 2 or later.

// constant thread_safe=1;

#include <module.h>

inherit "module";
inherit "roxenlib";

import Array;
import Sql;

/*
 * Module interface functions
 */

array register_module()
{
  return( ({ MODULE_PARSER,
	       "SQL-Extras",
	       "This module gives the two tags: &lt;SQLREPORT&gt; "
	       "and &lt;SQLFORM&gt;.<br>This module requires the SQL (sqltag) "
	       "module to be installed.<br>\n"
	       "Usage:<ul>\n"
	       "<table border=0>\n"
	       "<tr><td valign=top><b>&lt;sqlreport&gt;</b></td>"
	       "<td>Executes an SQL-query, and "
	       "generates a vertically oriented table report.</td></tr>\n"
	       "<tr><td valign=top><b>&lt;sqlform&gt;</b></td>\n"
	       "<td>Creates HTML form elements based on the"
	       "database's schema.</td></tr>\n"
	       "</table></ul>\n"
	       "The following attributes are used by the above tags:<ul>\n"
	       "<table border=0>\n"
	       "<tr><td valign=top><b>query</b></td>"
	       "<td>The actual SQL-query. (<b>Used only for SQLREPORT</b>)</td></tr>\n"
	       "<tr><td valign=top><b>table</b></td>"
	       "<td>The table to generate a table for. (<b>Used only for SQLFORM</b>)</td></tr>\n"
	       "<tr><td valign=top><b>host<b></td>"
	       "<td>The hostname of the machine the SQL-server runs on.<br>\n"
	       "This argument can also be used to specify which SQL-server "
	       "to use by specifying an \"SQL-URL\":<br><ul>\n"
	       "<pre>[<i>sqlserver</i>://][[<i>user</i>][:<i>password</i>]@]"
	       "[<i>host</i>[:<i>port</i>]]/<i>database</i></pre><br>\n"
	       "</ul>Valid values for \"sqlserver\" depend on which "
	       "sql-servers your pike has support for, but the following "
	       "might exist: msql, mysql, odbc, oracle, postgres.</td></tr>\n"
	       "<tr><td valign=top><b>database</b></td>"
	       "<td>The name of the database to use.</td></tr>\n"
	       "<tr><td valign=top><b>user</b></td>"
	       "<td>The name of the user to access the database with.</td></tr>\n"
	       "<tr><td valign=top><b>password</b></td>"
	       "<td>The password to access the database.</td></tr>\n"
	       "</table></ul><p>\n"
	       "\n"
	       "<b>NOTE</b>: Specifying passwords in the documents may prove "
	       "to be a security hole if the module is not loaded for some "
	       "reason.<br>\n",
	       0,
	       1 }) );
}

/*
 * Tag handlers
 */

string sqlform_tag(string tag_name, mapping args,
		    object request_id, mapping defines)
{
string retval="";
array rs;
    object(sql) con;
    string host = request_id->conf->modules->sqltag->enabled->query("hostname");
#ifdef SQL_TAG_COMPAT
    string database = request_id->conf->modules->sqltag->enabled->query("database");
    string user = request_id->conf->modules->sqltag->enabled->query("user");
    string password =  request_id->conf->modules->sqltag->enabled->query("password");
#else /* SQL_TAG_COMPAT */
    string database, user, password;
#endif /* SQL_TAG_COMPAT */
    object(sql) con;
    array(mapping(string:mixed)) result;
perror(sprintf("%O",mkmapping(values(request_id->conf),indices(request_id->conf))));
    mixed sql_connect = request_id->conf->sql_connect;
    mixed error;

    if (args->host) {
      host = args->host;
      user = "";
      password = "";
    }
    if (args->database) {
      database = args->database;
      user = "";
      password = "";
      sql_connect = 0;
    }
    if (args->user) {
      user = args->user;
      sql_connect = 0;
    }
    if (args->password) {
      password = args->password;
      sql_connect = 0;
    }
    if (sql_connect) {
      error = catch(con = sql_connect(host));
    } else {
      host = (lower_case(host) == "localhost")?"":host;
      error = catch(con = sql(host, database, user, password));
    }
    if (error) {
      if (!args->quiet) {
	retval = "<h1>Couldn't connect to SQL-server</h1><br>\n" +
	  ((master()->describe_backtrace(error)/"\n")*"<br>\n" + "<false>");
      } else {
	retval = "<false>";
      }
    } 
    array(mapping(string:mixed)) r=con->list_fields(args->table); 
retval+=  "<INPUT TYPE=HIDDEN NAME=db VALUE=\""+database+"\">\n"
        "<INPUT TYPE=HIDDEN NAME=h VALUE=\""+host+"\">\n"
        "<INPUT TYPE=HIDDEN NAME=t VALUE=\""+args->table+"\">\n"
        "<TABLE>\n";


for(int i=0; i<sizeof(r);i++){          // Generate form from schema


if(r[i]->type=="blob"){
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        +replace(r[i]->name,"_"," ")+
        "</FONT></TD>\n"
        "<TD>\n";

        retval+="<TEXTAREA NAME=\""+r[i]->name+"\" COLS=70 ROWS=5></TEXTAREA>\n"
	"</TD></TR>\n";
        }
        

else if(r[i]->type=="decimal"){
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        +replace(r[i]->name,"_"," ")+
        " <b>$</b></FONT></TD>\n"
        "<TD>\n";
  
        retval+="<INPUT TYPE=TEXT NAME=\""+r[i]->name+"\" SIZE="+r[i]->length+
	">\n";
        if(r[i]->flags->not_null) retval+="&nbsp;<FONT FACE=helvetica,arial SIZE=-1><i>Required</i>\n";
        }

else if(r[i]->type=="var string"){
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        +replace(r[i]->name,"_"," ")+
        "</FONT></TD>\n"
        "<TD>\n";

        retval+="<INPUT TYPE=TEXT NAME=\""
+r[i]->name+"\" SIZE="+r[i]->length+" MAXLEN="+r[i]->length+">\n";
        if(r[i]->flags->not_null)
retval+="&nbsp;<FONT FACE=helvetica,arial SIZE=-1><I> Required\n";
        }

else if(r[i]->type=="string"){
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        +replace(r[i]->name,"_"," ")+
        "</FONT></TD>\n"
        "<TD>\n";
    
        if(r[i]["default"]=="N")
        retval+="<SELECT NAME=\""
+r[i]->name+"\"><OPTION VALUE=\"N\">No\n<OPTION VALUE=\"Y\">Yes\n</SELECT>\n";
        else if(r[i]["default"]=="Y")
        retval+="<SELECT NAME=\""
+r[i]->name+"\"><OPTION VALUE=\"Y\">Yes\n<OPTION VALUE=\"N\">No\n</SELECT>\n";
        else retval+="<INPUT TYPE=TEXT NAME=\""
+r[i]->name+"\" MAXLEN="+r[i]->length+" SIZE="+(r[i]->length+20)+">\n";
        if(r[i]->flags->not_null)
retval+="&nbsp;<FONT FACE=helvetica,arial SIZE=-1><I> Required\n";

        }

else if(r[i]->type=="long" && r[i]->flags["not_null"]){
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT>&nbsp;</TD>\n<TD>\n";
        retval+="<INPUT TYPE=HIDDEN NAME=\""
+r[i]->name+"\" MAXLEN="+r[i]->length+" SIZE="+r[i]->length+" VALUE=NULL>\n";

        }
else if(r[i]->type=="unknown")  {
        retval+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        "&nbsp; </FONT></TD>\n"
        "<TD>\n";

        retval+="<INPUT TYPE=HIDDEN NAME=\""+r[i]->name+"\" VALUE=NULL>\n";
        if(r[i]->flags->not_null)
retval+="&nbsp;<FONT FACE=helvetica,arial SIZE=-1><I> Required\n";

        }
retval+="</TD>\n"
        "</TR>\n";

}              
return retval;

       }




/*
 * Setting the defaults
 */

void create()
{
}

/*
 * More interface functions
 */

void start()
{
}

void stop()
{
}

/*
 * Tag handlers
 */

string sqlreport_tag (string tag_name, mapping args,
                    object request_id, mapping defines) 
{
string contents="";
  if(args->help) return register_module()[2]; // FIXME

  if (args->query) {

    if (args->parse) {
      args->query = parse_rxml(args->query, request_id);
    }

    string host = request_id->conf->modules->sqltag->enabled->query("hostname");
#ifdef SQL_TAG_COMPAT
    string database = request_id->conf->modules->sqltag->enabled->query("database");
    string user = request_id->conf->modules->sqltag->enabled->query("user");
    string password =  request_id->conf->modules->sqltag->enabled->query("password");
#else /* SQL_TAG_COMPAT */
    string database, user, password;
#endif /* SQL_TAG_COMPAT */
    object(sql) con;
    array(mapping(string:mixed)) result;
perror(sprintf("%O",mkmapping(values(request_id->conf),indices(request_id->conf))));
    mixed sql_connect = request_id->conf->sql_connect;
    mixed error;

    if (args->host) {
      host = args->host;
      user = "";
      password = "";
    }
    if (args->database) {
      database = args->database;
      user = "";
      password = "";
      sql_connect = 0;
    }
    if (args->user) {
      user = args->user;
      sql_connect = 0;
    }
    if (args->password) {
      password = args->password;
      sql_connect = 0;
    }
    if (sql_connect) {
      error = catch(con = sql_connect(host));
    } else {
      host = (lower_case(host) == "localhost")?"":host;
      error = catch(con = sql(host, database, user, password));
    }
    if (error) {
      if (!args->quiet) {
	contents = "<h1>Couldn't connect to SQL-server</h1><br>\n" +
	  ((master()->describe_backtrace(error)/"\n")*"<br>\n" + "<false>");
      } else {
	contents = "<false>";
      }
    } else if (error = catch(result = con->query(args->query))) {
      if (!args->quiet) {
	contents = "<h1>Query \"" + args->query + "\" failed: " +
	  con->error() + "</h1>\n" +
	  ((master()->describe_backtrace(error)/"\n")*"<br>\n" + "<false>");
      } else {
	contents = "<false>";
      }
    } else if (result && sizeof(result))
    {

 for(int i=0; i<sizeof(result);i++){	// Do a report for each record.

  contents+="<TABLE>\n";
  string t;
  sscanf(parse_rxml(args->query, request_id),"%*s FROM %[^ ]",t);
  array(mapping(string:mixed)) fields=con->list_fields(t);
  for(int j=0; j<sizeof(fields);j++){     // Generate report from schema

        contents+="<TR>\n"
        "<TD VALIGN=TOP ALIGN=RIGHT><FONT FACE=helvetica,arial SIZE=-1>\n"
        +replace(fields[j]->name,"_"," ")+
        "</FONT> &nbsp; </TD>\n"
        "<TD><FONT COLOR=\"Maroon\">\n"
        +(string)(result[i][fields[j]->name])+
        "\n</TD>\n</TR>\n";

	}

  contents+="</table><true>\n\n";

    } 
  }
}
  return(contents);
}

mapping query_tag_callers()
{
  return( ([ "sqlreport":sqlreport_tag,
	     "sqlform":sqlform_tag ]) );
}

mapping query_container_callers()
{
  return( ([]) );
}

