string cvs_version = "$Id: Layout.pike,v 1.1 1997/10/9 06:49:16 Allen_Bolderoff Exp $";

#include <module.h>
inherit "module";
inherit "roxenlib";
#include <stdio.h>
#include <array.h>
#include <simulate.h>

string myfilename = "";
string basedir = "";


mixed register_module()
{
  return ({ 
	MODULE_FILTER,
	"basic layout",
	("Basic Layout Module."
			"<p>This module creates a Modifiable Layout"
			"<br> Loosely based on Perspathway module"
			"Needs a .pathways style file<BR>\n"),
	({}), 1, });
}


void create()
{
        defvar("pathwaysfile", "/.pathways", "Locateion - .pathways File", 
		TYPE_STRING,
                "Where does the .pathways file live (virtual server path).");
        defvar("defaultnfont", "template_gothic", "Font", TYPE_STRING,
                "Default Font for GTEXT Tags.");
        defvar("layoutbodytag", 
	"<body link=blue alink=gold vlink=red bgcolor=white text=black>", 
		"Body Tag for whole page ", TYPE_STRING,
                "Must include:<br>"
		"<blockquote>bgcolor,alink,text,vlink,link</blockquote><br>");
        defvar("ttc", "Maroon", "Text Color - Top Text", TYPE_STRING,
                "What is the default color for the Top text?");
        defvar("lhtc", "Maroon", "Text Color - Left Hand Text", TYPE_STRING,
                "What is the default color for the LHS text?");
        defvar("counterfont", "katt000", "Counter Style", TYPE_STRING,
                "Default Counter Style.");
        defvar("backgroundforleft", "/images/reachbg.gif", 
		"Image - background - LHS", TYPE_STRING,
                "What back Ground do you want on the left of the screen.");
        defvar("midcolor", "White", "Color - For main frame", TYPE_STRING,
                "What color do you want the main display to have?.");
        defvar("mainlogo", "/images/logo.gif", "Image - Main Logo TLHS", 
		TYPE_STRING,
                "What Logo do you want on top of page??.");
        defvar("topbutton", 
		"<gtext 5 nfont=zapf_dingbats>l</gtext>", 
		"Button - Top Level", TYPE_STRING,
                "What code do you want for top level button?"
                "<blockquote>include full tag here.");
        defvar("topbuttoncolor", 
		"Red", 
		"Button - Top Level Color", TYPE_STRING,
                "What code do you want for 2nd level button?"
                "<blockquote>include full tag here.");
        defvar("botbutton", 
		"<gtext 4 nfont=zapf_dingbats>l</gtext>", 
		"Button - 2nd Level", TYPE_STRING,
                "What code do you want for 2nd level button?.");
        defvar("botbuttoncolor", 
		"Red", 
		"Button - 2nd Level Color", TYPE_STRING,
                "What color do you want for 2nd level button?.");
        defvar("leftbutton", 
		"<gtext 3 nfont=zapf_dingbats>l</gtext>", 
		"Button - Left", TYPE_STRING,
                "What code do you want for Left button?.");
        defvar("leftbuttoncolor", 
		"Red", 
		"Button - Left - Color", TYPE_STRING,
                "What color do you want for 2nd level button?.");
        defvar("mainlogowidth", "100", "Main Logo width", TYPE_STRING,
                "How wide do you want the log on the page??.");
        defvar("lhtis", "http://www.lysator.liu.se/~cardeci/arch.pike", 
		"Image - Top Left", TYPE_STRING,
                "What image do you want at LH top?."
                "can be either http://xxx/image.gif or"
		"a local link ie /images/top.gif");
        defvar("rhbis", "http://www.lysator.liu.se/~cardeci/arch.pike?reverse", 
		"Image - Bottom Right", TYPE_STRING,
		"What image do you want on Bottom Right corner?"
                "can be either http://xxx/image.gif or"
		"a local link ie /images/top.gif");
}



array pathways, left;


void fix_pathways(object id)
{
  string s = id->conf->try_get_file(query("pathwaysfile"), id);
  if(!s) error("No "+"pathwaysfile"+" file.\n");

  int depth;
  array current = ({});
  int mode;

  left=({});
  pathways=({});
  foreach(s/"\n", mixed line)
  {
    line = (replace(line,"\t"," ")/" "-({""}));
    if(!mode)
      if(line[0]=="|")
        current[0][2]+=({ ({ replace(line[1],"_"," "), line[2] }) });
      else if(line[0] != "!left") {
        pathways+=current;current=({({replace(line[0],"_"," "),line[1],({})})})
;
      } else
        mode=1;
    else if(sizeof(line)==3)
      left += ({ ({ replace(line[1],"_"," "),line[2] }) });
  }
  pathways+=current;
}

void filter(mapping m, object id)
{
  if(m && !m->pathisdone && (m->type == "text/html") && (m->data))
  {
    if(id->misc->orig) return;
    m->pathisdone=1;
    string to_left="", top="<define name=nfont>"
			   +query("defaultnfont")+"</define>",
           below_top="";
    if(!pathways) fix_pathways(id);
    foreach(pathways, array path)
    {
      if(!search(id->not_query, path[1]))
      {
        top += ("<font color="+query("topbuttoncolor")+">"
                +query("topbutton")+"<gtext 3 magic='"+path[0]+"' "
                +query("topbuttoncolor")+
		" href='"+path[1]+"'>"+path[0]+"</gtext> "
                "&nbsp;\n");
        foreach(path[2], path)
          if(!search(id->not_query, path[1]))
            below_top +=("<font color="+query("topbuttoncolor")+">"
			 +query("topbutton")+
                         "<gtext 4 fg="+query("dfontcol")+
			 " magic='"+path[0]+"' "
                         "href='"+path[1]+"'>"+path[0]+"</gtext> \n");
          else
            below_top +=("<font color="+query("topbuttoncolor")+">"
                         +query("topbutton")+"<gtext 4 fg="+query("ttc")+
			 " magic='"+path[0]+"' "
                         "href='"+path[1]+"'>"+path[0]+"</gtext> \n");
      } else
        top += ("<font color="+query("topbuttoncolor")+">"+query("topbutton")+
                "<gtext 3 fg="+query("ttc")+
		" magic='"+path[0]+"' href='"+path[1]+"'>"+
                path[0]+"</gtext> &nbsp;\n");
    }

    to_left="<br><br><br>";
    foreach(left, array path)
      to_left += ("<font color="+query("leftbuttoncolor")+">"
		+query("leftbutton")+
		"<gtext 4 fg="+query("lhtc")+
                  " magic='"+path[0]+"' href='"+path[1]+"'>"+path[0]
                  +"</gtext></nobr><br>\n");

    string before="", in="";
    if(sscanf(m->data, "\n<title>%s</title>\n%s", before,in)!=2)
    {
      before="";
  in = m->data;
    }
    m->data = parse_rxml("<title>"+before+
                         "</title>"+query("layoutbodytag")+"\n"
                         "<table border=0 cellpadding=2>\n  <tr>\n    "
			 "<TD><a href=/><img src="+query("mainlogo")+" width="
			 +query("mainlogowidth")+" border=0></a></td>"
                         "<td>"+top+"<br>\n"+below_top+
                         "\n  </td></tr>\n  <tr><td valign=top align=left "
			 "background="+query("backgroundforleft")+">"+
                         to_left+"<br><counter style="+query("counterfont")+
			 "></td><td>\n<table bgcolor="+query("midcolor")+
			 " cellpadding=0>\n  <tr><td>"
                         "<img src="+query("lhtis")+" border=0"
                         "<blockquote>"+
                         in+"\n</blockquote></font><img"
			 " src="+query("rhbis")+" align=right hspace=0"
                         " vspace=0 border=0></td></tr>\n</table>\n</td></table>", id);
  }
}

