/* libwpd
 * Copyright (C) 2004 Marc Maurer (uwog@uwog.net)
 * Copyright (C) 2004-2005 Fridrich Strba (fridrich.strba@bluewin.ch)
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef WP3FILESTRUCTURE_H
#define WP3FILESTRUCTURE_H

// size of the fixed length function groups 0xC0 to 0xCF
extern int WP3_FIXED_LENGTH_FUNCTION_GROUP_SIZE[16]; 

/* Main function group list  */

#define WP3_EXTENDED_CHARACTER_GROUP 0xC0
#define WP3_TAB_GROUP 0xC1
#define WP3_INDENT_GROUP 0xC2
#define WP3_ATTRIBUTE_GROUP 0xC3

#define WP3_DOUBLE_BYTE_SCRIPT_CHARACTER_GROUP 0xC8

#define WP3_UNDO_GROUP 0xCD

#define WP3_PAGE_FORMAT_GROUP 0xD0
#define WP3_FONT_GROUP 0xD1
#define WP3_DEFINITION_GROUP 0xD2

#define WP3_HEADER_FOOTER_GROUP 0xD5
#define WP3_FOOTNOTE_ENDNOTE_GROUP 0xD6

#define WP3_DISPLAY_GROUP 0xD8
#define WP3_MISCELLANEOUS_GROUP 0xD9
#define WP3_WINDOW_GROUP 0xDA
#define WP3_STYLE_GROUP 0xDB
#define WP3_END_OF_LINE_PAGE_GROUP 0xDC

#define WP3_TABLES_GROUP 0xE2

/* Tab Group */
#define WP3_TAB_GROUP_TAB 0x00
#define WP3_TAB_GROUP_CENTER 0x01
#define WP3_TAB_GROUP_FLUSH_RIGHT 0x02
#define WP3_TAB_GROUP_BACK_TAB 0x03
#define WP3_TAB_GROUP_CHARACTER_KERNING 0x04
#define WP3_TAB_GROUP_BAR_TAB 0x05
#define WP3_TAB_GROUP_FIXED_TAB 0x06

/* Indent Group */
#define WP3_INDENT_GROUP_LEFT_INDENT 0x00
#define WP3_INDENT_GROUP_LEFT_RIGHT_INDENT 0x01

/* Attribute Group */
#define WP3_ATTRIBUTE_BOLD 0
#define WP3_ATTRIBUTE_ITALICS 1
#define WP3_ATTRIBUTE_UNDERLINE 2
#define WP3_ATTRIBUTE_OUTLINE 3
#define WP3_ATTRIBUTE_SHADOW 4
// 5 to 7 is not documented
#define WP3_ATTRIBUTE_REDLINE 8
#define WP3_ATTRIBUTE_STRIKE_OUT 9
#define WP3_ATTRIBUTE_SUBSCRIPT 10
#define WP3_ATTRIBUTE_SUPERSCRIPT 11
#define WP3_ATTRIBUTE_DOUBLE_UNDERLINE 12
#define WP3_ATTRIBUTE_EXTRA_LARGE 13
#define WP3_ATTRIBUTE_VERY_LARGE 14
#define WP3_ATTRIBUTE_LARGE 15
#define WP3_ATTRIBUTE_SMALL_PRINT 16
#define WP3_ATTRIBUTE_FINE_PRINT 17
#define WP3_ATTRIBUTE_SMALL_CAPS 18

/* Page Format Group */
#define WP3_PAGE_FORMAT_GROUP_HORIZONTAL_MARGINS 0x01
#define WP3_PAGE_FORMAT_GROUP_LINE_SPACING 0x02
#define WP3_PAGE_FORMAT_GROUP_SET_TABS 0x04
#define WP3_PAGE_FORMAT_GROUP_VERTICAL_MARGINS 0x05
#define WP3_PAGE_FORMAT_GROUP_JUSTIFICATION_MODE 0x06
#define WP3_PAGE_FORMAT_GROUP_SUPPRESS_PAGE 0x07
#define WP3_PAGE_FORMAT_GROUP_INDENT_AT_BEGINNING_OF_PARAGRAPH 0x0C

#define WP3_PAGE_GROUP_SUPPRESS_PAGE_NUMBER 0x01
#define WP3_PAGE_GROUP_PAGE_NUMBER_TO_BOTTOM 0x02
#define WP3_PAGE_GROUP_SUPPRESS_HEADER_A 0x04
#define WP3_PAGE_GROUP_SUPPRESS_HEADER_B 0x08
#define WP3_PAGE_GROUP_SUPPRESS_FOOTER_A 0x10
#define WP3_PAGE_GROUP_SUPPRESS_FOOTER_B 0x20
#define WP3_PAGE_GROUP_SUPPRESS_WATERMARK_A 0x40
#define WP3_PAGE_GROUP_SUPPRESS_WATERMARK_B 0x80

/* Font Group */
#define WP3_FONT_GROUP_SET_TEXT_COLOR 0x00
#define WP3_FONT_GROUP_SET_TEXT_FONT 0x01
#define WP3_FONT_GROUP_SET_FONT_SIZE 0x02

/* Definition Group */
#define WP3_DEFINITION_GROUP_SET_COLUMNS 0x01

/* Header Footer Group */
#define WP3_HEADER_FOOTER_GROUP_HEADER_A 0x00
#define WP3_HEADER_FOOTER_GROUP_HEADER_B 0x01
#define WP3_HEADER_FOOTER_GROUP_FOOTER_A 0x02
#define WP3_HEADER_FOOTER_GROUP_FOOTER_B 0x03
#define WP3_HEADER_FOOTER_GROUP_WATERMARK_A 0x04
#define WP3_HEADER_FOOTER_GROUP_WATERMARK_B 0x05

#define WP3_HEADER_FOOTER_GROUP_EVEN_BIT 0x01
#define WP3_HEADER_FOOTER_GROUP_ODD_BIT 0x02

/* Footnote/Endnote Group */
#define WP3_FOOTNOTE_ENDNOTE_GROUP_FOOTNOTE_FUNCTION 0x00
#define WP3_FOOTNOTE_ENDNOTE_GROUP_ENDNOTE_FUNCTION 0x01

/* Display Group */
#define WP3_DISPLAY_GROUP_INSERT_DATE_TIME 0x00
#define WP3_DISPLAY_GROUP_INSERT_PARAGRAPH_NUMBER 0x01
#define WP3_DISPLAY_GROUP_OVERSTRIKE_TEXT 0x02
#define WP3_DISPLAY_GROUP_SEARCH_CHARACTER 0x03
#define WP3_DISPLAY_GROUP_INSERT_BOX_NUMBER 0x04
#define WP3_DISPLAY_GROUP_INSERT_CHAPTER_NUMBER 0x05
#define WP3_DISPLAY_GROUP_INSERT_PAGE_NUMBER 0x06
#define WP3_DISPLAY_GROUP_INSERT_FOOTNOTE_NUMBER 0x07
#define WP3_DISPLAY_GROUP_INSERT_ENDNOTE_NUMBER 0x08

/* Miscellaneous Group */

#define WP3_MISCELLANEOUS_GROUP_PAGE_SIZE_OVERRIDE 0x04

/* Window Group */

#define WP3_WINDOW_GROUP_FIGURE_BOX_FUNCTION 0x00
#define WP3_WINDOW_GROUP_TABLE_BOX_FUNCTION 0x01
#define WP3_WINDOW_GROUP_TEXT_BOX_FUNCTION 0x02
#define WP3_WINDOW_GROUP_USER_BOX_FUNCTION 0x03
#define WP3_WINDOW_GROUP_EQUATION_BOX_FUNCTION 0x04
#define WP3_WINDOW_GROUP_HTML_IMAGE_BOX_FUNCTION 0x05
#define WP3_WINDOW_GROUP_HORIZONTAL_LINE 0x06

/* Tables Group */

#define WP3_TABLES_GROUP_TABLE_FUNCTION 0x01
#define WP3_TABLES_GROUP_SET_TABLE_CELL_SPAN 0x02
#define WP3_TABLES_GROUP_SET_TABLE_CELL_TOP_LINE 0x03
#define WP3_TABLES_GROUP_SET_TABLE_CELL_LEFT_LINE 0x04
#define WP3_TABLES_GROUP_SET_TABLE_CELL_BOTTOM_LINE 0x05
#define WP3_TABLES_GROUP_SET_TABLE_CELL_RIGHT_LINE 0x06
#define WP3_TABLES_GROUP_SET_TABLE_CELL_TOP_LINE_COLOR 0x07
#define WP3_TABLES_GROUP_SET_TABLE_CELL_LEFT_LINE_COLOR 0x08
#define WP3_TABLES_GROUP_SET_TABLE_CELL_BOTTOM_LINE_COLOR 0x09
#define WP3_TABLES_GROUP_SET_TABLE_CELL_RIGHT_LINE_COLOR 0x0A
#define WP3_TABLES_GROUP_SET_TABLE_CELL_FILL_COLOR_PATTERN 0x0B
#define WP3_TABLES_GROUP_SET_TABLE_CELL_VERTICAL_ALIGNMENT 0x0C
#define WP3_TABLES_GROUP_SET_TABLE_CELL_MODE 0x0D
#define WP3_TABLES_GROUP_SET_TABLE_ROW_MODE 0x0E

/* Column Types */

#define WP3_COLUMN_TYPE_COLLUMNS_OFF 0x01
#define WP3_COLUMN_TYPE_NEWSPAPER 0x01
#define WP3_COLUMN_TYPE_PARALLEL 0x02
#define WP3_COLUMN_TYPE_EXTENDED 0x03

#endif /* WP3FILESTRUCTURE_H */
