#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright 2010 Zuza Software Foundation
#
# This file is part of the Translate Toolkit.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see <http://www.gnu.org/licenses/>.

"""Serves as single import for all project-related classes."""

from project import Project, split_extensions
from projstore import ProjectStore, FileExistsInProjectError, FileNotInProjectError
from bundleprojstore import BundleProjectStore, InvalidBundleError

__all__ = [
    # Classes
    'Project', 'ProjectStore', 'BundleProjectStore',
    # Exceptions
    'FileExistsInProjectError', 'FileNotInProjectError', 'InvalidBundleError',
    # Functions
    'split_extensions',
]
