//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qwebframe_c.h"

QWebHitTestResultH QWebHitTestResult_create()
{
	return (QWebHitTestResultH) new QWebHitTestResult();
}

void QWebHitTestResult_destroy(QWebHitTestResultH handle)
{
	delete (QWebHitTestResult *)handle;
}

QWebHitTestResultH QWebHitTestResult_create2(const QWebHitTestResultH other)
{
	return (QWebHitTestResultH) new QWebHitTestResult(*(const QWebHitTestResult*)other);
}

bool QWebHitTestResult_isNull(QWebHitTestResultH handle)
{
	return (bool) ((QWebHitTestResult *)handle)->isNull();
}

void QWebHitTestResult_pos(QWebHitTestResultH handle, PQtPoint retval)
{
	*(QPoint *)retval = ((QWebHitTestResult *)handle)->pos();
}

void QWebHitTestResult_boundingRect(QWebHitTestResultH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QWebHitTestResult *)handle)->boundingRect();
	copyQRectToPRect(t_retval, retval);
}

void QWebHitTestResult_title(QWebHitTestResultH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebHitTestResult *)handle)->title();
	copyQStringToPWideString(t_retval, retval);
}

void QWebHitTestResult_linkText(QWebHitTestResultH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebHitTestResult *)handle)->linkText();
	copyQStringToPWideString(t_retval, retval);
}

void QWebHitTestResult_linkUrl(QWebHitTestResultH handle, QUrlH retval)
{
	*(QUrl *)retval = ((QWebHitTestResult *)handle)->linkUrl();
}

void QWebHitTestResult_linkTitle(QWebHitTestResultH handle, QUrlH retval)
{
	*(QUrl *)retval = ((QWebHitTestResult *)handle)->linkTitle();
}

QWebFrameH QWebHitTestResult_linkTargetFrame(QWebHitTestResultH handle)
{
	return (QWebFrameH) ((QWebHitTestResult *)handle)->linkTargetFrame();
}

void QWebHitTestResult_alternateText(QWebHitTestResultH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebHitTestResult *)handle)->alternateText();
	copyQStringToPWideString(t_retval, retval);
}

void QWebHitTestResult_imageUrl(QWebHitTestResultH handle, QUrlH retval)
{
	*(QUrl *)retval = ((QWebHitTestResult *)handle)->imageUrl();
}

void QWebHitTestResult_pixmap(QWebHitTestResultH handle, QPixmapH retval)
{
	*(QPixmap *)retval = ((QWebHitTestResult *)handle)->pixmap();
}

bool QWebHitTestResult_isContentEditable(QWebHitTestResultH handle)
{
	return (bool) ((QWebHitTestResult *)handle)->isContentEditable();
}

bool QWebHitTestResult_isContentSelected(QWebHitTestResultH handle)
{
	return (bool) ((QWebHitTestResult *)handle)->isContentSelected();
}

QWebFrameH QWebHitTestResult_frame(QWebHitTestResultH handle)
{
	return (QWebFrameH) ((QWebHitTestResult *)handle)->frame();
}

QWebPageH QWebFrame_page(QWebFrameH handle)
{
	return (QWebPageH) ((QWebFrame *)handle)->page();
}

void QWebFrame_load(QWebFrameH handle, const QUrlH url)
{
	((QWebFrame *)handle)->load(*(const QUrl*)url);
}

void QWebFrame_load2(QWebFrameH handle, const QNetworkRequestH request, QNetworkAccessManager::Operation operation, const QByteArrayH body)
{
	((QWebFrame *)handle)->load(*(const QNetworkRequest*)request, operation, *(const QByteArray*)body);
}

void QWebFrame_setHtml(QWebFrameH handle, PWideString html, const QUrlH baseUrl)
{
	QString t_html;
	copyPWideStringToQString(html, t_html);
	((QWebFrame *)handle)->setHtml(t_html, *(const QUrl*)baseUrl);
}

void QWebFrame_setContent(QWebFrameH handle, const QByteArrayH data, PWideString mimeType, const QUrlH baseUrl)
{
	QString t_mimeType;
	copyPWideStringToQString(mimeType, t_mimeType);
	((QWebFrame *)handle)->setContent(*(const QByteArray*)data, t_mimeType, *(const QUrl*)baseUrl);
}

void QWebFrame_addToJavaScriptWindowObject(QWebFrameH handle, PWideString name, QObjectH object)
{
	QString t_name;
	copyPWideStringToQString(name, t_name);
	((QWebFrame *)handle)->addToJavaScriptWindowObject(t_name, (QObject*)object);
}

void QWebFrame_toHtml(QWebFrameH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebFrame *)handle)->toHtml();
	copyQStringToPWideString(t_retval, retval);
}

void QWebFrame_toPlainText(QWebFrameH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebFrame *)handle)->toPlainText();
	copyQStringToPWideString(t_retval, retval);
}

void QWebFrame_renderTreeDump(QWebFrameH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebFrame *)handle)->renderTreeDump();
	copyQStringToPWideString(t_retval, retval);
}

void QWebFrame_title(QWebFrameH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebFrame *)handle)->title();
	copyQStringToPWideString(t_retval, retval);
}

void QWebFrame_setUrl(QWebFrameH handle, const QUrlH url)
{
	((QWebFrame *)handle)->setUrl(*(const QUrl*)url);
}

void QWebFrame_url(QWebFrameH handle, QUrlH retval)
{
	*(QUrl *)retval = ((QWebFrame *)handle)->url();
}

void QWebFrame_icon(QWebFrameH handle, QIconH retval)
{
	*(QIcon *)retval = ((QWebFrame *)handle)->icon();
}

void QWebFrame_frameName(QWebFrameH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QWebFrame *)handle)->frameName();
	copyQStringToPWideString(t_retval, retval);
}

QWebFrameH QWebFrame_parentFrame(QWebFrameH handle)
{
	return (QWebFrameH) ((QWebFrame *)handle)->parentFrame();
}

void QWebFrame_childFrames(QWebFrameH handle, PPtrIntArray retval)
{
	QList<QWebFrame*> t_retval;
	t_retval = ((QWebFrame *)handle)->childFrames();
	copyQListTemplateToPtrIntArray(t_retval, retval);
}

Qt::ScrollBarPolicy QWebFrame_scrollBarPolicy(QWebFrameH handle, Qt::Orientation orientation)
{
	return (Qt::ScrollBarPolicy) ((QWebFrame *)handle)->scrollBarPolicy(orientation);
}

void QWebFrame_setScrollBarPolicy(QWebFrameH handle, Qt::Orientation orientation, Qt::ScrollBarPolicy policy)
{
	((QWebFrame *)handle)->setScrollBarPolicy(orientation, policy);
}

void QWebFrame_setScrollBarValue(QWebFrameH handle, Qt::Orientation orientation, int value)
{
	((QWebFrame *)handle)->setScrollBarValue(orientation, value);
}

int QWebFrame_scrollBarValue(QWebFrameH handle, Qt::Orientation orientation)
{
	return (int) ((QWebFrame *)handle)->scrollBarValue(orientation);
}

int QWebFrame_scrollBarMinimum(QWebFrameH handle, Qt::Orientation orientation)
{
	return (int) ((QWebFrame *)handle)->scrollBarMinimum(orientation);
}

int QWebFrame_scrollBarMaximum(QWebFrameH handle, Qt::Orientation orientation)
{
	return (int) ((QWebFrame *)handle)->scrollBarMaximum(orientation);
}

void QWebFrame_scroll(QWebFrameH handle, int p1, int p2)
{
	((QWebFrame *)handle)->scroll(p1, p2);
}

void QWebFrame_scrollPosition(QWebFrameH handle, PQtPoint retval)
{
	*(QPoint *)retval = ((QWebFrame *)handle)->scrollPosition();
}

void QWebFrame_setScrollPosition(QWebFrameH handle, const QPointH pos)
{
	((QWebFrame *)handle)->setScrollPosition(*(const QPoint*)pos);
}

void QWebFrame_render(QWebFrameH handle, QPainterH painter, const QRegionH clip)
{
	((QWebFrame *)handle)->render((QPainter*)painter, *(const QRegion*)clip);
}

void QWebFrame_render2(QWebFrameH handle, QPainterH painter)
{
	((QWebFrame *)handle)->render((QPainter*)painter);
}

void QWebFrame_setTextSizeMultiplier(QWebFrameH handle, qreal factor)
{
	((QWebFrame *)handle)->setTextSizeMultiplier(factor);
}

qreal QWebFrame_textSizeMultiplier(QWebFrameH handle)
{
	return (qreal) ((QWebFrame *)handle)->textSizeMultiplier();
}

qreal QWebFrame_zoomFactor(QWebFrameH handle)
{
	return (qreal) ((QWebFrame *)handle)->zoomFactor();
}

void QWebFrame_setZoomFactor(QWebFrameH handle, qreal factor)
{
	((QWebFrame *)handle)->setZoomFactor(factor);
}

void QWebFrame_pos(QWebFrameH handle, PQtPoint retval)
{
	*(QPoint *)retval = ((QWebFrame *)handle)->pos();
}

void QWebFrame_geometry(QWebFrameH handle, PRect retval)
{
	QRect t_retval;
	t_retval = ((QWebFrame *)handle)->geometry();
	copyQRectToPRect(t_retval, retval);
}

void QWebFrame_contentsSize(QWebFrameH handle, PSize retval)
{
	*(QSize *)retval = ((QWebFrame *)handle)->contentsSize();
}

void QWebFrame_hitTestContent(QWebFrameH handle, QWebHitTestResultH retval, const QPointH pos)
{
	*(QWebHitTestResult *)retval = ((QWebFrame *)handle)->hitTestContent(*(const QPoint*)pos);
}

bool QWebFrame_event(QWebFrameH handle, QEventH p1)
{
	return (bool) ((QWebFrame *)handle)->event((QEvent*)p1);
}

void QWebFrame_evaluateJavaScript(QWebFrameH handle, QVariantH retval, PWideString scriptSource)
{
	QString t_scriptSource;
	copyPWideStringToQString(scriptSource, t_scriptSource);
	*(QVariant *)retval = ((QWebFrame *)handle)->evaluateJavaScript(t_scriptSource);
}

void QWebFrame_print(QWebFrameH handle, QPrinterH printer)
{
	((QWebFrame *)handle)->print((QPrinter*)printer);
}

