//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qthread_c.h"

Qt::HANDLE QThread_currentThreadId()
{
	return (Qt::HANDLE) QThread::currentThreadId();
}

QThreadH QThread_currentThread()
{
	return (QThreadH) QThread::currentThread();
}

int QThread_idealThreadCount()
{
	return (int) QThread::idealThreadCount();
}

void QThread_yieldCurrentThread()
{
	QThread::yieldCurrentThread();
}

QThreadH QThread_create(QObjectH parent)
{
	return (QThreadH) new QThread((QObject*)parent);
}

void QThread_destroy(QThreadH handle)
{
	delete (QThread *)handle;
}

void QThread_setPriority(QThreadH handle, QThread::Priority priority)
{
	((QThread *)handle)->setPriority(priority);
}

QThread::Priority QThread_priority(QThreadH handle)
{
	return (QThread::Priority) ((QThread *)handle)->priority();
}

bool QThread_isFinished(QThreadH handle)
{
	return (bool) ((QThread *)handle)->isFinished();
}

bool QThread_isRunning(QThreadH handle)
{
	return (bool) ((QThread *)handle)->isRunning();
}

void QThread_setStackSize(QThreadH handle, uint stackSize)
{
	((QThread *)handle)->setStackSize(stackSize);
}

uint QThread_stackSize(QThreadH handle)
{
	return (uint) ((QThread *)handle)->stackSize();
}

void QThread_exit(QThreadH handle, int retcode)
{
	((QThread *)handle)->exit(retcode);
}

void QThread_start(QThreadH handle, QThread::Priority p1)
{
	((QThread *)handle)->start(p1);
}

void QThread_terminate(QThreadH handle)
{
	((QThread *)handle)->terminate();
}

void QThread_quit(QThreadH handle)
{
	((QThread *)handle)->quit();
}

bool QThread_wait(QThreadH handle, unsigned long time)
{
	return (bool) ((QThread *)handle)->wait(time);
}

