//******************************************************************************
//  Copyright (c) 2005-2011 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QSTRING_C_H
#define QSTRING_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QStringH QString_create();
C_EXPORT void QString_destroy(QStringH handle);
C_EXPORT QStringH QString_create2(const QCharH unicode, int size);
C_EXPORT QStringH QString_create3(PWideChar c);
C_EXPORT QStringH QString_create5(const QLatin1StringH latin1);
C_EXPORT QStringH QString_create6(PWideString p1);
C_EXPORT int QString_size(QStringH handle);
C_EXPORT int QString_count(QStringH handle);
C_EXPORT int QString_length(QStringH handle);
C_EXPORT bool QString_isEmpty(QStringH handle);
C_EXPORT void QString_resize(QStringH handle, int size);
C_EXPORT void QString_fill(QStringH handle, PWideString retval, PWideChar c, int size);
C_EXPORT void QString_truncate(QStringH handle, int pos);
C_EXPORT void QString_chop(QStringH handle, int n);
C_EXPORT int QString_capacity(QStringH handle);
C_EXPORT void QString_reserve(QStringH handle, int size);
C_EXPORT void QString_squeeze(QStringH handle);
C_EXPORT const QCharH QString_unicode(QStringH handle);
C_EXPORT QCharH QString_data(QStringH handle);
C_EXPORT const QCharH QString_constData(QStringH handle);
C_EXPORT void QString_detach(QStringH handle);
C_EXPORT bool QString_isDetached(QStringH handle);
C_EXPORT void QString_clear(QStringH handle);
C_EXPORT void QString_at(QStringH handle, PWideChar retval, int i);
C_EXPORT void QString_arg(QStringH handle, PWideString retval, qlonglong a, int fieldwidth, int base, const QCharH fillChar);
C_EXPORT void QString_arg2(QStringH handle, PWideString retval, qulonglong a, int fieldwidth, int base, const QCharH fillChar);
C_EXPORT void QString_arg4(QStringH handle, PWideString retval, ulong a, int fieldwidth, int base, const QCharH fillChar);
C_EXPORT void QString_arg7(QStringH handle, PWideString retval, short a, int fieldWidth, int base, const QCharH fillChar);
C_EXPORT void QString_arg8(QStringH handle, PWideString retval, ushort a, int fieldWidth, int base, const QCharH fillChar);
C_EXPORT void QString_arg9(QStringH handle, PWideString retval, double a, int fieldWidth, char fmt, int prec, const QCharH fillChar);
C_EXPORT void QString_arg10(QStringH handle, PWideString retval, char a, int fieldWidth, const QCharH fillChar);
C_EXPORT void QString_arg11(QStringH handle, PWideString retval, PWideChar a, int fieldWidth, const QCharH fillChar);
C_EXPORT void QString_arg12(QStringH handle, PWideString retval, PWideString a, int fieldWidth, const QCharH fillChar);
C_EXPORT void QString_arg13(QStringH handle, PWideString retval, PWideString a1, PWideString a2);
C_EXPORT void QString_arg14(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3);
C_EXPORT void QString_arg15(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4);
C_EXPORT void QString_arg16(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4, PWideString a5);
C_EXPORT void QString_arg17(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4, PWideString a5, PWideString a6);
C_EXPORT void QString_arg18(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4, PWideString a5, PWideString a6, PWideString a7);
C_EXPORT void QString_arg19(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4, PWideString a5, PWideString a6, PWideString a7, PWideString a8);
C_EXPORT void QString_arg20(QStringH handle, PWideString retval, PWideString a1, PWideString a2, PWideString a3, PWideString a4, PWideString a5, PWideString a6, PWideString a7, PWideString a8, PWideString a9);
C_EXPORT int QString_indexOf(QStringH handle, PWideChar c, int from, Qt::CaseSensitivity cs);
C_EXPORT int QString_indexOf2(QStringH handle, PWideString s, int from, Qt::CaseSensitivity cs);
C_EXPORT int QString_indexOf3(QStringH handle, const QLatin1StringH s, int from, Qt::CaseSensitivity cs);
C_EXPORT int QString_lastIndexOf(QStringH handle, PWideChar c, int from, Qt::CaseSensitivity cs);
C_EXPORT int QString_lastIndexOf2(QStringH handle, PWideString s, int from, Qt::CaseSensitivity cs);
C_EXPORT int QString_lastIndexOf3(QStringH handle, const QLatin1StringH s, int from, Qt::CaseSensitivity cs);
C_EXPORT QBool QString_contains(QStringH handle, PWideChar c, Qt::CaseSensitivity cs);
C_EXPORT QBool QString_contains2(QStringH handle, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT int QString_count2(QStringH handle, PWideChar c, Qt::CaseSensitivity cs);
C_EXPORT int QString_count3(QStringH handle, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT int QString_indexOf4(QStringH handle, const QRegExpH p1, int from);
C_EXPORT int QString_lastIndexOf4(QStringH handle, const QRegExpH p1, int from);
C_EXPORT QBool QString_contains3(QStringH handle, const QRegExpH rx);
C_EXPORT int QString_count4(QStringH handle, const QRegExpH p1);
C_EXPORT void QString_section(QStringH handle, PWideString retval, PWideChar sep, int start, int end, unsigned int flags);
C_EXPORT void QString_section2(QStringH handle, PWideString retval, PWideString in_sep, int start, int end, unsigned int flags);
C_EXPORT void QString_section3(QStringH handle, PWideString retval, const QRegExpH reg, int start, int end, unsigned int flags);
C_EXPORT void QString_left(QStringH handle, PWideString retval, int n);
C_EXPORT void QString_right(QStringH handle, PWideString retval, int n);
C_EXPORT void QString_mid(QStringH handle, PWideString retval, int position, int n);
C_EXPORT bool QString_startsWith(QStringH handle, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT bool QString_startsWith2(QStringH handle, const QLatin1StringH s, Qt::CaseSensitivity cs);
C_EXPORT bool QString_startsWith3(QStringH handle, const QCharH c, Qt::CaseSensitivity cs);
C_EXPORT bool QString_endsWith(QStringH handle, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT bool QString_endsWith2(QStringH handle, const QLatin1StringH s, Qt::CaseSensitivity cs);
C_EXPORT bool QString_endsWith3(QStringH handle, const QCharH c, Qt::CaseSensitivity cs);
C_EXPORT void QString_leftJustified(QStringH handle, PWideString retval, int width, PWideChar fill, bool trunc);
C_EXPORT void QString_rightJustified(QStringH handle, PWideString retval, int width, PWideChar fill, bool trunc);
C_EXPORT void QString_toLower(QStringH handle, PWideString retval);
C_EXPORT void QString_toUpper(QStringH handle, PWideString retval);
C_EXPORT void QString_toCaseFolded(QStringH handle, PWideString retval);
C_EXPORT void QString_trimmed(QStringH handle, PWideString retval);
C_EXPORT void QString_simplified(QStringH handle, PWideString retval);
C_EXPORT void QString_insert(QStringH handle, PWideString retval, int i, PWideChar c);
C_EXPORT void QString_insert2(QStringH handle, PWideString retval, int i, const QCharH uc, int len);
C_EXPORT void QString_insert3(QStringH handle, PWideString retval, int i, PWideString s);
C_EXPORT void QString_insert4(QStringH handle, PWideString retval, int i, const QLatin1StringH s);
C_EXPORT void QString_append(QStringH handle, PWideString retval, PWideChar c);
C_EXPORT void QString_append2(QStringH handle, PWideString retval, PWideString s);
C_EXPORT void QString_append3(QStringH handle, PWideString retval, const QLatin1StringH s);
C_EXPORT void QString_prepend(QStringH handle, PWideString retval, PWideChar c);
C_EXPORT void QString_prepend2(QStringH handle, PWideString retval, PWideString s);
C_EXPORT void QString_prepend3(QStringH handle, PWideString retval, const QLatin1StringH s);
C_EXPORT void QString_remove(QStringH handle, PWideString retval, int i, int len);
C_EXPORT void QString_remove2(QStringH handle, PWideString retval, PWideChar c, Qt::CaseSensitivity cs);
C_EXPORT void QString_remove3(QStringH handle, PWideString retval, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace(QStringH handle, PWideString retval, int i, int len, PWideChar after);
C_EXPORT void QString_replace2(QStringH handle, PWideString retval, int i, int len, const QCharH s, int slen);
C_EXPORT void QString_replace3(QStringH handle, PWideString retval, int i, int len, PWideString after);
C_EXPORT void QString_replace4(QStringH handle, PWideString retval, PWideChar before, PWideChar after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace5(QStringH handle, PWideString retval, const QCharH before, int blen, const QCharH after, int alen, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace6(QStringH handle, PWideString retval, const QLatin1StringH before, const QLatin1StringH after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace7(QStringH handle, PWideString retval, const QLatin1StringH before, PWideString after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace8(QStringH handle, PWideString retval, PWideString before, const QLatin1StringH after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace9(QStringH handle, PWideString retval, PWideString before, PWideString after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace10(QStringH handle, PWideString retval, PWideChar c, PWideString after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace11(QStringH handle, PWideString retval, PWideChar c, const QLatin1StringH after, Qt::CaseSensitivity cs);
C_EXPORT void QString_replace12(QStringH handle, PWideString retval, const QRegExpH rx, PWideString after);
C_EXPORT void QString_remove4(QStringH handle, PWideString retval, const QRegExpH rx);
C_EXPORT void QString_split(QStringH handle, QStringListH retval, PWideString sep, QString::SplitBehavior behavior, Qt::CaseSensitivity cs);
C_EXPORT void QString_split2(QStringH handle, QStringListH retval, const QCharH sep, QString::SplitBehavior behavior, Qt::CaseSensitivity cs);
C_EXPORT void QString_split3(QStringH handle, QStringListH retval, const QRegExpH sep, QString::SplitBehavior behavior);
C_EXPORT void QString_normalized(QStringH handle, PWideString retval, QString::NormalizationForm mode);
C_EXPORT void QString_normalized2(QStringH handle, PWideString retval, QString::NormalizationForm mode, QChar::UnicodeVersion version);
C_EXPORT void QString_repeated(QStringH handle, PWideString retval, int times);
C_EXPORT const ushort* QString_utf16(QStringH handle);
C_EXPORT void QString_toAscii(QStringH handle, QByteArrayH retval);
C_EXPORT void QString_toLatin1(QStringH handle, QByteArrayH retval);
C_EXPORT void QString_toUtf8(QStringH handle, QByteArrayH retval);
C_EXPORT void QString_toLocal8Bit(QStringH handle, QByteArrayH retval);
C_EXPORT void QString_fromAscii(PWideString retval, const char* p1, int size);
C_EXPORT void QString_fromLatin1(PWideString retval, const char* p1, int size);
C_EXPORT void QString_fromUtf8(PWideString retval, const char* p1, int size);
C_EXPORT void QString_fromLocal8Bit(PWideString retval, const char* p1, int size);
C_EXPORT void QString_fromUtf16(PWideString retval, const ushort* p1, int size);
C_EXPORT void QString_fromUcs4(PWideString retval, const uint* p1, int size);
C_EXPORT void QString_fromRawData(PWideString retval, const QCharH p1, int size);
C_EXPORT int QString_toWCharArray(QStringH handle, wchar_t* array);
C_EXPORT void QString_fromWCharArray(PWideString retval, const wchar_t* p1, int size);
C_EXPORT void QString_setUnicode(QStringH handle, PWideString retval, const QCharH unicode, int size);
C_EXPORT void QString_setUtf16(QStringH handle, PWideString retval, const ushort* utf16, int size);
C_EXPORT int QString_compare(QStringH handle, PWideString s);
C_EXPORT int QString_compare2(QStringH handle, PWideString s, Qt::CaseSensitivity cs);
C_EXPORT int QString_compare3(QStringH handle, const QLatin1StringH other, Qt::CaseSensitivity cs);
C_EXPORT int QString_compare4(PWideString s1, PWideString s2);
C_EXPORT int QString_compare5(PWideString s1, PWideString s2, Qt::CaseSensitivity cs);
C_EXPORT int QString_compare6(PWideString s1, const QLatin1StringH s2, Qt::CaseSensitivity cs);
C_EXPORT int QString_compare7(const QLatin1StringH s1, PWideString s2, Qt::CaseSensitivity cs);
C_EXPORT int QString_localeAwareCompare(QStringH handle, PWideString s);
C_EXPORT int QString_localeAwareCompare2(PWideString s1, PWideString s2);
C_EXPORT short QString_toShort(QStringH handle, bool* ok, int base);
C_EXPORT ushort QString_toUShort(QStringH handle, bool* ok, int base);
C_EXPORT int QString_toInt(QStringH handle, bool* ok, int base);
C_EXPORT uint QString_toUInt(QStringH handle, bool* ok, int base);
C_EXPORT long QString_toLong(QStringH handle, bool* ok, int base);
C_EXPORT ulong QString_toULong(QStringH handle, bool* ok, int base);
C_EXPORT qlonglong QString_toLongLong(QStringH handle, bool* ok, int base);
C_EXPORT qulonglong QString_toULongLong(QStringH handle, bool* ok, int base);
C_EXPORT float QString_toFloat(QStringH handle, bool* ok);
C_EXPORT double QString_toDouble(QStringH handle, bool* ok);
C_EXPORT void QString_setNum(QStringH handle, PWideString retval, short p1, int base);
C_EXPORT void QString_setNum2(QStringH handle, PWideString retval, ushort p1, int base);
C_EXPORT void QString_setNum3(QStringH handle, PWideString retval, int p1, int base);
C_EXPORT void QString_setNum4(QStringH handle, PWideString retval, uint p1, int base);
C_EXPORT void QString_setNum7(QStringH handle, PWideString retval, qlonglong p1, int base);
C_EXPORT void QString_setNum8(QStringH handle, PWideString retval, qulonglong p1, int base);
C_EXPORT void QString_setNum9(QStringH handle, PWideString retval, float p1, char f, int prec);
C_EXPORT void QString_setNum10(QStringH handle, PWideString retval, double p1, char f, int prec);
C_EXPORT void QString_number(PWideString retval, int p1, int base);
C_EXPORT void QString_number2(PWideString retval, uint p1, int base);
C_EXPORT void QString_number5(PWideString retval, qlonglong p1, int base);
C_EXPORT void QString_number6(PWideString retval, qulonglong p1, int base);
C_EXPORT void QString_number7(PWideString retval, double p1, char f, int prec);
C_EXPORT QStringH QString_create7(const char* ch);
C_EXPORT QStringH QString_create8(const QByteArrayH a);
C_EXPORT void QString_prepend4(QStringH handle, PWideString retval, const char* s);
C_EXPORT void QString_prepend5(QStringH handle, PWideString retval, const QByteArrayH s);
C_EXPORT void QString_append4(QStringH handle, PWideString retval, const char* s);
C_EXPORT void QString_append5(QStringH handle, PWideString retval, const QByteArrayH s);
C_EXPORT void QString_push_back(QStringH handle, PWideChar c);
C_EXPORT void QString_push_back2(QStringH handle, PWideString s);
C_EXPORT void QString_push_front(QStringH handle, PWideChar c);
C_EXPORT void QString_push_front2(QStringH handle, PWideString s);
C_EXPORT bool QString_isNull(QStringH handle);
C_EXPORT bool QString_isSimpleText(QStringH handle);
C_EXPORT bool QString_isRightToLeft(QStringH handle);
C_EXPORT QLatin1StringH QLatin1String_create(const char* s);
C_EXPORT void QLatin1String_destroy(QLatin1StringH handle);
C_EXPORT const char* QLatin1String_latin1(QLatin1StringH handle);

#endif
